# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PeeringConnectionAccepterArgs', 'PeeringConnectionAccepter']

@pulumi.input_type
class PeeringConnectionAccepterArgs:
    def __init__(__self__, *,
                 vpc_peering_connection_id: pulumi.Input[_builtins.str],
                 accept: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PeeringConnectionAccepter resource.
        :param pulumi.Input[_builtins.str] vpc_peering_connection_id: The VPC Peering Connection ID to manage. Changing this
               creates a new VPC peering connection accepter.
        :param pulumi.Input[_builtins.bool] accept: Whether or not to accept the peering request. Defaults to `false`.
        :param pulumi.Input[_builtins.str] region: The region in which to create the vpc peering connection accepter. If omitted,
               the provider-level region will be used. Changing this creates a new VPC peering connection accepter resource.
        """
        pulumi.set(__self__, "vpc_peering_connection_id", vpc_peering_connection_id)
        if accept is not None:
            pulumi.set(__self__, "accept", accept)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="vpcPeeringConnectionId")
    def vpc_peering_connection_id(self) -> pulumi.Input[_builtins.str]:
        """
        The VPC Peering Connection ID to manage. Changing this
        creates a new VPC peering connection accepter.
        """
        return pulumi.get(self, "vpc_peering_connection_id")

    @vpc_peering_connection_id.setter
    def vpc_peering_connection_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_peering_connection_id", value)

    @_builtins.property
    @pulumi.getter
    def accept(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to accept the peering request. Defaults to `false`.
        """
        return pulumi.get(self, "accept")

    @accept.setter
    def accept(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "accept", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the vpc peering connection accepter. If omitted,
        the provider-level region will be used. Changing this creates a new VPC peering connection accepter resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _PeeringConnectionAccepterState:
    def __init__(__self__, *,
                 accept: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_peering_connection_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PeeringConnectionAccepter resources.
        :param pulumi.Input[_builtins.bool] accept: Whether or not to accept the peering request. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: The VPC peering connection name.
        :param pulumi.Input[_builtins.str] peer_tenant_id: The Tenant Id of the accepter tenant.
        :param pulumi.Input[_builtins.str] peer_vpc_id: The VPC ID of the accepter tenant.
        :param pulumi.Input[_builtins.str] region: The region in which to create the vpc peering connection accepter. If omitted,
               the provider-level region will be used. Changing this creates a new VPC peering connection accepter resource.
        :param pulumi.Input[_builtins.str] status: The VPC peering connection status.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of requester VPC involved in a VPC peering connection.
        :param pulumi.Input[_builtins.str] vpc_peering_connection_id: The VPC Peering Connection ID to manage. Changing this
               creates a new VPC peering connection accepter.
        """
        if accept is not None:
            pulumi.set(__self__, "accept", accept)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_tenant_id is not None:
            pulumi.set(__self__, "peer_tenant_id", peer_tenant_id)
        if peer_vpc_id is not None:
            pulumi.set(__self__, "peer_vpc_id", peer_vpc_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_peering_connection_id is not None:
            pulumi.set(__self__, "vpc_peering_connection_id", vpc_peering_connection_id)

    @_builtins.property
    @pulumi.getter
    def accept(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to accept the peering request. Defaults to `false`.
        """
        return pulumi.get(self, "accept")

    @accept.setter
    def accept(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "accept", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC peering connection name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="peerTenantId")
    def peer_tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant Id of the accepter tenant.
        """
        return pulumi.get(self, "peer_tenant_id")

    @peer_tenant_id.setter
    def peer_tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="peerVpcId")
    def peer_vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC ID of the accepter tenant.
        """
        return pulumi.get(self, "peer_vpc_id")

    @peer_vpc_id.setter
    def peer_vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_vpc_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the vpc peering connection accepter. If omitted,
        the provider-level region will be used. Changing this creates a new VPC peering connection accepter resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC peering connection status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of requester VPC involved in a VPC peering connection.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcPeeringConnectionId")
    def vpc_peering_connection_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC Peering Connection ID to manage. Changing this
        creates a new VPC peering connection accepter.
        """
        return pulumi.get(self, "vpc_peering_connection_id")

    @vpc_peering_connection_id.setter
    def vpc_peering_connection_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_peering_connection_id", value)


@pulumi.type_token("sbercloud:Vpc/peeringConnectionAccepter:PeeringConnectionAccepter")
class PeeringConnectionAccepter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accept: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_peering_connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a PeeringConnectionAccepter resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] accept: Whether or not to accept the peering request. Defaults to `false`.
        :param pulumi.Input[_builtins.str] region: The region in which to create the vpc peering connection accepter. If omitted,
               the provider-level region will be used. Changing this creates a new VPC peering connection accepter resource.
        :param pulumi.Input[_builtins.str] vpc_peering_connection_id: The VPC Peering Connection ID to manage. Changing this
               creates a new VPC peering connection accepter.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PeeringConnectionAccepterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a PeeringConnectionAccepter resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param PeeringConnectionAccepterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PeeringConnectionAccepterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accept: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_peering_connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PeeringConnectionAccepterArgs.__new__(PeeringConnectionAccepterArgs)

            __props__.__dict__["accept"] = accept
            __props__.__dict__["region"] = region
            if vpc_peering_connection_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_peering_connection_id'")
            __props__.__dict__["vpc_peering_connection_id"] = vpc_peering_connection_id
            __props__.__dict__["description"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["peer_tenant_id"] = None
            __props__.__dict__["peer_vpc_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["vpc_id"] = None
        super(PeeringConnectionAccepter, __self__).__init__(
            'sbercloud:Vpc/peeringConnectionAccepter:PeeringConnectionAccepter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accept: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            peer_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            peer_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_peering_connection_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'PeeringConnectionAccepter':
        """
        Get an existing PeeringConnectionAccepter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] accept: Whether or not to accept the peering request. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: The VPC peering connection name.
        :param pulumi.Input[_builtins.str] peer_tenant_id: The Tenant Id of the accepter tenant.
        :param pulumi.Input[_builtins.str] peer_vpc_id: The VPC ID of the accepter tenant.
        :param pulumi.Input[_builtins.str] region: The region in which to create the vpc peering connection accepter. If omitted,
               the provider-level region will be used. Changing this creates a new VPC peering connection accepter resource.
        :param pulumi.Input[_builtins.str] status: The VPC peering connection status.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of requester VPC involved in a VPC peering connection.
        :param pulumi.Input[_builtins.str] vpc_peering_connection_id: The VPC Peering Connection ID to manage. Changing this
               creates a new VPC peering connection accepter.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PeeringConnectionAccepterState.__new__(_PeeringConnectionAccepterState)

        __props__.__dict__["accept"] = accept
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["peer_tenant_id"] = peer_tenant_id
        __props__.__dict__["peer_vpc_id"] = peer_vpc_id
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vpc_peering_connection_id"] = vpc_peering_connection_id
        return PeeringConnectionAccepter(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def accept(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether or not to accept the peering request. Defaults to `false`.
        """
        return pulumi.get(self, "accept")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The VPC peering connection name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="peerTenantId")
    def peer_tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Tenant Id of the accepter tenant.
        """
        return pulumi.get(self, "peer_tenant_id")

    @_builtins.property
    @pulumi.getter(name="peerVpcId")
    def peer_vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The VPC ID of the accepter tenant.
        """
        return pulumi.get(self, "peer_vpc_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the vpc peering connection accepter. If omitted,
        the provider-level region will be used. Changing this creates a new VPC peering connection accepter resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The VPC peering connection status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of requester VPC involved in a VPC peering connection.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpcPeeringConnectionId")
    def vpc_peering_connection_id(self) -> pulumi.Output[_builtins.str]:
        """
        The VPC Peering Connection ID to manage. Changing this
        creates a new VPC peering connection accepter.
        """
        return pulumi.get(self, "vpc_peering_connection_id")

