# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RouteArgs', 'Route']

@pulumi.input_type
class RouteArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input[_builtins.str],
                 nexthop: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Route resource.
        :param pulumi.Input[_builtins.str] destination: Specifies the destination address in the CIDR notation format,
               for example, 192.168.200.0/24. The destination of each route must be unique and cannot overlap with any
               subnet in the VPC. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] nexthop: Specifies the next hop.
               + If the route type is **ecs**, the value is an ECS instance ID in the VPC.
               + If the route type is **eni**, the value is the extension NIC of an ECS in the VPC.
               + If the route type is **vip**, the value is a virtual IP address.
               + If the route type is **nat**, the value is a VPN gateway ID.
               + If the route type is **peering**, the value is a VPC peering connection ID.
               + If the route type is **vpn**, the value is a VPN gateway ID.
               + If the route type is **dc**, the value is a Direct Connect gateway ID.
               + If the route type is **cc**, the value is a Cloud Connection ID.
        :param pulumi.Input[_builtins.str] type: Specifies the route type. Currently, the value can be:
               **ecs**, **eni**, **vip**, **nat**, **peering**, **vpn**, **dc** and **cc**.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the VPC for which a route is to be added. Changing this creates a
               new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the supplementary information about the route.
               The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[_builtins.str] region: The region in which to create the VPC route. If omitted, the provider-level
               region will be used. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] route_table_id: Specifies the route table ID for which a route is to be added.
               If the value is not set, the route will be added to the *default* route table.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "nexthop", nexthop)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if route_table_id is not None:
            pulumi.set(__self__, "route_table_id", route_table_id)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the destination address in the CIDR notation format,
        for example, 192.168.200.0/24. The destination of each route must be unique and cannot overlap with any
        subnet in the VPC. Changing this creates a new resource.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter
    def nexthop(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the next hop.
        + If the route type is **ecs**, the value is an ECS instance ID in the VPC.
        + If the route type is **eni**, the value is the extension NIC of an ECS in the VPC.
        + If the route type is **vip**, the value is a virtual IP address.
        + If the route type is **nat**, the value is a VPN gateway ID.
        + If the route type is **peering**, the value is a VPC peering connection ID.
        + If the route type is **vpn**, the value is a VPN gateway ID.
        + If the route type is **dc**, the value is a Direct Connect gateway ID.
        + If the route type is **cc**, the value is a Cloud Connection ID.
        """
        return pulumi.get(self, "nexthop")

    @nexthop.setter
    def nexthop(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "nexthop", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the route type. Currently, the value can be:
        **ecs**, **eni**, **vip**, **nat**, **peering**, **vpn**, **dc** and **cc**.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the VPC for which a route is to be added. Changing this creates a
        new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supplementary information about the route.
        The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the VPC route. If omitted, the provider-level
        region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the route table ID for which a route is to be added.
        If the value is not set, the route will be added to the *default* route table.
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_table_id", value)


@pulumi.input_type
class _RouteState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[_builtins.str]] = None,
                 nexthop: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Route resources.
        :param pulumi.Input[_builtins.str] description: Specifies the supplementary information about the route.
               The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[_builtins.str] destination: Specifies the destination address in the CIDR notation format,
               for example, 192.168.200.0/24. The destination of each route must be unique and cannot overlap with any
               subnet in the VPC. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] nexthop: Specifies the next hop.
               + If the route type is **ecs**, the value is an ECS instance ID in the VPC.
               + If the route type is **eni**, the value is the extension NIC of an ECS in the VPC.
               + If the route type is **vip**, the value is a virtual IP address.
               + If the route type is **nat**, the value is a VPN gateway ID.
               + If the route type is **peering**, the value is a VPC peering connection ID.
               + If the route type is **vpn**, the value is a VPN gateway ID.
               + If the route type is **dc**, the value is a Direct Connect gateway ID.
               + If the route type is **cc**, the value is a Cloud Connection ID.
        :param pulumi.Input[_builtins.str] region: The region in which to create the VPC route. If omitted, the provider-level
               region will be used. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] route_table_id: Specifies the route table ID for which a route is to be added.
               If the value is not set, the route will be added to the *default* route table.
        :param pulumi.Input[_builtins.str] route_table_name: The name of route table.
        :param pulumi.Input[_builtins.str] type: Specifies the route type. Currently, the value can be:
               **ecs**, **eni**, **vip**, **nat**, **peering**, **vpn**, **dc** and **cc**.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the VPC for which a route is to be added. Changing this creates a
               new resource.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if nexthop is not None:
            pulumi.set(__self__, "nexthop", nexthop)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if route_table_id is not None:
            pulumi.set(__self__, "route_table_id", route_table_id)
        if route_table_name is not None:
            pulumi.set(__self__, "route_table_name", route_table_name)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supplementary information about the route.
        The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the destination address in the CIDR notation format,
        for example, 192.168.200.0/24. The destination of each route must be unique and cannot overlap with any
        subnet in the VPC. Changing this creates a new resource.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter
    def nexthop(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the next hop.
        + If the route type is **ecs**, the value is an ECS instance ID in the VPC.
        + If the route type is **eni**, the value is the extension NIC of an ECS in the VPC.
        + If the route type is **vip**, the value is a virtual IP address.
        + If the route type is **nat**, the value is a VPN gateway ID.
        + If the route type is **peering**, the value is a VPC peering connection ID.
        + If the route type is **vpn**, the value is a VPN gateway ID.
        + If the route type is **dc**, the value is a Direct Connect gateway ID.
        + If the route type is **cc**, the value is a Cloud Connection ID.
        """
        return pulumi.get(self, "nexthop")

    @nexthop.setter
    def nexthop(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nexthop", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the VPC route. If omitted, the provider-level
        region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the route table ID for which a route is to be added.
        If the value is not set, the route will be added to the *default* route table.
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_table_id", value)

    @_builtins.property
    @pulumi.getter(name="routeTableName")
    def route_table_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of route table.
        """
        return pulumi.get(self, "route_table_name")

    @route_table_name.setter
    def route_table_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_table_name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the route type. Currently, the value can be:
        **ecs**, **eni**, **vip**, **nat**, **peering**, **vpn**, **dc** and **cc**.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the VPC for which a route is to be added. Changing this creates a
        new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("sbercloud:Vpc/route:Route")
class Route(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[_builtins.str]] = None,
                 nexthop: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a VPC route resource within SberCloud.

        ## Example Usage

        ### Add route to the default route table

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        nexthop = config.require_object("nexthop")
        vpc_route = sbercloud.vpc.Route("vpc_route",
            vpc_id=vpc_id,
            destination="192.168.0.0/16",
            type="peering",
            nexthop=nexthop)
        ```

        ### Add route to a custom route table

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud
        import pulumi_sbercloud as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        nexthop = config.require_object("nexthop")
        rtb = sbercloud.Vpc.get_route_table(vpc_id=vpc_id,
            name="demo")
        vpc_route = sbercloud.vpc.Route("vpc_route",
            vpc_id=vpc_id,
            route_table_id=rtb.id,
            destination="172.16.8.0/24",
            type="ecs",
            nexthop=nexthop)
        ```

        ## Import

        VPC routes can be imported using the route table ID and their `destination` separated by a slash, e.g.

        ```sh
        $ pulumi import sbercloud:Vpc/route:Route test <route_table_id>/<destination>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specifies the supplementary information about the route.
               The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[_builtins.str] destination: Specifies the destination address in the CIDR notation format,
               for example, 192.168.200.0/24. The destination of each route must be unique and cannot overlap with any
               subnet in the VPC. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] nexthop: Specifies the next hop.
               + If the route type is **ecs**, the value is an ECS instance ID in the VPC.
               + If the route type is **eni**, the value is the extension NIC of an ECS in the VPC.
               + If the route type is **vip**, the value is a virtual IP address.
               + If the route type is **nat**, the value is a VPN gateway ID.
               + If the route type is **peering**, the value is a VPC peering connection ID.
               + If the route type is **vpn**, the value is a VPN gateway ID.
               + If the route type is **dc**, the value is a Direct Connect gateway ID.
               + If the route type is **cc**, the value is a Cloud Connection ID.
        :param pulumi.Input[_builtins.str] region: The region in which to create the VPC route. If omitted, the provider-level
               region will be used. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] route_table_id: Specifies the route table ID for which a route is to be added.
               If the value is not set, the route will be added to the *default* route table.
        :param pulumi.Input[_builtins.str] type: Specifies the route type. Currently, the value can be:
               **ecs**, **eni**, **vip**, **nat**, **peering**, **vpn**, **dc** and **cc**.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the VPC for which a route is to be added. Changing this creates a
               new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a VPC route resource within SberCloud.

        ## Example Usage

        ### Add route to the default route table

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        nexthop = config.require_object("nexthop")
        vpc_route = sbercloud.vpc.Route("vpc_route",
            vpc_id=vpc_id,
            destination="192.168.0.0/16",
            type="peering",
            nexthop=nexthop)
        ```

        ### Add route to a custom route table

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud
        import pulumi_sbercloud as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        nexthop = config.require_object("nexthop")
        rtb = sbercloud.Vpc.get_route_table(vpc_id=vpc_id,
            name="demo")
        vpc_route = sbercloud.vpc.Route("vpc_route",
            vpc_id=vpc_id,
            route_table_id=rtb.id,
            destination="172.16.8.0/24",
            type="ecs",
            nexthop=nexthop)
        ```

        ## Import

        VPC routes can be imported using the route table ID and their `destination` separated by a slash, e.g.

        ```sh
        $ pulumi import sbercloud:Vpc/route:Route test <route_table_id>/<destination>
        ```

        :param str resource_name: The name of the resource.
        :param RouteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[_builtins.str]] = None,
                 nexthop: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteArgs.__new__(RouteArgs)

            __props__.__dict__["description"] = description
            if destination is None and not opts.urn:
                raise TypeError("Missing required property 'destination'")
            __props__.__dict__["destination"] = destination
            if nexthop is None and not opts.urn:
                raise TypeError("Missing required property 'nexthop'")
            __props__.__dict__["nexthop"] = nexthop
            __props__.__dict__["region"] = region
            __props__.__dict__["route_table_id"] = route_table_id
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["route_table_name"] = None
        super(Route, __self__).__init__(
            'sbercloud:Vpc/route:Route',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            destination: Optional[pulumi.Input[_builtins.str]] = None,
            nexthop: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
            route_table_name: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Route':
        """
        Get an existing Route resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specifies the supplementary information about the route.
               The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[_builtins.str] destination: Specifies the destination address in the CIDR notation format,
               for example, 192.168.200.0/24. The destination of each route must be unique and cannot overlap with any
               subnet in the VPC. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] nexthop: Specifies the next hop.
               + If the route type is **ecs**, the value is an ECS instance ID in the VPC.
               + If the route type is **eni**, the value is the extension NIC of an ECS in the VPC.
               + If the route type is **vip**, the value is a virtual IP address.
               + If the route type is **nat**, the value is a VPN gateway ID.
               + If the route type is **peering**, the value is a VPC peering connection ID.
               + If the route type is **vpn**, the value is a VPN gateway ID.
               + If the route type is **dc**, the value is a Direct Connect gateway ID.
               + If the route type is **cc**, the value is a Cloud Connection ID.
        :param pulumi.Input[_builtins.str] region: The region in which to create the VPC route. If omitted, the provider-level
               region will be used. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] route_table_id: Specifies the route table ID for which a route is to be added.
               If the value is not set, the route will be added to the *default* route table.
        :param pulumi.Input[_builtins.str] route_table_name: The name of route table.
        :param pulumi.Input[_builtins.str] type: Specifies the route type. Currently, the value can be:
               **ecs**, **eni**, **vip**, **nat**, **peering**, **vpn**, **dc** and **cc**.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the VPC for which a route is to be added. Changing this creates a
               new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouteState.__new__(_RouteState)

        __props__.__dict__["description"] = description
        __props__.__dict__["destination"] = destination
        __props__.__dict__["nexthop"] = nexthop
        __props__.__dict__["region"] = region
        __props__.__dict__["route_table_id"] = route_table_id
        __props__.__dict__["route_table_name"] = route_table_name
        __props__.__dict__["type"] = type
        __props__.__dict__["vpc_id"] = vpc_id
        return Route(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the supplementary information about the route.
        The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the destination address in the CIDR notation format,
        for example, 192.168.200.0/24. The destination of each route must be unique and cannot overlap with any
        subnet in the VPC. Changing this creates a new resource.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def nexthop(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the next hop.
        + If the route type is **ecs**, the value is an ECS instance ID in the VPC.
        + If the route type is **eni**, the value is the extension NIC of an ECS in the VPC.
        + If the route type is **vip**, the value is a virtual IP address.
        + If the route type is **nat**, the value is a VPN gateway ID.
        + If the route type is **peering**, the value is a VPC peering connection ID.
        + If the route type is **vpn**, the value is a VPN gateway ID.
        + If the route type is **dc**, the value is a Direct Connect gateway ID.
        + If the route type is **cc**, the value is a Cloud Connection ID.
        """
        return pulumi.get(self, "nexthop")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the VPC route. If omitted, the provider-level
        region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the route table ID for which a route is to be added.
        If the value is not set, the route will be added to the *default* route table.
        """
        return pulumi.get(self, "route_table_id")

    @_builtins.property
    @pulumi.getter(name="routeTableName")
    def route_table_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of route table.
        """
        return pulumi.get(self, "route_table_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the route type. Currently, the value can be:
        **ecs**, **eni**, **vip**, **nat**, **peering**, **vpn**, **dc** and **cc**.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the VPC for which a route is to be added. Changing this creates a
        new resource.
        """
        return pulumi.get(self, "vpc_id")

