# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RouteTableArgs', 'RouteTable']

@pulumi.input_type
class RouteTableArgs:
    def __init__(__self__, *,
                 vpc_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input['RouteTableRouteArgs']]]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a RouteTable resource.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the VPC ID for which a route table is to be added.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the supplementary information about the route.
               The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[_builtins.str] name: Specifies the route table name. The value is a string of no more than
               64 characters that can contain letters, digits, underscores (_), hyphens (-), and periods (.).
        :param pulumi.Input[_builtins.str] region: The region in which to create the vpc route table.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['RouteTableRouteArgs']]] routes: Specifies the route object list. The route object
               is documented below.
               
               <a name="route_object"></a>
               The `route` block supports:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnets: Specifies an array of one or more subnets associating with the route table.
               
               > **NOTE:** The custom route table associated with a subnet affects only the outbound traffic.
               The default route table determines the inbound traffic.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the VPC ID for which a route table is to be added.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supplementary information about the route.
        The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the route table name. The value is a string of no more than
        64 characters that can contain letters, digits, underscores (_), hyphens (-), and periods (.).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the vpc route table.
        If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouteTableRouteArgs']]]]:
        """
        Specifies the route object list. The route object
        is documented below.

        <a name="route_object"></a>
        The `route` block supports:
        """
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouteTableRouteArgs']]]]):
        pulumi.set(self, "routes", value)

    @_builtins.property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies an array of one or more subnets associating with the route table.

        > **NOTE:** The custom route table associated with a subnet affects only the outbound traffic.
        The default route table determines the inbound traffic.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "subnets", value)


@pulumi.input_type
class _RouteTableState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input['RouteTableRouteArgs']]]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RouteTable resources.
        :param pulumi.Input[_builtins.str] description: Specifies the supplementary information about the route.
               The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[_builtins.str] name: Specifies the route table name. The value is a string of no more than
               64 characters that can contain letters, digits, underscores (_), hyphens (-), and periods (.).
        :param pulumi.Input[_builtins.str] region: The region in which to create the vpc route table.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['RouteTableRouteArgs']]] routes: Specifies the route object list. The route object
               is documented below.
               
               <a name="route_object"></a>
               The `route` block supports:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnets: Specifies an array of one or more subnets associating with the route table.
               
               > **NOTE:** The custom route table associated with a subnet affects only the outbound traffic.
               The default route table determines the inbound traffic.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the VPC ID for which a route table is to be added.
               Changing this creates a new resource.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supplementary information about the route.
        The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the route table name. The value is a string of no more than
        64 characters that can contain letters, digits, underscores (_), hyphens (-), and periods (.).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the vpc route table.
        If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouteTableRouteArgs']]]]:
        """
        Specifies the route object list. The route object
        is documented below.

        <a name="route_object"></a>
        The `route` block supports:
        """
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouteTableRouteArgs']]]]):
        pulumi.set(self, "routes", value)

    @_builtins.property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies an array of one or more subnets associating with the route table.

        > **NOTE:** The custom route table associated with a subnet affects only the outbound traffic.
        The default route table determines the inbound traffic.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "subnets", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the VPC ID for which a route table is to be added.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("sbercloud:Vpc/routeTable:RouteTable")
class RouteTable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouteTableRouteArgs', 'RouteTableRouteArgsDict']]]]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a VPC custom route table resource within SberCloud.

        > **NOTE:** To use a custom route table, you need to submit a service ticket to increase quota.

        ## Example Usage

        ### Basic Custom Route Table

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        vpc_peering_id = config.require_object("vpcPeeringId")
        demo = sbercloud.vpc.RouteTable("demo",
            name="demo",
            vpc_id=vpc_id,
            description="a custom route table demo",
            routes=[{
                "destination": "172.16.0.0/16",
                "type": "peering",
                "nexthop": vpc_peering_id,
            }])
        ```

        ### Associating Subnets with a Route Table

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud
        import pulumi_sbercloud as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        vpc_peering_id = config.require_object("vpcPeeringId")
        subnet_ids = sbercloud.Vpc.get_subnet_ids(vpc_id=vpc_id)
        demo = sbercloud.vpc.RouteTable("demo",
            name="demo",
            vpc_id=vpc_id,
            subnets=subnet_ids.ids,
            routes=[
                {
                    "destination": "172.16.0.0/16",
                    "type": "peering",
                    "nexthop": vpc_peering_id,
                },
                {
                    "destination": "192.168.100.0/24",
                    "type": "vip",
                    "nexthop": "192.168.10.200",
                },
            ])
        ```

        ## Import

        vpc route tables can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Vpc/routeTable:RouteTable demo e1b3208a-544b-42a7-84e6-5d70371dd982
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specifies the supplementary information about the route.
               The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[_builtins.str] name: Specifies the route table name. The value is a string of no more than
               64 characters that can contain letters, digits, underscores (_), hyphens (-), and periods (.).
        :param pulumi.Input[_builtins.str] region: The region in which to create the vpc route table.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RouteTableRouteArgs', 'RouteTableRouteArgsDict']]]] routes: Specifies the route object list. The route object
               is documented below.
               
               <a name="route_object"></a>
               The `route` block supports:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnets: Specifies an array of one or more subnets associating with the route table.
               
               > **NOTE:** The custom route table associated with a subnet affects only the outbound traffic.
               The default route table determines the inbound traffic.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the VPC ID for which a route table is to be added.
               Changing this creates a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteTableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a VPC custom route table resource within SberCloud.

        > **NOTE:** To use a custom route table, you need to submit a service ticket to increase quota.

        ## Example Usage

        ### Basic Custom Route Table

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        vpc_peering_id = config.require_object("vpcPeeringId")
        demo = sbercloud.vpc.RouteTable("demo",
            name="demo",
            vpc_id=vpc_id,
            description="a custom route table demo",
            routes=[{
                "destination": "172.16.0.0/16",
                "type": "peering",
                "nexthop": vpc_peering_id,
            }])
        ```

        ### Associating Subnets with a Route Table

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud
        import pulumi_sbercloud as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        vpc_peering_id = config.require_object("vpcPeeringId")
        subnet_ids = sbercloud.Vpc.get_subnet_ids(vpc_id=vpc_id)
        demo = sbercloud.vpc.RouteTable("demo",
            name="demo",
            vpc_id=vpc_id,
            subnets=subnet_ids.ids,
            routes=[
                {
                    "destination": "172.16.0.0/16",
                    "type": "peering",
                    "nexthop": vpc_peering_id,
                },
                {
                    "destination": "192.168.100.0/24",
                    "type": "vip",
                    "nexthop": "192.168.10.200",
                },
            ])
        ```

        ## Import

        vpc route tables can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Vpc/routeTable:RouteTable demo e1b3208a-544b-42a7-84e6-5d70371dd982
        ```

        :param str resource_name: The name of the resource.
        :param RouteTableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteTableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouteTableRouteArgs', 'RouteTableRouteArgsDict']]]]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteTableArgs.__new__(RouteTableArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["routes"] = routes
            __props__.__dict__["subnets"] = subnets
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
        super(RouteTable, __self__).__init__(
            'sbercloud:Vpc/routeTable:RouteTable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouteTableRouteArgs', 'RouteTableRouteArgsDict']]]]] = None,
            subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'RouteTable':
        """
        Get an existing RouteTable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specifies the supplementary information about the route.
               The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[_builtins.str] name: Specifies the route table name. The value is a string of no more than
               64 characters that can contain letters, digits, underscores (_), hyphens (-), and periods (.).
        :param pulumi.Input[_builtins.str] region: The region in which to create the vpc route table.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RouteTableRouteArgs', 'RouteTableRouteArgsDict']]]] routes: Specifies the route object list. The route object
               is documented below.
               
               <a name="route_object"></a>
               The `route` block supports:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnets: Specifies an array of one or more subnets associating with the route table.
               
               > **NOTE:** The custom route table associated with a subnet affects only the outbound traffic.
               The default route table determines the inbound traffic.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the VPC ID for which a route table is to be added.
               Changing this creates a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouteTableState.__new__(_RouteTableState)

        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["routes"] = routes
        __props__.__dict__["subnets"] = subnets
        __props__.__dict__["vpc_id"] = vpc_id
        return RouteTable(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the supplementary information about the route.
        The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the route table name. The value is a string of no more than
        64 characters that can contain letters, digits, underscores (_), hyphens (-), and periods (.).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the vpc route table.
        If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def routes(self) -> pulumi.Output[Sequence['outputs.RouteTableRoute']]:
        """
        Specifies the route object list. The route object
        is documented below.

        <a name="route_object"></a>
        The `route` block supports:
        """
        return pulumi.get(self, "routes")

    @_builtins.property
    @pulumi.getter
    def subnets(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies an array of one or more subnets associating with the route table.

        > **NOTE:** The custom route table associated with a subnet affects only the outbound traffic.
        The default route table determines the inbound traffic.
        """
        return pulumi.get(self, "subnets")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the VPC ID for which a route table is to be added.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "vpc_id")

