# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VipArgs', 'Vip']

@pulumi.input_type
class VipArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[_builtins.str],
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Vip resource.
        :param pulumi.Input[_builtins.str] network_id: Specifies the network ID of the VPC subnet to which the VIP belongs.
               Changing this will create a new VIP resource.
        :param pulumi.Input[_builtins.str] ip_address: Specifies the IP address desired in the subnet for this VIP.
               Changing this will create a new VIP resource.
        :param pulumi.Input[_builtins.int] ip_version: Specifies the IP version, either `4` (default) or `6`.
               Changing this will create a new VIP resource.
        :param pulumi.Input[_builtins.str] name: Specifies a unique name for the VIP.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the VIP.
               If omitted, the provider-level region will be used. Changing this will create a new VIP resource.
        """
        pulumi.set(__self__, "network_id", network_id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if subnet_id is not None:
            warnings.warn("""use ip_version instead""", DeprecationWarning)
            pulumi.log.warn("""subnet_id is deprecated: use ip_version instead""")
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the network ID of the VPC subnet to which the VIP belongs.
        Changing this will create a new VIP resource.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IP address desired in the subnet for this VIP.
        Changing this will create a new VIP resource.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the IP version, either `4` (default) or `6`.
        Changing this will create a new VIP resource.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a unique name for the VIP.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the VIP.
        If omitted, the provider-level region will be used. Changing this will create a new VIP resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    @_utilities.deprecated("""use ip_version instead""")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class _VipState:
    def __init__(__self__, *,
                 device_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.int]] = None,
                 mac_address: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Vip resources.
        :param pulumi.Input[_builtins.str] device_owner: The device owner of the VIP.
        :param pulumi.Input[_builtins.str] ip_address: Specifies the IP address desired in the subnet for this VIP.
               Changing this will create a new VIP resource.
        :param pulumi.Input[_builtins.int] ip_version: Specifies the IP version, either `4` (default) or `6`.
               Changing this will create a new VIP resource.
        :param pulumi.Input[_builtins.str] mac_address: The MAC address of the VIP.
        :param pulumi.Input[_builtins.str] name: Specifies a unique name for the VIP.
        :param pulumi.Input[_builtins.str] network_id: Specifies the network ID of the VPC subnet to which the VIP belongs.
               Changing this will create a new VIP resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the VIP.
               If omitted, the provider-level region will be used. Changing this will create a new VIP resource.
        :param pulumi.Input[_builtins.str] status: The VIP status.
        """
        if device_owner is not None:
            pulumi.set(__self__, "device_owner", device_owner)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            warnings.warn("""use ip_version instead""", DeprecationWarning)
            pulumi.log.warn("""subnet_id is deprecated: use ip_version instead""")
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="deviceOwner")
    def device_owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device owner of the VIP.
        """
        return pulumi.get(self, "device_owner")

    @device_owner.setter
    def device_owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device_owner", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IP address desired in the subnet for this VIP.
        Changing this will create a new VIP resource.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the IP version, either `4` (default) or `6`.
        Changing this will create a new VIP resource.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The MAC address of the VIP.
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mac_address", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a unique name for the VIP.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the network ID of the VPC subnet to which the VIP belongs.
        Changing this will create a new VIP resource.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the VIP.
        If omitted, the provider-level region will be used. Changing this will create a new VIP resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VIP status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    @_utilities.deprecated("""use ip_version instead""")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.type_token("sbercloud:Vpc/vip:Vip")
class Vip(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a network VIP resource within SberCloud VPC.

        ## Import

        Network VIPs can be imported using their `id`, e.g.:

        ```sh
        $ pulumi import sbercloud:Vpc/vip:Vip test ce595799-da26-4015-8db5-7733c6db292e
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ip_address: Specifies the IP address desired in the subnet for this VIP.
               Changing this will create a new VIP resource.
        :param pulumi.Input[_builtins.int] ip_version: Specifies the IP version, either `4` (default) or `6`.
               Changing this will create a new VIP resource.
        :param pulumi.Input[_builtins.str] name: Specifies a unique name for the VIP.
        :param pulumi.Input[_builtins.str] network_id: Specifies the network ID of the VPC subnet to which the VIP belongs.
               Changing this will create a new VIP resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the VIP.
               If omitted, the provider-level region will be used. Changing this will create a new VIP resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VipArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a network VIP resource within SberCloud VPC.

        ## Import

        Network VIPs can be imported using their `id`, e.g.:

        ```sh
        $ pulumi import sbercloud:Vpc/vip:Vip test ce595799-da26-4015-8db5-7733c6db292e
        ```

        :param str resource_name: The name of the resource.
        :param VipArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VipArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VipArgs.__new__(VipArgs)

            __props__.__dict__["ip_address"] = ip_address
            __props__.__dict__["ip_version"] = ip_version
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["region"] = region
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["device_owner"] = None
            __props__.__dict__["mac_address"] = None
            __props__.__dict__["status"] = None
        super(Vip, __self__).__init__(
            'sbercloud:Vpc/vip:Vip',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            device_owner: Optional[pulumi.Input[_builtins.str]] = None,
            ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            ip_version: Optional[pulumi.Input[_builtins.int]] = None,
            mac_address: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Vip':
        """
        Get an existing Vip resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] device_owner: The device owner of the VIP.
        :param pulumi.Input[_builtins.str] ip_address: Specifies the IP address desired in the subnet for this VIP.
               Changing this will create a new VIP resource.
        :param pulumi.Input[_builtins.int] ip_version: Specifies the IP version, either `4` (default) or `6`.
               Changing this will create a new VIP resource.
        :param pulumi.Input[_builtins.str] mac_address: The MAC address of the VIP.
        :param pulumi.Input[_builtins.str] name: Specifies a unique name for the VIP.
        :param pulumi.Input[_builtins.str] network_id: Specifies the network ID of the VPC subnet to which the VIP belongs.
               Changing this will create a new VIP resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the VIP.
               If omitted, the provider-level region will be used. Changing this will create a new VIP resource.
        :param pulumi.Input[_builtins.str] status: The VIP status.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VipState.__new__(_VipState)

        __props__.__dict__["device_owner"] = device_owner
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["ip_version"] = ip_version
        __props__.__dict__["mac_address"] = mac_address
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        return Vip(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="deviceOwner")
    def device_owner(self) -> pulumi.Output[_builtins.str]:
        """
        The device owner of the VIP.
        """
        return pulumi.get(self, "device_owner")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the IP address desired in the subnet for this VIP.
        Changing this will create a new VIP resource.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the IP version, either `4` (default) or `6`.
        Changing this will create a new VIP resource.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> pulumi.Output[_builtins.str]:
        """
        The MAC address of the VIP.
        """
        return pulumi.get(self, "mac_address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies a unique name for the VIP.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the network ID of the VPC subnet to which the VIP belongs.
        Changing this will create a new VIP resource.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the VIP.
        If omitted, the provider-level region will be used. Changing this will create a new VIP resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The VIP status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    @_utilities.deprecated("""use ip_version instead""")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "subnet_id")

