# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VpcArgs', 'Vpc']

@pulumi.input_type
class VpcArgs:
    def __init__(__self__, *,
                 cidr: pulumi.Input[_builtins.str],
                 block_service_endpoint_states: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enhanced_local_route: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Vpc resource.
        :param pulumi.Input[_builtins.str] cidr: Specifies the range of available subnets in the VPC. The value ranges from 10.0.0.0/8 to
               10.255.255.0/24, 172.16.0.0/12 to 172.31.255.0/24, or 192.168.0.0/16 to 192.168.255.0/24.
        :param pulumi.Input[_builtins.str] description: Specifies supplementary information about the VPC. The value is a string of
               no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the VPC. Changing this
               creates a new VPC resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the VPC. The name must be unique for a tenant. The value is a string
               of no more than 64 characters and can contain digits, letters, underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the VPC. If omitted, the
               provider-level region will be used. Changing this creates a new VPC resource.
        :param pulumi.Input[_builtins.str] secondary_cidr: schema: Deprecated; use secondary_cidrs instead
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the VPC.
        """
        pulumi.set(__self__, "cidr", cidr)
        if block_service_endpoint_states is not None:
            pulumi.set(__self__, "block_service_endpoint_states", block_service_endpoint_states)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enhanced_local_route is not None:
            pulumi.set(__self__, "enhanced_local_route", enhanced_local_route)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secondary_cidr is not None:
            pulumi.set(__self__, "secondary_cidr", secondary_cidr)
        if secondary_cidrs is not None:
            pulumi.set(__self__, "secondary_cidrs", secondary_cidrs)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the range of available subnets in the VPC. The value ranges from 10.0.0.0/8 to
        10.255.255.0/24, 172.16.0.0/12 to 172.31.255.0/24, or 192.168.0.0/16 to 192.168.255.0/24.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cidr", value)

    @_builtins.property
    @pulumi.getter(name="blockServiceEndpointStates")
    def block_service_endpoint_states(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "block_service_endpoint_states")

    @block_service_endpoint_states.setter
    def block_service_endpoint_states(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "block_service_endpoint_states", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies supplementary information about the VPC. The value is a string of
        no more than 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enhancedLocalRoute")
    def enhanced_local_route(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enhanced_local_route")

    @enhanced_local_route.setter
    def enhanced_local_route(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enhanced_local_route", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project id of the VPC. Changing this
        creates a new VPC resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the VPC. The name must be unique for a tenant. The value is a string
        of no more than 64 characters and can contain digits, letters, underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the VPC. If omitted, the
        provider-level region will be used. Changing this creates a new VPC resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="secondaryCidr")
    def secondary_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        schema: Deprecated; use secondary_cidrs instead
        """
        return pulumi.get(self, "secondary_cidr")

    @secondary_cidr.setter
    def secondary_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_cidr", value)

    @_builtins.property
    @pulumi.getter(name="secondaryCidrs")
    def secondary_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "secondary_cidrs")

    @secondary_cidrs.setter
    def secondary_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "secondary_cidrs", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs to associate with the VPC.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _VpcState:
    def __init__(__self__, *,
                 block_service_endpoint_states: Optional[pulumi.Input[_builtins.str]] = None,
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enhanced_local_route: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input['VpcRouteArgs']]]] = None,
                 secondary_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Vpc resources.
        :param pulumi.Input[_builtins.str] cidr: Specifies the range of available subnets in the VPC. The value ranges from 10.0.0.0/8 to
               10.255.255.0/24, 172.16.0.0/12 to 172.31.255.0/24, or 192.168.0.0/16 to 192.168.255.0/24.
        :param pulumi.Input[_builtins.str] description: Specifies supplementary information about the VPC. The value is a string of
               no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the VPC. Changing this
               creates a new VPC resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the VPC. The name must be unique for a tenant. The value is a string
               of no more than 64 characters and can contain digits, letters, underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the VPC. If omitted, the
               provider-level region will be used. Changing this creates a new VPC resource.
        :param pulumi.Input[_builtins.str] secondary_cidr: schema: Deprecated; use secondary_cidrs instead
        :param pulumi.Input[_builtins.str] status: The current status of the VPC. Possible values are as follows: CREATING, OK or ERROR.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the VPC.
        """
        if block_service_endpoint_states is not None:
            pulumi.set(__self__, "block_service_endpoint_states", block_service_endpoint_states)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enhanced_local_route is not None:
            pulumi.set(__self__, "enhanced_local_route", enhanced_local_route)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if routes is not None:
            warnings.warn("""use huaweicloud_vpc_route_table data source to get all routes""", DeprecationWarning)
            pulumi.log.warn("""routes is deprecated: use huaweicloud_vpc_route_table data source to get all routes""")
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if secondary_cidr is not None:
            pulumi.set(__self__, "secondary_cidr", secondary_cidr)
        if secondary_cidrs is not None:
            pulumi.set(__self__, "secondary_cidrs", secondary_cidrs)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="blockServiceEndpointStates")
    def block_service_endpoint_states(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "block_service_endpoint_states")

    @block_service_endpoint_states.setter
    def block_service_endpoint_states(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "block_service_endpoint_states", value)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the range of available subnets in the VPC. The value ranges from 10.0.0.0/8 to
        10.255.255.0/24, 172.16.0.0/12 to 172.31.255.0/24, or 192.168.0.0/16 to 192.168.255.0/24.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cidr", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies supplementary information about the VPC. The value is a string of
        no more than 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enhancedLocalRoute")
    def enhanced_local_route(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enhanced_local_route")

    @enhanced_local_route.setter
    def enhanced_local_route(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enhanced_local_route", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project id of the VPC. Changing this
        creates a new VPC resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the VPC. The name must be unique for a tenant. The value is a string
        of no more than 64 characters and can contain digits, letters, underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the VPC. If omitted, the
        provider-level region will be used. Changing this creates a new VPC resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""use huaweicloud_vpc_route_table data source to get all routes""")
    def routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcRouteArgs']]]]:
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcRouteArgs']]]]):
        pulumi.set(self, "routes", value)

    @_builtins.property
    @pulumi.getter(name="secondaryCidr")
    def secondary_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        schema: Deprecated; use secondary_cidrs instead
        """
        return pulumi.get(self, "secondary_cidr")

    @secondary_cidr.setter
    def secondary_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_cidr", value)

    @_builtins.property
    @pulumi.getter(name="secondaryCidrs")
    def secondary_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "secondary_cidrs")

    @secondary_cidrs.setter
    def secondary_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "secondary_cidrs", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current status of the VPC. Possible values are as follows: CREATING, OK or ERROR.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs to associate with the VPC.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("sbercloud:Vpc/vpc:Vpc")
class Vpc(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 block_service_endpoint_states: Optional[pulumi.Input[_builtins.str]] = None,
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enhanced_local_route: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a VPC resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        vpc_name = config.get("vpcName")
        if vpc_name is None:
            vpc_name = "sbercloud_vpc"
        vpc_cidr = config.get("vpcCidr")
        if vpc_cidr is None:
            vpc_cidr = "192.168.0.0/16"
        vpc = sbercloud.vpc.Vpc("vpc",
            name=vpc_name,
            cidr=vpc_cidr)
        vpc_with_tags = sbercloud.vpc.Vpc("vpc_with_tags",
            name=vpc_name,
            cidr=vpc_cidr,
            tags={
                "foo": "bar",
                "key": "value",
            })
        ```

        ## Import

        VPCs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Vpc/vpc:Vpc vpc_v1 7117d38e-4c8f-4624-a505-bd96b97d024c
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cidr: Specifies the range of available subnets in the VPC. The value ranges from 10.0.0.0/8 to
               10.255.255.0/24, 172.16.0.0/12 to 172.31.255.0/24, or 192.168.0.0/16 to 192.168.255.0/24.
        :param pulumi.Input[_builtins.str] description: Specifies supplementary information about the VPC. The value is a string of
               no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the VPC. Changing this
               creates a new VPC resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the VPC. The name must be unique for a tenant. The value is a string
               of no more than 64 characters and can contain digits, letters, underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the VPC. If omitted, the
               provider-level region will be used. Changing this creates a new VPC resource.
        :param pulumi.Input[_builtins.str] secondary_cidr: schema: Deprecated; use secondary_cidrs instead
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the VPC.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a VPC resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        vpc_name = config.get("vpcName")
        if vpc_name is None:
            vpc_name = "sbercloud_vpc"
        vpc_cidr = config.get("vpcCidr")
        if vpc_cidr is None:
            vpc_cidr = "192.168.0.0/16"
        vpc = sbercloud.vpc.Vpc("vpc",
            name=vpc_name,
            cidr=vpc_cidr)
        vpc_with_tags = sbercloud.vpc.Vpc("vpc_with_tags",
            name=vpc_name,
            cidr=vpc_cidr,
            tags={
                "foo": "bar",
                "key": "value",
            })
        ```

        ## Import

        VPCs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Vpc/vpc:Vpc vpc_v1 7117d38e-4c8f-4624-a505-bd96b97d024c
        ```

        :param str resource_name: The name of the resource.
        :param VpcArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 block_service_endpoint_states: Optional[pulumi.Input[_builtins.str]] = None,
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enhanced_local_route: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcArgs.__new__(VpcArgs)

            __props__.__dict__["block_service_endpoint_states"] = block_service_endpoint_states
            if cidr is None and not opts.urn:
                raise TypeError("Missing required property 'cidr'")
            __props__.__dict__["cidr"] = cidr
            __props__.__dict__["description"] = description
            __props__.__dict__["enhanced_local_route"] = enhanced_local_route
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["secondary_cidr"] = secondary_cidr
            __props__.__dict__["secondary_cidrs"] = secondary_cidrs
            __props__.__dict__["tags"] = tags
            __props__.__dict__["routes"] = None
            __props__.__dict__["status"] = None
        super(Vpc, __self__).__init__(
            'sbercloud:Vpc/vpc:Vpc',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            block_service_endpoint_states: Optional[pulumi.Input[_builtins.str]] = None,
            cidr: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enhanced_local_route: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcRouteArgs', 'VpcRouteArgsDict']]]]] = None,
            secondary_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Vpc':
        """
        Get an existing Vpc resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cidr: Specifies the range of available subnets in the VPC. The value ranges from 10.0.0.0/8 to
               10.255.255.0/24, 172.16.0.0/12 to 172.31.255.0/24, or 192.168.0.0/16 to 192.168.255.0/24.
        :param pulumi.Input[_builtins.str] description: Specifies supplementary information about the VPC. The value is a string of
               no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the VPC. Changing this
               creates a new VPC resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the VPC. The name must be unique for a tenant. The value is a string
               of no more than 64 characters and can contain digits, letters, underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the VPC. If omitted, the
               provider-level region will be used. Changing this creates a new VPC resource.
        :param pulumi.Input[_builtins.str] secondary_cidr: schema: Deprecated; use secondary_cidrs instead
        :param pulumi.Input[_builtins.str] status: The current status of the VPC. Possible values are as follows: CREATING, OK or ERROR.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the VPC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcState.__new__(_VpcState)

        __props__.__dict__["block_service_endpoint_states"] = block_service_endpoint_states
        __props__.__dict__["cidr"] = cidr
        __props__.__dict__["description"] = description
        __props__.__dict__["enhanced_local_route"] = enhanced_local_route
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["routes"] = routes
        __props__.__dict__["secondary_cidr"] = secondary_cidr
        __props__.__dict__["secondary_cidrs"] = secondary_cidrs
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        return Vpc(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="blockServiceEndpointStates")
    def block_service_endpoint_states(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "block_service_endpoint_states")

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the range of available subnets in the VPC. The value ranges from 10.0.0.0/8 to
        10.255.255.0/24, 172.16.0.0/12 to 172.31.255.0/24, or 192.168.0.0/16 to 192.168.255.0/24.
        """
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies supplementary information about the VPC. The value is a string of
        no more than 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enhancedLocalRoute")
    def enhanced_local_route(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "enhanced_local_route")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the enterprise project id of the VPC. Changing this
        creates a new VPC resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the VPC. The name must be unique for a tenant. The value is a string
        of no more than 64 characters and can contain digits, letters, underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the VPC. If omitted, the
        provider-level region will be used. Changing this creates a new VPC resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""use huaweicloud_vpc_route_table data source to get all routes""")
    def routes(self) -> pulumi.Output[Sequence['outputs.VpcRoute']]:
        return pulumi.get(self, "routes")

    @_builtins.property
    @pulumi.getter(name="secondaryCidr")
    def secondary_cidr(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        schema: Deprecated; use secondary_cidrs instead
        """
        return pulumi.get(self, "secondary_cidr")

    @_builtins.property
    @pulumi.getter(name="secondaryCidrs")
    def secondary_cidrs(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "secondary_cidrs")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The current status of the VPC. Possible values are as follows: CREATING, OK or ERROR.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the key/value pairs to associate with the VPC.
        """
        return pulumi.get(self, "tags")

