# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ServiceConnectionArgs',
    'ServiceConnectionArgsDict',
    'ServicePortMappingArgs',
    'ServicePortMappingArgsDict',
]

MYPY = False

if not MYPY:
    class ServiceConnectionArgsDict(TypedDict):
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the description of the VPC endpoint service.
        """
        domain_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The user's domain ID.
        """
        endpoint_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The unique ID of the VPC endpoint.
        """
        packet_id: NotRequired[pulumi.Input[_builtins.int]]
        """
        The packet ID of the VPC endpoint.
        """
        status: NotRequired[pulumi.Input[_builtins.str]]
        """
        The connection status of the VPC endpoint.
        """
elif False:
    ServiceConnectionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceConnectionArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 packet_id: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] description: Specifies the description of the VPC endpoint service.
        :param pulumi.Input[_builtins.str] domain_id: The user's domain ID.
        :param pulumi.Input[_builtins.str] endpoint_id: The unique ID of the VPC endpoint.
        :param pulumi.Input[_builtins.int] packet_id: The packet ID of the VPC endpoint.
        :param pulumi.Input[_builtins.str] status: The connection status of the VPC endpoint.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_id is not None:
            pulumi.set(__self__, "domain_id", domain_id)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if packet_id is not None:
            pulumi.set(__self__, "packet_id", packet_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the VPC endpoint service.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user's domain ID.
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_id", value)

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique ID of the VPC endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="packetId")
    def packet_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The packet ID of the VPC endpoint.
        """
        return pulumi.get(self, "packet_id")

    @packet_id.setter
    def packet_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "packet_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection status of the VPC endpoint.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


if not MYPY:
    class ServicePortMappingArgsDict(TypedDict):
        protocol: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the protocol used in port mappings. Only **TCP** is supported.
        """
        service_port: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the port for accessing the VPC endpoint service. This port is provided by
        the backend service to provide services. The value ranges from 1 to 65535.
        """
        terminal_port: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the port for accessing the VPC endpoint. This port is provided by the VPC
        endpoint, allowing you to access the VPC endpoint service. The value ranges from 1 to 65535.
        """
elif False:
    ServicePortMappingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServicePortMappingArgs:
    def __init__(__self__, *,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 service_port: Optional[pulumi.Input[_builtins.int]] = None,
                 terminal_port: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] protocol: Specifies the protocol used in port mappings. Only **TCP** is supported.
        :param pulumi.Input[_builtins.int] service_port: Specifies the port for accessing the VPC endpoint service. This port is provided by
               the backend service to provide services. The value ranges from 1 to 65535.
        :param pulumi.Input[_builtins.int] terminal_port: Specifies the port for accessing the VPC endpoint. This port is provided by the VPC
               endpoint, allowing you to access the VPC endpoint service. The value ranges from 1 to 65535.
        """
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if service_port is not None:
            pulumi.set(__self__, "service_port", service_port)
        if terminal_port is not None:
            pulumi.set(__self__, "terminal_port", terminal_port)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the protocol used in port mappings. Only **TCP** is supported.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="servicePort")
    def service_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the port for accessing the VPC endpoint service. This port is provided by
        the backend service to provide services. The value ranges from 1 to 65535.
        """
        return pulumi.get(self, "service_port")

    @service_port.setter
    def service_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "service_port", value)

    @_builtins.property
    @pulumi.getter(name="terminalPort")
    def terminal_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the port for accessing the VPC endpoint. This port is provided by the VPC
        endpoint, allowing you to access the VPC endpoint service. The value ranges from 1 to 65535.
        """
        return pulumi.get(self, "terminal_port")

    @terminal_port.setter
    def terminal_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "terminal_port", value)


