# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EndpointArgs', 'Endpoint']

@pulumi.input_type
class EndpointArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[_builtins.str],
                 service_id: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_dns: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_whitelist: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Endpoint resource.
        :param pulumi.Input[_builtins.str] network_id: Specifies the network ID of the subnet in the VPC specified by `vpc_id`.
               Changing this creates a new VPC endpoint.
        :param pulumi.Input[_builtins.str] service_id: Specifies the ID of the VPC endpoint service.
               The VPC endpoint service could be private or public. Changing this creates a new VPC endpoint.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of the VPC where the VPC endpoint is to be created. Changing
               this creates a new VPC endpoint.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the VPC endpoint.
               
               Changing this creates a new VPC endpoint.
        :param pulumi.Input[_builtins.bool] enable_dns: Specifies whether to create a private domain name. The default value is
               true. Changing this creates a new VPC endpoint.
        :param pulumi.Input[_builtins.bool] enable_whitelist: Specifies whether to enable access control. The default value is
               false.
        :param pulumi.Input[_builtins.str] ip_address: Specifies the IP address for accessing the associated VPC endpoint
               service. Only IPv4 addresses are supported. Changing this creates a new VPC endpoint.
        :param pulumi.Input[_builtins.str] region: The region in which to create the VPC endpoint. If omitted, the provider-level
               region will be used. Changing this creates a new VPC endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the VPC endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] whitelists: Specifies the list of IP address or CIDR block which can be accessed to the
               VPC endpoint. This field is valid when `enable_whitelist` is set to **true**. The max length of whitelist is 20.
        """
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "service_id", service_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_dns is not None:
            pulumi.set(__self__, "enable_dns", enable_dns)
        if enable_whitelist is not None:
            pulumi.set(__self__, "enable_whitelist", enable_whitelist)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if whitelists is not None:
            pulumi.set(__self__, "whitelists", whitelists)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the network ID of the subnet in the VPC specified by `vpc_id`.
        Changing this creates a new VPC endpoint.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the VPC endpoint service.
        The VPC endpoint service could be private or public. Changing this creates a new VPC endpoint.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the VPC where the VPC endpoint is to be created. Changing
        this creates a new VPC endpoint.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the VPC endpoint.

        Changing this creates a new VPC endpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableDns")
    def enable_dns(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to create a private domain name. The default value is
        true. Changing this creates a new VPC endpoint.
        """
        return pulumi.get(self, "enable_dns")

    @enable_dns.setter
    def enable_dns(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_dns", value)

    @_builtins.property
    @pulumi.getter(name="enableWhitelist")
    def enable_whitelist(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable access control. The default value is
        false.
        """
        return pulumi.get(self, "enable_whitelist")

    @enable_whitelist.setter
    def enable_whitelist(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_whitelist", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IP address for accessing the associated VPC endpoint
        service. Only IPv4 addresses are supported. Changing this creates a new VPC endpoint.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the VPC endpoint. If omitted, the provider-level
        region will be used. Changing this creates a new VPC endpoint.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the VPC endpoint.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of IP address or CIDR block which can be accessed to the
        VPC endpoint. This field is valid when `enable_whitelist` is set to **true**. The max length of whitelist is 20.
        """
        return pulumi.get(self, "whitelists")

    @whitelists.setter
    def whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "whitelists", value)


@pulumi.input_type
class _EndpointState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_dns: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_whitelist: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 packet_id: Optional[pulumi.Input[_builtins.int]] = None,
                 private_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Endpoint resources.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the VPC endpoint.
               
               Changing this creates a new VPC endpoint.
        :param pulumi.Input[_builtins.bool] enable_dns: Specifies whether to create a private domain name. The default value is
               true. Changing this creates a new VPC endpoint.
        :param pulumi.Input[_builtins.bool] enable_whitelist: Specifies whether to enable access control. The default value is
               false.
        :param pulumi.Input[_builtins.str] ip_address: Specifies the IP address for accessing the associated VPC endpoint
               service. Only IPv4 addresses are supported. Changing this creates a new VPC endpoint.
        :param pulumi.Input[_builtins.str] network_id: Specifies the network ID of the subnet in the VPC specified by `vpc_id`.
               Changing this creates a new VPC endpoint.
        :param pulumi.Input[_builtins.int] packet_id: The packet ID of the VPC endpoint.
        :param pulumi.Input[_builtins.str] private_domain_name: The domain name for accessing the associated VPC endpoint service. This parameter is only
               available when enable_dns is set to true.
        :param pulumi.Input[_builtins.str] region: The region in which to create the VPC endpoint. If omitted, the provider-level
               region will be used. Changing this creates a new VPC endpoint.
        :param pulumi.Input[_builtins.str] service_id: Specifies the ID of the VPC endpoint service.
               The VPC endpoint service could be private or public. Changing this creates a new VPC endpoint.
        :param pulumi.Input[_builtins.str] service_name: The name of the VPC endpoint service.
        :param pulumi.Input[_builtins.str] service_type: The type of the VPC endpoint service.
        :param pulumi.Input[_builtins.str] status: The status of the VPC endpoint. The value can be **accepted**, **pendingAcceptance** or **rejected**.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the VPC endpoint.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of the VPC where the VPC endpoint is to be created. Changing
               this creates a new VPC endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] whitelists: Specifies the list of IP address or CIDR block which can be accessed to the
               VPC endpoint. This field is valid when `enable_whitelist` is set to **true**. The max length of whitelist is 20.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_dns is not None:
            pulumi.set(__self__, "enable_dns", enable_dns)
        if enable_whitelist is not None:
            pulumi.set(__self__, "enable_whitelist", enable_whitelist)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if packet_id is not None:
            pulumi.set(__self__, "packet_id", packet_id)
        if private_domain_name is not None:
            pulumi.set(__self__, "private_domain_name", private_domain_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if service_type is not None:
            pulumi.set(__self__, "service_type", service_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if whitelists is not None:
            pulumi.set(__self__, "whitelists", whitelists)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the VPC endpoint.

        Changing this creates a new VPC endpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableDns")
    def enable_dns(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to create a private domain name. The default value is
        true. Changing this creates a new VPC endpoint.
        """
        return pulumi.get(self, "enable_dns")

    @enable_dns.setter
    def enable_dns(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_dns", value)

    @_builtins.property
    @pulumi.getter(name="enableWhitelist")
    def enable_whitelist(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable access control. The default value is
        false.
        """
        return pulumi.get(self, "enable_whitelist")

    @enable_whitelist.setter
    def enable_whitelist(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_whitelist", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IP address for accessing the associated VPC endpoint
        service. Only IPv4 addresses are supported. Changing this creates a new VPC endpoint.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the network ID of the subnet in the VPC specified by `vpc_id`.
        Changing this creates a new VPC endpoint.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="packetId")
    def packet_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The packet ID of the VPC endpoint.
        """
        return pulumi.get(self, "packet_id")

    @packet_id.setter
    def packet_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "packet_id", value)

    @_builtins.property
    @pulumi.getter(name="privateDomainName")
    def private_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name for accessing the associated VPC endpoint service. This parameter is only
        available when enable_dns is set to true.
        """
        return pulumi.get(self, "private_domain_name")

    @private_domain_name.setter
    def private_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_domain_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the VPC endpoint. If omitted, the provider-level
        region will be used. Changing this creates a new VPC endpoint.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the VPC endpoint service.
        The VPC endpoint service could be private or public. Changing this creates a new VPC endpoint.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the VPC endpoint service.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the VPC endpoint service.
        """
        return pulumi.get(self, "service_type")

    @service_type.setter
    def service_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_type", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the VPC endpoint. The value can be **accepted**, **pendingAcceptance** or **rejected**.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the VPC endpoint.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the VPC where the VPC endpoint is to be created. Changing
        this creates a new VPC endpoint.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter
    def whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of IP address or CIDR block which can be accessed to the
        VPC endpoint. This field is valid when `enable_whitelist` is set to **true**. The max length of whitelist is 20.
        """
        return pulumi.get(self, "whitelists")

    @whitelists.setter
    def whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "whitelists", value)


@pulumi.type_token("sbercloud:Vpcep/endpoint:Endpoint")
class Endpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_dns: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_whitelist: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a resource to manage a VPC endpoint resource.

        ## Example Usage

        ### Access to the public service

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud
        import pulumi_sbercloud as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        network_id = config.require_object("networkId")
        cloud_service = sbercloud.Vpcep.get_public_services(service_name="dis")
        myendpoint = sbercloud.vpcep.Endpoint("myendpoint",
            service_id=cloud_service.services[0].id,
            vpc_id=vpc_id,
            network_id=network_id,
            enable_dns=True,
            enable_whitelist=True,
            whitelists=["192.168.0.0/24"])
        ```

        ### Access to the private service

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        service_vpc_id = config.require_object("serviceVpcId")
        vm_port = config.require_object("vmPort")
        vpc_id = config.require_object("vpcId")
        network_id = config.require_object("networkId")
        demo = sbercloud.vpcep.Service("demo",
            name="demo-service",
            server_type="VM",
            vpc_id=service_vpc_id,
            port_id=vm_port,
            port_mappings=[{
                "service_port": 8080,
                "terminal_port": 80,
            }])
        demo_endpoint = sbercloud.vpcep.Endpoint("demo",
            service_id=demo.id,
            vpc_id=vpc_id,
            network_id=network_id,
            enable_dns=True,
            description="test description")
        ```

        ## Import

        VPC endpoint can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Vpcep/endpoint:Endpoint test <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the VPC endpoint.
               
               Changing this creates a new VPC endpoint.
        :param pulumi.Input[_builtins.bool] enable_dns: Specifies whether to create a private domain name. The default value is
               true. Changing this creates a new VPC endpoint.
        :param pulumi.Input[_builtins.bool] enable_whitelist: Specifies whether to enable access control. The default value is
               false.
        :param pulumi.Input[_builtins.str] ip_address: Specifies the IP address for accessing the associated VPC endpoint
               service. Only IPv4 addresses are supported. Changing this creates a new VPC endpoint.
        :param pulumi.Input[_builtins.str] network_id: Specifies the network ID of the subnet in the VPC specified by `vpc_id`.
               Changing this creates a new VPC endpoint.
        :param pulumi.Input[_builtins.str] region: The region in which to create the VPC endpoint. If omitted, the provider-level
               region will be used. Changing this creates a new VPC endpoint.
        :param pulumi.Input[_builtins.str] service_id: Specifies the ID of the VPC endpoint service.
               The VPC endpoint service could be private or public. Changing this creates a new VPC endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the VPC endpoint.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of the VPC where the VPC endpoint is to be created. Changing
               this creates a new VPC endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] whitelists: Specifies the list of IP address or CIDR block which can be accessed to the
               VPC endpoint. This field is valid when `enable_whitelist` is set to **true**. The max length of whitelist is 20.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage a VPC endpoint resource.

        ## Example Usage

        ### Access to the public service

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud
        import pulumi_sbercloud as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        network_id = config.require_object("networkId")
        cloud_service = sbercloud.Vpcep.get_public_services(service_name="dis")
        myendpoint = sbercloud.vpcep.Endpoint("myendpoint",
            service_id=cloud_service.services[0].id,
            vpc_id=vpc_id,
            network_id=network_id,
            enable_dns=True,
            enable_whitelist=True,
            whitelists=["192.168.0.0/24"])
        ```

        ### Access to the private service

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        service_vpc_id = config.require_object("serviceVpcId")
        vm_port = config.require_object("vmPort")
        vpc_id = config.require_object("vpcId")
        network_id = config.require_object("networkId")
        demo = sbercloud.vpcep.Service("demo",
            name="demo-service",
            server_type="VM",
            vpc_id=service_vpc_id,
            port_id=vm_port,
            port_mappings=[{
                "service_port": 8080,
                "terminal_port": 80,
            }])
        demo_endpoint = sbercloud.vpcep.Endpoint("demo",
            service_id=demo.id,
            vpc_id=vpc_id,
            network_id=network_id,
            enable_dns=True,
            description="test description")
        ```

        ## Import

        VPC endpoint can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Vpcep/endpoint:Endpoint test <id>
        ```

        :param str resource_name: The name of the resource.
        :param EndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_dns: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_whitelist: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EndpointArgs.__new__(EndpointArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["enable_dns"] = enable_dns
            __props__.__dict__["enable_whitelist"] = enable_whitelist
            __props__.__dict__["ip_address"] = ip_address
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["region"] = region
            if service_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_id'")
            __props__.__dict__["service_id"] = service_id
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["whitelists"] = whitelists
            __props__.__dict__["packet_id"] = None
            __props__.__dict__["private_domain_name"] = None
            __props__.__dict__["service_name"] = None
            __props__.__dict__["service_type"] = None
            __props__.__dict__["status"] = None
        super(Endpoint, __self__).__init__(
            'sbercloud:Vpcep/endpoint:Endpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enable_dns: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_whitelist: Optional[pulumi.Input[_builtins.bool]] = None,
            ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            packet_id: Optional[pulumi.Input[_builtins.int]] = None,
            private_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            service_id: Optional[pulumi.Input[_builtins.str]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            service_type: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'Endpoint':
        """
        Get an existing Endpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the VPC endpoint.
               
               Changing this creates a new VPC endpoint.
        :param pulumi.Input[_builtins.bool] enable_dns: Specifies whether to create a private domain name. The default value is
               true. Changing this creates a new VPC endpoint.
        :param pulumi.Input[_builtins.bool] enable_whitelist: Specifies whether to enable access control. The default value is
               false.
        :param pulumi.Input[_builtins.str] ip_address: Specifies the IP address for accessing the associated VPC endpoint
               service. Only IPv4 addresses are supported. Changing this creates a new VPC endpoint.
        :param pulumi.Input[_builtins.str] network_id: Specifies the network ID of the subnet in the VPC specified by `vpc_id`.
               Changing this creates a new VPC endpoint.
        :param pulumi.Input[_builtins.int] packet_id: The packet ID of the VPC endpoint.
        :param pulumi.Input[_builtins.str] private_domain_name: The domain name for accessing the associated VPC endpoint service. This parameter is only
               available when enable_dns is set to true.
        :param pulumi.Input[_builtins.str] region: The region in which to create the VPC endpoint. If omitted, the provider-level
               region will be used. Changing this creates a new VPC endpoint.
        :param pulumi.Input[_builtins.str] service_id: Specifies the ID of the VPC endpoint service.
               The VPC endpoint service could be private or public. Changing this creates a new VPC endpoint.
        :param pulumi.Input[_builtins.str] service_name: The name of the VPC endpoint service.
        :param pulumi.Input[_builtins.str] service_type: The type of the VPC endpoint service.
        :param pulumi.Input[_builtins.str] status: The status of the VPC endpoint. The value can be **accepted**, **pendingAcceptance** or **rejected**.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the VPC endpoint.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of the VPC where the VPC endpoint is to be created. Changing
               this creates a new VPC endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] whitelists: Specifies the list of IP address or CIDR block which can be accessed to the
               VPC endpoint. This field is valid when `enable_whitelist` is set to **true**. The max length of whitelist is 20.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EndpointState.__new__(_EndpointState)

        __props__.__dict__["description"] = description
        __props__.__dict__["enable_dns"] = enable_dns
        __props__.__dict__["enable_whitelist"] = enable_whitelist
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["packet_id"] = packet_id
        __props__.__dict__["private_domain_name"] = private_domain_name
        __props__.__dict__["region"] = region
        __props__.__dict__["service_id"] = service_id
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["service_type"] = service_type
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["whitelists"] = whitelists
        return Endpoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the description of the VPC endpoint.

        Changing this creates a new VPC endpoint.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enableDns")
    def enable_dns(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to create a private domain name. The default value is
        true. Changing this creates a new VPC endpoint.
        """
        return pulumi.get(self, "enable_dns")

    @_builtins.property
    @pulumi.getter(name="enableWhitelist")
    def enable_whitelist(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable access control. The default value is
        false.
        """
        return pulumi.get(self, "enable_whitelist")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the IP address for accessing the associated VPC endpoint
        service. Only IPv4 addresses are supported. Changing this creates a new VPC endpoint.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the network ID of the subnet in the VPC specified by `vpc_id`.
        Changing this creates a new VPC endpoint.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="packetId")
    def packet_id(self) -> pulumi.Output[_builtins.int]:
        """
        The packet ID of the VPC endpoint.
        """
        return pulumi.get(self, "packet_id")

    @_builtins.property
    @pulumi.getter(name="privateDomainName")
    def private_domain_name(self) -> pulumi.Output[_builtins.str]:
        """
        The domain name for accessing the associated VPC endpoint service. This parameter is only
        available when enable_dns is set to true.
        """
        return pulumi.get(self, "private_domain_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the VPC endpoint. If omitted, the provider-level
        region will be used. Changing this creates a new VPC endpoint.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the VPC endpoint service.
        The VPC endpoint service could be private or public. Changing this creates a new VPC endpoint.
        """
        return pulumi.get(self, "service_id")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the VPC endpoint service.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the VPC endpoint service.
        """
        return pulumi.get(self, "service_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the VPC endpoint. The value can be **accepted**, **pendingAcceptance** or **rejected**.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The key/value pairs to associate with the VPC endpoint.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the VPC where the VPC endpoint is to be created. Changing
        this creates a new VPC endpoint.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter
    def whitelists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the list of IP address or CIDR block which can be accessed to the
        VPC endpoint. This field is valid when `enable_whitelist` is set to **true**. The max length of whitelist is 20.
        """
        return pulumi.get(self, "whitelists")

