# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ServiceConnection',
    'ServicePortMapping',
    'GetPublicServicesServiceResult',
]

@pulumi.output_type
class ServiceConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainId":
            suggest = "domain_id"
        elif key == "endpointId":
            suggest = "endpoint_id"
        elif key == "packetId":
            suggest = "packet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[_builtins.str] = None,
                 domain_id: Optional[_builtins.str] = None,
                 endpoint_id: Optional[_builtins.str] = None,
                 packet_id: Optional[_builtins.int] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str description: Specifies the description of the VPC endpoint service.
        :param _builtins.str domain_id: The user's domain ID.
        :param _builtins.str endpoint_id: The unique ID of the VPC endpoint.
        :param _builtins.int packet_id: The packet ID of the VPC endpoint.
        :param _builtins.str status: The connection status of the VPC endpoint.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_id is not None:
            pulumi.set(__self__, "domain_id", domain_id)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if packet_id is not None:
            pulumi.set(__self__, "packet_id", packet_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Specifies the description of the VPC endpoint service.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[_builtins.str]:
        """
        The user's domain ID.
        """
        return pulumi.get(self, "domain_id")

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[_builtins.str]:
        """
        The unique ID of the VPC endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @_builtins.property
    @pulumi.getter(name="packetId")
    def packet_id(self) -> Optional[_builtins.int]:
        """
        The packet ID of the VPC endpoint.
        """
        return pulumi.get(self, "packet_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The connection status of the VPC endpoint.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ServicePortMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "servicePort":
            suggest = "service_port"
        elif key == "terminalPort":
            suggest = "terminal_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePortMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePortMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePortMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protocol: Optional[_builtins.str] = None,
                 service_port: Optional[_builtins.int] = None,
                 terminal_port: Optional[_builtins.int] = None):
        """
        :param _builtins.str protocol: Specifies the protocol used in port mappings. Only **TCP** is supported.
        :param _builtins.int service_port: Specifies the port for accessing the VPC endpoint service. This port is provided by
               the backend service to provide services. The value ranges from 1 to 65535.
        :param _builtins.int terminal_port: Specifies the port for accessing the VPC endpoint. This port is provided by the VPC
               endpoint, allowing you to access the VPC endpoint service. The value ranges from 1 to 65535.
        """
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if service_port is not None:
            pulumi.set(__self__, "service_port", service_port)
        if terminal_port is not None:
            pulumi.set(__self__, "terminal_port", terminal_port)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        Specifies the protocol used in port mappings. Only **TCP** is supported.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="servicePort")
    def service_port(self) -> Optional[_builtins.int]:
        """
        Specifies the port for accessing the VPC endpoint service. This port is provided by
        the backend service to provide services. The value ranges from 1 to 65535.
        """
        return pulumi.get(self, "service_port")

    @_builtins.property
    @pulumi.getter(name="terminalPort")
    def terminal_port(self) -> Optional[_builtins.int]:
        """
        Specifies the port for accessing the VPC endpoint. This port is provided by the VPC
        endpoint, allowing you to access the VPC endpoint service. The value ranges from 1 to 65535.
        """
        return pulumi.get(self, "terminal_port")


@pulumi.output_type
class GetPublicServicesServiceResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 is_charge: _builtins.bool,
                 owner: _builtins.str,
                 service_name: _builtins.str,
                 service_type: _builtins.str):
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_charge", is_charge)
        pulumi.set(__self__, "owner", owner)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "service_type", service_type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isCharge")
    def is_charge(self) -> _builtins.bool:
        return pulumi.get(self, "is_charge")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> _builtins.str:
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> _builtins.str:
        return pulumi.get(self, "service_type")


