# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceArgs', 'Service']

@pulumi.input_type
class ServiceArgs:
    def __init__(__self__, *,
                 port_id: pulumi.Input[_builtins.str],
                 port_mappings: pulumi.Input[Sequence[pulumi.Input['ServicePortMappingArgs']]],
                 server_type: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 approval: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Service resource.
        :param pulumi.Input[_builtins.str] port_id: Specifies the ID for identifying the backend resource of the VPC endpoint service.
               + If the `server_type` is **VM**, the value is the NIC ID of the ECS where the VPC endpoint service is deployed.
               + If the `server_type` is **LB**, the value is the ID of the port bound to the private IP address of the load
               balancer.
        :param pulumi.Input[Sequence[pulumi.Input['ServicePortMappingArgs']]] port_mappings: Specifies the port mappings opened to the VPC endpoint service. Structure is
               documented below.
        :param pulumi.Input[_builtins.str] server_type: Specifies the backend resource type. The valid values are as follows:
               + **VM**: Indicates the cloud server, which can be used as a server.
               + **LB**: Indicates the shared load balancer, which is applicable to services with high access traffic and services
               that require high reliability and disaster recovery.
               
               Changing this creates a new VPC endpoint service.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of the VPC to which the backend resource of the VPC endpoint
               service belongs. Changing this creates a new VPC endpoint service.
        :param pulumi.Input[_builtins.bool] approval: Specifies whether connection approval is required. The default value is false.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the VPC endpoint service.
        :param pulumi.Input[_builtins.bool] enable_policy: Specifies whether the VPC endpoint policy is enabled. Defaults to **false**.
               Changing this creates a new VPC endpoint service resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the VPC endpoint service. The value contains a maximum of 16
               characters, including letters, digits, underscores (_), and hyphens (-).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] organization_permissions: Specifies the list of organizations to access the VPC endpoint service.
               The record is in the `organizations:orgPath::org_path` format, while `organizations:orgPath::*` allows all users in
               organizations to access the VPC endpoint service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permissions: Specifies the list of accounts to access the VPC endpoint service.
               The record is in the `iam:domain::domain_id` format, while `*` allows all users to access the VPC endpoint service.
        :param pulumi.Input[_builtins.str] region: The region in which to create the VPC endpoint service. If omitted, the
               provider-level region will be used. Changing this creates a new VPC endpoint service resource.
        :param pulumi.Input[_builtins.str] service_type: The type of the VPC endpoint service.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the VPC endpoint service.
        """
        pulumi.set(__self__, "port_id", port_id)
        pulumi.set(__self__, "port_mappings", port_mappings)
        pulumi.set(__self__, "server_type", server_type)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if approval is not None:
            pulumi.set(__self__, "approval", approval)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_policy is not None:
            pulumi.set(__self__, "enable_policy", enable_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_permissions is not None:
            pulumi.set(__self__, "organization_permissions", organization_permissions)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_type is not None:
            pulumi.set(__self__, "service_type", service_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="portId")
    def port_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID for identifying the backend resource of the VPC endpoint service.
        + If the `server_type` is **VM**, the value is the NIC ID of the ECS where the VPC endpoint service is deployed.
        + If the `server_type` is **LB**, the value is the ID of the port bound to the private IP address of the load
        balancer.
        """
        return pulumi.get(self, "port_id")

    @port_id.setter
    def port_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "port_id", value)

    @_builtins.property
    @pulumi.getter(name="portMappings")
    def port_mappings(self) -> pulumi.Input[Sequence[pulumi.Input['ServicePortMappingArgs']]]:
        """
        Specifies the port mappings opened to the VPC endpoint service. Structure is
        documented below.
        """
        return pulumi.get(self, "port_mappings")

    @port_mappings.setter
    def port_mappings(self, value: pulumi.Input[Sequence[pulumi.Input['ServicePortMappingArgs']]]):
        pulumi.set(self, "port_mappings", value)

    @_builtins.property
    @pulumi.getter(name="serverType")
    def server_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the backend resource type. The valid values are as follows:
        + **VM**: Indicates the cloud server, which can be used as a server.
        + **LB**: Indicates the shared load balancer, which is applicable to services with high access traffic and services
        that require high reliability and disaster recovery.

        Changing this creates a new VPC endpoint service.
        """
        return pulumi.get(self, "server_type")

    @server_type.setter
    def server_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "server_type", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the VPC to which the backend resource of the VPC endpoint
        service belongs. Changing this creates a new VPC endpoint service.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter
    def approval(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether connection approval is required. The default value is false.
        """
        return pulumi.get(self, "approval")

    @approval.setter
    def approval(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "approval", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the VPC endpoint service.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enablePolicy")
    def enable_policy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the VPC endpoint policy is enabled. Defaults to **false**.
        Changing this creates a new VPC endpoint service resource.
        """
        return pulumi.get(self, "enable_policy")

    @enable_policy.setter
    def enable_policy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_policy", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the VPC endpoint service. The value contains a maximum of 16
        characters, including letters, digits, underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="organizationPermissions")
    def organization_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of organizations to access the VPC endpoint service.
        The record is in the `organizations:orgPath::org_path` format, while `organizations:orgPath::*` allows all users in
        organizations to access the VPC endpoint service.
        """
        return pulumi.get(self, "organization_permissions")

    @organization_permissions.setter
    def organization_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "organization_permissions", value)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of accounts to access the VPC endpoint service.
        The record is in the `iam:domain::domain_id` format, while `*` allows all users to access the VPC endpoint service.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the VPC endpoint service. If omitted, the
        provider-level region will be used. Changing this creates a new VPC endpoint service resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the VPC endpoint service.
        """
        return pulumi.get(self, "service_type")

    @service_type.setter
    def service_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the VPC endpoint service.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ServiceState:
    def __init__(__self__, *,
                 approval: Optional[pulumi.Input[_builtins.bool]] = None,
                 connections: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceConnectionArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 port_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['ServicePortMappingArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 server_type: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Service resources.
        :param pulumi.Input[_builtins.bool] approval: Specifies whether connection approval is required. The default value is false.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceConnectionArgs']]] connections: An array of VPC endpoints connect to the VPC endpoint service. Structure is documented below.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the VPC endpoint service.
        :param pulumi.Input[_builtins.bool] enable_policy: Specifies whether the VPC endpoint policy is enabled. Defaults to **false**.
               Changing this creates a new VPC endpoint service resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the VPC endpoint service. The value contains a maximum of 16
               characters, including letters, digits, underscores (_), and hyphens (-).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] organization_permissions: Specifies the list of organizations to access the VPC endpoint service.
               The record is in the `organizations:orgPath::org_path` format, while `organizations:orgPath::*` allows all users in
               organizations to access the VPC endpoint service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permissions: Specifies the list of accounts to access the VPC endpoint service.
               The record is in the `iam:domain::domain_id` format, while `*` allows all users to access the VPC endpoint service.
        :param pulumi.Input[_builtins.str] port_id: Specifies the ID for identifying the backend resource of the VPC endpoint service.
               + If the `server_type` is **VM**, the value is the NIC ID of the ECS where the VPC endpoint service is deployed.
               + If the `server_type` is **LB**, the value is the ID of the port bound to the private IP address of the load
               balancer.
        :param pulumi.Input[Sequence[pulumi.Input['ServicePortMappingArgs']]] port_mappings: Specifies the port mappings opened to the VPC endpoint service. Structure is
               documented below.
        :param pulumi.Input[_builtins.str] region: The region in which to create the VPC endpoint service. If omitted, the
               provider-level region will be used. Changing this creates a new VPC endpoint service resource.
        :param pulumi.Input[_builtins.str] server_type: Specifies the backend resource type. The valid values are as follows:
               + **VM**: Indicates the cloud server, which can be used as a server.
               + **LB**: Indicates the shared load balancer, which is applicable to services with high access traffic and services
               that require high reliability and disaster recovery.
               
               Changing this creates a new VPC endpoint service.
        :param pulumi.Input[_builtins.str] service_name: The full name of the VPC endpoint service in the format: *region.name.id* or *region.id*.
        :param pulumi.Input[_builtins.str] service_type: The type of the VPC endpoint service.
        :param pulumi.Input[_builtins.str] status: The connection status of the VPC endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the VPC endpoint service.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of the VPC to which the backend resource of the VPC endpoint
               service belongs. Changing this creates a new VPC endpoint service.
        """
        if approval is not None:
            pulumi.set(__self__, "approval", approval)
        if connections is not None:
            pulumi.set(__self__, "connections", connections)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_policy is not None:
            pulumi.set(__self__, "enable_policy", enable_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_permissions is not None:
            pulumi.set(__self__, "organization_permissions", organization_permissions)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if port_id is not None:
            pulumi.set(__self__, "port_id", port_id)
        if port_mappings is not None:
            pulumi.set(__self__, "port_mappings", port_mappings)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if server_type is not None:
            pulumi.set(__self__, "server_type", server_type)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if service_type is not None:
            pulumi.set(__self__, "service_type", service_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def approval(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether connection approval is required. The default value is false.
        """
        return pulumi.get(self, "approval")

    @approval.setter
    def approval(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "approval", value)

    @_builtins.property
    @pulumi.getter
    def connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceConnectionArgs']]]]:
        """
        An array of VPC endpoints connect to the VPC endpoint service. Structure is documented below.
        """
        return pulumi.get(self, "connections")

    @connections.setter
    def connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceConnectionArgs']]]]):
        pulumi.set(self, "connections", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the VPC endpoint service.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enablePolicy")
    def enable_policy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the VPC endpoint policy is enabled. Defaults to **false**.
        Changing this creates a new VPC endpoint service resource.
        """
        return pulumi.get(self, "enable_policy")

    @enable_policy.setter
    def enable_policy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_policy", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the VPC endpoint service. The value contains a maximum of 16
        characters, including letters, digits, underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="organizationPermissions")
    def organization_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of organizations to access the VPC endpoint service.
        The record is in the `organizations:orgPath::org_path` format, while `organizations:orgPath::*` allows all users in
        organizations to access the VPC endpoint service.
        """
        return pulumi.get(self, "organization_permissions")

    @organization_permissions.setter
    def organization_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "organization_permissions", value)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of accounts to access the VPC endpoint service.
        The record is in the `iam:domain::domain_id` format, while `*` allows all users to access the VPC endpoint service.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter(name="portId")
    def port_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID for identifying the backend resource of the VPC endpoint service.
        + If the `server_type` is **VM**, the value is the NIC ID of the ECS where the VPC endpoint service is deployed.
        + If the `server_type` is **LB**, the value is the ID of the port bound to the private IP address of the load
        balancer.
        """
        return pulumi.get(self, "port_id")

    @port_id.setter
    def port_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port_id", value)

    @_builtins.property
    @pulumi.getter(name="portMappings")
    def port_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServicePortMappingArgs']]]]:
        """
        Specifies the port mappings opened to the VPC endpoint service. Structure is
        documented below.
        """
        return pulumi.get(self, "port_mappings")

    @port_mappings.setter
    def port_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServicePortMappingArgs']]]]):
        pulumi.set(self, "port_mappings", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the VPC endpoint service. If omitted, the
        provider-level region will be used. Changing this creates a new VPC endpoint service resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="serverType")
    def server_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the backend resource type. The valid values are as follows:
        + **VM**: Indicates the cloud server, which can be used as a server.
        + **LB**: Indicates the shared load balancer, which is applicable to services with high access traffic and services
        that require high reliability and disaster recovery.

        Changing this creates a new VPC endpoint service.
        """
        return pulumi.get(self, "server_type")

    @server_type.setter
    def server_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_type", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full name of the VPC endpoint service in the format: *region.name.id* or *region.id*.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the VPC endpoint service.
        """
        return pulumi.get(self, "service_type")

    @service_type.setter
    def service_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_type", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection status of the VPC endpoint.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the VPC endpoint service.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the VPC to which the backend resource of the VPC endpoint
        service belongs. Changing this creates a new VPC endpoint service.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("sbercloud:Vpcep/service:Service")
class Service(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approval: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 port_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServicePortMappingArgs', 'ServicePortMappingArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 server_type: Optional[pulumi.Input[_builtins.str]] = None,
                 service_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to manage a VPC endpoint service resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        vm_port = config.require_object("vmPort")
        demo = sbercloud.vpcep.Service("demo",
            name="demo-service",
            server_type="VM",
            vpc_id=vpc_id,
            port_id=vm_port,
            description="test description",
            port_mappings=[{
                "service_port": 8080,
                "terminal_port": 80,
            }])
        ```

        ## Import

        VPC endpoint services can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Vpcep/service:Service test_service <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] approval: Specifies whether connection approval is required. The default value is false.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the VPC endpoint service.
        :param pulumi.Input[_builtins.bool] enable_policy: Specifies whether the VPC endpoint policy is enabled. Defaults to **false**.
               Changing this creates a new VPC endpoint service resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the VPC endpoint service. The value contains a maximum of 16
               characters, including letters, digits, underscores (_), and hyphens (-).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] organization_permissions: Specifies the list of organizations to access the VPC endpoint service.
               The record is in the `organizations:orgPath::org_path` format, while `organizations:orgPath::*` allows all users in
               organizations to access the VPC endpoint service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permissions: Specifies the list of accounts to access the VPC endpoint service.
               The record is in the `iam:domain::domain_id` format, while `*` allows all users to access the VPC endpoint service.
        :param pulumi.Input[_builtins.str] port_id: Specifies the ID for identifying the backend resource of the VPC endpoint service.
               + If the `server_type` is **VM**, the value is the NIC ID of the ECS where the VPC endpoint service is deployed.
               + If the `server_type` is **LB**, the value is the ID of the port bound to the private IP address of the load
               balancer.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServicePortMappingArgs', 'ServicePortMappingArgsDict']]]] port_mappings: Specifies the port mappings opened to the VPC endpoint service. Structure is
               documented below.
        :param pulumi.Input[_builtins.str] region: The region in which to create the VPC endpoint service. If omitted, the
               provider-level region will be used. Changing this creates a new VPC endpoint service resource.
        :param pulumi.Input[_builtins.str] server_type: Specifies the backend resource type. The valid values are as follows:
               + **VM**: Indicates the cloud server, which can be used as a server.
               + **LB**: Indicates the shared load balancer, which is applicable to services with high access traffic and services
               that require high reliability and disaster recovery.
               
               Changing this creates a new VPC endpoint service.
        :param pulumi.Input[_builtins.str] service_type: The type of the VPC endpoint service.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the VPC endpoint service.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of the VPC to which the backend resource of the VPC endpoint
               service belongs. Changing this creates a new VPC endpoint service.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage a VPC endpoint service resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        vm_port = config.require_object("vmPort")
        demo = sbercloud.vpcep.Service("demo",
            name="demo-service",
            server_type="VM",
            vpc_id=vpc_id,
            port_id=vm_port,
            description="test description",
            port_mappings=[{
                "service_port": 8080,
                "terminal_port": 80,
            }])
        ```

        ## Import

        VPC endpoint services can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Vpcep/service:Service test_service <id>
        ```

        :param str resource_name: The name of the resource.
        :param ServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approval: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 port_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServicePortMappingArgs', 'ServicePortMappingArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 server_type: Optional[pulumi.Input[_builtins.str]] = None,
                 service_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceArgs.__new__(ServiceArgs)

            __props__.__dict__["approval"] = approval
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_policy"] = enable_policy
            __props__.__dict__["name"] = name
            __props__.__dict__["organization_permissions"] = organization_permissions
            __props__.__dict__["permissions"] = permissions
            if port_id is None and not opts.urn:
                raise TypeError("Missing required property 'port_id'")
            __props__.__dict__["port_id"] = port_id
            if port_mappings is None and not opts.urn:
                raise TypeError("Missing required property 'port_mappings'")
            __props__.__dict__["port_mappings"] = port_mappings
            __props__.__dict__["region"] = region
            if server_type is None and not opts.urn:
                raise TypeError("Missing required property 'server_type'")
            __props__.__dict__["server_type"] = server_type
            __props__.__dict__["service_type"] = service_type
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["connections"] = None
            __props__.__dict__["service_name"] = None
            __props__.__dict__["status"] = None
        super(Service, __self__).__init__(
            'sbercloud:Vpcep/service:Service',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            approval: Optional[pulumi.Input[_builtins.bool]] = None,
            connections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceConnectionArgs', 'ServiceConnectionArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enable_policy: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            organization_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            port_id: Optional[pulumi.Input[_builtins.str]] = None,
            port_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServicePortMappingArgs', 'ServicePortMappingArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            server_type: Optional[pulumi.Input[_builtins.str]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            service_type: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Service':
        """
        Get an existing Service resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] approval: Specifies whether connection approval is required. The default value is false.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceConnectionArgs', 'ServiceConnectionArgsDict']]]] connections: An array of VPC endpoints connect to the VPC endpoint service. Structure is documented below.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the VPC endpoint service.
        :param pulumi.Input[_builtins.bool] enable_policy: Specifies whether the VPC endpoint policy is enabled. Defaults to **false**.
               Changing this creates a new VPC endpoint service resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the VPC endpoint service. The value contains a maximum of 16
               characters, including letters, digits, underscores (_), and hyphens (-).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] organization_permissions: Specifies the list of organizations to access the VPC endpoint service.
               The record is in the `organizations:orgPath::org_path` format, while `organizations:orgPath::*` allows all users in
               organizations to access the VPC endpoint service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permissions: Specifies the list of accounts to access the VPC endpoint service.
               The record is in the `iam:domain::domain_id` format, while `*` allows all users to access the VPC endpoint service.
        :param pulumi.Input[_builtins.str] port_id: Specifies the ID for identifying the backend resource of the VPC endpoint service.
               + If the `server_type` is **VM**, the value is the NIC ID of the ECS where the VPC endpoint service is deployed.
               + If the `server_type` is **LB**, the value is the ID of the port bound to the private IP address of the load
               balancer.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServicePortMappingArgs', 'ServicePortMappingArgsDict']]]] port_mappings: Specifies the port mappings opened to the VPC endpoint service. Structure is
               documented below.
        :param pulumi.Input[_builtins.str] region: The region in which to create the VPC endpoint service. If omitted, the
               provider-level region will be used. Changing this creates a new VPC endpoint service resource.
        :param pulumi.Input[_builtins.str] server_type: Specifies the backend resource type. The valid values are as follows:
               + **VM**: Indicates the cloud server, which can be used as a server.
               + **LB**: Indicates the shared load balancer, which is applicable to services with high access traffic and services
               that require high reliability and disaster recovery.
               
               Changing this creates a new VPC endpoint service.
        :param pulumi.Input[_builtins.str] service_name: The full name of the VPC endpoint service in the format: *region.name.id* or *region.id*.
        :param pulumi.Input[_builtins.str] service_type: The type of the VPC endpoint service.
        :param pulumi.Input[_builtins.str] status: The connection status of the VPC endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the VPC endpoint service.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of the VPC to which the backend resource of the VPC endpoint
               service belongs. Changing this creates a new VPC endpoint service.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceState.__new__(_ServiceState)

        __props__.__dict__["approval"] = approval
        __props__.__dict__["connections"] = connections
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_policy"] = enable_policy
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_permissions"] = organization_permissions
        __props__.__dict__["permissions"] = permissions
        __props__.__dict__["port_id"] = port_id
        __props__.__dict__["port_mappings"] = port_mappings
        __props__.__dict__["region"] = region
        __props__.__dict__["server_type"] = server_type
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["service_type"] = service_type
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_id"] = vpc_id
        return Service(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def approval(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether connection approval is required. The default value is false.
        """
        return pulumi.get(self, "approval")

    @_builtins.property
    @pulumi.getter
    def connections(self) -> pulumi.Output[Sequence['outputs.ServiceConnection']]:
        """
        An array of VPC endpoints connect to the VPC endpoint service. Structure is documented below.
        """
        return pulumi.get(self, "connections")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the description of the VPC endpoint service.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enablePolicy")
    def enable_policy(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether the VPC endpoint policy is enabled. Defaults to **false**.
        Changing this creates a new VPC endpoint service resource.
        """
        return pulumi.get(self, "enable_policy")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the VPC endpoint service. The value contains a maximum of 16
        characters, including letters, digits, underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationPermissions")
    def organization_permissions(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the list of organizations to access the VPC endpoint service.
        The record is in the `organizations:orgPath::org_path` format, while `organizations:orgPath::*` allows all users in
        organizations to access the VPC endpoint service.
        """
        return pulumi.get(self, "organization_permissions")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the list of accounts to access the VPC endpoint service.
        The record is in the `iam:domain::domain_id` format, while `*` allows all users to access the VPC endpoint service.
        """
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter(name="portId")
    def port_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID for identifying the backend resource of the VPC endpoint service.
        + If the `server_type` is **VM**, the value is the NIC ID of the ECS where the VPC endpoint service is deployed.
        + If the `server_type` is **LB**, the value is the ID of the port bound to the private IP address of the load
        balancer.
        """
        return pulumi.get(self, "port_id")

    @_builtins.property
    @pulumi.getter(name="portMappings")
    def port_mappings(self) -> pulumi.Output[Sequence['outputs.ServicePortMapping']]:
        """
        Specifies the port mappings opened to the VPC endpoint service. Structure is
        documented below.
        """
        return pulumi.get(self, "port_mappings")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the VPC endpoint service. If omitted, the
        provider-level region will be used. Changing this creates a new VPC endpoint service resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="serverType")
    def server_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the backend resource type. The valid values are as follows:
        + **VM**: Indicates the cloud server, which can be used as a server.
        + **LB**: Indicates the shared load balancer, which is applicable to services with high access traffic and services
        that require high reliability and disaster recovery.

        Changing this creates a new VPC endpoint service.
        """
        return pulumi.get(self, "server_type")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        The full name of the VPC endpoint service in the format: *region.name.id* or *region.id*.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of the VPC endpoint service.
        """
        return pulumi.get(self, "service_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The connection status of the VPC endpoint.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The key/value pairs to associate with the VPC endpoint service.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the VPC to which the backend resource of the VPC endpoint
        service belongs. Changing this creates a new VPC endpoint service.
        """
        return pulumi.get(self, "vpc_id")

