# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VpnConnectionArgs', 'VpnConnection']

@pulumi.input_type
class VpnConnectionArgs:
    def __init__(__self__, *,
                 customer_gateway_id: pulumi.Input[_builtins.str],
                 gateway_id: pulumi.Input[_builtins.str],
                 gateway_ip: pulumi.Input[_builtins.str],
                 psk: pulumi.Input[_builtins.str],
                 vpn_type: pulumi.Input[_builtins.str],
                 enable_nqa: Optional[pulumi.Input[_builtins.bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ha_role: Optional[pulumi.Input[_builtins.str]] = None,
                 ikepolicy: Optional[pulumi.Input['VpnConnectionIkepolicyArgs']] = None,
                 ipsecpolicy: Optional[pulumi.Input['VpnConnectionIpsecpolicyArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 policy_rules: Optional[pulumi.Input[Sequence[pulumi.Input['VpnConnectionPolicyRuleArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tunnel_local_address: Optional[pulumi.Input[_builtins.str]] = None,
                 tunnel_peer_address: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a VpnConnection resource.
        :param pulumi.Input[_builtins.str] customer_gateway_id: The customer gateway ID.
        :param pulumi.Input[_builtins.str] gateway_id: The VPN gateway ID.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] gateway_ip: The VPN gateway IP ID.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] psk: The pre-shared key.
        :param pulumi.Input[_builtins.str] vpn_type: The connection type. The value can be **policy**, **static** or **bgp**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] enable_nqa: Whether to enable NQA check. Defaults to **false**.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project ID.
        :param pulumi.Input[_builtins.str] ha_role: Specifies the mode of the VPN connection.
               The valid values are **master** and **slave**, defaults to **master**.
               This parameter is optional when you create a connection for a VPN gateway in **active-active** mode.
               When you create a connection for a VPN gateway in **active-standby** mode, **master** indicates
               the active connection, and **slave** indicates the standby connection.
               In **active-active** mode, this field must be set to **master** for the connection established
               using the active EIP or active private IP address of the VPN gateway, and must be set to **slave**
               for the connection established using active EIP 2 or active private IP address 2 of the VPN gateway.
               
               Changing this parameter will create a new resource.
               
               <a name="Connection_CreateRequestIkePolicy"></a>
               The `ikepolicy` block supports:
        :param pulumi.Input['VpnConnectionIkepolicyArgs'] ikepolicy: The IKE policy configurations.
               The ikepolicy structure is documented below.
        :param pulumi.Input['VpnConnectionIpsecpolicyArgs'] ipsecpolicy: The IPsec policy configurations.
               The ipsecpolicy structure is documented below.
        :param pulumi.Input[_builtins.str] name: The name of the VPN connection.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] peer_subnets: The CIDR list of customer subnets. This parameter must be empty
               when the `attachment_type` of the VPN gateway is set to **er** and `vpn_type` is set to **policy** or **bgp**.
               This parameter is mandatory in other scenarios.
        :param pulumi.Input[Sequence[pulumi.Input['VpnConnectionPolicyRuleArgs']]] policy_rules: The policy rules. Only works when vpn_type is set to **policy**
               The policy_rules structure is documented below.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the tags of the VPN connection.
        :param pulumi.Input[_builtins.str] tunnel_local_address: The local tunnel address.
        :param pulumi.Input[_builtins.str] tunnel_peer_address: The peer tunnel address.
        """
        pulumi.set(__self__, "customer_gateway_id", customer_gateway_id)
        pulumi.set(__self__, "gateway_id", gateway_id)
        pulumi.set(__self__, "gateway_ip", gateway_ip)
        pulumi.set(__self__, "psk", psk)
        pulumi.set(__self__, "vpn_type", vpn_type)
        if enable_nqa is not None:
            pulumi.set(__self__, "enable_nqa", enable_nqa)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if ha_role is not None:
            pulumi.set(__self__, "ha_role", ha_role)
        if ikepolicy is not None:
            pulumi.set(__self__, "ikepolicy", ikepolicy)
        if ipsecpolicy is not None:
            pulumi.set(__self__, "ipsecpolicy", ipsecpolicy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_subnets is not None:
            pulumi.set(__self__, "peer_subnets", peer_subnets)
        if policy_rules is not None:
            pulumi.set(__self__, "policy_rules", policy_rules)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tunnel_local_address is not None:
            pulumi.set(__self__, "tunnel_local_address", tunnel_local_address)
        if tunnel_peer_address is not None:
            pulumi.set(__self__, "tunnel_peer_address", tunnel_peer_address)

    @_builtins.property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> pulumi.Input[_builtins.str]:
        """
        The customer gateway ID.
        """
        return pulumi.get(self, "customer_gateway_id")

    @customer_gateway_id.setter
    def customer_gateway_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "customer_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> pulumi.Input[_builtins.str]:
        """
        The VPN gateway ID.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "gateway_id")

    @gateway_id.setter
    def gateway_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="gatewayIp")
    def gateway_ip(self) -> pulumi.Input[_builtins.str]:
        """
        The VPN gateway IP ID.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "gateway_ip")

    @gateway_ip.setter
    def gateway_ip(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "gateway_ip", value)

    @_builtins.property
    @pulumi.getter
    def psk(self) -> pulumi.Input[_builtins.str]:
        """
        The pre-shared key.
        """
        return pulumi.get(self, "psk")

    @psk.setter
    def psk(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "psk", value)

    @_builtins.property
    @pulumi.getter(name="vpnType")
    def vpn_type(self) -> pulumi.Input[_builtins.str]:
        """
        The connection type. The value can be **policy**, **static** or **bgp**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpn_type")

    @vpn_type.setter
    def vpn_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpn_type", value)

    @_builtins.property
    @pulumi.getter(name="enableNqa")
    def enable_nqa(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable NQA check. Defaults to **false**.
        """
        return pulumi.get(self, "enable_nqa")

    @enable_nqa.setter
    def enable_nqa(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_nqa", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project ID.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="haRole")
    def ha_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the mode of the VPN connection.
        The valid values are **master** and **slave**, defaults to **master**.
        This parameter is optional when you create a connection for a VPN gateway in **active-active** mode.
        When you create a connection for a VPN gateway in **active-standby** mode, **master** indicates
        the active connection, and **slave** indicates the standby connection.
        In **active-active** mode, this field must be set to **master** for the connection established
        using the active EIP or active private IP address of the VPN gateway, and must be set to **slave**
        for the connection established using active EIP 2 or active private IP address 2 of the VPN gateway.

        Changing this parameter will create a new resource.

        <a name="Connection_CreateRequestIkePolicy"></a>
        The `ikepolicy` block supports:
        """
        return pulumi.get(self, "ha_role")

    @ha_role.setter
    def ha_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ha_role", value)

    @_builtins.property
    @pulumi.getter
    def ikepolicy(self) -> Optional[pulumi.Input['VpnConnectionIkepolicyArgs']]:
        """
        The IKE policy configurations.
        The ikepolicy structure is documented below.
        """
        return pulumi.get(self, "ikepolicy")

    @ikepolicy.setter
    def ikepolicy(self, value: Optional[pulumi.Input['VpnConnectionIkepolicyArgs']]):
        pulumi.set(self, "ikepolicy", value)

    @_builtins.property
    @pulumi.getter
    def ipsecpolicy(self) -> Optional[pulumi.Input['VpnConnectionIpsecpolicyArgs']]:
        """
        The IPsec policy configurations.
        The ipsecpolicy structure is documented below.
        """
        return pulumi.get(self, "ipsecpolicy")

    @ipsecpolicy.setter
    def ipsecpolicy(self, value: Optional[pulumi.Input['VpnConnectionIpsecpolicyArgs']]):
        pulumi.set(self, "ipsecpolicy", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the VPN connection.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="peerSubnets")
    def peer_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The CIDR list of customer subnets. This parameter must be empty
        when the `attachment_type` of the VPN gateway is set to **er** and `vpn_type` is set to **policy** or **bgp**.
        This parameter is mandatory in other scenarios.
        """
        return pulumi.get(self, "peer_subnets")

    @peer_subnets.setter
    def peer_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "peer_subnets", value)

    @_builtins.property
    @pulumi.getter(name="policyRules")
    def policy_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnConnectionPolicyRuleArgs']]]]:
        """
        The policy rules. Only works when vpn_type is set to **policy**
        The policy_rules structure is documented below.
        """
        return pulumi.get(self, "policy_rules")

    @policy_rules.setter
    def policy_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnConnectionPolicyRuleArgs']]]]):
        pulumi.set(self, "policy_rules", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the tags of the VPN connection.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tunnelLocalAddress")
    def tunnel_local_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The local tunnel address.
        """
        return pulumi.get(self, "tunnel_local_address")

    @tunnel_local_address.setter
    def tunnel_local_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tunnel_local_address", value)

    @_builtins.property
    @pulumi.getter(name="tunnelPeerAddress")
    def tunnel_peer_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The peer tunnel address.
        """
        return pulumi.get(self, "tunnel_peer_address")

    @tunnel_peer_address.setter
    def tunnel_peer_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tunnel_peer_address", value)


@pulumi.input_type
class _VpnConnectionState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_nqa: Optional[pulumi.Input[_builtins.bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 ha_role: Optional[pulumi.Input[_builtins.str]] = None,
                 ikepolicy: Optional[pulumi.Input['VpnConnectionIkepolicyArgs']] = None,
                 ipsecpolicy: Optional[pulumi.Input['VpnConnectionIpsecpolicyArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 policy_rules: Optional[pulumi.Input[Sequence[pulumi.Input['VpnConnectionPolicyRuleArgs']]]] = None,
                 psk: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tunnel_local_address: Optional[pulumi.Input[_builtins.str]] = None,
                 tunnel_peer_address: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VpnConnection resources.
        :param pulumi.Input[_builtins.str] created_at: The create time.
        :param pulumi.Input[_builtins.str] customer_gateway_id: The customer gateway ID.
        :param pulumi.Input[_builtins.bool] enable_nqa: Whether to enable NQA check. Defaults to **false**.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project ID.
        :param pulumi.Input[_builtins.str] gateway_id: The VPN gateway ID.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] gateway_ip: The VPN gateway IP ID.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] ha_role: Specifies the mode of the VPN connection.
               The valid values are **master** and **slave**, defaults to **master**.
               This parameter is optional when you create a connection for a VPN gateway in **active-active** mode.
               When you create a connection for a VPN gateway in **active-standby** mode, **master** indicates
               the active connection, and **slave** indicates the standby connection.
               In **active-active** mode, this field must be set to **master** for the connection established
               using the active EIP or active private IP address of the VPN gateway, and must be set to **slave**
               for the connection established using active EIP 2 or active private IP address 2 of the VPN gateway.
               
               Changing this parameter will create a new resource.
               
               <a name="Connection_CreateRequestIkePolicy"></a>
               The `ikepolicy` block supports:
        :param pulumi.Input['VpnConnectionIkepolicyArgs'] ikepolicy: The IKE policy configurations.
               The ikepolicy structure is documented below.
        :param pulumi.Input['VpnConnectionIpsecpolicyArgs'] ipsecpolicy: The IPsec policy configurations.
               The ipsecpolicy structure is documented below.
        :param pulumi.Input[_builtins.str] name: The name of the VPN connection.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] peer_subnets: The CIDR list of customer subnets. This parameter must be empty
               when the `attachment_type` of the VPN gateway is set to **er** and `vpn_type` is set to **policy** or **bgp**.
               This parameter is mandatory in other scenarios.
        :param pulumi.Input[Sequence[pulumi.Input['VpnConnectionPolicyRuleArgs']]] policy_rules: The policy rules. Only works when vpn_type is set to **policy**
               The policy_rules structure is documented below.
        :param pulumi.Input[_builtins.str] psk: The pre-shared key.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] status: The status of the VPN connection.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the tags of the VPN connection.
        :param pulumi.Input[_builtins.str] tunnel_local_address: The local tunnel address.
        :param pulumi.Input[_builtins.str] tunnel_peer_address: The peer tunnel address.
        :param pulumi.Input[_builtins.str] updated_at: The update time.
        :param pulumi.Input[_builtins.str] vpn_type: The connection type. The value can be **policy**, **static** or **bgp**.
               
               Changing this parameter will create a new resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if customer_gateway_id is not None:
            pulumi.set(__self__, "customer_gateway_id", customer_gateway_id)
        if enable_nqa is not None:
            pulumi.set(__self__, "enable_nqa", enable_nqa)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if gateway_id is not None:
            pulumi.set(__self__, "gateway_id", gateway_id)
        if gateway_ip is not None:
            pulumi.set(__self__, "gateway_ip", gateway_ip)
        if ha_role is not None:
            pulumi.set(__self__, "ha_role", ha_role)
        if ikepolicy is not None:
            pulumi.set(__self__, "ikepolicy", ikepolicy)
        if ipsecpolicy is not None:
            pulumi.set(__self__, "ipsecpolicy", ipsecpolicy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_subnets is not None:
            pulumi.set(__self__, "peer_subnets", peer_subnets)
        if policy_rules is not None:
            pulumi.set(__self__, "policy_rules", policy_rules)
        if psk is not None:
            pulumi.set(__self__, "psk", psk)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tunnel_local_address is not None:
            pulumi.set(__self__, "tunnel_local_address", tunnel_local_address)
        if tunnel_peer_address is not None:
            pulumi.set(__self__, "tunnel_peer_address", tunnel_peer_address)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if vpn_type is not None:
            pulumi.set(__self__, "vpn_type", vpn_type)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The create time.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The customer gateway ID.
        """
        return pulumi.get(self, "customer_gateway_id")

    @customer_gateway_id.setter
    def customer_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "customer_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="enableNqa")
    def enable_nqa(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable NQA check. Defaults to **false**.
        """
        return pulumi.get(self, "enable_nqa")

    @enable_nqa.setter
    def enable_nqa(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_nqa", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project ID.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPN gateway ID.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "gateway_id")

    @gateway_id.setter
    def gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="gatewayIp")
    def gateway_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPN gateway IP ID.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "gateway_ip")

    @gateway_ip.setter
    def gateway_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_ip", value)

    @_builtins.property
    @pulumi.getter(name="haRole")
    def ha_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the mode of the VPN connection.
        The valid values are **master** and **slave**, defaults to **master**.
        This parameter is optional when you create a connection for a VPN gateway in **active-active** mode.
        When you create a connection for a VPN gateway in **active-standby** mode, **master** indicates
        the active connection, and **slave** indicates the standby connection.
        In **active-active** mode, this field must be set to **master** for the connection established
        using the active EIP or active private IP address of the VPN gateway, and must be set to **slave**
        for the connection established using active EIP 2 or active private IP address 2 of the VPN gateway.

        Changing this parameter will create a new resource.

        <a name="Connection_CreateRequestIkePolicy"></a>
        The `ikepolicy` block supports:
        """
        return pulumi.get(self, "ha_role")

    @ha_role.setter
    def ha_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ha_role", value)

    @_builtins.property
    @pulumi.getter
    def ikepolicy(self) -> Optional[pulumi.Input['VpnConnectionIkepolicyArgs']]:
        """
        The IKE policy configurations.
        The ikepolicy structure is documented below.
        """
        return pulumi.get(self, "ikepolicy")

    @ikepolicy.setter
    def ikepolicy(self, value: Optional[pulumi.Input['VpnConnectionIkepolicyArgs']]):
        pulumi.set(self, "ikepolicy", value)

    @_builtins.property
    @pulumi.getter
    def ipsecpolicy(self) -> Optional[pulumi.Input['VpnConnectionIpsecpolicyArgs']]:
        """
        The IPsec policy configurations.
        The ipsecpolicy structure is documented below.
        """
        return pulumi.get(self, "ipsecpolicy")

    @ipsecpolicy.setter
    def ipsecpolicy(self, value: Optional[pulumi.Input['VpnConnectionIpsecpolicyArgs']]):
        pulumi.set(self, "ipsecpolicy", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the VPN connection.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="peerSubnets")
    def peer_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The CIDR list of customer subnets. This parameter must be empty
        when the `attachment_type` of the VPN gateway is set to **er** and `vpn_type` is set to **policy** or **bgp**.
        This parameter is mandatory in other scenarios.
        """
        return pulumi.get(self, "peer_subnets")

    @peer_subnets.setter
    def peer_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "peer_subnets", value)

    @_builtins.property
    @pulumi.getter(name="policyRules")
    def policy_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnConnectionPolicyRuleArgs']]]]:
        """
        The policy rules. Only works when vpn_type is set to **policy**
        The policy_rules structure is documented below.
        """
        return pulumi.get(self, "policy_rules")

    @policy_rules.setter
    def policy_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnConnectionPolicyRuleArgs']]]]):
        pulumi.set(self, "policy_rules", value)

    @_builtins.property
    @pulumi.getter
    def psk(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The pre-shared key.
        """
        return pulumi.get(self, "psk")

    @psk.setter
    def psk(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "psk", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the VPN connection.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the tags of the VPN connection.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tunnelLocalAddress")
    def tunnel_local_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The local tunnel address.
        """
        return pulumi.get(self, "tunnel_local_address")

    @tunnel_local_address.setter
    def tunnel_local_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tunnel_local_address", value)

    @_builtins.property
    @pulumi.getter(name="tunnelPeerAddress")
    def tunnel_peer_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The peer tunnel address.
        """
        return pulumi.get(self, "tunnel_peer_address")

    @tunnel_peer_address.setter
    def tunnel_peer_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tunnel_peer_address", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The update time.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="vpnType")
    def vpn_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection type. The value can be **policy**, **static** or **bgp**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpn_type")

    @vpn_type.setter
    def vpn_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpn_type", value)


@pulumi.type_token("sbercloud:index/vpnConnection:VpnConnection")
class VpnConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customer_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_nqa: Optional[pulumi.Input[_builtins.bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 ha_role: Optional[pulumi.Input[_builtins.str]] = None,
                 ikepolicy: Optional[pulumi.Input[Union['VpnConnectionIkepolicyArgs', 'VpnConnectionIkepolicyArgsDict']]] = None,
                 ipsecpolicy: Optional[pulumi.Input[Union['VpnConnectionIpsecpolicyArgs', 'VpnConnectionIpsecpolicyArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 policy_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnConnectionPolicyRuleArgs', 'VpnConnectionPolicyRuleArgsDict']]]]] = None,
                 psk: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tunnel_local_address: Optional[pulumi.Input[_builtins.str]] = None,
                 tunnel_peer_address: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a VPN connection resource within SberCloud.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        name = config.require_object("name")
        peer_subnet = config.require_object("peerSubnet")
        gateway_id = config.require_object("gatewayId")
        gateway_ip = config.require_object("gatewayIp")
        customer_gateway_id = config.require_object("customerGatewayId")
        test = sbercloud.VpnConnection("test",
            name=name,
            gateway_id=gateway_id,
            gateway_ip=gateway_ip,
            customer_gateway_id=customer_gateway_id,
            peer_subnets=[peer_subnet],
            vpn_type="static",
            psk="Test@123")
        ```

        ### VPN connection with policy

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        name = config.require_object("name")
        peer_subnet = config.require_object("peerSubnet")
        gateway_id = config.require_object("gatewayId")
        gateway_ip = config.require_object("gatewayIp")
        customer_gateway_id = config.require_object("customerGatewayId")
        test = sbercloud.VpnConnection("test",
            name=name,
            gateway_id=gateway_id,
            gateway_ip=gateway_ip,
            customer_gateway_id=customer_gateway_id,
            peer_subnets=[peer_subnet],
            vpn_type="static",
            psk="Test@123",
            ikepolicy={
                "authentication_algorithm": "sha2-256",
                "authentication_method": "pre-share",
                "encryption_algorithm": "aes-128",
                "ike_version": "v2",
                "lifetime_seconds": 86400,
                "pfs": "group14",
            },
            ipsecpolicy={
                "authentication_algorithm": "sha2-256",
                "encapsulation_mode": "tunnel",
                "encryption_algorithm": "aes-128",
                "lifetime_seconds": 3600,
                "pfs": "group14",
                "transform_protocol": "esp",
            })
        ```

        ## Import

        The connection can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/vpnConnection:VpnConnection test <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] customer_gateway_id: The customer gateway ID.
        :param pulumi.Input[_builtins.bool] enable_nqa: Whether to enable NQA check. Defaults to **false**.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project ID.
        :param pulumi.Input[_builtins.str] gateway_id: The VPN gateway ID.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] gateway_ip: The VPN gateway IP ID.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] ha_role: Specifies the mode of the VPN connection.
               The valid values are **master** and **slave**, defaults to **master**.
               This parameter is optional when you create a connection for a VPN gateway in **active-active** mode.
               When you create a connection for a VPN gateway in **active-standby** mode, **master** indicates
               the active connection, and **slave** indicates the standby connection.
               In **active-active** mode, this field must be set to **master** for the connection established
               using the active EIP or active private IP address of the VPN gateway, and must be set to **slave**
               for the connection established using active EIP 2 or active private IP address 2 of the VPN gateway.
               
               Changing this parameter will create a new resource.
               
               <a name="Connection_CreateRequestIkePolicy"></a>
               The `ikepolicy` block supports:
        :param pulumi.Input[Union['VpnConnectionIkepolicyArgs', 'VpnConnectionIkepolicyArgsDict']] ikepolicy: The IKE policy configurations.
               The ikepolicy structure is documented below.
        :param pulumi.Input[Union['VpnConnectionIpsecpolicyArgs', 'VpnConnectionIpsecpolicyArgsDict']] ipsecpolicy: The IPsec policy configurations.
               The ipsecpolicy structure is documented below.
        :param pulumi.Input[_builtins.str] name: The name of the VPN connection.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] peer_subnets: The CIDR list of customer subnets. This parameter must be empty
               when the `attachment_type` of the VPN gateway is set to **er** and `vpn_type` is set to **policy** or **bgp**.
               This parameter is mandatory in other scenarios.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpnConnectionPolicyRuleArgs', 'VpnConnectionPolicyRuleArgsDict']]]] policy_rules: The policy rules. Only works when vpn_type is set to **policy**
               The policy_rules structure is documented below.
        :param pulumi.Input[_builtins.str] psk: The pre-shared key.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the tags of the VPN connection.
        :param pulumi.Input[_builtins.str] tunnel_local_address: The local tunnel address.
        :param pulumi.Input[_builtins.str] tunnel_peer_address: The peer tunnel address.
        :param pulumi.Input[_builtins.str] vpn_type: The connection type. The value can be **policy**, **static** or **bgp**.
               
               Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpnConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a VPN connection resource within SberCloud.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        name = config.require_object("name")
        peer_subnet = config.require_object("peerSubnet")
        gateway_id = config.require_object("gatewayId")
        gateway_ip = config.require_object("gatewayIp")
        customer_gateway_id = config.require_object("customerGatewayId")
        test = sbercloud.VpnConnection("test",
            name=name,
            gateway_id=gateway_id,
            gateway_ip=gateway_ip,
            customer_gateway_id=customer_gateway_id,
            peer_subnets=[peer_subnet],
            vpn_type="static",
            psk="Test@123")
        ```

        ### VPN connection with policy

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        name = config.require_object("name")
        peer_subnet = config.require_object("peerSubnet")
        gateway_id = config.require_object("gatewayId")
        gateway_ip = config.require_object("gatewayIp")
        customer_gateway_id = config.require_object("customerGatewayId")
        test = sbercloud.VpnConnection("test",
            name=name,
            gateway_id=gateway_id,
            gateway_ip=gateway_ip,
            customer_gateway_id=customer_gateway_id,
            peer_subnets=[peer_subnet],
            vpn_type="static",
            psk="Test@123",
            ikepolicy={
                "authentication_algorithm": "sha2-256",
                "authentication_method": "pre-share",
                "encryption_algorithm": "aes-128",
                "ike_version": "v2",
                "lifetime_seconds": 86400,
                "pfs": "group14",
            },
            ipsecpolicy={
                "authentication_algorithm": "sha2-256",
                "encapsulation_mode": "tunnel",
                "encryption_algorithm": "aes-128",
                "lifetime_seconds": 3600,
                "pfs": "group14",
                "transform_protocol": "esp",
            })
        ```

        ## Import

        The connection can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/vpnConnection:VpnConnection test <id>
        ```

        :param str resource_name: The name of the resource.
        :param VpnConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpnConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customer_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_nqa: Optional[pulumi.Input[_builtins.bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 ha_role: Optional[pulumi.Input[_builtins.str]] = None,
                 ikepolicy: Optional[pulumi.Input[Union['VpnConnectionIkepolicyArgs', 'VpnConnectionIkepolicyArgsDict']]] = None,
                 ipsecpolicy: Optional[pulumi.Input[Union['VpnConnectionIpsecpolicyArgs', 'VpnConnectionIpsecpolicyArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 policy_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnConnectionPolicyRuleArgs', 'VpnConnectionPolicyRuleArgsDict']]]]] = None,
                 psk: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tunnel_local_address: Optional[pulumi.Input[_builtins.str]] = None,
                 tunnel_peer_address: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpnConnectionArgs.__new__(VpnConnectionArgs)

            if customer_gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'customer_gateway_id'")
            __props__.__dict__["customer_gateway_id"] = customer_gateway_id
            __props__.__dict__["enable_nqa"] = enable_nqa
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            if gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'gateway_id'")
            __props__.__dict__["gateway_id"] = gateway_id
            if gateway_ip is None and not opts.urn:
                raise TypeError("Missing required property 'gateway_ip'")
            __props__.__dict__["gateway_ip"] = gateway_ip
            __props__.__dict__["ha_role"] = ha_role
            __props__.__dict__["ikepolicy"] = ikepolicy
            __props__.__dict__["ipsecpolicy"] = ipsecpolicy
            __props__.__dict__["name"] = name
            __props__.__dict__["peer_subnets"] = peer_subnets
            __props__.__dict__["policy_rules"] = policy_rules
            if psk is None and not opts.urn:
                raise TypeError("Missing required property 'psk'")
            __props__.__dict__["psk"] = psk
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tunnel_local_address"] = tunnel_local_address
            __props__.__dict__["tunnel_peer_address"] = tunnel_peer_address
            if vpn_type is None and not opts.urn:
                raise TypeError("Missing required property 'vpn_type'")
            __props__.__dict__["vpn_type"] = vpn_type
            __props__.__dict__["created_at"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
        super(VpnConnection, __self__).__init__(
            'sbercloud:index/vpnConnection:VpnConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            customer_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
            enable_nqa: Optional[pulumi.Input[_builtins.bool]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
            gateway_ip: Optional[pulumi.Input[_builtins.str]] = None,
            ha_role: Optional[pulumi.Input[_builtins.str]] = None,
            ikepolicy: Optional[pulumi.Input[Union['VpnConnectionIkepolicyArgs', 'VpnConnectionIkepolicyArgsDict']]] = None,
            ipsecpolicy: Optional[pulumi.Input[Union['VpnConnectionIpsecpolicyArgs', 'VpnConnectionIpsecpolicyArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            peer_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            policy_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnConnectionPolicyRuleArgs', 'VpnConnectionPolicyRuleArgsDict']]]]] = None,
            psk: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tunnel_local_address: Optional[pulumi.Input[_builtins.str]] = None,
            tunnel_peer_address: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            vpn_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'VpnConnection':
        """
        Get an existing VpnConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: The create time.
        :param pulumi.Input[_builtins.str] customer_gateway_id: The customer gateway ID.
        :param pulumi.Input[_builtins.bool] enable_nqa: Whether to enable NQA check. Defaults to **false**.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project ID.
        :param pulumi.Input[_builtins.str] gateway_id: The VPN gateway ID.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] gateway_ip: The VPN gateway IP ID.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] ha_role: Specifies the mode of the VPN connection.
               The valid values are **master** and **slave**, defaults to **master**.
               This parameter is optional when you create a connection for a VPN gateway in **active-active** mode.
               When you create a connection for a VPN gateway in **active-standby** mode, **master** indicates
               the active connection, and **slave** indicates the standby connection.
               In **active-active** mode, this field must be set to **master** for the connection established
               using the active EIP or active private IP address of the VPN gateway, and must be set to **slave**
               for the connection established using active EIP 2 or active private IP address 2 of the VPN gateway.
               
               Changing this parameter will create a new resource.
               
               <a name="Connection_CreateRequestIkePolicy"></a>
               The `ikepolicy` block supports:
        :param pulumi.Input[Union['VpnConnectionIkepolicyArgs', 'VpnConnectionIkepolicyArgsDict']] ikepolicy: The IKE policy configurations.
               The ikepolicy structure is documented below.
        :param pulumi.Input[Union['VpnConnectionIpsecpolicyArgs', 'VpnConnectionIpsecpolicyArgsDict']] ipsecpolicy: The IPsec policy configurations.
               The ipsecpolicy structure is documented below.
        :param pulumi.Input[_builtins.str] name: The name of the VPN connection.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] peer_subnets: The CIDR list of customer subnets. This parameter must be empty
               when the `attachment_type` of the VPN gateway is set to **er** and `vpn_type` is set to **policy** or **bgp**.
               This parameter is mandatory in other scenarios.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpnConnectionPolicyRuleArgs', 'VpnConnectionPolicyRuleArgsDict']]]] policy_rules: The policy rules. Only works when vpn_type is set to **policy**
               The policy_rules structure is documented below.
        :param pulumi.Input[_builtins.str] psk: The pre-shared key.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] status: The status of the VPN connection.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the tags of the VPN connection.
        :param pulumi.Input[_builtins.str] tunnel_local_address: The local tunnel address.
        :param pulumi.Input[_builtins.str] tunnel_peer_address: The peer tunnel address.
        :param pulumi.Input[_builtins.str] updated_at: The update time.
        :param pulumi.Input[_builtins.str] vpn_type: The connection type. The value can be **policy**, **static** or **bgp**.
               
               Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpnConnectionState.__new__(_VpnConnectionState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["customer_gateway_id"] = customer_gateway_id
        __props__.__dict__["enable_nqa"] = enable_nqa
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["gateway_id"] = gateway_id
        __props__.__dict__["gateway_ip"] = gateway_ip
        __props__.__dict__["ha_role"] = ha_role
        __props__.__dict__["ikepolicy"] = ikepolicy
        __props__.__dict__["ipsecpolicy"] = ipsecpolicy
        __props__.__dict__["name"] = name
        __props__.__dict__["peer_subnets"] = peer_subnets
        __props__.__dict__["policy_rules"] = policy_rules
        __props__.__dict__["psk"] = psk
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tunnel_local_address"] = tunnel_local_address
        __props__.__dict__["tunnel_peer_address"] = tunnel_peer_address
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["vpn_type"] = vpn_type
        return VpnConnection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The create time.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> pulumi.Output[_builtins.str]:
        """
        The customer gateway ID.
        """
        return pulumi.get(self, "customer_gateway_id")

    @_builtins.property
    @pulumi.getter(name="enableNqa")
    def enable_nqa(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to enable NQA check. Defaults to **false**.
        """
        return pulumi.get(self, "enable_nqa")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The enterprise project ID.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> pulumi.Output[_builtins.str]:
        """
        The VPN gateway ID.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "gateway_id")

    @_builtins.property
    @pulumi.getter(name="gatewayIp")
    def gateway_ip(self) -> pulumi.Output[_builtins.str]:
        """
        The VPN gateway IP ID.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "gateway_ip")

    @_builtins.property
    @pulumi.getter(name="haRole")
    def ha_role(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the mode of the VPN connection.
        The valid values are **master** and **slave**, defaults to **master**.
        This parameter is optional when you create a connection for a VPN gateway in **active-active** mode.
        When you create a connection for a VPN gateway in **active-standby** mode, **master** indicates
        the active connection, and **slave** indicates the standby connection.
        In **active-active** mode, this field must be set to **master** for the connection established
        using the active EIP or active private IP address of the VPN gateway, and must be set to **slave**
        for the connection established using active EIP 2 or active private IP address 2 of the VPN gateway.

        Changing this parameter will create a new resource.

        <a name="Connection_CreateRequestIkePolicy"></a>
        The `ikepolicy` block supports:
        """
        return pulumi.get(self, "ha_role")

    @_builtins.property
    @pulumi.getter
    def ikepolicy(self) -> pulumi.Output['outputs.VpnConnectionIkepolicy']:
        """
        The IKE policy configurations.
        The ikepolicy structure is documented below.
        """
        return pulumi.get(self, "ikepolicy")

    @_builtins.property
    @pulumi.getter
    def ipsecpolicy(self) -> pulumi.Output['outputs.VpnConnectionIpsecpolicy']:
        """
        The IPsec policy configurations.
        The ipsecpolicy structure is documented below.
        """
        return pulumi.get(self, "ipsecpolicy")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the VPN connection.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="peerSubnets")
    def peer_subnets(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The CIDR list of customer subnets. This parameter must be empty
        when the `attachment_type` of the VPN gateway is set to **er** and `vpn_type` is set to **policy** or **bgp**.
        This parameter is mandatory in other scenarios.
        """
        return pulumi.get(self, "peer_subnets")

    @_builtins.property
    @pulumi.getter(name="policyRules")
    def policy_rules(self) -> pulumi.Output[Sequence['outputs.VpnConnectionPolicyRule']]:
        """
        The policy rules. Only works when vpn_type is set to **policy**
        The policy_rules structure is documented below.
        """
        return pulumi.get(self, "policy_rules")

    @_builtins.property
    @pulumi.getter
    def psk(self) -> pulumi.Output[_builtins.str]:
        """
        The pre-shared key.
        """
        return pulumi.get(self, "psk")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the VPN connection.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the tags of the VPN connection.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tunnelLocalAddress")
    def tunnel_local_address(self) -> pulumi.Output[_builtins.str]:
        """
        The local tunnel address.
        """
        return pulumi.get(self, "tunnel_local_address")

    @_builtins.property
    @pulumi.getter(name="tunnelPeerAddress")
    def tunnel_peer_address(self) -> pulumi.Output[_builtins.str]:
        """
        The peer tunnel address.
        """
        return pulumi.get(self, "tunnel_peer_address")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The update time.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="vpnType")
    def vpn_type(self) -> pulumi.Output[_builtins.str]:
        """
        The connection type. The value can be **policy**, **static** or **bgp**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpn_type")

