# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['VpnConnectionHealthCheckArgs', 'VpnConnectionHealthCheck']

@pulumi.input_type
class VpnConnectionHealthCheckArgs:
    def __init__(__self__, *,
                 connection_id: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a VpnConnectionHealthCheck resource.
        :param pulumi.Input[_builtins.str] connection_id: Specifies the ID of the VPN connection to monitor.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "connection_id", connection_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the VPN connection to monitor.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "connection_id")

    @connection_id.setter
    def connection_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "connection_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _VpnConnectionHealthCheckState:
    def __init__(__self__, *,
                 connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VpnConnectionHealthCheck resources.
        :param pulumi.Input[_builtins.str] connection_id: Specifies the ID of the VPN connection to monitor.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] destination_ip: The destination IP address of the VPN connection.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] source_ip: The source IP address of the VPN connection.
        :param pulumi.Input[_builtins.str] status: The status of the connection health check.
        """
        if connection_id is not None:
            pulumi.set(__self__, "connection_id", connection_id)
        if destination_ip is not None:
            pulumi.set(__self__, "destination_ip", destination_ip)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if source_ip is not None:
            pulumi.set(__self__, "source_ip", source_ip)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the VPN connection to monitor.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "connection_id")

    @connection_id.setter
    def connection_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_id", value)

    @_builtins.property
    @pulumi.getter(name="destinationIp")
    def destination_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination IP address of the VPN connection.
        """
        return pulumi.get(self, "destination_ip")

    @destination_ip.setter
    def destination_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_ip", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source IP address of the VPN connection.
        """
        return pulumi.get(self, "source_ip")

    @source_ip.setter
    def source_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_ip", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the connection health check.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("sbercloud:index/vpnConnectionHealthCheck:VpnConnectionHealthCheck")
class VpnConnectionHealthCheck(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a VPN connection health check resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        connection_id = config.require_object("connectionId")
        test = sbercloud.VpnConnectionHealthCheck("test", connection_id=connection_id)
        ```

        ## Import

        The health check can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/vpnConnectionHealthCheck:VpnConnectionHealthCheck test <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] connection_id: Specifies the ID of the VPN connection to monitor.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpnConnectionHealthCheckArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a VPN connection health check resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        connection_id = config.require_object("connectionId")
        test = sbercloud.VpnConnectionHealthCheck("test", connection_id=connection_id)
        ```

        ## Import

        The health check can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/vpnConnectionHealthCheck:VpnConnectionHealthCheck test <id>
        ```

        :param str resource_name: The name of the resource.
        :param VpnConnectionHealthCheckArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpnConnectionHealthCheckArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpnConnectionHealthCheckArgs.__new__(VpnConnectionHealthCheckArgs)

            if connection_id is None and not opts.urn:
                raise TypeError("Missing required property 'connection_id'")
            __props__.__dict__["connection_id"] = connection_id
            __props__.__dict__["region"] = region
            __props__.__dict__["destination_ip"] = None
            __props__.__dict__["source_ip"] = None
            __props__.__dict__["status"] = None
        super(VpnConnectionHealthCheck, __self__).__init__(
            'sbercloud:index/vpnConnectionHealthCheck:VpnConnectionHealthCheck',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_id: Optional[pulumi.Input[_builtins.str]] = None,
            destination_ip: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            source_ip: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'VpnConnectionHealthCheck':
        """
        Get an existing VpnConnectionHealthCheck resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] connection_id: Specifies the ID of the VPN connection to monitor.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] destination_ip: The destination IP address of the VPN connection.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] source_ip: The source IP address of the VPN connection.
        :param pulumi.Input[_builtins.str] status: The status of the connection health check.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpnConnectionHealthCheckState.__new__(_VpnConnectionHealthCheckState)

        __props__.__dict__["connection_id"] = connection_id
        __props__.__dict__["destination_ip"] = destination_ip
        __props__.__dict__["region"] = region
        __props__.__dict__["source_ip"] = source_ip
        __props__.__dict__["status"] = status
        return VpnConnectionHealthCheck(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the VPN connection to monitor.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "connection_id")

    @_builtins.property
    @pulumi.getter(name="destinationIp")
    def destination_ip(self) -> pulumi.Output[_builtins.str]:
        """
        The destination IP address of the VPN connection.
        """
        return pulumi.get(self, "destination_ip")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> pulumi.Output[_builtins.str]:
        """
        The source IP address of the VPN connection.
        """
        return pulumi.get(self, "source_ip")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the connection health check.
        """
        return pulumi.get(self, "status")

