# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['VpnCustomerGatewayArgs', 'VpnCustomerGateway']

@pulumi.input_type
class VpnCustomerGatewayArgs:
    def __init__(__self__, *,
                 asn: Optional[pulumi.Input[_builtins.int]] = None,
                 certificate_content: Optional[pulumi.Input[_builtins.str]] = None,
                 id_type: Optional[pulumi.Input[_builtins.str]] = None,
                 id_value: Optional[pulumi.Input[_builtins.str]] = None,
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 route_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a VpnCustomerGateway resource.
        :param pulumi.Input[_builtins.int] asn: The BGP ASN number of the customer gateway.
               The value ranges from **1** to **4294967295**, the default value is **65000**.
               Set this parameter to **0** when `id_type` is set to **fqdn**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] certificate_content: The CA certificate content of the customer gateway.
        :param pulumi.Input[_builtins.str] id_type: Specifies the identifier type of a customer gateway.
               The value can be **ip** or **fqdn**. The default value is **ip**.
        :param pulumi.Input[_builtins.str] id_value: Specifies the identifier of a customer gateway.
               When `id_type` is set to **ip**, the value is an IPv4 address in dotted decimal notation, for example, 192.168.45.7.
               When `id_type` is set to **fqdn**, the value is a string of characters that can contain uppercase letters, lowercase letters,
               digits, and special characters. Spaces and the following special characters are not supported: & < > [ ] \\ ?.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] ip: The IP address of the customer gateway.
        :param pulumi.Input[_builtins.str] name: The customer gateway name.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] route_mode: The route mode of the customer gateway.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the tags of the customer gateway.
        """
        if asn is not None:
            pulumi.set(__self__, "asn", asn)
        if certificate_content is not None:
            pulumi.set(__self__, "certificate_content", certificate_content)
        if id_type is not None:
            pulumi.set(__self__, "id_type", id_type)
        if id_value is not None:
            pulumi.set(__self__, "id_value", id_value)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if route_mode is not None:
            pulumi.set(__self__, "route_mode", route_mode)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def asn(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The BGP ASN number of the customer gateway.
        The value ranges from **1** to **4294967295**, the default value is **65000**.
        Set this parameter to **0** when `id_type` is set to **fqdn**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "asn")

    @asn.setter
    def asn(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "asn", value)

    @_builtins.property
    @pulumi.getter(name="certificateContent")
    def certificate_content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CA certificate content of the customer gateway.
        """
        return pulumi.get(self, "certificate_content")

    @certificate_content.setter
    def certificate_content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_content", value)

    @_builtins.property
    @pulumi.getter(name="idType")
    def id_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier type of a customer gateway.
        The value can be **ip** or **fqdn**. The default value is **ip**.
        """
        return pulumi.get(self, "id_type")

    @id_type.setter
    def id_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id_type", value)

    @_builtins.property
    @pulumi.getter(name="idValue")
    def id_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier of a customer gateway.
        When `id_type` is set to **ip**, the value is an IPv4 address in dotted decimal notation, for example, 192.168.45.7.
        When `id_type` is set to **fqdn**, the value is a string of characters that can contain uppercase letters, lowercase letters,
        digits, and special characters. Spaces and the following special characters are not supported: & < > [ ] \\ ?.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "id_value")

    @id_value.setter
    def id_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id_value", value)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address of the customer gateway.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The customer gateway name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="routeMode")
    def route_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The route mode of the customer gateway.
        """
        return pulumi.get(self, "route_mode")

    @route_mode.setter
    def route_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_mode", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the tags of the customer gateway.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _VpnCustomerGatewayState:
    def __init__(__self__, *,
                 asn: Optional[pulumi.Input[_builtins.int]] = None,
                 certificate_content: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_time: Optional[pulumi.Input[_builtins.str]] = None,
                 id_type: Optional[pulumi.Input[_builtins.str]] = None,
                 id_value: Optional[pulumi.Input[_builtins.str]] = None,
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 is_updatable: Optional[pulumi.Input[_builtins.bool]] = None,
                 issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 route_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 serial_number: Optional[pulumi.Input[_builtins.str]] = None,
                 signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 subject: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VpnCustomerGateway resources.
        :param pulumi.Input[_builtins.int] asn: The BGP ASN number of the customer gateway.
               The value ranges from **1** to **4294967295**, the default value is **65000**.
               Set this parameter to **0** when `id_type` is set to **fqdn**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] certificate_content: The CA certificate content of the customer gateway.
        :param pulumi.Input[_builtins.str] certificate_id: Indicates the ID of the customer gateway certificate.
        :param pulumi.Input[_builtins.str] created_at: The create time.
        :param pulumi.Input[_builtins.str] expire_time: Indicates the expire time of the customer gateway certificate.
        :param pulumi.Input[_builtins.str] id_type: Specifies the identifier type of a customer gateway.
               The value can be **ip** or **fqdn**. The default value is **ip**.
        :param pulumi.Input[_builtins.str] id_value: Specifies the identifier of a customer gateway.
               When `id_type` is set to **ip**, the value is an IPv4 address in dotted decimal notation, for example, 192.168.45.7.
               When `id_type` is set to **fqdn**, the value is a string of characters that can contain uppercase letters, lowercase letters,
               digits, and special characters. Spaces and the following special characters are not supported: & < > [ ] \\ ?.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] ip: The IP address of the customer gateway.
        :param pulumi.Input[_builtins.bool] is_updatable: Indicates whether the customer gateway certificate is updatable.
        :param pulumi.Input[_builtins.str] issuer: Indicates the issuer of the customer gateway certificate.
        :param pulumi.Input[_builtins.str] name: The customer gateway name.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] route_mode: The route mode of the customer gateway.
        :param pulumi.Input[_builtins.str] serial_number: Indicates the serial number of the customer gateway certificate.
        :param pulumi.Input[_builtins.str] signature_algorithm: Indicates the signature algorithm of the customer gateway certificate.
        :param pulumi.Input[_builtins.str] subject: Indicates the subject of the customer gateway certificate.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the tags of the customer gateway.
        :param pulumi.Input[_builtins.str] updated_at: The update time.
        """
        if asn is not None:
            pulumi.set(__self__, "asn", asn)
        if certificate_content is not None:
            pulumi.set(__self__, "certificate_content", certificate_content)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if id_type is not None:
            pulumi.set(__self__, "id_type", id_type)
        if id_value is not None:
            pulumi.set(__self__, "id_value", id_value)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if is_updatable is not None:
            pulumi.set(__self__, "is_updatable", is_updatable)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if route_mode is not None:
            pulumi.set(__self__, "route_mode", route_mode)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if signature_algorithm is not None:
            pulumi.set(__self__, "signature_algorithm", signature_algorithm)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def asn(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The BGP ASN number of the customer gateway.
        The value ranges from **1** to **4294967295**, the default value is **65000**.
        Set this parameter to **0** when `id_type` is set to **fqdn**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "asn")

    @asn.setter
    def asn(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "asn", value)

    @_builtins.property
    @pulumi.getter(name="certificateContent")
    def certificate_content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CA certificate content of the customer gateway.
        """
        return pulumi.get(self, "certificate_content")

    @certificate_content.setter
    def certificate_content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_content", value)

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the ID of the customer gateway certificate.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_id", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The create time.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the expire time of the customer gateway certificate.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expire_time", value)

    @_builtins.property
    @pulumi.getter(name="idType")
    def id_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier type of a customer gateway.
        The value can be **ip** or **fqdn**. The default value is **ip**.
        """
        return pulumi.get(self, "id_type")

    @id_type.setter
    def id_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id_type", value)

    @_builtins.property
    @pulumi.getter(name="idValue")
    def id_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier of a customer gateway.
        When `id_type` is set to **ip**, the value is an IPv4 address in dotted decimal notation, for example, 192.168.45.7.
        When `id_type` is set to **fqdn**, the value is a string of characters that can contain uppercase letters, lowercase letters,
        digits, and special characters. Spaces and the following special characters are not supported: & < > [ ] \\ ?.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "id_value")

    @id_value.setter
    def id_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id_value", value)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address of the customer gateway.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter(name="isUpdatable")
    def is_updatable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the customer gateway certificate is updatable.
        """
        return pulumi.get(self, "is_updatable")

    @is_updatable.setter
    def is_updatable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_updatable", value)

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the issuer of the customer gateway certificate.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The customer gateway name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="routeMode")
    def route_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The route mode of the customer gateway.
        """
        return pulumi.get(self, "route_mode")

    @route_mode.setter
    def route_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_mode", value)

    @_builtins.property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the serial number of the customer gateway certificate.
        """
        return pulumi.get(self, "serial_number")

    @serial_number.setter
    def serial_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "serial_number", value)

    @_builtins.property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the signature algorithm of the customer gateway certificate.
        """
        return pulumi.get(self, "signature_algorithm")

    @signature_algorithm.setter
    def signature_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "signature_algorithm", value)

    @_builtins.property
    @pulumi.getter
    def subject(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the subject of the customer gateway certificate.
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subject", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the tags of the customer gateway.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The update time.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("sbercloud:index/vpnCustomerGateway:VpnCustomerGateway")
class VpnCustomerGateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 asn: Optional[pulumi.Input[_builtins.int]] = None,
                 certificate_content: Optional[pulumi.Input[_builtins.str]] = None,
                 id_type: Optional[pulumi.Input[_builtins.str]] = None,
                 id_value: Optional[pulumi.Input[_builtins.str]] = None,
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 route_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a VPN customer gateway resource within SberCloud.

        ## Example Usage

        ### Manages a common VPN customer gateway

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        name = config.require_object("name")
        id_value = config.require_object("idValue")
        test = sbercloud.VpnCustomerGateway("test",
            name=name,
            id_value=id_value)
        ```

        ### Manages a VPN customer gateway with CA certificate

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        name = config.require_object("name")
        id_value = config.require_object("idValue")
        certificate_content = config.require_object("certificateContent")
        test = sbercloud.VpnCustomerGateway("test",
            name=name,
            id_value=id_value,
            certificate_content=certificate_content)
        ```

        ## Import

        The customer gateway can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/vpnCustomerGateway:VpnCustomerGateway test <id>
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attribute is `certificate_content`. It is generally recommended

        running `pulumi preview` after importing the resource. You can then decide if changes should be applied to the instance,

        or the resource definition should be updated to align with the instance. Also you can ignore changes as below.

        hcl

        resource "sbercloud_vpn_customer_gateway" "test" {

            ...

          lifecycle {

            ignore_changes = [
            
              certificate_content,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] asn: The BGP ASN number of the customer gateway.
               The value ranges from **1** to **4294967295**, the default value is **65000**.
               Set this parameter to **0** when `id_type` is set to **fqdn**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] certificate_content: The CA certificate content of the customer gateway.
        :param pulumi.Input[_builtins.str] id_type: Specifies the identifier type of a customer gateway.
               The value can be **ip** or **fqdn**. The default value is **ip**.
        :param pulumi.Input[_builtins.str] id_value: Specifies the identifier of a customer gateway.
               When `id_type` is set to **ip**, the value is an IPv4 address in dotted decimal notation, for example, 192.168.45.7.
               When `id_type` is set to **fqdn**, the value is a string of characters that can contain uppercase letters, lowercase letters,
               digits, and special characters. Spaces and the following special characters are not supported: & < > [ ] \\ ?.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] ip: The IP address of the customer gateway.
        :param pulumi.Input[_builtins.str] name: The customer gateway name.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] route_mode: The route mode of the customer gateway.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the tags of the customer gateway.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[VpnCustomerGatewayArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a VPN customer gateway resource within SberCloud.

        ## Example Usage

        ### Manages a common VPN customer gateway

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        name = config.require_object("name")
        id_value = config.require_object("idValue")
        test = sbercloud.VpnCustomerGateway("test",
            name=name,
            id_value=id_value)
        ```

        ### Manages a VPN customer gateway with CA certificate

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        name = config.require_object("name")
        id_value = config.require_object("idValue")
        certificate_content = config.require_object("certificateContent")
        test = sbercloud.VpnCustomerGateway("test",
            name=name,
            id_value=id_value,
            certificate_content=certificate_content)
        ```

        ## Import

        The customer gateway can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/vpnCustomerGateway:VpnCustomerGateway test <id>
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attribute is `certificate_content`. It is generally recommended

        running `pulumi preview` after importing the resource. You can then decide if changes should be applied to the instance,

        or the resource definition should be updated to align with the instance. Also you can ignore changes as below.

        hcl

        resource "sbercloud_vpn_customer_gateway" "test" {

            ...

          lifecycle {

            ignore_changes = [
            
              certificate_content,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param VpnCustomerGatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpnCustomerGatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 asn: Optional[pulumi.Input[_builtins.int]] = None,
                 certificate_content: Optional[pulumi.Input[_builtins.str]] = None,
                 id_type: Optional[pulumi.Input[_builtins.str]] = None,
                 id_value: Optional[pulumi.Input[_builtins.str]] = None,
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 route_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpnCustomerGatewayArgs.__new__(VpnCustomerGatewayArgs)

            __props__.__dict__["asn"] = asn
            __props__.__dict__["certificate_content"] = certificate_content
            __props__.__dict__["id_type"] = id_type
            __props__.__dict__["id_value"] = id_value
            __props__.__dict__["ip"] = ip
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["route_mode"] = route_mode
            __props__.__dict__["tags"] = tags
            __props__.__dict__["certificate_id"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["expire_time"] = None
            __props__.__dict__["is_updatable"] = None
            __props__.__dict__["issuer"] = None
            __props__.__dict__["serial_number"] = None
            __props__.__dict__["signature_algorithm"] = None
            __props__.__dict__["subject"] = None
            __props__.__dict__["updated_at"] = None
        super(VpnCustomerGateway, __self__).__init__(
            'sbercloud:index/vpnCustomerGateway:VpnCustomerGateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            asn: Optional[pulumi.Input[_builtins.int]] = None,
            certificate_content: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            expire_time: Optional[pulumi.Input[_builtins.str]] = None,
            id_type: Optional[pulumi.Input[_builtins.str]] = None,
            id_value: Optional[pulumi.Input[_builtins.str]] = None,
            ip: Optional[pulumi.Input[_builtins.str]] = None,
            is_updatable: Optional[pulumi.Input[_builtins.bool]] = None,
            issuer: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            route_mode: Optional[pulumi.Input[_builtins.str]] = None,
            serial_number: Optional[pulumi.Input[_builtins.str]] = None,
            signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            subject: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'VpnCustomerGateway':
        """
        Get an existing VpnCustomerGateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] asn: The BGP ASN number of the customer gateway.
               The value ranges from **1** to **4294967295**, the default value is **65000**.
               Set this parameter to **0** when `id_type` is set to **fqdn**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] certificate_content: The CA certificate content of the customer gateway.
        :param pulumi.Input[_builtins.str] certificate_id: Indicates the ID of the customer gateway certificate.
        :param pulumi.Input[_builtins.str] created_at: The create time.
        :param pulumi.Input[_builtins.str] expire_time: Indicates the expire time of the customer gateway certificate.
        :param pulumi.Input[_builtins.str] id_type: Specifies the identifier type of a customer gateway.
               The value can be **ip** or **fqdn**. The default value is **ip**.
        :param pulumi.Input[_builtins.str] id_value: Specifies the identifier of a customer gateway.
               When `id_type` is set to **ip**, the value is an IPv4 address in dotted decimal notation, for example, 192.168.45.7.
               When `id_type` is set to **fqdn**, the value is a string of characters that can contain uppercase letters, lowercase letters,
               digits, and special characters. Spaces and the following special characters are not supported: & < > [ ] \\ ?.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] ip: The IP address of the customer gateway.
        :param pulumi.Input[_builtins.bool] is_updatable: Indicates whether the customer gateway certificate is updatable.
        :param pulumi.Input[_builtins.str] issuer: Indicates the issuer of the customer gateway certificate.
        :param pulumi.Input[_builtins.str] name: The customer gateway name.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] route_mode: The route mode of the customer gateway.
        :param pulumi.Input[_builtins.str] serial_number: Indicates the serial number of the customer gateway certificate.
        :param pulumi.Input[_builtins.str] signature_algorithm: Indicates the signature algorithm of the customer gateway certificate.
        :param pulumi.Input[_builtins.str] subject: Indicates the subject of the customer gateway certificate.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the tags of the customer gateway.
        :param pulumi.Input[_builtins.str] updated_at: The update time.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpnCustomerGatewayState.__new__(_VpnCustomerGatewayState)

        __props__.__dict__["asn"] = asn
        __props__.__dict__["certificate_content"] = certificate_content
        __props__.__dict__["certificate_id"] = certificate_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["expire_time"] = expire_time
        __props__.__dict__["id_type"] = id_type
        __props__.__dict__["id_value"] = id_value
        __props__.__dict__["ip"] = ip
        __props__.__dict__["is_updatable"] = is_updatable
        __props__.__dict__["issuer"] = issuer
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["route_mode"] = route_mode
        __props__.__dict__["serial_number"] = serial_number
        __props__.__dict__["signature_algorithm"] = signature_algorithm
        __props__.__dict__["subject"] = subject
        __props__.__dict__["tags"] = tags
        __props__.__dict__["updated_at"] = updated_at
        return VpnCustomerGateway(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def asn(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The BGP ASN number of the customer gateway.
        The value ranges from **1** to **4294967295**, the default value is **65000**.
        Set this parameter to **0** when `id_type` is set to **fqdn**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "asn")

    @_builtins.property
    @pulumi.getter(name="certificateContent")
    def certificate_content(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The CA certificate content of the customer gateway.
        """
        return pulumi.get(self, "certificate_content")

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the ID of the customer gateway certificate.
        """
        return pulumi.get(self, "certificate_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The create time.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the expire time of the customer gateway certificate.
        """
        return pulumi.get(self, "expire_time")

    @_builtins.property
    @pulumi.getter(name="idType")
    def id_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the identifier type of a customer gateway.
        The value can be **ip** or **fqdn**. The default value is **ip**.
        """
        return pulumi.get(self, "id_type")

    @_builtins.property
    @pulumi.getter(name="idValue")
    def id_value(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the identifier of a customer gateway.
        When `id_type` is set to **ip**, the value is an IPv4 address in dotted decimal notation, for example, 192.168.45.7.
        When `id_type` is set to **fqdn**, the value is a string of characters that can contain uppercase letters, lowercase letters,
        digits, and special characters. Spaces and the following special characters are not supported: & < > [ ] \\ ?.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "id_value")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IP address of the customer gateway.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="isUpdatable")
    def is_updatable(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the customer gateway certificate is updatable.
        """
        return pulumi.get(self, "is_updatable")

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the issuer of the customer gateway certificate.
        """
        return pulumi.get(self, "issuer")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The customer gateway name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="routeMode")
    def route_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The route mode of the customer gateway.
        """
        return pulumi.get(self, "route_mode")

    @_builtins.property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the serial number of the customer gateway certificate.
        """
        return pulumi.get(self, "serial_number")

    @_builtins.property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the signature algorithm of the customer gateway certificate.
        """
        return pulumi.get(self, "signature_algorithm")

    @_builtins.property
    @pulumi.getter
    def subject(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the subject of the customer gateway certificate.
        """
        return pulumi.get(self, "subject")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the tags of the customer gateway.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The update time.
        """
        return pulumi.get(self, "updated_at")

