# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VpnGatewayArgs', 'VpnGateway']

@pulumi.input_type
class VpnGatewayArgs:
    def __init__(__self__, *,
                 availability_zones: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 access_private_ip1: Optional[pulumi.Input[_builtins.str]] = None,
                 access_private_ip2: Optional[pulumi.Input[_builtins.str]] = None,
                 access_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 access_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 asn: Optional[pulumi.Input[_builtins.int]] = None,
                 attachment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate: Optional[pulumi.Input['VpnGatewayCertificateArgs']] = None,
                 connect_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_eip_on_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 eip1: Optional[pulumi.Input['VpnGatewayEip1Args']] = None,
                 eip2: Optional[pulumi.Input['VpnGatewayEip2Args']] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 er_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor: Optional[pulumi.Input[_builtins.str]] = None,
                 ha_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 local_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 master_eip: Optional[pulumi.Input['VpnGatewayMasterEipArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 slave_eip: Optional[pulumi.Input['VpnGatewaySlaveEipArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a VpnGateway resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: The list of availability zone IDs.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] access_private_ip1: The private IP 1 in private network type VPN gateway.
               It is the master IP 1 in **active-active** HA mode, and the master IP in **active-standby** HA mode.
               Must declare the **access_private_ip_2** at the same time, and can not use the same IP value.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] access_private_ip2: The private IP 2 in private network type VPN gateway.
               It is the master IP 2 in **active-active** HA mode, and the slave IP in **active-standby** HA mode.
               Must declare the **access_private_ip_1** at the same time, and can not use the same IP value.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] access_subnet_id: The access subnet ID.
               The default value is the value of `connect_subnet`.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] access_vpc_id: The access VPC ID.
               The default value is the value of `vpc_id`.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] asn: The ASN number of BGP. The value ranges from **1** to **4294967295**.
               Defaults to **64512**
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] attachment_type: The attachment type. The value can be **vpc** and **er**.
               Defaults to **vpc**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input['VpnGatewayCertificateArgs'] certificate: The GM certificate of the **GM** flavor gateway.
               The object structure is documented below.
        :param pulumi.Input[_builtins.str] connect_subnet: The Network ID of the VPC subnet used by the VPN gateway.
               This parameter is mandatory when `attachment_type` is **vpc**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] delete_eip_on_termination: Whether to delete the EIP when the VPN gateway is deleted.
        :param pulumi.Input['VpnGatewayEip1Args'] eip1: The master 1 IP in active-active VPN gateway or the master IP
               in active-standby VPN gateway. This parameter is mandatory when `network_type` is **public** or left empty.
               The object structure is documented below.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input['VpnGatewayEip2Args'] eip2: The master 2 IP in active-active VPN gateway or the slave IP
               in active-standby VPN gateway. This parameter is mandatory when `network_type` is **public** or left empty.
               The object structure is documented below.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project ID.
               
               <a name="Gateway_CreateRequestEip"></a>
               The `eip1` or `eip2` block supports:
        :param pulumi.Input[_builtins.str] er_id: The enterprise router ID to attach with to VPN gateway.
               This parameter is mandatory when `attachment_type` is **er**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] flavor: The flavor of the VPN gateway.
               The value can be **Basic**, **Professional1**, **Professional2** and **GM**. Defaults to **Professional1**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] ha_mode: The HA mode of VPN gateway. Valid values are **active-active** and
               **active-standby**. The default value is **active-active**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] local_subnets: The list of local subnets.
               This parameter is mandatory when `attachment_type` is **vpc**.
        :param pulumi.Input[_builtins.str] name: The name of the gateway certificate.
        :param pulumi.Input[_builtins.str] network_type: The network type. The value can be **public** and **private**.
               Defaults to **public**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the tags of the VPN gateway.
               
               <a name="Gateway_certificate_attr"></a>
               The `certificate` block supports:
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC to which the VPN gateway is connected.
               This parameter is mandatory when `attachment_type` is **vpc**.
               
               Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "availability_zones", availability_zones)
        if access_private_ip1 is not None:
            pulumi.set(__self__, "access_private_ip1", access_private_ip1)
        if access_private_ip2 is not None:
            pulumi.set(__self__, "access_private_ip2", access_private_ip2)
        if access_subnet_id is not None:
            pulumi.set(__self__, "access_subnet_id", access_subnet_id)
        if access_vpc_id is not None:
            pulumi.set(__self__, "access_vpc_id", access_vpc_id)
        if asn is not None:
            pulumi.set(__self__, "asn", asn)
        if attachment_type is not None:
            pulumi.set(__self__, "attachment_type", attachment_type)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if connect_subnet is not None:
            pulumi.set(__self__, "connect_subnet", connect_subnet)
        if delete_eip_on_termination is not None:
            pulumi.set(__self__, "delete_eip_on_termination", delete_eip_on_termination)
        if eip1 is not None:
            pulumi.set(__self__, "eip1", eip1)
        if eip2 is not None:
            pulumi.set(__self__, "eip2", eip2)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if er_id is not None:
            pulumi.set(__self__, "er_id", er_id)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if ha_mode is not None:
            pulumi.set(__self__, "ha_mode", ha_mode)
        if local_subnets is not None:
            pulumi.set(__self__, "local_subnets", local_subnets)
        if master_eip is not None:
            pulumi.set(__self__, "master_eip", master_eip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if slave_eip is not None:
            pulumi.set(__self__, "slave_eip", slave_eip)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of availability zone IDs.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="accessPrivateIp1")
    def access_private_ip1(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private IP 1 in private network type VPN gateway.
        It is the master IP 1 in **active-active** HA mode, and the master IP in **active-standby** HA mode.
        Must declare the **access_private_ip_2** at the same time, and can not use the same IP value.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "access_private_ip1")

    @access_private_ip1.setter
    def access_private_ip1(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_private_ip1", value)

    @_builtins.property
    @pulumi.getter(name="accessPrivateIp2")
    def access_private_ip2(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private IP 2 in private network type VPN gateway.
        It is the master IP 2 in **active-active** HA mode, and the slave IP in **active-standby** HA mode.
        Must declare the **access_private_ip_1** at the same time, and can not use the same IP value.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "access_private_ip2")

    @access_private_ip2.setter
    def access_private_ip2(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_private_ip2", value)

    @_builtins.property
    @pulumi.getter(name="accessSubnetId")
    def access_subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access subnet ID.
        The default value is the value of `connect_subnet`.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "access_subnet_id")

    @access_subnet_id.setter
    def access_subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="accessVpcId")
    def access_vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access VPC ID.
        The default value is the value of `vpc_id`.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "access_vpc_id")

    @access_vpc_id.setter
    def access_vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_vpc_id", value)

    @_builtins.property
    @pulumi.getter
    def asn(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ASN number of BGP. The value ranges from **1** to **4294967295**.
        Defaults to **64512**

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "asn")

    @asn.setter
    def asn(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "asn", value)

    @_builtins.property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The attachment type. The value can be **vpc** and **er**.
        Defaults to **vpc**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "attachment_type")

    @attachment_type.setter
    def attachment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "attachment_type", value)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input['VpnGatewayCertificateArgs']]:
        """
        The GM certificate of the **GM** flavor gateway.
        The object structure is documented below.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input['VpnGatewayCertificateArgs']]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="connectSubnet")
    def connect_subnet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Network ID of the VPC subnet used by the VPN gateway.
        This parameter is mandatory when `attachment_type` is **vpc**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "connect_subnet")

    @connect_subnet.setter
    def connect_subnet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connect_subnet", value)

    @_builtins.property
    @pulumi.getter(name="deleteEipOnTermination")
    def delete_eip_on_termination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to delete the EIP when the VPN gateway is deleted.
        """
        return pulumi.get(self, "delete_eip_on_termination")

    @delete_eip_on_termination.setter
    def delete_eip_on_termination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_eip_on_termination", value)

    @_builtins.property
    @pulumi.getter
    def eip1(self) -> Optional[pulumi.Input['VpnGatewayEip1Args']]:
        """
        The master 1 IP in active-active VPN gateway or the master IP
        in active-standby VPN gateway. This parameter is mandatory when `network_type` is **public** or left empty.
        The object structure is documented below.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "eip1")

    @eip1.setter
    def eip1(self, value: Optional[pulumi.Input['VpnGatewayEip1Args']]):
        pulumi.set(self, "eip1", value)

    @_builtins.property
    @pulumi.getter
    def eip2(self) -> Optional[pulumi.Input['VpnGatewayEip2Args']]:
        """
        The master 2 IP in active-active VPN gateway or the slave IP
        in active-standby VPN gateway. This parameter is mandatory when `network_type` is **public** or left empty.
        The object structure is documented below.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "eip2")

    @eip2.setter
    def eip2(self, value: Optional[pulumi.Input['VpnGatewayEip2Args']]):
        pulumi.set(self, "eip2", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project ID.

        <a name="Gateway_CreateRequestEip"></a>
        The `eip1` or `eip2` block supports:
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="erId")
    def er_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise router ID to attach with to VPN gateway.
        This parameter is mandatory when `attachment_type` is **er**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "er_id")

    @er_id.setter
    def er_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "er_id", value)

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The flavor of the VPN gateway.
        The value can be **Basic**, **Professional1**, **Professional2** and **GM**. Defaults to **Professional1**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flavor", value)

    @_builtins.property
    @pulumi.getter(name="haMode")
    def ha_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The HA mode of VPN gateway. Valid values are **active-active** and
        **active-standby**. The default value is **active-active**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ha_mode")

    @ha_mode.setter
    def ha_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ha_mode", value)

    @_builtins.property
    @pulumi.getter(name="localSubnets")
    def local_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of local subnets.
        This parameter is mandatory when `attachment_type` is **vpc**.
        """
        return pulumi.get(self, "local_subnets")

    @local_subnets.setter
    def local_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "local_subnets", value)

    @_builtins.property
    @pulumi.getter(name="masterEip")
    def master_eip(self) -> Optional[pulumi.Input['VpnGatewayMasterEipArgs']]:
        return pulumi.get(self, "master_eip")

    @master_eip.setter
    def master_eip(self, value: Optional[pulumi.Input['VpnGatewayMasterEipArgs']]):
        pulumi.set(self, "master_eip", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the gateway certificate.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type. The value can be **public** and **private**.
        Defaults to **public**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_type", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="slaveEip")
    def slave_eip(self) -> Optional[pulumi.Input['VpnGatewaySlaveEipArgs']]:
        return pulumi.get(self, "slave_eip")

    @slave_eip.setter
    def slave_eip(self, value: Optional[pulumi.Input['VpnGatewaySlaveEipArgs']]):
        pulumi.set(self, "slave_eip", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the tags of the VPN gateway.

        <a name="Gateway_certificate_attr"></a>
        The `certificate` block supports:
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC to which the VPN gateway is connected.
        This parameter is mandatory when `attachment_type` is **vpc**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class _VpnGatewayState:
    def __init__(__self__, *,
                 access_private_ip1: Optional[pulumi.Input[_builtins.str]] = None,
                 access_private_ip2: Optional[pulumi.Input[_builtins.str]] = None,
                 access_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 access_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 asn: Optional[pulumi.Input[_builtins.int]] = None,
                 attachment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 certificate: Optional[pulumi.Input['VpnGatewayCertificateArgs']] = None,
                 connect_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_eip_on_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 eip1: Optional[pulumi.Input['VpnGatewayEip1Args']] = None,
                 eip2: Optional[pulumi.Input['VpnGatewayEip2Args']] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 er_attachment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 er_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor: Optional[pulumi.Input[_builtins.str]] = None,
                 ha_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 local_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 master_eip: Optional[pulumi.Input['VpnGatewayMasterEipArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 slave_eip: Optional[pulumi.Input['VpnGatewaySlaveEipArgs']] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 used_connection_group: Optional[pulumi.Input[_builtins.int]] = None,
                 used_connection_number: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VpnGateway resources.
        :param pulumi.Input[_builtins.str] access_private_ip1: The private IP 1 in private network type VPN gateway.
               It is the master IP 1 in **active-active** HA mode, and the master IP in **active-standby** HA mode.
               Must declare the **access_private_ip_2** at the same time, and can not use the same IP value.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] access_private_ip2: The private IP 2 in private network type VPN gateway.
               It is the master IP 2 in **active-active** HA mode, and the slave IP in **active-standby** HA mode.
               Must declare the **access_private_ip_1** at the same time, and can not use the same IP value.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] access_subnet_id: The access subnet ID.
               The default value is the value of `connect_subnet`.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] access_vpc_id: The access VPC ID.
               The default value is the value of `vpc_id`.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] asn: The ASN number of BGP. The value ranges from **1** to **4294967295**.
               Defaults to **64512**
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] attachment_type: The attachment type. The value can be **vpc** and **er**.
               Defaults to **vpc**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: The list of availability zone IDs.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input['VpnGatewayCertificateArgs'] certificate: The GM certificate of the **GM** flavor gateway.
               The object structure is documented below.
        :param pulumi.Input[_builtins.str] connect_subnet: The Network ID of the VPC subnet used by the VPN gateway.
               This parameter is mandatory when `attachment_type` is **vpc**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] created_at: The create time of the gateway certificate.
        :param pulumi.Input[_builtins.bool] delete_eip_on_termination: Whether to delete the EIP when the VPN gateway is deleted.
        :param pulumi.Input['VpnGatewayEip1Args'] eip1: The master 1 IP in active-active VPN gateway or the master IP
               in active-standby VPN gateway. This parameter is mandatory when `network_type` is **public** or left empty.
               The object structure is documented below.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input['VpnGatewayEip2Args'] eip2: The master 2 IP in active-active VPN gateway or the slave IP
               in active-standby VPN gateway. This parameter is mandatory when `network_type` is **public** or left empty.
               The object structure is documented below.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project ID.
               
               <a name="Gateway_CreateRequestEip"></a>
               The `eip1` or `eip2` block supports:
        :param pulumi.Input[_builtins.str] er_attachment_id: The ER attachment ID.
        :param pulumi.Input[_builtins.str] er_id: The enterprise router ID to attach with to VPN gateway.
               This parameter is mandatory when `attachment_type` is **er**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] flavor: The flavor of the VPN gateway.
               The value can be **Basic**, **Professional1**, **Professional2** and **GM**. Defaults to **Professional1**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] ha_mode: The HA mode of VPN gateway. Valid values are **active-active** and
               **active-standby**. The default value is **active-active**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] local_subnets: The list of local subnets.
               This parameter is mandatory when `attachment_type` is **vpc**.
        :param pulumi.Input[_builtins.str] name: The name of the gateway certificate.
        :param pulumi.Input[_builtins.str] network_type: The network type. The value can be **public** and **private**.
               Defaults to **public**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] status: The status of the certificate.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the tags of the VPN gateway.
               
               <a name="Gateway_certificate_attr"></a>
               The `certificate` block supports:
        :param pulumi.Input[_builtins.str] updated_at: The update time of the gateway certificate.
        :param pulumi.Input[_builtins.int] used_connection_group: The number of used connection groups.
        :param pulumi.Input[_builtins.int] used_connection_number: The number of used connections.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC to which the VPN gateway is connected.
               This parameter is mandatory when `attachment_type` is **vpc**.
               
               Changing this parameter will create a new resource.
        """
        if access_private_ip1 is not None:
            pulumi.set(__self__, "access_private_ip1", access_private_ip1)
        if access_private_ip2 is not None:
            pulumi.set(__self__, "access_private_ip2", access_private_ip2)
        if access_subnet_id is not None:
            pulumi.set(__self__, "access_subnet_id", access_subnet_id)
        if access_vpc_id is not None:
            pulumi.set(__self__, "access_vpc_id", access_vpc_id)
        if asn is not None:
            pulumi.set(__self__, "asn", asn)
        if attachment_type is not None:
            pulumi.set(__self__, "attachment_type", attachment_type)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if connect_subnet is not None:
            pulumi.set(__self__, "connect_subnet", connect_subnet)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if delete_eip_on_termination is not None:
            pulumi.set(__self__, "delete_eip_on_termination", delete_eip_on_termination)
        if eip1 is not None:
            pulumi.set(__self__, "eip1", eip1)
        if eip2 is not None:
            pulumi.set(__self__, "eip2", eip2)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if er_attachment_id is not None:
            pulumi.set(__self__, "er_attachment_id", er_attachment_id)
        if er_id is not None:
            pulumi.set(__self__, "er_id", er_id)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if ha_mode is not None:
            pulumi.set(__self__, "ha_mode", ha_mode)
        if local_subnets is not None:
            pulumi.set(__self__, "local_subnets", local_subnets)
        if master_eip is not None:
            pulumi.set(__self__, "master_eip", master_eip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if slave_eip is not None:
            pulumi.set(__self__, "slave_eip", slave_eip)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if used_connection_group is not None:
            pulumi.set(__self__, "used_connection_group", used_connection_group)
        if used_connection_number is not None:
            pulumi.set(__self__, "used_connection_number", used_connection_number)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="accessPrivateIp1")
    def access_private_ip1(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private IP 1 in private network type VPN gateway.
        It is the master IP 1 in **active-active** HA mode, and the master IP in **active-standby** HA mode.
        Must declare the **access_private_ip_2** at the same time, and can not use the same IP value.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "access_private_ip1")

    @access_private_ip1.setter
    def access_private_ip1(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_private_ip1", value)

    @_builtins.property
    @pulumi.getter(name="accessPrivateIp2")
    def access_private_ip2(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private IP 2 in private network type VPN gateway.
        It is the master IP 2 in **active-active** HA mode, and the slave IP in **active-standby** HA mode.
        Must declare the **access_private_ip_1** at the same time, and can not use the same IP value.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "access_private_ip2")

    @access_private_ip2.setter
    def access_private_ip2(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_private_ip2", value)

    @_builtins.property
    @pulumi.getter(name="accessSubnetId")
    def access_subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access subnet ID.
        The default value is the value of `connect_subnet`.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "access_subnet_id")

    @access_subnet_id.setter
    def access_subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="accessVpcId")
    def access_vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access VPC ID.
        The default value is the value of `vpc_id`.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "access_vpc_id")

    @access_vpc_id.setter
    def access_vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_vpc_id", value)

    @_builtins.property
    @pulumi.getter
    def asn(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ASN number of BGP. The value ranges from **1** to **4294967295**.
        Defaults to **64512**

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "asn")

    @asn.setter
    def asn(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "asn", value)

    @_builtins.property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The attachment type. The value can be **vpc** and **er**.
        Defaults to **vpc**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "attachment_type")

    @attachment_type.setter
    def attachment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "attachment_type", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of availability zone IDs.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input['VpnGatewayCertificateArgs']]:
        """
        The GM certificate of the **GM** flavor gateway.
        The object structure is documented below.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input['VpnGatewayCertificateArgs']]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="connectSubnet")
    def connect_subnet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Network ID of the VPC subnet used by the VPN gateway.
        This parameter is mandatory when `attachment_type` is **vpc**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "connect_subnet")

    @connect_subnet.setter
    def connect_subnet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connect_subnet", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The create time of the gateway certificate.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="deleteEipOnTermination")
    def delete_eip_on_termination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to delete the EIP when the VPN gateway is deleted.
        """
        return pulumi.get(self, "delete_eip_on_termination")

    @delete_eip_on_termination.setter
    def delete_eip_on_termination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_eip_on_termination", value)

    @_builtins.property
    @pulumi.getter
    def eip1(self) -> Optional[pulumi.Input['VpnGatewayEip1Args']]:
        """
        The master 1 IP in active-active VPN gateway or the master IP
        in active-standby VPN gateway. This parameter is mandatory when `network_type` is **public** or left empty.
        The object structure is documented below.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "eip1")

    @eip1.setter
    def eip1(self, value: Optional[pulumi.Input['VpnGatewayEip1Args']]):
        pulumi.set(self, "eip1", value)

    @_builtins.property
    @pulumi.getter
    def eip2(self) -> Optional[pulumi.Input['VpnGatewayEip2Args']]:
        """
        The master 2 IP in active-active VPN gateway or the slave IP
        in active-standby VPN gateway. This parameter is mandatory when `network_type` is **public** or left empty.
        The object structure is documented below.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "eip2")

    @eip2.setter
    def eip2(self, value: Optional[pulumi.Input['VpnGatewayEip2Args']]):
        pulumi.set(self, "eip2", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project ID.

        <a name="Gateway_CreateRequestEip"></a>
        The `eip1` or `eip2` block supports:
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="erAttachmentId")
    def er_attachment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ER attachment ID.
        """
        return pulumi.get(self, "er_attachment_id")

    @er_attachment_id.setter
    def er_attachment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "er_attachment_id", value)

    @_builtins.property
    @pulumi.getter(name="erId")
    def er_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise router ID to attach with to VPN gateway.
        This parameter is mandatory when `attachment_type` is **er**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "er_id")

    @er_id.setter
    def er_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "er_id", value)

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The flavor of the VPN gateway.
        The value can be **Basic**, **Professional1**, **Professional2** and **GM**. Defaults to **Professional1**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flavor", value)

    @_builtins.property
    @pulumi.getter(name="haMode")
    def ha_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The HA mode of VPN gateway. Valid values are **active-active** and
        **active-standby**. The default value is **active-active**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ha_mode")

    @ha_mode.setter
    def ha_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ha_mode", value)

    @_builtins.property
    @pulumi.getter(name="localSubnets")
    def local_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of local subnets.
        This parameter is mandatory when `attachment_type` is **vpc**.
        """
        return pulumi.get(self, "local_subnets")

    @local_subnets.setter
    def local_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "local_subnets", value)

    @_builtins.property
    @pulumi.getter(name="masterEip")
    def master_eip(self) -> Optional[pulumi.Input['VpnGatewayMasterEipArgs']]:
        return pulumi.get(self, "master_eip")

    @master_eip.setter
    def master_eip(self, value: Optional[pulumi.Input['VpnGatewayMasterEipArgs']]):
        pulumi.set(self, "master_eip", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the gateway certificate.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type. The value can be **public** and **private**.
        Defaults to **public**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_type", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="slaveEip")
    def slave_eip(self) -> Optional[pulumi.Input['VpnGatewaySlaveEipArgs']]:
        return pulumi.get(self, "slave_eip")

    @slave_eip.setter
    def slave_eip(self, value: Optional[pulumi.Input['VpnGatewaySlaveEipArgs']]):
        pulumi.set(self, "slave_eip", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the certificate.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the tags of the VPN gateway.

        <a name="Gateway_certificate_attr"></a>
        The `certificate` block supports:
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The update time of the gateway certificate.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="usedConnectionGroup")
    def used_connection_group(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of used connection groups.
        """
        return pulumi.get(self, "used_connection_group")

    @used_connection_group.setter
    def used_connection_group(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "used_connection_group", value)

    @_builtins.property
    @pulumi.getter(name="usedConnectionNumber")
    def used_connection_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of used connections.
        """
        return pulumi.get(self, "used_connection_number")

    @used_connection_number.setter
    def used_connection_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "used_connection_number", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC to which the VPN gateway is connected.
        This parameter is mandatory when `attachment_type` is **vpc**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("sbercloud:index/vpnGateway:VpnGateway")
class VpnGateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_private_ip1: Optional[pulumi.Input[_builtins.str]] = None,
                 access_private_ip2: Optional[pulumi.Input[_builtins.str]] = None,
                 access_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 access_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 asn: Optional[pulumi.Input[_builtins.int]] = None,
                 attachment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 certificate: Optional[pulumi.Input[Union['VpnGatewayCertificateArgs', 'VpnGatewayCertificateArgsDict']]] = None,
                 connect_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_eip_on_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 eip1: Optional[pulumi.Input[Union['VpnGatewayEip1Args', 'VpnGatewayEip1ArgsDict']]] = None,
                 eip2: Optional[pulumi.Input[Union['VpnGatewayEip2Args', 'VpnGatewayEip2ArgsDict']]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 er_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor: Optional[pulumi.Input[_builtins.str]] = None,
                 ha_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 local_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 master_eip: Optional[pulumi.Input[Union['VpnGatewayMasterEipArgs', 'VpnGatewayMasterEipArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 slave_eip: Optional[pulumi.Input[Union['VpnGatewaySlaveEipArgs', 'VpnGatewaySlaveEipArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a VPN gateway resource within SberCloud.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud
        import pulumi_sbercloud as sbercloud

        config = pulumi.Config()
        name = config.require_object("name")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        eip_id1 = config.require_object("eipId1")
        eip_id2 = config.require_object("eipId2")
        test = sbercloud.get_vpn_gateway_availability_zones(flavor="professional1",
            attachment_type="vpc")
        test_vpn_gateway = sbercloud.VpnGateway("test",
            name=name,
            vpc_id=vpc_id,
            local_subnets=[
                "192.168.0.0/24",
                "192.168.1.0/24",
            ],
            connect_subnet=subnet_id,
            availability_zones=[
                test.names[0],
                test.names[1],
            ],
            eip1={
                "id": eip_id1,
            },
            eip2={
                "id": eip_id2,
            })
        ```

        ### Creating a VPN gateway with creating new EIPs

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud
        import pulumi_sbercloud as sbercloud

        config = pulumi.Config()
        name = config.require_object("name")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        bandwidth_name1 = config.require_object("bandwidthName1")
        bandwidth_name2 = config.require_object("bandwidthName2")
        test = sbercloud.get_vpn_gateway_availability_zones(flavor="professional1",
            attachment_type="vpc")
        test_vpn_gateway = sbercloud.VpnGateway("test",
            name=name,
            vpc_id=vpc_id,
            local_subnets=[
                "192.168.0.0/24",
                "192.168.1.0/24",
            ],
            connect_subnet=subnet_id,
            availability_zones=[
                test.names[0],
                test.names[1],
            ],
            eip1={
                "bandwidth_name": bandwidth_name1,
                "type": "5_bgp",
                "bandwidth_size": 5,
                "charge_mode": "traffic",
            },
            eip2={
                "bandwidth_name": bandwidth_name2,
                "type": "5_bgp",
                "bandwidth_size": 5,
                "charge_mode": "traffic",
            })
        ```

        ### Creating a private VPN gateway with Enterprise Router

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud
        import pulumi_sbercloud as sbercloud

        config = pulumi.Config()
        name = config.require_object("name")
        er_id = config.require_object("erId")
        access_vpc_id = config.require_object("accessVpcId")
        access_subnet_id = config.require_object("accessSubnetId")
        access_private_ip1 = config.require_object("accessPrivateIp1")
        access_private_ip2 = config.require_object("accessPrivateIp2")
        test = sbercloud.get_vpn_gateway_availability_zones(flavor="professional1",
            attachment_type="er")
        test_vpn_gateway = sbercloud.VpnGateway("test",
            name=name,
            network_type="private",
            attachment_type="er",
            er_id=er_id,
            availability_zones=[
                test.names[0],
                test.names[1],
            ],
            access_vpc_id=access_vpc_id,
            access_subnet_id=access_subnet_id,
            access_private_ip1=access_private_ip1,
            access_private_ip2=access_private_ip2)
        ```

        ### Creating a GM VPN gateway with certificate

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud
        import pulumi_sbercloud as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        cidr = config.require_object("cidr")
        subnet_id = config.require_object("subnetId")
        test = sbercloud.get_vpn_gateway_availability_zones(attachment_type="er",
            flavor="GM")
        test_vpn_gateway = sbercloud.VpnGateway("test",
            name="test",
            vpc_id=vpc_id,
            flavor="GM",
            network_type="private",
            local_subnets=[cidr],
            connect_subnet=subnet_id,
            availability_zones=[
                test.names[0],
                test.names[1],
            ],
            certificate={
                "name": "test",
                "content": \"\"\"-----BEGIN CERTIFICATE-----
        THIS IS YOUR CERT CONTENT
        -----END CERTIFICATE-----\"\"\",
                "private_key": \"\"\"-----BEGIN EC PRIVATE KEY-----
        THIS IS YOUR PRIVATE KEY CONTENT
        -----END EC PRIVATE KEY-----\"\"\",
                "certificate_chain": \"\"\"-----BEGIN CERTIFICATE-----
        THIS IS YOUR CERTIFICATE CHAIN CONTENT
        -----END CERTIFICATE-----\"\"\",
                "enc_certificate": \"\"\"-----BEGIN CERTIFICATE-----
        THIS IS YOUR ENC CERTIFICATE CONTENT
        -----END CERTIFICATE-----\"\"\",
                "enc_private_key": \"\"\"-----BEGIN EC PRIVATE KEY-----
        THIS IS YOUR ENC PRIVATE KEY CONTENT
        -----END EC PRIVATE KEY-----\"\"\",
            })
        ```

        ## Import

        The gateway can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/vpnGateway:VpnGateway test <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_private_ip1: The private IP 1 in private network type VPN gateway.
               It is the master IP 1 in **active-active** HA mode, and the master IP in **active-standby** HA mode.
               Must declare the **access_private_ip_2** at the same time, and can not use the same IP value.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] access_private_ip2: The private IP 2 in private network type VPN gateway.
               It is the master IP 2 in **active-active** HA mode, and the slave IP in **active-standby** HA mode.
               Must declare the **access_private_ip_1** at the same time, and can not use the same IP value.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] access_subnet_id: The access subnet ID.
               The default value is the value of `connect_subnet`.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] access_vpc_id: The access VPC ID.
               The default value is the value of `vpc_id`.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] asn: The ASN number of BGP. The value ranges from **1** to **4294967295**.
               Defaults to **64512**
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] attachment_type: The attachment type. The value can be **vpc** and **er**.
               Defaults to **vpc**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: The list of availability zone IDs.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Union['VpnGatewayCertificateArgs', 'VpnGatewayCertificateArgsDict']] certificate: The GM certificate of the **GM** flavor gateway.
               The object structure is documented below.
        :param pulumi.Input[_builtins.str] connect_subnet: The Network ID of the VPC subnet used by the VPN gateway.
               This parameter is mandatory when `attachment_type` is **vpc**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] delete_eip_on_termination: Whether to delete the EIP when the VPN gateway is deleted.
        :param pulumi.Input[Union['VpnGatewayEip1Args', 'VpnGatewayEip1ArgsDict']] eip1: The master 1 IP in active-active VPN gateway or the master IP
               in active-standby VPN gateway. This parameter is mandatory when `network_type` is **public** or left empty.
               The object structure is documented below.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Union['VpnGatewayEip2Args', 'VpnGatewayEip2ArgsDict']] eip2: The master 2 IP in active-active VPN gateway or the slave IP
               in active-standby VPN gateway. This parameter is mandatory when `network_type` is **public** or left empty.
               The object structure is documented below.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project ID.
               
               <a name="Gateway_CreateRequestEip"></a>
               The `eip1` or `eip2` block supports:
        :param pulumi.Input[_builtins.str] er_id: The enterprise router ID to attach with to VPN gateway.
               This parameter is mandatory when `attachment_type` is **er**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] flavor: The flavor of the VPN gateway.
               The value can be **Basic**, **Professional1**, **Professional2** and **GM**. Defaults to **Professional1**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] ha_mode: The HA mode of VPN gateway. Valid values are **active-active** and
               **active-standby**. The default value is **active-active**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] local_subnets: The list of local subnets.
               This parameter is mandatory when `attachment_type` is **vpc**.
        :param pulumi.Input[_builtins.str] name: The name of the gateway certificate.
        :param pulumi.Input[_builtins.str] network_type: The network type. The value can be **public** and **private**.
               Defaults to **public**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the tags of the VPN gateway.
               
               <a name="Gateway_certificate_attr"></a>
               The `certificate` block supports:
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC to which the VPN gateway is connected.
               This parameter is mandatory when `attachment_type` is **vpc**.
               
               Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpnGatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a VPN gateway resource within SberCloud.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud
        import pulumi_sbercloud as sbercloud

        config = pulumi.Config()
        name = config.require_object("name")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        eip_id1 = config.require_object("eipId1")
        eip_id2 = config.require_object("eipId2")
        test = sbercloud.get_vpn_gateway_availability_zones(flavor="professional1",
            attachment_type="vpc")
        test_vpn_gateway = sbercloud.VpnGateway("test",
            name=name,
            vpc_id=vpc_id,
            local_subnets=[
                "192.168.0.0/24",
                "192.168.1.0/24",
            ],
            connect_subnet=subnet_id,
            availability_zones=[
                test.names[0],
                test.names[1],
            ],
            eip1={
                "id": eip_id1,
            },
            eip2={
                "id": eip_id2,
            })
        ```

        ### Creating a VPN gateway with creating new EIPs

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud
        import pulumi_sbercloud as sbercloud

        config = pulumi.Config()
        name = config.require_object("name")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        bandwidth_name1 = config.require_object("bandwidthName1")
        bandwidth_name2 = config.require_object("bandwidthName2")
        test = sbercloud.get_vpn_gateway_availability_zones(flavor="professional1",
            attachment_type="vpc")
        test_vpn_gateway = sbercloud.VpnGateway("test",
            name=name,
            vpc_id=vpc_id,
            local_subnets=[
                "192.168.0.0/24",
                "192.168.1.0/24",
            ],
            connect_subnet=subnet_id,
            availability_zones=[
                test.names[0],
                test.names[1],
            ],
            eip1={
                "bandwidth_name": bandwidth_name1,
                "type": "5_bgp",
                "bandwidth_size": 5,
                "charge_mode": "traffic",
            },
            eip2={
                "bandwidth_name": bandwidth_name2,
                "type": "5_bgp",
                "bandwidth_size": 5,
                "charge_mode": "traffic",
            })
        ```

        ### Creating a private VPN gateway with Enterprise Router

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud
        import pulumi_sbercloud as sbercloud

        config = pulumi.Config()
        name = config.require_object("name")
        er_id = config.require_object("erId")
        access_vpc_id = config.require_object("accessVpcId")
        access_subnet_id = config.require_object("accessSubnetId")
        access_private_ip1 = config.require_object("accessPrivateIp1")
        access_private_ip2 = config.require_object("accessPrivateIp2")
        test = sbercloud.get_vpn_gateway_availability_zones(flavor="professional1",
            attachment_type="er")
        test_vpn_gateway = sbercloud.VpnGateway("test",
            name=name,
            network_type="private",
            attachment_type="er",
            er_id=er_id,
            availability_zones=[
                test.names[0],
                test.names[1],
            ],
            access_vpc_id=access_vpc_id,
            access_subnet_id=access_subnet_id,
            access_private_ip1=access_private_ip1,
            access_private_ip2=access_private_ip2)
        ```

        ### Creating a GM VPN gateway with certificate

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud
        import pulumi_sbercloud as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        cidr = config.require_object("cidr")
        subnet_id = config.require_object("subnetId")
        test = sbercloud.get_vpn_gateway_availability_zones(attachment_type="er",
            flavor="GM")
        test_vpn_gateway = sbercloud.VpnGateway("test",
            name="test",
            vpc_id=vpc_id,
            flavor="GM",
            network_type="private",
            local_subnets=[cidr],
            connect_subnet=subnet_id,
            availability_zones=[
                test.names[0],
                test.names[1],
            ],
            certificate={
                "name": "test",
                "content": \"\"\"-----BEGIN CERTIFICATE-----
        THIS IS YOUR CERT CONTENT
        -----END CERTIFICATE-----\"\"\",
                "private_key": \"\"\"-----BEGIN EC PRIVATE KEY-----
        THIS IS YOUR PRIVATE KEY CONTENT
        -----END EC PRIVATE KEY-----\"\"\",
                "certificate_chain": \"\"\"-----BEGIN CERTIFICATE-----
        THIS IS YOUR CERTIFICATE CHAIN CONTENT
        -----END CERTIFICATE-----\"\"\",
                "enc_certificate": \"\"\"-----BEGIN CERTIFICATE-----
        THIS IS YOUR ENC CERTIFICATE CONTENT
        -----END CERTIFICATE-----\"\"\",
                "enc_private_key": \"\"\"-----BEGIN EC PRIVATE KEY-----
        THIS IS YOUR ENC PRIVATE KEY CONTENT
        -----END EC PRIVATE KEY-----\"\"\",
            })
        ```

        ## Import

        The gateway can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/vpnGateway:VpnGateway test <id>
        ```

        :param str resource_name: The name of the resource.
        :param VpnGatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpnGatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_private_ip1: Optional[pulumi.Input[_builtins.str]] = None,
                 access_private_ip2: Optional[pulumi.Input[_builtins.str]] = None,
                 access_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 access_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 asn: Optional[pulumi.Input[_builtins.int]] = None,
                 attachment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 certificate: Optional[pulumi.Input[Union['VpnGatewayCertificateArgs', 'VpnGatewayCertificateArgsDict']]] = None,
                 connect_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_eip_on_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 eip1: Optional[pulumi.Input[Union['VpnGatewayEip1Args', 'VpnGatewayEip1ArgsDict']]] = None,
                 eip2: Optional[pulumi.Input[Union['VpnGatewayEip2Args', 'VpnGatewayEip2ArgsDict']]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 er_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor: Optional[pulumi.Input[_builtins.str]] = None,
                 ha_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 local_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 master_eip: Optional[pulumi.Input[Union['VpnGatewayMasterEipArgs', 'VpnGatewayMasterEipArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 slave_eip: Optional[pulumi.Input[Union['VpnGatewaySlaveEipArgs', 'VpnGatewaySlaveEipArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpnGatewayArgs.__new__(VpnGatewayArgs)

            __props__.__dict__["access_private_ip1"] = access_private_ip1
            __props__.__dict__["access_private_ip2"] = access_private_ip2
            __props__.__dict__["access_subnet_id"] = access_subnet_id
            __props__.__dict__["access_vpc_id"] = access_vpc_id
            __props__.__dict__["asn"] = asn
            __props__.__dict__["attachment_type"] = attachment_type
            if availability_zones is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zones'")
            __props__.__dict__["availability_zones"] = availability_zones
            __props__.__dict__["certificate"] = certificate
            __props__.__dict__["connect_subnet"] = connect_subnet
            __props__.__dict__["delete_eip_on_termination"] = delete_eip_on_termination
            __props__.__dict__["eip1"] = eip1
            __props__.__dict__["eip2"] = eip2
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["er_id"] = er_id
            __props__.__dict__["flavor"] = flavor
            __props__.__dict__["ha_mode"] = ha_mode
            __props__.__dict__["local_subnets"] = local_subnets
            __props__.__dict__["master_eip"] = master_eip
            __props__.__dict__["name"] = name
            __props__.__dict__["network_type"] = network_type
            __props__.__dict__["region"] = region
            __props__.__dict__["slave_eip"] = slave_eip
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["er_attachment_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["used_connection_group"] = None
            __props__.__dict__["used_connection_number"] = None
        super(VpnGateway, __self__).__init__(
            'sbercloud:index/vpnGateway:VpnGateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_private_ip1: Optional[pulumi.Input[_builtins.str]] = None,
            access_private_ip2: Optional[pulumi.Input[_builtins.str]] = None,
            access_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            access_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            asn: Optional[pulumi.Input[_builtins.int]] = None,
            attachment_type: Optional[pulumi.Input[_builtins.str]] = None,
            availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            certificate: Optional[pulumi.Input[Union['VpnGatewayCertificateArgs', 'VpnGatewayCertificateArgsDict']]] = None,
            connect_subnet: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            delete_eip_on_termination: Optional[pulumi.Input[_builtins.bool]] = None,
            eip1: Optional[pulumi.Input[Union['VpnGatewayEip1Args', 'VpnGatewayEip1ArgsDict']]] = None,
            eip2: Optional[pulumi.Input[Union['VpnGatewayEip2Args', 'VpnGatewayEip2ArgsDict']]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            er_attachment_id: Optional[pulumi.Input[_builtins.str]] = None,
            er_id: Optional[pulumi.Input[_builtins.str]] = None,
            flavor: Optional[pulumi.Input[_builtins.str]] = None,
            ha_mode: Optional[pulumi.Input[_builtins.str]] = None,
            local_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            master_eip: Optional[pulumi.Input[Union['VpnGatewayMasterEipArgs', 'VpnGatewayMasterEipArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_type: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            slave_eip: Optional[pulumi.Input[Union['VpnGatewaySlaveEipArgs', 'VpnGatewaySlaveEipArgsDict']]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            used_connection_group: Optional[pulumi.Input[_builtins.int]] = None,
            used_connection_number: Optional[pulumi.Input[_builtins.int]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'VpnGateway':
        """
        Get an existing VpnGateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_private_ip1: The private IP 1 in private network type VPN gateway.
               It is the master IP 1 in **active-active** HA mode, and the master IP in **active-standby** HA mode.
               Must declare the **access_private_ip_2** at the same time, and can not use the same IP value.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] access_private_ip2: The private IP 2 in private network type VPN gateway.
               It is the master IP 2 in **active-active** HA mode, and the slave IP in **active-standby** HA mode.
               Must declare the **access_private_ip_1** at the same time, and can not use the same IP value.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] access_subnet_id: The access subnet ID.
               The default value is the value of `connect_subnet`.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] access_vpc_id: The access VPC ID.
               The default value is the value of `vpc_id`.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] asn: The ASN number of BGP. The value ranges from **1** to **4294967295**.
               Defaults to **64512**
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] attachment_type: The attachment type. The value can be **vpc** and **er**.
               Defaults to **vpc**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: The list of availability zone IDs.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Union['VpnGatewayCertificateArgs', 'VpnGatewayCertificateArgsDict']] certificate: The GM certificate of the **GM** flavor gateway.
               The object structure is documented below.
        :param pulumi.Input[_builtins.str] connect_subnet: The Network ID of the VPC subnet used by the VPN gateway.
               This parameter is mandatory when `attachment_type` is **vpc**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] created_at: The create time of the gateway certificate.
        :param pulumi.Input[_builtins.bool] delete_eip_on_termination: Whether to delete the EIP when the VPN gateway is deleted.
        :param pulumi.Input[Union['VpnGatewayEip1Args', 'VpnGatewayEip1ArgsDict']] eip1: The master 1 IP in active-active VPN gateway or the master IP
               in active-standby VPN gateway. This parameter is mandatory when `network_type` is **public** or left empty.
               The object structure is documented below.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Union['VpnGatewayEip2Args', 'VpnGatewayEip2ArgsDict']] eip2: The master 2 IP in active-active VPN gateway or the slave IP
               in active-standby VPN gateway. This parameter is mandatory when `network_type` is **public** or left empty.
               The object structure is documented below.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project ID.
               
               <a name="Gateway_CreateRequestEip"></a>
               The `eip1` or `eip2` block supports:
        :param pulumi.Input[_builtins.str] er_attachment_id: The ER attachment ID.
        :param pulumi.Input[_builtins.str] er_id: The enterprise router ID to attach with to VPN gateway.
               This parameter is mandatory when `attachment_type` is **er**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] flavor: The flavor of the VPN gateway.
               The value can be **Basic**, **Professional1**, **Professional2** and **GM**. Defaults to **Professional1**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] ha_mode: The HA mode of VPN gateway. Valid values are **active-active** and
               **active-standby**. The default value is **active-active**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] local_subnets: The list of local subnets.
               This parameter is mandatory when `attachment_type` is **vpc**.
        :param pulumi.Input[_builtins.str] name: The name of the gateway certificate.
        :param pulumi.Input[_builtins.str] network_type: The network type. The value can be **public** and **private**.
               Defaults to **public**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] status: The status of the certificate.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the tags of the VPN gateway.
               
               <a name="Gateway_certificate_attr"></a>
               The `certificate` block supports:
        :param pulumi.Input[_builtins.str] updated_at: The update time of the gateway certificate.
        :param pulumi.Input[_builtins.int] used_connection_group: The number of used connection groups.
        :param pulumi.Input[_builtins.int] used_connection_number: The number of used connections.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC to which the VPN gateway is connected.
               This parameter is mandatory when `attachment_type` is **vpc**.
               
               Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpnGatewayState.__new__(_VpnGatewayState)

        __props__.__dict__["access_private_ip1"] = access_private_ip1
        __props__.__dict__["access_private_ip2"] = access_private_ip2
        __props__.__dict__["access_subnet_id"] = access_subnet_id
        __props__.__dict__["access_vpc_id"] = access_vpc_id
        __props__.__dict__["asn"] = asn
        __props__.__dict__["attachment_type"] = attachment_type
        __props__.__dict__["availability_zones"] = availability_zones
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["connect_subnet"] = connect_subnet
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["delete_eip_on_termination"] = delete_eip_on_termination
        __props__.__dict__["eip1"] = eip1
        __props__.__dict__["eip2"] = eip2
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["er_attachment_id"] = er_attachment_id
        __props__.__dict__["er_id"] = er_id
        __props__.__dict__["flavor"] = flavor
        __props__.__dict__["ha_mode"] = ha_mode
        __props__.__dict__["local_subnets"] = local_subnets
        __props__.__dict__["master_eip"] = master_eip
        __props__.__dict__["name"] = name
        __props__.__dict__["network_type"] = network_type
        __props__.__dict__["region"] = region
        __props__.__dict__["slave_eip"] = slave_eip
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["used_connection_group"] = used_connection_group
        __props__.__dict__["used_connection_number"] = used_connection_number
        __props__.__dict__["vpc_id"] = vpc_id
        return VpnGateway(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessPrivateIp1")
    def access_private_ip1(self) -> pulumi.Output[_builtins.str]:
        """
        The private IP 1 in private network type VPN gateway.
        It is the master IP 1 in **active-active** HA mode, and the master IP in **active-standby** HA mode.
        Must declare the **access_private_ip_2** at the same time, and can not use the same IP value.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "access_private_ip1")

    @_builtins.property
    @pulumi.getter(name="accessPrivateIp2")
    def access_private_ip2(self) -> pulumi.Output[_builtins.str]:
        """
        The private IP 2 in private network type VPN gateway.
        It is the master IP 2 in **active-active** HA mode, and the slave IP in **active-standby** HA mode.
        Must declare the **access_private_ip_1** at the same time, and can not use the same IP value.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "access_private_ip2")

    @_builtins.property
    @pulumi.getter(name="accessSubnetId")
    def access_subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        The access subnet ID.
        The default value is the value of `connect_subnet`.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "access_subnet_id")

    @_builtins.property
    @pulumi.getter(name="accessVpcId")
    def access_vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The access VPC ID.
        The default value is the value of `vpc_id`.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "access_vpc_id")

    @_builtins.property
    @pulumi.getter
    def asn(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The ASN number of BGP. The value ranges from **1** to **4294967295**.
        Defaults to **64512**

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "asn")

    @_builtins.property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The attachment type. The value can be **vpc** and **er**.
        Defaults to **vpc**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "attachment_type")

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of availability zone IDs.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> pulumi.Output['outputs.VpnGatewayCertificate']:
        """
        The GM certificate of the **GM** flavor gateway.
        The object structure is documented below.
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter(name="connectSubnet")
    def connect_subnet(self) -> pulumi.Output[_builtins.str]:
        """
        The Network ID of the VPC subnet used by the VPN gateway.
        This parameter is mandatory when `attachment_type` is **vpc**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "connect_subnet")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The create time of the gateway certificate.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="deleteEipOnTermination")
    def delete_eip_on_termination(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to delete the EIP when the VPN gateway is deleted.
        """
        return pulumi.get(self, "delete_eip_on_termination")

    @_builtins.property
    @pulumi.getter
    def eip1(self) -> pulumi.Output['outputs.VpnGatewayEip1']:
        """
        The master 1 IP in active-active VPN gateway or the master IP
        in active-standby VPN gateway. This parameter is mandatory when `network_type` is **public** or left empty.
        The object structure is documented below.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "eip1")

    @_builtins.property
    @pulumi.getter
    def eip2(self) -> pulumi.Output['outputs.VpnGatewayEip2']:
        """
        The master 2 IP in active-active VPN gateway or the slave IP
        in active-standby VPN gateway. This parameter is mandatory when `network_type` is **public** or left empty.
        The object structure is documented below.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "eip2")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The enterprise project ID.

        <a name="Gateway_CreateRequestEip"></a>
        The `eip1` or `eip2` block supports:
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="erAttachmentId")
    def er_attachment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ER attachment ID.
        """
        return pulumi.get(self, "er_attachment_id")

    @_builtins.property
    @pulumi.getter(name="erId")
    def er_id(self) -> pulumi.Output[_builtins.str]:
        """
        The enterprise router ID to attach with to VPN gateway.
        This parameter is mandatory when `attachment_type` is **er**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "er_id")

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> pulumi.Output[_builtins.str]:
        """
        The flavor of the VPN gateway.
        The value can be **Basic**, **Professional1**, **Professional2** and **GM**. Defaults to **Professional1**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "flavor")

    @_builtins.property
    @pulumi.getter(name="haMode")
    def ha_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The HA mode of VPN gateway. Valid values are **active-active** and
        **active-standby**. The default value is **active-active**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ha_mode")

    @_builtins.property
    @pulumi.getter(name="localSubnets")
    def local_subnets(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of local subnets.
        This parameter is mandatory when `attachment_type` is **vpc**.
        """
        return pulumi.get(self, "local_subnets")

    @_builtins.property
    @pulumi.getter(name="masterEip")
    def master_eip(self) -> pulumi.Output['outputs.VpnGatewayMasterEip']:
        return pulumi.get(self, "master_eip")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the gateway certificate.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> pulumi.Output[_builtins.str]:
        """
        The network type. The value can be **public** and **private**.
        Defaults to **public**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="slaveEip")
    def slave_eip(self) -> pulumi.Output['outputs.VpnGatewaySlaveEip']:
        return pulumi.get(self, "slave_eip")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the certificate.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the tags of the VPN gateway.

        <a name="Gateway_certificate_attr"></a>
        The `certificate` block supports:
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The update time of the gateway certificate.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="usedConnectionGroup")
    def used_connection_group(self) -> pulumi.Output[_builtins.int]:
        """
        The number of used connection groups.
        """
        return pulumi.get(self, "used_connection_group")

    @_builtins.property
    @pulumi.getter(name="usedConnectionNumber")
    def used_connection_number(self) -> pulumi.Output[_builtins.int]:
        """
        The number of used connections.
        """
        return pulumi.get(self, "used_connection_number")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VPC to which the VPN gateway is connected.
        This parameter is mandatory when `attachment_type` is **vpc**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

