from typing import Protocol


class PyJrkSettingsProperties(Protocol):
    """Base class for PyJrk_Settings with static property definitions for IDE support."""

    @property
    def product(self) -> int: ...

    @product.setter
    def product(self, value: int) -> None: ...

    @property
    def firmware_version(self) -> int: ...

    @firmware_version.setter
    def firmware_version(self, value: int) -> None: ...

    @property
    def input_mode(self) -> int: ...

    @input_mode.setter
    def input_mode(self, value: int) -> None: ...

    @property
    def input_error_minimum(self) -> int: ...

    @input_error_minimum.setter
    def input_error_minimum(self, value: int) -> None: ...

    @property
    def input_error_maximum(self) -> int: ...

    @input_error_maximum.setter
    def input_error_maximum(self, value: int) -> None: ...

    @property
    def input_minimum(self) -> int: ...

    @input_minimum.setter
    def input_minimum(self, value: int) -> None: ...

    @property
    def input_maximum(self) -> int: ...

    @input_maximum.setter
    def input_maximum(self, value: int) -> None: ...

    @property
    def input_neutral_minimum(self) -> int: ...

    @input_neutral_minimum.setter
    def input_neutral_minimum(self, value: int) -> None: ...

    @property
    def input_neutral_maximum(self) -> int: ...

    @input_neutral_maximum.setter
    def input_neutral_maximum(self, value: int) -> None: ...

    @property
    def output_minimum(self) -> int: ...

    @output_minimum.setter
    def output_minimum(self, value: int) -> None: ...

    @property
    def output_neutral(self) -> int: ...

    @output_neutral.setter
    def output_neutral(self, value: int) -> None: ...

    @property
    def output_maximum(self) -> int: ...

    @output_maximum.setter
    def output_maximum(self, value: int) -> None: ...

    @property
    def input_invert(self) -> bool: ...

    @input_invert.setter
    def input_invert(self, value: bool) -> None: ...

    @property
    def input_scaling_degree(self) -> int: ...

    @input_scaling_degree.setter
    def input_scaling_degree(self, value: int) -> None: ...

    @property
    def input_detect_disconnect(self) -> bool: ...

    @input_detect_disconnect.setter
    def input_detect_disconnect(self, value: bool) -> None: ...

    @property
    def input_analog_samples_exponent(self) -> int: ...

    @input_analog_samples_exponent.setter
    def input_analog_samples_exponent(self, value: int) -> None: ...

    @property
    def feedback_mode(self) -> int: ...

    @feedback_mode.setter
    def feedback_mode(self, value: int) -> None: ...

    @property
    def feedback_error_minimum(self) -> int: ...

    @feedback_error_minimum.setter
    def feedback_error_minimum(self, value: int) -> None: ...

    @property
    def feedback_error_maximum(self) -> int: ...

    @feedback_error_maximum.setter
    def feedback_error_maximum(self, value: int) -> None: ...

    @property
    def feedback_minimum(self) -> int: ...

    @feedback_minimum.setter
    def feedback_minimum(self, value: int) -> None: ...

    @property
    def feedback_maximum(self) -> int: ...

    @feedback_maximum.setter
    def feedback_maximum(self, value: int) -> None: ...

    @property
    def feedback_invert(self) -> bool: ...

    @feedback_invert.setter
    def feedback_invert(self, value: bool) -> None: ...

    @property
    def feedback_detect_disconnect(self) -> bool: ...

    @feedback_detect_disconnect.setter
    def feedback_detect_disconnect(self, value: bool) -> None: ...

    @property
    def feedback_dead_zone(self) -> int: ...

    @feedback_dead_zone.setter
    def feedback_dead_zone(self, value: int) -> None: ...

    @property
    def feedback_analog_samples_exponent(self) -> int: ...

    @feedback_analog_samples_exponent.setter
    def feedback_analog_samples_exponent(self, value: int) -> None: ...

    @property
    def feedback_wraparound(self) -> bool: ...

    @feedback_wraparound.setter
    def feedback_wraparound(self, value: bool) -> None: ...

    @property
    def serial_mode(self) -> int: ...

    @serial_mode.setter
    def serial_mode(self, value: int) -> None: ...

    @property
    def serial_baud_rate(self) -> int: ...

    @serial_baud_rate.setter
    def serial_baud_rate(self, value: int) -> None: ...

    @property
    def serial_timeout(self) -> int: ...

    @serial_timeout.setter
    def serial_timeout(self, value: int) -> None: ...

    @property
    def serial_device_number(self) -> int: ...

    @serial_device_number.setter
    def serial_device_number(self, value: int) -> None: ...

    @property
    def never_sleep(self) -> bool: ...

    @never_sleep.setter
    def never_sleep(self, value: bool) -> None: ...

    @property
    def serial_enable_crc(self) -> bool: ...

    @serial_enable_crc.setter
    def serial_enable_crc(self, value: bool) -> None: ...

    @property
    def serial_enable_14bit_device_number(self) -> bool: ...

    @serial_enable_14bit_device_number.setter
    def serial_enable_14bit_device_number(self, value: bool) -> None: ...

    @property
    def serial_disable_compact_protocol(self) -> bool: ...

    @serial_disable_compact_protocol.setter
    def serial_disable_compact_protocol(self, value: bool) -> None: ...

    @property
    def proportional_multiplier(self) -> int: ...

    @proportional_multiplier.setter
    def proportional_multiplier(self, value: int) -> None: ...

    @property
    def proportional_exponent(self) -> int: ...

    @proportional_exponent.setter
    def proportional_exponent(self, value: int) -> None: ...

    @property
    def integral_multiplier(self) -> int: ...

    @integral_multiplier.setter
    def integral_multiplier(self, value: int) -> None: ...

    @property
    def integral_exponent(self) -> int: ...

    @integral_exponent.setter
    def integral_exponent(self, value: int) -> None: ...

    @property
    def derivative_multiplier(self) -> int: ...

    @derivative_multiplier.setter
    def derivative_multiplier(self, value: int) -> None: ...

    @property
    def derivative_exponent(self) -> int: ...

    @derivative_exponent.setter
    def derivative_exponent(self, value: int) -> None: ...

    @property
    def pid_period(self) -> int: ...

    @pid_period.setter
    def pid_period(self, value: int) -> None: ...

    @property
    def integral_divider_exponent(self) -> int: ...

    @integral_divider_exponent.setter
    def integral_divider_exponent(self, value: int) -> None: ...

    @property
    def integral_limit(self) -> int: ...

    @integral_limit.setter
    def integral_limit(self, value: int) -> None: ...

    @property
    def reset_integral(self) -> bool: ...

    @reset_integral.setter
    def reset_integral(self, value: bool) -> None: ...

    @property
    def pwm_frequency(self) -> int: ...

    @pwm_frequency.setter
    def pwm_frequency(self, value: int) -> None: ...

    @property
    def current_samples_exponent(self) -> int: ...

    @current_samples_exponent.setter
    def current_samples_exponent(self, value: int) -> None: ...

    @property
    def hard_overcurrent_threshold(self) -> int: ...

    @hard_overcurrent_threshold.setter
    def hard_overcurrent_threshold(self, value: int) -> None: ...

    @property
    def current_offset_calibration(self) -> int: ...

    @current_offset_calibration.setter
    def current_offset_calibration(self, value: int) -> None: ...

    @property
    def current_scale_calibration(self) -> int: ...

    @current_scale_calibration.setter
    def current_scale_calibration(self, value: int) -> None: ...

    @property
    def motor_invert(self) -> bool: ...

    @motor_invert.setter
    def motor_invert(self, value: bool) -> None: ...

    @property
    def max_duty_cycle_while_feedback_out_of_range(self) -> int: ...

    @max_duty_cycle_while_feedback_out_of_range.setter
    def max_duty_cycle_while_feedback_out_of_range(self, value: int) -> None: ...

    @property
    def max_acceleration_forward(self) -> int: ...

    @max_acceleration_forward.setter
    def max_acceleration_forward(self, value: int) -> None: ...

    @property
    def max_acceleration_reverse(self) -> int: ...

    @max_acceleration_reverse.setter
    def max_acceleration_reverse(self, value: int) -> None: ...

    @property
    def max_deceleration_forward(self) -> int: ...

    @max_deceleration_forward.setter
    def max_deceleration_forward(self, value: int) -> None: ...

    @property
    def max_deceleration_reverse(self) -> int: ...

    @max_deceleration_reverse.setter
    def max_deceleration_reverse(self, value: int) -> None: ...

    @property
    def max_duty_cycle_forward(self) -> int: ...

    @max_duty_cycle_forward.setter
    def max_duty_cycle_forward(self, value: int) -> None: ...

    @property
    def max_duty_cycle_reverse(self) -> int: ...

    @max_duty_cycle_reverse.setter
    def max_duty_cycle_reverse(self, value: int) -> None: ...

    @property
    def encoded_hard_current_limit_forward(self) -> int: ...

    @encoded_hard_current_limit_forward.setter
    def encoded_hard_current_limit_forward(self, value: int) -> None: ...

    @property
    def encoded_hard_current_limit_reverse(self) -> int: ...

    @encoded_hard_current_limit_reverse.setter
    def encoded_hard_current_limit_reverse(self, value: int) -> None: ...

    @property
    def brake_duration_forward(self) -> int: ...

    @brake_duration_forward.setter
    def brake_duration_forward(self, value: int) -> None: ...

    @property
    def brake_duration_reverse(self) -> int: ...

    @brake_duration_reverse.setter
    def brake_duration_reverse(self, value: int) -> None: ...

    @property
    def soft_current_limit_forward(self) -> int: ...

    @soft_current_limit_forward.setter
    def soft_current_limit_forward(self, value: int) -> None: ...

    @property
    def soft_current_limit_reverse(self) -> int: ...

    @soft_current_limit_reverse.setter
    def soft_current_limit_reverse(self, value: int) -> None: ...

    @property
    def soft_current_regulation_level_forward(self) -> int: ...

    @soft_current_regulation_level_forward.setter
    def soft_current_regulation_level_forward(self, value: int) -> None: ...

    @property
    def soft_current_regulation_level_reverse(self) -> int: ...

    @soft_current_regulation_level_reverse.setter
    def soft_current_regulation_level_reverse(self, value: int) -> None: ...

    @property
    def coast_when_off(self) -> bool: ...

    @coast_when_off.setter
    def coast_when_off(self, value: bool) -> None: ...

    @property
    def error_enable(self) -> int: ...

    @error_enable.setter
    def error_enable(self, value: int) -> None: ...

    @property
    def error_latch(self) -> int: ...

    @error_latch.setter
    def error_latch(self, value: int) -> None: ...

    @property
    def error_hard(self) -> int: ...

    @error_hard.setter
    def error_hard(self, value: int) -> None: ...

    @property
    def vin_calibration(self) -> int: ...

    @vin_calibration.setter
    def vin_calibration(self, value: int) -> None: ...

    @property
    def disable_i2c_pullups(self) -> bool: ...

    @disable_i2c_pullups.setter
    def disable_i2c_pullups(self, value: bool) -> None: ...

    @property
    def analog_sda_pullup(self) -> bool: ...

    @analog_sda_pullup.setter
    def analog_sda_pullup(self, value: bool) -> None: ...

    @property
    def always_analog_sda(self) -> bool: ...

    @always_analog_sda.setter
    def always_analog_sda(self, value: bool) -> None: ...

    @property
    def always_analog_fba(self) -> bool: ...

    @always_analog_fba.setter
    def always_analog_fba(self, value: bool) -> None: ...

    @property
    def fbt_method(self) -> int: ...

    @fbt_method.setter
    def fbt_method(self, value: int) -> None: ...

    @property
    def fbt_timing_clock(self) -> int: ...

    @fbt_timing_clock.setter
    def fbt_timing_clock(self, value: int) -> None: ...

    @property
    def fbt_timing_polarity(self) -> bool: ...

    @fbt_timing_polarity.setter
    def fbt_timing_polarity(self, value: bool) -> None: ...

    @property
    def fbt_timing_timeout(self) -> int: ...

    @fbt_timing_timeout.setter
    def fbt_timing_timeout(self, value: int) -> None: ...

    @property
    def fbt_samples(self) -> int: ...

    @fbt_samples.setter
    def fbt_samples(self, value: int) -> None: ...

    @property
    def fbt_divider_exponent(self) -> int: ...

    @fbt_divider_exponent.setter
    def fbt_divider_exponent(self, value: int) -> None: ...


class PyJrkVariablesProperties(Protocol):
    """Base class for PyJrkVariables with static property definitions for IDE support."""

    @property
    def input(self) -> int: ...

    @input.setter
    def input(self, value: int) -> None: ...

    @property
    def target(self) -> int: ...

    @target.setter
    def target(self, value: int) -> None: ...

    @property
    def feedback(self) -> int: ...

    @feedback.setter
    def feedback(self, value: int) -> None: ...

    @property
    def scaled_feedback(self) -> int: ...

    @scaled_feedback.setter
    def scaled_feedback(self, value: int) -> None: ...

    @property
    def integral(self) -> int: ...

    @integral.setter
    def integral(self, value: int) -> None: ...

    @property
    def duty_cycle_target(self) -> int: ...

    @duty_cycle_target.setter
    def duty_cycle_target(self, value: int) -> None: ...

    @property
    def duty_cycle(self) -> int: ...

    @duty_cycle.setter
    def duty_cycle(self, value: int) -> None: ...

    @property
    def current_low_res(self) -> int: ...

    @current_low_res.setter
    def current_low_res(self, value: int) -> None: ...

    @property
    def pid_period_exceeded(self) -> bool: ...

    @pid_period_exceeded.setter
    def pid_period_exceeded(self, value: bool) -> None: ...

    @property
    def pid_period_count(self) -> int: ...

    @pid_period_count.setter
    def pid_period_count(self, value: int) -> None: ...

    @property
    def error_flags_halting(self) -> int: ...

    @error_flags_halting.setter
    def error_flags_halting(self, value: int) -> None: ...

    @property
    def error_flags_occurred(self) -> int: ...

    @error_flags_occurred.setter
    def error_flags_occurred(self, value: int) -> None: ...

    @property
    def vin_voltage(self) -> int: ...

    @vin_voltage.setter
    def vin_voltage(self, value: int) -> None: ...

    @property
    def current(self) -> int: ...

    @current.setter
    def current(self, value: int) -> None: ...

    @property
    def device_reset(self) -> int: ...

    @device_reset.setter
    def device_reset(self, value: int) -> None: ...

    @property
    def up_time(self) -> int: ...

    @up_time.setter
    def up_time(self, value: int) -> None: ...

    @property
    def rc_pulse_width(self) -> int: ...

    @rc_pulse_width.setter
    def rc_pulse_width(self, value: int) -> None: ...

    @property
    def fbt_reading(self) -> int: ...

    @fbt_reading.setter
    def fbt_reading(self, value: int) -> None: ...

    @property
    def raw_current(self) -> int: ...

    @raw_current.setter
    def raw_current(self, value: int) -> None: ...

    @property
    def encoded_hard_current_limit(self) -> int: ...

    @encoded_hard_current_limit.setter
    def encoded_hard_current_limit(self, value: int) -> None: ...

    @property
    def last_duty_cycle(self) -> int: ...

    @last_duty_cycle.setter
    def last_duty_cycle(self, value: int) -> None: ...

    @property
    def current_chopping_consecutive_count(self) -> int: ...

    @current_chopping_consecutive_count.setter
    def current_chopping_consecutive_count(self, value: int) -> None: ...

    @property
    def current_chopping_occurrence_count(self) -> int: ...

    @current_chopping_occurrence_count.setter
    def current_chopping_occurrence_count(self, value: int) -> None: ...

    @property
    def force_mode(self) -> int: ...

    @force_mode.setter
    def force_mode(self, value: int) -> None: ...
