jrk_constant = {
    # Present in jrk.h
    "JRK_PRODUCT_UMC04A_30V": 1,
    "JRK_PRODUCT_UMC04A_40V": 2,
    "JRK_PRODUCT_UMC05A_30V": 3,
    "JRK_PRODUCT_UMC05A_40V": 4,
    "JRK_PRODUCT_UMC06A":    5,

    # Present in jrk_protocol.h
    'JRK_USB_VENDOR_ID': 0x1FFB,
    'JRK_USB_PRODUCT_ID_UMC04A_30V': 0x00B7,
    'JRK_USB_PRODUCT_ID_UMC04A_40V': 0x00B9,
    'JRK_USB_PRODUCT_ID_UMC05A_30V': 0x00BF,
    'JRK_USB_PRODUCT_ID_UMC05A_40V': 0x00C1,
    'JRK_USB_PRODUCT_ID_UMC06A': 0x00C5,
    
    'JRK_CMD_REINITIALIZE': 0x10,
    'JRK_CMD_SET_EEPROM_SETTING': 0x13,
    'JRK_CMD_GET_DEBUG_DATA': 0x20,
    'JRK_CMD_GET_VARIABLE_SERIAL': 0x80,
    'JRK_CMD_GET_ERROR_FLAGS_HALTING_SERIAL': 0xB3,
    'JRK_CMD_GET_ERROR_FLAGS_OCCURRED_SERIAL': 0xB5,
    'JRK_CMD_SET_TARGET_USB': 0x84,
    'JRK_CMD_STOP_MOTOR_USB': 0x87,
    'JRK_CMD_SET_TARGET_SERIAL': 0xC0,
    'JRK_CMD_SET_TARGET_LOW_RES_REV': 0xE0,
    'JRK_CMD_SET_TARGET_LOW_RES_FWD': 0xE1,
    'JRK_CMD_GET_EEPROM_SETTINGS': 0xE3,
    'JRK_CMD_GET_VARIABLES': 0xE5,
    'JRK_CMD_SET_RAM_SETTINGS': 0xE6,
    'JRK_CMD_GET_RAM_SETTINGS': 0xEA,
    'JRK_CMD_GET_CURRENT_CHOPPING_OCCURRENCE_COUNT': 0xEC,
    'JRK_CMD_FORCE_DUTY_CYCLE_TARGET': 0xF2,
    'JRK_CMD_FORCE_DUTY_CYCLE': 0xF4,
    'JRK_CMD_STOP_MOTOR_SERIAL': 0xFF,
    'JRK_CMD_START_BOOTLOADER': 0xFF,
    
    'JRK_CMD_GET_VARIABLE_SERIAL_MASK': 0xC0,
    'JRK_CMD_SET_TARGET_SERIAL_MASK': 0xE0,
    
    'JRK_GET_VARIABLES_FLAG_CLEAR_ERROR_FLAGS_HALTING': 0,
    'JRK_GET_VARIABLES_FLAG_CLEAR_ERROR_FLAGS_OCCURRED': 1,
    'JRK_GET_VARIABLES_FLAG_CLEAR_CURRENT_CHOPPING_OCCURRENCE_COUNT': 2,
    
    'JRK_REINITIALIZE_FLAG_PRESERVE_ERRORS': 0,
    
    'JRK_VAR_INPUT': 0x00,
    'JRK_VAR_TARGET': 0x02,
    'JRK_VAR_FEEDBACK': 0x04,
    'JRK_VAR_SCALED_FEEDBACK': 0x06,
    'JRK_VAR_INTEGRAL': 0x08,
    'JRK_VAR_DUTY_CYCLE_TARGET': 0x0A,
    'JRK_VAR_DUTY_CYCLE': 0x0C,
    'JRK_VAR_CURRENT_LOW_RES': 0x0E,
    'JRK_VAR_PID_PERIOD_EXCEEDED': 0x0F,
    'JRK_VAR_PID_PERIOD_COUNT': 0x10,
    'JRK_VAR_ERROR_FLAGS_HALTING': 0x12,
    'JRK_VAR_ERROR_FLAGS_OCCURRED': 0x14,
    'JRK_VAR_FLAG_BYTE1': 0x16,
    'JRK_VAR_VIN_VOLTAGE': 0x17,
    'JRK_VAR_CURRENT': 0x19,
    'JRK_VAR_DEVICE_RESET': 0x1F,
    'JRK_VAR_UP_TIME': 0x20,
    'JRK_VAR_RC_PULSE_WIDTH': 0x24,
    'JRK_VAR_FBT_READING': 0x26,
    'JRK_VAR_ANALOG_READING_SDA': 0x28,
    'JRK_VAR_ANALOG_READING_FBA': 0x2A,
    'JRK_VAR_DIGITAL_READINGS': 0x2C,
    'JRK_VAR_RAW_CURRENT': 0x2D,
    'JRK_VAR_ENCODED_HARD_CURRENT_LIMIT': 0x2F,
    'JRK_VAR_LAST_DUTY_CYCLE': 0x31,
    'JRK_VAR_CURRENT_CHOPPING_CONSECUTIVE_COUNT': 0x33,
    'JRK_VAR_CURRENT_CHOPPING_OCCURRENCE_COUNT': 0x34,
    'JRK_VARIABLES_SIZE': 0x35,
    
    'JRK_SETTING_NOT_INITIALIZED': 0x00,
    'JRK_SETTING_OPTIONS_BYTE1': 0x01,
    'JRK_SETTING_OPTIONS_BYTE2': 0x02,
    'JRK_SETTING_INPUT_MODE': 0x03,
    'JRK_SETTING_INPUT_ERROR_MINIMUM': 0x04,
    'JRK_SETTING_INPUT_ERROR_MAXIMUM': 0x06,
    'JRK_SETTING_INPUT_MINIMUM': 0x08,
    'JRK_SETTING_INPUT_MAXIMUM': 0x0A,
    'JRK_SETTING_INPUT_NEUTRAL_MINIMUM': 0x0C,
    'JRK_SETTING_INPUT_NEUTRAL_MAXIMUM': 0x0E,
    'JRK_SETTING_OUTPUT_MINIMUM': 0x10,
    'JRK_SETTING_OUTPUT_NEUTRAL': 0x12,
    'JRK_SETTING_OUTPUT_MAXIMUM': 0x14,
    'JRK_SETTING_INPUT_SCALING_DEGREE': 0x16,
    'JRK_SETTING_INPUT_ANALOG_SAMPLES_EXPONENT': 0x17,
    'JRK_SETTING_FEEDBACK_MODE': 0x18,
    'JRK_SETTING_FEEDBACK_ERROR_MINIMUM': 0x19,
    'JRK_SETTING_FEEDBACK_ERROR_MAXIMUM': 0x1B,
    'JRK_SETTING_FEEDBACK_MINIMUM': 0x1D,
    'JRK_SETTING_FEEDBACK_MAXIMUM': 0x1F,
    'JRK_SETTING_FEEDBACK_DEAD_ZONE': 0x21,
    'JRK_SETTING_FEEDBACK_ANALOG_SAMPLES_EXPONENT': 0x22,
    'JRK_SETTING_SERIAL_MODE': 0x23,
    'JRK_SETTING_SERIAL_BAUD_RATE_GENERATOR': 0x24,
    'JRK_SETTING_SERIAL_TIMEOUT': 0x26,
    'JRK_SETTING_SERIAL_DEVICE_NUMBER': 0x28,
    'JRK_SETTING_ERROR_ENABLE': 0x2A,
    'JRK_SETTING_ERROR_LATCH': 0x2C,
    'JRK_SETTING_ERROR_HARD': 0x2E,
    'JRK_SETTING_VIN_CALIBRATION': 0x30,
    'JRK_SETTING_PWM_FREQUENCY': 0x32,
    'JRK_SETTING_CURRENT_SAMPLES_EXPONENT': 0x33,
    'JRK_SETTING_HARD_OVERCURRENT_THRESHOLD': 0x34,
    'JRK_SETTING_CURRENT_OFFSET_CALIBRATION': 0x35,
    'JRK_SETTING_CURRENT_SCALE_CALIBRATION': 0x37,
    'JRK_SETTING_FBT_METHOD': 0x39,
    'JRK_SETTING_FBT_OPTIONS': 0x3A,
    'JRK_SETTING_FBT_TIMING_TIMEOUT': 0x3B,
    'JRK_SETTING_FBT_SAMPLES': 0x3D,
    'JRK_SETTING_FBT_DIVIDER_EXPONENT': 0x3E,
    'JRK_SETTING_INTEGRAL_DIVIDER_EXPONENT': 0x3F,
    'JRK_SETTING_SOFT_CURRENT_REGULATION_LEVEL_FORWARD': 0x40,
    'JRK_SETTING_SOFT_CURRENT_REGULATION_LEVEL_REVERSE': 0x42,
    'JRK_SETTING_OPTIONS_BYTE3': 0x50,
    'JRK_SETTING_PROPORTIONAL_MULTIPLIER': 0x51,
    'JRK_SETTING_PROPORTIONAL_EXPONENT': 0x53,
    'JRK_SETTING_INTEGRAL_MULTIPLIER': 0x54,
    'JRK_SETTING_INTEGRAL_EXPONENT': 0x56,
    'JRK_SETTING_DERIVATIVE_MULTIPLIER': 0x57,
    'JRK_SETTING_DERIVATIVE_EXPONENT': 0x59,
    'JRK_SETTING_PID_PERIOD': 0x5A,
    'JRK_SETTING_INTEGRAL_LIMIT': 0x5C,
    'JRK_SETTING_MAX_DUTY_CYCLE_WHILE_FEEDBACK_OUT_OF_RANGE': 0x5E,
    'JRK_SETTING_MAX_ACCELERATION_FORWARD': 0x60,
    'JRK_SETTING_MAX_ACCELERATION_REVERSE': 0x62,
    'JRK_SETTING_MAX_DECELERATION_FORWARD': 0x64,
    'JRK_SETTING_MAX_DECELERATION_REVERSE': 0x66,
    'JRK_SETTING_MAX_DUTY_CYCLE_FORWARD': 0x68,
    'JRK_SETTING_MAX_DUTY_CYCLE_REVERSE': 0x6A,
    'JRK_SETTING_ENCODED_HARD_CURRENT_LIMIT_FORWARD': 0x6C,
    'JRK_SETTING_ENCODED_HARD_CURRENT_LIMIT_REVERSE': 0x6E,
    'JRK_SETTING_BRAKE_DURATION_FORWARD': 0x70,
    'JRK_SETTING_BRAKE_DURATION_REVERSE': 0x71,
    'JRK_SETTING_SOFT_CURRENT_LIMIT_FORWARD': 0x72,
    'JRK_SETTING_SOFT_CURRENT_LIMIT_REVERSE': 0x74,
    
    'JRK_SETTINGS_SIZE': 0x76,
    
    'JRK_OPTIONS_BYTE1_NEVER_SLEEP': 0,
    'JRK_OPTIONS_BYTE1_SERIAL_ENABLE_CRC': 1,
    'JRK_OPTIONS_BYTE1_SERIAL_ENABLE_14BIT_DEVICE_NUMBER': 2,
    'JRK_OPTIONS_BYTE1_SERIAL_DISABLE_COMPACT_PROTOCOL': 3,
    'JRK_OPTIONS_BYTE1_DISABLE_I2C_PULLUPS': 4,
    'JRK_OPTIONS_BYTE1_ANALOG_SDA_PULLUP': 5,
    'JRK_OPTIONS_BYTE1_ALWAYS_ANALOG_SDA': 6,
    'JRK_OPTIONS_BYTE1_ALWAYS_ANALOG_FBA': 7,
    
    'JRK_OPTIONS_BYTE2_INPUT_INVERT': 0,
    'JRK_OPTIONS_BYTE2_INPUT_DETECT_DISCONNECT': 1,
    'JRK_OPTIONS_BYTE2_FEEDBACK_INVERT': 2,
    'JRK_OPTIONS_BYTE2_FEEDBACK_DETECT_DISCONNECT': 3,
    'JRK_OPTIONS_BYTE2_FEEDBACK_WRAPAROUND': 4,
    'JRK_OPTIONS_BYTE2_MOTOR_INVERT': 5,
    
    'JRK_OPTIONS_BYTE3_RESET_INTEGRAL': 0,
    'JRK_OPTIONS_BYTE3_COAST_WHEN_OFF': 1,
    
    'JRK_FBT_OPTIONS_TIMING_POLARITY': 0,
    'JRK_FBT_OPTIONS_TIMING_CLOCK': 4,
    'JRK_FBT_OPTIONS_TIMING_CLOCK_MASK': 0x7,
    
    'JRK_FIRMWARE_MODIFICATION_STRING_INDEX': 6,
    
    'JRK_MAX_USB_RESPONSE_SIZE': 128,
    
    'JRK_MAX_ALLOWED_DUTY_CYCLE': 600,
    
    'JRK_INPUT_MODE_SERIAL': 0,
    'JRK_INPUT_MODE_ANALOG': 1,
    'JRK_INPUT_MODE_RC': 2,
    
    'JRK_FEEDBACK_MODE_NONE': 0,
    'JRK_FEEDBACK_MODE_ANALOG': 1,
    'JRK_FEEDBACK_MODE_FREQUENCY': 2,
    
    'JRK_SERIAL_MODE_USB_DUAL_PORT': 0,
    'JRK_SERIAL_MODE_USB_CHAINED': 1,
    'JRK_SERIAL_MODE_UART': 2,
    
    'JRK_PWM_FREQUENCY_20': 0,
    'JRK_PWM_FREQUENCY_5': 1,
    
    'JRK_SCALING_DEGREE_LINEAR': 0,
    'JRK_SCALING_DEGREE_QUADRATIC': 1,
    'JRK_SCALING_DEGREE_CUBIC': 2,
    'JRK_SCALING_DEGREE_QUARTIC': 3,
    'JRK_SCALING_DEGREE_QUINTIC': 4,
    
    'JRK_BRAKE_DURATION_UNITS': 5,
    'JRK_MAX_ALLOWED_BRAKE_DURATION': 1275,
    
    'JRK_SERIAL_TIMEOUT_UNITS': 10,
    'JRK_MAX_ALLOWED_SERIAL_TIMEOUT': 655350,
    
    'JRK_BAUD_RATE_GENERATOR_FACTOR': 12000000,
    
    'JRK_MIN_ALLOWED_BAUD_RATE': 184,
    'JRK_MAX_ALLOWED_BAUD_RATE': 115385,
    
    'JRK_FBT_METHOD_PULSE_COUNTING': 0,
    'JRK_FBT_METHOD_PULSE_TIMING': 1,
    
    'JRK_MAX_ALLOWED_FBT_SAMPLES': 32,
    
    'JRK_FBT_TIMING_CLOCK_12': 0,
    'JRK_FBT_TIMING_CLOCK_6': 1,
    'JRK_FBT_TIMING_CLOCK_3': 2,
    'JRK_FBT_TIMING_CLOCK_1_5': 3,
    'JRK_FBT_TIMING_CLOCK_48': 4,
    'JRK_FBT_TIMING_CLOCK_24': 5,
    
    'JRK_FORCE_MODE_NONE': 0,
    'JRK_FORCE_MODE_DUTY_CYCLE_TARGET': 1,
    'JRK_FORCE_MODE_DUTY_CYCLE': 2,
    
    'JRK_RESET_POWER_UP': 0,
    'JRK_RESET_BROWNOUT': 1,
    'JRK_RESET_RESET_LINE': 2,
    'JRK_RESET_WATCHDOG': 4,
    'JRK_RESET_SOFTWARE': 8,
    'JRK_RESET_STACK_OVERFLOW': 16,
    'JRK_RESET_STACK_UNDERFLOW': 32,
    
    'JRK_ERROR_AWAITING_COMMAND': 0,
    'JRK_ERROR_NO_POWER': 1,
    'JRK_ERROR_MOTOR_DRIVER': 2,
    'JRK_ERROR_INPUT_INVALID': 3,
    'JRK_ERROR_INPUT_DISCONNECT': 4,
    'JRK_ERROR_FEEDBACK_DISCONNECT': 5,
    'JRK_ERROR_SOFT_OVERCURRENT': 6,
    'JRK_ERROR_SERIAL_SIGNAL': 7,
    'JRK_ERROR_SERIAL_OVERRUN': 8,
    'JRK_ERROR_SERIAL_BUFFER_FULL': 9,
    'JRK_ERROR_SERIAL_CRC': 10,
    'JRK_ERROR_SERIAL_PROTOCOL': 11,
    'JRK_ERROR_SERIAL_TIMEOUT': 12,
    'JRK_ERROR_HARD_OVERCURRENT': 13,
    
    'JRK_PIN_NUM_SCL': 0,
    'JRK_PIN_NUM_SDA': 1,
    'JRK_PIN_NUM_TX': 2,
    'JRK_PIN_NUM_RX': 3,
    'JRK_PIN_NUM_RC': 4,
    'JRK_PIN_NUM_AUX': 5,
    'JRK_PIN_NUM_FBA': 6,
    'JRK_PIN_NUM_FBT': 7,
    'JRK_CONTROL_PIN_COUNT': 8,
}