# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class DimensionScope(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The scope at which the quota is applied to."""

    WORKSPACE = "Workspace"
    """The quota is applied to the Quantum Workspace."""
    SUBSCRIPTION = "Subscription"
    """The quota is applied to the Azure Subscription."""


class ItemType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the workspace item."""

    JOB = "Job"
    """A program, problem, or application submitted for processing."""
    SESSION = "Session"
    """A logical grouping of jobs."""


class JobStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the job."""

    WAITING = "Waiting"
    """The job is waiting in the queue to be executed."""
    EXECUTING = "Executing"
    """The job is being executed."""
    SUCCEEDED = "Succeeded"
    """The job completed with success."""
    FAILED = "Failed"
    """The job completed with failure."""
    CANCELLED = "Cancelled"
    """The job was cancelled."""


class JobType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the job."""

    UNKNOWN = "Unknown"
    """Unknown job type."""
    QUANTUM_COMPUTING = "QuantumComputing"
    """Quantum Computing job type."""
    OPTIMIZATION = "Optimization"
    """Optimization job type."""


class JsonPatchOperation(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The operation to be performed."""

    ADD = "add"
    """Add value operation."""
    REMOVE = "remove"
    """Remove value operation."""
    REPLACE = "replace"
    """Replace value operation."""
    MOVE = "move"
    """Move value operation."""
    COPY = "copy"
    """Copy value operation."""
    TEST = "test"
    """Test value operation."""


class MeterPeriod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The time period in which the quota's underlying meter is accumulated. Based on calendar year.
    'None' is used for concurrent quotas.
    """

    NONE = "None"
    """The meter period is instantaneous. Used for concurrent quotas."""
    MONTHLY = "Monthly"
    """The meter period is per month."""


class ProviderAvailability(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provider availability."""

    AVAILABLE = "Available"
    """Provider is available."""
    DEGRADED = "Degraded"
    """Provider is available with degraded experience."""
    UNAVAILABLE = "Unavailable"
    """Provider is unavailable."""


class SessionJobFailurePolicy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Policy controlling the behavior of the Session when a job in the session fails."""

    ABORT = "Abort"
    """New jobs submitted after a job fails will be rejected."""
    CONTINUE = "Continue"
    """New jobs submitted after a job fails will be accepted."""


class SessionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the session."""

    WAITING = "Waiting"
    """The session is waiting in the queue to be executed."""
    EXECUTING = "Executing"
    """The session is being executed."""
    SUCCEEDED = "Succeeded"
    """The session completed with success."""
    FAILED = "Failed"
    """The session completed with failure."""
    FAILURE_S_ = "Failure(s)"
    """The session completed with some failures."""
    TIMED_OUT = "TimedOut"
    """The session timed out."""


class TargetAvailability(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Target availability."""

    AVAILABLE = "Available"
    """Target is available."""
    DEGRADED = "Degraded"
    """Target is available with degraded experience."""
    UNAVAILABLE = "Unavailable"
    """Target is unavailable."""
