# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from azure.core.exceptions import ODataV4Format

from .. import _model_base
from .._model_base import rest_discriminator, rest_field
from ._enums import ItemType

if TYPE_CHECKING:
    from .. import models as _models


class BlobDetails(_model_base.Model):
    """The details (name and container) of the blob to store or download data.

    All required parameters must be populated in order to send to server.

    :ivar container_name: The container name. Required.
    :vartype container_name: str
    :ivar blob_name: The blob name.
    :vartype blob_name: str
    """

    container_name: str = rest_field(name="containerName", visibility=["read", "create"])
    """The container name. Required."""
    blob_name: Optional[str] = rest_field(name="blobName", visibility=["read", "create"])
    """The blob name."""

    @overload
    def __init__(
        self,
        *,
        container_name: str,
        blob_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CostEstimate(_model_base.Model):
    """The job cost billed by the provider. The final cost on your bill might be slightly different
    due to added taxes and currency conversion rates.


    :ivar currency_code: The currency code. Required.
    :vartype currency_code: str
    :ivar events: List of usage events.
    :vartype events: list[~azure.quantum.models.UsageEvent]
    :ivar estimated_total: The estimated total. Required.
    :vartype estimated_total: float
    """

    currency_code: str = rest_field(name="currencyCode")
    """The currency code. Required."""
    events: Optional[List["_models.UsageEvent"]] = rest_field()
    """List of usage events."""
    estimated_total: float = rest_field(name="estimatedTotal")
    """The estimated total. Required."""

    @overload
    def __init__(
        self,
        *,
        currency_code: str,
        estimated_total: float,
        events: Optional[List["_models.UsageEvent"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InnerError(_model_base.Model):
    """An object containing more specific information about the error. As per Microsoft One API
    guidelines -
    https://github.com/Microsoft/api-guidelines/blob/vNext/Guidelines.md#7102-error-condition-responses.

    :ivar code: One of a server-defined set of error codes.
    :vartype code: str
    :ivar innererror: Inner error.
    :vartype innererror: ~azure.quantum.models.InnerError
    """

    code: Optional[str] = rest_field()
    """One of a server-defined set of error codes."""
    innererror: Optional["_models.InnerError"] = rest_field()
    """Inner error."""

    @overload
    def __init__(
        self,
        *,
        code: Optional[str] = None,
        innererror: Optional["_models.InnerError"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ItemDetails(_model_base.Model):
    """A workspace item.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    JobDetails, SessionDetails

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Id of the item. Required.
    :vartype id: str
    :ivar name: The name of the item. It is not required for the name to be unique and it's only
     used for display purposes. Required.
    :vartype name: str
    :ivar provider_id: The unique identifier for the provider. Required.
    :vartype provider_id: str
    :ivar target: The target identifier to run the job. Required.
    :vartype target: str
    :ivar item_type: Type of the Quantum Workspace item. Required. Known values are: "Job" and
     "Session".
    :vartype item_type: str or ~azure.quantum.models.ItemType
    :ivar creation_time: The creation time of the item.
    :vartype creation_time: ~datetime.datetime
    :ivar begin_execution_time: The time when the item began execution.
    :vartype begin_execution_time: ~datetime.datetime
    :ivar end_execution_time: The time when the item finished execution.
    :vartype end_execution_time: ~datetime.datetime
    :ivar cost_estimate: Cost estimate.
    :vartype cost_estimate: ~azure.quantum.models.CostEstimate
    :ivar error_data: Error information.
    :vartype error_data: ~azure.quantum.models.WorkspaceItemError
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    id: str = rest_field(visibility=["read"])
    """Id of the item. Required."""
    name: str = rest_field(visibility=["read", "create", "update"])
    """The name of the item. It is not required for the name to be unique and it's only used for
     display purposes. Required."""
    provider_id: str = rest_field(name="providerId", visibility=["read", "create"])
    """The unique identifier for the provider. Required."""
    target: str = rest_field(visibility=["read", "create"])
    """The target identifier to run the job. Required."""
    item_type: str = rest_discriminator(name="itemType", visibility=["read", "create"])
    """Type of the Quantum Workspace item. Required. Known values are: \"Job\" and \"Session\"."""
    creation_time: Optional[datetime.datetime] = rest_field(name="creationTime", visibility=["read"], format="rfc3339")
    """The creation time of the item."""
    begin_execution_time: Optional[datetime.datetime] = rest_field(
        name="beginExecutionTime", visibility=["read"], format="rfc3339"
    )
    """The time when the item began execution."""
    end_execution_time: Optional[datetime.datetime] = rest_field(
        name="endExecutionTime", visibility=["read"], format="rfc3339"
    )
    """The time when the item finished execution."""
    cost_estimate: Optional["_models.CostEstimate"] = rest_field(name="costEstimate", visibility=["read"])
    """Cost estimate."""
    error_data: Optional["_models.WorkspaceItemError"] = rest_field(name="errorData", visibility=["read"])
    """Error information."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        provider_id: str,
        target: str,
        item_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class JobDetails(ItemDetails, discriminator="Job"):
    """A job to be run in the workspace.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar name: The name of the item. It is not required for the name to be unique and it's only
     used for display purposes. Required.
    :vartype name: str
    :ivar provider_id: The unique identifier for the provider. Required.
    :vartype provider_id: str
    :ivar target: The target identifier to run the job. Required.
    :vartype target: str
    :ivar creation_time: The creation time of the item.
    :vartype creation_time: ~datetime.datetime
    :ivar begin_execution_time: The time when the item began execution.
    :vartype begin_execution_time: ~datetime.datetime
    :ivar end_execution_time: The time when the item finished execution.
    :vartype end_execution_time: ~datetime.datetime
    :ivar cost_estimate: Cost estimate.
    :vartype cost_estimate: ~azure.quantum.models.CostEstimate
    :ivar error_data: Error information.
    :vartype error_data: ~azure.quantum.models.WorkspaceItemError
    :ivar id: Id of the job. Required.
    :vartype id: str
    :ivar item_type: Type of the Quantum Workspace item is Job. Required. A program, problem, or
     application submitted for processing.
    :vartype item_type: str or ~azure.quantum.models.JOB
    :ivar job_type: The type of job. Known values are: "Unknown", "QuantumComputing", and
     "Optimization".
    :vartype job_type: str or ~azure.quantum.models.JobType
    :ivar session_id: The ID of the session that the job is part of.
    :vartype session_id: str
    :ivar container_uri: The blob container SAS uri, the container is used to host job data.
     Required.
    :vartype container_uri: str
    :ivar input_data_uri: The input blob URI, if specified, it will override the default input blob
     in the container.
    :vartype input_data_uri: str
    :ivar input_data_format: The format of the input data.
    :vartype input_data_format: str
    :ivar status: The status of the job. Known values are: "Waiting", "Executing", "Succeeded",
     "Failed", and "Cancelled".
    :vartype status: str or ~azure.quantum.models.JobStatus
    :ivar metadata: The job metadata. Metadata provides client the ability to store client-specific
     information.
    :vartype metadata: any
    :ivar cancellation_time: The time when a job was successfully cancelled.
    :vartype cancellation_time: ~datetime.datetime
    :ivar tags: List of user-supplied tags associated with the job.
    :vartype tags: list[str]
    :ivar quantum_computing_data: Quantum computing data.
    :vartype quantum_computing_data: ~azure.quantum.models.QuantumComputingData
    :ivar input_params: The input parameters for the job. JSON object used by the target solver. It
     is expected that the size of this object is small and only used to specify parameters for the
     execution target, not the input data.
    :vartype input_params: any
    :ivar output_data_uri: The output blob uri. When a job finishes successfully, results will be
     uploaded to this blob.
    :vartype output_data_uri: str
    :ivar output_data_format: The format of the output data.
    :vartype output_data_format: str
    """

    item_type: Literal[ItemType.JOB] = rest_discriminator(name="itemType", visibility=["read", "create"])  # type: ignore # pylint: disable=line-too-long
    """Type of the Quantum Workspace item is Job. Required. A program, problem, or application
     submitted for processing."""
    job_type: Optional[Union[str, "_models.JobType"]] = rest_field(name="jobType", visibility=["read", "create"])
    """The type of job. Known values are: \"Unknown\", \"QuantumComputing\", and \"Optimization\"."""
    session_id: Optional[str] = rest_field(name="sessionId", visibility=["read", "create"])
    """The ID of the session that the job is part of."""
    container_uri: str = rest_field(name="containerUri", visibility=["read", "create"])
    """The blob container SAS uri, the container is used to host job data. Required."""
    input_data_uri: Optional[str] = rest_field(name="inputDataUri", visibility=["read", "create"])
    """The input blob URI, if specified, it will override the default input blob in the container."""
    input_data_format: Optional[str] = rest_field(name="inputDataFormat", visibility=["read", "create"])
    """The format of the input data."""
    status: Optional[Union[str, "_models.JobStatus"]] = rest_field(visibility=["read"])
    """The status of the job. Known values are: \"Waiting\", \"Executing\", \"Succeeded\", \"Failed\",
     and \"Cancelled\"."""
    metadata: Optional[Any] = rest_field(visibility=["read", "create", "update"])
    """The job metadata. Metadata provides client the ability to store client-specific information."""
    cancellation_time: Optional[datetime.datetime] = rest_field(
        name="cancellationTime", visibility=["read"], format="rfc3339"
    )
    """The time when a job was successfully cancelled."""
    tags: Optional[List[str]] = rest_field(visibility=["read", "create", "update"])
    """List of user-supplied tags associated with the job."""
    quantum_computing_data: Optional["_models.QuantumComputingData"] = rest_field(
        name="quantumComputingData", visibility=["read"]
    )
    """Quantum computing data."""
    input_params: Optional[Any] = rest_field(name="inputParams", visibility=["read", "create"])
    """The input parameters for the job. JSON object used by the target solver. It is expected that
     the size of this object is small and only used to specify parameters for the execution target,
     not the input data."""
    output_data_uri: Optional[str] = rest_field(name="outputDataUri", visibility=["read", "create"])
    """The output blob uri. When a job finishes successfully, results will be uploaded to this blob."""
    output_data_format: Optional[str] = rest_field(name="outputDataFormat", visibility=["read", "create"])
    """The format of the output data."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        provider_id: str,
        target: str,
        container_uri: str,
        job_type: Optional[Union[str, "_models.JobType"]] = None,
        session_id: Optional[str] = None,
        input_data_uri: Optional[str] = None,
        input_data_format: Optional[str] = None,
        metadata: Optional[Any] = None,
        tags: Optional[List[str]] = None,
        input_params: Optional[Any] = None,
        output_data_uri: Optional[str] = None,
        output_data_format: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, item_type=ItemType.JOB, **kwargs)


class JsonPatchObject(_model_base.Model):
    """A JSONPatch object as defined by RFC 6902.

    All required parameters must be populated in order to send to server.

    :ivar operation: The operation to be performed. Required. Known values are: "add", "remove",
     "replace", "move", "copy", and "test".
    :vartype operation: str or ~azure.quantum.models.JsonPatchOperation
    :ivar path: A JSON-Pointer. Required.
    :vartype path: str
    :ivar value: A value to be used in the operation on the path.
    :vartype value: any
    :ivar from_property: Optional field used in copy and move operations.
    :vartype from_property: str
    """

    operation: Union[str, "_models.JsonPatchOperation"] = rest_field(name="op", visibility=["create"])
    """The operation to be performed. Required. Known values are: \"add\", \"remove\", \"replace\",
     \"move\", \"copy\", and \"test\"."""
    path: str = rest_field(visibility=["create"])
    """A JSON-Pointer. Required."""
    value: Optional[Any] = rest_field(visibility=["create"])
    """A value to be used in the operation on the path."""
    from_property: Optional[str] = rest_field(name="from", visibility=["create"])
    """Optional field used in copy and move operations."""

    @overload
    def __init__(
        self,
        *,
        operation: Union[str, "_models.JsonPatchOperation"],
        path: str,
        value: Optional[Any] = None,
        from_property: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProviderStatus(_model_base.Model):
    """Provider status.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Provider id. Required.
    :vartype id: str
    :ivar current_availability: Current provider availability. Required. Known values are:
     "Available", "Degraded", and "Unavailable".
    :vartype current_availability: str or ~azure.quantum.models.ProviderAvailability
    :ivar targets: Current target statuses. Required.
    :vartype targets: list[~azure.quantum.models.TargetStatus]
    """

    id: str = rest_field(visibility=["read"])
    """Provider id. Required."""
    current_availability: Union[str, "_models.ProviderAvailability"] = rest_field(
        name="currentAvailability", visibility=["read"]
    )
    """Current provider availability. Required. Known values are: \"Available\", \"Degraded\", and
     \"Unavailable\"."""
    targets: List["_models.TargetStatus"] = rest_field(visibility=["read"])
    """Current target statuses. Required."""


class QuantumComputingData(_model_base.Model):
    """Quantum computing data.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar count: The number of quantum computing items in the job. Required.
    :vartype count: int
    """

    count: int = rest_field(visibility=["read"])
    """The number of quantum computing items in the job. Required."""


class Quota(_model_base.Model):
    """Quota information.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar dimension: The name of the dimension associated with the quota. Required.
    :vartype dimension: str
    :ivar scope: The scope at which the quota is applied. Required. Known values are: "Workspace"
     and "Subscription".
    :vartype scope: str or ~azure.quantum.models.DimensionScope
    :ivar provider_id: The unique identifier for the provider. Required.
    :vartype provider_id: str
    :ivar utilization: The amount of the usage that has been applied for the current period.
     Required.
    :vartype utilization: float
    :ivar holds: The amount of the usage that has been reserved but not applied for the current
     period. Required.
    :vartype holds: float
    :ivar limit: The maximum amount of usage allowed for the current period. Required.
    :vartype limit: float
    :ivar period: The time period in which the quota's underlying meter is accumulated. Based on
     calendar year. 'None' is used for concurrent quotas. Required. Known values are: "None" and
     "Monthly".
    :vartype period: str or ~azure.quantum.models.MeterPeriod
    """

    dimension: str = rest_field(visibility=["read"])
    """The name of the dimension associated with the quota. Required."""
    scope: Union[str, "_models.DimensionScope"] = rest_field(visibility=["read"])
    """The scope at which the quota is applied. Required. Known values are: \"Workspace\" and
     \"Subscription\"."""
    provider_id: str = rest_field(name="providerId", visibility=["read"])
    """The unique identifier for the provider. Required."""
    utilization: float = rest_field(visibility=["read"])
    """The amount of the usage that has been applied for the current period. Required."""
    holds: float = rest_field(visibility=["read"])
    """The amount of the usage that has been reserved but not applied for the current period.
     Required."""
    limit: float = rest_field(visibility=["read"])
    """The maximum amount of usage allowed for the current period. Required."""
    period: Union[str, "_models.MeterPeriod"] = rest_field(visibility=["read"])
    """The time period in which the quota's underlying meter is accumulated. Based on calendar year.
     'None' is used for concurrent quotas. Required. Known values are: \"None\" and \"Monthly\"."""


class SasUriResponse(_model_base.Model):
    """SAS URI operation response.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar sas_uri: A URL with a SAS token to upload a blob for execution in the given workspace.
     Required.
    :vartype sas_uri: str
    """

    sas_uri: str = rest_field(name="sasUri", visibility=["read"])
    """A URL with a SAS token to upload a blob for execution in the given workspace. Required."""


class SessionDetails(ItemDetails, discriminator="Session"):
    """Session, a logical grouping of jobs.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar name: The name of the item. It is not required for the name to be unique and it's only
     used for display purposes. Required.
    :vartype name: str
    :ivar provider_id: The unique identifier for the provider. Required.
    :vartype provider_id: str
    :ivar target: The target identifier to run the job. Required.
    :vartype target: str
    :ivar creation_time: The creation time of the item.
    :vartype creation_time: ~datetime.datetime
    :ivar begin_execution_time: The time when the item began execution.
    :vartype begin_execution_time: ~datetime.datetime
    :ivar end_execution_time: The time when the item finished execution.
    :vartype end_execution_time: ~datetime.datetime
    :ivar cost_estimate: Cost estimate.
    :vartype cost_estimate: ~azure.quantum.models.CostEstimate
    :ivar error_data: Error information.
    :vartype error_data: ~azure.quantum.models.WorkspaceItemError
    :ivar id: Id of the session. Required.
    :vartype id: str
    :ivar item_type: Type of the Quantum Workspace item is Session. Required. A logical grouping of
     jobs.
    :vartype item_type: str or ~azure.quantum.models.SESSION
    :ivar job_failure_policy: Policy controlling the behavior of the Session when a job in the
     session fails. Required. Known values are: "Abort" and "Continue".
    :vartype job_failure_policy: str or ~azure.quantum.models.SessionJobFailurePolicy
    :ivar status: The status of the session. Known values are: "Waiting", "Executing", "Succeeded",
     "Failed", "Failure(s)", and "TimedOut".
    :vartype status: str or ~azure.quantum.models.SessionStatus
    """

    item_type: Literal[ItemType.SESSION] = rest_discriminator(name="itemType", visibility=["read", "create"])  # type: ignore # pylint: disable=line-too-long
    """Type of the Quantum Workspace item is Session. Required. A logical grouping of jobs."""
    job_failure_policy: Union[str, "_models.SessionJobFailurePolicy"] = rest_field(
        name="jobFailurePolicy", visibility=["read", "create"]
    )
    """Policy controlling the behavior of the Session when a job in the session fails. Required. Known
     values are: \"Abort\" and \"Continue\"."""
    status: Optional[Union[str, "_models.SessionStatus"]] = rest_field(visibility=["read"])
    """The status of the session. Known values are: \"Waiting\", \"Executing\", \"Succeeded\",
     \"Failed\", \"Failure(s)\", and \"TimedOut\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        provider_id: str,
        target: str,
        job_failure_policy: Union[str, "_models.SessionJobFailurePolicy"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, item_type=ItemType.SESSION, **kwargs)


class TargetStatus(_model_base.Model):
    """Target status.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Target id. Required.
    :vartype id: str
    :ivar current_availability: Current target availability. Required. Known values are:
     "Available", "Degraded", and "Unavailable".
    :vartype current_availability: str or ~azure.quantum.models.TargetAvailability
    :ivar average_queue_time: Average queue time in seconds. Required.
    :vartype average_queue_time: int
    :ivar status_page: A page with detailed status of the provider.
    :vartype status_page: str
    """

    id: str = rest_field(visibility=["read"])
    """Target id. Required."""
    current_availability: Union[str, "_models.TargetAvailability"] = rest_field(
        name="currentAvailability", visibility=["read"]
    )
    """Current target availability. Required. Known values are: \"Available\", \"Degraded\", and
     \"Unavailable\"."""
    average_queue_time: int = rest_field(name="averageQueueTime", visibility=["read"])
    """Average queue time in seconds. Required."""
    status_page: Optional[str] = rest_field(name="statusPage", visibility=["read"])
    """A page with detailed status of the provider."""


class UsageEvent(_model_base.Model):
    """Usage event details.


    :ivar dimension_id: The dimension id. Required.
    :vartype dimension_id: str
    :ivar dimension_name: The dimension name. Required.
    :vartype dimension_name: str
    :ivar measure_unit: The unit of measure. Required.
    :vartype measure_unit: str
    :ivar amount_billed: The amount billed. Required.
    :vartype amount_billed: float
    :ivar amount_consumed: The amount consumed. Required.
    :vartype amount_consumed: float
    :ivar unit_price: The unit price. Required.
    :vartype unit_price: float
    """

    dimension_id: str = rest_field(name="dimensionId")
    """The dimension id. Required."""
    dimension_name: str = rest_field(name="dimensionName")
    """The dimension name. Required."""
    measure_unit: str = rest_field(name="measureUnit")
    """The unit of measure. Required."""
    amount_billed: float = rest_field(name="amountBilled")
    """The amount billed. Required."""
    amount_consumed: float = rest_field(name="amountConsumed")
    """The amount consumed. Required."""
    unit_price: float = rest_field(name="unitPrice")
    """The unit price. Required."""

    @overload
    def __init__(
        self,
        *,
        dimension_id: str,
        dimension_name: str,
        measure_unit: str,
        amount_billed: float,
        amount_consumed: float,
        unit_price: float,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WorkspaceItemError(_model_base.Model):
    """The error object.


    :ivar code: One of a server-defined set of error codes. Required.
    :vartype code: str
    :ivar message: A human-readable representation of the error. Required.
    :vartype message: str
    :ivar target: The target of the error.
    :vartype target: str
    :ivar details: An array of details about specific errors that led to this reported error.
    :vartype details: list[~azure.core.ODataV4Format]
    :ivar innererror: An object containing more specific information than the current object about
     the error.
    :vartype innererror: ~azure.quantum.models.InnerError
    """

    code: str = rest_field()
    """One of a server-defined set of error codes. Required."""
    message: str = rest_field()
    """A human-readable representation of the error. Required."""
    target: Optional[str] = rest_field()
    """The target of the error."""
    details: Optional[List[ODataV4Format]] = rest_field()
    """An array of details about specific errors that led to this reported error."""
    innererror: Optional["_models.InnerError"] = rest_field()
    """An object containing more specific information than the current object about the error."""

    @overload
    def __init__(
        self,
        *,
        code: str,
        message: str,
        target: Optional[str] = None,
        details: Optional[List[ODataV4Format]] = None,
        innererror: Optional["_models.InnerError"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
