# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import json
import sys
from typing import Any, Callable, Dict, IO, Iterable, List, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .. import models as _models
from .._model_base import SdkJSONEncoder, _deserialize
from .._serialization import Serializer

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_jobs_create_or_replace_request(
    subscription_id: str, resource_group_name: str, workspace_name: str, job_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Quantum/workspaces/{workspaceName}/jobs/{jobId}"  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "workspaceName": _SERIALIZER.url("workspace_name", workspace_name, "str"),
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_jobs_update_request(
    subscription_id: str, resource_group_name: str, workspace_name: str, job_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Quantum/workspaces/{workspaceName}/jobs/{jobId}"  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "workspaceName": _SERIALIZER.url("workspace_name", workspace_name, "str"),
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_jobs_delete_request(
    subscription_id: str, resource_group_name: str, workspace_name: str, job_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Quantum/workspaces/{workspaceName}/jobs/{jobId}"  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "workspaceName": _SERIALIZER.url("workspace_name", workspace_name, "str"),
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_jobs_get_request(
    subscription_id: str, resource_group_name: str, workspace_name: str, job_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Quantum/workspaces/{workspaceName}/jobs/{jobId}"  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "workspaceName": _SERIALIZER.url("workspace_name", workspace_name, "str"),
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_jobs_list_request(
    subscription_id: str,
    resource_group_name: str,
    workspace_name: str,
    *,
    filter: Optional[str] = None,
    skip: Optional[int] = None,
    top: Optional[int] = None,
    orderby: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Quantum/workspaces/{workspaceName}/jobs"  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "workspaceName": _SERIALIZER.url("workspace_name", workspace_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if filter is not None:
        _params["filter"] = _SERIALIZER.query("filter", filter, "str")
    if skip is not None:
        _params["skip"] = _SERIALIZER.query("skip", skip, "int")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")
    if orderby is not None:
        _params["orderby"] = _SERIALIZER.query("orderby", orderby, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_sessions_create_or_replace_request(
    subscription_id: str, resource_group_name: str, workspace_name: str, session_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Quantum/workspaces/{workspaceName}/sessions/{sessionId}"  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "workspaceName": _SERIALIZER.url("workspace_name", workspace_name, "str"),
        "sessionId": _SERIALIZER.url("session_id", session_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_sessions_close_request(
    subscription_id: str, resource_group_name: str, workspace_name: str, session_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Quantum/workspaces/{workspaceName}/sessions/{sessionId}:close"  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "workspaceName": _SERIALIZER.url("workspace_name", workspace_name, "str"),
        "sessionId": _SERIALIZER.url("session_id", session_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_sessions_get_request(
    subscription_id: str, resource_group_name: str, workspace_name: str, session_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Quantum/workspaces/{workspaceName}/sessions/{sessionId}"  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "workspaceName": _SERIALIZER.url("workspace_name", workspace_name, "str"),
        "sessionId": _SERIALIZER.url("session_id", session_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_sessions_list_request(
    subscription_id: str,
    resource_group_name: str,
    workspace_name: str,
    *,
    filter: Optional[str] = None,
    skip: Optional[int] = None,
    top: Optional[int] = None,
    orderby: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Quantum/workspaces/{workspaceName}/sessions"  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "workspaceName": _SERIALIZER.url("workspace_name", workspace_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if filter is not None:
        _params["filter"] = _SERIALIZER.query("filter", filter, "str")
    if skip is not None:
        _params["skip"] = _SERIALIZER.query("skip", skip, "int")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")
    if orderby is not None:
        _params["orderby"] = _SERIALIZER.query("orderby", orderby, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_sessions_jobs_list_request(
    subscription_id: str,
    resource_group_name: str,
    workspace_name: str,
    session_id: str,
    *,
    filter: Optional[str] = None,
    skip: Optional[int] = None,
    top: Optional[int] = None,
    orderby: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Quantum/workspaces/{workspaceName}/sessions/{sessionId}/jobs"  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "workspaceName": _SERIALIZER.url("workspace_name", workspace_name, "str"),
        "sessionId": _SERIALIZER.url("session_id", session_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if filter is not None:
        _params["filter"] = _SERIALIZER.query("filter", filter, "str")
    if skip is not None:
        _params["skip"] = _SERIALIZER.query("skip", skip, "int")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")
    if orderby is not None:
        _params["orderby"] = _SERIALIZER.query("orderby", orderby, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_providers_list_request(
    subscription_id: str, resource_group_name: str, workspace_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Quantum/workspaces/{workspaceName}/providerStatus"  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "workspaceName": _SERIALIZER.url("workspace_name", workspace_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_storage_get_sas_uri_request(
    subscription_id: str, resource_group_name: str, workspace_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Quantum/workspaces/{workspaceName}/storage/sasUri"  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "workspaceName": _SERIALIZER.url("workspace_name", workspace_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_quotas_list_request(
    subscription_id: str, resource_group_name: str, workspace_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Quantum/workspaces/{workspaceName}/quotas"  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "workspaceName": _SERIALIZER.url("workspace_name", workspace_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_top_level_items_list_request(
    subscription_id: str,
    resource_group_name: str,
    workspace_name: str,
    *,
    filter: Optional[str] = None,
    skip: Optional[int] = None,
    top: Optional[int] = None,
    orderby: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Quantum/workspaces/{workspaceName}/topLevelItems"  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "workspaceName": _SERIALIZER.url("workspace_name", workspace_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if filter is not None:
        _params["filter"] = _SERIALIZER.query("filter", filter, "str")
    if skip is not None:
        _params["skip"] = _SERIALIZER.query("skip", skip, "int")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")
    if orderby is not None:
        _params["orderby"] = _SERIALIZER.query("orderby", orderby, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


class JobsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.quantum.ServicesClient`'s
        :attr:`jobs` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    def create_or_replace(
        self,
        subscription_id: str,
        resource_group_name: str,
        workspace_name: str,
        job_id: str,
        resource: _models.JobDetails,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.JobDetails:
        """Create a new job.

        :param subscription_id: The Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Name of the Azure resource group. Required.
        :type resource_group_name: str
        :param workspace_name: Name of the Azure Quantum workspace. Required.
        :type workspace_name: str
        :param job_id: Id of the job. Required.
        :type job_id: str
        :param resource: The resource instance. Required.
        :type resource: ~azure.quantum.models.JobDetails
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JobDetails. The JobDetails is compatible with MutableMapping
        :rtype: ~azure.quantum.models.JobDetails
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def create_or_replace(
        self,
        subscription_id: str,
        resource_group_name: str,
        workspace_name: str,
        job_id: str,
        resource: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.JobDetails:
        """Create a new job.

        :param subscription_id: The Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Name of the Azure resource group. Required.
        :type resource_group_name: str
        :param workspace_name: Name of the Azure Quantum workspace. Required.
        :type workspace_name: str
        :param job_id: Id of the job. Required.
        :type job_id: str
        :param resource: The resource instance. Required.
        :type resource: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JobDetails. The JobDetails is compatible with MutableMapping
        :rtype: ~azure.quantum.models.JobDetails
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def create_or_replace(
        self,
        subscription_id: str,
        resource_group_name: str,
        workspace_name: str,
        job_id: str,
        resource: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.JobDetails:
        """Create a new job.

        :param subscription_id: The Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Name of the Azure resource group. Required.
        :type resource_group_name: str
        :param workspace_name: Name of the Azure Quantum workspace. Required.
        :type workspace_name: str
        :param job_id: Id of the job. Required.
        :type job_id: str
        :param resource: The resource instance. Required.
        :type resource: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JobDetails. The JobDetails is compatible with MutableMapping
        :rtype: ~azure.quantum.models.JobDetails
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def create_or_replace(
        self,
        subscription_id: str,
        resource_group_name: str,
        workspace_name: str,
        job_id: str,
        resource: Union[_models.JobDetails, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.JobDetails:
        """Create a new job.

        :param subscription_id: The Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Name of the Azure resource group. Required.
        :type resource_group_name: str
        :param workspace_name: Name of the Azure Quantum workspace. Required.
        :type workspace_name: str
        :param job_id: Id of the job. Required.
        :type job_id: str
        :param resource: The resource instance. Is one of the following types: JobDetails, JSON,
         IO[bytes] Required.
        :type resource: ~azure.quantum.models.JobDetails or JSON or IO[bytes]
        :return: JobDetails. The JobDetails is compatible with MutableMapping
        :rtype: ~azure.quantum.models.JobDetails
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.JobDetails] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(resource, (IOBase, bytes)):
            _content = resource
        else:
            _content = json.dumps(resource, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_jobs_create_or_replace_request(
            subscription_id=subscription_id,
            resource_group_name=resource_group_name,
            workspace_name=workspace_name,
            job_id=job_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
            "serviceBaseUrl": self._serialize.url(
                "self._config.service_base_url", self._config.service_base_url, "str"
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.JobDetails, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def update(
        self,
        subscription_id: str,
        resource_group_name: str,
        workspace_name: str,
        job_id: str,
        resource: List[_models.JsonPatchObject],
        *,
        content_type: str = "application/json-patch+json",
        **kwargs: Any
    ) -> Optional[_models.JobDetails]:
        """Update job properties.

        :param subscription_id: The Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Name of the Azure resource group. Required.
        :type resource_group_name: str
        :param workspace_name: Name of the Azure Quantum workspace. Required.
        :type workspace_name: str
        :param job_id: Id of the job. Required.
        :type job_id: str
        :param resource: The resource instance. Required.
        :type resource: list[~azure.quantum.models.JsonPatchObject]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json-patch+json".
        :paramtype content_type: str
        :return: JobDetails or None. The JobDetails is compatible with MutableMapping
        :rtype: ~azure.quantum.models.JobDetails or None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update(
        self,
        subscription_id: str,
        resource_group_name: str,
        workspace_name: str,
        job_id: str,
        resource: IO[bytes],
        *,
        content_type: str = "application/json-patch+json",
        **kwargs: Any
    ) -> Optional[_models.JobDetails]:
        """Update job properties.

        :param subscription_id: The Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Name of the Azure resource group. Required.
        :type resource_group_name: str
        :param workspace_name: Name of the Azure Quantum workspace. Required.
        :type workspace_name: str
        :param job_id: Id of the job. Required.
        :type job_id: str
        :param resource: The resource instance. Required.
        :type resource: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json-patch+json".
        :paramtype content_type: str
        :return: JobDetails or None. The JobDetails is compatible with MutableMapping
        :rtype: ~azure.quantum.models.JobDetails or None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def update(
        self,
        subscription_id: str,
        resource_group_name: str,
        workspace_name: str,
        job_id: str,
        resource: Union[List[_models.JsonPatchObject], IO[bytes]],
        **kwargs: Any
    ) -> Optional[_models.JobDetails]:
        """Update job properties.

        :param subscription_id: The Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Name of the Azure resource group. Required.
        :type resource_group_name: str
        :param workspace_name: Name of the Azure Quantum workspace. Required.
        :type workspace_name: str
        :param job_id: Id of the job. Required.
        :type job_id: str
        :param resource: The resource instance. Is either a [JsonPatchObject] type or a IO[bytes] type.
         Required.
        :type resource: list[~azure.quantum.models.JsonPatchObject] or IO[bytes]
        :return: JobDetails or None. The JobDetails is compatible with MutableMapping
        :rtype: ~azure.quantum.models.JobDetails or None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[_models.JobDetails]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json-patch+json"
        _content = None
        if isinstance(resource, (IOBase, bytes)):
            _content = resource
        else:
            _content = json.dumps(resource, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_jobs_update_request(
            subscription_id=subscription_id,
            resource_group_name=resource_group_name,
            workspace_name=workspace_name,
            job_id=job_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
            "serviceBaseUrl": self._serialize.url(
                "self._config.service_base_url", self._config.service_base_url, "str"
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        if response.status_code == 200:
            if _stream:
                deserialized = response.iter_bytes()
            else:
                deserialized = _deserialize(_models.JobDetails, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def delete(  # pylint: disable=inconsistent-return-statements
        self, subscription_id: str, resource_group_name: str, workspace_name: str, job_id: str, **kwargs: Any
    ) -> None:
        """Request the cancellation of an existing job.

        :param subscription_id: The Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Name of the Azure resource group. Required.
        :type resource_group_name: str
        :param workspace_name: Name of the Azure Quantum workspace. Required.
        :type workspace_name: str
        :param job_id: Id of the job. Required.
        :type job_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_jobs_delete_request(
            subscription_id=subscription_id,
            resource_group_name=resource_group_name,
            workspace_name=workspace_name,
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
            "serviceBaseUrl": self._serialize.url(
                "self._config.service_base_url", self._config.service_base_url, "str"
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace
    def get(
        self, subscription_id: str, resource_group_name: str, workspace_name: str, job_id: str, **kwargs: Any
    ) -> _models.JobDetails:
        """Get job by its id.

        :param subscription_id: The Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Name of the Azure resource group. Required.
        :type resource_group_name: str
        :param workspace_name: Name of the Azure Quantum workspace. Required.
        :type workspace_name: str
        :param job_id: Id of the job. Required.
        :type job_id: str
        :return: JobDetails. The JobDetails is compatible with MutableMapping
        :rtype: ~azure.quantum.models.JobDetails
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.JobDetails] = kwargs.pop("cls", None)

        _request = build_jobs_get_request(
            subscription_id=subscription_id,
            resource_group_name=resource_group_name,
            workspace_name=workspace_name,
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
            "serviceBaseUrl": self._serialize.url(
                "self._config.service_base_url", self._config.service_base_url, "str"
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.JobDetails, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list(
        self,
        subscription_id: str,
        resource_group_name: str,
        workspace_name: str,
        *,
        filter: Optional[str] = None,
        skip: Optional[int] = None,
        top: Optional[int] = None,
        orderby: Optional[str] = None,
        **kwargs: Any
    ) -> Iterable["_models.JobDetails"]:
        """List all jobs.

        :param subscription_id: The Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Name of the Azure resource group. Required.
        :type resource_group_name: str
        :param workspace_name: Name of the Azure Quantum workspace. Required.
        :type workspace_name: str
        :keyword filter: Filter the result list using the given expression. Default value is None.
        :paramtype filter: str
        :keyword skip: The number of result items to skip. Default value is None.
        :paramtype skip: int
        :keyword top: The number of jobs taken. Default value is None.
        :paramtype top: int
        :keyword orderby: The order of returned items. Default value is None.
        :paramtype orderby: str
        :return: An iterator like instance of JobDetails
        :rtype: ~azure.core.paging.ItemPaged[~azure.quantum.models.JobDetails]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.JobDetails]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_jobs_list_request(
                    subscription_id=subscription_id,
                    resource_group_name=resource_group_name,
                    workspace_name=workspace_name,
                    filter=filter,
                    skip=skip,
                    top=top,
                    orderby=orderby,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "region": self._serialize.url("self._config.region", self._config.region, "str"),
                    "serviceBaseUrl": self._serialize.url(
                        "self._config.service_base_url", self._config.service_base_url, "str"
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "region": self._serialize.url("self._config.region", self._config.region, "str"),
                    "serviceBaseUrl": self._serialize.url(
                        "self._config.service_base_url", self._config.service_base_url, "str"
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.JobDetails], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)


class SessionsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.quantum.ServicesClient`'s
        :attr:`sessions` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    def create_or_replace(
        self,
        subscription_id: str,
        resource_group_name: str,
        workspace_name: str,
        session_id: str,
        resource: _models.SessionDetails,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SessionDetails:
        """Open a new session.

        :param subscription_id: The Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Name of the Azure resource group. Required.
        :type resource_group_name: str
        :param workspace_name: Name of the Azure Quantum workspace. Required.
        :type workspace_name: str
        :param session_id: Id of the session. Required.
        :type session_id: str
        :param resource: The resource instance. Required.
        :type resource: ~azure.quantum.models.SessionDetails
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SessionDetails. The SessionDetails is compatible with MutableMapping
        :rtype: ~azure.quantum.models.SessionDetails
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def create_or_replace(
        self,
        subscription_id: str,
        resource_group_name: str,
        workspace_name: str,
        session_id: str,
        resource: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SessionDetails:
        """Open a new session.

        :param subscription_id: The Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Name of the Azure resource group. Required.
        :type resource_group_name: str
        :param workspace_name: Name of the Azure Quantum workspace. Required.
        :type workspace_name: str
        :param session_id: Id of the session. Required.
        :type session_id: str
        :param resource: The resource instance. Required.
        :type resource: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SessionDetails. The SessionDetails is compatible with MutableMapping
        :rtype: ~azure.quantum.models.SessionDetails
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def create_or_replace(
        self,
        subscription_id: str,
        resource_group_name: str,
        workspace_name: str,
        session_id: str,
        resource: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SessionDetails:
        """Open a new session.

        :param subscription_id: The Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Name of the Azure resource group. Required.
        :type resource_group_name: str
        :param workspace_name: Name of the Azure Quantum workspace. Required.
        :type workspace_name: str
        :param session_id: Id of the session. Required.
        :type session_id: str
        :param resource: The resource instance. Required.
        :type resource: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SessionDetails. The SessionDetails is compatible with MutableMapping
        :rtype: ~azure.quantum.models.SessionDetails
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def create_or_replace(
        self,
        subscription_id: str,
        resource_group_name: str,
        workspace_name: str,
        session_id: str,
        resource: Union[_models.SessionDetails, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.SessionDetails:
        """Open a new session.

        :param subscription_id: The Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Name of the Azure resource group. Required.
        :type resource_group_name: str
        :param workspace_name: Name of the Azure Quantum workspace. Required.
        :type workspace_name: str
        :param session_id: Id of the session. Required.
        :type session_id: str
        :param resource: The resource instance. Is one of the following types: SessionDetails, JSON,
         IO[bytes] Required.
        :type resource: ~azure.quantum.models.SessionDetails or JSON or IO[bytes]
        :return: SessionDetails. The SessionDetails is compatible with MutableMapping
        :rtype: ~azure.quantum.models.SessionDetails
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SessionDetails] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(resource, (IOBase, bytes)):
            _content = resource
        else:
            _content = json.dumps(resource, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_sessions_create_or_replace_request(
            subscription_id=subscription_id,
            resource_group_name=resource_group_name,
            workspace_name=workspace_name,
            session_id=session_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
            "serviceBaseUrl": self._serialize.url(
                "self._config.service_base_url", self._config.service_base_url, "str"
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.SessionDetails, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def close(
        self, subscription_id: str, resource_group_name: str, workspace_name: str, session_id: str, **kwargs: Any
    ) -> _models.SessionDetails:
        """Close an existing session.

        :param subscription_id: The Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Name of the Azure resource group. Required.
        :type resource_group_name: str
        :param workspace_name: Name of the Azure Quantum workspace. Required.
        :type workspace_name: str
        :param session_id: Id of the session. Required.
        :type session_id: str
        :return: SessionDetails. The SessionDetails is compatible with MutableMapping
        :rtype: ~azure.quantum.models.SessionDetails
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.SessionDetails] = kwargs.pop("cls", None)

        _request = build_sessions_close_request(
            subscription_id=subscription_id,
            resource_group_name=resource_group_name,
            workspace_name=workspace_name,
            session_id=session_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
            "serviceBaseUrl": self._serialize.url(
                "self._config.service_base_url", self._config.service_base_url, "str"
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.SessionDetails, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get(
        self, subscription_id: str, resource_group_name: str, workspace_name: str, session_id: str, **kwargs: Any
    ) -> _models.SessionDetails:
        """Get Session by its id.

        :param subscription_id: The Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Name of the Azure resource group. Required.
        :type resource_group_name: str
        :param workspace_name: Name of the Azure Quantum workspace. Required.
        :type workspace_name: str
        :param session_id: Id of the session. Required.
        :type session_id: str
        :return: SessionDetails. The SessionDetails is compatible with MutableMapping
        :rtype: ~azure.quantum.models.SessionDetails
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.SessionDetails] = kwargs.pop("cls", None)

        _request = build_sessions_get_request(
            subscription_id=subscription_id,
            resource_group_name=resource_group_name,
            workspace_name=workspace_name,
            session_id=session_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
            "serviceBaseUrl": self._serialize.url(
                "self._config.service_base_url", self._config.service_base_url, "str"
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.SessionDetails, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list(
        self,
        subscription_id: str,
        resource_group_name: str,
        workspace_name: str,
        *,
        filter: Optional[str] = None,
        skip: Optional[int] = None,
        top: Optional[int] = None,
        orderby: Optional[str] = None,
        **kwargs: Any
    ) -> Iterable["_models.SessionDetails"]:
        """List all Sessions.

        :param subscription_id: The Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Name of the Azure resource group. Required.
        :type resource_group_name: str
        :param workspace_name: Name of the Azure Quantum workspace. Required.
        :type workspace_name: str
        :keyword filter: Filter the result list using the given expression. Default value is None.
        :paramtype filter: str
        :keyword skip: The number of result items to skip. Default value is None.
        :paramtype skip: int
        :keyword top: The number of jobs taken. Default value is None.
        :paramtype top: int
        :keyword orderby: The order of returned items. Default value is None.
        :paramtype orderby: str
        :return: An iterator like instance of SessionDetails
        :rtype: ~azure.core.paging.ItemPaged[~azure.quantum.models.SessionDetails]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.SessionDetails]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_sessions_list_request(
                    subscription_id=subscription_id,
                    resource_group_name=resource_group_name,
                    workspace_name=workspace_name,
                    filter=filter,
                    skip=skip,
                    top=top,
                    orderby=orderby,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "region": self._serialize.url("self._config.region", self._config.region, "str"),
                    "serviceBaseUrl": self._serialize.url(
                        "self._config.service_base_url", self._config.service_base_url, "str"
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "region": self._serialize.url("self._config.region", self._config.region, "str"),
                    "serviceBaseUrl": self._serialize.url(
                        "self._config.service_base_url", self._config.service_base_url, "str"
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.SessionDetails], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def jobs_list(
        self,
        subscription_id: str,
        resource_group_name: str,
        workspace_name: str,
        session_id: str,
        *,
        filter: Optional[str] = None,
        skip: Optional[int] = None,
        top: Optional[int] = None,
        orderby: Optional[str] = None,
        **kwargs: Any
    ) -> Iterable["_models.JobDetails"]:
        """List jobs in a session.

        :param subscription_id: The Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Name of the Azure resource group. Required.
        :type resource_group_name: str
        :param workspace_name: Name of the Azure Quantum workspace. Required.
        :type workspace_name: str
        :param session_id: Id of the session to list jobs from. Required.
        :type session_id: str
        :keyword filter: Filter the result list using the given expression. Default value is None.
        :paramtype filter: str
        :keyword skip: The number of result items to skip. Default value is None.
        :paramtype skip: int
        :keyword top: The number of jobs taken. Default value is None.
        :paramtype top: int
        :keyword orderby: The order of returned items. Default value is None.
        :paramtype orderby: str
        :return: An iterator like instance of JobDetails
        :rtype: ~azure.core.paging.ItemPaged[~azure.quantum.models.JobDetails]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.JobDetails]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_sessions_jobs_list_request(
                    subscription_id=subscription_id,
                    resource_group_name=resource_group_name,
                    workspace_name=workspace_name,
                    session_id=session_id,
                    filter=filter,
                    skip=skip,
                    top=top,
                    orderby=orderby,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "region": self._serialize.url("self._config.region", self._config.region, "str"),
                    "serviceBaseUrl": self._serialize.url(
                        "self._config.service_base_url", self._config.service_base_url, "str"
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "region": self._serialize.url("self._config.region", self._config.region, "str"),
                    "serviceBaseUrl": self._serialize.url(
                        "self._config.service_base_url", self._config.service_base_url, "str"
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.JobDetails], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)


class ProvidersOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.quantum.ServicesClient`'s
        :attr:`providers` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self, subscription_id: str, resource_group_name: str, workspace_name: str, **kwargs: Any
    ) -> Iterable["_models.ProviderStatus"]:
        """List all providers in the workspace with their respective status.

        :param subscription_id: The Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Name of the Azure resource group. Required.
        :type resource_group_name: str
        :param workspace_name: Name of the Azure Quantum workspace. Required.
        :type workspace_name: str
        :return: An iterator like instance of ProviderStatus
        :rtype: ~azure.core.paging.ItemPaged[~azure.quantum.models.ProviderStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.ProviderStatus]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_providers_list_request(
                    subscription_id=subscription_id,
                    resource_group_name=resource_group_name,
                    workspace_name=workspace_name,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "region": self._serialize.url("self._config.region", self._config.region, "str"),
                    "serviceBaseUrl": self._serialize.url(
                        "self._config.service_base_url", self._config.service_base_url, "str"
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "region": self._serialize.url("self._config.region", self._config.region, "str"),
                    "serviceBaseUrl": self._serialize.url(
                        "self._config.service_base_url", self._config.service_base_url, "str"
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.ProviderStatus], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)


class StorageOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.quantum.ServicesClient`'s
        :attr:`storage` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    def get_sas_uri(
        self,
        subscription_id: str,
        resource_group_name: str,
        workspace_name: str,
        blob_details: _models.BlobDetails,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SasUriResponse:
        """Gets a URL with SAS token for a container/blob in the storage account associated with the
        workspace. The SAS URL can be used to upload job input and/or download job output.

        :param subscription_id: The Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Name of the Azure resource group. Required.
        :type resource_group_name: str
        :param workspace_name: Name of the Azure Quantum workspace. Required.
        :type workspace_name: str
        :param blob_details: The details (name and container) of the blob. Required.
        :type blob_details: ~azure.quantum.models.BlobDetails
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SasUriResponse. The SasUriResponse is compatible with MutableMapping
        :rtype: ~azure.quantum.models.SasUriResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def get_sas_uri(
        self,
        subscription_id: str,
        resource_group_name: str,
        workspace_name: str,
        blob_details: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SasUriResponse:
        """Gets a URL with SAS token for a container/blob in the storage account associated with the
        workspace. The SAS URL can be used to upload job input and/or download job output.

        :param subscription_id: The Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Name of the Azure resource group. Required.
        :type resource_group_name: str
        :param workspace_name: Name of the Azure Quantum workspace. Required.
        :type workspace_name: str
        :param blob_details: The details (name and container) of the blob. Required.
        :type blob_details: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SasUriResponse. The SasUriResponse is compatible with MutableMapping
        :rtype: ~azure.quantum.models.SasUriResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def get_sas_uri(
        self,
        subscription_id: str,
        resource_group_name: str,
        workspace_name: str,
        blob_details: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SasUriResponse:
        """Gets a URL with SAS token for a container/blob in the storage account associated with the
        workspace. The SAS URL can be used to upload job input and/or download job output.

        :param subscription_id: The Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Name of the Azure resource group. Required.
        :type resource_group_name: str
        :param workspace_name: Name of the Azure Quantum workspace. Required.
        :type workspace_name: str
        :param blob_details: The details (name and container) of the blob. Required.
        :type blob_details: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SasUriResponse. The SasUriResponse is compatible with MutableMapping
        :rtype: ~azure.quantum.models.SasUriResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def get_sas_uri(
        self,
        subscription_id: str,
        resource_group_name: str,
        workspace_name: str,
        blob_details: Union[_models.BlobDetails, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.SasUriResponse:
        """Gets a URL with SAS token for a container/blob in the storage account associated with the
        workspace. The SAS URL can be used to upload job input and/or download job output.

        :param subscription_id: The Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Name of the Azure resource group. Required.
        :type resource_group_name: str
        :param workspace_name: Name of the Azure Quantum workspace. Required.
        :type workspace_name: str
        :param blob_details: The details (name and container) of the blob. Is one of the following
         types: BlobDetails, JSON, IO[bytes] Required.
        :type blob_details: ~azure.quantum.models.BlobDetails or JSON or IO[bytes]
        :return: SasUriResponse. The SasUriResponse is compatible with MutableMapping
        :rtype: ~azure.quantum.models.SasUriResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SasUriResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(blob_details, (IOBase, bytes)):
            _content = blob_details
        else:
            _content = json.dumps(blob_details, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_storage_get_sas_uri_request(
            subscription_id=subscription_id,
            resource_group_name=resource_group_name,
            workspace_name=workspace_name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
            "serviceBaseUrl": self._serialize.url(
                "self._config.service_base_url", self._config.service_base_url, "str"
            ),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.SasUriResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class QuotasOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.quantum.ServicesClient`'s
        :attr:`quotas` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self, subscription_id: str, resource_group_name: str, workspace_name: str, **kwargs: Any
    ) -> Iterable["_models.Quota"]:
        """List quotas for the given workspace.

        :param subscription_id: The Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Name of the Azure resource group. Required.
        :type resource_group_name: str
        :param workspace_name: Name of the Azure Quantum workspace. Required.
        :type workspace_name: str
        :return: An iterator like instance of Quota
        :rtype: ~azure.core.paging.ItemPaged[~azure.quantum.models.Quota]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.Quota]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_quotas_list_request(
                    subscription_id=subscription_id,
                    resource_group_name=resource_group_name,
                    workspace_name=workspace_name,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "region": self._serialize.url("self._config.region", self._config.region, "str"),
                    "serviceBaseUrl": self._serialize.url(
                        "self._config.service_base_url", self._config.service_base_url, "str"
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "region": self._serialize.url("self._config.region", self._config.region, "str"),
                    "serviceBaseUrl": self._serialize.url(
                        "self._config.service_base_url", self._config.service_base_url, "str"
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.Quota], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)


class TopLevelItemsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.quantum.ServicesClient`'s
        :attr:`top_level_items` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self,
        subscription_id: str,
        resource_group_name: str,
        workspace_name: str,
        *,
        filter: Optional[str] = None,
        skip: Optional[int] = None,
        top: Optional[int] = None,
        orderby: Optional[str] = None,
        **kwargs: Any
    ) -> Iterable["_models.ItemDetails"]:
        """List top-level items.

        :param subscription_id: The Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Name of the Azure resource group. Required.
        :type resource_group_name: str
        :param workspace_name: Name of the Azure Quantum workspace. Required.
        :type workspace_name: str
        :keyword filter: Filter the result list using the given expression. Default value is None.
        :paramtype filter: str
        :keyword skip: The number of result items to skip. Default value is None.
        :paramtype skip: int
        :keyword top: The number of jobs taken. Default value is None.
        :paramtype top: int
        :keyword orderby: The order of returned items. Default value is None.
        :paramtype orderby: str
        :return: An iterator like instance of ItemDetails
        :rtype: ~azure.core.paging.ItemPaged[~azure.quantum.models.ItemDetails]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.ItemDetails]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_top_level_items_list_request(
                    subscription_id=subscription_id,
                    resource_group_name=resource_group_name,
                    workspace_name=workspace_name,
                    filter=filter,
                    skip=skip,
                    top=top,
                    orderby=orderby,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "region": self._serialize.url("self._config.region", self._config.region, "str"),
                    "serviceBaseUrl": self._serialize.url(
                        "self._config.service_base_url", self._config.service_base_url, "str"
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "region": self._serialize.url("self._config.region", self._config.region, "str"),
                    "serviceBaseUrl": self._serialize.url(
                        "self._config.service_base_url", self._config.service_base_url, "str"
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.ItemDetails], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)
