# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from datetime import datetime

from pydantic import Field, StrictStr, conint

from typing import Optional

from circle.web3.configurations.models.blockchain import Blockchain
from circle.web3.configurations.models.create_monitored_tokens_request import CreateMonitoredTokensRequest
from circle.web3.configurations.models.delete_monitored_tokens_request import DeleteMonitoredTokensRequest
from circle.web3.configurations.models.monitored_tokens import MonitoredTokens
from circle.web3.configurations.models.update_monitored_tokens_request import UpdateMonitoredTokensRequest
from circle.web3.configurations.models.update_monitored_tokens_scope_request import UpdateMonitoredTokensScopeRequest

from circle.web3.configurations.api_client import ApiClient
from circle.web3.configurations.api_response import ApiResponse
from circle.web3.configurations.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class MonitorTokensApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_monitored_tokens(self, create_monitored_tokens_request : Annotated[CreateMonitoredTokensRequest, Field(..., description="Request body")], **kwargs) -> MonitoredTokens:  # noqa: E501
        """Set monitored tokens  # noqa: E501

        Add a new token to the monitored token list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_monitored_tokens(create_monitored_tokens_request, async_req=True)
        >>> result = thread.get()

        :param create_monitored_tokens_request: Request body (required)
        :type create_monitored_tokens_request: CreateMonitoredTokensRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MonitoredTokens
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_monitored_tokens_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_monitored_tokens_with_http_info(create_monitored_tokens_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_monitored_tokens_with_http_info(self, create_monitored_tokens_request : Annotated[CreateMonitoredTokensRequest, Field(..., description="Request body")], **kwargs) -> ApiResponse:  # noqa: E501
        """Set monitored tokens  # noqa: E501

        Add a new token to the monitored token list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_monitored_tokens_with_http_info(create_monitored_tokens_request, async_req=True)
        >>> result = thread.get()

        :param create_monitored_tokens_request: Request body (required)
        :type create_monitored_tokens_request: CreateMonitoredTokensRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MonitoredTokens, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_monitored_tokens_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_monitored_tokens" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_monitored_tokens_request'] is not None:
            _body_params = _params['create_monitored_tokens_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "MonitoredTokens",
            '201': "MonitoredTokens",
            '400': "BadRequestResponse",
            '401': "NotAuthorizedResponse",
        }

        return self.api_client.call_api(
            '/v1/w3s/config/entity/monitoredTokens', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_monitored_tokens(self, delete_monitored_tokens_request : Annotated[DeleteMonitoredTokensRequest, Field(..., description="Request body")], **kwargs) -> None:  # noqa: E501
        """Delete monitored tokens  # noqa: E501

        Delete tokens from the monitored token list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_monitored_tokens(delete_monitored_tokens_request, async_req=True)
        >>> result = thread.get()

        :param delete_monitored_tokens_request: Request body (required)
        :type delete_monitored_tokens_request: DeleteMonitoredTokensRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the delete_monitored_tokens_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.delete_monitored_tokens_with_http_info(delete_monitored_tokens_request, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_monitored_tokens_with_http_info(self, delete_monitored_tokens_request : Annotated[DeleteMonitoredTokensRequest, Field(..., description="Request body")], **kwargs) -> ApiResponse:  # noqa: E501
        """Delete monitored tokens  # noqa: E501

        Delete tokens from the monitored token list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_monitored_tokens_with_http_info(delete_monitored_tokens_request, async_req=True)
        >>> result = thread.get()

        :param delete_monitored_tokens_request: Request body (required)
        :type delete_monitored_tokens_request: DeleteMonitoredTokensRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'delete_monitored_tokens_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_monitored_tokens" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['delete_monitored_tokens_request'] is not None:
            _body_params = _params['delete_monitored_tokens_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/v1/w3s/config/entity/monitoredTokens/delete', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_monitored_tokens(self, blockchain : Annotated[Optional[Blockchain], Field(description="Filter by blockchain.")] = None, token_address : Annotated[Optional[StrictStr], Field(description="Filter by token address.")] = None, symbol : Annotated[Optional[StrictStr], Field(description="Filter by token symbol.")] = None, var_from : Annotated[Optional[datetime], Field(description="Queries items created since the specified date-time (inclusive) in ISO 8601 format.")] = None, to : Annotated[Optional[datetime], Field(description="Queries items created before the specified date-time (inclusive) in ISO 8601 format.")] = None, page_before : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. ")] = None, page_after : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. ")] = None, page_size : Annotated[Optional[conint(strict=True, le=50, ge=1)], Field(description="Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. ")] = None, **kwargs) -> MonitoredTokens:  # noqa: E501
        """Retrieve existing monitored tokens.  # noqa: E501

        Get monitored tokens  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_monitored_tokens(blockchain, token_address, symbol, var_from, to, page_before, page_after, page_size, async_req=True)
        >>> result = thread.get()

        :param blockchain: Filter by blockchain.
        :type blockchain: Blockchain
        :param token_address: Filter by token address.
        :type token_address: str
        :param symbol: Filter by token symbol.
        :type symbol: str
        :param var_from: Queries items created since the specified date-time (inclusive) in ISO 8601 format.
        :type var_from: datetime
        :param to: Queries items created before the specified date-time (inclusive) in ISO 8601 format.
        :type to: datetime
        :param page_before: A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. 
        :type page_before: str
        :param page_after: A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. 
        :type page_after: str
        :param page_size: Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. 
        :type page_size: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MonitoredTokens
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the list_monitored_tokens_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.list_monitored_tokens_with_http_info(blockchain, token_address, symbol, var_from, to, page_before, page_after, page_size, **kwargs)  # noqa: E501

    @validate_arguments
    def list_monitored_tokens_with_http_info(self, blockchain : Annotated[Optional[Blockchain], Field(description="Filter by blockchain.")] = None, token_address : Annotated[Optional[StrictStr], Field(description="Filter by token address.")] = None, symbol : Annotated[Optional[StrictStr], Field(description="Filter by token symbol.")] = None, var_from : Annotated[Optional[datetime], Field(description="Queries items created since the specified date-time (inclusive) in ISO 8601 format.")] = None, to : Annotated[Optional[datetime], Field(description="Queries items created before the specified date-time (inclusive) in ISO 8601 format.")] = None, page_before : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. ")] = None, page_after : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. ")] = None, page_size : Annotated[Optional[conint(strict=True, le=50, ge=1)], Field(description="Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. ")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Retrieve existing monitored tokens.  # noqa: E501

        Get monitored tokens  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_monitored_tokens_with_http_info(blockchain, token_address, symbol, var_from, to, page_before, page_after, page_size, async_req=True)
        >>> result = thread.get()

        :param blockchain: Filter by blockchain.
        :type blockchain: Blockchain
        :param token_address: Filter by token address.
        :type token_address: str
        :param symbol: Filter by token symbol.
        :type symbol: str
        :param var_from: Queries items created since the specified date-time (inclusive) in ISO 8601 format.
        :type var_from: datetime
        :param to: Queries items created before the specified date-time (inclusive) in ISO 8601 format.
        :type to: datetime
        :param page_before: A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. 
        :type page_before: str
        :param page_after: A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. 
        :type page_after: str
        :param page_size: Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. 
        :type page_size: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MonitoredTokens, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'blockchain',
            'token_address',
            'symbol',
            'var_from',
            'to',
            'page_before',
            'page_after',
            'page_size'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_monitored_tokens" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('blockchain') is not None:  # noqa: E501
            _query_params.append(('blockchain', _params['blockchain'].value))

        if _params.get('token_address') is not None:  # noqa: E501
            _query_params.append(('tokenAddress', _params['token_address']))

        if _params.get('symbol') is not None:  # noqa: E501
            _query_params.append(('symbol', _params['symbol']))

        if _params.get('var_from') is not None:  # noqa: E501
            if isinstance(_params['var_from'], datetime):
                _query_params.append(('from', _params['var_from'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('from', _params['var_from']))

        if _params.get('to') is not None:  # noqa: E501
            if isinstance(_params['to'], datetime):
                _query_params.append(('to', _params['to'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('to', _params['to']))

        if _params.get('page_before') is not None:  # noqa: E501
            _query_params.append(('pageBefore', _params['page_before']))

        if _params.get('page_after') is not None:  # noqa: E501
            _query_params.append(('pageAfter', _params['page_after']))

        if _params.get('page_size') is not None:  # noqa: E501
            _query_params.append(('pageSize', _params['page_size']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "MonitoredTokens",
            '400': "BadRequestResponse",
        }

        return self.api_client.call_api(
            '/v1/w3s/config/entity/monitoredTokens', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_monitored_tokens(self, update_monitored_tokens_request : Annotated[UpdateMonitoredTokensRequest, Field(..., description="Request body")], **kwargs) -> MonitoredTokens:  # noqa: E501
        """Update monitored tokens  # noqa: E501

        Upsert the monitored token list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_monitored_tokens(update_monitored_tokens_request, async_req=True)
        >>> result = thread.get()

        :param update_monitored_tokens_request: Request body (required)
        :type update_monitored_tokens_request: UpdateMonitoredTokensRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MonitoredTokens
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the update_monitored_tokens_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.update_monitored_tokens_with_http_info(update_monitored_tokens_request, **kwargs)  # noqa: E501

    @validate_arguments
    def update_monitored_tokens_with_http_info(self, update_monitored_tokens_request : Annotated[UpdateMonitoredTokensRequest, Field(..., description="Request body")], **kwargs) -> ApiResponse:  # noqa: E501
        """Update monitored tokens  # noqa: E501

        Upsert the monitored token list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_monitored_tokens_with_http_info(update_monitored_tokens_request, async_req=True)
        >>> result = thread.get()

        :param update_monitored_tokens_request: Request body (required)
        :type update_monitored_tokens_request: UpdateMonitoredTokensRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MonitoredTokens, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'update_monitored_tokens_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_monitored_tokens" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_monitored_tokens_request'] is not None:
            _body_params = _params['update_monitored_tokens_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "MonitoredTokens",
            '400': "BadRequestResponse",
        }

        return self.api_client.call_api(
            '/v1/w3s/config/entity/monitoredTokens', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_monitored_tokens_scope(self, update_monitored_tokens_scope_request : Annotated[UpdateMonitoredTokensScopeRequest, Field(..., description="Request body")], **kwargs) -> None:  # noqa: E501
        """Update monitored tokens scope  # noqa: E501

        Select between monitoring all tokens or selected tokens added to the monitored tokens list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_monitored_tokens_scope(update_monitored_tokens_scope_request, async_req=True)
        >>> result = thread.get()

        :param update_monitored_tokens_scope_request: Request body (required)
        :type update_monitored_tokens_scope_request: UpdateMonitoredTokensScopeRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the update_monitored_tokens_scope_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.update_monitored_tokens_scope_with_http_info(update_monitored_tokens_scope_request, **kwargs)  # noqa: E501

    @validate_arguments
    def update_monitored_tokens_scope_with_http_info(self, update_monitored_tokens_scope_request : Annotated[UpdateMonitoredTokensScopeRequest, Field(..., description="Request body")], **kwargs) -> ApiResponse:  # noqa: E501
        """Update monitored tokens scope  # noqa: E501

        Select between monitoring all tokens or selected tokens added to the monitored tokens list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_monitored_tokens_scope_with_http_info(update_monitored_tokens_scope_request, async_req=True)
        >>> result = thread.get()

        :param update_monitored_tokens_scope_request: Request body (required)
        :type update_monitored_tokens_scope_request: UpdateMonitoredTokensScopeRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'update_monitored_tokens_scope_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_monitored_tokens_scope" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_monitored_tokens_scope_request'] is not None:
            _body_params = _params['update_monitored_tokens_scope_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/v1/w3s/config/entity/monitoredTokens/scope', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
