# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictStr

from typing import Optional

from circle.web3.configurations.models.create_subscription_request import CreateSubscriptionRequest
from circle.web3.configurations.models.notification_signature_public_key import NotificationSignaturePublicKey
from circle.web3.configurations.models.subscription_response import SubscriptionResponse
from circle.web3.configurations.models.subscriptions import Subscriptions
from circle.web3.configurations.models.update_subscription_request import UpdateSubscriptionRequest

from circle.web3.configurations.api_client import ApiClient
from circle.web3.configurations.api_response import ApiResponse
from circle.web3.configurations.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class WebhookSubscriptionsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_subscription(self, create_subscription_request : Annotated[CreateSubscriptionRequest, Field(..., description="Schema for the request payload to create a new subscription.")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> SubscriptionResponse:  # noqa: E501
        """Create a notification subscription  # noqa: E501

        Create a notification subscription by configuring an endpoint to receive notifications. For details, see the [Notification Flows](https://developers.circle.com/w3s/docs/notification-flows) guide.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_subscription(create_subscription_request, x_request_id, async_req=True)
        >>> result = thread.get()

        :param create_subscription_request: Schema for the request payload to create a new subscription. (required)
        :type create_subscription_request: CreateSubscriptionRequest
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SubscriptionResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_subscription_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_subscription_with_http_info(create_subscription_request, x_request_id, **kwargs)  # noqa: E501

    @validate_arguments
    def create_subscription_with_http_info(self, create_subscription_request : Annotated[CreateSubscriptionRequest, Field(..., description="Schema for the request payload to create a new subscription.")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Create a notification subscription  # noqa: E501

        Create a notification subscription by configuring an endpoint to receive notifications. For details, see the [Notification Flows](https://developers.circle.com/w3s/docs/notification-flows) guide.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_subscription_with_http_info(create_subscription_request, x_request_id, async_req=True)
        >>> result = thread.get()

        :param create_subscription_request: Schema for the request payload to create a new subscription. (required)
        :type create_subscription_request: CreateSubscriptionRequest
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SubscriptionResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_subscription_request',
            'x_request_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_subscription" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_request_id']:
            _header_params['X-Request-Id'] = _params['x_request_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_subscription_request'] is not None:
            _body_params = _params['create_subscription_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "SubscriptionResponse",
            '400': "BadRequestResponse",
            '401': "NotAuthorizedResponse",
        }

        return self.api_client.call_api(
            '/v2/notifications/subscriptions', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_subscription(self, id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the resource.")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> None:  # noqa: E501
        """Delete a notification subscription  # noqa: E501

        Delete an existing subscription.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_subscription(id, x_request_id, async_req=True)
        >>> result = thread.get()

        :param id: The universally unique identifier of the resource. (required)
        :type id: str
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the delete_subscription_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.delete_subscription_with_http_info(id, x_request_id, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_subscription_with_http_info(self, id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the resource.")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Delete a notification subscription  # noqa: E501

        Delete an existing subscription.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_subscription_with_http_info(id, x_request_id, async_req=True)
        >>> result = thread.get()

        :param id: The universally unique identifier of the resource. (required)
        :type id: str
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'id',
            'x_request_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_subscription" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_request_id']:
            _header_params['X-Request-Id'] = _params['x_request_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/v2/notifications/subscriptions/{id}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_notification_signature(self, id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the resource.")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> NotificationSignaturePublicKey:  # noqa: E501
        """Get a notification signature public key  # noqa: E501

        Get the public key and algorithm used to digitally sign webhook notifications. Verifying the digital signature ensures the notification came from Circle.  In the headers of each webhook, you can find   1. `X-Circle-Signature`: a header containing the digital signature generated by Circle.   2. `X-Circle-Key-Id`: a header containing the UUID. This is will be used as the `ID` as URL parameter to retrieve the relevant public key.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_notification_signature(id, x_request_id, async_req=True)
        >>> result = thread.get()

        :param id: The universally unique identifier of the resource. (required)
        :type id: str
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: NotificationSignaturePublicKey
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_notification_signature_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_notification_signature_with_http_info(id, x_request_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_notification_signature_with_http_info(self, id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the resource.")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get a notification signature public key  # noqa: E501

        Get the public key and algorithm used to digitally sign webhook notifications. Verifying the digital signature ensures the notification came from Circle.  In the headers of each webhook, you can find   1. `X-Circle-Signature`: a header containing the digital signature generated by Circle.   2. `X-Circle-Key-Id`: a header containing the UUID. This is will be used as the `ID` as URL parameter to retrieve the relevant public key.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_notification_signature_with_http_info(id, x_request_id, async_req=True)
        >>> result = thread.get()

        :param id: The universally unique identifier of the resource. (required)
        :type id: str
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(NotificationSignaturePublicKey, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'x_request_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_notification_signature" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_request_id']:
            _header_params['X-Request-Id'] = _params['x_request_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "NotificationSignaturePublicKey",
            '400': "Error",
        }

        return self.api_client.call_api(
            '/v2/notifications/publicKey/{id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_subscription(self, id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the resource.")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> SubscriptionResponse:  # noqa: E501
        """Retrieve a notification subscription  # noqa: E501

        Retrieve an existing notification subscription.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_subscription(id, x_request_id, async_req=True)
        >>> result = thread.get()

        :param id: The universally unique identifier of the resource. (required)
        :type id: str
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SubscriptionResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_subscription_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_subscription_with_http_info(id, x_request_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_subscription_with_http_info(self, id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the resource.")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Retrieve a notification subscription  # noqa: E501

        Retrieve an existing notification subscription.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_subscription_with_http_info(id, x_request_id, async_req=True)
        >>> result = thread.get()

        :param id: The universally unique identifier of the resource. (required)
        :type id: str
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SubscriptionResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'x_request_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_subscription" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_request_id']:
            _header_params['X-Request-Id'] = _params['x_request_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "SubscriptionResponse",
            '401': "NotAuthorizedResponse",
            '404': "NotFoundResponse",
        }

        return self.api_client.call_api(
            '/v2/notifications/subscriptions/{id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_subscriptions(self, **kwargs) -> Subscriptions:  # noqa: E501
        """Get all notification subscriptions  # noqa: E501

        Retrieve an array of existing notification subscriptions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_subscriptions(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Subscriptions
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_subscriptions_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_subscriptions_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def get_subscriptions_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """Get all notification subscriptions  # noqa: E501

        Retrieve an array of existing notification subscriptions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_subscriptions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Subscriptions, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_subscriptions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "Subscriptions",
            '401': "NotAuthorizedResponse",
        }

        return self.api_client.call_api(
            '/v2/notifications/subscriptions', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_subscription(self, id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the resource.")], update_subscription_request : Annotated[UpdateSubscriptionRequest, Field(..., description="Schema for the request payload to update a new subscription.")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> SubscriptionResponse:  # noqa: E501
        """Update a notification subscription  # noqa: E501

        Update subscription endpoint to receive notifications.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_subscription(id, update_subscription_request, x_request_id, async_req=True)
        >>> result = thread.get()

        :param id: The universally unique identifier of the resource. (required)
        :type id: str
        :param update_subscription_request: Schema for the request payload to update a new subscription. (required)
        :type update_subscription_request: UpdateSubscriptionRequest
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SubscriptionResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the update_subscription_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.update_subscription_with_http_info(id, update_subscription_request, x_request_id, **kwargs)  # noqa: E501

    @validate_arguments
    def update_subscription_with_http_info(self, id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the resource.")], update_subscription_request : Annotated[UpdateSubscriptionRequest, Field(..., description="Schema for the request payload to update a new subscription.")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Update a notification subscription  # noqa: E501

        Update subscription endpoint to receive notifications.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_subscription_with_http_info(id, update_subscription_request, x_request_id, async_req=True)
        >>> result = thread.get()

        :param id: The universally unique identifier of the resource. (required)
        :type id: str
        :param update_subscription_request: Schema for the request payload to update a new subscription. (required)
        :type update_subscription_request: UpdateSubscriptionRequest
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SubscriptionResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'update_subscription_request',
            'x_request_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_subscription" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_request_id']:
            _header_params['X-Request-Id'] = _params['x_request_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_subscription_request'] is not None:
            _body_params = _params['update_subscription_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "SubscriptionResponse",
            '400': "BadRequestResponse",
            '401': "NotAuthorizedResponse",
            '404': "NotFoundResponse",
        }

        return self.api_client.call_api(
            '/v2/notifications/subscriptions/{id}', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
