# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

# CUSTOMIZED: Added pydantic_encoder import (not in default OpenAPI Generator template)
# pydantic_encoder is needed to address serialization issues with datetime and other non-primitive fields,
# which are not handled by the default JSON encoder.
from pydantic.json import pydantic_encoder

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist
from circle.web3.configurations.models.notification_type import NotificationType

class Subscription(BaseModel):
    """
    Contains information about a webhook notification subscription.
    """
    id: StrictStr = Field(..., description="System-generated unique identifier of the resource.")
    name: StrictStr = Field(..., description="Name of the webhook notification subscription.")
    endpoint: StrictStr = Field(..., description="URL of the endpoint subscribing to notifications. Must be enabled to receive notifications.")
    enabled: StrictBool = Field(..., description="Whether the subscription is enabled. `true` indicates the subscription is enabled.")
    create_date: datetime = Field(..., alias="createDate", description="Date and time the resource was created, in ISO-8601 UTC format.")
    update_date: datetime = Field(..., alias="updateDate", description="Date and time the resource was last updated, in ISO-8601 UTC format.")
    notification_types: Optional[conlist(NotificationType)] = Field(None, alias="notificationTypes", description="The notification types on which a notification will be sent.")
    restricted: Optional[StrictBool] = Field(None, description="Whether the webhook is restricted to specific notification types. An unrestricted webhook will notify on all notification types. A restricted webhook will only notify on the notification types in the `notificationTypes` field.")
    __properties = ["id", "name", "endpoint", "enabled", "createDate", "updateDate", "notificationTypes", "restricted"]

    def __init__(self, **kwargs):
        if "idempotencyKey" in self.__properties and not kwargs.get("idempotency_key"):
            kwargs["idempotency_key"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in self.__properties and not kwargs.get("entity_secret_ciphertext"):
            kwargs["entity_secret_ciphertext"] = "#REFILL_PLACEHOLDER"
        super().__init__(**kwargs)


    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Return JSON string of the model (handles datetime/UUID/Decimal/Enum, etc.)"""
        # CUSTOMIZED: Added default=pydantic_encoder to handle complex types (datetime, UUID, Enum, etc.)
        # This differs from the default OpenAPI Generator template which doesn't handle these types properly
        return json.dumps(self.to_dict(), default=pydantic_encoder)

    @classmethod
    def from_json(cls, json_str: str) -> Subscription:
        """Create an instance of Subscription from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Subscription:
        """Create an instance of Subscription from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Subscription.parse_obj(obj)

        # fill idempotency_key and ciphertext with placeholder for auto_fill
        if "idempotencyKey" in cls.__properties and not obj.get("idempotencyKey"):
            obj["idempotencyKey"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in cls.__properties and not obj.get("entitySecretCiphertext"):
            obj["entitySecretCiphertext"] = "#REFILL_PLACEHOLDER"

        _obj = Subscription.parse_obj({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "endpoint": obj.get("endpoint"),
            "enabled": obj.get("enabled"),
            "create_date": obj.get("createDate"),
            "update_date": obj.get("updateDate"),
            "notification_types": obj.get("notificationTypes"),
            "restricted": obj.get("restricted")
        })
        return _obj


