from dataclasses import dataclass
from sqlmodel import SQLModel
from typing import Generic, TypeVar

SQLModel_Schema = TypeVar("SQLModel_Schema", bound=SQLModel)
SQLModel_Field = TypeVar("SQLModel_Field", bound=SQLModel)
SQLModel_Value = TypeVar("SQLModel_Value", bound=SQLModel)

@dataclass
class GeneratorConfig(Generic[SQLModel_Schema, SQLModel_Field, SQLModel_Value]):
    enum_engine_name: str = ...
    enum_schema_table: type[SQLModel_Schema] = ...
    enum_field_table: type[SQLModel_Field] = ...
    enum_value_table: type[SQLModel_Value] = ...
    target_engine_name: str = ...
    default_schema_name: str | None = ...
    output_path: str | None = ...
