from dataclasses import dataclass
from datetime import datetime, timedelta, tzinfo

__all__ = ["Snowflake", "SnowflakeGenerator", "MAX_TS", "MAX_INSTANCE", "MAX_SEQ"]

MAX_TS: int
MAX_INSTANCE: int
MAX_SEQ: int

@dataclass(frozen=True)
class Snowflake:
    timestamp: int
    instance: int
    epoch: int = ...
    seq: int = ...
    def __post_init__(self) -> None: ...
    @classmethod
    def parse(cls, snowflake: int, epoch: int = 0) -> Snowflake: ...
    @property
    def milliseconds(self) -> int: ...
    @property
    def seconds(self) -> float: ...
    @property
    def datetime(self) -> datetime: ...
    def datetime_tz(self, tz: tzinfo | None = None) -> datetime: ...
    @property
    def timedelta(self) -> timedelta: ...
    @property
    def value(self) -> int: ...
    def __int__(self) -> int: ...

class SnowflakeGenerator:
    def __init__(
        self,
        instance: int,
        *,
        seq: int = 0,
        epoch: int = 0,
        timestamp: int | None = None,
    ) -> None: ...
    @classmethod
    def from_snowflake(cls, sf: Snowflake) -> SnowflakeGenerator: ...
    @property
    def epoch(self) -> int: ...
    def __iter__(self): ...
    def __next__(self) -> int | None: ...
