# generated by datamodel-codegen:
#   filename:  .openapi.json
#   timestamp: 2025-10-15T19:25:00+00:00

from __future__ import annotations
from typing import Any, Dict, List, Literal, Optional, TypedDict, Union
from typing_extensions import NotRequired


TraceAndSpanId = List


class EvalResultsFetch(TypedDict):
    experiment_run_id: str
    project_name: str


class DatasetFetch(TypedDict):
    dataset_name: str
    project_name: str


class DatasetsFetch(TypedDict):
    project_name: str


class DatasetsTableRow(TypedDict):
    dataset_id: str
    name: str
    created_at: str
    kind: Literal["trace", "example"]
    entries: int
    creator: str


class ProjectAdd(TypedDict):
    project_name: str


class ProjectAddResponse(TypedDict):
    project_id: str


class ProjectDeleteFromJudgevalResponse(TypedDict):
    project_name: str


class ProjectDeleteResponse(TypedDict):
    message: str


class ScorerExistsRequest(TypedDict):
    name: str


class ScorerExistsResponse(TypedDict):
    exists: bool


class SavePromptScorerRequest(TypedDict):
    name: str
    prompt: str
    threshold: float
    model: NotRequired[str]
    is_trace: NotRequired[bool]
    options: NotRequired[Optional[Dict[str, float]]]
    description: NotRequired[Optional[str]]


class SavePromptScorerResponse(TypedDict):
    message: str
    name: str


class FetchPromptScorersRequest(TypedDict):
    names: NotRequired[Optional[List[str]]]


class CustomScorerUploadPayload(TypedDict):
    scorer_name: str
    scorer_code: str
    requirements_text: str


class CustomScorerTemplateResponse(TypedDict):
    scorer_name: str
    status: str
    message: str


class ResolveProjectNameRequest(TypedDict):
    project_name: str


class ResolveProjectNameResponse(TypedDict):
    project_id: str


class TraceIdRequest(TypedDict):
    trace_id: str


class SpanScoreRequest(TypedDict):
    span_id: str
    trace_id: str


class BaseScorer(TypedDict):
    score_type: str
    threshold: NotRequired[float]
    name: NotRequired[Optional[str]]
    class_name: NotRequired[Optional[str]]
    score: NotRequired[Optional[float]]
    score_breakdown: NotRequired[Optional[Dict[str, Any]]]
    reason: NotRequired[Optional[str]]
    using_native_model: NotRequired[Optional[bool]]
    success: NotRequired[Optional[bool]]
    model: NotRequired[Optional[str]]
    model_client: NotRequired[Any]
    strict_mode: NotRequired[bool]
    error: NotRequired[Optional[str]]
    additional_metadata: NotRequired[Optional[Dict[str, Any]]]
    user: NotRequired[Optional[str]]
    server_hosted: NotRequired[bool]


class ScorerConfig(TypedDict):
    score_type: str
    name: NotRequired[Optional[str]]
    threshold: NotRequired[float]
    model: NotRequired[Optional[str]]
    strict_mode: NotRequired[bool]
    required_params: NotRequired[List[str]]
    kwargs: NotRequired[Optional[Dict[str, Any]]]


class Example(TypedDict):
    example_id: NotRequired[str]
    created_at: NotRequired[str]
    name: NotRequired[Optional[str]]


class ValidationError(TypedDict):
    loc: List[Union[str, int]]
    msg: str
    type: str


class UsageInfo(TypedDict):
    total_judgees: int
    regular_use: int
    pay_as_you_go_use: int
    remaining_regular: int
    remaining_after: int


DatasetKind = Literal["trace", "example"]


class PromptScorer(TypedDict):
    name: str
    prompt: str
    threshold: float
    model: NotRequired[str]
    options: NotRequired[Optional[Dict[str, float]]]
    description: NotRequired[Optional[str]]
    created_at: NotRequired[Optional[str]]
    updated_at: NotRequired[Optional[str]]
    is_trace: NotRequired[Optional[bool]]


class ScorerData(TypedDict):
    id: NotRequired[str]
    name: str
    threshold: float
    success: bool
    score: NotRequired[Optional[float]]
    reason: NotRequired[Optional[str]]
    strict_mode: NotRequired[Optional[bool]]
    evaluation_model: NotRequired[Optional[str]]
    error: NotRequired[Optional[str]]
    additional_metadata: NotRequired[Optional[Dict[str, Any]]]


class OtelTraceSpan(TypedDict):
    organization_id: str
    project_id: NotRequired[Optional[str]]
    user_id: str
    timestamp: str
    trace_id: str
    span_id: str
    parent_span_id: NotRequired[Optional[str]]
    trace_state: NotRequired[Optional[str]]
    span_name: NotRequired[Optional[str]]
    span_kind: NotRequired[Optional[str]]
    service_name: NotRequired[Optional[str]]
    resource_attributes: NotRequired[Optional[Dict[str, Any]]]
    span_attributes: NotRequired[Optional[Dict[str, Any]]]
    duration: NotRequired[Optional[int]]
    status_code: NotRequired[Optional[int]]
    status_message: NotRequired[Optional[str]]
    events: NotRequired[Optional[List[Dict[str, Any]]]]
    links: NotRequired[Optional[List[Dict[str, Any]]]]


class OtelSpanListItemScores(TypedDict):
    success: bool
    score: float
    reason: NotRequired[Optional[str]]
    name: str


class OtelSpanDetailScores(TypedDict):
    success: bool
    score: float
    reason: NotRequired[Optional[str]]
    name: str
    example_id: NotRequired[Optional[str]]


class ExampleEvaluationRun(TypedDict):
    id: NotRequired[str]
    project_name: str
    eval_name: str
    custom_scorers: NotRequired[List[BaseScorer]]
    judgment_scorers: NotRequired[List[ScorerConfig]]
    model: NotRequired[Optional[str]]
    created_at: NotRequired[str]
    examples: List[Example]
    trace_span_id: NotRequired[Optional[str]]
    trace_id: NotRequired[Optional[str]]


class HTTPValidationError(TypedDict):
    detail: NotRequired[List[ValidationError]]


class TraceEvaluationRun(TypedDict):
    id: NotRequired[str]
    project_name: str
    eval_name: str
    custom_scorers: NotRequired[List[BaseScorer]]
    judgment_scorers: NotRequired[List[ScorerConfig]]
    model: NotRequired[Optional[str]]
    created_at: NotRequired[str]
    trace_and_span_ids: List[TraceAndSpanId]
    is_offline: NotRequired[bool]


class DatasetInsertExamples(TypedDict):
    dataset_name: str
    examples: List[Example]
    project_name: str


class DatasetCreate(TypedDict):
    name: str
    dataset_kind: DatasetKind
    project_name: str
    examples: List[Example]
    overwrite: bool


class FetchPromptScorersResponse(TypedDict):
    scorers: List[PromptScorer]


class ScoringResult(TypedDict):
    success: bool
    scorers_data: List[ScorerData]
    name: NotRequired[Optional[str]]
    data_object: NotRequired[Optional[Union[OtelTraceSpan, Example]]]
    trace_id: NotRequired[Optional[str]]
    run_duration: NotRequired[Optional[float]]
    evaluation_cost: NotRequired[Optional[float]]


class OtelTraceListItem(TypedDict):
    organization_id: str
    project_id: str
    trace_id: str
    created_at: str
    duration: NotRequired[Optional[int]]
    tags: NotRequired[Optional[List[str]]]
    experiment_run_id: NotRequired[Optional[str]]
    span_name: NotRequired[Optional[str]]
    llm_cost: NotRequired[Optional[float]]
    error: NotRequired[str]
    scores: NotRequired[List[OtelSpanListItemScores]]
    customer_id: NotRequired[Optional[str]]
    input: NotRequired[Optional[str]]
    output: NotRequired[Optional[str]]
    input_preview: NotRequired[Optional[str]]
    output_preview: NotRequired[Optional[str]]
    annotation_count: NotRequired[int]
    span_id: str
    rule_id: NotRequired[Optional[str]]


class OtelSpanDetail(TypedDict):
    organization_id: str
    project_id: str
    timestamp: str
    trace_id: str
    span_id: str
    parent_span_id: NotRequired[Optional[str]]
    trace_state: NotRequired[Optional[str]]
    span_name: NotRequired[Optional[str]]
    span_kind: NotRequired[Optional[str]]
    service_name: NotRequired[Optional[str]]
    resource_attributes: NotRequired[Optional[Dict[str, Any]]]
    span_attributes: NotRequired[Optional[Dict[str, Any]]]
    duration: NotRequired[Optional[int]]
    status_code: NotRequired[Optional[int]]
    status_message: NotRequired[Optional[str]]
    events: NotRequired[Optional[List[Dict[str, Any]]]]
    links: NotRequired[Optional[Union[List[Dict[str, Any]], Dict[str, Any]]]]
    llm_cost: NotRequired[Optional[float]]
    prompt_tokens: NotRequired[Optional[int]]
    completion_tokens: NotRequired[Optional[int]]
    scores: NotRequired[Optional[List[OtelSpanDetailScores]]]


class EvaluateResponse(TypedDict):
    status: str
    results: List[ScoringResult]
    resource_usage: NotRequired[Optional[UsageInfo]]


class EvalResults(TypedDict):
    results: List[ScoringResult]
    run: Union[ExampleEvaluationRun, TraceEvaluationRun]


class DatasetTraceWithSpans(TypedDict):
    dataset_id: str
    trace_detail: OtelTraceListItem
    spans: List[OtelSpanDetail]


class DatasetReturn(TypedDict):
    name: str
    project_name: str
    dataset_kind: DatasetKind
    examples: NotRequired[List[Example]]
    traces: NotRequired[Optional[List[DatasetTraceWithSpans]]]
