# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['RoleArgs', 'Role']

@pulumi.input_type
class RoleArgs:
    def __init__(__self__, *,
                 assume_role: Optional[pulumi.Input[_builtins.str]] = None,
                 bypass_row_level_security: Optional[pulumi.Input[_builtins.bool]] = None,
                 connection_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 create_database: Optional[pulumi.Input[_builtins.bool]] = None,
                 create_role: Optional[pulumi.Input[_builtins.bool]] = None,
                 encrypted: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypted_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 idle_in_transaction_session_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 inherit: Optional[pulumi.Input[_builtins.bool]] = None,
                 login: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 replication: Optional[pulumi.Input[_builtins.bool]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 search_paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 skip_drop_role: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_reassign_owned: Optional[pulumi.Input[_builtins.bool]] = None,
                 statement_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 superuser: Optional[pulumi.Input[_builtins.bool]] = None,
                 valid_until: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Role resource.
        :param pulumi.Input[_builtins.str] assume_role: Defines the role to switch to at login via [`SET ROLE`](https://www.postgresql.org/docs/current/sql-set-role.html).
        :param pulumi.Input[_builtins.bool] bypass_row_level_security: Defines whether a role bypasses every
               row-level security (RLS) policy.  Default value is `false`.
        :param pulumi.Input[_builtins.int] connection_limit: If this role can log in, this specifies how
               many concurrent connections the role can establish. `-1` (the default) means no
               limit.
        :param pulumi.Input[_builtins.bool] create_database: Defines a role's ability to execute `CREATE
               DATABASE`.  Default value is `false`.
        :param pulumi.Input[_builtins.bool] create_role: Defines a role's ability to execute `CREATE ROLE`.
               A role with this privilege can also alter and drop other roles.  Default value
               is `false`.
        :param pulumi.Input[_builtins.bool] encrypted_password: Defines whether the password is stored
               encrypted in the system catalogs.  Default value is `true`.  NOTE: this value
               is always set (to the conservative and safe value), but may interfere with the
               behavior of
               [PostgreSQL's `password_encryption` setting](https://www.postgresql.org/docs/current/static/runtime-config-connection.html#GUC-PASSWORD-ENCRYPTION).
        :param pulumi.Input[_builtins.int] idle_in_transaction_session_timeout: Terminate any session with an open transaction that has been idle for longer than the specified duration in milliseconds
        :param pulumi.Input[_builtins.bool] inherit: Defines whether a role "inherits" the privileges of
               roles it is a member of.  Default value is `true`.
        :param pulumi.Input[_builtins.bool] login: Defines whether role is allowed to log in.  Roles without
               this attribute are useful for managing database privileges, but are not users
               in the usual sense of the word.  Default value is `false`.
        :param pulumi.Input[_builtins.str] name: The name of the role. Must be unique on the PostgreSQL
               server instance where it is configured.
        :param pulumi.Input[_builtins.str] password: Sets the role's password. A password is only of use
               for roles having the `login` attribute set to true.
        :param pulumi.Input[_builtins.bool] replication: Defines whether a role is allowed to initiate
               streaming replication or put the system in and out of backup mode.  Default
               value is `false`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: Defines list of roles which will be granted to this new role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] search_paths: Alters the search path of this new role. Note that
               due to limitations in the implementation, values cannot contain the substring
               `", "`.
        :param pulumi.Input[_builtins.bool] skip_drop_role: When a PostgreSQL ROLE exists in multiple
               databases and the ROLE is dropped, the
               [cleanup of ownership of objects](https://www.postgresql.org/docs/current/static/role-removal.html)
               in each of the respective databases must occur before the ROLE can be dropped
               from the catalog.  Set this option to true when there are multiple databases
               in a PostgreSQL cluster using the same PostgreSQL ROLE for object ownership.
               This is the third and final step taken when removing a ROLE from a database.
        :param pulumi.Input[_builtins.bool] skip_reassign_owned: When a PostgreSQL ROLE exists in multiple
               databases and the ROLE is dropped, a
               [`REASSIGN OWNED`](https://www.postgresql.org/docs/current/static/sql-reassign-owned.html) in
               must be executed on each of the respective databases before the `DROP ROLE`
               can be executed to dropped the ROLE from the catalog.  This is the first and
               second steps taken when removing a ROLE from a database (the second step being
               an implicit
               [`DROP OWNED`](https://www.postgresql.org/docs/current/static/sql-drop-owned.html)).
        :param pulumi.Input[_builtins.int] statement_timeout: Defines [`statement_timeout`](https://www.postgresql.org/docs/current/runtime-config-client.html#RUNTIME-CONFIG-CLIENT-STATEMENT) setting for this role which allows to abort any statement that takes more than the specified amount of time.
        :param pulumi.Input[_builtins.bool] superuser: Defines whether the role is a "superuser", and
               therefore can override all access restrictions within the database.  Default
               value is `false`.
        :param pulumi.Input[_builtins.str] valid_until: Defines the date and time after which the role's
               password is no longer valid.  Established connections past this `valid_time`
               will have to be manually terminated.  This value corresponds to a PostgreSQL
               datetime. If omitted or the magic value `NULL` is used, `valid_until` will be
               set to `infinity`.  Default is `NULL`, therefore `infinity`.
        """
        if assume_role is not None:
            pulumi.set(__self__, "assume_role", assume_role)
        if bypass_row_level_security is not None:
            pulumi.set(__self__, "bypass_row_level_security", bypass_row_level_security)
        if connection_limit is not None:
            pulumi.set(__self__, "connection_limit", connection_limit)
        if create_database is not None:
            pulumi.set(__self__, "create_database", create_database)
        if create_role is not None:
            pulumi.set(__self__, "create_role", create_role)
        if encrypted is not None:
            warnings.warn("""Rename PostgreSQL role resource attribute \"encrypted\" to \"encrypted_password\"""", DeprecationWarning)
            pulumi.log.warn("""encrypted is deprecated: Rename PostgreSQL role resource attribute \"encrypted\" to \"encrypted_password\"""")
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if encrypted_password is not None:
            pulumi.set(__self__, "encrypted_password", encrypted_password)
        if idle_in_transaction_session_timeout is not None:
            pulumi.set(__self__, "idle_in_transaction_session_timeout", idle_in_transaction_session_timeout)
        if inherit is not None:
            pulumi.set(__self__, "inherit", inherit)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if replication is not None:
            pulumi.set(__self__, "replication", replication)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if search_paths is not None:
            pulumi.set(__self__, "search_paths", search_paths)
        if skip_drop_role is not None:
            pulumi.set(__self__, "skip_drop_role", skip_drop_role)
        if skip_reassign_owned is not None:
            pulumi.set(__self__, "skip_reassign_owned", skip_reassign_owned)
        if statement_timeout is not None:
            pulumi.set(__self__, "statement_timeout", statement_timeout)
        if superuser is not None:
            pulumi.set(__self__, "superuser", superuser)
        if valid_until is not None:
            pulumi.set(__self__, "valid_until", valid_until)

    @_builtins.property
    @pulumi.getter(name="assumeRole")
    def assume_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the role to switch to at login via [`SET ROLE`](https://www.postgresql.org/docs/current/sql-set-role.html).
        """
        return pulumi.get(self, "assume_role")

    @assume_role.setter
    def assume_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assume_role", value)

    @_builtins.property
    @pulumi.getter(name="bypassRowLevelSecurity")
    def bypass_row_level_security(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether a role bypasses every
        row-level security (RLS) policy.  Default value is `false`.
        """
        return pulumi.get(self, "bypass_row_level_security")

    @bypass_row_level_security.setter
    def bypass_row_level_security(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bypass_row_level_security", value)

    @_builtins.property
    @pulumi.getter(name="connectionLimit")
    def connection_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        If this role can log in, this specifies how
        many concurrent connections the role can establish. `-1` (the default) means no
        limit.
        """
        return pulumi.get(self, "connection_limit")

    @connection_limit.setter
    def connection_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_limit", value)

    @_builtins.property
    @pulumi.getter(name="createDatabase")
    def create_database(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines a role's ability to execute `CREATE
        DATABASE`.  Default value is `false`.
        """
        return pulumi.get(self, "create_database")

    @create_database.setter
    def create_database(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "create_database", value)

    @_builtins.property
    @pulumi.getter(name="createRole")
    def create_role(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines a role's ability to execute `CREATE ROLE`.
        A role with this privilege can also alter and drop other roles.  Default value
        is `false`.
        """
        return pulumi.get(self, "create_role")

    @create_role.setter
    def create_role(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "create_role", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Rename PostgreSQL role resource attribute \"encrypted\" to \"encrypted_password\"""")
    def encrypted(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encrypted", value)

    @_builtins.property
    @pulumi.getter(name="encryptedPassword")
    def encrypted_password(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether the password is stored
        encrypted in the system catalogs.  Default value is `true`.  NOTE: this value
        is always set (to the conservative and safe value), but may interfere with the
        behavior of
        [PostgreSQL's `password_encryption` setting](https://www.postgresql.org/docs/current/static/runtime-config-connection.html#GUC-PASSWORD-ENCRYPTION).
        """
        return pulumi.get(self, "encrypted_password")

    @encrypted_password.setter
    def encrypted_password(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "encrypted_password", value)

    @_builtins.property
    @pulumi.getter(name="idleInTransactionSessionTimeout")
    def idle_in_transaction_session_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Terminate any session with an open transaction that has been idle for longer than the specified duration in milliseconds
        """
        return pulumi.get(self, "idle_in_transaction_session_timeout")

    @idle_in_transaction_session_timeout.setter
    def idle_in_transaction_session_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "idle_in_transaction_session_timeout", value)

    @_builtins.property
    @pulumi.getter
    def inherit(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether a role "inherits" the privileges of
        roles it is a member of.  Default value is `true`.
        """
        return pulumi.get(self, "inherit")

    @inherit.setter
    def inherit(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "inherit", value)

    @_builtins.property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether role is allowed to log in.  Roles without
        this attribute are useful for managing database privileges, but are not users
        in the usual sense of the word.  Default value is `false`.
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "login", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the role. Must be unique on the PostgreSQL
        server instance where it is configured.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets the role's password. A password is only of use
        for roles having the `login` attribute set to true.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def replication(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether a role is allowed to initiate
        streaming replication or put the system in and out of backup mode.  Default
        value is `false`
        """
        return pulumi.get(self, "replication")

    @replication.setter
    def replication(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "replication", value)

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Defines list of roles which will be granted to this new role.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "roles", value)

    @_builtins.property
    @pulumi.getter(name="searchPaths")
    def search_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Alters the search path of this new role. Note that
        due to limitations in the implementation, values cannot contain the substring
        `", "`.
        """
        return pulumi.get(self, "search_paths")

    @search_paths.setter
    def search_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "search_paths", value)

    @_builtins.property
    @pulumi.getter(name="skipDropRole")
    def skip_drop_role(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When a PostgreSQL ROLE exists in multiple
        databases and the ROLE is dropped, the
        [cleanup of ownership of objects](https://www.postgresql.org/docs/current/static/role-removal.html)
        in each of the respective databases must occur before the ROLE can be dropped
        from the catalog.  Set this option to true when there are multiple databases
        in a PostgreSQL cluster using the same PostgreSQL ROLE for object ownership.
        This is the third and final step taken when removing a ROLE from a database.
        """
        return pulumi.get(self, "skip_drop_role")

    @skip_drop_role.setter
    def skip_drop_role(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_drop_role", value)

    @_builtins.property
    @pulumi.getter(name="skipReassignOwned")
    def skip_reassign_owned(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When a PostgreSQL ROLE exists in multiple
        databases and the ROLE is dropped, a
        [`REASSIGN OWNED`](https://www.postgresql.org/docs/current/static/sql-reassign-owned.html) in
        must be executed on each of the respective databases before the `DROP ROLE`
        can be executed to dropped the ROLE from the catalog.  This is the first and
        second steps taken when removing a ROLE from a database (the second step being
        an implicit
        [`DROP OWNED`](https://www.postgresql.org/docs/current/static/sql-drop-owned.html)).
        """
        return pulumi.get(self, "skip_reassign_owned")

    @skip_reassign_owned.setter
    def skip_reassign_owned(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_reassign_owned", value)

    @_builtins.property
    @pulumi.getter(name="statementTimeout")
    def statement_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Defines [`statement_timeout`](https://www.postgresql.org/docs/current/runtime-config-client.html#RUNTIME-CONFIG-CLIENT-STATEMENT) setting for this role which allows to abort any statement that takes more than the specified amount of time.
        """
        return pulumi.get(self, "statement_timeout")

    @statement_timeout.setter
    def statement_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "statement_timeout", value)

    @_builtins.property
    @pulumi.getter
    def superuser(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether the role is a "superuser", and
        therefore can override all access restrictions within the database.  Default
        value is `false`.
        """
        return pulumi.get(self, "superuser")

    @superuser.setter
    def superuser(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "superuser", value)

    @_builtins.property
    @pulumi.getter(name="validUntil")
    def valid_until(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the date and time after which the role's
        password is no longer valid.  Established connections past this `valid_time`
        will have to be manually terminated.  This value corresponds to a PostgreSQL
        datetime. If omitted or the magic value `NULL` is used, `valid_until` will be
        set to `infinity`.  Default is `NULL`, therefore `infinity`.
        """
        return pulumi.get(self, "valid_until")

    @valid_until.setter
    def valid_until(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "valid_until", value)


@pulumi.input_type
class _RoleState:
    def __init__(__self__, *,
                 assume_role: Optional[pulumi.Input[_builtins.str]] = None,
                 bypass_row_level_security: Optional[pulumi.Input[_builtins.bool]] = None,
                 connection_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 create_database: Optional[pulumi.Input[_builtins.bool]] = None,
                 create_role: Optional[pulumi.Input[_builtins.bool]] = None,
                 encrypted: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypted_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 idle_in_transaction_session_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 inherit: Optional[pulumi.Input[_builtins.bool]] = None,
                 login: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 replication: Optional[pulumi.Input[_builtins.bool]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 search_paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 skip_drop_role: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_reassign_owned: Optional[pulumi.Input[_builtins.bool]] = None,
                 statement_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 superuser: Optional[pulumi.Input[_builtins.bool]] = None,
                 valid_until: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Role resources.
        :param pulumi.Input[_builtins.str] assume_role: Defines the role to switch to at login via [`SET ROLE`](https://www.postgresql.org/docs/current/sql-set-role.html).
        :param pulumi.Input[_builtins.bool] bypass_row_level_security: Defines whether a role bypasses every
               row-level security (RLS) policy.  Default value is `false`.
        :param pulumi.Input[_builtins.int] connection_limit: If this role can log in, this specifies how
               many concurrent connections the role can establish. `-1` (the default) means no
               limit.
        :param pulumi.Input[_builtins.bool] create_database: Defines a role's ability to execute `CREATE
               DATABASE`.  Default value is `false`.
        :param pulumi.Input[_builtins.bool] create_role: Defines a role's ability to execute `CREATE ROLE`.
               A role with this privilege can also alter and drop other roles.  Default value
               is `false`.
        :param pulumi.Input[_builtins.bool] encrypted_password: Defines whether the password is stored
               encrypted in the system catalogs.  Default value is `true`.  NOTE: this value
               is always set (to the conservative and safe value), but may interfere with the
               behavior of
               [PostgreSQL's `password_encryption` setting](https://www.postgresql.org/docs/current/static/runtime-config-connection.html#GUC-PASSWORD-ENCRYPTION).
        :param pulumi.Input[_builtins.int] idle_in_transaction_session_timeout: Terminate any session with an open transaction that has been idle for longer than the specified duration in milliseconds
        :param pulumi.Input[_builtins.bool] inherit: Defines whether a role "inherits" the privileges of
               roles it is a member of.  Default value is `true`.
        :param pulumi.Input[_builtins.bool] login: Defines whether role is allowed to log in.  Roles without
               this attribute are useful for managing database privileges, but are not users
               in the usual sense of the word.  Default value is `false`.
        :param pulumi.Input[_builtins.str] name: The name of the role. Must be unique on the PostgreSQL
               server instance where it is configured.
        :param pulumi.Input[_builtins.str] password: Sets the role's password. A password is only of use
               for roles having the `login` attribute set to true.
        :param pulumi.Input[_builtins.bool] replication: Defines whether a role is allowed to initiate
               streaming replication or put the system in and out of backup mode.  Default
               value is `false`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: Defines list of roles which will be granted to this new role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] search_paths: Alters the search path of this new role. Note that
               due to limitations in the implementation, values cannot contain the substring
               `", "`.
        :param pulumi.Input[_builtins.bool] skip_drop_role: When a PostgreSQL ROLE exists in multiple
               databases and the ROLE is dropped, the
               [cleanup of ownership of objects](https://www.postgresql.org/docs/current/static/role-removal.html)
               in each of the respective databases must occur before the ROLE can be dropped
               from the catalog.  Set this option to true when there are multiple databases
               in a PostgreSQL cluster using the same PostgreSQL ROLE for object ownership.
               This is the third and final step taken when removing a ROLE from a database.
        :param pulumi.Input[_builtins.bool] skip_reassign_owned: When a PostgreSQL ROLE exists in multiple
               databases and the ROLE is dropped, a
               [`REASSIGN OWNED`](https://www.postgresql.org/docs/current/static/sql-reassign-owned.html) in
               must be executed on each of the respective databases before the `DROP ROLE`
               can be executed to dropped the ROLE from the catalog.  This is the first and
               second steps taken when removing a ROLE from a database (the second step being
               an implicit
               [`DROP OWNED`](https://www.postgresql.org/docs/current/static/sql-drop-owned.html)).
        :param pulumi.Input[_builtins.int] statement_timeout: Defines [`statement_timeout`](https://www.postgresql.org/docs/current/runtime-config-client.html#RUNTIME-CONFIG-CLIENT-STATEMENT) setting for this role which allows to abort any statement that takes more than the specified amount of time.
        :param pulumi.Input[_builtins.bool] superuser: Defines whether the role is a "superuser", and
               therefore can override all access restrictions within the database.  Default
               value is `false`.
        :param pulumi.Input[_builtins.str] valid_until: Defines the date and time after which the role's
               password is no longer valid.  Established connections past this `valid_time`
               will have to be manually terminated.  This value corresponds to a PostgreSQL
               datetime. If omitted or the magic value `NULL` is used, `valid_until` will be
               set to `infinity`.  Default is `NULL`, therefore `infinity`.
        """
        if assume_role is not None:
            pulumi.set(__self__, "assume_role", assume_role)
        if bypass_row_level_security is not None:
            pulumi.set(__self__, "bypass_row_level_security", bypass_row_level_security)
        if connection_limit is not None:
            pulumi.set(__self__, "connection_limit", connection_limit)
        if create_database is not None:
            pulumi.set(__self__, "create_database", create_database)
        if create_role is not None:
            pulumi.set(__self__, "create_role", create_role)
        if encrypted is not None:
            warnings.warn("""Rename PostgreSQL role resource attribute \"encrypted\" to \"encrypted_password\"""", DeprecationWarning)
            pulumi.log.warn("""encrypted is deprecated: Rename PostgreSQL role resource attribute \"encrypted\" to \"encrypted_password\"""")
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if encrypted_password is not None:
            pulumi.set(__self__, "encrypted_password", encrypted_password)
        if idle_in_transaction_session_timeout is not None:
            pulumi.set(__self__, "idle_in_transaction_session_timeout", idle_in_transaction_session_timeout)
        if inherit is not None:
            pulumi.set(__self__, "inherit", inherit)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if replication is not None:
            pulumi.set(__self__, "replication", replication)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if search_paths is not None:
            pulumi.set(__self__, "search_paths", search_paths)
        if skip_drop_role is not None:
            pulumi.set(__self__, "skip_drop_role", skip_drop_role)
        if skip_reassign_owned is not None:
            pulumi.set(__self__, "skip_reassign_owned", skip_reassign_owned)
        if statement_timeout is not None:
            pulumi.set(__self__, "statement_timeout", statement_timeout)
        if superuser is not None:
            pulumi.set(__self__, "superuser", superuser)
        if valid_until is not None:
            pulumi.set(__self__, "valid_until", valid_until)

    @_builtins.property
    @pulumi.getter(name="assumeRole")
    def assume_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the role to switch to at login via [`SET ROLE`](https://www.postgresql.org/docs/current/sql-set-role.html).
        """
        return pulumi.get(self, "assume_role")

    @assume_role.setter
    def assume_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assume_role", value)

    @_builtins.property
    @pulumi.getter(name="bypassRowLevelSecurity")
    def bypass_row_level_security(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether a role bypasses every
        row-level security (RLS) policy.  Default value is `false`.
        """
        return pulumi.get(self, "bypass_row_level_security")

    @bypass_row_level_security.setter
    def bypass_row_level_security(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bypass_row_level_security", value)

    @_builtins.property
    @pulumi.getter(name="connectionLimit")
    def connection_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        If this role can log in, this specifies how
        many concurrent connections the role can establish. `-1` (the default) means no
        limit.
        """
        return pulumi.get(self, "connection_limit")

    @connection_limit.setter
    def connection_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_limit", value)

    @_builtins.property
    @pulumi.getter(name="createDatabase")
    def create_database(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines a role's ability to execute `CREATE
        DATABASE`.  Default value is `false`.
        """
        return pulumi.get(self, "create_database")

    @create_database.setter
    def create_database(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "create_database", value)

    @_builtins.property
    @pulumi.getter(name="createRole")
    def create_role(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines a role's ability to execute `CREATE ROLE`.
        A role with this privilege can also alter and drop other roles.  Default value
        is `false`.
        """
        return pulumi.get(self, "create_role")

    @create_role.setter
    def create_role(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "create_role", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Rename PostgreSQL role resource attribute \"encrypted\" to \"encrypted_password\"""")
    def encrypted(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encrypted", value)

    @_builtins.property
    @pulumi.getter(name="encryptedPassword")
    def encrypted_password(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether the password is stored
        encrypted in the system catalogs.  Default value is `true`.  NOTE: this value
        is always set (to the conservative and safe value), but may interfere with the
        behavior of
        [PostgreSQL's `password_encryption` setting](https://www.postgresql.org/docs/current/static/runtime-config-connection.html#GUC-PASSWORD-ENCRYPTION).
        """
        return pulumi.get(self, "encrypted_password")

    @encrypted_password.setter
    def encrypted_password(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "encrypted_password", value)

    @_builtins.property
    @pulumi.getter(name="idleInTransactionSessionTimeout")
    def idle_in_transaction_session_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Terminate any session with an open transaction that has been idle for longer than the specified duration in milliseconds
        """
        return pulumi.get(self, "idle_in_transaction_session_timeout")

    @idle_in_transaction_session_timeout.setter
    def idle_in_transaction_session_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "idle_in_transaction_session_timeout", value)

    @_builtins.property
    @pulumi.getter
    def inherit(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether a role "inherits" the privileges of
        roles it is a member of.  Default value is `true`.
        """
        return pulumi.get(self, "inherit")

    @inherit.setter
    def inherit(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "inherit", value)

    @_builtins.property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether role is allowed to log in.  Roles without
        this attribute are useful for managing database privileges, but are not users
        in the usual sense of the word.  Default value is `false`.
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "login", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the role. Must be unique on the PostgreSQL
        server instance where it is configured.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets the role's password. A password is only of use
        for roles having the `login` attribute set to true.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def replication(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether a role is allowed to initiate
        streaming replication or put the system in and out of backup mode.  Default
        value is `false`
        """
        return pulumi.get(self, "replication")

    @replication.setter
    def replication(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "replication", value)

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Defines list of roles which will be granted to this new role.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "roles", value)

    @_builtins.property
    @pulumi.getter(name="searchPaths")
    def search_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Alters the search path of this new role. Note that
        due to limitations in the implementation, values cannot contain the substring
        `", "`.
        """
        return pulumi.get(self, "search_paths")

    @search_paths.setter
    def search_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "search_paths", value)

    @_builtins.property
    @pulumi.getter(name="skipDropRole")
    def skip_drop_role(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When a PostgreSQL ROLE exists in multiple
        databases and the ROLE is dropped, the
        [cleanup of ownership of objects](https://www.postgresql.org/docs/current/static/role-removal.html)
        in each of the respective databases must occur before the ROLE can be dropped
        from the catalog.  Set this option to true when there are multiple databases
        in a PostgreSQL cluster using the same PostgreSQL ROLE for object ownership.
        This is the third and final step taken when removing a ROLE from a database.
        """
        return pulumi.get(self, "skip_drop_role")

    @skip_drop_role.setter
    def skip_drop_role(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_drop_role", value)

    @_builtins.property
    @pulumi.getter(name="skipReassignOwned")
    def skip_reassign_owned(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When a PostgreSQL ROLE exists in multiple
        databases and the ROLE is dropped, a
        [`REASSIGN OWNED`](https://www.postgresql.org/docs/current/static/sql-reassign-owned.html) in
        must be executed on each of the respective databases before the `DROP ROLE`
        can be executed to dropped the ROLE from the catalog.  This is the first and
        second steps taken when removing a ROLE from a database (the second step being
        an implicit
        [`DROP OWNED`](https://www.postgresql.org/docs/current/static/sql-drop-owned.html)).
        """
        return pulumi.get(self, "skip_reassign_owned")

    @skip_reassign_owned.setter
    def skip_reassign_owned(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_reassign_owned", value)

    @_builtins.property
    @pulumi.getter(name="statementTimeout")
    def statement_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Defines [`statement_timeout`](https://www.postgresql.org/docs/current/runtime-config-client.html#RUNTIME-CONFIG-CLIENT-STATEMENT) setting for this role which allows to abort any statement that takes more than the specified amount of time.
        """
        return pulumi.get(self, "statement_timeout")

    @statement_timeout.setter
    def statement_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "statement_timeout", value)

    @_builtins.property
    @pulumi.getter
    def superuser(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether the role is a "superuser", and
        therefore can override all access restrictions within the database.  Default
        value is `false`.
        """
        return pulumi.get(self, "superuser")

    @superuser.setter
    def superuser(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "superuser", value)

    @_builtins.property
    @pulumi.getter(name="validUntil")
    def valid_until(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the date and time after which the role's
        password is no longer valid.  Established connections past this `valid_time`
        will have to be manually terminated.  This value corresponds to a PostgreSQL
        datetime. If omitted or the magic value `NULL` is used, `valid_until` will be
        set to `infinity`.  Default is `NULL`, therefore `infinity`.
        """
        return pulumi.get(self, "valid_until")

    @valid_until.setter
    def valid_until(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "valid_until", value)


@pulumi.type_token("postgresql:index/role:Role")
class Role(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assume_role: Optional[pulumi.Input[_builtins.str]] = None,
                 bypass_row_level_security: Optional[pulumi.Input[_builtins.bool]] = None,
                 connection_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 create_database: Optional[pulumi.Input[_builtins.bool]] = None,
                 create_role: Optional[pulumi.Input[_builtins.bool]] = None,
                 encrypted: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypted_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 idle_in_transaction_session_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 inherit: Optional[pulumi.Input[_builtins.bool]] = None,
                 login: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 replication: Optional[pulumi.Input[_builtins.bool]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 search_paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 skip_drop_role: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_reassign_owned: Optional[pulumi.Input[_builtins.bool]] = None,
                 statement_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 superuser: Optional[pulumi.Input[_builtins.bool]] = None,
                 valid_until: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a Role resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] assume_role: Defines the role to switch to at login via [`SET ROLE`](https://www.postgresql.org/docs/current/sql-set-role.html).
        :param pulumi.Input[_builtins.bool] bypass_row_level_security: Defines whether a role bypasses every
               row-level security (RLS) policy.  Default value is `false`.
        :param pulumi.Input[_builtins.int] connection_limit: If this role can log in, this specifies how
               many concurrent connections the role can establish. `-1` (the default) means no
               limit.
        :param pulumi.Input[_builtins.bool] create_database: Defines a role's ability to execute `CREATE
               DATABASE`.  Default value is `false`.
        :param pulumi.Input[_builtins.bool] create_role: Defines a role's ability to execute `CREATE ROLE`.
               A role with this privilege can also alter and drop other roles.  Default value
               is `false`.
        :param pulumi.Input[_builtins.bool] encrypted_password: Defines whether the password is stored
               encrypted in the system catalogs.  Default value is `true`.  NOTE: this value
               is always set (to the conservative and safe value), but may interfere with the
               behavior of
               [PostgreSQL's `password_encryption` setting](https://www.postgresql.org/docs/current/static/runtime-config-connection.html#GUC-PASSWORD-ENCRYPTION).
        :param pulumi.Input[_builtins.int] idle_in_transaction_session_timeout: Terminate any session with an open transaction that has been idle for longer than the specified duration in milliseconds
        :param pulumi.Input[_builtins.bool] inherit: Defines whether a role "inherits" the privileges of
               roles it is a member of.  Default value is `true`.
        :param pulumi.Input[_builtins.bool] login: Defines whether role is allowed to log in.  Roles without
               this attribute are useful for managing database privileges, but are not users
               in the usual sense of the word.  Default value is `false`.
        :param pulumi.Input[_builtins.str] name: The name of the role. Must be unique on the PostgreSQL
               server instance where it is configured.
        :param pulumi.Input[_builtins.str] password: Sets the role's password. A password is only of use
               for roles having the `login` attribute set to true.
        :param pulumi.Input[_builtins.bool] replication: Defines whether a role is allowed to initiate
               streaming replication or put the system in and out of backup mode.  Default
               value is `false`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: Defines list of roles which will be granted to this new role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] search_paths: Alters the search path of this new role. Note that
               due to limitations in the implementation, values cannot contain the substring
               `", "`.
        :param pulumi.Input[_builtins.bool] skip_drop_role: When a PostgreSQL ROLE exists in multiple
               databases and the ROLE is dropped, the
               [cleanup of ownership of objects](https://www.postgresql.org/docs/current/static/role-removal.html)
               in each of the respective databases must occur before the ROLE can be dropped
               from the catalog.  Set this option to true when there are multiple databases
               in a PostgreSQL cluster using the same PostgreSQL ROLE for object ownership.
               This is the third and final step taken when removing a ROLE from a database.
        :param pulumi.Input[_builtins.bool] skip_reassign_owned: When a PostgreSQL ROLE exists in multiple
               databases and the ROLE is dropped, a
               [`REASSIGN OWNED`](https://www.postgresql.org/docs/current/static/sql-reassign-owned.html) in
               must be executed on each of the respective databases before the `DROP ROLE`
               can be executed to dropped the ROLE from the catalog.  This is the first and
               second steps taken when removing a ROLE from a database (the second step being
               an implicit
               [`DROP OWNED`](https://www.postgresql.org/docs/current/static/sql-drop-owned.html)).
        :param pulumi.Input[_builtins.int] statement_timeout: Defines [`statement_timeout`](https://www.postgresql.org/docs/current/runtime-config-client.html#RUNTIME-CONFIG-CLIENT-STATEMENT) setting for this role which allows to abort any statement that takes more than the specified amount of time.
        :param pulumi.Input[_builtins.bool] superuser: Defines whether the role is a "superuser", and
               therefore can override all access restrictions within the database.  Default
               value is `false`.
        :param pulumi.Input[_builtins.str] valid_until: Defines the date and time after which the role's
               password is no longer valid.  Established connections past this `valid_time`
               will have to be manually terminated.  This value corresponds to a PostgreSQL
               datetime. If omitted or the magic value `NULL` is used, `valid_until` will be
               set to `infinity`.  Default is `NULL`, therefore `infinity`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RoleArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Role resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param RoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assume_role: Optional[pulumi.Input[_builtins.str]] = None,
                 bypass_row_level_security: Optional[pulumi.Input[_builtins.bool]] = None,
                 connection_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 create_database: Optional[pulumi.Input[_builtins.bool]] = None,
                 create_role: Optional[pulumi.Input[_builtins.bool]] = None,
                 encrypted: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypted_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 idle_in_transaction_session_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 inherit: Optional[pulumi.Input[_builtins.bool]] = None,
                 login: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 replication: Optional[pulumi.Input[_builtins.bool]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 search_paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 skip_drop_role: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_reassign_owned: Optional[pulumi.Input[_builtins.bool]] = None,
                 statement_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 superuser: Optional[pulumi.Input[_builtins.bool]] = None,
                 valid_until: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RoleArgs.__new__(RoleArgs)

            __props__.__dict__["assume_role"] = assume_role
            __props__.__dict__["bypass_row_level_security"] = bypass_row_level_security
            __props__.__dict__["connection_limit"] = connection_limit
            __props__.__dict__["create_database"] = create_database
            __props__.__dict__["create_role"] = create_role
            __props__.__dict__["encrypted"] = encrypted
            __props__.__dict__["encrypted_password"] = encrypted_password
            __props__.__dict__["idle_in_transaction_session_timeout"] = idle_in_transaction_session_timeout
            __props__.__dict__["inherit"] = inherit
            __props__.__dict__["login"] = login
            __props__.__dict__["name"] = name
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["replication"] = replication
            __props__.__dict__["roles"] = roles
            __props__.__dict__["search_paths"] = search_paths
            __props__.__dict__["skip_drop_role"] = skip_drop_role
            __props__.__dict__["skip_reassign_owned"] = skip_reassign_owned
            __props__.__dict__["statement_timeout"] = statement_timeout
            __props__.__dict__["superuser"] = superuser
            __props__.__dict__["valid_until"] = valid_until
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Role, __self__).__init__(
            'postgresql:index/role:Role',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assume_role: Optional[pulumi.Input[_builtins.str]] = None,
            bypass_row_level_security: Optional[pulumi.Input[_builtins.bool]] = None,
            connection_limit: Optional[pulumi.Input[_builtins.int]] = None,
            create_database: Optional[pulumi.Input[_builtins.bool]] = None,
            create_role: Optional[pulumi.Input[_builtins.bool]] = None,
            encrypted: Optional[pulumi.Input[_builtins.str]] = None,
            encrypted_password: Optional[pulumi.Input[_builtins.bool]] = None,
            idle_in_transaction_session_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            inherit: Optional[pulumi.Input[_builtins.bool]] = None,
            login: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            replication: Optional[pulumi.Input[_builtins.bool]] = None,
            roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            search_paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            skip_drop_role: Optional[pulumi.Input[_builtins.bool]] = None,
            skip_reassign_owned: Optional[pulumi.Input[_builtins.bool]] = None,
            statement_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            superuser: Optional[pulumi.Input[_builtins.bool]] = None,
            valid_until: Optional[pulumi.Input[_builtins.str]] = None) -> 'Role':
        """
        Get an existing Role resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] assume_role: Defines the role to switch to at login via [`SET ROLE`](https://www.postgresql.org/docs/current/sql-set-role.html).
        :param pulumi.Input[_builtins.bool] bypass_row_level_security: Defines whether a role bypasses every
               row-level security (RLS) policy.  Default value is `false`.
        :param pulumi.Input[_builtins.int] connection_limit: If this role can log in, this specifies how
               many concurrent connections the role can establish. `-1` (the default) means no
               limit.
        :param pulumi.Input[_builtins.bool] create_database: Defines a role's ability to execute `CREATE
               DATABASE`.  Default value is `false`.
        :param pulumi.Input[_builtins.bool] create_role: Defines a role's ability to execute `CREATE ROLE`.
               A role with this privilege can also alter and drop other roles.  Default value
               is `false`.
        :param pulumi.Input[_builtins.bool] encrypted_password: Defines whether the password is stored
               encrypted in the system catalogs.  Default value is `true`.  NOTE: this value
               is always set (to the conservative and safe value), but may interfere with the
               behavior of
               [PostgreSQL's `password_encryption` setting](https://www.postgresql.org/docs/current/static/runtime-config-connection.html#GUC-PASSWORD-ENCRYPTION).
        :param pulumi.Input[_builtins.int] idle_in_transaction_session_timeout: Terminate any session with an open transaction that has been idle for longer than the specified duration in milliseconds
        :param pulumi.Input[_builtins.bool] inherit: Defines whether a role "inherits" the privileges of
               roles it is a member of.  Default value is `true`.
        :param pulumi.Input[_builtins.bool] login: Defines whether role is allowed to log in.  Roles without
               this attribute are useful for managing database privileges, but are not users
               in the usual sense of the word.  Default value is `false`.
        :param pulumi.Input[_builtins.str] name: The name of the role. Must be unique on the PostgreSQL
               server instance where it is configured.
        :param pulumi.Input[_builtins.str] password: Sets the role's password. A password is only of use
               for roles having the `login` attribute set to true.
        :param pulumi.Input[_builtins.bool] replication: Defines whether a role is allowed to initiate
               streaming replication or put the system in and out of backup mode.  Default
               value is `false`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: Defines list of roles which will be granted to this new role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] search_paths: Alters the search path of this new role. Note that
               due to limitations in the implementation, values cannot contain the substring
               `", "`.
        :param pulumi.Input[_builtins.bool] skip_drop_role: When a PostgreSQL ROLE exists in multiple
               databases and the ROLE is dropped, the
               [cleanup of ownership of objects](https://www.postgresql.org/docs/current/static/role-removal.html)
               in each of the respective databases must occur before the ROLE can be dropped
               from the catalog.  Set this option to true when there are multiple databases
               in a PostgreSQL cluster using the same PostgreSQL ROLE for object ownership.
               This is the third and final step taken when removing a ROLE from a database.
        :param pulumi.Input[_builtins.bool] skip_reassign_owned: When a PostgreSQL ROLE exists in multiple
               databases and the ROLE is dropped, a
               [`REASSIGN OWNED`](https://www.postgresql.org/docs/current/static/sql-reassign-owned.html) in
               must be executed on each of the respective databases before the `DROP ROLE`
               can be executed to dropped the ROLE from the catalog.  This is the first and
               second steps taken when removing a ROLE from a database (the second step being
               an implicit
               [`DROP OWNED`](https://www.postgresql.org/docs/current/static/sql-drop-owned.html)).
        :param pulumi.Input[_builtins.int] statement_timeout: Defines [`statement_timeout`](https://www.postgresql.org/docs/current/runtime-config-client.html#RUNTIME-CONFIG-CLIENT-STATEMENT) setting for this role which allows to abort any statement that takes more than the specified amount of time.
        :param pulumi.Input[_builtins.bool] superuser: Defines whether the role is a "superuser", and
               therefore can override all access restrictions within the database.  Default
               value is `false`.
        :param pulumi.Input[_builtins.str] valid_until: Defines the date and time after which the role's
               password is no longer valid.  Established connections past this `valid_time`
               will have to be manually terminated.  This value corresponds to a PostgreSQL
               datetime. If omitted or the magic value `NULL` is used, `valid_until` will be
               set to `infinity`.  Default is `NULL`, therefore `infinity`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RoleState.__new__(_RoleState)

        __props__.__dict__["assume_role"] = assume_role
        __props__.__dict__["bypass_row_level_security"] = bypass_row_level_security
        __props__.__dict__["connection_limit"] = connection_limit
        __props__.__dict__["create_database"] = create_database
        __props__.__dict__["create_role"] = create_role
        __props__.__dict__["encrypted"] = encrypted
        __props__.__dict__["encrypted_password"] = encrypted_password
        __props__.__dict__["idle_in_transaction_session_timeout"] = idle_in_transaction_session_timeout
        __props__.__dict__["inherit"] = inherit
        __props__.__dict__["login"] = login
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["replication"] = replication
        __props__.__dict__["roles"] = roles
        __props__.__dict__["search_paths"] = search_paths
        __props__.__dict__["skip_drop_role"] = skip_drop_role
        __props__.__dict__["skip_reassign_owned"] = skip_reassign_owned
        __props__.__dict__["statement_timeout"] = statement_timeout
        __props__.__dict__["superuser"] = superuser
        __props__.__dict__["valid_until"] = valid_until
        return Role(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="assumeRole")
    def assume_role(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Defines the role to switch to at login via [`SET ROLE`](https://www.postgresql.org/docs/current/sql-set-role.html).
        """
        return pulumi.get(self, "assume_role")

    @_builtins.property
    @pulumi.getter(name="bypassRowLevelSecurity")
    def bypass_row_level_security(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Defines whether a role bypasses every
        row-level security (RLS) policy.  Default value is `false`.
        """
        return pulumi.get(self, "bypass_row_level_security")

    @_builtins.property
    @pulumi.getter(name="connectionLimit")
    def connection_limit(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        If this role can log in, this specifies how
        many concurrent connections the role can establish. `-1` (the default) means no
        limit.
        """
        return pulumi.get(self, "connection_limit")

    @_builtins.property
    @pulumi.getter(name="createDatabase")
    def create_database(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Defines a role's ability to execute `CREATE
        DATABASE`.  Default value is `false`.
        """
        return pulumi.get(self, "create_database")

    @_builtins.property
    @pulumi.getter(name="createRole")
    def create_role(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Defines a role's ability to execute `CREATE ROLE`.
        A role with this privilege can also alter and drop other roles.  Default value
        is `false`.
        """
        return pulumi.get(self, "create_role")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Rename PostgreSQL role resource attribute \"encrypted\" to \"encrypted_password\"""")
    def encrypted(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "encrypted")

    @_builtins.property
    @pulumi.getter(name="encryptedPassword")
    def encrypted_password(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Defines whether the password is stored
        encrypted in the system catalogs.  Default value is `true`.  NOTE: this value
        is always set (to the conservative and safe value), but may interfere with the
        behavior of
        [PostgreSQL's `password_encryption` setting](https://www.postgresql.org/docs/current/static/runtime-config-connection.html#GUC-PASSWORD-ENCRYPTION).
        """
        return pulumi.get(self, "encrypted_password")

    @_builtins.property
    @pulumi.getter(name="idleInTransactionSessionTimeout")
    def idle_in_transaction_session_timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Terminate any session with an open transaction that has been idle for longer than the specified duration in milliseconds
        """
        return pulumi.get(self, "idle_in_transaction_session_timeout")

    @_builtins.property
    @pulumi.getter
    def inherit(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Defines whether a role "inherits" the privileges of
        roles it is a member of.  Default value is `true`.
        """
        return pulumi.get(self, "inherit")

    @_builtins.property
    @pulumi.getter
    def login(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Defines whether role is allowed to log in.  Roles without
        this attribute are useful for managing database privileges, but are not users
        in the usual sense of the word.  Default value is `false`.
        """
        return pulumi.get(self, "login")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the role. Must be unique on the PostgreSQL
        server instance where it is configured.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Sets the role's password. A password is only of use
        for roles having the `login` attribute set to true.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def replication(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Defines whether a role is allowed to initiate
        streaming replication or put the system in and out of backup mode.  Default
        value is `false`
        """
        return pulumi.get(self, "replication")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Defines list of roles which will be granted to this new role.
        """
        return pulumi.get(self, "roles")

    @_builtins.property
    @pulumi.getter(name="searchPaths")
    def search_paths(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Alters the search path of this new role. Note that
        due to limitations in the implementation, values cannot contain the substring
        `", "`.
        """
        return pulumi.get(self, "search_paths")

    @_builtins.property
    @pulumi.getter(name="skipDropRole")
    def skip_drop_role(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        When a PostgreSQL ROLE exists in multiple
        databases and the ROLE is dropped, the
        [cleanup of ownership of objects](https://www.postgresql.org/docs/current/static/role-removal.html)
        in each of the respective databases must occur before the ROLE can be dropped
        from the catalog.  Set this option to true when there are multiple databases
        in a PostgreSQL cluster using the same PostgreSQL ROLE for object ownership.
        This is the third and final step taken when removing a ROLE from a database.
        """
        return pulumi.get(self, "skip_drop_role")

    @_builtins.property
    @pulumi.getter(name="skipReassignOwned")
    def skip_reassign_owned(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        When a PostgreSQL ROLE exists in multiple
        databases and the ROLE is dropped, a
        [`REASSIGN OWNED`](https://www.postgresql.org/docs/current/static/sql-reassign-owned.html) in
        must be executed on each of the respective databases before the `DROP ROLE`
        can be executed to dropped the ROLE from the catalog.  This is the first and
        second steps taken when removing a ROLE from a database (the second step being
        an implicit
        [`DROP OWNED`](https://www.postgresql.org/docs/current/static/sql-drop-owned.html)).
        """
        return pulumi.get(self, "skip_reassign_owned")

    @_builtins.property
    @pulumi.getter(name="statementTimeout")
    def statement_timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Defines [`statement_timeout`](https://www.postgresql.org/docs/current/runtime-config-client.html#RUNTIME-CONFIG-CLIENT-STATEMENT) setting for this role which allows to abort any statement that takes more than the specified amount of time.
        """
        return pulumi.get(self, "statement_timeout")

    @_builtins.property
    @pulumi.getter
    def superuser(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Defines whether the role is a "superuser", and
        therefore can override all access restrictions within the database.  Default
        value is `false`.
        """
        return pulumi.get(self, "superuser")

    @_builtins.property
    @pulumi.getter(name="validUntil")
    def valid_until(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Defines the date and time after which the role's
        password is no longer valid.  Established connections past this `valid_time`
        will have to be manually terminated.  This value corresponds to a PostgreSQL
        datetime. If omitted or the magic value `NULL` is used, `valid_until` will be
        set to `infinity`.  Default is `NULL`, therefore `infinity`.
        """
        return pulumi.get(self, "valid_until")

