# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetDimensionValuesResult',
    'AwaitableGetDimensionValuesResult',
    'get_dimension_values',
    'get_dimension_values_output',
]

@pulumi.output_type
class GetDimensionValuesResult:
    """
    A collection of values returned by getDimensionValues.
    """
    def __init__(__self__, id=None, limit=None, order_by=None, query=None, values=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if limit and not isinstance(limit, int):
            raise TypeError("Expected argument 'limit' to be a int")
        pulumi.set(__self__, "limit", limit)
        if order_by and not isinstance(order_by, str):
            raise TypeError("Expected argument 'order_by' to be a str")
        pulumi.set(__self__, "order_by", order_by)
        if query and not isinstance(query, str):
            raise TypeError("Expected argument 'query' to be a str")
        pulumi.set(__self__, "query", query)
        if values and not isinstance(values, list):
            raise TypeError("Expected argument 'values' to be a list")
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def limit(self) -> Optional[_builtins.int]:
        """
        This allows you to define how many dimensions are returned as the values output.
        """
        return pulumi.get(self, "limit")

    @_builtins.property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "order_by")

    @_builtins.property
    @pulumi.getter
    def query(self) -> _builtins.str:
        """
        Acepts a query string that allows for defining a key value deintion, wild card matching on values, or where the dimension value exists. Refer to https://dev.splunk.com/observability/reference/api/metrics_metadata/latest#endpoint-retrieve-dimensions-query for more details
        """
        return pulumi.get(self, "query")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        List of all the match dimension values that the provided query, ordered by order_by field
        """
        return pulumi.get(self, "values")


class AwaitableGetDimensionValuesResult(GetDimensionValuesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDimensionValuesResult(
            id=self.id,
            limit=self.limit,
            order_by=self.order_by,
            query=self.query,
            values=self.values)


def get_dimension_values(limit: Optional[_builtins.int] = None,
                         order_by: Optional[_builtins.str] = None,
                         query: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDimensionValuesResult:
    """
    This data sources allows for obtaining a list of dimension values by on query provided.

    ```python
    import pulumi
    import pulumi_signalfx as signalfx
    import pulumi_std as std

    mydashboardgroup0 = signalfx.DashboardGroup("mydashboardgroup0",
        name="My team dashboard group",
        description="Cool dashboard group")
    hosts = signalfx.get_dimension_values(query="key:host")
    host_charts = []
    for range in [{"value": i} for i in range(0, std.index.toset(input=hosts.values).result)]:
        host_charts.append(signalfx.TimeChart(f"host_charts-{range['value']}",
            name=f"CPU Total Idle {range['value']}",
            plot_type="ColumnChart",
            axes_include_zero=True,
            color_by="Metric",
            program_text=f"A = data(\\\\\\"cpu.idle\\\\\\", filter('host', '{range['key']}').publish(label=\\\\\\"CPU\\\\\\")\\n"))
    mydashboard1 = signalfx.Dashboard("mydashboard1",
        name="My Dashboard",
        dashboard_group=mydashboardgroup0.id,
        time_range="-30m",
        grids=[{
            "chart_ids": std.index.toset(input=[v.id for v in host_charts])["result"],
            "width": 3,
            "height": 1,
        }])
    ```


    :param _builtins.int limit: This allows you to define how many dimensions are returned as the values output.
    :param _builtins.str query: Acepts a query string that allows for defining a key value deintion, wild card matching on values, or where the dimension value exists. Refer to https://dev.splunk.com/observability/reference/api/metrics_metadata/latest#endpoint-retrieve-dimensions-query for more details
    """
    __args__ = dict()
    __args__['limit'] = limit
    __args__['orderBy'] = order_by
    __args__['query'] = query
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('signalfx:index/getDimensionValues:getDimensionValues', __args__, opts=opts, typ=GetDimensionValuesResult).value

    return AwaitableGetDimensionValuesResult(
        id=pulumi.get(__ret__, 'id'),
        limit=pulumi.get(__ret__, 'limit'),
        order_by=pulumi.get(__ret__, 'order_by'),
        query=pulumi.get(__ret__, 'query'),
        values=pulumi.get(__ret__, 'values'))
def get_dimension_values_output(limit: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                order_by: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                query: Optional[pulumi.Input[_builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDimensionValuesResult]:
    """
    This data sources allows for obtaining a list of dimension values by on query provided.

    ```python
    import pulumi
    import pulumi_signalfx as signalfx
    import pulumi_std as std

    mydashboardgroup0 = signalfx.DashboardGroup("mydashboardgroup0",
        name="My team dashboard group",
        description="Cool dashboard group")
    hosts = signalfx.get_dimension_values(query="key:host")
    host_charts = []
    for range in [{"value": i} for i in range(0, std.index.toset(input=hosts.values).result)]:
        host_charts.append(signalfx.TimeChart(f"host_charts-{range['value']}",
            name=f"CPU Total Idle {range['value']}",
            plot_type="ColumnChart",
            axes_include_zero=True,
            color_by="Metric",
            program_text=f"A = data(\\\\\\"cpu.idle\\\\\\", filter('host', '{range['key']}').publish(label=\\\\\\"CPU\\\\\\")\\n"))
    mydashboard1 = signalfx.Dashboard("mydashboard1",
        name="My Dashboard",
        dashboard_group=mydashboardgroup0.id,
        time_range="-30m",
        grids=[{
            "chart_ids": std.index.toset(input=[v.id for v in host_charts])["result"],
            "width": 3,
            "height": 1,
        }])
    ```


    :param _builtins.int limit: This allows you to define how many dimensions are returned as the values output.
    :param _builtins.str query: Acepts a query string that allows for defining a key value deintion, wild card matching on values, or where the dimension value exists. Refer to https://dev.splunk.com/observability/reference/api/metrics_metadata/latest#endpoint-retrieve-dimensions-query for more details
    """
    __args__ = dict()
    __args__['limit'] = limit
    __args__['orderBy'] = order_by
    __args__['query'] = query
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('signalfx:index/getDimensionValues:getDimensionValues', __args__, opts=opts, typ=GetDimensionValuesResult)
    return __ret__.apply(lambda __response__: GetDimensionValuesResult(
        id=pulumi.get(__response__, 'id'),
        limit=pulumi.get(__response__, 'limit'),
        order_by=pulumi.get(__response__, 'order_by'),
        query=pulumi.get(__response__, 'query'),
        values=pulumi.get(__response__, 'values')))
