# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ListChartArgs', 'ListChart']

@pulumi.input_type
class ListChartArgs:
    def __init__(__self__, *,
                 program_text: pulumi.Input[_builtins.str],
                 color_by: Optional[pulumi.Input[_builtins.str]] = None,
                 color_scales: Optional[pulumi.Input[Sequence[pulumi.Input['ListChartColorScaleArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_sampling: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_time: Optional[pulumi.Input[_builtins.int]] = None,
                 hide_missing_values: Optional[pulumi.Input[_builtins.bool]] = None,
                 legend_fields_to_hides: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 legend_options_fields: Optional[pulumi.Input[Sequence[pulumi.Input['ListChartLegendOptionsFieldArgs']]]] = None,
                 max_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 max_precision: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 secondary_visualization: Optional[pulumi.Input[_builtins.str]] = None,
                 sort_by: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_range: Optional[pulumi.Input[_builtins.int]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 viz_options: Optional[pulumi.Input[Sequence[pulumi.Input['ListChartVizOptionArgs']]]] = None):
        """
        The set of arguments for constructing a ListChart resource.
        :param pulumi.Input[_builtins.str] program_text: Signalflow program text for the chart. More info[in the Splunk Observability Cloud docs](https://developers.signalfx.com/signalflow_analytics/signalflow_overview.html#_signalflow_programming_language).
        :param pulumi.Input[_builtins.str] color_by: Must be one of `"Scale"`, `"Dimension"` or `"Metric"`. `"Dimension"` by default.
        :param pulumi.Input[Sequence[pulumi.Input['ListChartColorScaleArgs']]] color_scales: Single color range including both the color to display for that range and the borders of the range. Example: `[{ gt = 60, color = "blue" }, { lte = 60, color = "yellow" }]`. Look at this [link](https://docs.splunk.com/observability/en/data-visualization/charts/chart-options.html).
        :param pulumi.Input[_builtins.str] description: Description of the chart.
        :param pulumi.Input[_builtins.bool] disable_sampling: If `false`, samples a subset of the output MTS, which improves UI performance. `false` by default.
        :param pulumi.Input[_builtins.int] end_time: Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        :param pulumi.Input[_builtins.bool] hide_missing_values: Determines whether to hide missing data points in the chart. If `true`, missing data points in the chart would be hidden. `false` by default.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] legend_fields_to_hides: List of properties that should not be displayed in the chart legend (i.e. dimension names). All the properties are visible by default. Deprecated, please use `legend_options_fields`.
        :param pulumi.Input[Sequence[pulumi.Input['ListChartLegendOptionsFieldArgs']]] legend_options_fields: List of property names and enabled flags that should be displayed in the data table for the chart, in the order provided. This option cannot be used with `legend_fields_to_hide`.
        :param pulumi.Input[_builtins.int] max_delay: How long (in seconds) to wait for late datapoints.
        :param pulumi.Input[_builtins.int] max_precision: Maximum number of digits to display when rounding values up or down.
        :param pulumi.Input[_builtins.str] name: Name of the chart.
        :param pulumi.Input[_builtins.int] refresh_interval: How often (in seconds) to refresh the values of the list.
        :param pulumi.Input[_builtins.str] secondary_visualization: The type of secondary visualization. Can be `None`, `Radial`, `Linear`, or `Sparkline`. If unset, the Splunk Observability Cloud default is used (`Sparkline`).
        :param pulumi.Input[_builtins.str] sort_by: The property to use when sorting the elements. Use `value` if you want to sort by value. Must be prepended with `+` for ascending or `-` for descending (e.g. `-foo`). Note there are some special values for some of the options provided in the UX: `"value"` for Value, `"sf_originatingMetric"` for Metric, and `"sf_metric"` for plot.
        :param pulumi.Input[_builtins.int] start_time: Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags associated with the resource
        :param pulumi.Input[_builtins.int] time_range: How many seconds ago from which to display data. For example, the last hour would be `3600`, etc. Conflicts with `start_time` and `end_time`.
        :param pulumi.Input[_builtins.str] timezone: The property value is a string that denotes the geographic region associated with the time zone, (default UTC).
        :param pulumi.Input[_builtins.str] unit_prefix: Must be `"Metric"` or `"Binary`". `"Metric"` by default.
        :param pulumi.Input[Sequence[pulumi.Input['ListChartVizOptionArgs']]] viz_options: Plot-level customization options, associated with a publish statement.
        """
        pulumi.set(__self__, "program_text", program_text)
        if color_by is not None:
            pulumi.set(__self__, "color_by", color_by)
        if color_scales is not None:
            pulumi.set(__self__, "color_scales", color_scales)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_sampling is not None:
            pulumi.set(__self__, "disable_sampling", disable_sampling)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if hide_missing_values is not None:
            pulumi.set(__self__, "hide_missing_values", hide_missing_values)
        if legend_fields_to_hides is not None:
            warnings.warn("""Please use legend_options_fields""", DeprecationWarning)
            pulumi.log.warn("""legend_fields_to_hides is deprecated: Please use legend_options_fields""")
        if legend_fields_to_hides is not None:
            pulumi.set(__self__, "legend_fields_to_hides", legend_fields_to_hides)
        if legend_options_fields is not None:
            pulumi.set(__self__, "legend_options_fields", legend_options_fields)
        if max_delay is not None:
            pulumi.set(__self__, "max_delay", max_delay)
        if max_precision is not None:
            pulumi.set(__self__, "max_precision", max_precision)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if refresh_interval is not None:
            pulumi.set(__self__, "refresh_interval", refresh_interval)
        if secondary_visualization is not None:
            pulumi.set(__self__, "secondary_visualization", secondary_visualization)
        if sort_by is not None:
            pulumi.set(__self__, "sort_by", sort_by)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_range is not None:
            pulumi.set(__self__, "time_range", time_range)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if unit_prefix is not None:
            pulumi.set(__self__, "unit_prefix", unit_prefix)
        if viz_options is not None:
            pulumi.set(__self__, "viz_options", viz_options)

    @_builtins.property
    @pulumi.getter(name="programText")
    def program_text(self) -> pulumi.Input[_builtins.str]:
        """
        Signalflow program text for the chart. More info[in the Splunk Observability Cloud docs](https://developers.signalfx.com/signalflow_analytics/signalflow_overview.html#_signalflow_programming_language).
        """
        return pulumi.get(self, "program_text")

    @program_text.setter
    def program_text(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "program_text", value)

    @_builtins.property
    @pulumi.getter(name="colorBy")
    def color_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Must be one of `"Scale"`, `"Dimension"` or `"Metric"`. `"Dimension"` by default.
        """
        return pulumi.get(self, "color_by")

    @color_by.setter
    def color_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "color_by", value)

    @_builtins.property
    @pulumi.getter(name="colorScales")
    def color_scales(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ListChartColorScaleArgs']]]]:
        """
        Single color range including both the color to display for that range and the borders of the range. Example: `[{ gt = 60, color = "blue" }, { lte = 60, color = "yellow" }]`. Look at this [link](https://docs.splunk.com/observability/en/data-visualization/charts/chart-options.html).
        """
        return pulumi.get(self, "color_scales")

    @color_scales.setter
    def color_scales(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ListChartColorScaleArgs']]]]):
        pulumi.set(self, "color_scales", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the chart.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableSampling")
    def disable_sampling(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `false`, samples a subset of the output MTS, which improves UI performance. `false` by default.
        """
        return pulumi.get(self, "disable_sampling")

    @disable_sampling.setter
    def disable_sampling(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_sampling", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="hideMissingValues")
    def hide_missing_values(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines whether to hide missing data points in the chart. If `true`, missing data points in the chart would be hidden. `false` by default.
        """
        return pulumi.get(self, "hide_missing_values")

    @hide_missing_values.setter
    def hide_missing_values(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hide_missing_values", value)

    @_builtins.property
    @pulumi.getter(name="legendFieldsToHides")
    @_utilities.deprecated("""Please use legend_options_fields""")
    def legend_fields_to_hides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of properties that should not be displayed in the chart legend (i.e. dimension names). All the properties are visible by default. Deprecated, please use `legend_options_fields`.
        """
        return pulumi.get(self, "legend_fields_to_hides")

    @legend_fields_to_hides.setter
    def legend_fields_to_hides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "legend_fields_to_hides", value)

    @_builtins.property
    @pulumi.getter(name="legendOptionsFields")
    def legend_options_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ListChartLegendOptionsFieldArgs']]]]:
        """
        List of property names and enabled flags that should be displayed in the data table for the chart, in the order provided. This option cannot be used with `legend_fields_to_hide`.
        """
        return pulumi.get(self, "legend_options_fields")

    @legend_options_fields.setter
    def legend_options_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ListChartLegendOptionsFieldArgs']]]]):
        pulumi.set(self, "legend_options_fields", value)

    @_builtins.property
    @pulumi.getter(name="maxDelay")
    def max_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How long (in seconds) to wait for late datapoints.
        """
        return pulumi.get(self, "max_delay")

    @max_delay.setter
    def max_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_delay", value)

    @_builtins.property
    @pulumi.getter(name="maxPrecision")
    def max_precision(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of digits to display when rounding values up or down.
        """
        return pulumi.get(self, "max_precision")

    @max_precision.setter
    def max_precision(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_precision", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the chart.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How often (in seconds) to refresh the values of the list.
        """
        return pulumi.get(self, "refresh_interval")

    @refresh_interval.setter
    def refresh_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "refresh_interval", value)

    @_builtins.property
    @pulumi.getter(name="secondaryVisualization")
    def secondary_visualization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of secondary visualization. Can be `None`, `Radial`, `Linear`, or `Sparkline`. If unset, the Splunk Observability Cloud default is used (`Sparkline`).
        """
        return pulumi.get(self, "secondary_visualization")

    @secondary_visualization.setter
    def secondary_visualization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_visualization", value)

    @_builtins.property
    @pulumi.getter(name="sortBy")
    def sort_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The property to use when sorting the elements. Use `value` if you want to sort by value. Must be prepended with `+` for ascending or `-` for descending (e.g. `-foo`). Note there are some special values for some of the options provided in the UX: `"value"` for Value, `"sf_originatingMetric"` for Metric, and `"sf_metric"` for plot.
        """
        return pulumi.get(self, "sort_by")

    @sort_by.setter
    def sort_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sort_by", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags associated with the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="timeRange")
    def time_range(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How many seconds ago from which to display data. For example, the last hour would be `3600`, etc. Conflicts with `start_time` and `end_time`.
        """
        return pulumi.get(self, "time_range")

    @time_range.setter
    def time_range(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "time_range", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The property value is a string that denotes the geographic region associated with the time zone, (default UTC).
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="unitPrefix")
    def unit_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Must be `"Metric"` or `"Binary`". `"Metric"` by default.
        """
        return pulumi.get(self, "unit_prefix")

    @unit_prefix.setter
    def unit_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unit_prefix", value)

    @_builtins.property
    @pulumi.getter(name="vizOptions")
    def viz_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ListChartVizOptionArgs']]]]:
        """
        Plot-level customization options, associated with a publish statement.
        """
        return pulumi.get(self, "viz_options")

    @viz_options.setter
    def viz_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ListChartVizOptionArgs']]]]):
        pulumi.set(self, "viz_options", value)


@pulumi.input_type
class _ListChartState:
    def __init__(__self__, *,
                 color_by: Optional[pulumi.Input[_builtins.str]] = None,
                 color_scales: Optional[pulumi.Input[Sequence[pulumi.Input['ListChartColorScaleArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_sampling: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_time: Optional[pulumi.Input[_builtins.int]] = None,
                 hide_missing_values: Optional[pulumi.Input[_builtins.bool]] = None,
                 legend_fields_to_hides: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 legend_options_fields: Optional[pulumi.Input[Sequence[pulumi.Input['ListChartLegendOptionsFieldArgs']]]] = None,
                 max_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 max_precision: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 program_text: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 secondary_visualization: Optional[pulumi.Input[_builtins.str]] = None,
                 sort_by: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_range: Optional[pulumi.Input[_builtins.int]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 viz_options: Optional[pulumi.Input[Sequence[pulumi.Input['ListChartVizOptionArgs']]]] = None):
        """
        Input properties used for looking up and filtering ListChart resources.
        :param pulumi.Input[_builtins.str] color_by: Must be one of `"Scale"`, `"Dimension"` or `"Metric"`. `"Dimension"` by default.
        :param pulumi.Input[Sequence[pulumi.Input['ListChartColorScaleArgs']]] color_scales: Single color range including both the color to display for that range and the borders of the range. Example: `[{ gt = 60, color = "blue" }, { lte = 60, color = "yellow" }]`. Look at this [link](https://docs.splunk.com/observability/en/data-visualization/charts/chart-options.html).
        :param pulumi.Input[_builtins.str] description: Description of the chart.
        :param pulumi.Input[_builtins.bool] disable_sampling: If `false`, samples a subset of the output MTS, which improves UI performance. `false` by default.
        :param pulumi.Input[_builtins.int] end_time: Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        :param pulumi.Input[_builtins.bool] hide_missing_values: Determines whether to hide missing data points in the chart. If `true`, missing data points in the chart would be hidden. `false` by default.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] legend_fields_to_hides: List of properties that should not be displayed in the chart legend (i.e. dimension names). All the properties are visible by default. Deprecated, please use `legend_options_fields`.
        :param pulumi.Input[Sequence[pulumi.Input['ListChartLegendOptionsFieldArgs']]] legend_options_fields: List of property names and enabled flags that should be displayed in the data table for the chart, in the order provided. This option cannot be used with `legend_fields_to_hide`.
        :param pulumi.Input[_builtins.int] max_delay: How long (in seconds) to wait for late datapoints.
        :param pulumi.Input[_builtins.int] max_precision: Maximum number of digits to display when rounding values up or down.
        :param pulumi.Input[_builtins.str] name: Name of the chart.
        :param pulumi.Input[_builtins.str] program_text: Signalflow program text for the chart. More info[in the Splunk Observability Cloud docs](https://developers.signalfx.com/signalflow_analytics/signalflow_overview.html#_signalflow_programming_language).
        :param pulumi.Input[_builtins.int] refresh_interval: How often (in seconds) to refresh the values of the list.
        :param pulumi.Input[_builtins.str] secondary_visualization: The type of secondary visualization. Can be `None`, `Radial`, `Linear`, or `Sparkline`. If unset, the Splunk Observability Cloud default is used (`Sparkline`).
        :param pulumi.Input[_builtins.str] sort_by: The property to use when sorting the elements. Use `value` if you want to sort by value. Must be prepended with `+` for ascending or `-` for descending (e.g. `-foo`). Note there are some special values for some of the options provided in the UX: `"value"` for Value, `"sf_originatingMetric"` for Metric, and `"sf_metric"` for plot.
        :param pulumi.Input[_builtins.int] start_time: Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags associated with the resource
        :param pulumi.Input[_builtins.int] time_range: How many seconds ago from which to display data. For example, the last hour would be `3600`, etc. Conflicts with `start_time` and `end_time`.
        :param pulumi.Input[_builtins.str] timezone: The property value is a string that denotes the geographic region associated with the time zone, (default UTC).
        :param pulumi.Input[_builtins.str] unit_prefix: Must be `"Metric"` or `"Binary`". `"Metric"` by default.
        :param pulumi.Input[_builtins.str] url: The URL of the chart.
        :param pulumi.Input[Sequence[pulumi.Input['ListChartVizOptionArgs']]] viz_options: Plot-level customization options, associated with a publish statement.
        """
        if color_by is not None:
            pulumi.set(__self__, "color_by", color_by)
        if color_scales is not None:
            pulumi.set(__self__, "color_scales", color_scales)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_sampling is not None:
            pulumi.set(__self__, "disable_sampling", disable_sampling)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if hide_missing_values is not None:
            pulumi.set(__self__, "hide_missing_values", hide_missing_values)
        if legend_fields_to_hides is not None:
            warnings.warn("""Please use legend_options_fields""", DeprecationWarning)
            pulumi.log.warn("""legend_fields_to_hides is deprecated: Please use legend_options_fields""")
        if legend_fields_to_hides is not None:
            pulumi.set(__self__, "legend_fields_to_hides", legend_fields_to_hides)
        if legend_options_fields is not None:
            pulumi.set(__self__, "legend_options_fields", legend_options_fields)
        if max_delay is not None:
            pulumi.set(__self__, "max_delay", max_delay)
        if max_precision is not None:
            pulumi.set(__self__, "max_precision", max_precision)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if program_text is not None:
            pulumi.set(__self__, "program_text", program_text)
        if refresh_interval is not None:
            pulumi.set(__self__, "refresh_interval", refresh_interval)
        if secondary_visualization is not None:
            pulumi.set(__self__, "secondary_visualization", secondary_visualization)
        if sort_by is not None:
            pulumi.set(__self__, "sort_by", sort_by)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_range is not None:
            pulumi.set(__self__, "time_range", time_range)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if unit_prefix is not None:
            pulumi.set(__self__, "unit_prefix", unit_prefix)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if viz_options is not None:
            pulumi.set(__self__, "viz_options", viz_options)

    @_builtins.property
    @pulumi.getter(name="colorBy")
    def color_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Must be one of `"Scale"`, `"Dimension"` or `"Metric"`. `"Dimension"` by default.
        """
        return pulumi.get(self, "color_by")

    @color_by.setter
    def color_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "color_by", value)

    @_builtins.property
    @pulumi.getter(name="colorScales")
    def color_scales(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ListChartColorScaleArgs']]]]:
        """
        Single color range including both the color to display for that range and the borders of the range. Example: `[{ gt = 60, color = "blue" }, { lte = 60, color = "yellow" }]`. Look at this [link](https://docs.splunk.com/observability/en/data-visualization/charts/chart-options.html).
        """
        return pulumi.get(self, "color_scales")

    @color_scales.setter
    def color_scales(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ListChartColorScaleArgs']]]]):
        pulumi.set(self, "color_scales", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the chart.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableSampling")
    def disable_sampling(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `false`, samples a subset of the output MTS, which improves UI performance. `false` by default.
        """
        return pulumi.get(self, "disable_sampling")

    @disable_sampling.setter
    def disable_sampling(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_sampling", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="hideMissingValues")
    def hide_missing_values(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines whether to hide missing data points in the chart. If `true`, missing data points in the chart would be hidden. `false` by default.
        """
        return pulumi.get(self, "hide_missing_values")

    @hide_missing_values.setter
    def hide_missing_values(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hide_missing_values", value)

    @_builtins.property
    @pulumi.getter(name="legendFieldsToHides")
    @_utilities.deprecated("""Please use legend_options_fields""")
    def legend_fields_to_hides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of properties that should not be displayed in the chart legend (i.e. dimension names). All the properties are visible by default. Deprecated, please use `legend_options_fields`.
        """
        return pulumi.get(self, "legend_fields_to_hides")

    @legend_fields_to_hides.setter
    def legend_fields_to_hides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "legend_fields_to_hides", value)

    @_builtins.property
    @pulumi.getter(name="legendOptionsFields")
    def legend_options_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ListChartLegendOptionsFieldArgs']]]]:
        """
        List of property names and enabled flags that should be displayed in the data table for the chart, in the order provided. This option cannot be used with `legend_fields_to_hide`.
        """
        return pulumi.get(self, "legend_options_fields")

    @legend_options_fields.setter
    def legend_options_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ListChartLegendOptionsFieldArgs']]]]):
        pulumi.set(self, "legend_options_fields", value)

    @_builtins.property
    @pulumi.getter(name="maxDelay")
    def max_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How long (in seconds) to wait for late datapoints.
        """
        return pulumi.get(self, "max_delay")

    @max_delay.setter
    def max_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_delay", value)

    @_builtins.property
    @pulumi.getter(name="maxPrecision")
    def max_precision(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of digits to display when rounding values up or down.
        """
        return pulumi.get(self, "max_precision")

    @max_precision.setter
    def max_precision(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_precision", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the chart.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="programText")
    def program_text(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Signalflow program text for the chart. More info[in the Splunk Observability Cloud docs](https://developers.signalfx.com/signalflow_analytics/signalflow_overview.html#_signalflow_programming_language).
        """
        return pulumi.get(self, "program_text")

    @program_text.setter
    def program_text(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "program_text", value)

    @_builtins.property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How often (in seconds) to refresh the values of the list.
        """
        return pulumi.get(self, "refresh_interval")

    @refresh_interval.setter
    def refresh_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "refresh_interval", value)

    @_builtins.property
    @pulumi.getter(name="secondaryVisualization")
    def secondary_visualization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of secondary visualization. Can be `None`, `Radial`, `Linear`, or `Sparkline`. If unset, the Splunk Observability Cloud default is used (`Sparkline`).
        """
        return pulumi.get(self, "secondary_visualization")

    @secondary_visualization.setter
    def secondary_visualization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_visualization", value)

    @_builtins.property
    @pulumi.getter(name="sortBy")
    def sort_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The property to use when sorting the elements. Use `value` if you want to sort by value. Must be prepended with `+` for ascending or `-` for descending (e.g. `-foo`). Note there are some special values for some of the options provided in the UX: `"value"` for Value, `"sf_originatingMetric"` for Metric, and `"sf_metric"` for plot.
        """
        return pulumi.get(self, "sort_by")

    @sort_by.setter
    def sort_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sort_by", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags associated with the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="timeRange")
    def time_range(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How many seconds ago from which to display data. For example, the last hour would be `3600`, etc. Conflicts with `start_time` and `end_time`.
        """
        return pulumi.get(self, "time_range")

    @time_range.setter
    def time_range(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "time_range", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The property value is a string that denotes the geographic region associated with the time zone, (default UTC).
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="unitPrefix")
    def unit_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Must be `"Metric"` or `"Binary`". `"Metric"` by default.
        """
        return pulumi.get(self, "unit_prefix")

    @unit_prefix.setter
    def unit_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unit_prefix", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the chart.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="vizOptions")
    def viz_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ListChartVizOptionArgs']]]]:
        """
        Plot-level customization options, associated with a publish statement.
        """
        return pulumi.get(self, "viz_options")

    @viz_options.setter
    def viz_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ListChartVizOptionArgs']]]]):
        pulumi.set(self, "viz_options", value)


@pulumi.type_token("signalfx:index/listChart:ListChart")
class ListChart(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 color_by: Optional[pulumi.Input[_builtins.str]] = None,
                 color_scales: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListChartColorScaleArgs', 'ListChartColorScaleArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_sampling: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_time: Optional[pulumi.Input[_builtins.int]] = None,
                 hide_missing_values: Optional[pulumi.Input[_builtins.bool]] = None,
                 legend_fields_to_hides: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 legend_options_fields: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListChartLegendOptionsFieldArgs', 'ListChartLegendOptionsFieldArgsDict']]]]] = None,
                 max_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 max_precision: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 program_text: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 secondary_visualization: Optional[pulumi.Input[_builtins.str]] = None,
                 sort_by: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_range: Optional[pulumi.Input[_builtins.int]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 viz_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListChartVizOptionArgs', 'ListChartVizOptionArgsDict']]]]] = None,
                 __props__=None):
        """
        This chart type displays current data values in a list format.

        The name of each value in the chart reflects the name of the plot and any associated dimensions. We recommend you click the Pencil icon and give the plot a meaningful name, as in plot B from the example. Otherwise, just the raw metric name will be displayed on the chart, as in plot A from the example.

        ## Example

        ```python
        import pulumi
        import pulumi_signalfx as signalfx

        mylistchart0 = signalfx.ListChart("mylistchart0",
            name="CPU Total Idle - List",
            program_text=\"\"\"myfilters = filter(\\"cluster_name\\", \\"prod\\") and filter(\\"role\\", \\"search\\")
        data(\\"cpu.total.idle\\", filter=myfilters).publish()
        \"\"\",
            description="Very cool List Chart",
            color_by="Metric",
            max_delay=2,
            timezone="Europe/Paris",
            disable_sampling=True,
            refresh_interval=1,
            hide_missing_values=True,
            legend_options_fields=[
                {
                    "property": "collector",
                    "enabled": False,
                },
                {
                    "property": "cluster_name",
                    "enabled": True,
                },
                {
                    "property": "role",
                    "enabled": True,
                },
                {
                    "property": "collector",
                    "enabled": False,
                },
                {
                    "property": "host",
                    "enabled": False,
                },
            ],
            max_precision=2,
            sort_by="-value")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] color_by: Must be one of `"Scale"`, `"Dimension"` or `"Metric"`. `"Dimension"` by default.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ListChartColorScaleArgs', 'ListChartColorScaleArgsDict']]]] color_scales: Single color range including both the color to display for that range and the borders of the range. Example: `[{ gt = 60, color = "blue" }, { lte = 60, color = "yellow" }]`. Look at this [link](https://docs.splunk.com/observability/en/data-visualization/charts/chart-options.html).
        :param pulumi.Input[_builtins.str] description: Description of the chart.
        :param pulumi.Input[_builtins.bool] disable_sampling: If `false`, samples a subset of the output MTS, which improves UI performance. `false` by default.
        :param pulumi.Input[_builtins.int] end_time: Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        :param pulumi.Input[_builtins.bool] hide_missing_values: Determines whether to hide missing data points in the chart. If `true`, missing data points in the chart would be hidden. `false` by default.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] legend_fields_to_hides: List of properties that should not be displayed in the chart legend (i.e. dimension names). All the properties are visible by default. Deprecated, please use `legend_options_fields`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ListChartLegendOptionsFieldArgs', 'ListChartLegendOptionsFieldArgsDict']]]] legend_options_fields: List of property names and enabled flags that should be displayed in the data table for the chart, in the order provided. This option cannot be used with `legend_fields_to_hide`.
        :param pulumi.Input[_builtins.int] max_delay: How long (in seconds) to wait for late datapoints.
        :param pulumi.Input[_builtins.int] max_precision: Maximum number of digits to display when rounding values up or down.
        :param pulumi.Input[_builtins.str] name: Name of the chart.
        :param pulumi.Input[_builtins.str] program_text: Signalflow program text for the chart. More info[in the Splunk Observability Cloud docs](https://developers.signalfx.com/signalflow_analytics/signalflow_overview.html#_signalflow_programming_language).
        :param pulumi.Input[_builtins.int] refresh_interval: How often (in seconds) to refresh the values of the list.
        :param pulumi.Input[_builtins.str] secondary_visualization: The type of secondary visualization. Can be `None`, `Radial`, `Linear`, or `Sparkline`. If unset, the Splunk Observability Cloud default is used (`Sparkline`).
        :param pulumi.Input[_builtins.str] sort_by: The property to use when sorting the elements. Use `value` if you want to sort by value. Must be prepended with `+` for ascending or `-` for descending (e.g. `-foo`). Note there are some special values for some of the options provided in the UX: `"value"` for Value, `"sf_originatingMetric"` for Metric, and `"sf_metric"` for plot.
        :param pulumi.Input[_builtins.int] start_time: Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags associated with the resource
        :param pulumi.Input[_builtins.int] time_range: How many seconds ago from which to display data. For example, the last hour would be `3600`, etc. Conflicts with `start_time` and `end_time`.
        :param pulumi.Input[_builtins.str] timezone: The property value is a string that denotes the geographic region associated with the time zone, (default UTC).
        :param pulumi.Input[_builtins.str] unit_prefix: Must be `"Metric"` or `"Binary`". `"Metric"` by default.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ListChartVizOptionArgs', 'ListChartVizOptionArgsDict']]]] viz_options: Plot-level customization options, associated with a publish statement.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ListChartArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This chart type displays current data values in a list format.

        The name of each value in the chart reflects the name of the plot and any associated dimensions. We recommend you click the Pencil icon and give the plot a meaningful name, as in plot B from the example. Otherwise, just the raw metric name will be displayed on the chart, as in plot A from the example.

        ## Example

        ```python
        import pulumi
        import pulumi_signalfx as signalfx

        mylistchart0 = signalfx.ListChart("mylistchart0",
            name="CPU Total Idle - List",
            program_text=\"\"\"myfilters = filter(\\"cluster_name\\", \\"prod\\") and filter(\\"role\\", \\"search\\")
        data(\\"cpu.total.idle\\", filter=myfilters).publish()
        \"\"\",
            description="Very cool List Chart",
            color_by="Metric",
            max_delay=2,
            timezone="Europe/Paris",
            disable_sampling=True,
            refresh_interval=1,
            hide_missing_values=True,
            legend_options_fields=[
                {
                    "property": "collector",
                    "enabled": False,
                },
                {
                    "property": "cluster_name",
                    "enabled": True,
                },
                {
                    "property": "role",
                    "enabled": True,
                },
                {
                    "property": "collector",
                    "enabled": False,
                },
                {
                    "property": "host",
                    "enabled": False,
                },
            ],
            max_precision=2,
            sort_by="-value")
        ```

        :param str resource_name: The name of the resource.
        :param ListChartArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ListChartArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 color_by: Optional[pulumi.Input[_builtins.str]] = None,
                 color_scales: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListChartColorScaleArgs', 'ListChartColorScaleArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_sampling: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_time: Optional[pulumi.Input[_builtins.int]] = None,
                 hide_missing_values: Optional[pulumi.Input[_builtins.bool]] = None,
                 legend_fields_to_hides: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 legend_options_fields: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListChartLegendOptionsFieldArgs', 'ListChartLegendOptionsFieldArgsDict']]]]] = None,
                 max_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 max_precision: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 program_text: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 secondary_visualization: Optional[pulumi.Input[_builtins.str]] = None,
                 sort_by: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_range: Optional[pulumi.Input[_builtins.int]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 viz_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListChartVizOptionArgs', 'ListChartVizOptionArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ListChartArgs.__new__(ListChartArgs)

            __props__.__dict__["color_by"] = color_by
            __props__.__dict__["color_scales"] = color_scales
            __props__.__dict__["description"] = description
            __props__.__dict__["disable_sampling"] = disable_sampling
            __props__.__dict__["end_time"] = end_time
            __props__.__dict__["hide_missing_values"] = hide_missing_values
            __props__.__dict__["legend_fields_to_hides"] = legend_fields_to_hides
            __props__.__dict__["legend_options_fields"] = legend_options_fields
            __props__.__dict__["max_delay"] = max_delay
            __props__.__dict__["max_precision"] = max_precision
            __props__.__dict__["name"] = name
            if program_text is None and not opts.urn:
                raise TypeError("Missing required property 'program_text'")
            __props__.__dict__["program_text"] = program_text
            __props__.__dict__["refresh_interval"] = refresh_interval
            __props__.__dict__["secondary_visualization"] = secondary_visualization
            __props__.__dict__["sort_by"] = sort_by
            __props__.__dict__["start_time"] = start_time
            __props__.__dict__["tags"] = tags
            __props__.__dict__["time_range"] = time_range
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["unit_prefix"] = unit_prefix
            __props__.__dict__["viz_options"] = viz_options
            __props__.__dict__["url"] = None
        super(ListChart, __self__).__init__(
            'signalfx:index/listChart:ListChart',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            color_by: Optional[pulumi.Input[_builtins.str]] = None,
            color_scales: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListChartColorScaleArgs', 'ListChartColorScaleArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disable_sampling: Optional[pulumi.Input[_builtins.bool]] = None,
            end_time: Optional[pulumi.Input[_builtins.int]] = None,
            hide_missing_values: Optional[pulumi.Input[_builtins.bool]] = None,
            legend_fields_to_hides: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            legend_options_fields: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListChartLegendOptionsFieldArgs', 'ListChartLegendOptionsFieldArgsDict']]]]] = None,
            max_delay: Optional[pulumi.Input[_builtins.int]] = None,
            max_precision: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            program_text: Optional[pulumi.Input[_builtins.str]] = None,
            refresh_interval: Optional[pulumi.Input[_builtins.int]] = None,
            secondary_visualization: Optional[pulumi.Input[_builtins.str]] = None,
            sort_by: Optional[pulumi.Input[_builtins.str]] = None,
            start_time: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            time_range: Optional[pulumi.Input[_builtins.int]] = None,
            timezone: Optional[pulumi.Input[_builtins.str]] = None,
            unit_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None,
            viz_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListChartVizOptionArgs', 'ListChartVizOptionArgsDict']]]]] = None) -> 'ListChart':
        """
        Get an existing ListChart resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] color_by: Must be one of `"Scale"`, `"Dimension"` or `"Metric"`. `"Dimension"` by default.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ListChartColorScaleArgs', 'ListChartColorScaleArgsDict']]]] color_scales: Single color range including both the color to display for that range and the borders of the range. Example: `[{ gt = 60, color = "blue" }, { lte = 60, color = "yellow" }]`. Look at this [link](https://docs.splunk.com/observability/en/data-visualization/charts/chart-options.html).
        :param pulumi.Input[_builtins.str] description: Description of the chart.
        :param pulumi.Input[_builtins.bool] disable_sampling: If `false`, samples a subset of the output MTS, which improves UI performance. `false` by default.
        :param pulumi.Input[_builtins.int] end_time: Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        :param pulumi.Input[_builtins.bool] hide_missing_values: Determines whether to hide missing data points in the chart. If `true`, missing data points in the chart would be hidden. `false` by default.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] legend_fields_to_hides: List of properties that should not be displayed in the chart legend (i.e. dimension names). All the properties are visible by default. Deprecated, please use `legend_options_fields`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ListChartLegendOptionsFieldArgs', 'ListChartLegendOptionsFieldArgsDict']]]] legend_options_fields: List of property names and enabled flags that should be displayed in the data table for the chart, in the order provided. This option cannot be used with `legend_fields_to_hide`.
        :param pulumi.Input[_builtins.int] max_delay: How long (in seconds) to wait for late datapoints.
        :param pulumi.Input[_builtins.int] max_precision: Maximum number of digits to display when rounding values up or down.
        :param pulumi.Input[_builtins.str] name: Name of the chart.
        :param pulumi.Input[_builtins.str] program_text: Signalflow program text for the chart. More info[in the Splunk Observability Cloud docs](https://developers.signalfx.com/signalflow_analytics/signalflow_overview.html#_signalflow_programming_language).
        :param pulumi.Input[_builtins.int] refresh_interval: How often (in seconds) to refresh the values of the list.
        :param pulumi.Input[_builtins.str] secondary_visualization: The type of secondary visualization. Can be `None`, `Radial`, `Linear`, or `Sparkline`. If unset, the Splunk Observability Cloud default is used (`Sparkline`).
        :param pulumi.Input[_builtins.str] sort_by: The property to use when sorting the elements. Use `value` if you want to sort by value. Must be prepended with `+` for ascending or `-` for descending (e.g. `-foo`). Note there are some special values for some of the options provided in the UX: `"value"` for Value, `"sf_originatingMetric"` for Metric, and `"sf_metric"` for plot.
        :param pulumi.Input[_builtins.int] start_time: Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags associated with the resource
        :param pulumi.Input[_builtins.int] time_range: How many seconds ago from which to display data. For example, the last hour would be `3600`, etc. Conflicts with `start_time` and `end_time`.
        :param pulumi.Input[_builtins.str] timezone: The property value is a string that denotes the geographic region associated with the time zone, (default UTC).
        :param pulumi.Input[_builtins.str] unit_prefix: Must be `"Metric"` or `"Binary`". `"Metric"` by default.
        :param pulumi.Input[_builtins.str] url: The URL of the chart.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ListChartVizOptionArgs', 'ListChartVizOptionArgsDict']]]] viz_options: Plot-level customization options, associated with a publish statement.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ListChartState.__new__(_ListChartState)

        __props__.__dict__["color_by"] = color_by
        __props__.__dict__["color_scales"] = color_scales
        __props__.__dict__["description"] = description
        __props__.__dict__["disable_sampling"] = disable_sampling
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["hide_missing_values"] = hide_missing_values
        __props__.__dict__["legend_fields_to_hides"] = legend_fields_to_hides
        __props__.__dict__["legend_options_fields"] = legend_options_fields
        __props__.__dict__["max_delay"] = max_delay
        __props__.__dict__["max_precision"] = max_precision
        __props__.__dict__["name"] = name
        __props__.__dict__["program_text"] = program_text
        __props__.__dict__["refresh_interval"] = refresh_interval
        __props__.__dict__["secondary_visualization"] = secondary_visualization
        __props__.__dict__["sort_by"] = sort_by
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["tags"] = tags
        __props__.__dict__["time_range"] = time_range
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["unit_prefix"] = unit_prefix
        __props__.__dict__["url"] = url
        __props__.__dict__["viz_options"] = viz_options
        return ListChart(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="colorBy")
    def color_by(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Must be one of `"Scale"`, `"Dimension"` or `"Metric"`. `"Dimension"` by default.
        """
        return pulumi.get(self, "color_by")

    @_builtins.property
    @pulumi.getter(name="colorScales")
    def color_scales(self) -> pulumi.Output[Optional[Sequence['outputs.ListChartColorScale']]]:
        """
        Single color range including both the color to display for that range and the borders of the range. Example: `[{ gt = 60, color = "blue" }, { lte = 60, color = "yellow" }]`. Look at this [link](https://docs.splunk.com/observability/en/data-visualization/charts/chart-options.html).
        """
        return pulumi.get(self, "color_scales")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the chart.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="disableSampling")
    def disable_sampling(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If `false`, samples a subset of the output MTS, which improves UI performance. `false` by default.
        """
        return pulumi.get(self, "disable_sampling")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="hideMissingValues")
    def hide_missing_values(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Determines whether to hide missing data points in the chart. If `true`, missing data points in the chart would be hidden. `false` by default.
        """
        return pulumi.get(self, "hide_missing_values")

    @_builtins.property
    @pulumi.getter(name="legendFieldsToHides")
    @_utilities.deprecated("""Please use legend_options_fields""")
    def legend_fields_to_hides(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of properties that should not be displayed in the chart legend (i.e. dimension names). All the properties are visible by default. Deprecated, please use `legend_options_fields`.
        """
        return pulumi.get(self, "legend_fields_to_hides")

    @_builtins.property
    @pulumi.getter(name="legendOptionsFields")
    def legend_options_fields(self) -> pulumi.Output[Optional[Sequence['outputs.ListChartLegendOptionsField']]]:
        """
        List of property names and enabled flags that should be displayed in the data table for the chart, in the order provided. This option cannot be used with `legend_fields_to_hide`.
        """
        return pulumi.get(self, "legend_options_fields")

    @_builtins.property
    @pulumi.getter(name="maxDelay")
    def max_delay(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        How long (in seconds) to wait for late datapoints.
        """
        return pulumi.get(self, "max_delay")

    @_builtins.property
    @pulumi.getter(name="maxPrecision")
    def max_precision(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Maximum number of digits to display when rounding values up or down.
        """
        return pulumi.get(self, "max_precision")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the chart.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="programText")
    def program_text(self) -> pulumi.Output[_builtins.str]:
        """
        Signalflow program text for the chart. More info[in the Splunk Observability Cloud docs](https://developers.signalfx.com/signalflow_analytics/signalflow_overview.html#_signalflow_programming_language).
        """
        return pulumi.get(self, "program_text")

    @_builtins.property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        How often (in seconds) to refresh the values of the list.
        """
        return pulumi.get(self, "refresh_interval")

    @_builtins.property
    @pulumi.getter(name="secondaryVisualization")
    def secondary_visualization(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of secondary visualization. Can be `None`, `Radial`, `Linear`, or `Sparkline`. If unset, the Splunk Observability Cloud default is used (`Sparkline`).
        """
        return pulumi.get(self, "secondary_visualization")

    @_builtins.property
    @pulumi.getter(name="sortBy")
    def sort_by(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The property to use when sorting the elements. Use `value` if you want to sort by value. Must be prepended with `+` for ascending or `-` for descending (e.g. `-foo`). Note there are some special values for some of the options provided in the UX: `"value"` for Value, `"sf_originatingMetric"` for Metric, and `"sf_metric"` for plot.
        """
        return pulumi.get(self, "sort_by")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Seconds since epoch. Used for visualization. Conflicts with `time_range`.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags associated with the resource
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="timeRange")
    def time_range(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        How many seconds ago from which to display data. For example, the last hour would be `3600`, etc. Conflicts with `start_time` and `end_time`.
        """
        return pulumi.get(self, "time_range")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The property value is a string that denotes the geographic region associated with the time zone, (default UTC).
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter(name="unitPrefix")
    def unit_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Must be `"Metric"` or `"Binary`". `"Metric"` by default.
        """
        return pulumi.get(self, "unit_prefix")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL of the chart.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="vizOptions")
    def viz_options(self) -> pulumi.Output[Optional[Sequence['outputs.ListChartVizOption']]]:
        """
        Plot-level customization options, associated with a publish statement.
        """
        return pulumi.get(self, "viz_options")

