# coding: utf-8

"""
    Seeq REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 66.75.3-v202511200104-CD
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import sys
import os
import re

from deprecated import deprecated
# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
from ..models import *

class FoldersApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def archive_folder(self, **kwargs):
        """
        Archive a folder and all of its content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.archive_folder(folder_id=folder_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str folder_id: ID of the folder to archive (required)
        :return: ArchiveOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ArchiveOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.archive_folder_with_http_info(**kwargs)
        else:
            (data) = self.archive_folder_with_http_info(**kwargs)
            return data

    def archive_folder_with_http_info(self, **kwargs):
        """
        Archive a folder and all of its content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.archive_folder_with_http_info(folder_id=folder_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str folder_id: ID of the folder to archive (required)
        :return: ArchiveOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ArchiveOutputV1
        """

        all_params = ['folder_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method archive_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'folder_id' is set
        if ('folder_id' not in params) or (params['folder_id'] is None):
            raise ValueError("Missing the required parameter `folder_id` when calling `archive_folder`")


        collection_formats = {}

        path_params = {}
        if 'folder_id' in params:
            path_params['folderId'] = params['folder_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/folders/{folderId}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ArchiveOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_folder(self, **kwargs):
        """
        Create a folder
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_folder(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FolderInputV1 body: Folder information (required)
        :return: FolderOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FolderOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_folder_with_http_info(**kwargs)
        else:
            (data) = self.create_folder_with_http_info(**kwargs)
            return data

    def create_folder_with_http_info(self, **kwargs):
        """
        Create a folder
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_folder_with_http_info(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FolderInputV1 body: Folder information (required)
        :return: FolderOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FolderOutputV1
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_folder`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/folders', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'FolderOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_ancestors(self, **kwargs):
        """
        Get navigation context for a folder. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_ancestors(folder_id=folder_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str folder_id: ID of the folder to retrieve. (required)
        :param str root: What sharing category results should be returned for
        :return: FolderNavigationOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FolderNavigationOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_ancestors_with_http_info(**kwargs)
        else:
            (data) = self.get_ancestors_with_http_info(**kwargs)
            return data

    def get_ancestors_with_http_info(self, **kwargs):
        """
        Get navigation context for a folder. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_ancestors_with_http_info(folder_id=folder_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str folder_id: ID of the folder to retrieve. (required)
        :param str root: What sharing category results should be returned for
        :return: FolderNavigationOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FolderNavigationOutputV1
        """

        all_params = ['folder_id', 'root']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ancestors" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'folder_id' is set
        if ('folder_id' not in params) or (params['folder_id'] is None):
            raise ValueError("Missing the required parameter `folder_id` when calling `get_ancestors`")


        collection_formats = {}

        path_params = {}
        if 'folder_id' in params:
            path_params['folderId'] = params['folder_id']

        query_params = []
        if 'root' in params:
            query_params.append(('root', params['root']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/folders/{folderId}/ancestors', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'FolderNavigationOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_folder(self, **kwargs):
        """
        Get information about a folder
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_folder(folder_id=folder_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str folder_id: ID of the folder to retrieve. Special values: 'mine' for the authenticated user's Home folder; 'corporate' for the Corporate folder; 'externallyShared' for the Externally Shared folder; 'users' (admins only) for the folder that contains the home folders of all users. (required)
        :param bool full_ancestry: If true, the full ancestry  will be returned, which includes the home folder of the relevant user. Otherwise, the home folder is not returned. Requires admin privileges.
        :return: FolderOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FolderOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_folder_with_http_info(**kwargs)
        else:
            (data) = self.get_folder_with_http_info(**kwargs)
            return data

    def get_folder_with_http_info(self, **kwargs):
        """
        Get information about a folder
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_folder_with_http_info(folder_id=folder_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str folder_id: ID of the folder to retrieve. Special values: 'mine' for the authenticated user's Home folder; 'corporate' for the Corporate folder; 'externallyShared' for the Externally Shared folder; 'users' (admins only) for the folder that contains the home folders of all users. (required)
        :param bool full_ancestry: If true, the full ancestry  will be returned, which includes the home folder of the relevant user. Otherwise, the home folder is not returned. Requires admin privileges.
        :return: FolderOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FolderOutputV1
        """

        all_params = ['folder_id', 'full_ancestry']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'folder_id' is set
        if ('folder_id' not in params) or (params['folder_id'] is None):
            raise ValueError("Missing the required parameter `folder_id` when calling `get_folder`")


        collection_formats = {}

        path_params = {}
        if 'folder_id' in params:
            path_params['folderId'] = params['folder_id']

        query_params = []
        if 'full_ancestry' in params:
            query_params.append(('fullAncestry', params['full_ancestry']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/folders/{folderId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'FolderOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_folders(self, **kwargs):
        """
        Get all root folders and workbooks, or folder content if a parent folder id is specified.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_folders(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str filter: If set to 'mine' or 'owner', only workbench items under the current user's home folder will be returned. If set to 'public' only workbench items shared with the Everyone group will be returned, excluding items under the corporate folder. If set to 'sharedOrPublic' only workbench items shared with the current user or a group they belong to are returned, excluding items under the corporate folder. If set to 'sharedDirectlyWithMe' only workbench items directly shared with the current user will be returned, excluding items under the corporate folder and items shared with groups the user belongs to. If set to 'shared' only workbench items shared with the current user or a group they belong to (except the Everyone group) are returned, excluding items under the corporate folder. If set to 'corporate', only workbench items under the corporate folder are returned. If set to 'users', only items under other user's home folders are returned. If set to 'all' (or not specified), all workbench items the current user has access to will be returned.
        :param str user_id: The user ID to return folders for, defaults to the current user if not specified. Only an admin user is allowed to specify a user ID.
        :param bool is_archived: When true, returns only archived workbench items.
        :param str sort_order: A field by which to order the folders followed by a space and 'asc' or 'desc'. Field name can be one of: createdAt, updatedAt, name, owner
        :param int offset: The pagination offset, the index of the first collection item that will be returned in this page of results
        :param int limit: The pagination limit, the total number of collection items that will be returned in this page of results
        :param bool only_pinned: When true, returns only pinned workbench items are returned. The given folderId is not applied.
        :param str folder_id: The folder to return the content of. If not specified, only root folders are returned unless filtering to specific IDs, filtering to pinned or archived items, sorting by last opened timestamp, or a text search is provided.
        :param list[str] ids: The IDs of items to return.
        :param list[str] types: The types of items to return.
        :param str text_search: Search text by which to filter items' names.
        :param bool is_exact: If true, uses the exact query terms supplied by the user instead of stemming the query to its root words
        :param str root: The highest ancestor that items should have, if possible
        :param list[str] search_fields: Search by name, description, or document body.  Searches name by default when no field is supplied
        :param list[str] creator_ids: List of creator IDs to filter on
        :param list[str] owner_ids: List of owner IDs to filter on
        :param list[str] locations: List of locations to search under, may be 'mine', 'others', or 'corporate'. 'mine' searches all items under the current user's home folder. 'others' searches items under home folders belonging to all users other than the current user. 'corporate' searches the corporate folder, if enabled. Values may be used together. No values searches all locations.
        :param list[str] access_statuses: List of access statuses to search by, may be 'public', 'groups', or 'directly'. 'public' searches items shared with the Everyone group, if enabled. 'groups' searches items shared with groups the current user belongs to. 'directly' searches items directly accessible by the current user. No values searches all access statuses.
        :return: WorkbenchItemOutputListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorkbenchItemOutputListV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_folders_with_http_info(**kwargs)
        else:
            (data) = self.get_folders_with_http_info(**kwargs)
            return data

    def get_folders_with_http_info(self, **kwargs):
        """
        Get all root folders and workbooks, or folder content if a parent folder id is specified.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_folders_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str filter: If set to 'mine' or 'owner', only workbench items under the current user's home folder will be returned. If set to 'public' only workbench items shared with the Everyone group will be returned, excluding items under the corporate folder. If set to 'sharedOrPublic' only workbench items shared with the current user or a group they belong to are returned, excluding items under the corporate folder. If set to 'sharedDirectlyWithMe' only workbench items directly shared with the current user will be returned, excluding items under the corporate folder and items shared with groups the user belongs to. If set to 'shared' only workbench items shared with the current user or a group they belong to (except the Everyone group) are returned, excluding items under the corporate folder. If set to 'corporate', only workbench items under the corporate folder are returned. If set to 'users', only items under other user's home folders are returned. If set to 'all' (or not specified), all workbench items the current user has access to will be returned.
        :param str user_id: The user ID to return folders for, defaults to the current user if not specified. Only an admin user is allowed to specify a user ID.
        :param bool is_archived: When true, returns only archived workbench items.
        :param str sort_order: A field by which to order the folders followed by a space and 'asc' or 'desc'. Field name can be one of: createdAt, updatedAt, name, owner
        :param int offset: The pagination offset, the index of the first collection item that will be returned in this page of results
        :param int limit: The pagination limit, the total number of collection items that will be returned in this page of results
        :param bool only_pinned: When true, returns only pinned workbench items are returned. The given folderId is not applied.
        :param str folder_id: The folder to return the content of. If not specified, only root folders are returned unless filtering to specific IDs, filtering to pinned or archived items, sorting by last opened timestamp, or a text search is provided.
        :param list[str] ids: The IDs of items to return.
        :param list[str] types: The types of items to return.
        :param str text_search: Search text by which to filter items' names.
        :param bool is_exact: If true, uses the exact query terms supplied by the user instead of stemming the query to its root words
        :param str root: The highest ancestor that items should have, if possible
        :param list[str] search_fields: Search by name, description, or document body.  Searches name by default when no field is supplied
        :param list[str] creator_ids: List of creator IDs to filter on
        :param list[str] owner_ids: List of owner IDs to filter on
        :param list[str] locations: List of locations to search under, may be 'mine', 'others', or 'corporate'. 'mine' searches all items under the current user's home folder. 'others' searches items under home folders belonging to all users other than the current user. 'corporate' searches the corporate folder, if enabled. Values may be used together. No values searches all locations.
        :param list[str] access_statuses: List of access statuses to search by, may be 'public', 'groups', or 'directly'. 'public' searches items shared with the Everyone group, if enabled. 'groups' searches items shared with groups the current user belongs to. 'directly' searches items directly accessible by the current user. No values searches all access statuses.
        :return: WorkbenchItemOutputListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorkbenchItemOutputListV1
        """

        all_params = ['filter', 'user_id', 'is_archived', 'sort_order', 'offset', 'limit', 'only_pinned', 'folder_id', 'ids', 'types', 'text_search', 'is_exact', 'root', 'search_fields', 'creator_ids', 'owner_ids', 'locations', 'access_statuses']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_folders" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('filter', params['filter']))
        if 'user_id' in params:
            query_params.append(('userId', params['user_id']))
        if 'is_archived' in params:
            query_params.append(('isArchived', params['is_archived']))
        if 'sort_order' in params:
            query_params.append(('sortOrder', params['sort_order']))
        if 'offset' in params:
            query_params.append(('offset', params['offset']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'only_pinned' in params:
            query_params.append(('onlyPinned', params['only_pinned']))
        if 'folder_id' in params:
            query_params.append(('folderId', params['folder_id']))
        if 'ids' in params:
            query_params.append(('ids', params['ids']))
            collection_formats['ids'] = 'multi'
        if 'types' in params:
            query_params.append(('types', params['types']))
            collection_formats['types'] = 'multi'
        if 'text_search' in params:
            query_params.append(('textSearch', params['text_search']))
        if 'is_exact' in params:
            query_params.append(('isExact', params['is_exact']))
        if 'root' in params:
            query_params.append(('root', params['root']))
        if 'search_fields' in params:
            query_params.append(('searchFields', params['search_fields']))
            collection_formats['searchFields'] = 'multi'
        if 'creator_ids' in params:
            query_params.append(('creatorIds', params['creator_ids']))
            collection_formats['creatorIds'] = 'multi'
        if 'owner_ids' in params:
            query_params.append(('ownerIds', params['owner_ids']))
            collection_formats['ownerIds'] = 'multi'
        if 'locations' in params:
            query_params.append(('locations', params['locations']))
            collection_formats['locations'] = 'multi'
        if 'access_statuses' in params:
            query_params.append(('accessStatuses', params['access_statuses']))
            collection_formats['accessStatuses'] = 'multi'

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/folders', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'WorkbenchItemOutputListV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_subfolders(self, **kwargs):
        """
        Get subfolders of a folder. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_subfolders(folder_id=folder_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str folder_id: ID of the folder to retrieve. Special values of 'mine', 'corporate', 'sharedOrPublic', 'externallyShared', or 'users' can be used to fetch the top level categories. (required)
        :param str root: What sharing category results should be returned for
        :return: FolderNavigationOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FolderNavigationOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_subfolders_with_http_info(**kwargs)
        else:
            (data) = self.get_subfolders_with_http_info(**kwargs)
            return data

    def get_subfolders_with_http_info(self, **kwargs):
        """
        Get subfolders of a folder. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_subfolders_with_http_info(folder_id=folder_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str folder_id: ID of the folder to retrieve. Special values of 'mine', 'corporate', 'sharedOrPublic', 'externallyShared', or 'users' can be used to fetch the top level categories. (required)
        :param str root: What sharing category results should be returned for
        :return: FolderNavigationOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FolderNavigationOutputV1
        """

        all_params = ['folder_id', 'root']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_subfolders" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'folder_id' is set
        if ('folder_id' not in params) or (params['folder_id'] is None):
            raise ValueError("Missing the required parameter `folder_id` when calling `get_subfolders`")


        collection_formats = {}

        path_params = {}
        if 'folder_id' in params:
            path_params['folderId'] = params['folder_id']

        query_params = []
        if 'root' in params:
            query_params.append(('root', params['root']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/folders/{folderId}/subfolders', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'FolderNavigationOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def move_item_to_folder(self, **kwargs):
        """
        Move specified item to specified folder
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.move_item_to_folder(folder_id=folder_id_value, item_id=item_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str folder_id: ID of folder to move item to. Special values of 'mine' or 'corporate' move the item to the authenticated user's home folder or the corporate folder, respectively. (required)
        :param str item_id: ID of item to move to folder (required)
        :return: FolderOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FolderOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.move_item_to_folder_with_http_info(**kwargs)
        else:
            (data) = self.move_item_to_folder_with_http_info(**kwargs)
            return data

    def move_item_to_folder_with_http_info(self, **kwargs):
        """
        Move specified item to specified folder
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.move_item_to_folder_with_http_info(folder_id=folder_id_value, item_id=item_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str folder_id: ID of folder to move item to. Special values of 'mine' or 'corporate' move the item to the authenticated user's home folder or the corporate folder, respectively. (required)
        :param str item_id: ID of item to move to folder (required)
        :return: FolderOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FolderOutputV1
        """

        all_params = ['folder_id', 'item_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method move_item_to_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'folder_id' is set
        if ('folder_id' not in params) or (params['folder_id'] is None):
            raise ValueError("Missing the required parameter `folder_id` when calling `move_item_to_folder`")
        # verify the required parameter 'item_id' is set
        if ('item_id' not in params) or (params['item_id'] is None):
            raise ValueError("Missing the required parameter `item_id` when calling `move_item_to_folder`")


        collection_formats = {}

        path_params = {}
        if 'folder_id' in params:
            path_params['folderId'] = params['folder_id']
        if 'item_id' in params:
            path_params['itemId'] = params['item_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/folders/{folderId}/{itemId}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'FolderOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def remove_item_from_folder(self, **kwargs):
        """
        Remove specified item from specified folder. The item will be moved to the root level.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_item_from_folder(folder_id=folder_id_value, item_id=item_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str folder_id: ID of folder to remove item from (required)
        :param str item_id: ID of item to remove from folder (required)
        :return: FolderOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FolderOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.remove_item_from_folder_with_http_info(**kwargs)
        else:
            (data) = self.remove_item_from_folder_with_http_info(**kwargs)
            return data

    def remove_item_from_folder_with_http_info(self, **kwargs):
        """
        Remove specified item from specified folder. The item will be moved to the root level.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_item_from_folder_with_http_info(folder_id=folder_id_value, item_id=item_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str folder_id: ID of folder to remove item from (required)
        :param str item_id: ID of item to remove from folder (required)
        :return: FolderOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FolderOutputV1
        """

        all_params = ['folder_id', 'item_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_item_from_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'folder_id' is set
        if ('folder_id' not in params) or (params['folder_id'] is None):
            raise ValueError("Missing the required parameter `folder_id` when calling `remove_item_from_folder`")
        # verify the required parameter 'item_id' is set
        if ('item_id' not in params) or (params['item_id'] is None):
            raise ValueError("Missing the required parameter `item_id` when calling `remove_item_from_folder`")


        collection_formats = {}

        path_params = {}
        if 'folder_id' in params:
            path_params['folderId'] = params['folder_id']
        if 'item_id' in params:
            path_params['itemId'] = params['item_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/folders/{folderId}/{itemId}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'FolderOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
