# coding: utf-8

"""
    Seeq REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 66.75.3-v202511200104-CD
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import sys
import os
import re

from deprecated import deprecated
# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
from ..models import *

class SignalsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def add_samples(self, **kwargs):
        """
        Save samples to a signal
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_samples(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SamplesInputV1 body: Data to be added to the signal (required)
        :param str id: The Seeq ID for the signal (required)
        :return: SamplesOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SamplesOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_samples_with_http_info(**kwargs)
        else:
            (data) = self.add_samples_with_http_info(**kwargs)
            return data

    def add_samples_with_http_info(self, **kwargs):
        """
        Save samples to a signal
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_samples_with_http_info(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SamplesInputV1 body: Data to be added to the signal (required)
        :param str id: The Seeq ID for the signal (required)
        :return: SamplesOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SamplesOutputV1
        """

        all_params = ['body', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_samples" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_samples`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `add_samples`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/signals/{id}/samples', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'SamplesOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def add_samples_by_data_id(self, **kwargs):
        """
        Save samples to a signal, using the source system's identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_samples_by_data_id(body=body_value, datasource_class=datasource_class_value, datasource_id=datasource_id_value, data_id=data_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SamplesInputV1 body: Data to be added to the signal (required)
        :param str datasource_class: The class of the datasource containing the signal (required)
        :param str datasource_id: The ID of the datasource containing the signal (required)
        :param str data_id: The Data ID for the signal (required)
        :return: SamplesOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SamplesOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_samples_by_data_id_with_http_info(**kwargs)
        else:
            (data) = self.add_samples_by_data_id_with_http_info(**kwargs)
            return data

    def add_samples_by_data_id_with_http_info(self, **kwargs):
        """
        Save samples to a signal, using the source system's identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_samples_by_data_id_with_http_info(body=body_value, datasource_class=datasource_class_value, datasource_id=datasource_id_value, data_id=data_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SamplesInputV1 body: Data to be added to the signal (required)
        :param str datasource_class: The class of the datasource containing the signal (required)
        :param str datasource_id: The ID of the datasource containing the signal (required)
        :param str data_id: The Data ID for the signal (required)
        :return: SamplesOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SamplesOutputV1
        """

        all_params = ['body', 'datasource_class', 'datasource_id', 'data_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_samples_by_data_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_samples_by_data_id`")
        # verify the required parameter 'datasource_class' is set
        if ('datasource_class' not in params) or (params['datasource_class'] is None):
            raise ValueError("Missing the required parameter `datasource_class` when calling `add_samples_by_data_id`")
        # verify the required parameter 'datasource_id' is set
        if ('datasource_id' not in params) or (params['datasource_id'] is None):
            raise ValueError("Missing the required parameter `datasource_id` when calling `add_samples_by_data_id`")
        # verify the required parameter 'data_id' is set
        if ('data_id' not in params) or (params['data_id'] is None):
            raise ValueError("Missing the required parameter `data_id` when calling `add_samples_by_data_id`")


        collection_formats = {}

        path_params = {}
        if 'datasource_class' in params:
            path_params['datasourceClass'] = params['datasource_class']
        if 'datasource_id' in params:
            path_params['datasourceId'] = params['datasource_id']
        if 'data_id' in params:
            path_params['dataId'] = params['data_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/signals/{datasourceClass}/{datasourceId}/{dataId}/samples', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'SamplesOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def archive_signal(self, **kwargs):
        """
        Archive a signal
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.archive_signal(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The Seeq ID for the signal (required)
        :return: ArchiveOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ArchiveOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.archive_signal_with_http_info(**kwargs)
        else:
            (data) = self.archive_signal_with_http_info(**kwargs)
            return data

    def archive_signal_with_http_info(self, **kwargs):
        """
        Archive a signal
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.archive_signal_with_http_info(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The Seeq ID for the signal (required)
        :return: ArchiveOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ArchiveOutputV1
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method archive_signal" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `archive_signal`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/signals/{id}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ArchiveOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def archive_signal_by_data_id(self, **kwargs):
        """
        Archive a signal, using the source system's identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.archive_signal_by_data_id(datasource_class=datasource_class_value, datasource_id=datasource_id_value, data_id=data_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datasource_class: The class of the datasource containing the signal (required)
        :param str datasource_id: The ID of the datasource containing the signal (required)
        :param str data_id: The Data ID for the signal (required)
        :return: ArchiveOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ArchiveOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.archive_signal_by_data_id_with_http_info(**kwargs)
        else:
            (data) = self.archive_signal_by_data_id_with_http_info(**kwargs)
            return data

    def archive_signal_by_data_id_with_http_info(self, **kwargs):
        """
        Archive a signal, using the source system's identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.archive_signal_by_data_id_with_http_info(datasource_class=datasource_class_value, datasource_id=datasource_id_value, data_id=data_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datasource_class: The class of the datasource containing the signal (required)
        :param str datasource_id: The ID of the datasource containing the signal (required)
        :param str data_id: The Data ID for the signal (required)
        :return: ArchiveOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ArchiveOutputV1
        """

        all_params = ['datasource_class', 'datasource_id', 'data_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method archive_signal_by_data_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'datasource_class' is set
        if ('datasource_class' not in params) or (params['datasource_class'] is None):
            raise ValueError("Missing the required parameter `datasource_class` when calling `archive_signal_by_data_id`")
        # verify the required parameter 'datasource_id' is set
        if ('datasource_id' not in params) or (params['datasource_id'] is None):
            raise ValueError("Missing the required parameter `datasource_id` when calling `archive_signal_by_data_id`")
        # verify the required parameter 'data_id' is set
        if ('data_id' not in params) or (params['data_id'] is None):
            raise ValueError("Missing the required parameter `data_id` when calling `archive_signal_by_data_id`")


        collection_formats = {}

        path_params = {}
        if 'datasource_class' in params:
            path_params['datasourceClass'] = params['datasource_class']
        if 'datasource_id' in params:
            path_params['datasourceId'] = params['datasource_id']
        if 'data_id' in params:
            path_params['dataId'] = params['data_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/signals/{datasourceClass}/{datasourceId}/{dataId}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ArchiveOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_signal(self, **kwargs):
        """
        Create a new signal, to be stored in Seeq
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_signal(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SignalInputV1 body: (required)
        :return: SignalOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SignalOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_signal_with_http_info(**kwargs)
        else:
            (data) = self.create_signal_with_http_info(**kwargs)
            return data

    def create_signal_with_http_info(self, **kwargs):
        """
        Create a new signal, to be stored in Seeq
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_signal_with_http_info(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SignalInputV1 body: (required)
        :return: SignalOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SignalOutputV1
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_signal" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_signal`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/signals', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'SignalOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_samples(self, **kwargs):
        """
        Delete all samples in a signal
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_samples(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The Seeq ID for the signal (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_samples_with_http_info(**kwargs)
        else:
            (data) = self.delete_samples_with_http_info(**kwargs)
            return data

    def delete_samples_with_http_info(self, **kwargs):
        """
        Delete all samples in a signal
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_samples_with_http_info(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The Seeq ID for the signal (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_samples" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_samples`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/signals/{id}/samples', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'StatusMessageBase'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_sample(self, **kwargs):
        """
        Get a sample from a signal
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_sample(id=id_value, key=key_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The Seeq ID for the signal (required)
        :param str key: The key in the signal where the sample should be retrieved (required)
        :param str lookup: Where to look for a sample relative to the specified key. The options are Interpolate, Before, AtOrBefore, At, AtOrAfter, After
        :param str key_unit_of_measure: Units to use for the key of each sample. The default does no unit conversion. For time-series, the default is ISO 8601 timestamps, e.g. '2016-01-01T19:51:32.490Z'.
        :param str value_unit_of_measure: Units to use for the value of each sample. The default does no unit conversion.
        :return: GetSampleOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetSampleOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_sample_with_http_info(**kwargs)
        else:
            (data) = self.get_sample_with_http_info(**kwargs)
            return data

    def get_sample_with_http_info(self, **kwargs):
        """
        Get a sample from a signal
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_sample_with_http_info(id=id_value, key=key_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The Seeq ID for the signal (required)
        :param str key: The key in the signal where the sample should be retrieved (required)
        :param str lookup: Where to look for a sample relative to the specified key. The options are Interpolate, Before, AtOrBefore, At, AtOrAfter, After
        :param str key_unit_of_measure: Units to use for the key of each sample. The default does no unit conversion. For time-series, the default is ISO 8601 timestamps, e.g. '2016-01-01T19:51:32.490Z'.
        :param str value_unit_of_measure: Units to use for the value of each sample. The default does no unit conversion.
        :return: GetSampleOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetSampleOutputV1
        """

        all_params = ['id', 'key', 'lookup', 'key_unit_of_measure', 'value_unit_of_measure']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sample" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_sample`")
        # verify the required parameter 'key' is set
        if ('key' not in params) or (params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `get_sample`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']
        if 'key' in params:
            path_params['key'] = params['key']

        query_params = []
        if 'lookup' in params:
            query_params.append(('lookup', params['lookup']))
        if 'key_unit_of_measure' in params:
            query_params.append(('keyUnitOfMeasure', params['key_unit_of_measure']))
        if 'value_unit_of_measure' in params:
            query_params.append(('valueUnitOfMeasure', params['value_unit_of_measure']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/signals/{id}/sample/{key}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'GetSampleOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_sample_by_data_id(self, **kwargs):
        """
        Get a sample from a signal, using the source system's identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_sample_by_data_id(datasource_class=datasource_class_value, datasource_id=datasource_id_value, data_id=data_id_value, key=key_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datasource_class: The class of the datasource containing the signal (required)
        :param str datasource_id: The ID of the datasource containing the signal (required)
        :param str data_id: The Data ID for the signal (required)
        :param str key: The key in the signal where the sample should be retrieved (required)
        :param str lookup: Where to look for a sample relative to the specified key. The options are Interpolate, Before, AtOrBefore, At, AtOrAfter, After
        :param str key_unit_of_measure: Units to use for the key of each sample. The default does no unit conversion. For time-series, the default is ISO 8601 timestamps, e.g. '2016-01-01T19:51:32.490Z'.
        :param str value_unit_of_measure: Units to use for the value of each sample. The default does no unit conversion.
        :return: GetSampleOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetSampleOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_sample_by_data_id_with_http_info(**kwargs)
        else:
            (data) = self.get_sample_by_data_id_with_http_info(**kwargs)
            return data

    def get_sample_by_data_id_with_http_info(self, **kwargs):
        """
        Get a sample from a signal, using the source system's identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_sample_by_data_id_with_http_info(datasource_class=datasource_class_value, datasource_id=datasource_id_value, data_id=data_id_value, key=key_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datasource_class: The class of the datasource containing the signal (required)
        :param str datasource_id: The ID of the datasource containing the signal (required)
        :param str data_id: The Data ID for the signal (required)
        :param str key: The key in the signal where the sample should be retrieved (required)
        :param str lookup: Where to look for a sample relative to the specified key. The options are Interpolate, Before, AtOrBefore, At, AtOrAfter, After
        :param str key_unit_of_measure: Units to use for the key of each sample. The default does no unit conversion. For time-series, the default is ISO 8601 timestamps, e.g. '2016-01-01T19:51:32.490Z'.
        :param str value_unit_of_measure: Units to use for the value of each sample. The default does no unit conversion.
        :return: GetSampleOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetSampleOutputV1
        """

        all_params = ['datasource_class', 'datasource_id', 'data_id', 'key', 'lookup', 'key_unit_of_measure', 'value_unit_of_measure']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sample_by_data_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'datasource_class' is set
        if ('datasource_class' not in params) or (params['datasource_class'] is None):
            raise ValueError("Missing the required parameter `datasource_class` when calling `get_sample_by_data_id`")
        # verify the required parameter 'datasource_id' is set
        if ('datasource_id' not in params) or (params['datasource_id'] is None):
            raise ValueError("Missing the required parameter `datasource_id` when calling `get_sample_by_data_id`")
        # verify the required parameter 'data_id' is set
        if ('data_id' not in params) or (params['data_id'] is None):
            raise ValueError("Missing the required parameter `data_id` when calling `get_sample_by_data_id`")
        # verify the required parameter 'key' is set
        if ('key' not in params) or (params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `get_sample_by_data_id`")


        collection_formats = {}

        path_params = {}
        if 'datasource_class' in params:
            path_params['datasourceClass'] = params['datasource_class']
        if 'datasource_id' in params:
            path_params['datasourceId'] = params['datasource_id']
        if 'data_id' in params:
            path_params['dataId'] = params['data_id']
        if 'key' in params:
            path_params['key'] = params['key']

        query_params = []
        if 'lookup' in params:
            query_params.append(('lookup', params['lookup']))
        if 'key_unit_of_measure' in params:
            query_params.append(('keyUnitOfMeasure', params['key_unit_of_measure']))
        if 'value_unit_of_measure' in params:
            query_params.append(('valueUnitOfMeasure', params['value_unit_of_measure']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/signals/{datasourceClass}/{datasourceId}/{dataId}/sample/{key}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'GetSampleOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_samples(self, **kwargs):
        """
        Get samples from a signal over an interval
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_samples(id=id_value, start=start_value, end=end_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The Seeq ID for the signal (required)
        :param str start: The key at the start of the query interval as an ISO 8601 timestamp (YYYY-MM-DDThh:mm:ss.sssssssss±hh:mm). (required)
        :param str end: The key at the end of the query interval as an ISO 8601 timestamp (YYYY-MM-DDThh:mm:ss.sssssssss±hh:mm). (required)
        :param str period: To resample the signal to an evenly-spaced grid, provide the desired resampling period. The default does not perform resampling.
        :param bool inflate: Whether to inflate the resulting signal. Inflation adds samples that may not be present in the source historian in two cases. Signals with step discontinuities will have an extra sample at each discontinuity. Also, gaps wider than Max Interpolation will be marked explicitly by invalid values. An inflated signal can be plotted by connecting adjacent samples with straight lines, without needing to consider the signal's interpolation method.
        :param str boundary_values: Choice for handling samples near the start and end of the query interval. The options are Outside, Inclusive, and Interpolate.
        :param str key_unit_of_measure: Units to use for the key of each sample. The default does no unit conversion. For time-series, the default is ISO 8601 timestamps, e.g. '2016-01-01T19:51:32.490Z'.
        :param str value_unit_of_measure: Units to use for the value of each sample. The default does no unit conversion.
        :param int limit: The pagination limit, the total number of samples that will be returned in this page of results
        :param str continuation_token: An opaque token used to query for the next page of results. Only use if returned by a previous call.
        :return: GetSamplesOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetSamplesOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_samples_with_http_info(**kwargs)
        else:
            (data) = self.get_samples_with_http_info(**kwargs)
            return data

    def get_samples_with_http_info(self, **kwargs):
        """
        Get samples from a signal over an interval
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_samples_with_http_info(id=id_value, start=start_value, end=end_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The Seeq ID for the signal (required)
        :param str start: The key at the start of the query interval as an ISO 8601 timestamp (YYYY-MM-DDThh:mm:ss.sssssssss±hh:mm). (required)
        :param str end: The key at the end of the query interval as an ISO 8601 timestamp (YYYY-MM-DDThh:mm:ss.sssssssss±hh:mm). (required)
        :param str period: To resample the signal to an evenly-spaced grid, provide the desired resampling period. The default does not perform resampling.
        :param bool inflate: Whether to inflate the resulting signal. Inflation adds samples that may not be present in the source historian in two cases. Signals with step discontinuities will have an extra sample at each discontinuity. Also, gaps wider than Max Interpolation will be marked explicitly by invalid values. An inflated signal can be plotted by connecting adjacent samples with straight lines, without needing to consider the signal's interpolation method.
        :param str boundary_values: Choice for handling samples near the start and end of the query interval. The options are Outside, Inclusive, and Interpolate.
        :param str key_unit_of_measure: Units to use for the key of each sample. The default does no unit conversion. For time-series, the default is ISO 8601 timestamps, e.g. '2016-01-01T19:51:32.490Z'.
        :param str value_unit_of_measure: Units to use for the value of each sample. The default does no unit conversion.
        :param int limit: The pagination limit, the total number of samples that will be returned in this page of results
        :param str continuation_token: An opaque token used to query for the next page of results. Only use if returned by a previous call.
        :return: GetSamplesOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetSamplesOutputV1
        """

        all_params = ['id', 'start', 'end', 'period', 'inflate', 'boundary_values', 'key_unit_of_measure', 'value_unit_of_measure', 'limit', 'continuation_token']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_samples" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_samples`")
        # verify the required parameter 'start' is set
        if ('start' not in params) or (params['start'] is None):
            raise ValueError("Missing the required parameter `start` when calling `get_samples`")
        # verify the required parameter 'end' is set
        if ('end' not in params) or (params['end'] is None):
            raise ValueError("Missing the required parameter `end` when calling `get_samples`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))
        if 'end' in params:
            query_params.append(('end', params['end']))
        if 'period' in params:
            query_params.append(('period', params['period']))
        if 'inflate' in params:
            query_params.append(('inflate', params['inflate']))
        if 'boundary_values' in params:
            query_params.append(('boundaryValues', params['boundary_values']))
        if 'key_unit_of_measure' in params:
            query_params.append(('keyUnitOfMeasure', params['key_unit_of_measure']))
        if 'value_unit_of_measure' in params:
            query_params.append(('valueUnitOfMeasure', params['value_unit_of_measure']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'continuation_token' in params:
            query_params.append(('continuationToken', params['continuation_token']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/signals/{id}/samples', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'GetSamplesOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_samples_by_data_id(self, **kwargs):
        """
        Get samples from a signal over an interval, using the source system's identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_samples_by_data_id(datasource_class=datasource_class_value, datasource_id=datasource_id_value, data_id=data_id_value, start=start_value, end=end_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datasource_class: The class of the datasource containing the signal (required)
        :param str datasource_id: The ID of the datasource containing the signal (required)
        :param str data_id: The Data ID for the signal (required)
        :param str start: The key at the start of the query interval as an ISO 8601 timestamp (YYYY-MM-DDThh:mm:ss.sssssssss±hh:mm). (required)
        :param str end: The key at the end of the query interval as an ISO 8601 timestamp (YYYY-MM-DDThh:mm:ss.sssssssss±hh:mm). (required)
        :param str period: To resample the signal to an evenly-spaced grid, provide the desired resampling period. The default does not perform resampling.
        :param bool inflate: Whether to inflate the resulting signal. Inflation adds samples that may not be present in the source historian in two cases. Signals with step discontinuities will have an extra sample at each discontinuity. Also, gaps wider than Max Interpolation will be marked explicitly by invalid values. An inflated signal can be plotted by connecting adjacent samples with straight lines, without needing to consider the signal's interpolation method.
        :param str boundary_values: Choice for handling samples near the start and end of the query interval. The options are Outside, Inclusive, and Interpolate.
        :param str key_unit_of_measure: Units to use for the key of each sample. The default does no unit conversion. For time-series, the default is ISO 8601 timestamps, e.g. '2016-01-01T19:51:32.490Z'.
        :param str value_unit_of_measure: Units to use for the value of each sample. The default does no unit conversion.
        :param int limit: The pagination limit, the total number of samples that will be returned in this page of results
        :param str continuation_token: An opaque token used to query for the next page of results. Only use if returned by a previous call.
        :return: GetSamplesOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetSamplesOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_samples_by_data_id_with_http_info(**kwargs)
        else:
            (data) = self.get_samples_by_data_id_with_http_info(**kwargs)
            return data

    def get_samples_by_data_id_with_http_info(self, **kwargs):
        """
        Get samples from a signal over an interval, using the source system's identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_samples_by_data_id_with_http_info(datasource_class=datasource_class_value, datasource_id=datasource_id_value, data_id=data_id_value, start=start_value, end=end_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datasource_class: The class of the datasource containing the signal (required)
        :param str datasource_id: The ID of the datasource containing the signal (required)
        :param str data_id: The Data ID for the signal (required)
        :param str start: The key at the start of the query interval as an ISO 8601 timestamp (YYYY-MM-DDThh:mm:ss.sssssssss±hh:mm). (required)
        :param str end: The key at the end of the query interval as an ISO 8601 timestamp (YYYY-MM-DDThh:mm:ss.sssssssss±hh:mm). (required)
        :param str period: To resample the signal to an evenly-spaced grid, provide the desired resampling period. The default does not perform resampling.
        :param bool inflate: Whether to inflate the resulting signal. Inflation adds samples that may not be present in the source historian in two cases. Signals with step discontinuities will have an extra sample at each discontinuity. Also, gaps wider than Max Interpolation will be marked explicitly by invalid values. An inflated signal can be plotted by connecting adjacent samples with straight lines, without needing to consider the signal's interpolation method.
        :param str boundary_values: Choice for handling samples near the start and end of the query interval. The options are Outside, Inclusive, and Interpolate.
        :param str key_unit_of_measure: Units to use for the key of each sample. The default does no unit conversion. For time-series, the default is ISO 8601 timestamps, e.g. '2016-01-01T19:51:32.490Z'.
        :param str value_unit_of_measure: Units to use for the value of each sample. The default does no unit conversion.
        :param int limit: The pagination limit, the total number of samples that will be returned in this page of results
        :param str continuation_token: An opaque token used to query for the next page of results. Only use if returned by a previous call.
        :return: GetSamplesOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetSamplesOutputV1
        """

        all_params = ['datasource_class', 'datasource_id', 'data_id', 'start', 'end', 'period', 'inflate', 'boundary_values', 'key_unit_of_measure', 'value_unit_of_measure', 'limit', 'continuation_token']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_samples_by_data_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'datasource_class' is set
        if ('datasource_class' not in params) or (params['datasource_class'] is None):
            raise ValueError("Missing the required parameter `datasource_class` when calling `get_samples_by_data_id`")
        # verify the required parameter 'datasource_id' is set
        if ('datasource_id' not in params) or (params['datasource_id'] is None):
            raise ValueError("Missing the required parameter `datasource_id` when calling `get_samples_by_data_id`")
        # verify the required parameter 'data_id' is set
        if ('data_id' not in params) or (params['data_id'] is None):
            raise ValueError("Missing the required parameter `data_id` when calling `get_samples_by_data_id`")
        # verify the required parameter 'start' is set
        if ('start' not in params) or (params['start'] is None):
            raise ValueError("Missing the required parameter `start` when calling `get_samples_by_data_id`")
        # verify the required parameter 'end' is set
        if ('end' not in params) or (params['end'] is None):
            raise ValueError("Missing the required parameter `end` when calling `get_samples_by_data_id`")


        collection_formats = {}

        path_params = {}
        if 'datasource_class' in params:
            path_params['datasourceClass'] = params['datasource_class']
        if 'datasource_id' in params:
            path_params['datasourceId'] = params['datasource_id']
        if 'data_id' in params:
            path_params['dataId'] = params['data_id']

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))
        if 'end' in params:
            query_params.append(('end', params['end']))
        if 'period' in params:
            query_params.append(('period', params['period']))
        if 'inflate' in params:
            query_params.append(('inflate', params['inflate']))
        if 'boundary_values' in params:
            query_params.append(('boundaryValues', params['boundary_values']))
        if 'key_unit_of_measure' in params:
            query_params.append(('keyUnitOfMeasure', params['key_unit_of_measure']))
        if 'value_unit_of_measure' in params:
            query_params.append(('valueUnitOfMeasure', params['value_unit_of_measure']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'continuation_token' in params:
            query_params.append(('continuationToken', params['continuation_token']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/signals/{datasourceClass}/{datasourceId}/{dataId}/samples', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'GetSamplesOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_signal(self, **kwargs):
        """
        Get signal
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_signal(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The Seeq ID for the signal (required)
        :return: SignalOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SignalOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_signal_with_http_info(**kwargs)
        else:
            (data) = self.get_signal_with_http_info(**kwargs)
            return data

    def get_signal_with_http_info(self, **kwargs):
        """
        Get signal
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_signal_with_http_info(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The Seeq ID for the signal (required)
        :return: SignalOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SignalOutputV1
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_signal" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_signal`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/signals/{id}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'SignalOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_signal_by_data_id(self, **kwargs):
        """
        Get a signal, using the source system's identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_signal_by_data_id(datasource_class=datasource_class_value, datasource_id=datasource_id_value, data_id=data_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datasource_class: The class of the datasource containing the signal (required)
        :param str datasource_id: The ID of the datasource containing the signal (required)
        :param str data_id: The Data ID for the signal (required)
        :return: SignalOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SignalOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_signal_by_data_id_with_http_info(**kwargs)
        else:
            (data) = self.get_signal_by_data_id_with_http_info(**kwargs)
            return data

    def get_signal_by_data_id_with_http_info(self, **kwargs):
        """
        Get a signal, using the source system's identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_signal_by_data_id_with_http_info(datasource_class=datasource_class_value, datasource_id=datasource_id_value, data_id=data_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datasource_class: The class of the datasource containing the signal (required)
        :param str datasource_id: The ID of the datasource containing the signal (required)
        :param str data_id: The Data ID for the signal (required)
        :return: SignalOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SignalOutputV1
        """

        all_params = ['datasource_class', 'datasource_id', 'data_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_signal_by_data_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'datasource_class' is set
        if ('datasource_class' not in params) or (params['datasource_class'] is None):
            raise ValueError("Missing the required parameter `datasource_class` when calling `get_signal_by_data_id`")
        # verify the required parameter 'datasource_id' is set
        if ('datasource_id' not in params) or (params['datasource_id'] is None):
            raise ValueError("Missing the required parameter `datasource_id` when calling `get_signal_by_data_id`")
        # verify the required parameter 'data_id' is set
        if ('data_id' not in params) or (params['data_id'] is None):
            raise ValueError("Missing the required parameter `data_id` when calling `get_signal_by_data_id`")


        collection_formats = {}

        path_params = {}
        if 'datasource_class' in params:
            path_params['datasourceClass'] = params['datasource_class']
        if 'datasource_id' in params:
            path_params['datasourceId'] = params['datasource_id']
        if 'data_id' in params:
            path_params['dataId'] = params['data_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/signals/{datasourceClass}/{datasourceId}/{dataId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'SignalOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_signals(self, **kwargs):
        """
        List signals
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_signals(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int offset: The pagination offset, the index of the first signal that will be returned in this page of results
        :param int limit: The pagination limit, the total number of signals that will be returned in this page of results
        :return: GetSignalsOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetSignalsOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_signals_with_http_info(**kwargs)
        else:
            (data) = self.get_signals_with_http_info(**kwargs)
            return data

    def get_signals_with_http_info(self, **kwargs):
        """
        List signals
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_signals_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int offset: The pagination offset, the index of the first signal that will be returned in this page of results
        :param int limit: The pagination limit, the total number of signals that will be returned in this page of results
        :return: GetSignalsOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetSignalsOutputV1
        """

        all_params = ['offset', 'limit']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_signals" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/signals', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'GetSignalsOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def put_samples(self, **kwargs):
        """
        Replace any samples to a signal in the same time range
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_samples(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SamplesOverwriteInputV1 body: Data to be added to the signal (required)
        :param str id: The Seeq ID for the signal (required)
        :return: SamplesOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SamplesOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.put_samples_with_http_info(**kwargs)
        else:
            (data) = self.put_samples_with_http_info(**kwargs)
            return data

    def put_samples_with_http_info(self, **kwargs):
        """
        Replace any samples to a signal in the same time range
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_samples_with_http_info(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SamplesOverwriteInputV1 body: Data to be added to the signal (required)
        :param str id: The Seeq ID for the signal (required)
        :return: SamplesOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SamplesOutputV1
        """

        all_params = ['body', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_samples" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_samples`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `put_samples`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/signals/{id}/samples', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'SamplesOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def put_samples_by_data_id(self, **kwargs):
        """
        Replace any samples to a signal in the same time range, using the source system's identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_samples_by_data_id(body=body_value, datasource_class=datasource_class_value, datasource_id=datasource_id_value, data_id=data_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SamplesOverwriteInputV1 body: Data to be added to the signal (required)
        :param str datasource_class: The class of the datasource containing the signal (required)
        :param str datasource_id: The ID of the datasource containing the signal (required)
        :param str data_id: The Data ID for the signal (required)
        :return: SamplesOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SamplesOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.put_samples_by_data_id_with_http_info(**kwargs)
        else:
            (data) = self.put_samples_by_data_id_with_http_info(**kwargs)
            return data

    def put_samples_by_data_id_with_http_info(self, **kwargs):
        """
        Replace any samples to a signal in the same time range, using the source system's identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_samples_by_data_id_with_http_info(body=body_value, datasource_class=datasource_class_value, datasource_id=datasource_id_value, data_id=data_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SamplesOverwriteInputV1 body: Data to be added to the signal (required)
        :param str datasource_class: The class of the datasource containing the signal (required)
        :param str datasource_id: The ID of the datasource containing the signal (required)
        :param str data_id: The Data ID for the signal (required)
        :return: SamplesOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SamplesOutputV1
        """

        all_params = ['body', 'datasource_class', 'datasource_id', 'data_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_samples_by_data_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_samples_by_data_id`")
        # verify the required parameter 'datasource_class' is set
        if ('datasource_class' not in params) or (params['datasource_class'] is None):
            raise ValueError("Missing the required parameter `datasource_class` when calling `put_samples_by_data_id`")
        # verify the required parameter 'datasource_id' is set
        if ('datasource_id' not in params) or (params['datasource_id'] is None):
            raise ValueError("Missing the required parameter `datasource_id` when calling `put_samples_by_data_id`")
        # verify the required parameter 'data_id' is set
        if ('data_id' not in params) or (params['data_id'] is None):
            raise ValueError("Missing the required parameter `data_id` when calling `put_samples_by_data_id`")


        collection_formats = {}

        path_params = {}
        if 'datasource_class' in params:
            path_params['datasourceClass'] = params['datasource_class']
        if 'datasource_id' in params:
            path_params['datasourceId'] = params['datasource_id']
        if 'data_id' in params:
            path_params['dataId'] = params['data_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/signals/{datasourceClass}/{datasourceId}/{dataId}/samples', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'SamplesOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def put_signal(self, **kwargs):
        """
        Update a signal
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_signal(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SignalInputV1 body: (required)
        :param str id: The Seeq ID for the signal (required)
        :return: SignalOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SignalOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.put_signal_with_http_info(**kwargs)
        else:
            (data) = self.put_signal_with_http_info(**kwargs)
            return data

    def put_signal_with_http_info(self, **kwargs):
        """
        Update a signal
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_signal_with_http_info(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SignalInputV1 body: (required)
        :param str id: The Seeq ID for the signal (required)
        :return: SignalOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SignalOutputV1
        """

        all_params = ['body', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_signal" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_signal`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `put_signal`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/signals/{id}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'SignalOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def put_signal_by_data_id(self, **kwargs):
        """
        Create or update a signal, using the source system's identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_signal_by_data_id(body=body_value, datasource_class=datasource_class_value, datasource_id=datasource_id_value, data_id=data_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SignalInputV1 body: (required)
        :param str datasource_class: The class of the datasource containing the signal (required)
        :param str datasource_id: The ID of the datasource containing the signal (required)
        :param str data_id: The Data ID for the signal (required)
        :return: SignalOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SignalOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.put_signal_by_data_id_with_http_info(**kwargs)
        else:
            (data) = self.put_signal_by_data_id_with_http_info(**kwargs)
            return data

    def put_signal_by_data_id_with_http_info(self, **kwargs):
        """
        Create or update a signal, using the source system's identifier
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_signal_by_data_id_with_http_info(body=body_value, datasource_class=datasource_class_value, datasource_id=datasource_id_value, data_id=data_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SignalInputV1 body: (required)
        :param str datasource_class: The class of the datasource containing the signal (required)
        :param str datasource_id: The ID of the datasource containing the signal (required)
        :param str data_id: The Data ID for the signal (required)
        :return: SignalOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SignalOutputV1
        """

        all_params = ['body', 'datasource_class', 'datasource_id', 'data_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_signal_by_data_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_signal_by_data_id`")
        # verify the required parameter 'datasource_class' is set
        if ('datasource_class' not in params) or (params['datasource_class'] is None):
            raise ValueError("Missing the required parameter `datasource_class` when calling `put_signal_by_data_id`")
        # verify the required parameter 'datasource_id' is set
        if ('datasource_id' not in params) or (params['datasource_id'] is None):
            raise ValueError("Missing the required parameter `datasource_id` when calling `put_signal_by_data_id`")
        # verify the required parameter 'data_id' is set
        if ('data_id' not in params) or (params['data_id'] is None):
            raise ValueError("Missing the required parameter `data_id` when calling `put_signal_by_data_id`")


        collection_formats = {}

        path_params = {}
        if 'datasource_class' in params:
            path_params['datasourceClass'] = params['datasource_class']
        if 'datasource_id' in params:
            path_params['datasourceId'] = params['datasource_id']
        if 'data_id' in params:
            path_params['dataId'] = params['data_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/signals/{datasourceClass}/{datasourceId}/{dataId}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'SignalOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def put_signals(self, **kwargs):
        """
        Create or update multiple signals
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_signals(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param PutSignalsInputV1 body: (required)
        :return: ItemBatchOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ItemBatchOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.put_signals_with_http_info(**kwargs)
        else:
            (data) = self.put_signals_with_http_info(**kwargs)
            return data

    def put_signals_with_http_info(self, **kwargs):
        """
        Create or update multiple signals
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_signals_with_http_info(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param PutSignalsInputV1 body: (required)
        :return: ItemBatchOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ItemBatchOutputV1
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_signals" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_signals`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/signals/batch', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ItemBatchOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
