"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Http302Backend = void 0;
const apigw = require("@aws-cdk/aws-apigatewayv2");
const integrations = require("@aws-cdk/aws-apigatewayv2-integrations");
const cf = require("@aws-cdk/aws-cloudfront");
const origins = require("@aws-cdk/aws-cloudfront-origins");
const lambda = require("@aws-cdk/aws-lambda");
const cdk = require("@aws-cdk/core");
const extensions = require("../../extensions");
class Http302Backend extends cdk.Construct {
    constructor(scope, id) {
        super(scope, id);
        const api = new apigw.HttpApi(this, 'Api', {
            defaultIntegration: new integrations.LambdaProxyIntegration({
                handler: new lambda.Function(this, 'ApiHandler', {
                    runtime: lambda.Runtime.PYTHON_3_7,
                    handler: 'index.handler',
                    code: new lambda.InlineCode(`
def handler(event, context):
      return {
        'statusCode': 302,
        'headers': {
          'location': 'https://www.google.com',
        },
      }`),
                }),
            }),
        });
        this.endpoint = api.apiEndpoint;
        const stack = cdk.Stack.of(this);
        this.domainName = `${api.apiId}.execute-api.${stack.region}.${stack.urlSuffix}`;
    }
}
exports.Http302Backend = Http302Backend;
const app = new cdk.App();
const stack = new cdk.Stack(app, 'http302-demo');
// create the cloudfront distribution with extension(s)
const ext = new extensions.HTTP302FromOrigin(stack, 'http302');
const backend = new Http302Backend(stack, 'Http302Backend');
// create the cloudfront distribution with extension(s)
const dist = new cf.Distribution(stack, 'dist', {
    defaultBehavior: {
        origin: new origins.HttpOrigin(backend.domainName),
        cachePolicy: cf.CachePolicy.CACHING_OPTIMIZED,
        edgeLambdas: [ext],
    },
});
new cdk.CfnOutput(stack, 'BackendApiEndpoint', {
    value: backend.endpoint,
});
new cdk.CfnOutput(stack, 'demoDomainName', {
    value: 'http://' + dist.distributionDomainName,
});
//# sourceMappingURL=data:application/json;base64,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