import * as cf from '@aws-cdk/aws-cloudfront';
import * as lambda from '@aws-cdk/aws-lambda';
import * as cdk from '@aws-cdk/core';
import { ServerlessApp } from './';
import { Custom } from './custom';
/**
 * The Extension interface.
 *
 * @stability stable
 */
export interface IExtensions {
    /**
     * Lambda function ARN for this extension.
     *
     * @stability stable
     */
    readonly functionArn: string;
    /**
     * Lambda function version for the function.
     *
     * @stability stable
     */
    readonly functionVersion: lambda.Version;
    /**
     * The Lambda edge event type for this extension.
     *
     * @stability stable
     */
    readonly eventType: cf.LambdaEdgeEventType;
    /**
     * Allows a Lambda function to have read access to the body content.
     *
     * @default false
     * @stability stable
     */
    readonly includeBody?: boolean;
}
/**
 * The modify response header extension.
 *
 * @see https://console.aws.amazon.com/lambda/home#/create/app?applicationId=arn:aws:serverlessrepo:us-east-1:418289889111:applications/modify-response-header
 * @stability stable
 */
export declare class ModifyResponseHeader extends ServerlessApp implements IExtensions {
    /**
     * Lambda function ARN for this extension.
     *
     * @stability stable
     */
    readonly functionArn: string;
    /**
     * Lambda function version for the function.
     *
     * @stability stable
     */
    readonly functionVersion: lambda.Version;
    /**
     * The Lambda edge event type for this extension.
     *
     * @stability stable
     */
    readonly eventType: cf.LambdaEdgeEventType;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string);
}
/**
 * The HTTP[302] from origin extension.
 *
 * @see https://console.aws.amazon.com/lambda/home#/create/app?applicationId=arn:aws:serverlessrepo:us-east-1:418289889111:applications/http302-from-origin
 * @stability stable
 */
export declare class HTTP302FromOrigin extends Custom {
    /**
     * @stability stable
     */
    readonly lambdaFunction: lambda.Version;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string);
}
/**
 * Construct properties for AntiHotlinking.
 *
 * @stability stable
 */
export interface AntiHotlinkingProps {
    /**
     * Referer allow list with wildcard(* and ?) support i.e. `example.com` or `exa?ple.*`.
     *
     * @stability stable
     */
    readonly referer: string[];
}
/**
 * The Anti-Hotlinking extension.
 *
 * @see https://console.aws.amazon.com/lambda/home#/create/app?applicationId=arn:aws:serverlessrepo:us-east-1:418289889111:applications/anti-hotlinking
 * @stability stable
 */
export declare class AntiHotlinking extends ServerlessApp implements IExtensions {
    /**
     * Lambda function ARN for this extension.
     *
     * @stability stable
     */
    readonly functionArn: string;
    /**
     * Lambda function version for the function.
     *
     * @stability stable
     */
    readonly functionVersion: lambda.Version;
    /**
     * The Lambda edge event type for this extension.
     *
     * @stability stable
     */
    readonly eventType: cf.LambdaEdgeEventType;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: AntiHotlinkingProps);
}
/**
 * Security Headers extension.
 *
 * @see https://aws.amazon.com/tw/blogs/networking-and-content-delivery/adding-http-security-headers-using-lambdaedge-and-amazon-cloudfront/
 * @stability stable
 */
export declare class SecurtyHeaders extends ServerlessApp implements IExtensions {
    /**
     * Lambda function ARN for this extension.
     *
     * @stability stable
     */
    readonly functionArn: string;
    /**
     * Lambda function version for the function.
     *
     * @stability stable
     */
    readonly functionVersion: lambda.Version;
    /**
     * The Lambda edge event type for this extension.
     *
     * @stability stable
     */
    readonly eventType: cf.LambdaEdgeEventType;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string);
}
/**
 * Construct properties for MultipleOriginIpRetry.
 *
 * @stability stable
 */
export interface MultipleOriginIpRetryProps {
    /**
     * Origin IP list for retry, use semicolon to separate multiple IP addresses.
     *
     * @stability stable
     */
    readonly originIp: string[];
    /**
     * Origin IP list for retry, use semicolon to separate multiple IP addresses.
     *
     * @stability stable
     * @example
     *
     * https or http
     */
    readonly originProtocol: string;
}
/**
 * Multiple Origin IP Retry extension.
 *
 * @see https://github.com/awslabs/aws-cloudfront-extensions/tree/main/edge/nodejs/multiple-origin-IP-retry
 * @stability stable
 */
export declare class MultipleOriginIpRetry extends ServerlessApp implements IExtensions {
    /**
     * Lambda function ARN for this extension.
     *
     * @stability stable
     */
    readonly functionArn: string;
    /**
     * Lambda function version for the function.
     *
     * @stability stable
     */
    readonly functionVersion: lambda.Version;
    /**
     * The Lambda edge event type for this extension.
     *
     * @stability stable
     */
    readonly eventType: cf.LambdaEdgeEventType;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: MultipleOriginIpRetryProps);
}
/**
 * Normalize Query String extension.
 *
 * @see https://github.com/awslabs/aws-cloudfront-extensions/tree/main/edge/nodejs/normalize-query-string
 * @stability stable
 */
export declare class NormalizeQueryString extends ServerlessApp implements IExtensions {
    /**
     * Lambda function ARN for this extension.
     *
     * @stability stable
     */
    readonly functionArn: string;
    /**
     * Lambda function version for the function.
     *
     * @stability stable
     */
    readonly functionVersion: lambda.Version;
    /**
     * The Lambda edge event type for this extension.
     *
     * @stability stable
     */
    readonly eventType: cf.LambdaEdgeEventType;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string);
}
/**
 * keys options.
 *
 * @stability stable
 */
export interface ConvertQueryStringProps {
    /**
     * The request arguments that will be converted to additional request headers.
     *
     * For example ['key1', 'key2'] will be converted to the header `x-key1` and `x-key2`.
     * Any other request arguments will not be converted.
     *
     * @stability stable
     */
    readonly args: Array<string>;
}
/**
 * Convert a query string to key-value pairs and add them into header.
 *
 * @see https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-examples.html#lambda-examples-header-based-on-query-string
 * @stability stable
 */
export declare class ConvertQueryString extends Custom {
    /**
     * @stability stable
     */
    readonly lambdaFunction: lambda.Version;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: ConvertQueryStringProps);
}
/**
 * Default Directory Indexes in Amazon S3-backed Amazon CloudFront Origins.
 *
 * use case - see https://aws.amazon.com/tw/blogs/compute/implementing-default-directory-indexes-in-amazon-s3-backed-amazon-cloudfront-origins-using-lambdaedge/
 *
 * @stability stable
 */
export declare class DefaultDirIndex extends Custom {
    /**
     * @stability stable
     */
    readonly lambdaFunction: lambda.Version;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string);
}
/**
 * Display customized error pages, or mask 4XX error pages, based on where the error originated.
 *
 * use case - see https://aws.amazon.com/blogs/networking-and-content-delivery/customize-403-error-pages-from-amazon-cloudfront-origin-with-lambdaedge/
 *
 * @stability stable
 */
export declare class CustomErrorPage extends Custom {
    /**
     * @stability stable
     */
    readonly lambdaFunction: lambda.Version;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string);
}
/**
 * @stability stable
 */
export interface AccessOriginByGeolocationProps {
    /**
     * The pre-defined country code table.
     *
     * Exampe: { 'US': 'amazon.com' }
     *
     * @stability stable
     */
    readonly countryTable: {
        [code: string]: string;
    };
}
/**
 * (SO8118)Access Origin by Geolocation.
 *
 * @stability stable
 */
export declare class AccessOriginByGeolocation extends Custom {
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: AccessOriginByGeolocationProps);
}
/**
 * @stability stable
 */
export interface RedirectByGeolocationProps {
    /**
     * The pre-defined country code table.
     *
     * Exampe: { 'US': 'amazon.com' }
     *
     * @stability stable
     */
    readonly countryTable: {
        [code: string]: string;
    };
}
/**
 * Forward request to the nearest PoP as per geolocation.
 *
 * @stability stable
 */
export declare class RedirectByGeolocation extends Custom {
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: RedirectByGeolocationProps);
}
/**
 * Simple content generation.
 *
 * @see https://github.com/awslabs/aws-cloudfront-extensions/tree/main/edge/nodejs/simple-lambda-edge
 * @stability stable
 */
export declare class SimpleLambdaEdge extends Custom {
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string);
}
/**
 * @stability stable
 */
export interface OAuth2AuthorizationCodeGrantProps {
    /**
     * @stability stable
     */
    readonly clientDomain: string;
    /**
     * @stability stable
     */
    readonly clientId: string;
    /**
     * @stability stable
     */
    readonly clientSecret: string;
    /**
     * @stability stable
     */
    readonly clientPublicKey: string;
    /**
     * @stability stable
     */
    readonly authorizeUrl: string;
    /**
     * @stability stable
     */
    readonly authorizeParams: string;
    /**
     * @stability stable
     */
    readonly authorizeRedirecturiShouldMatch: boolean;
    /**
     * @stability stable
     */
    readonly callbackPath: string;
    /**
     * @stability stable
     */
    readonly jwtArgorithm: string;
    /**
     * @stability stable
     */
    readonly jwtTokenPath: string;
    /**
     * @stability stable
     */
    readonly debugEnable: boolean;
}
/**
 * OAuth2 Authentication - Authorization Code Grant.
 *
 * @stability stable
 */
export declare class OAuth2AuthorizationCodeGrant extends Custom {
    /**
     * @stability stable
     */
    readonly lambdaFunction: lambda.Version;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: OAuth2AuthorizationCodeGrantProps);
}
/**
 * @stability stable
 */
export interface GlobalDataIngestionProps {
    /**
     * Kinesis Firehose DeliveryStreamName.
     *
     * @stability stable
     */
    readonly firehoseStreamName: string;
}
/**
 * Ingest data to Kinesis Firehose by nearest cloudfront edge.
 *
 * @see https://aws.amazon.com/blogs/networking-and-content-delivery/global-data-ingestion-with-amazon-cloudfront-and-lambdaedge/
 * @stability stable
 */
export declare class GlobalDataIngestion extends Custom {
    /**
     * @stability stable
     */
    readonly lambdaFunction: lambda.Version;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: GlobalDataIngestionProps);
}
