# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .llm_as_judge_code import LlmAsJudgeCode
from .trace_thread_llm_as_judge_code import TraceThreadLlmAsJudgeCode
from .trace_thread_user_defined_metric_python_code import TraceThreadUserDefinedMetricPythonCode
from .user_defined_metric_python_code import UserDefinedMetricPythonCode


class Base(UniversalBaseModel):
    name: str
    sampling_rate: typing.Optional[float] = None
    enabled: typing.Optional[bool] = None
    project_id: str
    action: typing.Literal["evaluator"] = "evaluator"

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class AutomationRuleEvaluatorUpdate_LlmAsJudge(Base):
    type: typing.Literal["llm_as_judge"] = "llm_as_judge"
    code: typing.Optional[LlmAsJudgeCode] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class AutomationRuleEvaluatorUpdate_UserDefinedMetricPython(Base):
    type: typing.Literal["user_defined_metric_python"] = "user_defined_metric_python"
    code: typing.Optional[UserDefinedMetricPythonCode] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class AutomationRuleEvaluatorUpdate_TraceThreadLlmAsJudge(Base):
    type: typing.Literal["trace_thread_llm_as_judge"] = "trace_thread_llm_as_judge"
    code: typing.Optional[TraceThreadLlmAsJudgeCode] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class AutomationRuleEvaluatorUpdate_TraceThreadUserDefinedMetricPython(Base):
    type: typing.Literal["trace_thread_user_defined_metric_python"] = "trace_thread_user_defined_metric_python"
    code: typing.Optional[TraceThreadUserDefinedMetricPythonCode] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


AutomationRuleEvaluatorUpdate = typing.Union[
    AutomationRuleEvaluatorUpdate_LlmAsJudge,
    AutomationRuleEvaluatorUpdate_UserDefinedMetricPython,
    AutomationRuleEvaluatorUpdate_TraceThreadLlmAsJudge,
    AutomationRuleEvaluatorUpdate_TraceThreadUserDefinedMetricPython,
]
