"""A minimal, extensible backtesting toolkit.

Current scope:
- Data utilities (load/generate sample OHLCV data)
- Core metrics: CAGR and Max Drawdown
- Simple Backtester wrapper producing metrics from price DataFrames

Design goals:
- Inputs and outputs are pandas DataFrames where practical
- Modular functions for maintainability and future expansion
"""

from .data import (
    generate_sample_data,
    load_data,
    pivot_close,
    load_sample_dataset,
    load_sample_prices,
)
from .metrics import compute_cagr, compute_max_drawdown, compute_metrics
from .backtester import Backtester

__all__ = [
    "generate_sample_data",
    "load_data",
    "pivot_close",
    "load_sample_dataset",
    "load_sample_prices",
    "compute_cagr",
    "compute_max_drawdown",
    "compute_metrics",
    "Backtester",
]
