# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AuthBackendLoginArgs', 'AuthBackendLogin']

@pulumi.input_type
class AuthBackendLoginArgs:
    def __init__(__self__, *,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_http_request_method: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_request_body: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_request_headers: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_request_url: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 nonce: Optional[pulumi.Input[_builtins.str]] = None,
                 pkcs7: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 signature: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AuthBackendLogin resource.
        :param pulumi.Input[_builtins.str] backend: The unique name of the AWS auth backend. Defaults to
               'aws'.
        :param pulumi.Input[_builtins.str] iam_http_request_method: The HTTP method used in the signed IAM
               request.
        :param pulumi.Input[_builtins.str] iam_request_body: The base64-encoded body of the signed
               request.
        :param pulumi.Input[_builtins.str] iam_request_headers: The base64-encoded, JSON serialized
               representation of the GetCallerIdentity HTTP request headers.
        :param pulumi.Input[_builtins.str] iam_request_url: The base64-encoded HTTP URL used in the signed
               request.
        :param pulumi.Input[_builtins.str] identity: The base64-encoded EC2 instance identity document to
               authenticate with. Can be retrieved from the EC2 metadata server.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] nonce: The unique nonce to be used for login requests. Can be
               set to a user-specified value, or will contain the server-generated value
               once a token is issued. EC2 instances can only acquire a single token until
               the whitelist is tidied again unless they keep track of this nonce.
        :param pulumi.Input[_builtins.str] pkcs7: The PKCS#7 signature of the identity document to
               authenticate with, with all newline characters removed. Can be retrieved from
               the EC2 metadata server.
        :param pulumi.Input[_builtins.str] role: The name of the AWS auth backend role to create tokens
               against.
        :param pulumi.Input[_builtins.str] signature: The base64-encoded SHA256 RSA signature of the
               instance identity document to authenticate with, with all newline characters
               removed. Can be retrieved from the EC2 metadata server.
        """
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if iam_http_request_method is not None:
            pulumi.set(__self__, "iam_http_request_method", iam_http_request_method)
        if iam_request_body is not None:
            pulumi.set(__self__, "iam_request_body", iam_request_body)
        if iam_request_headers is not None:
            pulumi.set(__self__, "iam_request_headers", iam_request_headers)
        if iam_request_url is not None:
            pulumi.set(__self__, "iam_request_url", iam_request_url)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if nonce is not None:
            pulumi.set(__self__, "nonce", nonce)
        if pkcs7 is not None:
            pulumi.set(__self__, "pkcs7", pkcs7)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if signature is not None:
            pulumi.set(__self__, "signature", signature)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique name of the AWS auth backend. Defaults to
        'aws'.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="iamHttpRequestMethod")
    def iam_http_request_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The HTTP method used in the signed IAM
        request.
        """
        return pulumi.get(self, "iam_http_request_method")

    @iam_http_request_method.setter
    def iam_http_request_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_http_request_method", value)

    @_builtins.property
    @pulumi.getter(name="iamRequestBody")
    def iam_request_body(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base64-encoded body of the signed
        request.
        """
        return pulumi.get(self, "iam_request_body")

    @iam_request_body.setter
    def iam_request_body(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_request_body", value)

    @_builtins.property
    @pulumi.getter(name="iamRequestHeaders")
    def iam_request_headers(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base64-encoded, JSON serialized
        representation of the GetCallerIdentity HTTP request headers.
        """
        return pulumi.get(self, "iam_request_headers")

    @iam_request_headers.setter
    def iam_request_headers(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_request_headers", value)

    @_builtins.property
    @pulumi.getter(name="iamRequestUrl")
    def iam_request_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base64-encoded HTTP URL used in the signed
        request.
        """
        return pulumi.get(self, "iam_request_url")

    @iam_request_url.setter
    def iam_request_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_request_url", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base64-encoded EC2 instance identity document to
        authenticate with. Can be retrieved from the EC2 metadata server.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def nonce(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique nonce to be used for login requests. Can be
        set to a user-specified value, or will contain the server-generated value
        once a token is issued. EC2 instances can only acquire a single token until
        the whitelist is tidied again unless they keep track of this nonce.
        """
        return pulumi.get(self, "nonce")

    @nonce.setter
    def nonce(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nonce", value)

    @_builtins.property
    @pulumi.getter
    def pkcs7(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The PKCS#7 signature of the identity document to
        authenticate with, with all newline characters removed. Can be retrieved from
        the EC2 metadata server.
        """
        return pulumi.get(self, "pkcs7")

    @pkcs7.setter
    def pkcs7(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pkcs7", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the AWS auth backend role to create tokens
        against.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter
    def signature(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base64-encoded SHA256 RSA signature of the
        instance identity document to authenticate with, with all newline characters
        removed. Can be retrieved from the EC2 metadata server.
        """
        return pulumi.get(self, "signature")

    @signature.setter
    def signature(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "signature", value)


@pulumi.input_type
class _AuthBackendLoginState:
    def __init__(__self__, *,
                 accessor: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_type: Optional[pulumi.Input[_builtins.str]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 client_token: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_http_request_method: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_request_body: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_request_headers: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_request_url: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[_builtins.str]] = None,
                 lease_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 lease_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 nonce: Optional[pulumi.Input[_builtins.str]] = None,
                 pkcs7: Optional[pulumi.Input[_builtins.str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 renewable: Optional[pulumi.Input[_builtins.bool]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 signature: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AuthBackendLogin resources.
        :param pulumi.Input[_builtins.str] accessor: The token's accessor.
        :param pulumi.Input[_builtins.str] auth_type: The authentication type used to generate this token.
        :param pulumi.Input[_builtins.str] backend: The unique name of the AWS auth backend. Defaults to
               'aws'.
        :param pulumi.Input[_builtins.str] client_token: The token returned by Vault.
        :param pulumi.Input[_builtins.str] iam_http_request_method: The HTTP method used in the signed IAM
               request.
        :param pulumi.Input[_builtins.str] iam_request_body: The base64-encoded body of the signed
               request.
        :param pulumi.Input[_builtins.str] iam_request_headers: The base64-encoded, JSON serialized
               representation of the GetCallerIdentity HTTP request headers.
        :param pulumi.Input[_builtins.str] iam_request_url: The base64-encoded HTTP URL used in the signed
               request.
        :param pulumi.Input[_builtins.str] identity: The base64-encoded EC2 instance identity document to
               authenticate with. Can be retrieved from the EC2 metadata server.
        :param pulumi.Input[_builtins.int] lease_duration: The duration in seconds the token will be valid, relative
               to the time in `lease_start_time`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: A map of information returned by the Vault server about the
               authentication used to generate this token.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] nonce: The unique nonce to be used for login requests. Can be
               set to a user-specified value, or will contain the server-generated value
               once a token is issued. EC2 instances can only acquire a single token until
               the whitelist is tidied again unless they keep track of this nonce.
        :param pulumi.Input[_builtins.str] pkcs7: The PKCS#7 signature of the identity document to
               authenticate with, with all newline characters removed. Can be retrieved from
               the EC2 metadata server.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policies: The Vault policies assigned to this token.
        :param pulumi.Input[_builtins.bool] renewable: Set to true if the token can be extended through renewal.
        :param pulumi.Input[_builtins.str] role: The name of the AWS auth backend role to create tokens
               against.
        :param pulumi.Input[_builtins.str] signature: The base64-encoded SHA256 RSA signature of the
               instance identity document to authenticate with, with all newline characters
               removed. Can be retrieved from the EC2 metadata server.
        """
        if accessor is not None:
            pulumi.set(__self__, "accessor", accessor)
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if client_token is not None:
            pulumi.set(__self__, "client_token", client_token)
        if iam_http_request_method is not None:
            pulumi.set(__self__, "iam_http_request_method", iam_http_request_method)
        if iam_request_body is not None:
            pulumi.set(__self__, "iam_request_body", iam_request_body)
        if iam_request_headers is not None:
            pulumi.set(__self__, "iam_request_headers", iam_request_headers)
        if iam_request_url is not None:
            pulumi.set(__self__, "iam_request_url", iam_request_url)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if lease_duration is not None:
            pulumi.set(__self__, "lease_duration", lease_duration)
        if lease_start_time is not None:
            pulumi.set(__self__, "lease_start_time", lease_start_time)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if nonce is not None:
            pulumi.set(__self__, "nonce", nonce)
        if pkcs7 is not None:
            pulumi.set(__self__, "pkcs7", pkcs7)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if renewable is not None:
            pulumi.set(__self__, "renewable", renewable)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if signature is not None:
            pulumi.set(__self__, "signature", signature)

    @_builtins.property
    @pulumi.getter
    def accessor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The token's accessor.
        """
        return pulumi.get(self, "accessor")

    @accessor.setter
    def accessor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accessor", value)

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication type used to generate this token.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_type", value)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique name of the AWS auth backend. Defaults to
        'aws'.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="clientToken")
    def client_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The token returned by Vault.
        """
        return pulumi.get(self, "client_token")

    @client_token.setter
    def client_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_token", value)

    @_builtins.property
    @pulumi.getter(name="iamHttpRequestMethod")
    def iam_http_request_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The HTTP method used in the signed IAM
        request.
        """
        return pulumi.get(self, "iam_http_request_method")

    @iam_http_request_method.setter
    def iam_http_request_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_http_request_method", value)

    @_builtins.property
    @pulumi.getter(name="iamRequestBody")
    def iam_request_body(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base64-encoded body of the signed
        request.
        """
        return pulumi.get(self, "iam_request_body")

    @iam_request_body.setter
    def iam_request_body(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_request_body", value)

    @_builtins.property
    @pulumi.getter(name="iamRequestHeaders")
    def iam_request_headers(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base64-encoded, JSON serialized
        representation of the GetCallerIdentity HTTP request headers.
        """
        return pulumi.get(self, "iam_request_headers")

    @iam_request_headers.setter
    def iam_request_headers(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_request_headers", value)

    @_builtins.property
    @pulumi.getter(name="iamRequestUrl")
    def iam_request_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base64-encoded HTTP URL used in the signed
        request.
        """
        return pulumi.get(self, "iam_request_url")

    @iam_request_url.setter
    def iam_request_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_request_url", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base64-encoded EC2 instance identity document to
        authenticate with. Can be retrieved from the EC2 metadata server.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="leaseDuration")
    def lease_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration in seconds the token will be valid, relative
        to the time in `lease_start_time`.
        """
        return pulumi.get(self, "lease_duration")

    @lease_duration.setter
    def lease_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "lease_duration", value)

    @_builtins.property
    @pulumi.getter(name="leaseStartTime")
    def lease_start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "lease_start_time")

    @lease_start_time.setter
    def lease_start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lease_start_time", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of information returned by the Vault server about the
        authentication used to generate this token.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def nonce(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique nonce to be used for login requests. Can be
        set to a user-specified value, or will contain the server-generated value
        once a token is issued. EC2 instances can only acquire a single token until
        the whitelist is tidied again unless they keep track of this nonce.
        """
        return pulumi.get(self, "nonce")

    @nonce.setter
    def nonce(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nonce", value)

    @_builtins.property
    @pulumi.getter
    def pkcs7(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The PKCS#7 signature of the identity document to
        authenticate with, with all newline characters removed. Can be retrieved from
        the EC2 metadata server.
        """
        return pulumi.get(self, "pkcs7")

    @pkcs7.setter
    def pkcs7(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pkcs7", value)

    @_builtins.property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The Vault policies assigned to this token.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "policies", value)

    @_builtins.property
    @pulumi.getter
    def renewable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true if the token can be extended through renewal.
        """
        return pulumi.get(self, "renewable")

    @renewable.setter
    def renewable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "renewable", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the AWS auth backend role to create tokens
        against.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter
    def signature(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base64-encoded SHA256 RSA signature of the
        instance identity document to authenticate with, with all newline characters
        removed. Can be retrieved from the EC2 metadata server.
        """
        return pulumi.get(self, "signature")

    @signature.setter
    def signature(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "signature", value)


@pulumi.type_token("vault:aws/authBackendLogin:AuthBackendLogin")
class AuthBackendLogin(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_http_request_method: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_request_body: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_request_headers: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_request_url: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 nonce: Optional[pulumi.Input[_builtins.str]] = None,
                 pkcs7: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 signature: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Logs into a Vault server using an AWS auth backend. Login can be
        accomplished using a signed identity request from IAM or using ec2
        instance metadata. For more information, see the [Vault
        documentation](https://www.vaultproject.io/docs/auth/aws.html).

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend: The unique name of the AWS auth backend. Defaults to
               'aws'.
        :param pulumi.Input[_builtins.str] iam_http_request_method: The HTTP method used in the signed IAM
               request.
        :param pulumi.Input[_builtins.str] iam_request_body: The base64-encoded body of the signed
               request.
        :param pulumi.Input[_builtins.str] iam_request_headers: The base64-encoded, JSON serialized
               representation of the GetCallerIdentity HTTP request headers.
        :param pulumi.Input[_builtins.str] iam_request_url: The base64-encoded HTTP URL used in the signed
               request.
        :param pulumi.Input[_builtins.str] identity: The base64-encoded EC2 instance identity document to
               authenticate with. Can be retrieved from the EC2 metadata server.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] nonce: The unique nonce to be used for login requests. Can be
               set to a user-specified value, or will contain the server-generated value
               once a token is issued. EC2 instances can only acquire a single token until
               the whitelist is tidied again unless they keep track of this nonce.
        :param pulumi.Input[_builtins.str] pkcs7: The PKCS#7 signature of the identity document to
               authenticate with, with all newline characters removed. Can be retrieved from
               the EC2 metadata server.
        :param pulumi.Input[_builtins.str] role: The name of the AWS auth backend role to create tokens
               against.
        :param pulumi.Input[_builtins.str] signature: The base64-encoded SHA256 RSA signature of the
               instance identity document to authenticate with, with all newline characters
               removed. Can be retrieved from the EC2 metadata server.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AuthBackendLoginArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Logs into a Vault server using an AWS auth backend. Login can be
        accomplished using a signed identity request from IAM or using ec2
        instance metadata. For more information, see the [Vault
        documentation](https://www.vaultproject.io/docs/auth/aws.html).

        :param str resource_name: The name of the resource.
        :param AuthBackendLoginArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthBackendLoginArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_http_request_method: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_request_body: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_request_headers: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_request_url: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 nonce: Optional[pulumi.Input[_builtins.str]] = None,
                 pkcs7: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 signature: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthBackendLoginArgs.__new__(AuthBackendLoginArgs)

            __props__.__dict__["backend"] = backend
            __props__.__dict__["iam_http_request_method"] = iam_http_request_method
            __props__.__dict__["iam_request_body"] = iam_request_body
            __props__.__dict__["iam_request_headers"] = iam_request_headers
            __props__.__dict__["iam_request_url"] = iam_request_url
            __props__.__dict__["identity"] = identity
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["nonce"] = nonce
            __props__.__dict__["pkcs7"] = pkcs7
            __props__.__dict__["role"] = role
            __props__.__dict__["signature"] = signature
            __props__.__dict__["accessor"] = None
            __props__.__dict__["auth_type"] = None
            __props__.__dict__["client_token"] = None
            __props__.__dict__["lease_duration"] = None
            __props__.__dict__["lease_start_time"] = None
            __props__.__dict__["metadata"] = None
            __props__.__dict__["policies"] = None
            __props__.__dict__["renewable"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clientToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AuthBackendLogin, __self__).__init__(
            'vault:aws/authBackendLogin:AuthBackendLogin',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accessor: Optional[pulumi.Input[_builtins.str]] = None,
            auth_type: Optional[pulumi.Input[_builtins.str]] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            client_token: Optional[pulumi.Input[_builtins.str]] = None,
            iam_http_request_method: Optional[pulumi.Input[_builtins.str]] = None,
            iam_request_body: Optional[pulumi.Input[_builtins.str]] = None,
            iam_request_headers: Optional[pulumi.Input[_builtins.str]] = None,
            iam_request_url: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[_builtins.str]] = None,
            lease_duration: Optional[pulumi.Input[_builtins.int]] = None,
            lease_start_time: Optional[pulumi.Input[_builtins.str]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            nonce: Optional[pulumi.Input[_builtins.str]] = None,
            pkcs7: Optional[pulumi.Input[_builtins.str]] = None,
            policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            renewable: Optional[pulumi.Input[_builtins.bool]] = None,
            role: Optional[pulumi.Input[_builtins.str]] = None,
            signature: Optional[pulumi.Input[_builtins.str]] = None) -> 'AuthBackendLogin':
        """
        Get an existing AuthBackendLogin resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accessor: The token's accessor.
        :param pulumi.Input[_builtins.str] auth_type: The authentication type used to generate this token.
        :param pulumi.Input[_builtins.str] backend: The unique name of the AWS auth backend. Defaults to
               'aws'.
        :param pulumi.Input[_builtins.str] client_token: The token returned by Vault.
        :param pulumi.Input[_builtins.str] iam_http_request_method: The HTTP method used in the signed IAM
               request.
        :param pulumi.Input[_builtins.str] iam_request_body: The base64-encoded body of the signed
               request.
        :param pulumi.Input[_builtins.str] iam_request_headers: The base64-encoded, JSON serialized
               representation of the GetCallerIdentity HTTP request headers.
        :param pulumi.Input[_builtins.str] iam_request_url: The base64-encoded HTTP URL used in the signed
               request.
        :param pulumi.Input[_builtins.str] identity: The base64-encoded EC2 instance identity document to
               authenticate with. Can be retrieved from the EC2 metadata server.
        :param pulumi.Input[_builtins.int] lease_duration: The duration in seconds the token will be valid, relative
               to the time in `lease_start_time`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: A map of information returned by the Vault server about the
               authentication used to generate this token.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] nonce: The unique nonce to be used for login requests. Can be
               set to a user-specified value, or will contain the server-generated value
               once a token is issued. EC2 instances can only acquire a single token until
               the whitelist is tidied again unless they keep track of this nonce.
        :param pulumi.Input[_builtins.str] pkcs7: The PKCS#7 signature of the identity document to
               authenticate with, with all newline characters removed. Can be retrieved from
               the EC2 metadata server.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policies: The Vault policies assigned to this token.
        :param pulumi.Input[_builtins.bool] renewable: Set to true if the token can be extended through renewal.
        :param pulumi.Input[_builtins.str] role: The name of the AWS auth backend role to create tokens
               against.
        :param pulumi.Input[_builtins.str] signature: The base64-encoded SHA256 RSA signature of the
               instance identity document to authenticate with, with all newline characters
               removed. Can be retrieved from the EC2 metadata server.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthBackendLoginState.__new__(_AuthBackendLoginState)

        __props__.__dict__["accessor"] = accessor
        __props__.__dict__["auth_type"] = auth_type
        __props__.__dict__["backend"] = backend
        __props__.__dict__["client_token"] = client_token
        __props__.__dict__["iam_http_request_method"] = iam_http_request_method
        __props__.__dict__["iam_request_body"] = iam_request_body
        __props__.__dict__["iam_request_headers"] = iam_request_headers
        __props__.__dict__["iam_request_url"] = iam_request_url
        __props__.__dict__["identity"] = identity
        __props__.__dict__["lease_duration"] = lease_duration
        __props__.__dict__["lease_start_time"] = lease_start_time
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["nonce"] = nonce
        __props__.__dict__["pkcs7"] = pkcs7
        __props__.__dict__["policies"] = policies
        __props__.__dict__["renewable"] = renewable
        __props__.__dict__["role"] = role
        __props__.__dict__["signature"] = signature
        return AuthBackendLogin(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def accessor(self) -> pulumi.Output[_builtins.str]:
        """
        The token's accessor.
        """
        return pulumi.get(self, "accessor")

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Output[_builtins.str]:
        """
        The authentication type used to generate this token.
        """
        return pulumi.get(self, "auth_type")

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The unique name of the AWS auth backend. Defaults to
        'aws'.
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="clientToken")
    def client_token(self) -> pulumi.Output[_builtins.str]:
        """
        The token returned by Vault.
        """
        return pulumi.get(self, "client_token")

    @_builtins.property
    @pulumi.getter(name="iamHttpRequestMethod")
    def iam_http_request_method(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The HTTP method used in the signed IAM
        request.
        """
        return pulumi.get(self, "iam_http_request_method")

    @_builtins.property
    @pulumi.getter(name="iamRequestBody")
    def iam_request_body(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The base64-encoded body of the signed
        request.
        """
        return pulumi.get(self, "iam_request_body")

    @_builtins.property
    @pulumi.getter(name="iamRequestHeaders")
    def iam_request_headers(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The base64-encoded, JSON serialized
        representation of the GetCallerIdentity HTTP request headers.
        """
        return pulumi.get(self, "iam_request_headers")

    @_builtins.property
    @pulumi.getter(name="iamRequestUrl")
    def iam_request_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The base64-encoded HTTP URL used in the signed
        request.
        """
        return pulumi.get(self, "iam_request_url")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The base64-encoded EC2 instance identity document to
        authenticate with. Can be retrieved from the EC2 metadata server.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="leaseDuration")
    def lease_duration(self) -> pulumi.Output[_builtins.int]:
        """
        The duration in seconds the token will be valid, relative
        to the time in `lease_start_time`.
        """
        return pulumi.get(self, "lease_duration")

    @_builtins.property
    @pulumi.getter(name="leaseStartTime")
    def lease_start_time(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "lease_start_time")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of information returned by the Vault server about the
        authentication used to generate this token.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def nonce(self) -> pulumi.Output[_builtins.str]:
        """
        The unique nonce to be used for login requests. Can be
        set to a user-specified value, or will contain the server-generated value
        once a token is issued. EC2 instances can only acquire a single token until
        the whitelist is tidied again unless they keep track of this nonce.
        """
        return pulumi.get(self, "nonce")

    @_builtins.property
    @pulumi.getter
    def pkcs7(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The PKCS#7 signature of the identity document to
        authenticate with, with all newline characters removed. Can be retrieved from
        the EC2 metadata server.
        """
        return pulumi.get(self, "pkcs7")

    @_builtins.property
    @pulumi.getter
    def policies(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The Vault policies assigned to this token.
        """
        return pulumi.get(self, "policies")

    @_builtins.property
    @pulumi.getter
    def renewable(self) -> pulumi.Output[_builtins.bool]:
        """
        Set to true if the token can be extended through renewal.
        """
        return pulumi.get(self, "renewable")

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the AWS auth backend role to create tokens
        against.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter
    def signature(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The base64-encoded SHA256 RSA signature of the
        instance identity document to authenticate with, with all newline characters
        removed. Can be retrieved from the EC2 metadata server.
        """
        return pulumi.get(self, "signature")

