# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SecretBackendRoleArgs', 'SecretBackendRole']

@pulumi.input_type
class SecretBackendRoleArgs:
    def __init__(__self__, *,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 consul_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 consul_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 consul_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 node_identities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_identities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a SecretBackendRole resource.
        :param pulumi.Input[_builtins.str] backend: The unique name of an existing Consul secrets backend mount. Must not begin or end with a `/`. One of `path` or `backend` is required.
        :param pulumi.Input[_builtins.str] consul_namespace: The Consul namespace that the token will be created in.
               Applicable for Vault 1.10+ and Consul 1.7+".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] consul_policies: <sup><a href="#note-about-required-arguments">SEE NOTE</a></sup> The list of Consul ACL policies to associate with these roles.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] consul_roles: <sup><a href="#note-about-required-arguments">SEE NOTE</a></sup> Set of Consul roles to attach to the token.
               Applicable for Vault 1.10+ with Consul 1.5+.
        :param pulumi.Input[_builtins.bool] local: Indicates that the token should not be replicated globally and instead be local to the current datacenter.
        :param pulumi.Input[_builtins.int] max_ttl: Maximum TTL for leases associated with this role, in seconds.
        :param pulumi.Input[_builtins.str] name: The name of the Consul secrets engine role to create.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] node_identities: <sup><a href="#note-about-required-arguments">SEE NOTE</a></sup> Set of Consul node
               identities to attach to the token. Applicable for Vault 1.11+ with Consul 1.8+.
        :param pulumi.Input[_builtins.str] partition: The admin partition that the token will be created in.
               Applicable for Vault 1.10+ and Consul 1.11+".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policies: The list of Consul ACL policies to associate with these roles.
               **NOTE:** The new parameter `consul_policies` should be used in favor of this. This parameter,
               `policies`, remains supported for legacy users, but Vault has deprecated this field.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] service_identities: <sup><a href="#note-about-required-arguments">SEE NOTE</a></sup> Set of Consul
               service identities to attach to the token. Applicable for Vault 1.11+ with Consul 1.5+.
        :param pulumi.Input[_builtins.int] ttl: Specifies the TTL for this role.
        """
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if consul_namespace is not None:
            pulumi.set(__self__, "consul_namespace", consul_namespace)
        if consul_policies is not None:
            pulumi.set(__self__, "consul_policies", consul_policies)
        if consul_roles is not None:
            pulumi.set(__self__, "consul_roles", consul_roles)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if node_identities is not None:
            pulumi.set(__self__, "node_identities", node_identities)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if service_identities is not None:
            pulumi.set(__self__, "service_identities", service_identities)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique name of an existing Consul secrets backend mount. Must not begin or end with a `/`. One of `path` or `backend` is required.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="consulNamespace")
    def consul_namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Consul namespace that the token will be created in.
        Applicable for Vault 1.10+ and Consul 1.7+".
        """
        return pulumi.get(self, "consul_namespace")

    @consul_namespace.setter
    def consul_namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "consul_namespace", value)

    @_builtins.property
    @pulumi.getter(name="consulPolicies")
    def consul_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        <sup><a href="#note-about-required-arguments">SEE NOTE</a></sup> The list of Consul ACL policies to associate with these roles.
        """
        return pulumi.get(self, "consul_policies")

    @consul_policies.setter
    def consul_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "consul_policies", value)

    @_builtins.property
    @pulumi.getter(name="consulRoles")
    def consul_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        <sup><a href="#note-about-required-arguments">SEE NOTE</a></sup> Set of Consul roles to attach to the token.
        Applicable for Vault 1.10+ with Consul 1.5+.
        """
        return pulumi.get(self, "consul_roles")

    @consul_roles.setter
    def consul_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "consul_roles", value)

    @_builtins.property
    @pulumi.getter
    def local(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates that the token should not be replicated globally and instead be local to the current datacenter.
        """
        return pulumi.get(self, "local")

    @local.setter
    def local(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local", value)

    @_builtins.property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum TTL for leases associated with this role, in seconds.
        """
        return pulumi.get(self, "max_ttl")

    @max_ttl.setter
    def max_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_ttl", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Consul secrets engine role to create.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="nodeIdentities")
    def node_identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        <sup><a href="#note-about-required-arguments">SEE NOTE</a></sup> Set of Consul node
        identities to attach to the token. Applicable for Vault 1.11+ with Consul 1.8+.
        """
        return pulumi.get(self, "node_identities")

    @node_identities.setter
    def node_identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "node_identities", value)

    @_builtins.property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The admin partition that the token will be created in.
        Applicable for Vault 1.10+ and Consul 1.11+".
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partition", value)

    @_builtins.property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of Consul ACL policies to associate with these roles.
        **NOTE:** The new parameter `consul_policies` should be used in favor of this. This parameter,
        `policies`, remains supported for legacy users, but Vault has deprecated this field.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "policies", value)

    @_builtins.property
    @pulumi.getter(name="serviceIdentities")
    def service_identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        <sup><a href="#note-about-required-arguments">SEE NOTE</a></sup> Set of Consul
        service identities to attach to the token. Applicable for Vault 1.11+ with Consul 1.5+.
        """
        return pulumi.get(self, "service_identities")

    @service_identities.setter
    def service_identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "service_identities", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the TTL for this role.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class _SecretBackendRoleState:
    def __init__(__self__, *,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 consul_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 consul_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 consul_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 node_identities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_identities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering SecretBackendRole resources.
        :param pulumi.Input[_builtins.str] backend: The unique name of an existing Consul secrets backend mount. Must not begin or end with a `/`. One of `path` or `backend` is required.
        :param pulumi.Input[_builtins.str] consul_namespace: The Consul namespace that the token will be created in.
               Applicable for Vault 1.10+ and Consul 1.7+".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] consul_policies: <sup><a href="#note-about-required-arguments">SEE NOTE</a></sup> The list of Consul ACL policies to associate with these roles.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] consul_roles: <sup><a href="#note-about-required-arguments">SEE NOTE</a></sup> Set of Consul roles to attach to the token.
               Applicable for Vault 1.10+ with Consul 1.5+.
        :param pulumi.Input[_builtins.bool] local: Indicates that the token should not be replicated globally and instead be local to the current datacenter.
        :param pulumi.Input[_builtins.int] max_ttl: Maximum TTL for leases associated with this role, in seconds.
        :param pulumi.Input[_builtins.str] name: The name of the Consul secrets engine role to create.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] node_identities: <sup><a href="#note-about-required-arguments">SEE NOTE</a></sup> Set of Consul node
               identities to attach to the token. Applicable for Vault 1.11+ with Consul 1.8+.
        :param pulumi.Input[_builtins.str] partition: The admin partition that the token will be created in.
               Applicable for Vault 1.10+ and Consul 1.11+".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policies: The list of Consul ACL policies to associate with these roles.
               **NOTE:** The new parameter `consul_policies` should be used in favor of this. This parameter,
               `policies`, remains supported for legacy users, but Vault has deprecated this field.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] service_identities: <sup><a href="#note-about-required-arguments">SEE NOTE</a></sup> Set of Consul
               service identities to attach to the token. Applicable for Vault 1.11+ with Consul 1.5+.
        :param pulumi.Input[_builtins.int] ttl: Specifies the TTL for this role.
        """
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if consul_namespace is not None:
            pulumi.set(__self__, "consul_namespace", consul_namespace)
        if consul_policies is not None:
            pulumi.set(__self__, "consul_policies", consul_policies)
        if consul_roles is not None:
            pulumi.set(__self__, "consul_roles", consul_roles)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if node_identities is not None:
            pulumi.set(__self__, "node_identities", node_identities)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if service_identities is not None:
            pulumi.set(__self__, "service_identities", service_identities)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique name of an existing Consul secrets backend mount. Must not begin or end with a `/`. One of `path` or `backend` is required.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="consulNamespace")
    def consul_namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Consul namespace that the token will be created in.
        Applicable for Vault 1.10+ and Consul 1.7+".
        """
        return pulumi.get(self, "consul_namespace")

    @consul_namespace.setter
    def consul_namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "consul_namespace", value)

    @_builtins.property
    @pulumi.getter(name="consulPolicies")
    def consul_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        <sup><a href="#note-about-required-arguments">SEE NOTE</a></sup> The list of Consul ACL policies to associate with these roles.
        """
        return pulumi.get(self, "consul_policies")

    @consul_policies.setter
    def consul_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "consul_policies", value)

    @_builtins.property
    @pulumi.getter(name="consulRoles")
    def consul_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        <sup><a href="#note-about-required-arguments">SEE NOTE</a></sup> Set of Consul roles to attach to the token.
        Applicable for Vault 1.10+ with Consul 1.5+.
        """
        return pulumi.get(self, "consul_roles")

    @consul_roles.setter
    def consul_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "consul_roles", value)

    @_builtins.property
    @pulumi.getter
    def local(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates that the token should not be replicated globally and instead be local to the current datacenter.
        """
        return pulumi.get(self, "local")

    @local.setter
    def local(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local", value)

    @_builtins.property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum TTL for leases associated with this role, in seconds.
        """
        return pulumi.get(self, "max_ttl")

    @max_ttl.setter
    def max_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_ttl", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Consul secrets engine role to create.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="nodeIdentities")
    def node_identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        <sup><a href="#note-about-required-arguments">SEE NOTE</a></sup> Set of Consul node
        identities to attach to the token. Applicable for Vault 1.11+ with Consul 1.8+.
        """
        return pulumi.get(self, "node_identities")

    @node_identities.setter
    def node_identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "node_identities", value)

    @_builtins.property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The admin partition that the token will be created in.
        Applicable for Vault 1.10+ and Consul 1.11+".
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partition", value)

    @_builtins.property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of Consul ACL policies to associate with these roles.
        **NOTE:** The new parameter `consul_policies` should be used in favor of this. This parameter,
        `policies`, remains supported for legacy users, but Vault has deprecated this field.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "policies", value)

    @_builtins.property
    @pulumi.getter(name="serviceIdentities")
    def service_identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        <sup><a href="#note-about-required-arguments">SEE NOTE</a></sup> Set of Consul
        service identities to attach to the token. Applicable for Vault 1.11+ with Consul 1.5+.
        """
        return pulumi.get(self, "service_identities")

    @service_identities.setter
    def service_identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "service_identities", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the TTL for this role.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)


@pulumi.type_token("vault:consul/secretBackendRole:SecretBackendRole")
class SecretBackendRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 consul_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 consul_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 consul_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 node_identities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_identities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages a Consul secrets role for a Consul secrets engine in Vault. Consul secret backends can then issue Consul tokens.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        test = vault.consul.SecretBackend("test",
            path="consul",
            description="Manages the Consul backend",
            address="127.0.0.1:8500",
            token="4240861b-ce3d-8530-115a-521ff070dd29")
        example = vault.consul.SecretBackendRole("example",
            name="test-role",
            backend=test.path,
            consul_policies=["example-policy"])
        ```

        ## Note About Required Arguments

        *At least one* of the four arguments `consul_policies`, `consul_roles`, `service_identities`, or
        `node_identities` is required for a token. If desired, any combination of the four arguments up-to and
        including all four, is valid.

        ## Import

        Consul secret backend roles can be imported using the `backend`, `/roles/`, and the `name` e.g.

        ```sh
        $ pulumi import vault:consul/secretBackendRole:SecretBackendRole example consul/roles/my-role
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend: The unique name of an existing Consul secrets backend mount. Must not begin or end with a `/`. One of `path` or `backend` is required.
        :param pulumi.Input[_builtins.str] consul_namespace: The Consul namespace that the token will be created in.
               Applicable for Vault 1.10+ and Consul 1.7+".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] consul_policies: <sup><a href="#note-about-required-arguments">SEE NOTE</a></sup> The list of Consul ACL policies to associate with these roles.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] consul_roles: <sup><a href="#note-about-required-arguments">SEE NOTE</a></sup> Set of Consul roles to attach to the token.
               Applicable for Vault 1.10+ with Consul 1.5+.
        :param pulumi.Input[_builtins.bool] local: Indicates that the token should not be replicated globally and instead be local to the current datacenter.
        :param pulumi.Input[_builtins.int] max_ttl: Maximum TTL for leases associated with this role, in seconds.
        :param pulumi.Input[_builtins.str] name: The name of the Consul secrets engine role to create.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] node_identities: <sup><a href="#note-about-required-arguments">SEE NOTE</a></sup> Set of Consul node
               identities to attach to the token. Applicable for Vault 1.11+ with Consul 1.8+.
        :param pulumi.Input[_builtins.str] partition: The admin partition that the token will be created in.
               Applicable for Vault 1.10+ and Consul 1.11+".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policies: The list of Consul ACL policies to associate with these roles.
               **NOTE:** The new parameter `consul_policies` should be used in favor of this. This parameter,
               `policies`, remains supported for legacy users, but Vault has deprecated this field.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] service_identities: <sup><a href="#note-about-required-arguments">SEE NOTE</a></sup> Set of Consul
               service identities to attach to the token. Applicable for Vault 1.11+ with Consul 1.5+.
        :param pulumi.Input[_builtins.int] ttl: Specifies the TTL for this role.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SecretBackendRoleArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Consul secrets role for a Consul secrets engine in Vault. Consul secret backends can then issue Consul tokens.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        test = vault.consul.SecretBackend("test",
            path="consul",
            description="Manages the Consul backend",
            address="127.0.0.1:8500",
            token="4240861b-ce3d-8530-115a-521ff070dd29")
        example = vault.consul.SecretBackendRole("example",
            name="test-role",
            backend=test.path,
            consul_policies=["example-policy"])
        ```

        ## Note About Required Arguments

        *At least one* of the four arguments `consul_policies`, `consul_roles`, `service_identities`, or
        `node_identities` is required for a token. If desired, any combination of the four arguments up-to and
        including all four, is valid.

        ## Import

        Consul secret backend roles can be imported using the `backend`, `/roles/`, and the `name` e.g.

        ```sh
        $ pulumi import vault:consul/secretBackendRole:SecretBackendRole example consul/roles/my-role
        ```

        :param str resource_name: The name of the resource.
        :param SecretBackendRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 consul_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 consul_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 consul_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 node_identities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_identities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretBackendRoleArgs.__new__(SecretBackendRoleArgs)

            __props__.__dict__["backend"] = backend
            __props__.__dict__["consul_namespace"] = consul_namespace
            __props__.__dict__["consul_policies"] = consul_policies
            __props__.__dict__["consul_roles"] = consul_roles
            __props__.__dict__["local"] = local
            __props__.__dict__["max_ttl"] = max_ttl
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["node_identities"] = node_identities
            __props__.__dict__["partition"] = partition
            __props__.__dict__["policies"] = policies
            __props__.__dict__["service_identities"] = service_identities
            __props__.__dict__["ttl"] = ttl
        super(SecretBackendRole, __self__).__init__(
            'vault:consul/secretBackendRole:SecretBackendRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            consul_namespace: Optional[pulumi.Input[_builtins.str]] = None,
            consul_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            consul_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            local: Optional[pulumi.Input[_builtins.bool]] = None,
            max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            node_identities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            partition: Optional[pulumi.Input[_builtins.str]] = None,
            policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            service_identities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ttl: Optional[pulumi.Input[_builtins.int]] = None) -> 'SecretBackendRole':
        """
        Get an existing SecretBackendRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend: The unique name of an existing Consul secrets backend mount. Must not begin or end with a `/`. One of `path` or `backend` is required.
        :param pulumi.Input[_builtins.str] consul_namespace: The Consul namespace that the token will be created in.
               Applicable for Vault 1.10+ and Consul 1.7+".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] consul_policies: <sup><a href="#note-about-required-arguments">SEE NOTE</a></sup> The list of Consul ACL policies to associate with these roles.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] consul_roles: <sup><a href="#note-about-required-arguments">SEE NOTE</a></sup> Set of Consul roles to attach to the token.
               Applicable for Vault 1.10+ with Consul 1.5+.
        :param pulumi.Input[_builtins.bool] local: Indicates that the token should not be replicated globally and instead be local to the current datacenter.
        :param pulumi.Input[_builtins.int] max_ttl: Maximum TTL for leases associated with this role, in seconds.
        :param pulumi.Input[_builtins.str] name: The name of the Consul secrets engine role to create.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] node_identities: <sup><a href="#note-about-required-arguments">SEE NOTE</a></sup> Set of Consul node
               identities to attach to the token. Applicable for Vault 1.11+ with Consul 1.8+.
        :param pulumi.Input[_builtins.str] partition: The admin partition that the token will be created in.
               Applicable for Vault 1.10+ and Consul 1.11+".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policies: The list of Consul ACL policies to associate with these roles.
               **NOTE:** The new parameter `consul_policies` should be used in favor of this. This parameter,
               `policies`, remains supported for legacy users, but Vault has deprecated this field.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] service_identities: <sup><a href="#note-about-required-arguments">SEE NOTE</a></sup> Set of Consul
               service identities to attach to the token. Applicable for Vault 1.11+ with Consul 1.5+.
        :param pulumi.Input[_builtins.int] ttl: Specifies the TTL for this role.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretBackendRoleState.__new__(_SecretBackendRoleState)

        __props__.__dict__["backend"] = backend
        __props__.__dict__["consul_namespace"] = consul_namespace
        __props__.__dict__["consul_policies"] = consul_policies
        __props__.__dict__["consul_roles"] = consul_roles
        __props__.__dict__["local"] = local
        __props__.__dict__["max_ttl"] = max_ttl
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["node_identities"] = node_identities
        __props__.__dict__["partition"] = partition
        __props__.__dict__["policies"] = policies
        __props__.__dict__["service_identities"] = service_identities
        __props__.__dict__["ttl"] = ttl
        return SecretBackendRole(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The unique name of an existing Consul secrets backend mount. Must not begin or end with a `/`. One of `path` or `backend` is required.
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="consulNamespace")
    def consul_namespace(self) -> pulumi.Output[_builtins.str]:
        """
        The Consul namespace that the token will be created in.
        Applicable for Vault 1.10+ and Consul 1.7+".
        """
        return pulumi.get(self, "consul_namespace")

    @_builtins.property
    @pulumi.getter(name="consulPolicies")
    def consul_policies(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        <sup><a href="#note-about-required-arguments">SEE NOTE</a></sup> The list of Consul ACL policies to associate with these roles.
        """
        return pulumi.get(self, "consul_policies")

    @_builtins.property
    @pulumi.getter(name="consulRoles")
    def consul_roles(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        <sup><a href="#note-about-required-arguments">SEE NOTE</a></sup> Set of Consul roles to attach to the token.
        Applicable for Vault 1.10+ with Consul 1.5+.
        """
        return pulumi.get(self, "consul_roles")

    @_builtins.property
    @pulumi.getter
    def local(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates that the token should not be replicated globally and instead be local to the current datacenter.
        """
        return pulumi.get(self, "local")

    @_builtins.property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Maximum TTL for leases associated with this role, in seconds.
        """
        return pulumi.get(self, "max_ttl")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Consul secrets engine role to create.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="nodeIdentities")
    def node_identities(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        <sup><a href="#note-about-required-arguments">SEE NOTE</a></sup> Set of Consul node
        identities to attach to the token. Applicable for Vault 1.11+ with Consul 1.8+.
        """
        return pulumi.get(self, "node_identities")

    @_builtins.property
    @pulumi.getter
    def partition(self) -> pulumi.Output[_builtins.str]:
        """
        The admin partition that the token will be created in.
        Applicable for Vault 1.10+ and Consul 1.11+".
        """
        return pulumi.get(self, "partition")

    @_builtins.property
    @pulumi.getter
    def policies(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of Consul ACL policies to associate with these roles.
        **NOTE:** The new parameter `consul_policies` should be used in favor of this. This parameter,
        `policies`, remains supported for legacy users, but Vault has deprecated this field.
        """
        return pulumi.get(self, "policies")

    @_builtins.property
    @pulumi.getter(name="serviceIdentities")
    def service_identities(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        <sup><a href="#note-about-required-arguments">SEE NOTE</a></sup> Set of Consul
        service identities to attach to the token. Applicable for Vault 1.11+ with Consul 1.5+.
        """
        return pulumi.get(self, "service_identities")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the TTL for this role.
        """
        return pulumi.get(self, "ttl")

