# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AuthBackendArgs', 'AuthBackend']

@pulumi.input_type
class AuthBackendArgs:
    def __init__(__self__, *,
                 client_email: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_endpoint: Optional[pulumi.Input['AuthBackendCustomEndpointArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity_token_audience: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
                 tune: Optional[pulumi.Input['AuthBackendTuneArgs']] = None):
        """
        The set of arguments for constructing a AuthBackend resource.
        :param pulumi.Input[_builtins.str] client_email: The clients email associated with the credentials
        :param pulumi.Input[_builtins.str] client_id: The Client ID of the credentials
        :param pulumi.Input[_builtins.str] credentials: A JSON string containing the contents of a GCP credentials file. If this value is empty, Vault will try to use Application Default Credentials from the machine on which the Vault server is running.
        :param pulumi.Input['AuthBackendCustomEndpointArgs'] custom_endpoint: Specifies overrides to
               [service endpoints](https://cloud.google.com/apis/design/glossary#api_service_endpoint)
               used when making API requests. This allows specific requests made during authentication
               to target alternative service endpoints for use in [Private Google Access](https://cloud.google.com/vpc/docs/configure-private-google-access)
               environments. Requires Vault 1.11+.
               
               Overrides are set at the subdomain level using the following keys:
        :param pulumi.Input[_builtins.str] description: A description of the auth method.
        :param pulumi.Input[_builtins.bool] disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
               See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        :param pulumi.Input[_builtins.str] identity_token_audience: The audience claim value for plugin identity
               tokens. Must match an allowed audience configured for the target [Workload Identity Pool](https://cloud.google.com/iam/docs/workload-identity-federation-with-other-providers#prepare).
               Mutually exclusive with `credentials`.  Requires Vault 1.17+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] identity_token_key: The key to use for signing plugin identity
               tokens. Requires Vault 1.17+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.int] identity_token_ttl: The TTL of generated tokens.
        :param pulumi.Input[_builtins.bool] local: Specifies if the auth method is local only.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] path: The path to mount the auth method — this defaults to 'gcp'.
        :param pulumi.Input[_builtins.str] private_key_id: The ID of the private key from the credentials
        :param pulumi.Input[_builtins.str] project_id: The GCP Project ID
        :param pulumi.Input[_builtins.int] rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.int] rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] service_account_email: Service Account to impersonate for plugin workload identity federation.
               Required with `identity_token_audience`. Requires Vault 1.17+. *Available only for Vault Enterprise*.
        :param pulumi.Input['AuthBackendTuneArgs'] tune: Extra configuration block. Structure is documented below.
               
               The `tune` block is used to tune the auth backend:
        """
        if client_email is not None:
            pulumi.set(__self__, "client_email", client_email)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if custom_endpoint is not None:
            pulumi.set(__self__, "custom_endpoint", custom_endpoint)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if disable_remount is not None:
            pulumi.set(__self__, "disable_remount", disable_remount)
        if identity_token_audience is not None:
            pulumi.set(__self__, "identity_token_audience", identity_token_audience)
        if identity_token_key is not None:
            pulumi.set(__self__, "identity_token_key", identity_token_key)
        if identity_token_ttl is not None:
            pulumi.set(__self__, "identity_token_ttl", identity_token_ttl)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if private_key_id is not None:
            pulumi.set(__self__, "private_key_id", private_key_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if tune is not None:
            pulumi.set(__self__, "tune", tune)

    @_builtins.property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The clients email associated with the credentials
        """
        return pulumi.get(self, "client_email")

    @client_email.setter
    def client_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_email", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Client ID of the credentials
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A JSON string containing the contents of a GCP credentials file. If this value is empty, Vault will try to use Application Default Credentials from the machine on which the Vault server is running.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter(name="customEndpoint")
    def custom_endpoint(self) -> Optional[pulumi.Input['AuthBackendCustomEndpointArgs']]:
        """
        Specifies overrides to
        [service endpoints](https://cloud.google.com/apis/design/glossary#api_service_endpoint)
        used when making API requests. This allows specific requests made during authentication
        to target alternative service endpoints for use in [Private Google Access](https://cloud.google.com/vpc/docs/configure-private-google-access)
        environments. Requires Vault 1.11+.

        Overrides are set at the subdomain level using the following keys:
        """
        return pulumi.get(self, "custom_endpoint")

    @custom_endpoint.setter
    def custom_endpoint(self, value: Optional[pulumi.Input['AuthBackendCustomEndpointArgs']]):
        pulumi.set(self, "custom_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the auth method.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "disable_automated_rotation")

    @disable_automated_rotation.setter
    def disable_automated_rotation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_automated_rotation", value)

    @_builtins.property
    @pulumi.getter(name="disableRemount")
    def disable_remount(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, opts out of mount migration on path updates.
        See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        """
        return pulumi.get(self, "disable_remount")

    @disable_remount.setter
    def disable_remount(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_remount", value)

    @_builtins.property
    @pulumi.getter(name="identityTokenAudience")
    def identity_token_audience(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The audience claim value for plugin identity
        tokens. Must match an allowed audience configured for the target [Workload Identity Pool](https://cloud.google.com/iam/docs/workload-identity-federation-with-other-providers#prepare).
        Mutually exclusive with `credentials`.  Requires Vault 1.17+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "identity_token_audience")

    @identity_token_audience.setter
    def identity_token_audience(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_token_audience", value)

    @_builtins.property
    @pulumi.getter(name="identityTokenKey")
    def identity_token_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key to use for signing plugin identity
        tokens. Requires Vault 1.17+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "identity_token_key")

    @identity_token_key.setter
    def identity_token_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_token_key", value)

    @_builtins.property
    @pulumi.getter(name="identityTokenTtl")
    def identity_token_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The TTL of generated tokens.
        """
        return pulumi.get(self, "identity_token_ttl")

    @identity_token_ttl.setter
    def identity_token_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "identity_token_ttl", value)

    @_builtins.property
    @pulumi.getter
    def local(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the auth method is local only.
        """
        return pulumi.get(self, "local")

    @local.setter
    def local(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to mount the auth method — this defaults to 'gcp'.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyId")
    def private_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the private key from the credentials
        """
        return pulumi.get(self, "private_key_id")

    @private_key_id.setter
    def private_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GCP Project ID
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_period")

    @rotation_period.setter
    def rotation_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_period", value)

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_schedule")

    @rotation_schedule.setter
    def rotation_schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rotation_schedule", value)

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_window")

    @rotation_window.setter
    def rotation_window(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_window", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service Account to impersonate for plugin workload identity federation.
        Required with `identity_token_audience`. Requires Vault 1.17+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_email", value)

    @_builtins.property
    @pulumi.getter
    def tune(self) -> Optional[pulumi.Input['AuthBackendTuneArgs']]:
        """
        Extra configuration block. Structure is documented below.

        The `tune` block is used to tune the auth backend:
        """
        return pulumi.get(self, "tune")

    @tune.setter
    def tune(self, value: Optional[pulumi.Input['AuthBackendTuneArgs']]):
        pulumi.set(self, "tune", value)


@pulumi.input_type
class _AuthBackendState:
    def __init__(__self__, *,
                 accessor: Optional[pulumi.Input[_builtins.str]] = None,
                 client_email: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_endpoint: Optional[pulumi.Input['AuthBackendCustomEndpointArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity_token_audience: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
                 tune: Optional[pulumi.Input['AuthBackendTuneArgs']] = None):
        """
        Input properties used for looking up and filtering AuthBackend resources.
        :param pulumi.Input[_builtins.str] accessor: The mount accessor related to the auth mount. It is useful for integration with [Identity Secrets Engine](https://www.vaultproject.io/docs/secrets/identity/index.html).
        :param pulumi.Input[_builtins.str] client_email: The clients email associated with the credentials
        :param pulumi.Input[_builtins.str] client_id: The Client ID of the credentials
        :param pulumi.Input[_builtins.str] credentials: A JSON string containing the contents of a GCP credentials file. If this value is empty, Vault will try to use Application Default Credentials from the machine on which the Vault server is running.
        :param pulumi.Input['AuthBackendCustomEndpointArgs'] custom_endpoint: Specifies overrides to
               [service endpoints](https://cloud.google.com/apis/design/glossary#api_service_endpoint)
               used when making API requests. This allows specific requests made during authentication
               to target alternative service endpoints for use in [Private Google Access](https://cloud.google.com/vpc/docs/configure-private-google-access)
               environments. Requires Vault 1.11+.
               
               Overrides are set at the subdomain level using the following keys:
        :param pulumi.Input[_builtins.str] description: A description of the auth method.
        :param pulumi.Input[_builtins.bool] disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
               See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        :param pulumi.Input[_builtins.str] identity_token_audience: The audience claim value for plugin identity
               tokens. Must match an allowed audience configured for the target [Workload Identity Pool](https://cloud.google.com/iam/docs/workload-identity-federation-with-other-providers#prepare).
               Mutually exclusive with `credentials`.  Requires Vault 1.17+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] identity_token_key: The key to use for signing plugin identity
               tokens. Requires Vault 1.17+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.int] identity_token_ttl: The TTL of generated tokens.
        :param pulumi.Input[_builtins.bool] local: Specifies if the auth method is local only.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] path: The path to mount the auth method — this defaults to 'gcp'.
        :param pulumi.Input[_builtins.str] private_key_id: The ID of the private key from the credentials
        :param pulumi.Input[_builtins.str] project_id: The GCP Project ID
        :param pulumi.Input[_builtins.int] rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.int] rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] service_account_email: Service Account to impersonate for plugin workload identity federation.
               Required with `identity_token_audience`. Requires Vault 1.17+. *Available only for Vault Enterprise*.
        :param pulumi.Input['AuthBackendTuneArgs'] tune: Extra configuration block. Structure is documented below.
               
               The `tune` block is used to tune the auth backend:
        """
        if accessor is not None:
            pulumi.set(__self__, "accessor", accessor)
        if client_email is not None:
            pulumi.set(__self__, "client_email", client_email)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if custom_endpoint is not None:
            pulumi.set(__self__, "custom_endpoint", custom_endpoint)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if disable_remount is not None:
            pulumi.set(__self__, "disable_remount", disable_remount)
        if identity_token_audience is not None:
            pulumi.set(__self__, "identity_token_audience", identity_token_audience)
        if identity_token_key is not None:
            pulumi.set(__self__, "identity_token_key", identity_token_key)
        if identity_token_ttl is not None:
            pulumi.set(__self__, "identity_token_ttl", identity_token_ttl)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if private_key_id is not None:
            pulumi.set(__self__, "private_key_id", private_key_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if tune is not None:
            pulumi.set(__self__, "tune", tune)

    @_builtins.property
    @pulumi.getter
    def accessor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mount accessor related to the auth mount. It is useful for integration with [Identity Secrets Engine](https://www.vaultproject.io/docs/secrets/identity/index.html).
        """
        return pulumi.get(self, "accessor")

    @accessor.setter
    def accessor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accessor", value)

    @_builtins.property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The clients email associated with the credentials
        """
        return pulumi.get(self, "client_email")

    @client_email.setter
    def client_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_email", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Client ID of the credentials
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A JSON string containing the contents of a GCP credentials file. If this value is empty, Vault will try to use Application Default Credentials from the machine on which the Vault server is running.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter(name="customEndpoint")
    def custom_endpoint(self) -> Optional[pulumi.Input['AuthBackendCustomEndpointArgs']]:
        """
        Specifies overrides to
        [service endpoints](https://cloud.google.com/apis/design/glossary#api_service_endpoint)
        used when making API requests. This allows specific requests made during authentication
        to target alternative service endpoints for use in [Private Google Access](https://cloud.google.com/vpc/docs/configure-private-google-access)
        environments. Requires Vault 1.11+.

        Overrides are set at the subdomain level using the following keys:
        """
        return pulumi.get(self, "custom_endpoint")

    @custom_endpoint.setter
    def custom_endpoint(self, value: Optional[pulumi.Input['AuthBackendCustomEndpointArgs']]):
        pulumi.set(self, "custom_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the auth method.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "disable_automated_rotation")

    @disable_automated_rotation.setter
    def disable_automated_rotation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_automated_rotation", value)

    @_builtins.property
    @pulumi.getter(name="disableRemount")
    def disable_remount(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, opts out of mount migration on path updates.
        See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        """
        return pulumi.get(self, "disable_remount")

    @disable_remount.setter
    def disable_remount(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_remount", value)

    @_builtins.property
    @pulumi.getter(name="identityTokenAudience")
    def identity_token_audience(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The audience claim value for plugin identity
        tokens. Must match an allowed audience configured for the target [Workload Identity Pool](https://cloud.google.com/iam/docs/workload-identity-federation-with-other-providers#prepare).
        Mutually exclusive with `credentials`.  Requires Vault 1.17+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "identity_token_audience")

    @identity_token_audience.setter
    def identity_token_audience(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_token_audience", value)

    @_builtins.property
    @pulumi.getter(name="identityTokenKey")
    def identity_token_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key to use for signing plugin identity
        tokens. Requires Vault 1.17+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "identity_token_key")

    @identity_token_key.setter
    def identity_token_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_token_key", value)

    @_builtins.property
    @pulumi.getter(name="identityTokenTtl")
    def identity_token_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The TTL of generated tokens.
        """
        return pulumi.get(self, "identity_token_ttl")

    @identity_token_ttl.setter
    def identity_token_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "identity_token_ttl", value)

    @_builtins.property
    @pulumi.getter
    def local(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the auth method is local only.
        """
        return pulumi.get(self, "local")

    @local.setter
    def local(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to mount the auth method — this defaults to 'gcp'.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyId")
    def private_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the private key from the credentials
        """
        return pulumi.get(self, "private_key_id")

    @private_key_id.setter
    def private_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GCP Project ID
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_period")

    @rotation_period.setter
    def rotation_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_period", value)

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_schedule")

    @rotation_schedule.setter
    def rotation_schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rotation_schedule", value)

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_window")

    @rotation_window.setter
    def rotation_window(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_window", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service Account to impersonate for plugin workload identity federation.
        Required with `identity_token_audience`. Requires Vault 1.17+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_email", value)

    @_builtins.property
    @pulumi.getter
    def tune(self) -> Optional[pulumi.Input['AuthBackendTuneArgs']]:
        """
        Extra configuration block. Structure is documented below.

        The `tune` block is used to tune the auth backend:
        """
        return pulumi.get(self, "tune")

    @tune.setter
    def tune(self, value: Optional[pulumi.Input['AuthBackendTuneArgs']]):
        pulumi.set(self, "tune", value)


@pulumi.type_token("vault:gcp/authBackend:AuthBackend")
class AuthBackend(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_email: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_endpoint: Optional[pulumi.Input[Union['AuthBackendCustomEndpointArgs', 'AuthBackendCustomEndpointArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity_token_audience: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
                 tune: Optional[pulumi.Input[Union['AuthBackendTuneArgs', 'AuthBackendTuneArgsDict']]] = None,
                 __props__=None):
        """
        Provides a resource to configure the [GCP auth backend within Vault](https://www.vaultproject.io/docs/auth/gcp.html).

        ## Example Usage

        You can setup the GCP auth backend with Workload Identity Federation (WIF) for a secret-less configuration:
        ```python
        import pulumi
        import pulumi_vault as vault

        gcp = vault.gcp.AuthBackend("gcp",
            identity_token_key="example-key",
            identity_token_ttl=1800,
            identity_token_audience="<TOKEN_AUDIENCE>",
            service_account_email="<SERVICE_ACCOUNT_EMAIL>",
            rotation_schedule="0 * * * SAT",
            rotation_window=3600)
        ```

        ## Import

        GCP authentication backends can be imported using the backend name, e.g.

        ```sh
        $ pulumi import vault:gcp/authBackend:AuthBackend gcp gcp
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] client_email: The clients email associated with the credentials
        :param pulumi.Input[_builtins.str] client_id: The Client ID of the credentials
        :param pulumi.Input[_builtins.str] credentials: A JSON string containing the contents of a GCP credentials file. If this value is empty, Vault will try to use Application Default Credentials from the machine on which the Vault server is running.
        :param pulumi.Input[Union['AuthBackendCustomEndpointArgs', 'AuthBackendCustomEndpointArgsDict']] custom_endpoint: Specifies overrides to
               [service endpoints](https://cloud.google.com/apis/design/glossary#api_service_endpoint)
               used when making API requests. This allows specific requests made during authentication
               to target alternative service endpoints for use in [Private Google Access](https://cloud.google.com/vpc/docs/configure-private-google-access)
               environments. Requires Vault 1.11+.
               
               Overrides are set at the subdomain level using the following keys:
        :param pulumi.Input[_builtins.str] description: A description of the auth method.
        :param pulumi.Input[_builtins.bool] disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
               See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        :param pulumi.Input[_builtins.str] identity_token_audience: The audience claim value for plugin identity
               tokens. Must match an allowed audience configured for the target [Workload Identity Pool](https://cloud.google.com/iam/docs/workload-identity-federation-with-other-providers#prepare).
               Mutually exclusive with `credentials`.  Requires Vault 1.17+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] identity_token_key: The key to use for signing plugin identity
               tokens. Requires Vault 1.17+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.int] identity_token_ttl: The TTL of generated tokens.
        :param pulumi.Input[_builtins.bool] local: Specifies if the auth method is local only.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] path: The path to mount the auth method — this defaults to 'gcp'.
        :param pulumi.Input[_builtins.str] private_key_id: The ID of the private key from the credentials
        :param pulumi.Input[_builtins.str] project_id: The GCP Project ID
        :param pulumi.Input[_builtins.int] rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.int] rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] service_account_email: Service Account to impersonate for plugin workload identity federation.
               Required with `identity_token_audience`. Requires Vault 1.17+. *Available only for Vault Enterprise*.
        :param pulumi.Input[Union['AuthBackendTuneArgs', 'AuthBackendTuneArgsDict']] tune: Extra configuration block. Structure is documented below.
               
               The `tune` block is used to tune the auth backend:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AuthBackendArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to configure the [GCP auth backend within Vault](https://www.vaultproject.io/docs/auth/gcp.html).

        ## Example Usage

        You can setup the GCP auth backend with Workload Identity Federation (WIF) for a secret-less configuration:
        ```python
        import pulumi
        import pulumi_vault as vault

        gcp = vault.gcp.AuthBackend("gcp",
            identity_token_key="example-key",
            identity_token_ttl=1800,
            identity_token_audience="<TOKEN_AUDIENCE>",
            service_account_email="<SERVICE_ACCOUNT_EMAIL>",
            rotation_schedule="0 * * * SAT",
            rotation_window=3600)
        ```

        ## Import

        GCP authentication backends can be imported using the backend name, e.g.

        ```sh
        $ pulumi import vault:gcp/authBackend:AuthBackend gcp gcp
        ```

        :param str resource_name: The name of the resource.
        :param AuthBackendArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthBackendArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_email: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_endpoint: Optional[pulumi.Input[Union['AuthBackendCustomEndpointArgs', 'AuthBackendCustomEndpointArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity_token_audience: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
                 tune: Optional[pulumi.Input[Union['AuthBackendTuneArgs', 'AuthBackendTuneArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthBackendArgs.__new__(AuthBackendArgs)

            __props__.__dict__["client_email"] = client_email
            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["credentials"] = None if credentials is None else pulumi.Output.secret(credentials)
            __props__.__dict__["custom_endpoint"] = custom_endpoint
            __props__.__dict__["description"] = description
            __props__.__dict__["disable_automated_rotation"] = disable_automated_rotation
            __props__.__dict__["disable_remount"] = disable_remount
            __props__.__dict__["identity_token_audience"] = identity_token_audience
            __props__.__dict__["identity_token_key"] = identity_token_key
            __props__.__dict__["identity_token_ttl"] = identity_token_ttl
            __props__.__dict__["local"] = local
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["path"] = path
            __props__.__dict__["private_key_id"] = private_key_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["rotation_period"] = rotation_period
            __props__.__dict__["rotation_schedule"] = rotation_schedule
            __props__.__dict__["rotation_window"] = rotation_window
            __props__.__dict__["service_account_email"] = service_account_email
            __props__.__dict__["tune"] = tune
            __props__.__dict__["accessor"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["credentials"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AuthBackend, __self__).__init__(
            'vault:gcp/authBackend:AuthBackend',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accessor: Optional[pulumi.Input[_builtins.str]] = None,
            client_email: Optional[pulumi.Input[_builtins.str]] = None,
            client_id: Optional[pulumi.Input[_builtins.str]] = None,
            credentials: Optional[pulumi.Input[_builtins.str]] = None,
            custom_endpoint: Optional[pulumi.Input[Union['AuthBackendCustomEndpointArgs', 'AuthBackendCustomEndpointArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
            disable_remount: Optional[pulumi.Input[_builtins.bool]] = None,
            identity_token_audience: Optional[pulumi.Input[_builtins.str]] = None,
            identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
            identity_token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            local: Optional[pulumi.Input[_builtins.bool]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            path: Optional[pulumi.Input[_builtins.str]] = None,
            private_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
            rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
            rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
            service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
            tune: Optional[pulumi.Input[Union['AuthBackendTuneArgs', 'AuthBackendTuneArgsDict']]] = None) -> 'AuthBackend':
        """
        Get an existing AuthBackend resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accessor: The mount accessor related to the auth mount. It is useful for integration with [Identity Secrets Engine](https://www.vaultproject.io/docs/secrets/identity/index.html).
        :param pulumi.Input[_builtins.str] client_email: The clients email associated with the credentials
        :param pulumi.Input[_builtins.str] client_id: The Client ID of the credentials
        :param pulumi.Input[_builtins.str] credentials: A JSON string containing the contents of a GCP credentials file. If this value is empty, Vault will try to use Application Default Credentials from the machine on which the Vault server is running.
        :param pulumi.Input[Union['AuthBackendCustomEndpointArgs', 'AuthBackendCustomEndpointArgsDict']] custom_endpoint: Specifies overrides to
               [service endpoints](https://cloud.google.com/apis/design/glossary#api_service_endpoint)
               used when making API requests. This allows specific requests made during authentication
               to target alternative service endpoints for use in [Private Google Access](https://cloud.google.com/vpc/docs/configure-private-google-access)
               environments. Requires Vault 1.11+.
               
               Overrides are set at the subdomain level using the following keys:
        :param pulumi.Input[_builtins.str] description: A description of the auth method.
        :param pulumi.Input[_builtins.bool] disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.bool] disable_remount: If set, opts out of mount migration on path updates.
               See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        :param pulumi.Input[_builtins.str] identity_token_audience: The audience claim value for plugin identity
               tokens. Must match an allowed audience configured for the target [Workload Identity Pool](https://cloud.google.com/iam/docs/workload-identity-federation-with-other-providers#prepare).
               Mutually exclusive with `credentials`.  Requires Vault 1.17+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] identity_token_key: The key to use for signing plugin identity
               tokens. Requires Vault 1.17+. *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.int] identity_token_ttl: The TTL of generated tokens.
        :param pulumi.Input[_builtins.bool] local: Specifies if the auth method is local only.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] path: The path to mount the auth method — this defaults to 'gcp'.
        :param pulumi.Input[_builtins.str] private_key_id: The ID of the private key from the credentials
        :param pulumi.Input[_builtins.str] project_id: The GCP Project ID
        :param pulumi.Input[_builtins.int] rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.int] rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        :param pulumi.Input[_builtins.str] service_account_email: Service Account to impersonate for plugin workload identity federation.
               Required with `identity_token_audience`. Requires Vault 1.17+. *Available only for Vault Enterprise*.
        :param pulumi.Input[Union['AuthBackendTuneArgs', 'AuthBackendTuneArgsDict']] tune: Extra configuration block. Structure is documented below.
               
               The `tune` block is used to tune the auth backend:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthBackendState.__new__(_AuthBackendState)

        __props__.__dict__["accessor"] = accessor
        __props__.__dict__["client_email"] = client_email
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["custom_endpoint"] = custom_endpoint
        __props__.__dict__["description"] = description
        __props__.__dict__["disable_automated_rotation"] = disable_automated_rotation
        __props__.__dict__["disable_remount"] = disable_remount
        __props__.__dict__["identity_token_audience"] = identity_token_audience
        __props__.__dict__["identity_token_key"] = identity_token_key
        __props__.__dict__["identity_token_ttl"] = identity_token_ttl
        __props__.__dict__["local"] = local
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["path"] = path
        __props__.__dict__["private_key_id"] = private_key_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["rotation_period"] = rotation_period
        __props__.__dict__["rotation_schedule"] = rotation_schedule
        __props__.__dict__["rotation_window"] = rotation_window
        __props__.__dict__["service_account_email"] = service_account_email
        __props__.__dict__["tune"] = tune
        return AuthBackend(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def accessor(self) -> pulumi.Output[_builtins.str]:
        """
        The mount accessor related to the auth mount. It is useful for integration with [Identity Secrets Engine](https://www.vaultproject.io/docs/secrets/identity/index.html).
        """
        return pulumi.get(self, "accessor")

    @_builtins.property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> pulumi.Output[_builtins.str]:
        """
        The clients email associated with the credentials
        """
        return pulumi.get(self, "client_email")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Client ID of the credentials
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A JSON string containing the contents of a GCP credentials file. If this value is empty, Vault will try to use Application Default Credentials from the machine on which the Vault server is running.
        """
        return pulumi.get(self, "credentials")

    @_builtins.property
    @pulumi.getter(name="customEndpoint")
    def custom_endpoint(self) -> pulumi.Output[Optional['outputs.AuthBackendCustomEndpoint']]:
        """
        Specifies overrides to
        [service endpoints](https://cloud.google.com/apis/design/glossary#api_service_endpoint)
        used when making API requests. This allows specific requests made during authentication
        to target alternative service endpoints for use in [Private Google Access](https://cloud.google.com/vpc/docs/configure-private-google-access)
        environments. Requires Vault 1.11+.

        Overrides are set at the subdomain level using the following keys:
        """
        return pulumi.get(self, "custom_endpoint")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description of the auth method.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "disable_automated_rotation")

    @_builtins.property
    @pulumi.getter(name="disableRemount")
    def disable_remount(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set, opts out of mount migration on path updates.
        See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        """
        return pulumi.get(self, "disable_remount")

    @_builtins.property
    @pulumi.getter(name="identityTokenAudience")
    def identity_token_audience(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The audience claim value for plugin identity
        tokens. Must match an allowed audience configured for the target [Workload Identity Pool](https://cloud.google.com/iam/docs/workload-identity-federation-with-other-providers#prepare).
        Mutually exclusive with `credentials`.  Requires Vault 1.17+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "identity_token_audience")

    @_builtins.property
    @pulumi.getter(name="identityTokenKey")
    def identity_token_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The key to use for signing plugin identity
        tokens. Requires Vault 1.17+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "identity_token_key")

    @_builtins.property
    @pulumi.getter(name="identityTokenTtl")
    def identity_token_ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The TTL of generated tokens.
        """
        return pulumi.get(self, "identity_token_ttl")

    @_builtins.property
    @pulumi.getter
    def local(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if the auth method is local only.
        """
        return pulumi.get(self, "local")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The path to mount the auth method — this defaults to 'gcp'.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="privateKeyId")
    def private_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the private key from the credentials
        """
        return pulumi.get(self, "private_key_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The GCP Project ID
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_period")

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_schedule")

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        """
        return pulumi.get(self, "rotation_window")

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Service Account to impersonate for plugin workload identity federation.
        Required with `identity_token_audience`. Requires Vault 1.17+. *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "service_account_email")

    @_builtins.property
    @pulumi.getter
    def tune(self) -> pulumi.Output['outputs.AuthBackendTune']:
        """
        Extra configuration block. Structure is documented below.

        The `tune` block is used to tune the auth backend:
        """
        return pulumi.get(self, "tune")

