# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SecretBackendArgs', 'SecretBackend']

@pulumi.input_type
class SecretBackendArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[_builtins.str],
                 allowed_managed_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_request_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_response_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 delegated_auth_accessors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_local_ca_jwt: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_entropy_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_host: Optional[pulumi.Input[_builtins.str]] = None,
                 listing_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 passthrough_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 plugin_version: Optional[pulumi.Input[_builtins.str]] = None,
                 seal_wrap: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_account_jwt: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SecretBackend resource.
        :param pulumi.Input[_builtins.str] path: Where the secret backend will be mounted
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_managed_keys: List of managed key registry entry names that the mount in question is allowed to access
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_response_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_request_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_response_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        :param pulumi.Input[_builtins.int] default_lease_ttl_seconds: Default lease duration for tokens and secrets in seconds
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegated_auth_accessors: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] description: Human-friendly description of the mount
        :param pulumi.Input[_builtins.bool] disable_local_ca_jwt: Disable defaulting to the local CA certificate and 
               service account JWT when Vault is running in a Kubernetes pod.
        :param pulumi.Input[_builtins.bool] external_entropy_access: Enable the secrets engine to access Vault's external entropy source
        :param pulumi.Input[_builtins.str] identity_token_key: The key to use for signing plugin workload identity tokens
        :param pulumi.Input[_builtins.str] kubernetes_ca_cert: A PEM-encoded CA certificate used by the 
               secrets engine to verify the Kubernetes API server certificate. Defaults to the local
               pod’s CA if Vault is running in Kubernetes. Otherwise, defaults to the root CA set where
               Vault is running.
        :param pulumi.Input[_builtins.str] kubernetes_host: The Kubernetes API URL to connect to. Required if the 
               standard pod environment variables `KUBERNETES_SERVICE_HOST` or `KUBERNETES_SERVICE_PORT`
               are not set on the host that Vault is running on.
        :param pulumi.Input[_builtins.str] listing_visibility: Specifies whether to show this mount in the UI-specific listing endpoint
        :param pulumi.Input[_builtins.bool] local: Local mount flag that can be explicitly set to true to enforce local mount in HA environment
        :param pulumi.Input[_builtins.int] max_lease_ttl_seconds: Maximum possible lease duration for tokens and secrets in seconds
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] options: Specifies mount type specific options that are passed to the backend
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] passthrough_request_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] plugin_version: Specifies the semantic version of the plugin to use, e.g. 'v1.0.0'
        :param pulumi.Input[_builtins.bool] seal_wrap: Enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        :param pulumi.Input[_builtins.str] service_account_jwt: The JSON web token of the service account used by the
               secrets engine to manage Kubernetes credentials. Defaults to the local pod’s JWT if Vault
               is running in Kubernetes.
        """
        pulumi.set(__self__, "path", path)
        if allowed_managed_keys is not None:
            pulumi.set(__self__, "allowed_managed_keys", allowed_managed_keys)
        if allowed_response_headers is not None:
            pulumi.set(__self__, "allowed_response_headers", allowed_response_headers)
        if audit_non_hmac_request_keys is not None:
            pulumi.set(__self__, "audit_non_hmac_request_keys", audit_non_hmac_request_keys)
        if audit_non_hmac_response_keys is not None:
            pulumi.set(__self__, "audit_non_hmac_response_keys", audit_non_hmac_response_keys)
        if default_lease_ttl_seconds is not None:
            pulumi.set(__self__, "default_lease_ttl_seconds", default_lease_ttl_seconds)
        if delegated_auth_accessors is not None:
            pulumi.set(__self__, "delegated_auth_accessors", delegated_auth_accessors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_ca_jwt is not None:
            pulumi.set(__self__, "disable_local_ca_jwt", disable_local_ca_jwt)
        if external_entropy_access is not None:
            pulumi.set(__self__, "external_entropy_access", external_entropy_access)
        if identity_token_key is not None:
            pulumi.set(__self__, "identity_token_key", identity_token_key)
        if kubernetes_ca_cert is not None:
            pulumi.set(__self__, "kubernetes_ca_cert", kubernetes_ca_cert)
        if kubernetes_host is not None:
            pulumi.set(__self__, "kubernetes_host", kubernetes_host)
        if listing_visibility is not None:
            pulumi.set(__self__, "listing_visibility", listing_visibility)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if max_lease_ttl_seconds is not None:
            pulumi.set(__self__, "max_lease_ttl_seconds", max_lease_ttl_seconds)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if passthrough_request_headers is not None:
            pulumi.set(__self__, "passthrough_request_headers", passthrough_request_headers)
        if plugin_version is not None:
            pulumi.set(__self__, "plugin_version", plugin_version)
        if seal_wrap is not None:
            pulumi.set(__self__, "seal_wrap", seal_wrap)
        if service_account_jwt is not None:
            pulumi.set(__self__, "service_account_jwt", service_account_jwt)

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Input[_builtins.str]:
        """
        Where the secret backend will be mounted
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="allowedManagedKeys")
    def allowed_managed_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of managed key registry entry names that the mount in question is allowed to access
        """
        return pulumi.get(self, "allowed_managed_keys")

    @allowed_managed_keys.setter
    def allowed_managed_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_managed_keys", value)

    @_builtins.property
    @pulumi.getter(name="allowedResponseHeaders")
    def allowed_response_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "allowed_response_headers")

    @allowed_response_headers.setter
    def allowed_response_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_response_headers", value)

    @_builtins.property
    @pulumi.getter(name="auditNonHmacRequestKeys")
    def audit_non_hmac_request_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        """
        return pulumi.get(self, "audit_non_hmac_request_keys")

    @audit_non_hmac_request_keys.setter
    def audit_non_hmac_request_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "audit_non_hmac_request_keys", value)

    @_builtins.property
    @pulumi.getter(name="auditNonHmacResponseKeys")
    def audit_non_hmac_response_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        """
        return pulumi.get(self, "audit_non_hmac_response_keys")

    @audit_non_hmac_response_keys.setter
    def audit_non_hmac_response_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "audit_non_hmac_response_keys", value)

    @_builtins.property
    @pulumi.getter(name="defaultLeaseTtlSeconds")
    def default_lease_ttl_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Default lease duration for tokens and secrets in seconds
        """
        return pulumi.get(self, "default_lease_ttl_seconds")

    @default_lease_ttl_seconds.setter
    def default_lease_ttl_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_lease_ttl_seconds", value)

    @_builtins.property
    @pulumi.getter(name="delegatedAuthAccessors")
    def delegated_auth_accessors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "delegated_auth_accessors")

    @delegated_auth_accessors.setter
    def delegated_auth_accessors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "delegated_auth_accessors", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-friendly description of the mount
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableLocalCaJwt")
    def disable_local_ca_jwt(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disable defaulting to the local CA certificate and 
        service account JWT when Vault is running in a Kubernetes pod.
        """
        return pulumi.get(self, "disable_local_ca_jwt")

    @disable_local_ca_jwt.setter
    def disable_local_ca_jwt(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_local_ca_jwt", value)

    @_builtins.property
    @pulumi.getter(name="externalEntropyAccess")
    def external_entropy_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the secrets engine to access Vault's external entropy source
        """
        return pulumi.get(self, "external_entropy_access")

    @external_entropy_access.setter
    def external_entropy_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "external_entropy_access", value)

    @_builtins.property
    @pulumi.getter(name="identityTokenKey")
    def identity_token_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key to use for signing plugin workload identity tokens
        """
        return pulumi.get(self, "identity_token_key")

    @identity_token_key.setter
    def identity_token_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_token_key", value)

    @_builtins.property
    @pulumi.getter(name="kubernetesCaCert")
    def kubernetes_ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A PEM-encoded CA certificate used by the 
        secrets engine to verify the Kubernetes API server certificate. Defaults to the local
        pod’s CA if Vault is running in Kubernetes. Otherwise, defaults to the root CA set where
        Vault is running.
        """
        return pulumi.get(self, "kubernetes_ca_cert")

    @kubernetes_ca_cert.setter
    def kubernetes_ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kubernetes_ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="kubernetesHost")
    def kubernetes_host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Kubernetes API URL to connect to. Required if the 
        standard pod environment variables `KUBERNETES_SERVICE_HOST` or `KUBERNETES_SERVICE_PORT`
        are not set on the host that Vault is running on.
        """
        return pulumi.get(self, "kubernetes_host")

    @kubernetes_host.setter
    def kubernetes_host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kubernetes_host", value)

    @_builtins.property
    @pulumi.getter(name="listingVisibility")
    def listing_visibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to show this mount in the UI-specific listing endpoint
        """
        return pulumi.get(self, "listing_visibility")

    @listing_visibility.setter
    def listing_visibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listing_visibility", value)

    @_builtins.property
    @pulumi.getter
    def local(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Local mount flag that can be explicitly set to true to enforce local mount in HA environment
        """
        return pulumi.get(self, "local")

    @local.setter
    def local(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local", value)

    @_builtins.property
    @pulumi.getter(name="maxLeaseTtlSeconds")
    def max_lease_ttl_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum possible lease duration for tokens and secrets in seconds
        """
        return pulumi.get(self, "max_lease_ttl_seconds")

    @max_lease_ttl_seconds.setter
    def max_lease_ttl_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_lease_ttl_seconds", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies mount type specific options that are passed to the backend
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter(name="passthroughRequestHeaders")
    def passthrough_request_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "passthrough_request_headers")

    @passthrough_request_headers.setter
    def passthrough_request_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "passthrough_request_headers", value)

    @_builtins.property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the semantic version of the plugin to use, e.g. 'v1.0.0'
        """
        return pulumi.get(self, "plugin_version")

    @plugin_version.setter
    def plugin_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugin_version", value)

    @_builtins.property
    @pulumi.getter(name="sealWrap")
    def seal_wrap(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        """
        return pulumi.get(self, "seal_wrap")

    @seal_wrap.setter
    def seal_wrap(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "seal_wrap", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountJwt")
    def service_account_jwt(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The JSON web token of the service account used by the
        secrets engine to manage Kubernetes credentials. Defaults to the local pod’s JWT if Vault
        is running in Kubernetes.
        """
        return pulumi.get(self, "service_account_jwt")

    @service_account_jwt.setter
    def service_account_jwt(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_jwt", value)


@pulumi.input_type
class _SecretBackendState:
    def __init__(__self__, *,
                 accessor: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_managed_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_request_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_response_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 delegated_auth_accessors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_local_ca_jwt: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_entropy_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_host: Optional[pulumi.Input[_builtins.str]] = None,
                 listing_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 passthrough_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_version: Optional[pulumi.Input[_builtins.str]] = None,
                 seal_wrap: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_account_jwt: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecretBackend resources.
        :param pulumi.Input[_builtins.str] accessor: Accessor of the mount
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_managed_keys: List of managed key registry entry names that the mount in question is allowed to access
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_response_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_request_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_response_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        :param pulumi.Input[_builtins.int] default_lease_ttl_seconds: Default lease duration for tokens and secrets in seconds
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegated_auth_accessors: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] description: Human-friendly description of the mount
        :param pulumi.Input[_builtins.bool] disable_local_ca_jwt: Disable defaulting to the local CA certificate and 
               service account JWT when Vault is running in a Kubernetes pod.
        :param pulumi.Input[_builtins.bool] external_entropy_access: Enable the secrets engine to access Vault's external entropy source
        :param pulumi.Input[_builtins.str] identity_token_key: The key to use for signing plugin workload identity tokens
        :param pulumi.Input[_builtins.str] kubernetes_ca_cert: A PEM-encoded CA certificate used by the 
               secrets engine to verify the Kubernetes API server certificate. Defaults to the local
               pod’s CA if Vault is running in Kubernetes. Otherwise, defaults to the root CA set where
               Vault is running.
        :param pulumi.Input[_builtins.str] kubernetes_host: The Kubernetes API URL to connect to. Required if the 
               standard pod environment variables `KUBERNETES_SERVICE_HOST` or `KUBERNETES_SERVICE_PORT`
               are not set on the host that Vault is running on.
        :param pulumi.Input[_builtins.str] listing_visibility: Specifies whether to show this mount in the UI-specific listing endpoint
        :param pulumi.Input[_builtins.bool] local: Local mount flag that can be explicitly set to true to enforce local mount in HA environment
        :param pulumi.Input[_builtins.int] max_lease_ttl_seconds: Maximum possible lease duration for tokens and secrets in seconds
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] options: Specifies mount type specific options that are passed to the backend
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] passthrough_request_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] path: Where the secret backend will be mounted
        :param pulumi.Input[_builtins.str] plugin_version: Specifies the semantic version of the plugin to use, e.g. 'v1.0.0'
        :param pulumi.Input[_builtins.bool] seal_wrap: Enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        :param pulumi.Input[_builtins.str] service_account_jwt: The JSON web token of the service account used by the
               secrets engine to manage Kubernetes credentials. Defaults to the local pod’s JWT if Vault
               is running in Kubernetes.
        """
        if accessor is not None:
            pulumi.set(__self__, "accessor", accessor)
        if allowed_managed_keys is not None:
            pulumi.set(__self__, "allowed_managed_keys", allowed_managed_keys)
        if allowed_response_headers is not None:
            pulumi.set(__self__, "allowed_response_headers", allowed_response_headers)
        if audit_non_hmac_request_keys is not None:
            pulumi.set(__self__, "audit_non_hmac_request_keys", audit_non_hmac_request_keys)
        if audit_non_hmac_response_keys is not None:
            pulumi.set(__self__, "audit_non_hmac_response_keys", audit_non_hmac_response_keys)
        if default_lease_ttl_seconds is not None:
            pulumi.set(__self__, "default_lease_ttl_seconds", default_lease_ttl_seconds)
        if delegated_auth_accessors is not None:
            pulumi.set(__self__, "delegated_auth_accessors", delegated_auth_accessors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_ca_jwt is not None:
            pulumi.set(__self__, "disable_local_ca_jwt", disable_local_ca_jwt)
        if external_entropy_access is not None:
            pulumi.set(__self__, "external_entropy_access", external_entropy_access)
        if identity_token_key is not None:
            pulumi.set(__self__, "identity_token_key", identity_token_key)
        if kubernetes_ca_cert is not None:
            pulumi.set(__self__, "kubernetes_ca_cert", kubernetes_ca_cert)
        if kubernetes_host is not None:
            pulumi.set(__self__, "kubernetes_host", kubernetes_host)
        if listing_visibility is not None:
            pulumi.set(__self__, "listing_visibility", listing_visibility)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if max_lease_ttl_seconds is not None:
            pulumi.set(__self__, "max_lease_ttl_seconds", max_lease_ttl_seconds)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if passthrough_request_headers is not None:
            pulumi.set(__self__, "passthrough_request_headers", passthrough_request_headers)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if plugin_version is not None:
            pulumi.set(__self__, "plugin_version", plugin_version)
        if seal_wrap is not None:
            pulumi.set(__self__, "seal_wrap", seal_wrap)
        if service_account_jwt is not None:
            pulumi.set(__self__, "service_account_jwt", service_account_jwt)

    @_builtins.property
    @pulumi.getter
    def accessor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Accessor of the mount
        """
        return pulumi.get(self, "accessor")

    @accessor.setter
    def accessor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accessor", value)

    @_builtins.property
    @pulumi.getter(name="allowedManagedKeys")
    def allowed_managed_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of managed key registry entry names that the mount in question is allowed to access
        """
        return pulumi.get(self, "allowed_managed_keys")

    @allowed_managed_keys.setter
    def allowed_managed_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_managed_keys", value)

    @_builtins.property
    @pulumi.getter(name="allowedResponseHeaders")
    def allowed_response_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "allowed_response_headers")

    @allowed_response_headers.setter
    def allowed_response_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_response_headers", value)

    @_builtins.property
    @pulumi.getter(name="auditNonHmacRequestKeys")
    def audit_non_hmac_request_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        """
        return pulumi.get(self, "audit_non_hmac_request_keys")

    @audit_non_hmac_request_keys.setter
    def audit_non_hmac_request_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "audit_non_hmac_request_keys", value)

    @_builtins.property
    @pulumi.getter(name="auditNonHmacResponseKeys")
    def audit_non_hmac_response_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        """
        return pulumi.get(self, "audit_non_hmac_response_keys")

    @audit_non_hmac_response_keys.setter
    def audit_non_hmac_response_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "audit_non_hmac_response_keys", value)

    @_builtins.property
    @pulumi.getter(name="defaultLeaseTtlSeconds")
    def default_lease_ttl_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Default lease duration for tokens and secrets in seconds
        """
        return pulumi.get(self, "default_lease_ttl_seconds")

    @default_lease_ttl_seconds.setter
    def default_lease_ttl_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_lease_ttl_seconds", value)

    @_builtins.property
    @pulumi.getter(name="delegatedAuthAccessors")
    def delegated_auth_accessors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "delegated_auth_accessors")

    @delegated_auth_accessors.setter
    def delegated_auth_accessors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "delegated_auth_accessors", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-friendly description of the mount
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableLocalCaJwt")
    def disable_local_ca_jwt(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disable defaulting to the local CA certificate and 
        service account JWT when Vault is running in a Kubernetes pod.
        """
        return pulumi.get(self, "disable_local_ca_jwt")

    @disable_local_ca_jwt.setter
    def disable_local_ca_jwt(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_local_ca_jwt", value)

    @_builtins.property
    @pulumi.getter(name="externalEntropyAccess")
    def external_entropy_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the secrets engine to access Vault's external entropy source
        """
        return pulumi.get(self, "external_entropy_access")

    @external_entropy_access.setter
    def external_entropy_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "external_entropy_access", value)

    @_builtins.property
    @pulumi.getter(name="identityTokenKey")
    def identity_token_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key to use for signing plugin workload identity tokens
        """
        return pulumi.get(self, "identity_token_key")

    @identity_token_key.setter
    def identity_token_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_token_key", value)

    @_builtins.property
    @pulumi.getter(name="kubernetesCaCert")
    def kubernetes_ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A PEM-encoded CA certificate used by the 
        secrets engine to verify the Kubernetes API server certificate. Defaults to the local
        pod’s CA if Vault is running in Kubernetes. Otherwise, defaults to the root CA set where
        Vault is running.
        """
        return pulumi.get(self, "kubernetes_ca_cert")

    @kubernetes_ca_cert.setter
    def kubernetes_ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kubernetes_ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="kubernetesHost")
    def kubernetes_host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Kubernetes API URL to connect to. Required if the 
        standard pod environment variables `KUBERNETES_SERVICE_HOST` or `KUBERNETES_SERVICE_PORT`
        are not set on the host that Vault is running on.
        """
        return pulumi.get(self, "kubernetes_host")

    @kubernetes_host.setter
    def kubernetes_host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kubernetes_host", value)

    @_builtins.property
    @pulumi.getter(name="listingVisibility")
    def listing_visibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to show this mount in the UI-specific listing endpoint
        """
        return pulumi.get(self, "listing_visibility")

    @listing_visibility.setter
    def listing_visibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listing_visibility", value)

    @_builtins.property
    @pulumi.getter
    def local(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Local mount flag that can be explicitly set to true to enforce local mount in HA environment
        """
        return pulumi.get(self, "local")

    @local.setter
    def local(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local", value)

    @_builtins.property
    @pulumi.getter(name="maxLeaseTtlSeconds")
    def max_lease_ttl_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum possible lease duration for tokens and secrets in seconds
        """
        return pulumi.get(self, "max_lease_ttl_seconds")

    @max_lease_ttl_seconds.setter
    def max_lease_ttl_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_lease_ttl_seconds", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies mount type specific options that are passed to the backend
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter(name="passthroughRequestHeaders")
    def passthrough_request_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "passthrough_request_headers")

    @passthrough_request_headers.setter
    def passthrough_request_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "passthrough_request_headers", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Where the secret backend will be mounted
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the semantic version of the plugin to use, e.g. 'v1.0.0'
        """
        return pulumi.get(self, "plugin_version")

    @plugin_version.setter
    def plugin_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugin_version", value)

    @_builtins.property
    @pulumi.getter(name="sealWrap")
    def seal_wrap(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        """
        return pulumi.get(self, "seal_wrap")

    @seal_wrap.setter
    def seal_wrap(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "seal_wrap", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountJwt")
    def service_account_jwt(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The JSON web token of the service account used by the
        secrets engine to manage Kubernetes credentials. Defaults to the local pod’s JWT if Vault
        is running in Kubernetes.
        """
        return pulumi.get(self, "service_account_jwt")

    @service_account_jwt.setter
    def service_account_jwt(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_jwt", value)


@pulumi.type_token("vault:kubernetes/secretBackend:SecretBackend")
class SecretBackend(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_managed_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_request_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_response_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 delegated_auth_accessors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_local_ca_jwt: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_entropy_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_host: Optional[pulumi.Input[_builtins.str]] = None,
                 listing_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 passthrough_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_version: Optional[pulumi.Input[_builtins.str]] = None,
                 seal_wrap: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_account_jwt: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_std as std
        import pulumi_vault as vault

        config = vault.kubernetes.SecretBackend("config",
            path="kubernetes",
            description="kubernetes secrets engine description",
            default_lease_ttl_seconds=43200,
            max_lease_ttl_seconds=86400,
            kubernetes_host="https://127.0.0.1:61233",
            kubernetes_ca_cert=std.file(input="/path/to/cert").result,
            service_account_jwt=std.file(input="/path/to/token").result,
            disable_local_ca_jwt=False)
        ```

        ## Import

        The Kubernetes secret backend can be imported using its `path` e.g.

        ```sh
        $ pulumi import vault:kubernetes/secretBackend:SecretBackend config kubernetes
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_managed_keys: List of managed key registry entry names that the mount in question is allowed to access
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_response_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_request_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_response_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        :param pulumi.Input[_builtins.int] default_lease_ttl_seconds: Default lease duration for tokens and secrets in seconds
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegated_auth_accessors: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] description: Human-friendly description of the mount
        :param pulumi.Input[_builtins.bool] disable_local_ca_jwt: Disable defaulting to the local CA certificate and 
               service account JWT when Vault is running in a Kubernetes pod.
        :param pulumi.Input[_builtins.bool] external_entropy_access: Enable the secrets engine to access Vault's external entropy source
        :param pulumi.Input[_builtins.str] identity_token_key: The key to use for signing plugin workload identity tokens
        :param pulumi.Input[_builtins.str] kubernetes_ca_cert: A PEM-encoded CA certificate used by the 
               secrets engine to verify the Kubernetes API server certificate. Defaults to the local
               pod’s CA if Vault is running in Kubernetes. Otherwise, defaults to the root CA set where
               Vault is running.
        :param pulumi.Input[_builtins.str] kubernetes_host: The Kubernetes API URL to connect to. Required if the 
               standard pod environment variables `KUBERNETES_SERVICE_HOST` or `KUBERNETES_SERVICE_PORT`
               are not set on the host that Vault is running on.
        :param pulumi.Input[_builtins.str] listing_visibility: Specifies whether to show this mount in the UI-specific listing endpoint
        :param pulumi.Input[_builtins.bool] local: Local mount flag that can be explicitly set to true to enforce local mount in HA environment
        :param pulumi.Input[_builtins.int] max_lease_ttl_seconds: Maximum possible lease duration for tokens and secrets in seconds
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] options: Specifies mount type specific options that are passed to the backend
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] passthrough_request_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] path: Where the secret backend will be mounted
        :param pulumi.Input[_builtins.str] plugin_version: Specifies the semantic version of the plugin to use, e.g. 'v1.0.0'
        :param pulumi.Input[_builtins.bool] seal_wrap: Enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        :param pulumi.Input[_builtins.str] service_account_jwt: The JSON web token of the service account used by the
               secrets engine to manage Kubernetes credentials. Defaults to the local pod’s JWT if Vault
               is running in Kubernetes.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretBackendArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_std as std
        import pulumi_vault as vault

        config = vault.kubernetes.SecretBackend("config",
            path="kubernetes",
            description="kubernetes secrets engine description",
            default_lease_ttl_seconds=43200,
            max_lease_ttl_seconds=86400,
            kubernetes_host="https://127.0.0.1:61233",
            kubernetes_ca_cert=std.file(input="/path/to/cert").result,
            service_account_jwt=std.file(input="/path/to/token").result,
            disable_local_ca_jwt=False)
        ```

        ## Import

        The Kubernetes secret backend can be imported using its `path` e.g.

        ```sh
        $ pulumi import vault:kubernetes/secretBackend:SecretBackend config kubernetes
        ```

        :param str resource_name: The name of the resource.
        :param SecretBackendArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_managed_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_request_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_non_hmac_response_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 delegated_auth_accessors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_local_ca_jwt: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_entropy_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_host: Optional[pulumi.Input[_builtins.str]] = None,
                 listing_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 local: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 passthrough_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_version: Optional[pulumi.Input[_builtins.str]] = None,
                 seal_wrap: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_account_jwt: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretBackendArgs.__new__(SecretBackendArgs)

            __props__.__dict__["allowed_managed_keys"] = allowed_managed_keys
            __props__.__dict__["allowed_response_headers"] = allowed_response_headers
            __props__.__dict__["audit_non_hmac_request_keys"] = audit_non_hmac_request_keys
            __props__.__dict__["audit_non_hmac_response_keys"] = audit_non_hmac_response_keys
            __props__.__dict__["default_lease_ttl_seconds"] = default_lease_ttl_seconds
            __props__.__dict__["delegated_auth_accessors"] = delegated_auth_accessors
            __props__.__dict__["description"] = description
            __props__.__dict__["disable_local_ca_jwt"] = disable_local_ca_jwt
            __props__.__dict__["external_entropy_access"] = external_entropy_access
            __props__.__dict__["identity_token_key"] = identity_token_key
            __props__.__dict__["kubernetes_ca_cert"] = kubernetes_ca_cert
            __props__.__dict__["kubernetes_host"] = kubernetes_host
            __props__.__dict__["listing_visibility"] = listing_visibility
            __props__.__dict__["local"] = local
            __props__.__dict__["max_lease_ttl_seconds"] = max_lease_ttl_seconds
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["options"] = options
            __props__.__dict__["passthrough_request_headers"] = passthrough_request_headers
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            __props__.__dict__["plugin_version"] = plugin_version
            __props__.__dict__["seal_wrap"] = seal_wrap
            __props__.__dict__["service_account_jwt"] = None if service_account_jwt is None else pulumi.Output.secret(service_account_jwt)
            __props__.__dict__["accessor"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["serviceAccountJwt"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SecretBackend, __self__).__init__(
            'vault:kubernetes/secretBackend:SecretBackend',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accessor: Optional[pulumi.Input[_builtins.str]] = None,
            allowed_managed_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            allowed_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            audit_non_hmac_request_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            audit_non_hmac_response_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            default_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            delegated_auth_accessors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disable_local_ca_jwt: Optional[pulumi.Input[_builtins.bool]] = None,
            external_entropy_access: Optional[pulumi.Input[_builtins.bool]] = None,
            identity_token_key: Optional[pulumi.Input[_builtins.str]] = None,
            kubernetes_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
            kubernetes_host: Optional[pulumi.Input[_builtins.str]] = None,
            listing_visibility: Optional[pulumi.Input[_builtins.str]] = None,
            local: Optional[pulumi.Input[_builtins.bool]] = None,
            max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            passthrough_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            path: Optional[pulumi.Input[_builtins.str]] = None,
            plugin_version: Optional[pulumi.Input[_builtins.str]] = None,
            seal_wrap: Optional[pulumi.Input[_builtins.bool]] = None,
            service_account_jwt: Optional[pulumi.Input[_builtins.str]] = None) -> 'SecretBackend':
        """
        Get an existing SecretBackend resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accessor: Accessor of the mount
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_managed_keys: List of managed key registry entry names that the mount in question is allowed to access
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_response_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_request_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_non_hmac_response_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        :param pulumi.Input[_builtins.int] default_lease_ttl_seconds: Default lease duration for tokens and secrets in seconds
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegated_auth_accessors: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] description: Human-friendly description of the mount
        :param pulumi.Input[_builtins.bool] disable_local_ca_jwt: Disable defaulting to the local CA certificate and 
               service account JWT when Vault is running in a Kubernetes pod.
        :param pulumi.Input[_builtins.bool] external_entropy_access: Enable the secrets engine to access Vault's external entropy source
        :param pulumi.Input[_builtins.str] identity_token_key: The key to use for signing plugin workload identity tokens
        :param pulumi.Input[_builtins.str] kubernetes_ca_cert: A PEM-encoded CA certificate used by the 
               secrets engine to verify the Kubernetes API server certificate. Defaults to the local
               pod’s CA if Vault is running in Kubernetes. Otherwise, defaults to the root CA set where
               Vault is running.
        :param pulumi.Input[_builtins.str] kubernetes_host: The Kubernetes API URL to connect to. Required if the 
               standard pod environment variables `KUBERNETES_SERVICE_HOST` or `KUBERNETES_SERVICE_PORT`
               are not set on the host that Vault is running on.
        :param pulumi.Input[_builtins.str] listing_visibility: Specifies whether to show this mount in the UI-specific listing endpoint
        :param pulumi.Input[_builtins.bool] local: Local mount flag that can be explicitly set to true to enforce local mount in HA environment
        :param pulumi.Input[_builtins.int] max_lease_ttl_seconds: Maximum possible lease duration for tokens and secrets in seconds
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] options: Specifies mount type specific options that are passed to the backend
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] passthrough_request_headers: List of headers to allow and pass from the request to the plugin
        :param pulumi.Input[_builtins.str] path: Where the secret backend will be mounted
        :param pulumi.Input[_builtins.str] plugin_version: Specifies the semantic version of the plugin to use, e.g. 'v1.0.0'
        :param pulumi.Input[_builtins.bool] seal_wrap: Enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        :param pulumi.Input[_builtins.str] service_account_jwt: The JSON web token of the service account used by the
               secrets engine to manage Kubernetes credentials. Defaults to the local pod’s JWT if Vault
               is running in Kubernetes.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretBackendState.__new__(_SecretBackendState)

        __props__.__dict__["accessor"] = accessor
        __props__.__dict__["allowed_managed_keys"] = allowed_managed_keys
        __props__.__dict__["allowed_response_headers"] = allowed_response_headers
        __props__.__dict__["audit_non_hmac_request_keys"] = audit_non_hmac_request_keys
        __props__.__dict__["audit_non_hmac_response_keys"] = audit_non_hmac_response_keys
        __props__.__dict__["default_lease_ttl_seconds"] = default_lease_ttl_seconds
        __props__.__dict__["delegated_auth_accessors"] = delegated_auth_accessors
        __props__.__dict__["description"] = description
        __props__.__dict__["disable_local_ca_jwt"] = disable_local_ca_jwt
        __props__.__dict__["external_entropy_access"] = external_entropy_access
        __props__.__dict__["identity_token_key"] = identity_token_key
        __props__.__dict__["kubernetes_ca_cert"] = kubernetes_ca_cert
        __props__.__dict__["kubernetes_host"] = kubernetes_host
        __props__.__dict__["listing_visibility"] = listing_visibility
        __props__.__dict__["local"] = local
        __props__.__dict__["max_lease_ttl_seconds"] = max_lease_ttl_seconds
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["options"] = options
        __props__.__dict__["passthrough_request_headers"] = passthrough_request_headers
        __props__.__dict__["path"] = path
        __props__.__dict__["plugin_version"] = plugin_version
        __props__.__dict__["seal_wrap"] = seal_wrap
        __props__.__dict__["service_account_jwt"] = service_account_jwt
        return SecretBackend(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def accessor(self) -> pulumi.Output[_builtins.str]:
        """
        Accessor of the mount
        """
        return pulumi.get(self, "accessor")

    @_builtins.property
    @pulumi.getter(name="allowedManagedKeys")
    def allowed_managed_keys(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of managed key registry entry names that the mount in question is allowed to access
        """
        return pulumi.get(self, "allowed_managed_keys")

    @_builtins.property
    @pulumi.getter(name="allowedResponseHeaders")
    def allowed_response_headers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "allowed_response_headers")

    @_builtins.property
    @pulumi.getter(name="auditNonHmacRequestKeys")
    def audit_non_hmac_request_keys(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        """
        return pulumi.get(self, "audit_non_hmac_request_keys")

    @_builtins.property
    @pulumi.getter(name="auditNonHmacResponseKeys")
    def audit_non_hmac_response_keys(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        """
        return pulumi.get(self, "audit_non_hmac_response_keys")

    @_builtins.property
    @pulumi.getter(name="defaultLeaseTtlSeconds")
    def default_lease_ttl_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        Default lease duration for tokens and secrets in seconds
        """
        return pulumi.get(self, "default_lease_ttl_seconds")

    @_builtins.property
    @pulumi.getter(name="delegatedAuthAccessors")
    def delegated_auth_accessors(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "delegated_auth_accessors")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Human-friendly description of the mount
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="disableLocalCaJwt")
    def disable_local_ca_jwt(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Disable defaulting to the local CA certificate and 
        service account JWT when Vault is running in a Kubernetes pod.
        """
        return pulumi.get(self, "disable_local_ca_jwt")

    @_builtins.property
    @pulumi.getter(name="externalEntropyAccess")
    def external_entropy_access(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable the secrets engine to access Vault's external entropy source
        """
        return pulumi.get(self, "external_entropy_access")

    @_builtins.property
    @pulumi.getter(name="identityTokenKey")
    def identity_token_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The key to use for signing plugin workload identity tokens
        """
        return pulumi.get(self, "identity_token_key")

    @_builtins.property
    @pulumi.getter(name="kubernetesCaCert")
    def kubernetes_ca_cert(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A PEM-encoded CA certificate used by the 
        secrets engine to verify the Kubernetes API server certificate. Defaults to the local
        pod’s CA if Vault is running in Kubernetes. Otherwise, defaults to the root CA set where
        Vault is running.
        """
        return pulumi.get(self, "kubernetes_ca_cert")

    @_builtins.property
    @pulumi.getter(name="kubernetesHost")
    def kubernetes_host(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Kubernetes API URL to connect to. Required if the 
        standard pod environment variables `KUBERNETES_SERVICE_HOST` or `KUBERNETES_SERVICE_PORT`
        are not set on the host that Vault is running on.
        """
        return pulumi.get(self, "kubernetes_host")

    @_builtins.property
    @pulumi.getter(name="listingVisibility")
    def listing_visibility(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether to show this mount in the UI-specific listing endpoint
        """
        return pulumi.get(self, "listing_visibility")

    @_builtins.property
    @pulumi.getter
    def local(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Local mount flag that can be explicitly set to true to enforce local mount in HA environment
        """
        return pulumi.get(self, "local")

    @_builtins.property
    @pulumi.getter(name="maxLeaseTtlSeconds")
    def max_lease_ttl_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        Maximum possible lease duration for tokens and secrets in seconds
        """
        return pulumi.get(self, "max_lease_ttl_seconds")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies mount type specific options that are passed to the backend
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter(name="passthroughRequestHeaders")
    def passthrough_request_headers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of headers to allow and pass from the request to the plugin
        """
        return pulumi.get(self, "passthrough_request_headers")

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Output[_builtins.str]:
        """
        Where the secret backend will be mounted
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the semantic version of the plugin to use, e.g. 'v1.0.0'
        """
        return pulumi.get(self, "plugin_version")

    @_builtins.property
    @pulumi.getter(name="sealWrap")
    def seal_wrap(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        """
        return pulumi.get(self, "seal_wrap")

    @_builtins.property
    @pulumi.getter(name="serviceAccountJwt")
    def service_account_jwt(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The JSON web token of the service account used by the
        secrets engine to manage Kubernetes credentials. Defaults to the local pod’s JWT if Vault
        is running in Kubernetes.
        """
        return pulumi.get(self, "service_account_jwt")

