# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SecretArgs', 'Secret']

@pulumi.input_type
class SecretArgs:
    def __init__(__self__, *,
                 data_json: pulumi.Input[_builtins.str],
                 path: pulumi.Input[_builtins.str],
                 namespace: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Secret resource.
        :param pulumi.Input[_builtins.str] data_json: JSON-encoded string that will be
               written as the secret data at the given path.
        :param pulumi.Input[_builtins.str] path: Full path of the KV-V1 secret.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        """
        pulumi.set(__self__, "data_json", data_json)
        pulumi.set(__self__, "path", path)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter(name="dataJson")
    def data_json(self) -> pulumi.Input[_builtins.str]:
        """
        JSON-encoded string that will be
        written as the secret data at the given path.
        """
        return pulumi.get(self, "data_json")

    @data_json.setter
    def data_json(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_json", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Input[_builtins.str]:
        """
        Full path of the KV-V1 secret.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class _SecretState:
    def __init__(__self__, *,
                 data: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 data_json: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Secret resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] data: A mapping whose keys are the top-level data keys returned from
               Vault and whose values are the corresponding values. This map can only
               represent string data, so any non-string values returned from Vault are
               serialized as JSON.
        :param pulumi.Input[_builtins.str] data_json: JSON-encoded string that will be
               written as the secret data at the given path.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] path: Full path of the KV-V1 secret.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)
        if data_json is not None:
            pulumi.set(__self__, "data_json", data_json)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping whose keys are the top-level data keys returned from
        Vault and whose values are the corresponding values. This map can only
        represent string data, so any non-string values returned from Vault are
        serialized as JSON.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "data", value)

    @_builtins.property
    @pulumi.getter(name="dataJson")
    def data_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON-encoded string that will be
        written as the secret data at the given path.
        """
        return pulumi.get(self, "data_json")

    @data_json.setter
    def data_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_json", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Full path of the KV-V1 secret.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)


@pulumi.type_token("vault:kv/secret:Secret")
class Secret(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_json: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Writes a KV-V1 secret to a given path in Vault.

        For more information on Vault's KV-V1 secret backend
        [see here](https://www.vaultproject.io/docs/secrets/kv/kv-v1).

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_vault as vault

        kvv1 = vault.Mount("kvv1",
            path="kvv1",
            type="kv",
            options={
                "version": "1",
            },
            description="KV Version 1 secret engine mount")
        secret = vault.kv.Secret("secret",
            path=kvv1.path.apply(lambda path: f"{path}/secret"),
            data_json=json.dumps({
                "zip": "zap",
                "foo": "bar",
            }))
        ```

        ## Required Vault Capabilities

        Use of this resource requires the `create` or `update` capability
        (depending on whether the resource already exists) on the given path,
        the `delete` capability if the resource is removed from configuration,
        and the `read` capability for drift detection (by default).

        ## Import

        KV-V1 secrets can be imported using the `path`, e.g.

        ```sh
        $ pulumi import vault:kv/secret:Secret secret kvv1/secret
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data_json: JSON-encoded string that will be
               written as the secret data at the given path.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] path: Full path of the KV-V1 secret.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Writes a KV-V1 secret to a given path in Vault.

        For more information on Vault's KV-V1 secret backend
        [see here](https://www.vaultproject.io/docs/secrets/kv/kv-v1).

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_vault as vault

        kvv1 = vault.Mount("kvv1",
            path="kvv1",
            type="kv",
            options={
                "version": "1",
            },
            description="KV Version 1 secret engine mount")
        secret = vault.kv.Secret("secret",
            path=kvv1.path.apply(lambda path: f"{path}/secret"),
            data_json=json.dumps({
                "zip": "zap",
                "foo": "bar",
            }))
        ```

        ## Required Vault Capabilities

        Use of this resource requires the `create` or `update` capability
        (depending on whether the resource already exists) on the given path,
        the `delete` capability if the resource is removed from configuration,
        and the `read` capability for drift detection (by default).

        ## Import

        KV-V1 secrets can be imported using the `path`, e.g.

        ```sh
        $ pulumi import vault:kv/secret:Secret secret kvv1/secret
        ```

        :param str resource_name: The name of the resource.
        :param SecretArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_json: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretArgs.__new__(SecretArgs)

            if data_json is None and not opts.urn:
                raise TypeError("Missing required property 'data_json'")
            __props__.__dict__["data_json"] = None if data_json is None else pulumi.Output.secret(data_json)
            __props__.__dict__["namespace"] = namespace
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            __props__.__dict__["data"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["data", "dataJson"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Secret, __self__).__init__(
            'vault:kv/secret:Secret',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            data: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            data_json: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            path: Optional[pulumi.Input[_builtins.str]] = None) -> 'Secret':
        """
        Get an existing Secret resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] data: A mapping whose keys are the top-level data keys returned from
               Vault and whose values are the corresponding values. This map can only
               represent string data, so any non-string values returned from Vault are
               serialized as JSON.
        :param pulumi.Input[_builtins.str] data_json: JSON-encoded string that will be
               written as the secret data at the given path.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] path: Full path of the KV-V1 secret.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretState.__new__(_SecretState)

        __props__.__dict__["data"] = data
        __props__.__dict__["data_json"] = data_json
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["path"] = path
        return Secret(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def data(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A mapping whose keys are the top-level data keys returned from
        Vault and whose values are the corresponding values. This map can only
        represent string data, so any non-string values returned from Vault are
        serialized as JSON.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="dataJson")
    def data_json(self) -> pulumi.Output[_builtins.str]:
        """
        JSON-encoded string that will be
        written as the secret data at the given path.
        """
        return pulumi.get(self, "data_json")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Output[_builtins.str]:
        """
        Full path of the KV-V1 secret.
        """
        return pulumi.get(self, "path")

