# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'KeysAw',
    'KeysAzure',
    'KeysPkc',
]

@pulumi.output_type
class KeysAw(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "keyBits":
            suggest = "key_bits"
        elif key == "keyType":
            suggest = "key_type"
        elif key == "kmsKey":
            suggest = "kms_key"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "allowGenerateKey":
            suggest = "allow_generate_key"
        elif key == "allowReplaceKey":
            suggest = "allow_replace_key"
        elif key == "allowStoreKey":
            suggest = "allow_store_key"
        elif key == "anyMount":
            suggest = "any_mount"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeysAw. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeysAw.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeysAw.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: _builtins.str,
                 key_bits: _builtins.str,
                 key_type: _builtins.str,
                 kms_key: _builtins.str,
                 name: _builtins.str,
                 secret_key: _builtins.str,
                 allow_generate_key: Optional[_builtins.bool] = None,
                 allow_replace_key: Optional[_builtins.bool] = None,
                 allow_store_key: Optional[_builtins.bool] = None,
                 any_mount: Optional[_builtins.bool] = None,
                 curve: Optional[_builtins.str] = None,
                 endpoint: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 uuid: Optional[_builtins.str] = None):
        """
        :param _builtins.str access_key: The AWS access key to use
        :param _builtins.str key_bits: The size in bits for an RSA key. This field is required when 'key_type' is 'RSA'
        :param _builtins.str key_type: The type of key to use
        :param _builtins.str kms_key: An identifier for the key
        :param _builtins.str name: A unique lowercase name that serves as identifying the key
        :param _builtins.str secret_key: The AWS secret key to use
        :param _builtins.bool allow_generate_key: If no existing key can be found in the referenced backend, instructs Vault to generate a key within the backend
        :param _builtins.bool allow_replace_key: Controls the ability for Vault to replace through generation or importing a key into the configured backend even if a key is present, if set to false those operations are forbidden if a key exists.
        :param _builtins.bool allow_store_key: Controls the ability for Vault to import a key to the configured backend, if 'false', those operations will be forbidden
        :param _builtins.bool any_mount: Allow usage from any mount point within the namespace if 'true'
        :param _builtins.str curve: The curve to use for an ECDSA key. Used when key_type is 'ECDSA'. Required if 'allow_generate_key' is true
        :param _builtins.str endpoint: Used to specify a custom AWS endpoint
        :param _builtins.str region: The AWS region where the keys are stored (or will be stored)
        :param _builtins.str uuid: ID of the managed key read from Vault
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "key_bits", key_bits)
        pulumi.set(__self__, "key_type", key_type)
        pulumi.set(__self__, "kms_key", kms_key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret_key", secret_key)
        if allow_generate_key is not None:
            pulumi.set(__self__, "allow_generate_key", allow_generate_key)
        if allow_replace_key is not None:
            pulumi.set(__self__, "allow_replace_key", allow_replace_key)
        if allow_store_key is not None:
            pulumi.set(__self__, "allow_store_key", allow_store_key)
        if any_mount is not None:
            pulumi.set(__self__, "any_mount", any_mount)
        if curve is not None:
            pulumi.set(__self__, "curve", curve)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> _builtins.str:
        """
        The AWS access key to use
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter(name="keyBits")
    def key_bits(self) -> _builtins.str:
        """
        The size in bits for an RSA key. This field is required when 'key_type' is 'RSA'
        """
        return pulumi.get(self, "key_bits")

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> _builtins.str:
        """
        The type of key to use
        """
        return pulumi.get(self, "key_type")

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> _builtins.str:
        """
        An identifier for the key
        """
        return pulumi.get(self, "kms_key")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique lowercase name that serves as identifying the key
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> _builtins.str:
        """
        The AWS secret key to use
        """
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter(name="allowGenerateKey")
    def allow_generate_key(self) -> Optional[_builtins.bool]:
        """
        If no existing key can be found in the referenced backend, instructs Vault to generate a key within the backend
        """
        return pulumi.get(self, "allow_generate_key")

    @_builtins.property
    @pulumi.getter(name="allowReplaceKey")
    def allow_replace_key(self) -> Optional[_builtins.bool]:
        """
        Controls the ability for Vault to replace through generation or importing a key into the configured backend even if a key is present, if set to false those operations are forbidden if a key exists.
        """
        return pulumi.get(self, "allow_replace_key")

    @_builtins.property
    @pulumi.getter(name="allowStoreKey")
    def allow_store_key(self) -> Optional[_builtins.bool]:
        """
        Controls the ability for Vault to import a key to the configured backend, if 'false', those operations will be forbidden
        """
        return pulumi.get(self, "allow_store_key")

    @_builtins.property
    @pulumi.getter(name="anyMount")
    def any_mount(self) -> Optional[_builtins.bool]:
        """
        Allow usage from any mount point within the namespace if 'true'
        """
        return pulumi.get(self, "any_mount")

    @_builtins.property
    @pulumi.getter
    def curve(self) -> Optional[_builtins.str]:
        """
        The curve to use for an ECDSA key. Used when key_type is 'ECDSA'. Required if 'allow_generate_key' is true
        """
        return pulumi.get(self, "curve")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[_builtins.str]:
        """
        Used to specify a custom AWS endpoint
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The AWS region where the keys are stored (or will be stored)
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> Optional[_builtins.str]:
        """
        ID of the managed key read from Vault
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class KeysAzure(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "keyName":
            suggest = "key_name"
        elif key == "keyType":
            suggest = "key_type"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "vaultName":
            suggest = "vault_name"
        elif key == "allowGenerateKey":
            suggest = "allow_generate_key"
        elif key == "allowReplaceKey":
            suggest = "allow_replace_key"
        elif key == "allowStoreKey":
            suggest = "allow_store_key"
        elif key == "anyMount":
            suggest = "any_mount"
        elif key == "keyBits":
            suggest = "key_bits"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeysAzure. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeysAzure.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeysAzure.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: _builtins.str,
                 client_secret: _builtins.str,
                 key_name: _builtins.str,
                 key_type: _builtins.str,
                 name: _builtins.str,
                 tenant_id: _builtins.str,
                 vault_name: _builtins.str,
                 allow_generate_key: Optional[_builtins.bool] = None,
                 allow_replace_key: Optional[_builtins.bool] = None,
                 allow_store_key: Optional[_builtins.bool] = None,
                 any_mount: Optional[_builtins.bool] = None,
                 environment: Optional[_builtins.str] = None,
                 key_bits: Optional[_builtins.str] = None,
                 resource: Optional[_builtins.str] = None,
                 uuid: Optional[_builtins.str] = None):
        """
        :param _builtins.str client_id: The client id for credentials to query the Azure APIs
        :param _builtins.str client_secret: The client secret for credentials to query the Azure APIs
        :param _builtins.str key_name: The Key Vault key to use for encryption and decryption
        :param _builtins.str key_type: The type of key to use
        :param _builtins.str name: A unique lowercase name that serves as identifying the key
        :param _builtins.str tenant_id: The tenant id for the Azure Active Directory organization
        :param _builtins.str vault_name: The Key Vault vault to use the encryption keys for encryption and decryption
        :param _builtins.bool allow_generate_key: If no existing key can be found in the referenced backend, instructs Vault to generate a key within the backend
        :param _builtins.bool allow_replace_key: Controls the ability for Vault to replace through generation or importing a key into the configured backend even if a key is present, if set to false those operations are forbidden if a key exists.
        :param _builtins.bool allow_store_key: Controls the ability for Vault to import a key to the configured backend, if 'false', those operations will be forbidden
        :param _builtins.bool any_mount: Allow usage from any mount point within the namespace if 'true'
        :param _builtins.str environment: The Azure Cloud environment API endpoints to use
        :param _builtins.str key_bits: The size in bits for an RSA key. This field is required when 'key_type' is 'RSA' or when 'allow_generate_key' is true
        :param _builtins.str resource: The Azure Key Vault resource's DNS Suffix to connect to
        :param _builtins.str uuid: ID of the managed key read from Vault
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "key_type", key_type)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "vault_name", vault_name)
        if allow_generate_key is not None:
            pulumi.set(__self__, "allow_generate_key", allow_generate_key)
        if allow_replace_key is not None:
            pulumi.set(__self__, "allow_replace_key", allow_replace_key)
        if allow_store_key is not None:
            pulumi.set(__self__, "allow_store_key", allow_store_key)
        if any_mount is not None:
            pulumi.set(__self__, "any_mount", any_mount)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if key_bits is not None:
            pulumi.set(__self__, "key_bits", key_bits)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> _builtins.str:
        """
        The client id for credentials to query the Azure APIs
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> _builtins.str:
        """
        The client secret for credentials to query the Azure APIs
        """
        return pulumi.get(self, "client_secret")

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> _builtins.str:
        """
        The Key Vault key to use for encryption and decryption
        """
        return pulumi.get(self, "key_name")

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> _builtins.str:
        """
        The type of key to use
        """
        return pulumi.get(self, "key_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique lowercase name that serves as identifying the key
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        The tenant id for the Azure Active Directory organization
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="vaultName")
    def vault_name(self) -> _builtins.str:
        """
        The Key Vault vault to use the encryption keys for encryption and decryption
        """
        return pulumi.get(self, "vault_name")

    @_builtins.property
    @pulumi.getter(name="allowGenerateKey")
    def allow_generate_key(self) -> Optional[_builtins.bool]:
        """
        If no existing key can be found in the referenced backend, instructs Vault to generate a key within the backend
        """
        return pulumi.get(self, "allow_generate_key")

    @_builtins.property
    @pulumi.getter(name="allowReplaceKey")
    def allow_replace_key(self) -> Optional[_builtins.bool]:
        """
        Controls the ability for Vault to replace through generation or importing a key into the configured backend even if a key is present, if set to false those operations are forbidden if a key exists.
        """
        return pulumi.get(self, "allow_replace_key")

    @_builtins.property
    @pulumi.getter(name="allowStoreKey")
    def allow_store_key(self) -> Optional[_builtins.bool]:
        """
        Controls the ability for Vault to import a key to the configured backend, if 'false', those operations will be forbidden
        """
        return pulumi.get(self, "allow_store_key")

    @_builtins.property
    @pulumi.getter(name="anyMount")
    def any_mount(self) -> Optional[_builtins.bool]:
        """
        Allow usage from any mount point within the namespace if 'true'
        """
        return pulumi.get(self, "any_mount")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[_builtins.str]:
        """
        The Azure Cloud environment API endpoints to use
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter(name="keyBits")
    def key_bits(self) -> Optional[_builtins.str]:
        """
        The size in bits for an RSA key. This field is required when 'key_type' is 'RSA' or when 'allow_generate_key' is true
        """
        return pulumi.get(self, "key_bits")

    @_builtins.property
    @pulumi.getter
    def resource(self) -> Optional[_builtins.str]:
        """
        The Azure Key Vault resource's DNS Suffix to connect to
        """
        return pulumi.get(self, "resource")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> Optional[_builtins.str]:
        """
        ID of the managed key read from Vault
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class KeysPkc(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyId":
            suggest = "key_id"
        elif key == "keyLabel":
            suggest = "key_label"
        elif key == "allowGenerateKey":
            suggest = "allow_generate_key"
        elif key == "allowReplaceKey":
            suggest = "allow_replace_key"
        elif key == "allowStoreKey":
            suggest = "allow_store_key"
        elif key == "anyMount":
            suggest = "any_mount"
        elif key == "forceRwSession":
            suggest = "force_rw_session"
        elif key == "keyBits":
            suggest = "key_bits"
        elif key == "tokenLabel":
            suggest = "token_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeysPkc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeysPkc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeysPkc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_id: _builtins.str,
                 key_label: _builtins.str,
                 library: _builtins.str,
                 mechanism: _builtins.str,
                 name: _builtins.str,
                 pin: _builtins.str,
                 allow_generate_key: Optional[_builtins.bool] = None,
                 allow_replace_key: Optional[_builtins.bool] = None,
                 allow_store_key: Optional[_builtins.bool] = None,
                 any_mount: Optional[_builtins.bool] = None,
                 curve: Optional[_builtins.str] = None,
                 force_rw_session: Optional[_builtins.str] = None,
                 key_bits: Optional[_builtins.str] = None,
                 slot: Optional[_builtins.str] = None,
                 token_label: Optional[_builtins.str] = None,
                 uuid: Optional[_builtins.str] = None):
        """
        :param _builtins.str key_id: The id of a PKCS#11 key to use
        :param _builtins.str key_label: The label of the key to use
        :param _builtins.str library: The name of the kms_library stanza to use from Vault's config to lookup the local library path
        :param _builtins.str mechanism: The encryption/decryption mechanism to use, specified as a hexadecimal (prefixed by 0x) string.
        :param _builtins.str name: A unique lowercase name that serves as identifying the key
        :param _builtins.str pin: The PIN for login
        :param _builtins.bool allow_generate_key: If no existing key can be found in the referenced backend, instructs Vault to generate a key within the backend
        :param _builtins.bool allow_replace_key: Controls the ability for Vault to replace through generation or importing a key into the configured backend even if a key is present, if set to false those operations are forbidden if a key exists.
        :param _builtins.bool allow_store_key: Controls the ability for Vault to import a key to the configured backend, if 'false', those operations will be forbidden
        :param _builtins.bool any_mount: Allow usage from any mount point within the namespace if 'true'
        :param _builtins.str curve: Supplies the curve value when using the 'CKM_ECDSA' mechanism. Required if 'allow_generate_key' is true
        :param _builtins.str force_rw_session: Force all operations to open up a read-write session to the HSM
        :param _builtins.str key_bits: Supplies the size in bits of the key when using 'CKM_RSA_PKCS_PSS', 'CKM_RSA_PKCS_OAEP' or 'CKM_RSA_PKCS' as a value for 'mechanism'. Required if 'allow_generate_key' is true
        :param _builtins.str slot: The slot number to use, specified as a string in a decimal format (e.g. '2305843009213693953')
        :param _builtins.str token_label: The slot token label to use
        :param _builtins.str uuid: ID of the managed key read from Vault
        """
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "key_label", key_label)
        pulumi.set(__self__, "library", library)
        pulumi.set(__self__, "mechanism", mechanism)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "pin", pin)
        if allow_generate_key is not None:
            pulumi.set(__self__, "allow_generate_key", allow_generate_key)
        if allow_replace_key is not None:
            pulumi.set(__self__, "allow_replace_key", allow_replace_key)
        if allow_store_key is not None:
            pulumi.set(__self__, "allow_store_key", allow_store_key)
        if any_mount is not None:
            pulumi.set(__self__, "any_mount", any_mount)
        if curve is not None:
            pulumi.set(__self__, "curve", curve)
        if force_rw_session is not None:
            pulumi.set(__self__, "force_rw_session", force_rw_session)
        if key_bits is not None:
            pulumi.set(__self__, "key_bits", key_bits)
        if slot is not None:
            pulumi.set(__self__, "slot", slot)
        if token_label is not None:
            pulumi.set(__self__, "token_label", token_label)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> _builtins.str:
        """
        The id of a PKCS#11 key to use
        """
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter(name="keyLabel")
    def key_label(self) -> _builtins.str:
        """
        The label of the key to use
        """
        return pulumi.get(self, "key_label")

    @_builtins.property
    @pulumi.getter
    def library(self) -> _builtins.str:
        """
        The name of the kms_library stanza to use from Vault's config to lookup the local library path
        """
        return pulumi.get(self, "library")

    @_builtins.property
    @pulumi.getter
    def mechanism(self) -> _builtins.str:
        """
        The encryption/decryption mechanism to use, specified as a hexadecimal (prefixed by 0x) string.
        """
        return pulumi.get(self, "mechanism")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A unique lowercase name that serves as identifying the key
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def pin(self) -> _builtins.str:
        """
        The PIN for login
        """
        return pulumi.get(self, "pin")

    @_builtins.property
    @pulumi.getter(name="allowGenerateKey")
    def allow_generate_key(self) -> Optional[_builtins.bool]:
        """
        If no existing key can be found in the referenced backend, instructs Vault to generate a key within the backend
        """
        return pulumi.get(self, "allow_generate_key")

    @_builtins.property
    @pulumi.getter(name="allowReplaceKey")
    def allow_replace_key(self) -> Optional[_builtins.bool]:
        """
        Controls the ability for Vault to replace through generation or importing a key into the configured backend even if a key is present, if set to false those operations are forbidden if a key exists.
        """
        return pulumi.get(self, "allow_replace_key")

    @_builtins.property
    @pulumi.getter(name="allowStoreKey")
    def allow_store_key(self) -> Optional[_builtins.bool]:
        """
        Controls the ability for Vault to import a key to the configured backend, if 'false', those operations will be forbidden
        """
        return pulumi.get(self, "allow_store_key")

    @_builtins.property
    @pulumi.getter(name="anyMount")
    def any_mount(self) -> Optional[_builtins.bool]:
        """
        Allow usage from any mount point within the namespace if 'true'
        """
        return pulumi.get(self, "any_mount")

    @_builtins.property
    @pulumi.getter
    def curve(self) -> Optional[_builtins.str]:
        """
        Supplies the curve value when using the 'CKM_ECDSA' mechanism. Required if 'allow_generate_key' is true
        """
        return pulumi.get(self, "curve")

    @_builtins.property
    @pulumi.getter(name="forceRwSession")
    def force_rw_session(self) -> Optional[_builtins.str]:
        """
        Force all operations to open up a read-write session to the HSM
        """
        return pulumi.get(self, "force_rw_session")

    @_builtins.property
    @pulumi.getter(name="keyBits")
    def key_bits(self) -> Optional[_builtins.str]:
        """
        Supplies the size in bits of the key when using 'CKM_RSA_PKCS_PSS', 'CKM_RSA_PKCS_OAEP' or 'CKM_RSA_PKCS' as a value for 'mechanism'. Required if 'allow_generate_key' is true
        """
        return pulumi.get(self, "key_bits")

    @_builtins.property
    @pulumi.getter
    def slot(self) -> Optional[_builtins.str]:
        """
        The slot number to use, specified as a string in a decimal format (e.g. '2305843009213693953')
        """
        return pulumi.get(self, "slot")

    @_builtins.property
    @pulumi.getter(name="tokenLabel")
    def token_label(self) -> Optional[_builtins.str]:
        """
        The slot token label to use
        """
        return pulumi.get(self, "token_label")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> Optional[_builtins.str]:
        """
        ID of the managed key read from Vault
        """
        return pulumi.get(self, "uuid")


