# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AuthBackendGroupArgs',
    'AuthBackendGroupArgsDict',
    'AuthBackendUserArgs',
    'AuthBackendUserArgsDict',
]

MYPY = False

if not MYPY:
    class AuthBackendGroupArgsDict(TypedDict):
        group_name: pulumi.Input[_builtins.str]
        """
        Name of the Okta group
        """
        policies: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Policies to associate with this group
        """
elif False:
    AuthBackendGroupArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AuthBackendGroupArgs:
    def __init__(__self__, *,
                 group_name: pulumi.Input[_builtins.str],
                 policies: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        """
        :param pulumi.Input[_builtins.str] group_name: Name of the Okta group
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policies: Policies to associate with this group
        """
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "policies", policies)

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the Okta group
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_name", value)

    @_builtins.property
    @pulumi.getter
    def policies(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Policies to associate with this group
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "policies", value)


if not MYPY:
    class AuthBackendUserArgsDict(TypedDict):
        username: pulumi.Input[_builtins.str]
        """
        Name of the user within Okta
        """
        groups: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Groups within the Okta auth backend to associate with this user
        """
        policies: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Policies to associate with this user
        """
elif False:
    AuthBackendUserArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AuthBackendUserArgs:
    def __init__(__self__, *,
                 username: pulumi.Input[_builtins.str],
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] username: Name of the user within Okta
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups: Groups within the Okta auth backend to associate with this user
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policies: Policies to associate with this user
        """
        pulumi.set(__self__, "username", username)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the user within Okta
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Groups within the Okta auth backend to associate with this user
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "groups", value)

    @_builtins.property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Policies to associate with this user
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "policies", value)


