# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetBackendConfigScepResult',
    'AwaitableGetBackendConfigScepResult',
    'get_backend_config_scep',
    'get_backend_config_scep_output',
]

@pulumi.output_type
class GetBackendConfigScepResult:
    """
    A collection of values returned by getBackendConfigScep.
    """
    def __init__(__self__, allowed_digest_algorithms=None, allowed_encryption_algorithms=None, authenticators=None, backend=None, default_path_policy=None, enabled=None, external_validations=None, id=None, last_updated=None, namespace=None, restrict_ca_chain_to_issuer=None):
        if allowed_digest_algorithms and not isinstance(allowed_digest_algorithms, list):
            raise TypeError("Expected argument 'allowed_digest_algorithms' to be a list")
        pulumi.set(__self__, "allowed_digest_algorithms", allowed_digest_algorithms)
        if allowed_encryption_algorithms and not isinstance(allowed_encryption_algorithms, list):
            raise TypeError("Expected argument 'allowed_encryption_algorithms' to be a list")
        pulumi.set(__self__, "allowed_encryption_algorithms", allowed_encryption_algorithms)
        if authenticators and not isinstance(authenticators, list):
            raise TypeError("Expected argument 'authenticators' to be a list")
        pulumi.set(__self__, "authenticators", authenticators)
        if backend and not isinstance(backend, str):
            raise TypeError("Expected argument 'backend' to be a str")
        pulumi.set(__self__, "backend", backend)
        if default_path_policy and not isinstance(default_path_policy, str):
            raise TypeError("Expected argument 'default_path_policy' to be a str")
        pulumi.set(__self__, "default_path_policy", default_path_policy)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if external_validations and not isinstance(external_validations, list):
            raise TypeError("Expected argument 'external_validations' to be a list")
        pulumi.set(__self__, "external_validations", external_validations)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_updated and not isinstance(last_updated, str):
            raise TypeError("Expected argument 'last_updated' to be a str")
        pulumi.set(__self__, "last_updated", last_updated)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if restrict_ca_chain_to_issuer and not isinstance(restrict_ca_chain_to_issuer, bool):
            raise TypeError("Expected argument 'restrict_ca_chain_to_issuer' to be a bool")
        pulumi.set(__self__, "restrict_ca_chain_to_issuer", restrict_ca_chain_to_issuer)

    @_builtins.property
    @pulumi.getter(name="allowedDigestAlgorithms")
    def allowed_digest_algorithms(self) -> Sequence[_builtins.str]:
        """
        List of allowed digest algorithms for SCEP requests.
        """
        return pulumi.get(self, "allowed_digest_algorithms")

    @_builtins.property
    @pulumi.getter(name="allowedEncryptionAlgorithms")
    def allowed_encryption_algorithms(self) -> Sequence[_builtins.str]:
        """
        List of allowed encryption algorithms for SCEP requests.
        """
        return pulumi.get(self, "allowed_encryption_algorithms")

    @_builtins.property
    @pulumi.getter
    def authenticators(self) -> Sequence['outputs.GetBackendConfigScepAuthenticatorResult']:
        """
        Lists the mount accessors SCEP should delegate authentication requests towards (see below for nested schema).
        """
        return pulumi.get(self, "authenticators")

    @_builtins.property
    @pulumi.getter
    def backend(self) -> _builtins.str:
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="defaultPathPolicy")
    def default_path_policy(self) -> _builtins.str:
        """
        Specifies the policy to be used for non-role-qualified SCEP requests; valid values are 'sign-verbatim', or "role:<role_name>" to specify a role to use as this policy.
        """
        return pulumi.get(self, "default_path_policy")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Specifies whether SCEP is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="externalValidations")
    def external_validations(self) -> Sequence['outputs.GetBackendConfigScepExternalValidationResult']:
        """
        Lists the 3rd party validation of SCEP requests (see below for nested schema).
        """
        return pulumi.get(self, "external_validations")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> _builtins.str:
        """
        A read-only timestamp representing the last time the configuration was updated.
        """
        return pulumi.get(self, "last_updated")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="restrictCaChainToIssuer")
    def restrict_ca_chain_to_issuer(self) -> _builtins.bool:
        """
        If true, only return the issuer CA, otherwise the entire CA certificate chain will be returned if available from the PKI mount.
        """
        return pulumi.get(self, "restrict_ca_chain_to_issuer")


class AwaitableGetBackendConfigScepResult(GetBackendConfigScepResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBackendConfigScepResult(
            allowed_digest_algorithms=self.allowed_digest_algorithms,
            allowed_encryption_algorithms=self.allowed_encryption_algorithms,
            authenticators=self.authenticators,
            backend=self.backend,
            default_path_policy=self.default_path_policy,
            enabled=self.enabled,
            external_validations=self.external_validations,
            id=self.id,
            last_updated=self.last_updated,
            namespace=self.namespace,
            restrict_ca_chain_to_issuer=self.restrict_ca_chain_to_issuer)


def get_backend_config_scep(backend: Optional[_builtins.str] = None,
                            namespace: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBackendConfigScepResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_vault as vault

    pki = vault.Mount("pki",
        path="pki",
        type="pki",
        description="PKI secret engine mount")
    scep_config = vault.pkiSecret.get_backend_config_scep_output(backend=pki.path)
    ```


    :param _builtins.str backend: The path to the PKI secret backend to
           read the SCEP configuration from, with no leading or trailing `/`s.
    :param _builtins.str namespace: The namespace of the target resource.
           The value should not contain leading or trailing forward slashes.
           The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
           *Available only for Vault Enterprise*.
    """
    __args__ = dict()
    __args__['backend'] = backend
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vault:pkiSecret/getBackendConfigScep:getBackendConfigScep', __args__, opts=opts, typ=GetBackendConfigScepResult).value

    return AwaitableGetBackendConfigScepResult(
        allowed_digest_algorithms=pulumi.get(__ret__, 'allowed_digest_algorithms'),
        allowed_encryption_algorithms=pulumi.get(__ret__, 'allowed_encryption_algorithms'),
        authenticators=pulumi.get(__ret__, 'authenticators'),
        backend=pulumi.get(__ret__, 'backend'),
        default_path_policy=pulumi.get(__ret__, 'default_path_policy'),
        enabled=pulumi.get(__ret__, 'enabled'),
        external_validations=pulumi.get(__ret__, 'external_validations'),
        id=pulumi.get(__ret__, 'id'),
        last_updated=pulumi.get(__ret__, 'last_updated'),
        namespace=pulumi.get(__ret__, 'namespace'),
        restrict_ca_chain_to_issuer=pulumi.get(__ret__, 'restrict_ca_chain_to_issuer'))
def get_backend_config_scep_output(backend: Optional[pulumi.Input[_builtins.str]] = None,
                                   namespace: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBackendConfigScepResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_vault as vault

    pki = vault.Mount("pki",
        path="pki",
        type="pki",
        description="PKI secret engine mount")
    scep_config = vault.pkiSecret.get_backend_config_scep_output(backend=pki.path)
    ```


    :param _builtins.str backend: The path to the PKI secret backend to
           read the SCEP configuration from, with no leading or trailing `/`s.
    :param _builtins.str namespace: The namespace of the target resource.
           The value should not contain leading or trailing forward slashes.
           The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
           *Available only for Vault Enterprise*.
    """
    __args__ = dict()
    __args__['backend'] = backend
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vault:pkiSecret/getBackendConfigScep:getBackendConfigScep', __args__, opts=opts, typ=GetBackendConfigScepResult)
    return __ret__.apply(lambda __response__: GetBackendConfigScepResult(
        allowed_digest_algorithms=pulumi.get(__response__, 'allowed_digest_algorithms'),
        allowed_encryption_algorithms=pulumi.get(__response__, 'allowed_encryption_algorithms'),
        authenticators=pulumi.get(__response__, 'authenticators'),
        backend=pulumi.get(__response__, 'backend'),
        default_path_policy=pulumi.get(__response__, 'default_path_policy'),
        enabled=pulumi.get(__response__, 'enabled'),
        external_validations=pulumi.get(__response__, 'external_validations'),
        id=pulumi.get(__response__, 'id'),
        last_updated=pulumi.get(__response__, 'last_updated'),
        namespace=pulumi.get(__response__, 'namespace'),
        restrict_ca_chain_to_issuer=pulumi.get(__response__, 'restrict_ca_chain_to_issuer')))
