# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SecretBackendCrlConfigArgs', 'SecretBackendCrlConfig']

@pulumi.input_type
class SecretBackendCrlConfigArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[_builtins.str],
                 auto_rebuild: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_rebuild_grace_period: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_cluster_revocation: Optional[pulumi.Input[_builtins.bool]] = None,
                 delta_rebuild_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 disable: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_delta: Optional[pulumi.Input[_builtins.bool]] = None,
                 expiry: Optional[pulumi.Input[_builtins.str]] = None,
                 max_crl_entries: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 ocsp_disable: Optional[pulumi.Input[_builtins.bool]] = None,
                 ocsp_expiry: Optional[pulumi.Input[_builtins.str]] = None,
                 unified_crl: Optional[pulumi.Input[_builtins.bool]] = None,
                 unified_crl_on_existing_paths: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a SecretBackendCrlConfig resource.
        :param pulumi.Input[_builtins.str] backend: The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.bool] auto_rebuild: Enables periodic rebuilding of the CRL upon expiry. **Vault 1.12+**
        :param pulumi.Input[_builtins.str] auto_rebuild_grace_period: Grace period before CRL expiry to attempt rebuild of CRL. **Vault 1.12+**
        :param pulumi.Input[_builtins.bool] cross_cluster_revocation: Enable cross-cluster revocation request queues. **Vault 1.13+**
        :param pulumi.Input[_builtins.str] delta_rebuild_interval: Interval to check for new revocations on, to regenerate the delta CRL.
        :param pulumi.Input[_builtins.bool] disable: Disables or enables CRL building.
        :param pulumi.Input[_builtins.bool] enable_delta: Enables building of delta CRLs with up-to-date revocation information, 
               augmenting the last complete CRL.  **Vault 1.12+**
        :param pulumi.Input[_builtins.str] expiry: Specifies the time until expiration.
        :param pulumi.Input[_builtins.int] max_crl_entries: The maximum number of entries a CRL can contain. This option exists to prevent 
               accidental runaway issuance/revocation from overloading Vault. If set to -1, the limit is disabled. **Vault 1.19**
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.bool] ocsp_disable: Disables the OCSP responder in Vault. **Vault 1.12+**
        :param pulumi.Input[_builtins.str] ocsp_expiry: The amount of time an OCSP response can be cached for, useful for OCSP stapling 
               refresh durations. **Vault 1.12+**
        :param pulumi.Input[_builtins.bool] unified_crl: Enables unified CRL and OCSP building. **Vault 1.13+**
        :param pulumi.Input[_builtins.bool] unified_crl_on_existing_paths: Enables serving the unified CRL and OCSP on the existing, previously
               cluster-local paths. **Vault 1.13+**
        """
        pulumi.set(__self__, "backend", backend)
        if auto_rebuild is not None:
            pulumi.set(__self__, "auto_rebuild", auto_rebuild)
        if auto_rebuild_grace_period is not None:
            pulumi.set(__self__, "auto_rebuild_grace_period", auto_rebuild_grace_period)
        if cross_cluster_revocation is not None:
            pulumi.set(__self__, "cross_cluster_revocation", cross_cluster_revocation)
        if delta_rebuild_interval is not None:
            pulumi.set(__self__, "delta_rebuild_interval", delta_rebuild_interval)
        if disable is not None:
            pulumi.set(__self__, "disable", disable)
        if enable_delta is not None:
            pulumi.set(__self__, "enable_delta", enable_delta)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)
        if max_crl_entries is not None:
            pulumi.set(__self__, "max_crl_entries", max_crl_entries)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if ocsp_disable is not None:
            pulumi.set(__self__, "ocsp_disable", ocsp_disable)
        if ocsp_expiry is not None:
            pulumi.set(__self__, "ocsp_expiry", ocsp_expiry)
        if unified_crl is not None:
            pulumi.set(__self__, "unified_crl", unified_crl)
        if unified_crl_on_existing_paths is not None:
            pulumi.set(__self__, "unified_crl_on_existing_paths", unified_crl_on_existing_paths)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Input[_builtins.str]:
        """
        The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="autoRebuild")
    def auto_rebuild(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables periodic rebuilding of the CRL upon expiry. **Vault 1.12+**
        """
        return pulumi.get(self, "auto_rebuild")

    @auto_rebuild.setter
    def auto_rebuild(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_rebuild", value)

    @_builtins.property
    @pulumi.getter(name="autoRebuildGracePeriod")
    def auto_rebuild_grace_period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Grace period before CRL expiry to attempt rebuild of CRL. **Vault 1.12+**
        """
        return pulumi.get(self, "auto_rebuild_grace_period")

    @auto_rebuild_grace_period.setter
    def auto_rebuild_grace_period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_rebuild_grace_period", value)

    @_builtins.property
    @pulumi.getter(name="crossClusterRevocation")
    def cross_cluster_revocation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable cross-cluster revocation request queues. **Vault 1.13+**
        """
        return pulumi.get(self, "cross_cluster_revocation")

    @cross_cluster_revocation.setter
    def cross_cluster_revocation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cross_cluster_revocation", value)

    @_builtins.property
    @pulumi.getter(name="deltaRebuildInterval")
    def delta_rebuild_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Interval to check for new revocations on, to regenerate the delta CRL.
        """
        return pulumi.get(self, "delta_rebuild_interval")

    @delta_rebuild_interval.setter
    def delta_rebuild_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delta_rebuild_interval", value)

    @_builtins.property
    @pulumi.getter
    def disable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disables or enables CRL building.
        """
        return pulumi.get(self, "disable")

    @disable.setter
    def disable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable", value)

    @_builtins.property
    @pulumi.getter(name="enableDelta")
    def enable_delta(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables building of delta CRLs with up-to-date revocation information, 
        augmenting the last complete CRL.  **Vault 1.12+**
        """
        return pulumi.get(self, "enable_delta")

    @enable_delta.setter
    def enable_delta(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_delta", value)

    @_builtins.property
    @pulumi.getter
    def expiry(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the time until expiration.
        """
        return pulumi.get(self, "expiry")

    @expiry.setter
    def expiry(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expiry", value)

    @_builtins.property
    @pulumi.getter(name="maxCrlEntries")
    def max_crl_entries(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of entries a CRL can contain. This option exists to prevent 
        accidental runaway issuance/revocation from overloading Vault. If set to -1, the limit is disabled. **Vault 1.19**
        """
        return pulumi.get(self, "max_crl_entries")

    @max_crl_entries.setter
    def max_crl_entries(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_crl_entries", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="ocspDisable")
    def ocsp_disable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disables the OCSP responder in Vault. **Vault 1.12+**
        """
        return pulumi.get(self, "ocsp_disable")

    @ocsp_disable.setter
    def ocsp_disable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ocsp_disable", value)

    @_builtins.property
    @pulumi.getter(name="ocspExpiry")
    def ocsp_expiry(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The amount of time an OCSP response can be cached for, useful for OCSP stapling 
        refresh durations. **Vault 1.12+**
        """
        return pulumi.get(self, "ocsp_expiry")

    @ocsp_expiry.setter
    def ocsp_expiry(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ocsp_expiry", value)

    @_builtins.property
    @pulumi.getter(name="unifiedCrl")
    def unified_crl(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables unified CRL and OCSP building. **Vault 1.13+**
        """
        return pulumi.get(self, "unified_crl")

    @unified_crl.setter
    def unified_crl(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "unified_crl", value)

    @_builtins.property
    @pulumi.getter(name="unifiedCrlOnExistingPaths")
    def unified_crl_on_existing_paths(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables serving the unified CRL and OCSP on the existing, previously
        cluster-local paths. **Vault 1.13+**
        """
        return pulumi.get(self, "unified_crl_on_existing_paths")

    @unified_crl_on_existing_paths.setter
    def unified_crl_on_existing_paths(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "unified_crl_on_existing_paths", value)


@pulumi.input_type
class _SecretBackendCrlConfigState:
    def __init__(__self__, *,
                 auto_rebuild: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_rebuild_grace_period: Optional[pulumi.Input[_builtins.str]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_cluster_revocation: Optional[pulumi.Input[_builtins.bool]] = None,
                 delta_rebuild_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 disable: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_delta: Optional[pulumi.Input[_builtins.bool]] = None,
                 expiry: Optional[pulumi.Input[_builtins.str]] = None,
                 max_crl_entries: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 ocsp_disable: Optional[pulumi.Input[_builtins.bool]] = None,
                 ocsp_expiry: Optional[pulumi.Input[_builtins.str]] = None,
                 unified_crl: Optional[pulumi.Input[_builtins.bool]] = None,
                 unified_crl_on_existing_paths: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering SecretBackendCrlConfig resources.
        :param pulumi.Input[_builtins.bool] auto_rebuild: Enables periodic rebuilding of the CRL upon expiry. **Vault 1.12+**
        :param pulumi.Input[_builtins.str] auto_rebuild_grace_period: Grace period before CRL expiry to attempt rebuild of CRL. **Vault 1.12+**
        :param pulumi.Input[_builtins.str] backend: The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.bool] cross_cluster_revocation: Enable cross-cluster revocation request queues. **Vault 1.13+**
        :param pulumi.Input[_builtins.str] delta_rebuild_interval: Interval to check for new revocations on, to regenerate the delta CRL.
        :param pulumi.Input[_builtins.bool] disable: Disables or enables CRL building.
        :param pulumi.Input[_builtins.bool] enable_delta: Enables building of delta CRLs with up-to-date revocation information, 
               augmenting the last complete CRL.  **Vault 1.12+**
        :param pulumi.Input[_builtins.str] expiry: Specifies the time until expiration.
        :param pulumi.Input[_builtins.int] max_crl_entries: The maximum number of entries a CRL can contain. This option exists to prevent 
               accidental runaway issuance/revocation from overloading Vault. If set to -1, the limit is disabled. **Vault 1.19**
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.bool] ocsp_disable: Disables the OCSP responder in Vault. **Vault 1.12+**
        :param pulumi.Input[_builtins.str] ocsp_expiry: The amount of time an OCSP response can be cached for, useful for OCSP stapling 
               refresh durations. **Vault 1.12+**
        :param pulumi.Input[_builtins.bool] unified_crl: Enables unified CRL and OCSP building. **Vault 1.13+**
        :param pulumi.Input[_builtins.bool] unified_crl_on_existing_paths: Enables serving the unified CRL and OCSP on the existing, previously
               cluster-local paths. **Vault 1.13+**
        """
        if auto_rebuild is not None:
            pulumi.set(__self__, "auto_rebuild", auto_rebuild)
        if auto_rebuild_grace_period is not None:
            pulumi.set(__self__, "auto_rebuild_grace_period", auto_rebuild_grace_period)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if cross_cluster_revocation is not None:
            pulumi.set(__self__, "cross_cluster_revocation", cross_cluster_revocation)
        if delta_rebuild_interval is not None:
            pulumi.set(__self__, "delta_rebuild_interval", delta_rebuild_interval)
        if disable is not None:
            pulumi.set(__self__, "disable", disable)
        if enable_delta is not None:
            pulumi.set(__self__, "enable_delta", enable_delta)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)
        if max_crl_entries is not None:
            pulumi.set(__self__, "max_crl_entries", max_crl_entries)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if ocsp_disable is not None:
            pulumi.set(__self__, "ocsp_disable", ocsp_disable)
        if ocsp_expiry is not None:
            pulumi.set(__self__, "ocsp_expiry", ocsp_expiry)
        if unified_crl is not None:
            pulumi.set(__self__, "unified_crl", unified_crl)
        if unified_crl_on_existing_paths is not None:
            pulumi.set(__self__, "unified_crl_on_existing_paths", unified_crl_on_existing_paths)

    @_builtins.property
    @pulumi.getter(name="autoRebuild")
    def auto_rebuild(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables periodic rebuilding of the CRL upon expiry. **Vault 1.12+**
        """
        return pulumi.get(self, "auto_rebuild")

    @auto_rebuild.setter
    def auto_rebuild(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_rebuild", value)

    @_builtins.property
    @pulumi.getter(name="autoRebuildGracePeriod")
    def auto_rebuild_grace_period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Grace period before CRL expiry to attempt rebuild of CRL. **Vault 1.12+**
        """
        return pulumi.get(self, "auto_rebuild_grace_period")

    @auto_rebuild_grace_period.setter
    def auto_rebuild_grace_period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_rebuild_grace_period", value)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="crossClusterRevocation")
    def cross_cluster_revocation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable cross-cluster revocation request queues. **Vault 1.13+**
        """
        return pulumi.get(self, "cross_cluster_revocation")

    @cross_cluster_revocation.setter
    def cross_cluster_revocation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cross_cluster_revocation", value)

    @_builtins.property
    @pulumi.getter(name="deltaRebuildInterval")
    def delta_rebuild_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Interval to check for new revocations on, to regenerate the delta CRL.
        """
        return pulumi.get(self, "delta_rebuild_interval")

    @delta_rebuild_interval.setter
    def delta_rebuild_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delta_rebuild_interval", value)

    @_builtins.property
    @pulumi.getter
    def disable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disables or enables CRL building.
        """
        return pulumi.get(self, "disable")

    @disable.setter
    def disable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable", value)

    @_builtins.property
    @pulumi.getter(name="enableDelta")
    def enable_delta(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables building of delta CRLs with up-to-date revocation information, 
        augmenting the last complete CRL.  **Vault 1.12+**
        """
        return pulumi.get(self, "enable_delta")

    @enable_delta.setter
    def enable_delta(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_delta", value)

    @_builtins.property
    @pulumi.getter
    def expiry(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the time until expiration.
        """
        return pulumi.get(self, "expiry")

    @expiry.setter
    def expiry(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expiry", value)

    @_builtins.property
    @pulumi.getter(name="maxCrlEntries")
    def max_crl_entries(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of entries a CRL can contain. This option exists to prevent 
        accidental runaway issuance/revocation from overloading Vault. If set to -1, the limit is disabled. **Vault 1.19**
        """
        return pulumi.get(self, "max_crl_entries")

    @max_crl_entries.setter
    def max_crl_entries(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_crl_entries", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="ocspDisable")
    def ocsp_disable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disables the OCSP responder in Vault. **Vault 1.12+**
        """
        return pulumi.get(self, "ocsp_disable")

    @ocsp_disable.setter
    def ocsp_disable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ocsp_disable", value)

    @_builtins.property
    @pulumi.getter(name="ocspExpiry")
    def ocsp_expiry(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The amount of time an OCSP response can be cached for, useful for OCSP stapling 
        refresh durations. **Vault 1.12+**
        """
        return pulumi.get(self, "ocsp_expiry")

    @ocsp_expiry.setter
    def ocsp_expiry(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ocsp_expiry", value)

    @_builtins.property
    @pulumi.getter(name="unifiedCrl")
    def unified_crl(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables unified CRL and OCSP building. **Vault 1.13+**
        """
        return pulumi.get(self, "unified_crl")

    @unified_crl.setter
    def unified_crl(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "unified_crl", value)

    @_builtins.property
    @pulumi.getter(name="unifiedCrlOnExistingPaths")
    def unified_crl_on_existing_paths(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables serving the unified CRL and OCSP on the existing, previously
        cluster-local paths. **Vault 1.13+**
        """
        return pulumi.get(self, "unified_crl_on_existing_paths")

    @unified_crl_on_existing_paths.setter
    def unified_crl_on_existing_paths(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "unified_crl_on_existing_paths", value)


@pulumi.type_token("vault:pkiSecret/secretBackendCrlConfig:SecretBackendCrlConfig")
class SecretBackendCrlConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_rebuild: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_rebuild_grace_period: Optional[pulumi.Input[_builtins.str]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_cluster_revocation: Optional[pulumi.Input[_builtins.bool]] = None,
                 delta_rebuild_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 disable: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_delta: Optional[pulumi.Input[_builtins.bool]] = None,
                 expiry: Optional[pulumi.Input[_builtins.str]] = None,
                 max_crl_entries: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 ocsp_disable: Optional[pulumi.Input[_builtins.bool]] = None,
                 ocsp_expiry: Optional[pulumi.Input[_builtins.str]] = None,
                 unified_crl: Optional[pulumi.Input[_builtins.bool]] = None,
                 unified_crl_on_existing_paths: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Allows setting the duration for which the generated CRL should be marked valid. If the CRL is disabled, it will return a signed but zero-length CRL for any request. If enabled, it will re-build the CRL.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        pki = vault.Mount("pki",
            path="%s",
            type="pki",
            default_lease_ttl_seconds=3600,
            max_lease_ttl_seconds=86400)
        crl_config = vault.pkisecret.SecretBackendCrlConfig("crl_config",
            backend=pki.path,
            expiry="72h",
            disable=False)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_rebuild: Enables periodic rebuilding of the CRL upon expiry. **Vault 1.12+**
        :param pulumi.Input[_builtins.str] auto_rebuild_grace_period: Grace period before CRL expiry to attempt rebuild of CRL. **Vault 1.12+**
        :param pulumi.Input[_builtins.str] backend: The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.bool] cross_cluster_revocation: Enable cross-cluster revocation request queues. **Vault 1.13+**
        :param pulumi.Input[_builtins.str] delta_rebuild_interval: Interval to check for new revocations on, to regenerate the delta CRL.
        :param pulumi.Input[_builtins.bool] disable: Disables or enables CRL building.
        :param pulumi.Input[_builtins.bool] enable_delta: Enables building of delta CRLs with up-to-date revocation information, 
               augmenting the last complete CRL.  **Vault 1.12+**
        :param pulumi.Input[_builtins.str] expiry: Specifies the time until expiration.
        :param pulumi.Input[_builtins.int] max_crl_entries: The maximum number of entries a CRL can contain. This option exists to prevent 
               accidental runaway issuance/revocation from overloading Vault. If set to -1, the limit is disabled. **Vault 1.19**
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.bool] ocsp_disable: Disables the OCSP responder in Vault. **Vault 1.12+**
        :param pulumi.Input[_builtins.str] ocsp_expiry: The amount of time an OCSP response can be cached for, useful for OCSP stapling 
               refresh durations. **Vault 1.12+**
        :param pulumi.Input[_builtins.bool] unified_crl: Enables unified CRL and OCSP building. **Vault 1.13+**
        :param pulumi.Input[_builtins.bool] unified_crl_on_existing_paths: Enables serving the unified CRL and OCSP on the existing, previously
               cluster-local paths. **Vault 1.13+**
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretBackendCrlConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows setting the duration for which the generated CRL should be marked valid. If the CRL is disabled, it will return a signed but zero-length CRL for any request. If enabled, it will re-build the CRL.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        pki = vault.Mount("pki",
            path="%s",
            type="pki",
            default_lease_ttl_seconds=3600,
            max_lease_ttl_seconds=86400)
        crl_config = vault.pkisecret.SecretBackendCrlConfig("crl_config",
            backend=pki.path,
            expiry="72h",
            disable=False)
        ```

        :param str resource_name: The name of the resource.
        :param SecretBackendCrlConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendCrlConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_rebuild: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_rebuild_grace_period: Optional[pulumi.Input[_builtins.str]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_cluster_revocation: Optional[pulumi.Input[_builtins.bool]] = None,
                 delta_rebuild_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 disable: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_delta: Optional[pulumi.Input[_builtins.bool]] = None,
                 expiry: Optional[pulumi.Input[_builtins.str]] = None,
                 max_crl_entries: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 ocsp_disable: Optional[pulumi.Input[_builtins.bool]] = None,
                 ocsp_expiry: Optional[pulumi.Input[_builtins.str]] = None,
                 unified_crl: Optional[pulumi.Input[_builtins.bool]] = None,
                 unified_crl_on_existing_paths: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretBackendCrlConfigArgs.__new__(SecretBackendCrlConfigArgs)

            __props__.__dict__["auto_rebuild"] = auto_rebuild
            __props__.__dict__["auto_rebuild_grace_period"] = auto_rebuild_grace_period
            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            __props__.__dict__["cross_cluster_revocation"] = cross_cluster_revocation
            __props__.__dict__["delta_rebuild_interval"] = delta_rebuild_interval
            __props__.__dict__["disable"] = disable
            __props__.__dict__["enable_delta"] = enable_delta
            __props__.__dict__["expiry"] = expiry
            __props__.__dict__["max_crl_entries"] = max_crl_entries
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["ocsp_disable"] = ocsp_disable
            __props__.__dict__["ocsp_expiry"] = ocsp_expiry
            __props__.__dict__["unified_crl"] = unified_crl
            __props__.__dict__["unified_crl_on_existing_paths"] = unified_crl_on_existing_paths
        super(SecretBackendCrlConfig, __self__).__init__(
            'vault:pkiSecret/secretBackendCrlConfig:SecretBackendCrlConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_rebuild: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_rebuild_grace_period: Optional[pulumi.Input[_builtins.str]] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            cross_cluster_revocation: Optional[pulumi.Input[_builtins.bool]] = None,
            delta_rebuild_interval: Optional[pulumi.Input[_builtins.str]] = None,
            disable: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_delta: Optional[pulumi.Input[_builtins.bool]] = None,
            expiry: Optional[pulumi.Input[_builtins.str]] = None,
            max_crl_entries: Optional[pulumi.Input[_builtins.int]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            ocsp_disable: Optional[pulumi.Input[_builtins.bool]] = None,
            ocsp_expiry: Optional[pulumi.Input[_builtins.str]] = None,
            unified_crl: Optional[pulumi.Input[_builtins.bool]] = None,
            unified_crl_on_existing_paths: Optional[pulumi.Input[_builtins.bool]] = None) -> 'SecretBackendCrlConfig':
        """
        Get an existing SecretBackendCrlConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_rebuild: Enables periodic rebuilding of the CRL upon expiry. **Vault 1.12+**
        :param pulumi.Input[_builtins.str] auto_rebuild_grace_period: Grace period before CRL expiry to attempt rebuild of CRL. **Vault 1.12+**
        :param pulumi.Input[_builtins.str] backend: The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.bool] cross_cluster_revocation: Enable cross-cluster revocation request queues. **Vault 1.13+**
        :param pulumi.Input[_builtins.str] delta_rebuild_interval: Interval to check for new revocations on, to regenerate the delta CRL.
        :param pulumi.Input[_builtins.bool] disable: Disables or enables CRL building.
        :param pulumi.Input[_builtins.bool] enable_delta: Enables building of delta CRLs with up-to-date revocation information, 
               augmenting the last complete CRL.  **Vault 1.12+**
        :param pulumi.Input[_builtins.str] expiry: Specifies the time until expiration.
        :param pulumi.Input[_builtins.int] max_crl_entries: The maximum number of entries a CRL can contain. This option exists to prevent 
               accidental runaway issuance/revocation from overloading Vault. If set to -1, the limit is disabled. **Vault 1.19**
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.bool] ocsp_disable: Disables the OCSP responder in Vault. **Vault 1.12+**
        :param pulumi.Input[_builtins.str] ocsp_expiry: The amount of time an OCSP response can be cached for, useful for OCSP stapling 
               refresh durations. **Vault 1.12+**
        :param pulumi.Input[_builtins.bool] unified_crl: Enables unified CRL and OCSP building. **Vault 1.13+**
        :param pulumi.Input[_builtins.bool] unified_crl_on_existing_paths: Enables serving the unified CRL and OCSP on the existing, previously
               cluster-local paths. **Vault 1.13+**
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretBackendCrlConfigState.__new__(_SecretBackendCrlConfigState)

        __props__.__dict__["auto_rebuild"] = auto_rebuild
        __props__.__dict__["auto_rebuild_grace_period"] = auto_rebuild_grace_period
        __props__.__dict__["backend"] = backend
        __props__.__dict__["cross_cluster_revocation"] = cross_cluster_revocation
        __props__.__dict__["delta_rebuild_interval"] = delta_rebuild_interval
        __props__.__dict__["disable"] = disable
        __props__.__dict__["enable_delta"] = enable_delta
        __props__.__dict__["expiry"] = expiry
        __props__.__dict__["max_crl_entries"] = max_crl_entries
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["ocsp_disable"] = ocsp_disable
        __props__.__dict__["ocsp_expiry"] = ocsp_expiry
        __props__.__dict__["unified_crl"] = unified_crl
        __props__.__dict__["unified_crl_on_existing_paths"] = unified_crl_on_existing_paths
        return SecretBackendCrlConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoRebuild")
    def auto_rebuild(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enables periodic rebuilding of the CRL upon expiry. **Vault 1.12+**
        """
        return pulumi.get(self, "auto_rebuild")

    @_builtins.property
    @pulumi.getter(name="autoRebuildGracePeriod")
    def auto_rebuild_grace_period(self) -> pulumi.Output[_builtins.str]:
        """
        Grace period before CRL expiry to attempt rebuild of CRL. **Vault 1.12+**
        """
        return pulumi.get(self, "auto_rebuild_grace_period")

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[_builtins.str]:
        """
        The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="crossClusterRevocation")
    def cross_cluster_revocation(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable cross-cluster revocation request queues. **Vault 1.13+**
        """
        return pulumi.get(self, "cross_cluster_revocation")

    @_builtins.property
    @pulumi.getter(name="deltaRebuildInterval")
    def delta_rebuild_interval(self) -> pulumi.Output[_builtins.str]:
        """
        Interval to check for new revocations on, to regenerate the delta CRL.
        """
        return pulumi.get(self, "delta_rebuild_interval")

    @_builtins.property
    @pulumi.getter
    def disable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Disables or enables CRL building.
        """
        return pulumi.get(self, "disable")

    @_builtins.property
    @pulumi.getter(name="enableDelta")
    def enable_delta(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enables building of delta CRLs with up-to-date revocation information, 
        augmenting the last complete CRL.  **Vault 1.12+**
        """
        return pulumi.get(self, "enable_delta")

    @_builtins.property
    @pulumi.getter
    def expiry(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the time until expiration.
        """
        return pulumi.get(self, "expiry")

    @_builtins.property
    @pulumi.getter(name="maxCrlEntries")
    def max_crl_entries(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum number of entries a CRL can contain. This option exists to prevent 
        accidental runaway issuance/revocation from overloading Vault. If set to -1, the limit is disabled. **Vault 1.19**
        """
        return pulumi.get(self, "max_crl_entries")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="ocspDisable")
    def ocsp_disable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Disables the OCSP responder in Vault. **Vault 1.12+**
        """
        return pulumi.get(self, "ocsp_disable")

    @_builtins.property
    @pulumi.getter(name="ocspExpiry")
    def ocsp_expiry(self) -> pulumi.Output[_builtins.str]:
        """
        The amount of time an OCSP response can be cached for, useful for OCSP stapling 
        refresh durations. **Vault 1.12+**
        """
        return pulumi.get(self, "ocsp_expiry")

    @_builtins.property
    @pulumi.getter(name="unifiedCrl")
    def unified_crl(self) -> pulumi.Output[_builtins.bool]:
        """
        Enables unified CRL and OCSP building. **Vault 1.13+**
        """
        return pulumi.get(self, "unified_crl")

    @_builtins.property
    @pulumi.getter(name="unifiedCrlOnExistingPaths")
    def unified_crl_on_existing_paths(self) -> pulumi.Output[_builtins.bool]:
        """
        Enables serving the unified CRL and OCSP on the existing, previously
        cluster-local paths. **Vault 1.13+**
        """
        return pulumi.get(self, "unified_crl_on_existing_paths")

