# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SecretBackendIssuerArgs', 'SecretBackendIssuer']

@pulumi.input_type
class SecretBackendIssuerArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[_builtins.str],
                 issuer_ref: pulumi.Input[_builtins.str],
                 crl_distribution_points: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 disable_critical_extension_checks: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_name_checks: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_name_constraint_checks: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_path_length_checks: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_aia_url_templating: Optional[pulumi.Input[_builtins.bool]] = None,
                 issuer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 issuing_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 leaf_not_after_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 manual_chains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 ocsp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 revocation_signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 usage: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SecretBackendIssuer resource.
        :param pulumi.Input[_builtins.str] backend: The path the PKI secret backend is mounted at, with no
               leading or trailing `/`s.
        :param pulumi.Input[_builtins.str] issuer_ref: Reference to an existing issuer.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] crl_distribution_points: Specifies the URL values for the CRL
               Distribution Points field.
        :param pulumi.Input[_builtins.bool] disable_critical_extension_checks: This determines whether this
               issuer is able to issue certificates where the chain of trust (including the
               issued certificate) contain critical extensions not processed by Vault.
        :param pulumi.Input[_builtins.bool] disable_name_checks: This determines whether this issuer is able
               to issue certificates where the chain of trust (including the final issued
               certificate) contains a link in which the subject of the issuing certificate
               does not match the named issuer of the certificate it signed.
        :param pulumi.Input[_builtins.bool] disable_name_constraint_checks: This determines whether this
               issuer is able to issue certificates where the chain of trust (including the
               final issued certificate) violates the name constraints critical extension of
               one of the issuer certificates in the chain.
        :param pulumi.Input[_builtins.bool] disable_path_length_checks: This determines whether this issuer
               is able to issue certificates where the chain of trust (including the final
               issued certificate) is longer than allowed by a certificate authority in that
               chain.
        :param pulumi.Input[_builtins.bool] enable_aia_url_templating: Specifies that the AIA URL values should
               be templated.
        :param pulumi.Input[_builtins.str] issuer_name: Name of the issuer.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] issuing_certificates: Specifies the URL values for the Issuing
               Certificate field.
        :param pulumi.Input[_builtins.str] leaf_not_after_behavior: Behavior of a leaf's NotAfter field during
               issuance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] manual_chains: Chain of issuer references to build this issuer's
               computed CAChain field from, when non-empty.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ocsp_servers: Specifies the URL values for the OCSP Servers field.
        :param pulumi.Input[_builtins.str] revocation_signature_algorithm: Which signature algorithm to use
               when building CRLs.
        :param pulumi.Input[_builtins.str] usage: Allowed usages for this issuer.
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "issuer_ref", issuer_ref)
        if crl_distribution_points is not None:
            pulumi.set(__self__, "crl_distribution_points", crl_distribution_points)
        if disable_critical_extension_checks is not None:
            pulumi.set(__self__, "disable_critical_extension_checks", disable_critical_extension_checks)
        if disable_name_checks is not None:
            pulumi.set(__self__, "disable_name_checks", disable_name_checks)
        if disable_name_constraint_checks is not None:
            pulumi.set(__self__, "disable_name_constraint_checks", disable_name_constraint_checks)
        if disable_path_length_checks is not None:
            pulumi.set(__self__, "disable_path_length_checks", disable_path_length_checks)
        if enable_aia_url_templating is not None:
            pulumi.set(__self__, "enable_aia_url_templating", enable_aia_url_templating)
        if issuer_name is not None:
            pulumi.set(__self__, "issuer_name", issuer_name)
        if issuing_certificates is not None:
            pulumi.set(__self__, "issuing_certificates", issuing_certificates)
        if leaf_not_after_behavior is not None:
            pulumi.set(__self__, "leaf_not_after_behavior", leaf_not_after_behavior)
        if manual_chains is not None:
            pulumi.set(__self__, "manual_chains", manual_chains)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if ocsp_servers is not None:
            pulumi.set(__self__, "ocsp_servers", ocsp_servers)
        if revocation_signature_algorithm is not None:
            pulumi.set(__self__, "revocation_signature_algorithm", revocation_signature_algorithm)
        if usage is not None:
            pulumi.set(__self__, "usage", usage)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Input[_builtins.str]:
        """
        The path the PKI secret backend is mounted at, with no
        leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="issuerRef")
    def issuer_ref(self) -> pulumi.Input[_builtins.str]:
        """
        Reference to an existing issuer.
        """
        return pulumi.get(self, "issuer_ref")

    @issuer_ref.setter
    def issuer_ref(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "issuer_ref", value)

    @_builtins.property
    @pulumi.getter(name="crlDistributionPoints")
    def crl_distribution_points(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the URL values for the CRL
        Distribution Points field.
        """
        return pulumi.get(self, "crl_distribution_points")

    @crl_distribution_points.setter
    def crl_distribution_points(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "crl_distribution_points", value)

    @_builtins.property
    @pulumi.getter(name="disableCriticalExtensionChecks")
    def disable_critical_extension_checks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This determines whether this
        issuer is able to issue certificates where the chain of trust (including the
        issued certificate) contain critical extensions not processed by Vault.
        """
        return pulumi.get(self, "disable_critical_extension_checks")

    @disable_critical_extension_checks.setter
    def disable_critical_extension_checks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_critical_extension_checks", value)

    @_builtins.property
    @pulumi.getter(name="disableNameChecks")
    def disable_name_checks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This determines whether this issuer is able
        to issue certificates where the chain of trust (including the final issued
        certificate) contains a link in which the subject of the issuing certificate
        does not match the named issuer of the certificate it signed.
        """
        return pulumi.get(self, "disable_name_checks")

    @disable_name_checks.setter
    def disable_name_checks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_name_checks", value)

    @_builtins.property
    @pulumi.getter(name="disableNameConstraintChecks")
    def disable_name_constraint_checks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This determines whether this
        issuer is able to issue certificates where the chain of trust (including the
        final issued certificate) violates the name constraints critical extension of
        one of the issuer certificates in the chain.
        """
        return pulumi.get(self, "disable_name_constraint_checks")

    @disable_name_constraint_checks.setter
    def disable_name_constraint_checks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_name_constraint_checks", value)

    @_builtins.property
    @pulumi.getter(name="disablePathLengthChecks")
    def disable_path_length_checks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This determines whether this issuer
        is able to issue certificates where the chain of trust (including the final
        issued certificate) is longer than allowed by a certificate authority in that
        chain.
        """
        return pulumi.get(self, "disable_path_length_checks")

    @disable_path_length_checks.setter
    def disable_path_length_checks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_path_length_checks", value)

    @_builtins.property
    @pulumi.getter(name="enableAiaUrlTemplating")
    def enable_aia_url_templating(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies that the AIA URL values should
        be templated.
        """
        return pulumi.get(self, "enable_aia_url_templating")

    @enable_aia_url_templating.setter
    def enable_aia_url_templating(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_aia_url_templating", value)

    @_builtins.property
    @pulumi.getter(name="issuerName")
    def issuer_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the issuer.
        """
        return pulumi.get(self, "issuer_name")

    @issuer_name.setter
    def issuer_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer_name", value)

    @_builtins.property
    @pulumi.getter(name="issuingCertificates")
    def issuing_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the URL values for the Issuing
        Certificate field.
        """
        return pulumi.get(self, "issuing_certificates")

    @issuing_certificates.setter
    def issuing_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "issuing_certificates", value)

    @_builtins.property
    @pulumi.getter(name="leafNotAfterBehavior")
    def leaf_not_after_behavior(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Behavior of a leaf's NotAfter field during
        issuance.
        """
        return pulumi.get(self, "leaf_not_after_behavior")

    @leaf_not_after_behavior.setter
    def leaf_not_after_behavior(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "leaf_not_after_behavior", value)

    @_builtins.property
    @pulumi.getter(name="manualChains")
    def manual_chains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Chain of issuer references to build this issuer's
        computed CAChain field from, when non-empty.
        """
        return pulumi.get(self, "manual_chains")

    @manual_chains.setter
    def manual_chains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "manual_chains", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="ocspServers")
    def ocsp_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the URL values for the OCSP Servers field.
        """
        return pulumi.get(self, "ocsp_servers")

    @ocsp_servers.setter
    def ocsp_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ocsp_servers", value)

    @_builtins.property
    @pulumi.getter(name="revocationSignatureAlgorithm")
    def revocation_signature_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Which signature algorithm to use
        when building CRLs.
        """
        return pulumi.get(self, "revocation_signature_algorithm")

    @revocation_signature_algorithm.setter
    def revocation_signature_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "revocation_signature_algorithm", value)

    @_builtins.property
    @pulumi.getter
    def usage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Allowed usages for this issuer.
        """
        return pulumi.get(self, "usage")

    @usage.setter
    def usage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "usage", value)


@pulumi.input_type
class _SecretBackendIssuerState:
    def __init__(__self__, *,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 crl_distribution_points: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 disable_critical_extension_checks: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_name_checks: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_name_constraint_checks: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_path_length_checks: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_aia_url_templating: Optional[pulumi.Input[_builtins.bool]] = None,
                 issuer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 issuer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 issuer_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 issuing_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 leaf_not_after_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 manual_chains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 ocsp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 revocation_signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 usage: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecretBackendIssuer resources.
        :param pulumi.Input[_builtins.str] backend: The path the PKI secret backend is mounted at, with no
               leading or trailing `/`s.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] crl_distribution_points: Specifies the URL values for the CRL
               Distribution Points field.
        :param pulumi.Input[_builtins.bool] disable_critical_extension_checks: This determines whether this
               issuer is able to issue certificates where the chain of trust (including the
               issued certificate) contain critical extensions not processed by Vault.
        :param pulumi.Input[_builtins.bool] disable_name_checks: This determines whether this issuer is able
               to issue certificates where the chain of trust (including the final issued
               certificate) contains a link in which the subject of the issuing certificate
               does not match the named issuer of the certificate it signed.
        :param pulumi.Input[_builtins.bool] disable_name_constraint_checks: This determines whether this
               issuer is able to issue certificates where the chain of trust (including the
               final issued certificate) violates the name constraints critical extension of
               one of the issuer certificates in the chain.
        :param pulumi.Input[_builtins.bool] disable_path_length_checks: This determines whether this issuer
               is able to issue certificates where the chain of trust (including the final
               issued certificate) is longer than allowed by a certificate authority in that
               chain.
        :param pulumi.Input[_builtins.bool] enable_aia_url_templating: Specifies that the AIA URL values should
               be templated.
        :param pulumi.Input[_builtins.str] issuer_id: ID of the issuer.
        :param pulumi.Input[_builtins.str] issuer_name: Name of the issuer.
        :param pulumi.Input[_builtins.str] issuer_ref: Reference to an existing issuer.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] issuing_certificates: Specifies the URL values for the Issuing
               Certificate field.
        :param pulumi.Input[_builtins.str] leaf_not_after_behavior: Behavior of a leaf's NotAfter field during
               issuance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] manual_chains: Chain of issuer references to build this issuer's
               computed CAChain field from, when non-empty.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ocsp_servers: Specifies the URL values for the OCSP Servers field.
        :param pulumi.Input[_builtins.str] revocation_signature_algorithm: Which signature algorithm to use
               when building CRLs.
        :param pulumi.Input[_builtins.str] usage: Allowed usages for this issuer.
        """
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if crl_distribution_points is not None:
            pulumi.set(__self__, "crl_distribution_points", crl_distribution_points)
        if disable_critical_extension_checks is not None:
            pulumi.set(__self__, "disable_critical_extension_checks", disable_critical_extension_checks)
        if disable_name_checks is not None:
            pulumi.set(__self__, "disable_name_checks", disable_name_checks)
        if disable_name_constraint_checks is not None:
            pulumi.set(__self__, "disable_name_constraint_checks", disable_name_constraint_checks)
        if disable_path_length_checks is not None:
            pulumi.set(__self__, "disable_path_length_checks", disable_path_length_checks)
        if enable_aia_url_templating is not None:
            pulumi.set(__self__, "enable_aia_url_templating", enable_aia_url_templating)
        if issuer_id is not None:
            pulumi.set(__self__, "issuer_id", issuer_id)
        if issuer_name is not None:
            pulumi.set(__self__, "issuer_name", issuer_name)
        if issuer_ref is not None:
            pulumi.set(__self__, "issuer_ref", issuer_ref)
        if issuing_certificates is not None:
            pulumi.set(__self__, "issuing_certificates", issuing_certificates)
        if leaf_not_after_behavior is not None:
            pulumi.set(__self__, "leaf_not_after_behavior", leaf_not_after_behavior)
        if manual_chains is not None:
            pulumi.set(__self__, "manual_chains", manual_chains)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if ocsp_servers is not None:
            pulumi.set(__self__, "ocsp_servers", ocsp_servers)
        if revocation_signature_algorithm is not None:
            pulumi.set(__self__, "revocation_signature_algorithm", revocation_signature_algorithm)
        if usage is not None:
            pulumi.set(__self__, "usage", usage)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path the PKI secret backend is mounted at, with no
        leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="crlDistributionPoints")
    def crl_distribution_points(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the URL values for the CRL
        Distribution Points field.
        """
        return pulumi.get(self, "crl_distribution_points")

    @crl_distribution_points.setter
    def crl_distribution_points(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "crl_distribution_points", value)

    @_builtins.property
    @pulumi.getter(name="disableCriticalExtensionChecks")
    def disable_critical_extension_checks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This determines whether this
        issuer is able to issue certificates where the chain of trust (including the
        issued certificate) contain critical extensions not processed by Vault.
        """
        return pulumi.get(self, "disable_critical_extension_checks")

    @disable_critical_extension_checks.setter
    def disable_critical_extension_checks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_critical_extension_checks", value)

    @_builtins.property
    @pulumi.getter(name="disableNameChecks")
    def disable_name_checks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This determines whether this issuer is able
        to issue certificates where the chain of trust (including the final issued
        certificate) contains a link in which the subject of the issuing certificate
        does not match the named issuer of the certificate it signed.
        """
        return pulumi.get(self, "disable_name_checks")

    @disable_name_checks.setter
    def disable_name_checks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_name_checks", value)

    @_builtins.property
    @pulumi.getter(name="disableNameConstraintChecks")
    def disable_name_constraint_checks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This determines whether this
        issuer is able to issue certificates where the chain of trust (including the
        final issued certificate) violates the name constraints critical extension of
        one of the issuer certificates in the chain.
        """
        return pulumi.get(self, "disable_name_constraint_checks")

    @disable_name_constraint_checks.setter
    def disable_name_constraint_checks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_name_constraint_checks", value)

    @_builtins.property
    @pulumi.getter(name="disablePathLengthChecks")
    def disable_path_length_checks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This determines whether this issuer
        is able to issue certificates where the chain of trust (including the final
        issued certificate) is longer than allowed by a certificate authority in that
        chain.
        """
        return pulumi.get(self, "disable_path_length_checks")

    @disable_path_length_checks.setter
    def disable_path_length_checks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_path_length_checks", value)

    @_builtins.property
    @pulumi.getter(name="enableAiaUrlTemplating")
    def enable_aia_url_templating(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies that the AIA URL values should
        be templated.
        """
        return pulumi.get(self, "enable_aia_url_templating")

    @enable_aia_url_templating.setter
    def enable_aia_url_templating(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_aia_url_templating", value)

    @_builtins.property
    @pulumi.getter(name="issuerId")
    def issuer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the issuer.
        """
        return pulumi.get(self, "issuer_id")

    @issuer_id.setter
    def issuer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer_id", value)

    @_builtins.property
    @pulumi.getter(name="issuerName")
    def issuer_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the issuer.
        """
        return pulumi.get(self, "issuer_name")

    @issuer_name.setter
    def issuer_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer_name", value)

    @_builtins.property
    @pulumi.getter(name="issuerRef")
    def issuer_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Reference to an existing issuer.
        """
        return pulumi.get(self, "issuer_ref")

    @issuer_ref.setter
    def issuer_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer_ref", value)

    @_builtins.property
    @pulumi.getter(name="issuingCertificates")
    def issuing_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the URL values for the Issuing
        Certificate field.
        """
        return pulumi.get(self, "issuing_certificates")

    @issuing_certificates.setter
    def issuing_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "issuing_certificates", value)

    @_builtins.property
    @pulumi.getter(name="leafNotAfterBehavior")
    def leaf_not_after_behavior(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Behavior of a leaf's NotAfter field during
        issuance.
        """
        return pulumi.get(self, "leaf_not_after_behavior")

    @leaf_not_after_behavior.setter
    def leaf_not_after_behavior(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "leaf_not_after_behavior", value)

    @_builtins.property
    @pulumi.getter(name="manualChains")
    def manual_chains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Chain of issuer references to build this issuer's
        computed CAChain field from, when non-empty.
        """
        return pulumi.get(self, "manual_chains")

    @manual_chains.setter
    def manual_chains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "manual_chains", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="ocspServers")
    def ocsp_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the URL values for the OCSP Servers field.
        """
        return pulumi.get(self, "ocsp_servers")

    @ocsp_servers.setter
    def ocsp_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ocsp_servers", value)

    @_builtins.property
    @pulumi.getter(name="revocationSignatureAlgorithm")
    def revocation_signature_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Which signature algorithm to use
        when building CRLs.
        """
        return pulumi.get(self, "revocation_signature_algorithm")

    @revocation_signature_algorithm.setter
    def revocation_signature_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "revocation_signature_algorithm", value)

    @_builtins.property
    @pulumi.getter
    def usage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Allowed usages for this issuer.
        """
        return pulumi.get(self, "usage")

    @usage.setter
    def usage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "usage", value)


@pulumi.type_token("vault:pkiSecret/secretBackendIssuer:SecretBackendIssuer")
class SecretBackendIssuer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 crl_distribution_points: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 disable_critical_extension_checks: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_name_checks: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_name_constraint_checks: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_path_length_checks: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_aia_url_templating: Optional[pulumi.Input[_builtins.bool]] = None,
                 issuer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 issuer_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 issuing_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 leaf_not_after_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 manual_chains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 ocsp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 revocation_signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 usage: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        pki = vault.Mount("pki",
            path="pki",
            type="pki",
            default_lease_ttl_seconds=3600,
            max_lease_ttl_seconds=86400)
        root = vault.pkisecret.SecretBackendRootCert("root",
            backend=pki.path,
            type="internal",
            common_name="test",
            ttl="86400")
        example = vault.pkisecret.SecretBackendIssuer("example",
            backend=root.backend,
            issuer_ref=root.issuer_id,
            issuer_name="example-issuer")
        ```

        ## Import

        PKI secret backend issuer can be imported using the `id`, e.g.

        ```sh
        $ pulumi import vault:pkiSecret/secretBackendIssuer:SecretBackendIssuer example pki/issuer/bf9b0d48-d0dd-652c-30be-77d04fc7e94d
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend: The path the PKI secret backend is mounted at, with no
               leading or trailing `/`s.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] crl_distribution_points: Specifies the URL values for the CRL
               Distribution Points field.
        :param pulumi.Input[_builtins.bool] disable_critical_extension_checks: This determines whether this
               issuer is able to issue certificates where the chain of trust (including the
               issued certificate) contain critical extensions not processed by Vault.
        :param pulumi.Input[_builtins.bool] disable_name_checks: This determines whether this issuer is able
               to issue certificates where the chain of trust (including the final issued
               certificate) contains a link in which the subject of the issuing certificate
               does not match the named issuer of the certificate it signed.
        :param pulumi.Input[_builtins.bool] disable_name_constraint_checks: This determines whether this
               issuer is able to issue certificates where the chain of trust (including the
               final issued certificate) violates the name constraints critical extension of
               one of the issuer certificates in the chain.
        :param pulumi.Input[_builtins.bool] disable_path_length_checks: This determines whether this issuer
               is able to issue certificates where the chain of trust (including the final
               issued certificate) is longer than allowed by a certificate authority in that
               chain.
        :param pulumi.Input[_builtins.bool] enable_aia_url_templating: Specifies that the AIA URL values should
               be templated.
        :param pulumi.Input[_builtins.str] issuer_name: Name of the issuer.
        :param pulumi.Input[_builtins.str] issuer_ref: Reference to an existing issuer.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] issuing_certificates: Specifies the URL values for the Issuing
               Certificate field.
        :param pulumi.Input[_builtins.str] leaf_not_after_behavior: Behavior of a leaf's NotAfter field during
               issuance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] manual_chains: Chain of issuer references to build this issuer's
               computed CAChain field from, when non-empty.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ocsp_servers: Specifies the URL values for the OCSP Servers field.
        :param pulumi.Input[_builtins.str] revocation_signature_algorithm: Which signature algorithm to use
               when building CRLs.
        :param pulumi.Input[_builtins.str] usage: Allowed usages for this issuer.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretBackendIssuerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        pki = vault.Mount("pki",
            path="pki",
            type="pki",
            default_lease_ttl_seconds=3600,
            max_lease_ttl_seconds=86400)
        root = vault.pkisecret.SecretBackendRootCert("root",
            backend=pki.path,
            type="internal",
            common_name="test",
            ttl="86400")
        example = vault.pkisecret.SecretBackendIssuer("example",
            backend=root.backend,
            issuer_ref=root.issuer_id,
            issuer_name="example-issuer")
        ```

        ## Import

        PKI secret backend issuer can be imported using the `id`, e.g.

        ```sh
        $ pulumi import vault:pkiSecret/secretBackendIssuer:SecretBackendIssuer example pki/issuer/bf9b0d48-d0dd-652c-30be-77d04fc7e94d
        ```

        :param str resource_name: The name of the resource.
        :param SecretBackendIssuerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendIssuerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 crl_distribution_points: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 disable_critical_extension_checks: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_name_checks: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_name_constraint_checks: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_path_length_checks: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_aia_url_templating: Optional[pulumi.Input[_builtins.bool]] = None,
                 issuer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 issuer_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 issuing_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 leaf_not_after_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 manual_chains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 ocsp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 revocation_signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 usage: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretBackendIssuerArgs.__new__(SecretBackendIssuerArgs)

            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            __props__.__dict__["crl_distribution_points"] = crl_distribution_points
            __props__.__dict__["disable_critical_extension_checks"] = disable_critical_extension_checks
            __props__.__dict__["disable_name_checks"] = disable_name_checks
            __props__.__dict__["disable_name_constraint_checks"] = disable_name_constraint_checks
            __props__.__dict__["disable_path_length_checks"] = disable_path_length_checks
            __props__.__dict__["enable_aia_url_templating"] = enable_aia_url_templating
            __props__.__dict__["issuer_name"] = issuer_name
            if issuer_ref is None and not opts.urn:
                raise TypeError("Missing required property 'issuer_ref'")
            __props__.__dict__["issuer_ref"] = issuer_ref
            __props__.__dict__["issuing_certificates"] = issuing_certificates
            __props__.__dict__["leaf_not_after_behavior"] = leaf_not_after_behavior
            __props__.__dict__["manual_chains"] = manual_chains
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["ocsp_servers"] = ocsp_servers
            __props__.__dict__["revocation_signature_algorithm"] = revocation_signature_algorithm
            __props__.__dict__["usage"] = usage
            __props__.__dict__["issuer_id"] = None
        super(SecretBackendIssuer, __self__).__init__(
            'vault:pkiSecret/secretBackendIssuer:SecretBackendIssuer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            crl_distribution_points: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            disable_critical_extension_checks: Optional[pulumi.Input[_builtins.bool]] = None,
            disable_name_checks: Optional[pulumi.Input[_builtins.bool]] = None,
            disable_name_constraint_checks: Optional[pulumi.Input[_builtins.bool]] = None,
            disable_path_length_checks: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_aia_url_templating: Optional[pulumi.Input[_builtins.bool]] = None,
            issuer_id: Optional[pulumi.Input[_builtins.str]] = None,
            issuer_name: Optional[pulumi.Input[_builtins.str]] = None,
            issuer_ref: Optional[pulumi.Input[_builtins.str]] = None,
            issuing_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            leaf_not_after_behavior: Optional[pulumi.Input[_builtins.str]] = None,
            manual_chains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            ocsp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            revocation_signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            usage: Optional[pulumi.Input[_builtins.str]] = None) -> 'SecretBackendIssuer':
        """
        Get an existing SecretBackendIssuer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend: The path the PKI secret backend is mounted at, with no
               leading or trailing `/`s.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] crl_distribution_points: Specifies the URL values for the CRL
               Distribution Points field.
        :param pulumi.Input[_builtins.bool] disable_critical_extension_checks: This determines whether this
               issuer is able to issue certificates where the chain of trust (including the
               issued certificate) contain critical extensions not processed by Vault.
        :param pulumi.Input[_builtins.bool] disable_name_checks: This determines whether this issuer is able
               to issue certificates where the chain of trust (including the final issued
               certificate) contains a link in which the subject of the issuing certificate
               does not match the named issuer of the certificate it signed.
        :param pulumi.Input[_builtins.bool] disable_name_constraint_checks: This determines whether this
               issuer is able to issue certificates where the chain of trust (including the
               final issued certificate) violates the name constraints critical extension of
               one of the issuer certificates in the chain.
        :param pulumi.Input[_builtins.bool] disable_path_length_checks: This determines whether this issuer
               is able to issue certificates where the chain of trust (including the final
               issued certificate) is longer than allowed by a certificate authority in that
               chain.
        :param pulumi.Input[_builtins.bool] enable_aia_url_templating: Specifies that the AIA URL values should
               be templated.
        :param pulumi.Input[_builtins.str] issuer_id: ID of the issuer.
        :param pulumi.Input[_builtins.str] issuer_name: Name of the issuer.
        :param pulumi.Input[_builtins.str] issuer_ref: Reference to an existing issuer.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] issuing_certificates: Specifies the URL values for the Issuing
               Certificate field.
        :param pulumi.Input[_builtins.str] leaf_not_after_behavior: Behavior of a leaf's NotAfter field during
               issuance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] manual_chains: Chain of issuer references to build this issuer's
               computed CAChain field from, when non-empty.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ocsp_servers: Specifies the URL values for the OCSP Servers field.
        :param pulumi.Input[_builtins.str] revocation_signature_algorithm: Which signature algorithm to use
               when building CRLs.
        :param pulumi.Input[_builtins.str] usage: Allowed usages for this issuer.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretBackendIssuerState.__new__(_SecretBackendIssuerState)

        __props__.__dict__["backend"] = backend
        __props__.__dict__["crl_distribution_points"] = crl_distribution_points
        __props__.__dict__["disable_critical_extension_checks"] = disable_critical_extension_checks
        __props__.__dict__["disable_name_checks"] = disable_name_checks
        __props__.__dict__["disable_name_constraint_checks"] = disable_name_constraint_checks
        __props__.__dict__["disable_path_length_checks"] = disable_path_length_checks
        __props__.__dict__["enable_aia_url_templating"] = enable_aia_url_templating
        __props__.__dict__["issuer_id"] = issuer_id
        __props__.__dict__["issuer_name"] = issuer_name
        __props__.__dict__["issuer_ref"] = issuer_ref
        __props__.__dict__["issuing_certificates"] = issuing_certificates
        __props__.__dict__["leaf_not_after_behavior"] = leaf_not_after_behavior
        __props__.__dict__["manual_chains"] = manual_chains
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["ocsp_servers"] = ocsp_servers
        __props__.__dict__["revocation_signature_algorithm"] = revocation_signature_algorithm
        __props__.__dict__["usage"] = usage
        return SecretBackendIssuer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[_builtins.str]:
        """
        The path the PKI secret backend is mounted at, with no
        leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="crlDistributionPoints")
    def crl_distribution_points(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the URL values for the CRL
        Distribution Points field.
        """
        return pulumi.get(self, "crl_distribution_points")

    @_builtins.property
    @pulumi.getter(name="disableCriticalExtensionChecks")
    def disable_critical_extension_checks(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        This determines whether this
        issuer is able to issue certificates where the chain of trust (including the
        issued certificate) contain critical extensions not processed by Vault.
        """
        return pulumi.get(self, "disable_critical_extension_checks")

    @_builtins.property
    @pulumi.getter(name="disableNameChecks")
    def disable_name_checks(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        This determines whether this issuer is able
        to issue certificates where the chain of trust (including the final issued
        certificate) contains a link in which the subject of the issuing certificate
        does not match the named issuer of the certificate it signed.
        """
        return pulumi.get(self, "disable_name_checks")

    @_builtins.property
    @pulumi.getter(name="disableNameConstraintChecks")
    def disable_name_constraint_checks(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        This determines whether this
        issuer is able to issue certificates where the chain of trust (including the
        final issued certificate) violates the name constraints critical extension of
        one of the issuer certificates in the chain.
        """
        return pulumi.get(self, "disable_name_constraint_checks")

    @_builtins.property
    @pulumi.getter(name="disablePathLengthChecks")
    def disable_path_length_checks(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        This determines whether this issuer
        is able to issue certificates where the chain of trust (including the final
        issued certificate) is longer than allowed by a certificate authority in that
        chain.
        """
        return pulumi.get(self, "disable_path_length_checks")

    @_builtins.property
    @pulumi.getter(name="enableAiaUrlTemplating")
    def enable_aia_url_templating(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies that the AIA URL values should
        be templated.
        """
        return pulumi.get(self, "enable_aia_url_templating")

    @_builtins.property
    @pulumi.getter(name="issuerId")
    def issuer_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the issuer.
        """
        return pulumi.get(self, "issuer_id")

    @_builtins.property
    @pulumi.getter(name="issuerName")
    def issuer_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of the issuer.
        """
        return pulumi.get(self, "issuer_name")

    @_builtins.property
    @pulumi.getter(name="issuerRef")
    def issuer_ref(self) -> pulumi.Output[_builtins.str]:
        """
        Reference to an existing issuer.
        """
        return pulumi.get(self, "issuer_ref")

    @_builtins.property
    @pulumi.getter(name="issuingCertificates")
    def issuing_certificates(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the URL values for the Issuing
        Certificate field.
        """
        return pulumi.get(self, "issuing_certificates")

    @_builtins.property
    @pulumi.getter(name="leafNotAfterBehavior")
    def leaf_not_after_behavior(self) -> pulumi.Output[_builtins.str]:
        """
        Behavior of a leaf's NotAfter field during
        issuance.
        """
        return pulumi.get(self, "leaf_not_after_behavior")

    @_builtins.property
    @pulumi.getter(name="manualChains")
    def manual_chains(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Chain of issuer references to build this issuer's
        computed CAChain field from, when non-empty.
        """
        return pulumi.get(self, "manual_chains")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="ocspServers")
    def ocsp_servers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the URL values for the OCSP Servers field.
        """
        return pulumi.get(self, "ocsp_servers")

    @_builtins.property
    @pulumi.getter(name="revocationSignatureAlgorithm")
    def revocation_signature_algorithm(self) -> pulumi.Output[_builtins.str]:
        """
        Which signature algorithm to use
        when building CRLs.
        """
        return pulumi.get(self, "revocation_signature_algorithm")

    @_builtins.property
    @pulumi.getter
    def usage(self) -> pulumi.Output[_builtins.str]:
        """
        Allowed usages for this issuer.
        """
        return pulumi.get(self, "usage")

