# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecretBackendRoleArgs', 'SecretBackendRole']

@pulumi.input_type
class SecretBackendRoleArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[_builtins.str],
                 allow_any_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_bare_domains: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_glob_domains: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_ip_sans: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_localhost: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_subdomains: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_wildcard_certificates: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_domains_template: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_serial_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_uri_sans_template: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 basic_constraints_valid_for_non_ca: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_flag: Optional[pulumi.Input[_builtins.bool]] = None,
                 cn_validations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 code_signing_flag: Optional[pulumi.Input[_builtins.bool]] = None,
                 countries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 email_protection_flag: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_hostnames: Optional[pulumi.Input[_builtins.bool]] = None,
                 ext_key_usage_oids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ext_key_usages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 generate_lease: Optional[pulumi.Input[_builtins.bool]] = None,
                 issuer_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 key_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key_usages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 localities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 max_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 no_store: Optional[pulumi.Input[_builtins.bool]] = None,
                 no_store_metadata: Optional[pulumi.Input[_builtins.bool]] = None,
                 not_after: Optional[pulumi.Input[_builtins.str]] = None,
                 not_before_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_unit: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 organizations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 policy_identifier: Optional[pulumi.Input[Sequence[pulumi.Input['SecretBackendRolePolicyIdentifierArgs']]]] = None,
                 policy_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 postal_codes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 provinces: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 require_cn: Optional[pulumi.Input[_builtins.bool]] = None,
                 serial_number_source: Optional[pulumi.Input[_builtins.str]] = None,
                 server_flag: Optional[pulumi.Input[_builtins.bool]] = None,
                 signature_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 street_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 use_csr_common_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_csr_sans: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_pss: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a SecretBackendRole resource.
        :param pulumi.Input[_builtins.str] backend: The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.bool] allow_any_name: Flag to allow any name
        :param pulumi.Input[_builtins.bool] allow_bare_domains: Flag to allow certificates matching the actual domain
        :param pulumi.Input[_builtins.bool] allow_glob_domains: Flag to allow names containing glob patterns.
        :param pulumi.Input[_builtins.bool] allow_ip_sans: Flag to allow IP SANs
        :param pulumi.Input[_builtins.bool] allow_localhost: Flag to allow certificates for localhost
        :param pulumi.Input[_builtins.bool] allow_subdomains: Flag to allow certificates matching subdomains
        :param pulumi.Input[_builtins.bool] allow_wildcard_certificates: Flag to allow wildcard certificates.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_domains: List of allowed domains for certificates
        :param pulumi.Input[_builtins.bool] allowed_domains_template: Flag, if set, `allowed_domains` can be specified using identity template expressions such as `{{identity.entity.aliases.<mount accessor>.name}}`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_other_sans: Defines allowed custom SANs
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_serial_numbers: An array of allowed serial numbers to put in Subject
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_uri_sans: Defines allowed URI SANs
        :param pulumi.Input[_builtins.bool] allowed_uri_sans_template: Flag, if set, `allowed_uri_sans` can be specified using identity template expressions such as `{{identity.entity.aliases.<mount accessor>.name}}`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_user_ids: Defines allowed User IDs
        :param pulumi.Input[_builtins.bool] basic_constraints_valid_for_non_ca: Flag to mark basic constraints valid when issuing non-CA certificates
        :param pulumi.Input[_builtins.bool] client_flag: Flag to specify certificates for client use
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cn_validations: Validations to run on the Common Name field of the certificate, choices: `email`, `hostname`, `disabled`
        :param pulumi.Input[_builtins.bool] code_signing_flag: Flag to specify certificates for code signing use
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] countries: The country of generated certificates
        :param pulumi.Input[_builtins.bool] email_protection_flag: Flag to specify certificates for email protection use
        :param pulumi.Input[_builtins.bool] enforce_hostnames: Flag to allow only valid host names
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ext_key_usage_oids: Specify the allowed extended key usage OIDs constraint on issued certificates
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ext_key_usages: Specify the allowed extended key usage constraint on issued certificates
        :param pulumi.Input[_builtins.bool] generate_lease: Flag to generate leases with certificates
        :param pulumi.Input[_builtins.str] issuer_ref: Specifies the default issuer of this request. May
               be the value `default`, a name, or an issuer ID. Use ACLs to prevent access to
               the `/pki/issuer/:issuer_ref/{issue,sign}/:name` paths to prevent users
               overriding the role's `issuer_ref` value.
        :param pulumi.Input[_builtins.int] key_bits: The number of bits of generated keys
        :param pulumi.Input[_builtins.str] key_type: The generated key type, choices: `rsa`, `ec`, `ed25519`, `any`
               Defaults to `rsa`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] key_usages: Specify the allowed key usage constraint on issued
               certificates. Defaults to `["DigitalSignature", "KeyAgreement", "KeyEncipherment"])`.
               To specify no default key usage constraints, set this to an empty list `[]`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] localities: The locality of generated certificates
        :param pulumi.Input[_builtins.str] max_ttl: The maximum lease TTL, in seconds, for the role.
        :param pulumi.Input[_builtins.str] name: The name to identify this role within the backend. Must be unique within the backend.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.bool] no_store: Flag to not store certificates in the storage backend
        :param pulumi.Input[_builtins.bool] no_store_metadata: Allows metadata to be stored keyed on the certificate's serial number. The field is independent of no_store, allowing metadata storage regardless of whether certificates are stored. If true, metadata is not stored and an error is returned if the metadata field is specified on issuance APIs
        :param pulumi.Input[_builtins.str] not_after: Set the Not After field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ. Supports the Y10K end date for IEEE 802.1AR-2018 standard devices, 9999-12-31T23:59:59Z.
        :param pulumi.Input[_builtins.str] not_before_duration: Specifies the duration by which to backdate the NotBefore property.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] organization_unit: The organization unit of generated certificates
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] organizations: The organization of generated certificates
        :param pulumi.Input[Sequence[pulumi.Input['SecretBackendRolePolicyIdentifierArgs']]] policy_identifier: (Vault 1.11+ only) A block for specifying policy identifers. The `policy_identifier` block can be repeated, and supports the following arguments:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policy_identifiers: Specify the list of allowed policies OIDs. Use with Vault 1.10 or before. For Vault 1.11+, use `policy_identifier` blocks instead
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] postal_codes: The postal code of generated certificates
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] provinces: The province of generated certificates
        :param pulumi.Input[_builtins.bool] require_cn: Flag to force CN usage
        :param pulumi.Input[_builtins.str] serial_number_source: Specifies the source of the subject serial number. Valid values are json-csr (default) or json. When set to json-csr, the subject serial number is taken from the serial_number parameter and falls back to the serial number in the CSR. When set to json, the subject serial number is taken from the serial_number parameter but will ignore any value in the CSR. For backwards compatibility an empty value for this field will default to the json-csr behavior.
               
               Example usage:
        :param pulumi.Input[_builtins.bool] server_flag: Flag to specify certificates for server use
        :param pulumi.Input[_builtins.int] signature_bits: The number of bits to use in the signature algorithm
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] street_addresses: The street address of generated certificates
        :param pulumi.Input[_builtins.str] ttl: The TTL, in seconds, for any certificate issued against this role.
        :param pulumi.Input[_builtins.bool] use_csr_common_name: Flag to use the CN in the CSR
        :param pulumi.Input[_builtins.bool] use_csr_sans: Flag to use the SANs in the CSR
        :param pulumi.Input[_builtins.bool] use_pss: Specifies whether or not to use PSS signatures over PKCS#1v1.5 signatures when a RSA-type issuer is used. Ignored for ECDSA/Ed25519 issuers.
        """
        pulumi.set(__self__, "backend", backend)
        if allow_any_name is not None:
            pulumi.set(__self__, "allow_any_name", allow_any_name)
        if allow_bare_domains is not None:
            pulumi.set(__self__, "allow_bare_domains", allow_bare_domains)
        if allow_glob_domains is not None:
            pulumi.set(__self__, "allow_glob_domains", allow_glob_domains)
        if allow_ip_sans is not None:
            pulumi.set(__self__, "allow_ip_sans", allow_ip_sans)
        if allow_localhost is not None:
            pulumi.set(__self__, "allow_localhost", allow_localhost)
        if allow_subdomains is not None:
            pulumi.set(__self__, "allow_subdomains", allow_subdomains)
        if allow_wildcard_certificates is not None:
            pulumi.set(__self__, "allow_wildcard_certificates", allow_wildcard_certificates)
        if allowed_domains is not None:
            pulumi.set(__self__, "allowed_domains", allowed_domains)
        if allowed_domains_template is not None:
            pulumi.set(__self__, "allowed_domains_template", allowed_domains_template)
        if allowed_other_sans is not None:
            pulumi.set(__self__, "allowed_other_sans", allowed_other_sans)
        if allowed_serial_numbers is not None:
            pulumi.set(__self__, "allowed_serial_numbers", allowed_serial_numbers)
        if allowed_uri_sans is not None:
            pulumi.set(__self__, "allowed_uri_sans", allowed_uri_sans)
        if allowed_uri_sans_template is not None:
            pulumi.set(__self__, "allowed_uri_sans_template", allowed_uri_sans_template)
        if allowed_user_ids is not None:
            pulumi.set(__self__, "allowed_user_ids", allowed_user_ids)
        if basic_constraints_valid_for_non_ca is not None:
            pulumi.set(__self__, "basic_constraints_valid_for_non_ca", basic_constraints_valid_for_non_ca)
        if client_flag is not None:
            pulumi.set(__self__, "client_flag", client_flag)
        if cn_validations is not None:
            pulumi.set(__self__, "cn_validations", cn_validations)
        if code_signing_flag is not None:
            pulumi.set(__self__, "code_signing_flag", code_signing_flag)
        if countries is not None:
            pulumi.set(__self__, "countries", countries)
        if email_protection_flag is not None:
            pulumi.set(__self__, "email_protection_flag", email_protection_flag)
        if enforce_hostnames is not None:
            pulumi.set(__self__, "enforce_hostnames", enforce_hostnames)
        if ext_key_usage_oids is not None:
            pulumi.set(__self__, "ext_key_usage_oids", ext_key_usage_oids)
        if ext_key_usages is not None:
            pulumi.set(__self__, "ext_key_usages", ext_key_usages)
        if generate_lease is not None:
            pulumi.set(__self__, "generate_lease", generate_lease)
        if issuer_ref is not None:
            pulumi.set(__self__, "issuer_ref", issuer_ref)
        if key_bits is not None:
            pulumi.set(__self__, "key_bits", key_bits)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if key_usages is not None:
            pulumi.set(__self__, "key_usages", key_usages)
        if localities is not None:
            pulumi.set(__self__, "localities", localities)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if no_store is not None:
            pulumi.set(__self__, "no_store", no_store)
        if no_store_metadata is not None:
            pulumi.set(__self__, "no_store_metadata", no_store_metadata)
        if not_after is not None:
            pulumi.set(__self__, "not_after", not_after)
        if not_before_duration is not None:
            pulumi.set(__self__, "not_before_duration", not_before_duration)
        if organization_unit is not None:
            pulumi.set(__self__, "organization_unit", organization_unit)
        if organizations is not None:
            pulumi.set(__self__, "organizations", organizations)
        if policy_identifier is not None:
            pulumi.set(__self__, "policy_identifier", policy_identifier)
        if policy_identifiers is not None:
            pulumi.set(__self__, "policy_identifiers", policy_identifiers)
        if postal_codes is not None:
            pulumi.set(__self__, "postal_codes", postal_codes)
        if provinces is not None:
            pulumi.set(__self__, "provinces", provinces)
        if require_cn is not None:
            pulumi.set(__self__, "require_cn", require_cn)
        if serial_number_source is not None:
            pulumi.set(__self__, "serial_number_source", serial_number_source)
        if server_flag is not None:
            pulumi.set(__self__, "server_flag", server_flag)
        if signature_bits is not None:
            pulumi.set(__self__, "signature_bits", signature_bits)
        if street_addresses is not None:
            pulumi.set(__self__, "street_addresses", street_addresses)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if use_csr_common_name is not None:
            pulumi.set(__self__, "use_csr_common_name", use_csr_common_name)
        if use_csr_sans is not None:
            pulumi.set(__self__, "use_csr_sans", use_csr_sans)
        if use_pss is not None:
            pulumi.set(__self__, "use_pss", use_pss)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Input[_builtins.str]:
        """
        The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="allowAnyName")
    def allow_any_name(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to allow any name
        """
        return pulumi.get(self, "allow_any_name")

    @allow_any_name.setter
    def allow_any_name(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_any_name", value)

    @_builtins.property
    @pulumi.getter(name="allowBareDomains")
    def allow_bare_domains(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to allow certificates matching the actual domain
        """
        return pulumi.get(self, "allow_bare_domains")

    @allow_bare_domains.setter
    def allow_bare_domains(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_bare_domains", value)

    @_builtins.property
    @pulumi.getter(name="allowGlobDomains")
    def allow_glob_domains(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to allow names containing glob patterns.
        """
        return pulumi.get(self, "allow_glob_domains")

    @allow_glob_domains.setter
    def allow_glob_domains(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_glob_domains", value)

    @_builtins.property
    @pulumi.getter(name="allowIpSans")
    def allow_ip_sans(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to allow IP SANs
        """
        return pulumi.get(self, "allow_ip_sans")

    @allow_ip_sans.setter
    def allow_ip_sans(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_ip_sans", value)

    @_builtins.property
    @pulumi.getter(name="allowLocalhost")
    def allow_localhost(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to allow certificates for localhost
        """
        return pulumi.get(self, "allow_localhost")

    @allow_localhost.setter
    def allow_localhost(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_localhost", value)

    @_builtins.property
    @pulumi.getter(name="allowSubdomains")
    def allow_subdomains(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to allow certificates matching subdomains
        """
        return pulumi.get(self, "allow_subdomains")

    @allow_subdomains.setter
    def allow_subdomains(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_subdomains", value)

    @_builtins.property
    @pulumi.getter(name="allowWildcardCertificates")
    def allow_wildcard_certificates(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to allow wildcard certificates.
        """
        return pulumi.get(self, "allow_wildcard_certificates")

    @allow_wildcard_certificates.setter
    def allow_wildcard_certificates(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_wildcard_certificates", value)

    @_builtins.property
    @pulumi.getter(name="allowedDomains")
    def allowed_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of allowed domains for certificates
        """
        return pulumi.get(self, "allowed_domains")

    @allowed_domains.setter
    def allowed_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_domains", value)

    @_builtins.property
    @pulumi.getter(name="allowedDomainsTemplate")
    def allowed_domains_template(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag, if set, `allowed_domains` can be specified using identity template expressions such as `{{identity.entity.aliases.<mount accessor>.name}}`.
        """
        return pulumi.get(self, "allowed_domains_template")

    @allowed_domains_template.setter
    def allowed_domains_template(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allowed_domains_template", value)

    @_builtins.property
    @pulumi.getter(name="allowedOtherSans")
    def allowed_other_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Defines allowed custom SANs
        """
        return pulumi.get(self, "allowed_other_sans")

    @allowed_other_sans.setter
    def allowed_other_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_other_sans", value)

    @_builtins.property
    @pulumi.getter(name="allowedSerialNumbers")
    def allowed_serial_numbers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An array of allowed serial numbers to put in Subject
        """
        return pulumi.get(self, "allowed_serial_numbers")

    @allowed_serial_numbers.setter
    def allowed_serial_numbers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_serial_numbers", value)

    @_builtins.property
    @pulumi.getter(name="allowedUriSans")
    def allowed_uri_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Defines allowed URI SANs
        """
        return pulumi.get(self, "allowed_uri_sans")

    @allowed_uri_sans.setter
    def allowed_uri_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_uri_sans", value)

    @_builtins.property
    @pulumi.getter(name="allowedUriSansTemplate")
    def allowed_uri_sans_template(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag, if set, `allowed_uri_sans` can be specified using identity template expressions such as `{{identity.entity.aliases.<mount accessor>.name}}`.
        """
        return pulumi.get(self, "allowed_uri_sans_template")

    @allowed_uri_sans_template.setter
    def allowed_uri_sans_template(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allowed_uri_sans_template", value)

    @_builtins.property
    @pulumi.getter(name="allowedUserIds")
    def allowed_user_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Defines allowed User IDs
        """
        return pulumi.get(self, "allowed_user_ids")

    @allowed_user_ids.setter
    def allowed_user_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_user_ids", value)

    @_builtins.property
    @pulumi.getter(name="basicConstraintsValidForNonCa")
    def basic_constraints_valid_for_non_ca(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to mark basic constraints valid when issuing non-CA certificates
        """
        return pulumi.get(self, "basic_constraints_valid_for_non_ca")

    @basic_constraints_valid_for_non_ca.setter
    def basic_constraints_valid_for_non_ca(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "basic_constraints_valid_for_non_ca", value)

    @_builtins.property
    @pulumi.getter(name="clientFlag")
    def client_flag(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to specify certificates for client use
        """
        return pulumi.get(self, "client_flag")

    @client_flag.setter
    def client_flag(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "client_flag", value)

    @_builtins.property
    @pulumi.getter(name="cnValidations")
    def cn_validations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Validations to run on the Common Name field of the certificate, choices: `email`, `hostname`, `disabled`
        """
        return pulumi.get(self, "cn_validations")

    @cn_validations.setter
    def cn_validations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "cn_validations", value)

    @_builtins.property
    @pulumi.getter(name="codeSigningFlag")
    def code_signing_flag(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to specify certificates for code signing use
        """
        return pulumi.get(self, "code_signing_flag")

    @code_signing_flag.setter
    def code_signing_flag(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "code_signing_flag", value)

    @_builtins.property
    @pulumi.getter
    def countries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The country of generated certificates
        """
        return pulumi.get(self, "countries")

    @countries.setter
    def countries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "countries", value)

    @_builtins.property
    @pulumi.getter(name="emailProtectionFlag")
    def email_protection_flag(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to specify certificates for email protection use
        """
        return pulumi.get(self, "email_protection_flag")

    @email_protection_flag.setter
    def email_protection_flag(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "email_protection_flag", value)

    @_builtins.property
    @pulumi.getter(name="enforceHostnames")
    def enforce_hostnames(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to allow only valid host names
        """
        return pulumi.get(self, "enforce_hostnames")

    @enforce_hostnames.setter
    def enforce_hostnames(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enforce_hostnames", value)

    @_builtins.property
    @pulumi.getter(name="extKeyUsageOids")
    def ext_key_usage_oids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specify the allowed extended key usage OIDs constraint on issued certificates
        """
        return pulumi.get(self, "ext_key_usage_oids")

    @ext_key_usage_oids.setter
    def ext_key_usage_oids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ext_key_usage_oids", value)

    @_builtins.property
    @pulumi.getter(name="extKeyUsages")
    def ext_key_usages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specify the allowed extended key usage constraint on issued certificates
        """
        return pulumi.get(self, "ext_key_usages")

    @ext_key_usages.setter
    def ext_key_usages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ext_key_usages", value)

    @_builtins.property
    @pulumi.getter(name="generateLease")
    def generate_lease(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to generate leases with certificates
        """
        return pulumi.get(self, "generate_lease")

    @generate_lease.setter
    def generate_lease(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "generate_lease", value)

    @_builtins.property
    @pulumi.getter(name="issuerRef")
    def issuer_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the default issuer of this request. May
        be the value `default`, a name, or an issuer ID. Use ACLs to prevent access to
        the `/pki/issuer/:issuer_ref/{issue,sign}/:name` paths to prevent users
        overriding the role's `issuer_ref` value.
        """
        return pulumi.get(self, "issuer_ref")

    @issuer_ref.setter
    def issuer_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer_ref", value)

    @_builtins.property
    @pulumi.getter(name="keyBits")
    def key_bits(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of bits of generated keys
        """
        return pulumi.get(self, "key_bits")

    @key_bits.setter
    def key_bits(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "key_bits", value)

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The generated key type, choices: `rsa`, `ec`, `ed25519`, `any`
        Defaults to `rsa`
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_type", value)

    @_builtins.property
    @pulumi.getter(name="keyUsages")
    def key_usages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specify the allowed key usage constraint on issued
        certificates. Defaults to `["DigitalSignature", "KeyAgreement", "KeyEncipherment"])`.
        To specify no default key usage constraints, set this to an empty list `[]`.
        """
        return pulumi.get(self, "key_usages")

    @key_usages.setter
    def key_usages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "key_usages", value)

    @_builtins.property
    @pulumi.getter
    def localities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The locality of generated certificates
        """
        return pulumi.get(self, "localities")

    @localities.setter
    def localities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "localities", value)

    @_builtins.property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maximum lease TTL, in seconds, for the role.
        """
        return pulumi.get(self, "max_ttl")

    @max_ttl.setter
    def max_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_ttl", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name to identify this role within the backend. Must be unique within the backend.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="noStore")
    def no_store(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to not store certificates in the storage backend
        """
        return pulumi.get(self, "no_store")

    @no_store.setter
    def no_store(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "no_store", value)

    @_builtins.property
    @pulumi.getter(name="noStoreMetadata")
    def no_store_metadata(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allows metadata to be stored keyed on the certificate's serial number. The field is independent of no_store, allowing metadata storage regardless of whether certificates are stored. If true, metadata is not stored and an error is returned if the metadata field is specified on issuance APIs
        """
        return pulumi.get(self, "no_store_metadata")

    @no_store_metadata.setter
    def no_store_metadata(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "no_store_metadata", value)

    @_builtins.property
    @pulumi.getter(name="notAfter")
    def not_after(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the Not After field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ. Supports the Y10K end date for IEEE 802.1AR-2018 standard devices, 9999-12-31T23:59:59Z.
        """
        return pulumi.get(self, "not_after")

    @not_after.setter
    def not_after(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "not_after", value)

    @_builtins.property
    @pulumi.getter(name="notBeforeDuration")
    def not_before_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the duration by which to backdate the NotBefore property.
        """
        return pulumi.get(self, "not_before_duration")

    @not_before_duration.setter
    def not_before_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "not_before_duration", value)

    @_builtins.property
    @pulumi.getter(name="organizationUnit")
    def organization_unit(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The organization unit of generated certificates
        """
        return pulumi.get(self, "organization_unit")

    @organization_unit.setter
    def organization_unit(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "organization_unit", value)

    @_builtins.property
    @pulumi.getter
    def organizations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The organization of generated certificates
        """
        return pulumi.get(self, "organizations")

    @organizations.setter
    def organizations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "organizations", value)

    @_builtins.property
    @pulumi.getter(name="policyIdentifier")
    def policy_identifier(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretBackendRolePolicyIdentifierArgs']]]]:
        """
        (Vault 1.11+ only) A block for specifying policy identifers. The `policy_identifier` block can be repeated, and supports the following arguments:
        """
        return pulumi.get(self, "policy_identifier")

    @policy_identifier.setter
    def policy_identifier(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretBackendRolePolicyIdentifierArgs']]]]):
        pulumi.set(self, "policy_identifier", value)

    @_builtins.property
    @pulumi.getter(name="policyIdentifiers")
    def policy_identifiers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specify the list of allowed policies OIDs. Use with Vault 1.10 or before. For Vault 1.11+, use `policy_identifier` blocks instead
        """
        return pulumi.get(self, "policy_identifiers")

    @policy_identifiers.setter
    def policy_identifiers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "policy_identifiers", value)

    @_builtins.property
    @pulumi.getter(name="postalCodes")
    def postal_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The postal code of generated certificates
        """
        return pulumi.get(self, "postal_codes")

    @postal_codes.setter
    def postal_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "postal_codes", value)

    @_builtins.property
    @pulumi.getter
    def provinces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The province of generated certificates
        """
        return pulumi.get(self, "provinces")

    @provinces.setter
    def provinces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "provinces", value)

    @_builtins.property
    @pulumi.getter(name="requireCn")
    def require_cn(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to force CN usage
        """
        return pulumi.get(self, "require_cn")

    @require_cn.setter
    def require_cn(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "require_cn", value)

    @_builtins.property
    @pulumi.getter(name="serialNumberSource")
    def serial_number_source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the source of the subject serial number. Valid values are json-csr (default) or json. When set to json-csr, the subject serial number is taken from the serial_number parameter and falls back to the serial number in the CSR. When set to json, the subject serial number is taken from the serial_number parameter but will ignore any value in the CSR. For backwards compatibility an empty value for this field will default to the json-csr behavior.

        Example usage:
        """
        return pulumi.get(self, "serial_number_source")

    @serial_number_source.setter
    def serial_number_source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "serial_number_source", value)

    @_builtins.property
    @pulumi.getter(name="serverFlag")
    def server_flag(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to specify certificates for server use
        """
        return pulumi.get(self, "server_flag")

    @server_flag.setter
    def server_flag(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "server_flag", value)

    @_builtins.property
    @pulumi.getter(name="signatureBits")
    def signature_bits(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of bits to use in the signature algorithm
        """
        return pulumi.get(self, "signature_bits")

    @signature_bits.setter
    def signature_bits(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "signature_bits", value)

    @_builtins.property
    @pulumi.getter(name="streetAddresses")
    def street_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The street address of generated certificates
        """
        return pulumi.get(self, "street_addresses")

    @street_addresses.setter
    def street_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "street_addresses", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The TTL, in seconds, for any certificate issued against this role.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter(name="useCsrCommonName")
    def use_csr_common_name(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to use the CN in the CSR
        """
        return pulumi.get(self, "use_csr_common_name")

    @use_csr_common_name.setter
    def use_csr_common_name(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_csr_common_name", value)

    @_builtins.property
    @pulumi.getter(name="useCsrSans")
    def use_csr_sans(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to use the SANs in the CSR
        """
        return pulumi.get(self, "use_csr_sans")

    @use_csr_sans.setter
    def use_csr_sans(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_csr_sans", value)

    @_builtins.property
    @pulumi.getter(name="usePss")
    def use_pss(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether or not to use PSS signatures over PKCS#1v1.5 signatures when a RSA-type issuer is used. Ignored for ECDSA/Ed25519 issuers.
        """
        return pulumi.get(self, "use_pss")

    @use_pss.setter
    def use_pss(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_pss", value)


@pulumi.input_type
class _SecretBackendRoleState:
    def __init__(__self__, *,
                 allow_any_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_bare_domains: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_glob_domains: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_ip_sans: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_localhost: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_subdomains: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_wildcard_certificates: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_domains_template: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_serial_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_uri_sans_template: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 basic_constraints_valid_for_non_ca: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_flag: Optional[pulumi.Input[_builtins.bool]] = None,
                 cn_validations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 code_signing_flag: Optional[pulumi.Input[_builtins.bool]] = None,
                 countries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 email_protection_flag: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_hostnames: Optional[pulumi.Input[_builtins.bool]] = None,
                 ext_key_usage_oids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ext_key_usages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 generate_lease: Optional[pulumi.Input[_builtins.bool]] = None,
                 issuer_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 key_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key_usages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 localities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 max_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 no_store: Optional[pulumi.Input[_builtins.bool]] = None,
                 no_store_metadata: Optional[pulumi.Input[_builtins.bool]] = None,
                 not_after: Optional[pulumi.Input[_builtins.str]] = None,
                 not_before_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_unit: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 organizations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 policy_identifier: Optional[pulumi.Input[Sequence[pulumi.Input['SecretBackendRolePolicyIdentifierArgs']]]] = None,
                 policy_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 postal_codes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 provinces: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 require_cn: Optional[pulumi.Input[_builtins.bool]] = None,
                 serial_number_source: Optional[pulumi.Input[_builtins.str]] = None,
                 server_flag: Optional[pulumi.Input[_builtins.bool]] = None,
                 signature_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 street_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 use_csr_common_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_csr_sans: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_pss: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering SecretBackendRole resources.
        :param pulumi.Input[_builtins.bool] allow_any_name: Flag to allow any name
        :param pulumi.Input[_builtins.bool] allow_bare_domains: Flag to allow certificates matching the actual domain
        :param pulumi.Input[_builtins.bool] allow_glob_domains: Flag to allow names containing glob patterns.
        :param pulumi.Input[_builtins.bool] allow_ip_sans: Flag to allow IP SANs
        :param pulumi.Input[_builtins.bool] allow_localhost: Flag to allow certificates for localhost
        :param pulumi.Input[_builtins.bool] allow_subdomains: Flag to allow certificates matching subdomains
        :param pulumi.Input[_builtins.bool] allow_wildcard_certificates: Flag to allow wildcard certificates.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_domains: List of allowed domains for certificates
        :param pulumi.Input[_builtins.bool] allowed_domains_template: Flag, if set, `allowed_domains` can be specified using identity template expressions such as `{{identity.entity.aliases.<mount accessor>.name}}`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_other_sans: Defines allowed custom SANs
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_serial_numbers: An array of allowed serial numbers to put in Subject
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_uri_sans: Defines allowed URI SANs
        :param pulumi.Input[_builtins.bool] allowed_uri_sans_template: Flag, if set, `allowed_uri_sans` can be specified using identity template expressions such as `{{identity.entity.aliases.<mount accessor>.name}}`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_user_ids: Defines allowed User IDs
        :param pulumi.Input[_builtins.str] backend: The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.bool] basic_constraints_valid_for_non_ca: Flag to mark basic constraints valid when issuing non-CA certificates
        :param pulumi.Input[_builtins.bool] client_flag: Flag to specify certificates for client use
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cn_validations: Validations to run on the Common Name field of the certificate, choices: `email`, `hostname`, `disabled`
        :param pulumi.Input[_builtins.bool] code_signing_flag: Flag to specify certificates for code signing use
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] countries: The country of generated certificates
        :param pulumi.Input[_builtins.bool] email_protection_flag: Flag to specify certificates for email protection use
        :param pulumi.Input[_builtins.bool] enforce_hostnames: Flag to allow only valid host names
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ext_key_usage_oids: Specify the allowed extended key usage OIDs constraint on issued certificates
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ext_key_usages: Specify the allowed extended key usage constraint on issued certificates
        :param pulumi.Input[_builtins.bool] generate_lease: Flag to generate leases with certificates
        :param pulumi.Input[_builtins.str] issuer_ref: Specifies the default issuer of this request. May
               be the value `default`, a name, or an issuer ID. Use ACLs to prevent access to
               the `/pki/issuer/:issuer_ref/{issue,sign}/:name` paths to prevent users
               overriding the role's `issuer_ref` value.
        :param pulumi.Input[_builtins.int] key_bits: The number of bits of generated keys
        :param pulumi.Input[_builtins.str] key_type: The generated key type, choices: `rsa`, `ec`, `ed25519`, `any`
               Defaults to `rsa`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] key_usages: Specify the allowed key usage constraint on issued
               certificates. Defaults to `["DigitalSignature", "KeyAgreement", "KeyEncipherment"])`.
               To specify no default key usage constraints, set this to an empty list `[]`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] localities: The locality of generated certificates
        :param pulumi.Input[_builtins.str] max_ttl: The maximum lease TTL, in seconds, for the role.
        :param pulumi.Input[_builtins.str] name: The name to identify this role within the backend. Must be unique within the backend.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.bool] no_store: Flag to not store certificates in the storage backend
        :param pulumi.Input[_builtins.bool] no_store_metadata: Allows metadata to be stored keyed on the certificate's serial number. The field is independent of no_store, allowing metadata storage regardless of whether certificates are stored. If true, metadata is not stored and an error is returned if the metadata field is specified on issuance APIs
        :param pulumi.Input[_builtins.str] not_after: Set the Not After field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ. Supports the Y10K end date for IEEE 802.1AR-2018 standard devices, 9999-12-31T23:59:59Z.
        :param pulumi.Input[_builtins.str] not_before_duration: Specifies the duration by which to backdate the NotBefore property.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] organization_unit: The organization unit of generated certificates
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] organizations: The organization of generated certificates
        :param pulumi.Input[Sequence[pulumi.Input['SecretBackendRolePolicyIdentifierArgs']]] policy_identifier: (Vault 1.11+ only) A block for specifying policy identifers. The `policy_identifier` block can be repeated, and supports the following arguments:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policy_identifiers: Specify the list of allowed policies OIDs. Use with Vault 1.10 or before. For Vault 1.11+, use `policy_identifier` blocks instead
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] postal_codes: The postal code of generated certificates
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] provinces: The province of generated certificates
        :param pulumi.Input[_builtins.bool] require_cn: Flag to force CN usage
        :param pulumi.Input[_builtins.str] serial_number_source: Specifies the source of the subject serial number. Valid values are json-csr (default) or json. When set to json-csr, the subject serial number is taken from the serial_number parameter and falls back to the serial number in the CSR. When set to json, the subject serial number is taken from the serial_number parameter but will ignore any value in the CSR. For backwards compatibility an empty value for this field will default to the json-csr behavior.
               
               Example usage:
        :param pulumi.Input[_builtins.bool] server_flag: Flag to specify certificates for server use
        :param pulumi.Input[_builtins.int] signature_bits: The number of bits to use in the signature algorithm
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] street_addresses: The street address of generated certificates
        :param pulumi.Input[_builtins.str] ttl: The TTL, in seconds, for any certificate issued against this role.
        :param pulumi.Input[_builtins.bool] use_csr_common_name: Flag to use the CN in the CSR
        :param pulumi.Input[_builtins.bool] use_csr_sans: Flag to use the SANs in the CSR
        :param pulumi.Input[_builtins.bool] use_pss: Specifies whether or not to use PSS signatures over PKCS#1v1.5 signatures when a RSA-type issuer is used. Ignored for ECDSA/Ed25519 issuers.
        """
        if allow_any_name is not None:
            pulumi.set(__self__, "allow_any_name", allow_any_name)
        if allow_bare_domains is not None:
            pulumi.set(__self__, "allow_bare_domains", allow_bare_domains)
        if allow_glob_domains is not None:
            pulumi.set(__self__, "allow_glob_domains", allow_glob_domains)
        if allow_ip_sans is not None:
            pulumi.set(__self__, "allow_ip_sans", allow_ip_sans)
        if allow_localhost is not None:
            pulumi.set(__self__, "allow_localhost", allow_localhost)
        if allow_subdomains is not None:
            pulumi.set(__self__, "allow_subdomains", allow_subdomains)
        if allow_wildcard_certificates is not None:
            pulumi.set(__self__, "allow_wildcard_certificates", allow_wildcard_certificates)
        if allowed_domains is not None:
            pulumi.set(__self__, "allowed_domains", allowed_domains)
        if allowed_domains_template is not None:
            pulumi.set(__self__, "allowed_domains_template", allowed_domains_template)
        if allowed_other_sans is not None:
            pulumi.set(__self__, "allowed_other_sans", allowed_other_sans)
        if allowed_serial_numbers is not None:
            pulumi.set(__self__, "allowed_serial_numbers", allowed_serial_numbers)
        if allowed_uri_sans is not None:
            pulumi.set(__self__, "allowed_uri_sans", allowed_uri_sans)
        if allowed_uri_sans_template is not None:
            pulumi.set(__self__, "allowed_uri_sans_template", allowed_uri_sans_template)
        if allowed_user_ids is not None:
            pulumi.set(__self__, "allowed_user_ids", allowed_user_ids)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if basic_constraints_valid_for_non_ca is not None:
            pulumi.set(__self__, "basic_constraints_valid_for_non_ca", basic_constraints_valid_for_non_ca)
        if client_flag is not None:
            pulumi.set(__self__, "client_flag", client_flag)
        if cn_validations is not None:
            pulumi.set(__self__, "cn_validations", cn_validations)
        if code_signing_flag is not None:
            pulumi.set(__self__, "code_signing_flag", code_signing_flag)
        if countries is not None:
            pulumi.set(__self__, "countries", countries)
        if email_protection_flag is not None:
            pulumi.set(__self__, "email_protection_flag", email_protection_flag)
        if enforce_hostnames is not None:
            pulumi.set(__self__, "enforce_hostnames", enforce_hostnames)
        if ext_key_usage_oids is not None:
            pulumi.set(__self__, "ext_key_usage_oids", ext_key_usage_oids)
        if ext_key_usages is not None:
            pulumi.set(__self__, "ext_key_usages", ext_key_usages)
        if generate_lease is not None:
            pulumi.set(__self__, "generate_lease", generate_lease)
        if issuer_ref is not None:
            pulumi.set(__self__, "issuer_ref", issuer_ref)
        if key_bits is not None:
            pulumi.set(__self__, "key_bits", key_bits)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if key_usages is not None:
            pulumi.set(__self__, "key_usages", key_usages)
        if localities is not None:
            pulumi.set(__self__, "localities", localities)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if no_store is not None:
            pulumi.set(__self__, "no_store", no_store)
        if no_store_metadata is not None:
            pulumi.set(__self__, "no_store_metadata", no_store_metadata)
        if not_after is not None:
            pulumi.set(__self__, "not_after", not_after)
        if not_before_duration is not None:
            pulumi.set(__self__, "not_before_duration", not_before_duration)
        if organization_unit is not None:
            pulumi.set(__self__, "organization_unit", organization_unit)
        if organizations is not None:
            pulumi.set(__self__, "organizations", organizations)
        if policy_identifier is not None:
            pulumi.set(__self__, "policy_identifier", policy_identifier)
        if policy_identifiers is not None:
            pulumi.set(__self__, "policy_identifiers", policy_identifiers)
        if postal_codes is not None:
            pulumi.set(__self__, "postal_codes", postal_codes)
        if provinces is not None:
            pulumi.set(__self__, "provinces", provinces)
        if require_cn is not None:
            pulumi.set(__self__, "require_cn", require_cn)
        if serial_number_source is not None:
            pulumi.set(__self__, "serial_number_source", serial_number_source)
        if server_flag is not None:
            pulumi.set(__self__, "server_flag", server_flag)
        if signature_bits is not None:
            pulumi.set(__self__, "signature_bits", signature_bits)
        if street_addresses is not None:
            pulumi.set(__self__, "street_addresses", street_addresses)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if use_csr_common_name is not None:
            pulumi.set(__self__, "use_csr_common_name", use_csr_common_name)
        if use_csr_sans is not None:
            pulumi.set(__self__, "use_csr_sans", use_csr_sans)
        if use_pss is not None:
            pulumi.set(__self__, "use_pss", use_pss)

    @_builtins.property
    @pulumi.getter(name="allowAnyName")
    def allow_any_name(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to allow any name
        """
        return pulumi.get(self, "allow_any_name")

    @allow_any_name.setter
    def allow_any_name(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_any_name", value)

    @_builtins.property
    @pulumi.getter(name="allowBareDomains")
    def allow_bare_domains(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to allow certificates matching the actual domain
        """
        return pulumi.get(self, "allow_bare_domains")

    @allow_bare_domains.setter
    def allow_bare_domains(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_bare_domains", value)

    @_builtins.property
    @pulumi.getter(name="allowGlobDomains")
    def allow_glob_domains(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to allow names containing glob patterns.
        """
        return pulumi.get(self, "allow_glob_domains")

    @allow_glob_domains.setter
    def allow_glob_domains(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_glob_domains", value)

    @_builtins.property
    @pulumi.getter(name="allowIpSans")
    def allow_ip_sans(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to allow IP SANs
        """
        return pulumi.get(self, "allow_ip_sans")

    @allow_ip_sans.setter
    def allow_ip_sans(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_ip_sans", value)

    @_builtins.property
    @pulumi.getter(name="allowLocalhost")
    def allow_localhost(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to allow certificates for localhost
        """
        return pulumi.get(self, "allow_localhost")

    @allow_localhost.setter
    def allow_localhost(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_localhost", value)

    @_builtins.property
    @pulumi.getter(name="allowSubdomains")
    def allow_subdomains(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to allow certificates matching subdomains
        """
        return pulumi.get(self, "allow_subdomains")

    @allow_subdomains.setter
    def allow_subdomains(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_subdomains", value)

    @_builtins.property
    @pulumi.getter(name="allowWildcardCertificates")
    def allow_wildcard_certificates(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to allow wildcard certificates.
        """
        return pulumi.get(self, "allow_wildcard_certificates")

    @allow_wildcard_certificates.setter
    def allow_wildcard_certificates(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_wildcard_certificates", value)

    @_builtins.property
    @pulumi.getter(name="allowedDomains")
    def allowed_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of allowed domains for certificates
        """
        return pulumi.get(self, "allowed_domains")

    @allowed_domains.setter
    def allowed_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_domains", value)

    @_builtins.property
    @pulumi.getter(name="allowedDomainsTemplate")
    def allowed_domains_template(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag, if set, `allowed_domains` can be specified using identity template expressions such as `{{identity.entity.aliases.<mount accessor>.name}}`.
        """
        return pulumi.get(self, "allowed_domains_template")

    @allowed_domains_template.setter
    def allowed_domains_template(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allowed_domains_template", value)

    @_builtins.property
    @pulumi.getter(name="allowedOtherSans")
    def allowed_other_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Defines allowed custom SANs
        """
        return pulumi.get(self, "allowed_other_sans")

    @allowed_other_sans.setter
    def allowed_other_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_other_sans", value)

    @_builtins.property
    @pulumi.getter(name="allowedSerialNumbers")
    def allowed_serial_numbers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An array of allowed serial numbers to put in Subject
        """
        return pulumi.get(self, "allowed_serial_numbers")

    @allowed_serial_numbers.setter
    def allowed_serial_numbers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_serial_numbers", value)

    @_builtins.property
    @pulumi.getter(name="allowedUriSans")
    def allowed_uri_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Defines allowed URI SANs
        """
        return pulumi.get(self, "allowed_uri_sans")

    @allowed_uri_sans.setter
    def allowed_uri_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_uri_sans", value)

    @_builtins.property
    @pulumi.getter(name="allowedUriSansTemplate")
    def allowed_uri_sans_template(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag, if set, `allowed_uri_sans` can be specified using identity template expressions such as `{{identity.entity.aliases.<mount accessor>.name}}`.
        """
        return pulumi.get(self, "allowed_uri_sans_template")

    @allowed_uri_sans_template.setter
    def allowed_uri_sans_template(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allowed_uri_sans_template", value)

    @_builtins.property
    @pulumi.getter(name="allowedUserIds")
    def allowed_user_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Defines allowed User IDs
        """
        return pulumi.get(self, "allowed_user_ids")

    @allowed_user_ids.setter
    def allowed_user_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_user_ids", value)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="basicConstraintsValidForNonCa")
    def basic_constraints_valid_for_non_ca(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to mark basic constraints valid when issuing non-CA certificates
        """
        return pulumi.get(self, "basic_constraints_valid_for_non_ca")

    @basic_constraints_valid_for_non_ca.setter
    def basic_constraints_valid_for_non_ca(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "basic_constraints_valid_for_non_ca", value)

    @_builtins.property
    @pulumi.getter(name="clientFlag")
    def client_flag(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to specify certificates for client use
        """
        return pulumi.get(self, "client_flag")

    @client_flag.setter
    def client_flag(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "client_flag", value)

    @_builtins.property
    @pulumi.getter(name="cnValidations")
    def cn_validations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Validations to run on the Common Name field of the certificate, choices: `email`, `hostname`, `disabled`
        """
        return pulumi.get(self, "cn_validations")

    @cn_validations.setter
    def cn_validations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "cn_validations", value)

    @_builtins.property
    @pulumi.getter(name="codeSigningFlag")
    def code_signing_flag(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to specify certificates for code signing use
        """
        return pulumi.get(self, "code_signing_flag")

    @code_signing_flag.setter
    def code_signing_flag(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "code_signing_flag", value)

    @_builtins.property
    @pulumi.getter
    def countries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The country of generated certificates
        """
        return pulumi.get(self, "countries")

    @countries.setter
    def countries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "countries", value)

    @_builtins.property
    @pulumi.getter(name="emailProtectionFlag")
    def email_protection_flag(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to specify certificates for email protection use
        """
        return pulumi.get(self, "email_protection_flag")

    @email_protection_flag.setter
    def email_protection_flag(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "email_protection_flag", value)

    @_builtins.property
    @pulumi.getter(name="enforceHostnames")
    def enforce_hostnames(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to allow only valid host names
        """
        return pulumi.get(self, "enforce_hostnames")

    @enforce_hostnames.setter
    def enforce_hostnames(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enforce_hostnames", value)

    @_builtins.property
    @pulumi.getter(name="extKeyUsageOids")
    def ext_key_usage_oids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specify the allowed extended key usage OIDs constraint on issued certificates
        """
        return pulumi.get(self, "ext_key_usage_oids")

    @ext_key_usage_oids.setter
    def ext_key_usage_oids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ext_key_usage_oids", value)

    @_builtins.property
    @pulumi.getter(name="extKeyUsages")
    def ext_key_usages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specify the allowed extended key usage constraint on issued certificates
        """
        return pulumi.get(self, "ext_key_usages")

    @ext_key_usages.setter
    def ext_key_usages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ext_key_usages", value)

    @_builtins.property
    @pulumi.getter(name="generateLease")
    def generate_lease(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to generate leases with certificates
        """
        return pulumi.get(self, "generate_lease")

    @generate_lease.setter
    def generate_lease(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "generate_lease", value)

    @_builtins.property
    @pulumi.getter(name="issuerRef")
    def issuer_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the default issuer of this request. May
        be the value `default`, a name, or an issuer ID. Use ACLs to prevent access to
        the `/pki/issuer/:issuer_ref/{issue,sign}/:name` paths to prevent users
        overriding the role's `issuer_ref` value.
        """
        return pulumi.get(self, "issuer_ref")

    @issuer_ref.setter
    def issuer_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer_ref", value)

    @_builtins.property
    @pulumi.getter(name="keyBits")
    def key_bits(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of bits of generated keys
        """
        return pulumi.get(self, "key_bits")

    @key_bits.setter
    def key_bits(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "key_bits", value)

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The generated key type, choices: `rsa`, `ec`, `ed25519`, `any`
        Defaults to `rsa`
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_type", value)

    @_builtins.property
    @pulumi.getter(name="keyUsages")
    def key_usages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specify the allowed key usage constraint on issued
        certificates. Defaults to `["DigitalSignature", "KeyAgreement", "KeyEncipherment"])`.
        To specify no default key usage constraints, set this to an empty list `[]`.
        """
        return pulumi.get(self, "key_usages")

    @key_usages.setter
    def key_usages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "key_usages", value)

    @_builtins.property
    @pulumi.getter
    def localities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The locality of generated certificates
        """
        return pulumi.get(self, "localities")

    @localities.setter
    def localities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "localities", value)

    @_builtins.property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maximum lease TTL, in seconds, for the role.
        """
        return pulumi.get(self, "max_ttl")

    @max_ttl.setter
    def max_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_ttl", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name to identify this role within the backend. Must be unique within the backend.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="noStore")
    def no_store(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to not store certificates in the storage backend
        """
        return pulumi.get(self, "no_store")

    @no_store.setter
    def no_store(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "no_store", value)

    @_builtins.property
    @pulumi.getter(name="noStoreMetadata")
    def no_store_metadata(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allows metadata to be stored keyed on the certificate's serial number. The field is independent of no_store, allowing metadata storage regardless of whether certificates are stored. If true, metadata is not stored and an error is returned if the metadata field is specified on issuance APIs
        """
        return pulumi.get(self, "no_store_metadata")

    @no_store_metadata.setter
    def no_store_metadata(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "no_store_metadata", value)

    @_builtins.property
    @pulumi.getter(name="notAfter")
    def not_after(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the Not After field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ. Supports the Y10K end date for IEEE 802.1AR-2018 standard devices, 9999-12-31T23:59:59Z.
        """
        return pulumi.get(self, "not_after")

    @not_after.setter
    def not_after(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "not_after", value)

    @_builtins.property
    @pulumi.getter(name="notBeforeDuration")
    def not_before_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the duration by which to backdate the NotBefore property.
        """
        return pulumi.get(self, "not_before_duration")

    @not_before_duration.setter
    def not_before_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "not_before_duration", value)

    @_builtins.property
    @pulumi.getter(name="organizationUnit")
    def organization_unit(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The organization unit of generated certificates
        """
        return pulumi.get(self, "organization_unit")

    @organization_unit.setter
    def organization_unit(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "organization_unit", value)

    @_builtins.property
    @pulumi.getter
    def organizations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The organization of generated certificates
        """
        return pulumi.get(self, "organizations")

    @organizations.setter
    def organizations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "organizations", value)

    @_builtins.property
    @pulumi.getter(name="policyIdentifier")
    def policy_identifier(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretBackendRolePolicyIdentifierArgs']]]]:
        """
        (Vault 1.11+ only) A block for specifying policy identifers. The `policy_identifier` block can be repeated, and supports the following arguments:
        """
        return pulumi.get(self, "policy_identifier")

    @policy_identifier.setter
    def policy_identifier(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretBackendRolePolicyIdentifierArgs']]]]):
        pulumi.set(self, "policy_identifier", value)

    @_builtins.property
    @pulumi.getter(name="policyIdentifiers")
    def policy_identifiers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specify the list of allowed policies OIDs. Use with Vault 1.10 or before. For Vault 1.11+, use `policy_identifier` blocks instead
        """
        return pulumi.get(self, "policy_identifiers")

    @policy_identifiers.setter
    def policy_identifiers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "policy_identifiers", value)

    @_builtins.property
    @pulumi.getter(name="postalCodes")
    def postal_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The postal code of generated certificates
        """
        return pulumi.get(self, "postal_codes")

    @postal_codes.setter
    def postal_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "postal_codes", value)

    @_builtins.property
    @pulumi.getter
    def provinces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The province of generated certificates
        """
        return pulumi.get(self, "provinces")

    @provinces.setter
    def provinces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "provinces", value)

    @_builtins.property
    @pulumi.getter(name="requireCn")
    def require_cn(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to force CN usage
        """
        return pulumi.get(self, "require_cn")

    @require_cn.setter
    def require_cn(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "require_cn", value)

    @_builtins.property
    @pulumi.getter(name="serialNumberSource")
    def serial_number_source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the source of the subject serial number. Valid values are json-csr (default) or json. When set to json-csr, the subject serial number is taken from the serial_number parameter and falls back to the serial number in the CSR. When set to json, the subject serial number is taken from the serial_number parameter but will ignore any value in the CSR. For backwards compatibility an empty value for this field will default to the json-csr behavior.

        Example usage:
        """
        return pulumi.get(self, "serial_number_source")

    @serial_number_source.setter
    def serial_number_source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "serial_number_source", value)

    @_builtins.property
    @pulumi.getter(name="serverFlag")
    def server_flag(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to specify certificates for server use
        """
        return pulumi.get(self, "server_flag")

    @server_flag.setter
    def server_flag(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "server_flag", value)

    @_builtins.property
    @pulumi.getter(name="signatureBits")
    def signature_bits(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of bits to use in the signature algorithm
        """
        return pulumi.get(self, "signature_bits")

    @signature_bits.setter
    def signature_bits(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "signature_bits", value)

    @_builtins.property
    @pulumi.getter(name="streetAddresses")
    def street_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The street address of generated certificates
        """
        return pulumi.get(self, "street_addresses")

    @street_addresses.setter
    def street_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "street_addresses", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The TTL, in seconds, for any certificate issued against this role.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter(name="useCsrCommonName")
    def use_csr_common_name(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to use the CN in the CSR
        """
        return pulumi.get(self, "use_csr_common_name")

    @use_csr_common_name.setter
    def use_csr_common_name(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_csr_common_name", value)

    @_builtins.property
    @pulumi.getter(name="useCsrSans")
    def use_csr_sans(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to use the SANs in the CSR
        """
        return pulumi.get(self, "use_csr_sans")

    @use_csr_sans.setter
    def use_csr_sans(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_csr_sans", value)

    @_builtins.property
    @pulumi.getter(name="usePss")
    def use_pss(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether or not to use PSS signatures over PKCS#1v1.5 signatures when a RSA-type issuer is used. Ignored for ECDSA/Ed25519 issuers.
        """
        return pulumi.get(self, "use_pss")

    @use_pss.setter
    def use_pss(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_pss", value)


@pulumi.type_token("vault:pkiSecret/secretBackendRole:SecretBackendRole")
class SecretBackendRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_any_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_bare_domains: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_glob_domains: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_ip_sans: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_localhost: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_subdomains: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_wildcard_certificates: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_domains_template: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_serial_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_uri_sans_template: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 basic_constraints_valid_for_non_ca: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_flag: Optional[pulumi.Input[_builtins.bool]] = None,
                 cn_validations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 code_signing_flag: Optional[pulumi.Input[_builtins.bool]] = None,
                 countries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 email_protection_flag: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_hostnames: Optional[pulumi.Input[_builtins.bool]] = None,
                 ext_key_usage_oids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ext_key_usages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 generate_lease: Optional[pulumi.Input[_builtins.bool]] = None,
                 issuer_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 key_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key_usages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 localities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 max_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 no_store: Optional[pulumi.Input[_builtins.bool]] = None,
                 no_store_metadata: Optional[pulumi.Input[_builtins.bool]] = None,
                 not_after: Optional[pulumi.Input[_builtins.str]] = None,
                 not_before_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_unit: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 organizations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 policy_identifier: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretBackendRolePolicyIdentifierArgs', 'SecretBackendRolePolicyIdentifierArgsDict']]]]] = None,
                 policy_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 postal_codes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 provinces: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 require_cn: Optional[pulumi.Input[_builtins.bool]] = None,
                 serial_number_source: Optional[pulumi.Input[_builtins.str]] = None,
                 server_flag: Optional[pulumi.Input[_builtins.bool]] = None,
                 signature_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 street_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 use_csr_common_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_csr_sans: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_pss: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Creates a role on an PKI Secret Backend for Vault.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        pki = vault.Mount("pki",
            path="pki",
            type="pki",
            default_lease_ttl_seconds=3600,
            max_lease_ttl_seconds=86400)
        role = vault.pkisecret.SecretBackendRole("role",
            backend=pki.path,
            name="my_role",
            ttl="3600",
            allow_ip_sans=True,
            key_type="rsa",
            key_bits=4096,
            allowed_domains=[
                "example.com",
                "my.domain",
            ],
            allow_subdomains=True)
        ```

        ## Import

        PKI secret backend roles can be imported using the `path`, e.g.

        ```sh
        $ pulumi import vault:pkiSecret/secretBackendRole:SecretBackendRole role pki/roles/my_role
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_any_name: Flag to allow any name
        :param pulumi.Input[_builtins.bool] allow_bare_domains: Flag to allow certificates matching the actual domain
        :param pulumi.Input[_builtins.bool] allow_glob_domains: Flag to allow names containing glob patterns.
        :param pulumi.Input[_builtins.bool] allow_ip_sans: Flag to allow IP SANs
        :param pulumi.Input[_builtins.bool] allow_localhost: Flag to allow certificates for localhost
        :param pulumi.Input[_builtins.bool] allow_subdomains: Flag to allow certificates matching subdomains
        :param pulumi.Input[_builtins.bool] allow_wildcard_certificates: Flag to allow wildcard certificates.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_domains: List of allowed domains for certificates
        :param pulumi.Input[_builtins.bool] allowed_domains_template: Flag, if set, `allowed_domains` can be specified using identity template expressions such as `{{identity.entity.aliases.<mount accessor>.name}}`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_other_sans: Defines allowed custom SANs
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_serial_numbers: An array of allowed serial numbers to put in Subject
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_uri_sans: Defines allowed URI SANs
        :param pulumi.Input[_builtins.bool] allowed_uri_sans_template: Flag, if set, `allowed_uri_sans` can be specified using identity template expressions such as `{{identity.entity.aliases.<mount accessor>.name}}`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_user_ids: Defines allowed User IDs
        :param pulumi.Input[_builtins.str] backend: The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.bool] basic_constraints_valid_for_non_ca: Flag to mark basic constraints valid when issuing non-CA certificates
        :param pulumi.Input[_builtins.bool] client_flag: Flag to specify certificates for client use
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cn_validations: Validations to run on the Common Name field of the certificate, choices: `email`, `hostname`, `disabled`
        :param pulumi.Input[_builtins.bool] code_signing_flag: Flag to specify certificates for code signing use
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] countries: The country of generated certificates
        :param pulumi.Input[_builtins.bool] email_protection_flag: Flag to specify certificates for email protection use
        :param pulumi.Input[_builtins.bool] enforce_hostnames: Flag to allow only valid host names
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ext_key_usage_oids: Specify the allowed extended key usage OIDs constraint on issued certificates
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ext_key_usages: Specify the allowed extended key usage constraint on issued certificates
        :param pulumi.Input[_builtins.bool] generate_lease: Flag to generate leases with certificates
        :param pulumi.Input[_builtins.str] issuer_ref: Specifies the default issuer of this request. May
               be the value `default`, a name, or an issuer ID. Use ACLs to prevent access to
               the `/pki/issuer/:issuer_ref/{issue,sign}/:name` paths to prevent users
               overriding the role's `issuer_ref` value.
        :param pulumi.Input[_builtins.int] key_bits: The number of bits of generated keys
        :param pulumi.Input[_builtins.str] key_type: The generated key type, choices: `rsa`, `ec`, `ed25519`, `any`
               Defaults to `rsa`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] key_usages: Specify the allowed key usage constraint on issued
               certificates. Defaults to `["DigitalSignature", "KeyAgreement", "KeyEncipherment"])`.
               To specify no default key usage constraints, set this to an empty list `[]`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] localities: The locality of generated certificates
        :param pulumi.Input[_builtins.str] max_ttl: The maximum lease TTL, in seconds, for the role.
        :param pulumi.Input[_builtins.str] name: The name to identify this role within the backend. Must be unique within the backend.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.bool] no_store: Flag to not store certificates in the storage backend
        :param pulumi.Input[_builtins.bool] no_store_metadata: Allows metadata to be stored keyed on the certificate's serial number. The field is independent of no_store, allowing metadata storage regardless of whether certificates are stored. If true, metadata is not stored and an error is returned if the metadata field is specified on issuance APIs
        :param pulumi.Input[_builtins.str] not_after: Set the Not After field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ. Supports the Y10K end date for IEEE 802.1AR-2018 standard devices, 9999-12-31T23:59:59Z.
        :param pulumi.Input[_builtins.str] not_before_duration: Specifies the duration by which to backdate the NotBefore property.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] organization_unit: The organization unit of generated certificates
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] organizations: The organization of generated certificates
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretBackendRolePolicyIdentifierArgs', 'SecretBackendRolePolicyIdentifierArgsDict']]]] policy_identifier: (Vault 1.11+ only) A block for specifying policy identifers. The `policy_identifier` block can be repeated, and supports the following arguments:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policy_identifiers: Specify the list of allowed policies OIDs. Use with Vault 1.10 or before. For Vault 1.11+, use `policy_identifier` blocks instead
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] postal_codes: The postal code of generated certificates
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] provinces: The province of generated certificates
        :param pulumi.Input[_builtins.bool] require_cn: Flag to force CN usage
        :param pulumi.Input[_builtins.str] serial_number_source: Specifies the source of the subject serial number. Valid values are json-csr (default) or json. When set to json-csr, the subject serial number is taken from the serial_number parameter and falls back to the serial number in the CSR. When set to json, the subject serial number is taken from the serial_number parameter but will ignore any value in the CSR. For backwards compatibility an empty value for this field will default to the json-csr behavior.
               
               Example usage:
        :param pulumi.Input[_builtins.bool] server_flag: Flag to specify certificates for server use
        :param pulumi.Input[_builtins.int] signature_bits: The number of bits to use in the signature algorithm
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] street_addresses: The street address of generated certificates
        :param pulumi.Input[_builtins.str] ttl: The TTL, in seconds, for any certificate issued against this role.
        :param pulumi.Input[_builtins.bool] use_csr_common_name: Flag to use the CN in the CSR
        :param pulumi.Input[_builtins.bool] use_csr_sans: Flag to use the SANs in the CSR
        :param pulumi.Input[_builtins.bool] use_pss: Specifies whether or not to use PSS signatures over PKCS#1v1.5 signatures when a RSA-type issuer is used. Ignored for ECDSA/Ed25519 issuers.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretBackendRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a role on an PKI Secret Backend for Vault.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        pki = vault.Mount("pki",
            path="pki",
            type="pki",
            default_lease_ttl_seconds=3600,
            max_lease_ttl_seconds=86400)
        role = vault.pkisecret.SecretBackendRole("role",
            backend=pki.path,
            name="my_role",
            ttl="3600",
            allow_ip_sans=True,
            key_type="rsa",
            key_bits=4096,
            allowed_domains=[
                "example.com",
                "my.domain",
            ],
            allow_subdomains=True)
        ```

        ## Import

        PKI secret backend roles can be imported using the `path`, e.g.

        ```sh
        $ pulumi import vault:pkiSecret/secretBackendRole:SecretBackendRole role pki/roles/my_role
        ```

        :param str resource_name: The name of the resource.
        :param SecretBackendRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_any_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_bare_domains: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_glob_domains: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_ip_sans: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_localhost: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_subdomains: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_wildcard_certificates: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_domains_template: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_serial_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_uri_sans_template: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 basic_constraints_valid_for_non_ca: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_flag: Optional[pulumi.Input[_builtins.bool]] = None,
                 cn_validations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 code_signing_flag: Optional[pulumi.Input[_builtins.bool]] = None,
                 countries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 email_protection_flag: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_hostnames: Optional[pulumi.Input[_builtins.bool]] = None,
                 ext_key_usage_oids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ext_key_usages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 generate_lease: Optional[pulumi.Input[_builtins.bool]] = None,
                 issuer_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 key_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key_usages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 localities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 max_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 no_store: Optional[pulumi.Input[_builtins.bool]] = None,
                 no_store_metadata: Optional[pulumi.Input[_builtins.bool]] = None,
                 not_after: Optional[pulumi.Input[_builtins.str]] = None,
                 not_before_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_unit: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 organizations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 policy_identifier: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretBackendRolePolicyIdentifierArgs', 'SecretBackendRolePolicyIdentifierArgsDict']]]]] = None,
                 policy_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 postal_codes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 provinces: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 require_cn: Optional[pulumi.Input[_builtins.bool]] = None,
                 serial_number_source: Optional[pulumi.Input[_builtins.str]] = None,
                 server_flag: Optional[pulumi.Input[_builtins.bool]] = None,
                 signature_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 street_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 use_csr_common_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_csr_sans: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_pss: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretBackendRoleArgs.__new__(SecretBackendRoleArgs)

            __props__.__dict__["allow_any_name"] = allow_any_name
            __props__.__dict__["allow_bare_domains"] = allow_bare_domains
            __props__.__dict__["allow_glob_domains"] = allow_glob_domains
            __props__.__dict__["allow_ip_sans"] = allow_ip_sans
            __props__.__dict__["allow_localhost"] = allow_localhost
            __props__.__dict__["allow_subdomains"] = allow_subdomains
            __props__.__dict__["allow_wildcard_certificates"] = allow_wildcard_certificates
            __props__.__dict__["allowed_domains"] = allowed_domains
            __props__.__dict__["allowed_domains_template"] = allowed_domains_template
            __props__.__dict__["allowed_other_sans"] = allowed_other_sans
            __props__.__dict__["allowed_serial_numbers"] = allowed_serial_numbers
            __props__.__dict__["allowed_uri_sans"] = allowed_uri_sans
            __props__.__dict__["allowed_uri_sans_template"] = allowed_uri_sans_template
            __props__.__dict__["allowed_user_ids"] = allowed_user_ids
            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            __props__.__dict__["basic_constraints_valid_for_non_ca"] = basic_constraints_valid_for_non_ca
            __props__.__dict__["client_flag"] = client_flag
            __props__.__dict__["cn_validations"] = cn_validations
            __props__.__dict__["code_signing_flag"] = code_signing_flag
            __props__.__dict__["countries"] = countries
            __props__.__dict__["email_protection_flag"] = email_protection_flag
            __props__.__dict__["enforce_hostnames"] = enforce_hostnames
            __props__.__dict__["ext_key_usage_oids"] = ext_key_usage_oids
            __props__.__dict__["ext_key_usages"] = ext_key_usages
            __props__.__dict__["generate_lease"] = generate_lease
            __props__.__dict__["issuer_ref"] = issuer_ref
            __props__.__dict__["key_bits"] = key_bits
            __props__.__dict__["key_type"] = key_type
            __props__.__dict__["key_usages"] = key_usages
            __props__.__dict__["localities"] = localities
            __props__.__dict__["max_ttl"] = max_ttl
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["no_store"] = no_store
            __props__.__dict__["no_store_metadata"] = no_store_metadata
            __props__.__dict__["not_after"] = not_after
            __props__.__dict__["not_before_duration"] = not_before_duration
            __props__.__dict__["organization_unit"] = organization_unit
            __props__.__dict__["organizations"] = organizations
            __props__.__dict__["policy_identifier"] = policy_identifier
            __props__.__dict__["policy_identifiers"] = policy_identifiers
            __props__.__dict__["postal_codes"] = postal_codes
            __props__.__dict__["provinces"] = provinces
            __props__.__dict__["require_cn"] = require_cn
            __props__.__dict__["serial_number_source"] = serial_number_source
            __props__.__dict__["server_flag"] = server_flag
            __props__.__dict__["signature_bits"] = signature_bits
            __props__.__dict__["street_addresses"] = street_addresses
            __props__.__dict__["ttl"] = ttl
            __props__.__dict__["use_csr_common_name"] = use_csr_common_name
            __props__.__dict__["use_csr_sans"] = use_csr_sans
            __props__.__dict__["use_pss"] = use_pss
        super(SecretBackendRole, __self__).__init__(
            'vault:pkiSecret/secretBackendRole:SecretBackendRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_any_name: Optional[pulumi.Input[_builtins.bool]] = None,
            allow_bare_domains: Optional[pulumi.Input[_builtins.bool]] = None,
            allow_glob_domains: Optional[pulumi.Input[_builtins.bool]] = None,
            allow_ip_sans: Optional[pulumi.Input[_builtins.bool]] = None,
            allow_localhost: Optional[pulumi.Input[_builtins.bool]] = None,
            allow_subdomains: Optional[pulumi.Input[_builtins.bool]] = None,
            allow_wildcard_certificates: Optional[pulumi.Input[_builtins.bool]] = None,
            allowed_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            allowed_domains_template: Optional[pulumi.Input[_builtins.bool]] = None,
            allowed_other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            allowed_serial_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            allowed_uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            allowed_uri_sans_template: Optional[pulumi.Input[_builtins.bool]] = None,
            allowed_user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            basic_constraints_valid_for_non_ca: Optional[pulumi.Input[_builtins.bool]] = None,
            client_flag: Optional[pulumi.Input[_builtins.bool]] = None,
            cn_validations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            code_signing_flag: Optional[pulumi.Input[_builtins.bool]] = None,
            countries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            email_protection_flag: Optional[pulumi.Input[_builtins.bool]] = None,
            enforce_hostnames: Optional[pulumi.Input[_builtins.bool]] = None,
            ext_key_usage_oids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ext_key_usages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            generate_lease: Optional[pulumi.Input[_builtins.bool]] = None,
            issuer_ref: Optional[pulumi.Input[_builtins.str]] = None,
            key_bits: Optional[pulumi.Input[_builtins.int]] = None,
            key_type: Optional[pulumi.Input[_builtins.str]] = None,
            key_usages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            localities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            max_ttl: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            no_store: Optional[pulumi.Input[_builtins.bool]] = None,
            no_store_metadata: Optional[pulumi.Input[_builtins.bool]] = None,
            not_after: Optional[pulumi.Input[_builtins.str]] = None,
            not_before_duration: Optional[pulumi.Input[_builtins.str]] = None,
            organization_unit: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            organizations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            policy_identifier: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretBackendRolePolicyIdentifierArgs', 'SecretBackendRolePolicyIdentifierArgsDict']]]]] = None,
            policy_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            postal_codes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            provinces: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            require_cn: Optional[pulumi.Input[_builtins.bool]] = None,
            serial_number_source: Optional[pulumi.Input[_builtins.str]] = None,
            server_flag: Optional[pulumi.Input[_builtins.bool]] = None,
            signature_bits: Optional[pulumi.Input[_builtins.int]] = None,
            street_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ttl: Optional[pulumi.Input[_builtins.str]] = None,
            use_csr_common_name: Optional[pulumi.Input[_builtins.bool]] = None,
            use_csr_sans: Optional[pulumi.Input[_builtins.bool]] = None,
            use_pss: Optional[pulumi.Input[_builtins.bool]] = None) -> 'SecretBackendRole':
        """
        Get an existing SecretBackendRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_any_name: Flag to allow any name
        :param pulumi.Input[_builtins.bool] allow_bare_domains: Flag to allow certificates matching the actual domain
        :param pulumi.Input[_builtins.bool] allow_glob_domains: Flag to allow names containing glob patterns.
        :param pulumi.Input[_builtins.bool] allow_ip_sans: Flag to allow IP SANs
        :param pulumi.Input[_builtins.bool] allow_localhost: Flag to allow certificates for localhost
        :param pulumi.Input[_builtins.bool] allow_subdomains: Flag to allow certificates matching subdomains
        :param pulumi.Input[_builtins.bool] allow_wildcard_certificates: Flag to allow wildcard certificates.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_domains: List of allowed domains for certificates
        :param pulumi.Input[_builtins.bool] allowed_domains_template: Flag, if set, `allowed_domains` can be specified using identity template expressions such as `{{identity.entity.aliases.<mount accessor>.name}}`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_other_sans: Defines allowed custom SANs
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_serial_numbers: An array of allowed serial numbers to put in Subject
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_uri_sans: Defines allowed URI SANs
        :param pulumi.Input[_builtins.bool] allowed_uri_sans_template: Flag, if set, `allowed_uri_sans` can be specified using identity template expressions such as `{{identity.entity.aliases.<mount accessor>.name}}`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_user_ids: Defines allowed User IDs
        :param pulumi.Input[_builtins.str] backend: The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.bool] basic_constraints_valid_for_non_ca: Flag to mark basic constraints valid when issuing non-CA certificates
        :param pulumi.Input[_builtins.bool] client_flag: Flag to specify certificates for client use
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cn_validations: Validations to run on the Common Name field of the certificate, choices: `email`, `hostname`, `disabled`
        :param pulumi.Input[_builtins.bool] code_signing_flag: Flag to specify certificates for code signing use
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] countries: The country of generated certificates
        :param pulumi.Input[_builtins.bool] email_protection_flag: Flag to specify certificates for email protection use
        :param pulumi.Input[_builtins.bool] enforce_hostnames: Flag to allow only valid host names
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ext_key_usage_oids: Specify the allowed extended key usage OIDs constraint on issued certificates
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ext_key_usages: Specify the allowed extended key usage constraint on issued certificates
        :param pulumi.Input[_builtins.bool] generate_lease: Flag to generate leases with certificates
        :param pulumi.Input[_builtins.str] issuer_ref: Specifies the default issuer of this request. May
               be the value `default`, a name, or an issuer ID. Use ACLs to prevent access to
               the `/pki/issuer/:issuer_ref/{issue,sign}/:name` paths to prevent users
               overriding the role's `issuer_ref` value.
        :param pulumi.Input[_builtins.int] key_bits: The number of bits of generated keys
        :param pulumi.Input[_builtins.str] key_type: The generated key type, choices: `rsa`, `ec`, `ed25519`, `any`
               Defaults to `rsa`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] key_usages: Specify the allowed key usage constraint on issued
               certificates. Defaults to `["DigitalSignature", "KeyAgreement", "KeyEncipherment"])`.
               To specify no default key usage constraints, set this to an empty list `[]`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] localities: The locality of generated certificates
        :param pulumi.Input[_builtins.str] max_ttl: The maximum lease TTL, in seconds, for the role.
        :param pulumi.Input[_builtins.str] name: The name to identify this role within the backend. Must be unique within the backend.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.bool] no_store: Flag to not store certificates in the storage backend
        :param pulumi.Input[_builtins.bool] no_store_metadata: Allows metadata to be stored keyed on the certificate's serial number. The field is independent of no_store, allowing metadata storage regardless of whether certificates are stored. If true, metadata is not stored and an error is returned if the metadata field is specified on issuance APIs
        :param pulumi.Input[_builtins.str] not_after: Set the Not After field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ. Supports the Y10K end date for IEEE 802.1AR-2018 standard devices, 9999-12-31T23:59:59Z.
        :param pulumi.Input[_builtins.str] not_before_duration: Specifies the duration by which to backdate the NotBefore property.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] organization_unit: The organization unit of generated certificates
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] organizations: The organization of generated certificates
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretBackendRolePolicyIdentifierArgs', 'SecretBackendRolePolicyIdentifierArgsDict']]]] policy_identifier: (Vault 1.11+ only) A block for specifying policy identifers. The `policy_identifier` block can be repeated, and supports the following arguments:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policy_identifiers: Specify the list of allowed policies OIDs. Use with Vault 1.10 or before. For Vault 1.11+, use `policy_identifier` blocks instead
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] postal_codes: The postal code of generated certificates
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] provinces: The province of generated certificates
        :param pulumi.Input[_builtins.bool] require_cn: Flag to force CN usage
        :param pulumi.Input[_builtins.str] serial_number_source: Specifies the source of the subject serial number. Valid values are json-csr (default) or json. When set to json-csr, the subject serial number is taken from the serial_number parameter and falls back to the serial number in the CSR. When set to json, the subject serial number is taken from the serial_number parameter but will ignore any value in the CSR. For backwards compatibility an empty value for this field will default to the json-csr behavior.
               
               Example usage:
        :param pulumi.Input[_builtins.bool] server_flag: Flag to specify certificates for server use
        :param pulumi.Input[_builtins.int] signature_bits: The number of bits to use in the signature algorithm
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] street_addresses: The street address of generated certificates
        :param pulumi.Input[_builtins.str] ttl: The TTL, in seconds, for any certificate issued against this role.
        :param pulumi.Input[_builtins.bool] use_csr_common_name: Flag to use the CN in the CSR
        :param pulumi.Input[_builtins.bool] use_csr_sans: Flag to use the SANs in the CSR
        :param pulumi.Input[_builtins.bool] use_pss: Specifies whether or not to use PSS signatures over PKCS#1v1.5 signatures when a RSA-type issuer is used. Ignored for ECDSA/Ed25519 issuers.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretBackendRoleState.__new__(_SecretBackendRoleState)

        __props__.__dict__["allow_any_name"] = allow_any_name
        __props__.__dict__["allow_bare_domains"] = allow_bare_domains
        __props__.__dict__["allow_glob_domains"] = allow_glob_domains
        __props__.__dict__["allow_ip_sans"] = allow_ip_sans
        __props__.__dict__["allow_localhost"] = allow_localhost
        __props__.__dict__["allow_subdomains"] = allow_subdomains
        __props__.__dict__["allow_wildcard_certificates"] = allow_wildcard_certificates
        __props__.__dict__["allowed_domains"] = allowed_domains
        __props__.__dict__["allowed_domains_template"] = allowed_domains_template
        __props__.__dict__["allowed_other_sans"] = allowed_other_sans
        __props__.__dict__["allowed_serial_numbers"] = allowed_serial_numbers
        __props__.__dict__["allowed_uri_sans"] = allowed_uri_sans
        __props__.__dict__["allowed_uri_sans_template"] = allowed_uri_sans_template
        __props__.__dict__["allowed_user_ids"] = allowed_user_ids
        __props__.__dict__["backend"] = backend
        __props__.__dict__["basic_constraints_valid_for_non_ca"] = basic_constraints_valid_for_non_ca
        __props__.__dict__["client_flag"] = client_flag
        __props__.__dict__["cn_validations"] = cn_validations
        __props__.__dict__["code_signing_flag"] = code_signing_flag
        __props__.__dict__["countries"] = countries
        __props__.__dict__["email_protection_flag"] = email_protection_flag
        __props__.__dict__["enforce_hostnames"] = enforce_hostnames
        __props__.__dict__["ext_key_usage_oids"] = ext_key_usage_oids
        __props__.__dict__["ext_key_usages"] = ext_key_usages
        __props__.__dict__["generate_lease"] = generate_lease
        __props__.__dict__["issuer_ref"] = issuer_ref
        __props__.__dict__["key_bits"] = key_bits
        __props__.__dict__["key_type"] = key_type
        __props__.__dict__["key_usages"] = key_usages
        __props__.__dict__["localities"] = localities
        __props__.__dict__["max_ttl"] = max_ttl
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["no_store"] = no_store
        __props__.__dict__["no_store_metadata"] = no_store_metadata
        __props__.__dict__["not_after"] = not_after
        __props__.__dict__["not_before_duration"] = not_before_duration
        __props__.__dict__["organization_unit"] = organization_unit
        __props__.__dict__["organizations"] = organizations
        __props__.__dict__["policy_identifier"] = policy_identifier
        __props__.__dict__["policy_identifiers"] = policy_identifiers
        __props__.__dict__["postal_codes"] = postal_codes
        __props__.__dict__["provinces"] = provinces
        __props__.__dict__["require_cn"] = require_cn
        __props__.__dict__["serial_number_source"] = serial_number_source
        __props__.__dict__["server_flag"] = server_flag
        __props__.__dict__["signature_bits"] = signature_bits
        __props__.__dict__["street_addresses"] = street_addresses
        __props__.__dict__["ttl"] = ttl
        __props__.__dict__["use_csr_common_name"] = use_csr_common_name
        __props__.__dict__["use_csr_sans"] = use_csr_sans
        __props__.__dict__["use_pss"] = use_pss
        return SecretBackendRole(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowAnyName")
    def allow_any_name(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag to allow any name
        """
        return pulumi.get(self, "allow_any_name")

    @_builtins.property
    @pulumi.getter(name="allowBareDomains")
    def allow_bare_domains(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag to allow certificates matching the actual domain
        """
        return pulumi.get(self, "allow_bare_domains")

    @_builtins.property
    @pulumi.getter(name="allowGlobDomains")
    def allow_glob_domains(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag to allow names containing glob patterns.
        """
        return pulumi.get(self, "allow_glob_domains")

    @_builtins.property
    @pulumi.getter(name="allowIpSans")
    def allow_ip_sans(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag to allow IP SANs
        """
        return pulumi.get(self, "allow_ip_sans")

    @_builtins.property
    @pulumi.getter(name="allowLocalhost")
    def allow_localhost(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag to allow certificates for localhost
        """
        return pulumi.get(self, "allow_localhost")

    @_builtins.property
    @pulumi.getter(name="allowSubdomains")
    def allow_subdomains(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag to allow certificates matching subdomains
        """
        return pulumi.get(self, "allow_subdomains")

    @_builtins.property
    @pulumi.getter(name="allowWildcardCertificates")
    def allow_wildcard_certificates(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag to allow wildcard certificates.
        """
        return pulumi.get(self, "allow_wildcard_certificates")

    @_builtins.property
    @pulumi.getter(name="allowedDomains")
    def allowed_domains(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of allowed domains for certificates
        """
        return pulumi.get(self, "allowed_domains")

    @_builtins.property
    @pulumi.getter(name="allowedDomainsTemplate")
    def allowed_domains_template(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag, if set, `allowed_domains` can be specified using identity template expressions such as `{{identity.entity.aliases.<mount accessor>.name}}`.
        """
        return pulumi.get(self, "allowed_domains_template")

    @_builtins.property
    @pulumi.getter(name="allowedOtherSans")
    def allowed_other_sans(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Defines allowed custom SANs
        """
        return pulumi.get(self, "allowed_other_sans")

    @_builtins.property
    @pulumi.getter(name="allowedSerialNumbers")
    def allowed_serial_numbers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        An array of allowed serial numbers to put in Subject
        """
        return pulumi.get(self, "allowed_serial_numbers")

    @_builtins.property
    @pulumi.getter(name="allowedUriSans")
    def allowed_uri_sans(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Defines allowed URI SANs
        """
        return pulumi.get(self, "allowed_uri_sans")

    @_builtins.property
    @pulumi.getter(name="allowedUriSansTemplate")
    def allowed_uri_sans_template(self) -> pulumi.Output[_builtins.bool]:
        """
        Flag, if set, `allowed_uri_sans` can be specified using identity template expressions such as `{{identity.entity.aliases.<mount accessor>.name}}`.
        """
        return pulumi.get(self, "allowed_uri_sans_template")

    @_builtins.property
    @pulumi.getter(name="allowedUserIds")
    def allowed_user_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Defines allowed User IDs
        """
        return pulumi.get(self, "allowed_user_ids")

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[_builtins.str]:
        """
        The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="basicConstraintsValidForNonCa")
    def basic_constraints_valid_for_non_ca(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag to mark basic constraints valid when issuing non-CA certificates
        """
        return pulumi.get(self, "basic_constraints_valid_for_non_ca")

    @_builtins.property
    @pulumi.getter(name="clientFlag")
    def client_flag(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag to specify certificates for client use
        """
        return pulumi.get(self, "client_flag")

    @_builtins.property
    @pulumi.getter(name="cnValidations")
    def cn_validations(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Validations to run on the Common Name field of the certificate, choices: `email`, `hostname`, `disabled`
        """
        return pulumi.get(self, "cn_validations")

    @_builtins.property
    @pulumi.getter(name="codeSigningFlag")
    def code_signing_flag(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag to specify certificates for code signing use
        """
        return pulumi.get(self, "code_signing_flag")

    @_builtins.property
    @pulumi.getter
    def countries(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The country of generated certificates
        """
        return pulumi.get(self, "countries")

    @_builtins.property
    @pulumi.getter(name="emailProtectionFlag")
    def email_protection_flag(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag to specify certificates for email protection use
        """
        return pulumi.get(self, "email_protection_flag")

    @_builtins.property
    @pulumi.getter(name="enforceHostnames")
    def enforce_hostnames(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag to allow only valid host names
        """
        return pulumi.get(self, "enforce_hostnames")

    @_builtins.property
    @pulumi.getter(name="extKeyUsageOids")
    def ext_key_usage_oids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specify the allowed extended key usage OIDs constraint on issued certificates
        """
        return pulumi.get(self, "ext_key_usage_oids")

    @_builtins.property
    @pulumi.getter(name="extKeyUsages")
    def ext_key_usages(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specify the allowed extended key usage constraint on issued certificates
        """
        return pulumi.get(self, "ext_key_usages")

    @_builtins.property
    @pulumi.getter(name="generateLease")
    def generate_lease(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag to generate leases with certificates
        """
        return pulumi.get(self, "generate_lease")

    @_builtins.property
    @pulumi.getter(name="issuerRef")
    def issuer_ref(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the default issuer of this request. May
        be the value `default`, a name, or an issuer ID. Use ACLs to prevent access to
        the `/pki/issuer/:issuer_ref/{issue,sign}/:name` paths to prevent users
        overriding the role's `issuer_ref` value.
        """
        return pulumi.get(self, "issuer_ref")

    @_builtins.property
    @pulumi.getter(name="keyBits")
    def key_bits(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of bits of generated keys
        """
        return pulumi.get(self, "key_bits")

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The generated key type, choices: `rsa`, `ec`, `ed25519`, `any`
        Defaults to `rsa`
        """
        return pulumi.get(self, "key_type")

    @_builtins.property
    @pulumi.getter(name="keyUsages")
    def key_usages(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specify the allowed key usage constraint on issued
        certificates. Defaults to `["DigitalSignature", "KeyAgreement", "KeyEncipherment"])`.
        To specify no default key usage constraints, set this to an empty list `[]`.
        """
        return pulumi.get(self, "key_usages")

    @_builtins.property
    @pulumi.getter
    def localities(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The locality of generated certificates
        """
        return pulumi.get(self, "localities")

    @_builtins.property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> pulumi.Output[_builtins.str]:
        """
        The maximum lease TTL, in seconds, for the role.
        """
        return pulumi.get(self, "max_ttl")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name to identify this role within the backend. Must be unique within the backend.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="noStore")
    def no_store(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag to not store certificates in the storage backend
        """
        return pulumi.get(self, "no_store")

    @_builtins.property
    @pulumi.getter(name="noStoreMetadata")
    def no_store_metadata(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Allows metadata to be stored keyed on the certificate's serial number. The field is independent of no_store, allowing metadata storage regardless of whether certificates are stored. If true, metadata is not stored and an error is returned if the metadata field is specified on issuance APIs
        """
        return pulumi.get(self, "no_store_metadata")

    @_builtins.property
    @pulumi.getter(name="notAfter")
    def not_after(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Set the Not After field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ. Supports the Y10K end date for IEEE 802.1AR-2018 standard devices, 9999-12-31T23:59:59Z.
        """
        return pulumi.get(self, "not_after")

    @_builtins.property
    @pulumi.getter(name="notBeforeDuration")
    def not_before_duration(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the duration by which to backdate the NotBefore property.
        """
        return pulumi.get(self, "not_before_duration")

    @_builtins.property
    @pulumi.getter(name="organizationUnit")
    def organization_unit(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The organization unit of generated certificates
        """
        return pulumi.get(self, "organization_unit")

    @_builtins.property
    @pulumi.getter
    def organizations(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The organization of generated certificates
        """
        return pulumi.get(self, "organizations")

    @_builtins.property
    @pulumi.getter(name="policyIdentifier")
    def policy_identifier(self) -> pulumi.Output[Optional[Sequence['outputs.SecretBackendRolePolicyIdentifier']]]:
        """
        (Vault 1.11+ only) A block for specifying policy identifers. The `policy_identifier` block can be repeated, and supports the following arguments:
        """
        return pulumi.get(self, "policy_identifier")

    @_builtins.property
    @pulumi.getter(name="policyIdentifiers")
    def policy_identifiers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specify the list of allowed policies OIDs. Use with Vault 1.10 or before. For Vault 1.11+, use `policy_identifier` blocks instead
        """
        return pulumi.get(self, "policy_identifiers")

    @_builtins.property
    @pulumi.getter(name="postalCodes")
    def postal_codes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The postal code of generated certificates
        """
        return pulumi.get(self, "postal_codes")

    @_builtins.property
    @pulumi.getter
    def provinces(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The province of generated certificates
        """
        return pulumi.get(self, "provinces")

    @_builtins.property
    @pulumi.getter(name="requireCn")
    def require_cn(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag to force CN usage
        """
        return pulumi.get(self, "require_cn")

    @_builtins.property
    @pulumi.getter(name="serialNumberSource")
    def serial_number_source(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the source of the subject serial number. Valid values are json-csr (default) or json. When set to json-csr, the subject serial number is taken from the serial_number parameter and falls back to the serial number in the CSR. When set to json, the subject serial number is taken from the serial_number parameter but will ignore any value in the CSR. For backwards compatibility an empty value for this field will default to the json-csr behavior.

        Example usage:
        """
        return pulumi.get(self, "serial_number_source")

    @_builtins.property
    @pulumi.getter(name="serverFlag")
    def server_flag(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag to specify certificates for server use
        """
        return pulumi.get(self, "server_flag")

    @_builtins.property
    @pulumi.getter(name="signatureBits")
    def signature_bits(self) -> pulumi.Output[_builtins.int]:
        """
        The number of bits to use in the signature algorithm
        """
        return pulumi.get(self, "signature_bits")

    @_builtins.property
    @pulumi.getter(name="streetAddresses")
    def street_addresses(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The street address of generated certificates
        """
        return pulumi.get(self, "street_addresses")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[_builtins.str]:
        """
        The TTL, in seconds, for any certificate issued against this role.
        """
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter(name="useCsrCommonName")
    def use_csr_common_name(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag to use the CN in the CSR
        """
        return pulumi.get(self, "use_csr_common_name")

    @_builtins.property
    @pulumi.getter(name="useCsrSans")
    def use_csr_sans(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag to use the SANs in the CSR
        """
        return pulumi.get(self, "use_csr_sans")

    @_builtins.property
    @pulumi.getter(name="usePss")
    def use_pss(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether or not to use PSS signatures over PKCS#1v1.5 signatures when a RSA-type issuer is used. Ignored for ECDSA/Ed25519 issuers.
        """
        return pulumi.get(self, "use_pss")

