# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SecretBackendSignArgs', 'SecretBackendSign']

@pulumi.input_type
class SecretBackendSignArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[_builtins.str],
                 common_name: pulumi.Input[_builtins.str],
                 csr: pulumi.Input[_builtins.str],
                 alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 cert_metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_cn_from_sans: Optional[pulumi.Input[_builtins.bool]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 issuer_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 min_seconds_remaining: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 not_after: Optional[pulumi.Input[_builtins.str]] = None,
                 other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a SecretBackendSign resource.
        :param pulumi.Input[_builtins.str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[_builtins.str] common_name: CN of certificate to create
        :param pulumi.Input[_builtins.str] csr: The CSR
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alt_names: List of alternative names
        :param pulumi.Input[_builtins.bool] auto_renew: If set to `true`, certs will be renewed if the expiration is within `min_seconds_remaining`. Default `false`
        :param pulumi.Input[_builtins.str] cert_metadata: A base 64 encoded value or an empty string to associate with the certificate's serial number. The role's no_store_metadata must be set to false, otherwise an error is returned when specified.
        :param pulumi.Input[_builtins.bool] exclude_cn_from_sans: Flag to exclude CN from SANs
        :param pulumi.Input[_builtins.str] format: The format of data
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_sans: List of alternative IPs
        :param pulumi.Input[_builtins.str] issuer_ref: Specifies the default issuer of this request. Can
               be the value `default`, a name, or an issuer ID. Use ACLs to prevent access to
               the `/pki/issuer/:issuer_ref/{issue,sign}/:name` paths to prevent users
               overriding the role's `issuer_ref` value.
        :param pulumi.Input[_builtins.int] min_seconds_remaining: Generate a new certificate when the expiration is within this number of seconds, default is 604800 (7 days)
        :param pulumi.Input[_builtins.str] name: Name of the role to create the certificate against
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] not_after: Set the Not After field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ. Supports the Y10K end date for IEEE 802.1AR-2018 standard devices, 9999-12-31T23:59:59Z.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] other_sans: List of other SANs
        :param pulumi.Input[_builtins.str] ttl: Time to live
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] uri_sans: List of alternative URIs
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "csr", csr)
        if alt_names is not None:
            pulumi.set(__self__, "alt_names", alt_names)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if cert_metadata is not None:
            pulumi.set(__self__, "cert_metadata", cert_metadata)
        if exclude_cn_from_sans is not None:
            pulumi.set(__self__, "exclude_cn_from_sans", exclude_cn_from_sans)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if ip_sans is not None:
            pulumi.set(__self__, "ip_sans", ip_sans)
        if issuer_ref is not None:
            pulumi.set(__self__, "issuer_ref", issuer_ref)
        if min_seconds_remaining is not None:
            pulumi.set(__self__, "min_seconds_remaining", min_seconds_remaining)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if not_after is not None:
            pulumi.set(__self__, "not_after", not_after)
        if other_sans is not None:
            pulumi.set(__self__, "other_sans", other_sans)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if uri_sans is not None:
            pulumi.set(__self__, "uri_sans", uri_sans)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Input[_builtins.str]:
        """
        The PKI secret backend the resource belongs to.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Input[_builtins.str]:
        """
        CN of certificate to create
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "common_name", value)

    @_builtins.property
    @pulumi.getter
    def csr(self) -> pulumi.Input[_builtins.str]:
        """
        The CSR
        """
        return pulumi.get(self, "csr")

    @csr.setter
    def csr(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "csr", value)

    @_builtins.property
    @pulumi.getter(name="altNames")
    def alt_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of alternative names
        """
        return pulumi.get(self, "alt_names")

    @alt_names.setter
    def alt_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "alt_names", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, certs will be renewed if the expiration is within `min_seconds_remaining`. Default `false`
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="certMetadata")
    def cert_metadata(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A base 64 encoded value or an empty string to associate with the certificate's serial number. The role's no_store_metadata must be set to false, otherwise an error is returned when specified.
        """
        return pulumi.get(self, "cert_metadata")

    @cert_metadata.setter
    def cert_metadata(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert_metadata", value)

    @_builtins.property
    @pulumi.getter(name="excludeCnFromSans")
    def exclude_cn_from_sans(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to exclude CN from SANs
        """
        return pulumi.get(self, "exclude_cn_from_sans")

    @exclude_cn_from_sans.setter
    def exclude_cn_from_sans(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "exclude_cn_from_sans", value)

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The format of data
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "format", value)

    @_builtins.property
    @pulumi.getter(name="ipSans")
    def ip_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of alternative IPs
        """
        return pulumi.get(self, "ip_sans")

    @ip_sans.setter
    def ip_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_sans", value)

    @_builtins.property
    @pulumi.getter(name="issuerRef")
    def issuer_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the default issuer of this request. Can
        be the value `default`, a name, or an issuer ID. Use ACLs to prevent access to
        the `/pki/issuer/:issuer_ref/{issue,sign}/:name` paths to prevent users
        overriding the role's `issuer_ref` value.
        """
        return pulumi.get(self, "issuer_ref")

    @issuer_ref.setter
    def issuer_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer_ref", value)

    @_builtins.property
    @pulumi.getter(name="minSecondsRemaining")
    def min_seconds_remaining(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Generate a new certificate when the expiration is within this number of seconds, default is 604800 (7 days)
        """
        return pulumi.get(self, "min_seconds_remaining")

    @min_seconds_remaining.setter
    def min_seconds_remaining(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_seconds_remaining", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the role to create the certificate against
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="notAfter")
    def not_after(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the Not After field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ. Supports the Y10K end date for IEEE 802.1AR-2018 standard devices, 9999-12-31T23:59:59Z.
        """
        return pulumi.get(self, "not_after")

    @not_after.setter
    def not_after(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "not_after", value)

    @_builtins.property
    @pulumi.getter(name="otherSans")
    def other_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of other SANs
        """
        return pulumi.get(self, "other_sans")

    @other_sans.setter
    def other_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "other_sans", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time to live
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter(name="uriSans")
    def uri_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of alternative URIs
        """
        return pulumi.get(self, "uri_sans")

    @uri_sans.setter
    def uri_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "uri_sans", value)


@pulumi.input_type
class _SecretBackendSignState:
    def __init__(__self__, *,
                 alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 ca_chains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cert_metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 common_name: Optional[pulumi.Input[_builtins.str]] = None,
                 csr: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_cn_from_sans: Optional[pulumi.Input[_builtins.bool]] = None,
                 expiration: Optional[pulumi.Input[_builtins.int]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 issuer_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 issuing_ca: Optional[pulumi.Input[_builtins.str]] = None,
                 min_seconds_remaining: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 not_after: Optional[pulumi.Input[_builtins.str]] = None,
                 other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 renew_pending: Optional[pulumi.Input[_builtins.bool]] = None,
                 serial_number: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering SecretBackendSign resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alt_names: List of alternative names
        :param pulumi.Input[_builtins.bool] auto_renew: If set to `true`, certs will be renewed if the expiration is within `min_seconds_remaining`. Default `false`
        :param pulumi.Input[_builtins.str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ca_chains: The CA chain
        :param pulumi.Input[_builtins.str] cert_metadata: A base 64 encoded value or an empty string to associate with the certificate's serial number. The role's no_store_metadata must be set to false, otherwise an error is returned when specified.
        :param pulumi.Input[_builtins.str] certificate: The certificate
        :param pulumi.Input[_builtins.str] common_name: CN of certificate to create
        :param pulumi.Input[_builtins.str] csr: The CSR
        :param pulumi.Input[_builtins.bool] exclude_cn_from_sans: Flag to exclude CN from SANs
        :param pulumi.Input[_builtins.int] expiration: The expiration date of the certificate in unix epoch format
        :param pulumi.Input[_builtins.str] format: The format of data
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_sans: List of alternative IPs
        :param pulumi.Input[_builtins.str] issuer_ref: Specifies the default issuer of this request. Can
               be the value `default`, a name, or an issuer ID. Use ACLs to prevent access to
               the `/pki/issuer/:issuer_ref/{issue,sign}/:name` paths to prevent users
               overriding the role's `issuer_ref` value.
        :param pulumi.Input[_builtins.str] issuing_ca: The issuing CA
        :param pulumi.Input[_builtins.int] min_seconds_remaining: Generate a new certificate when the expiration is within this number of seconds, default is 604800 (7 days)
        :param pulumi.Input[_builtins.str] name: Name of the role to create the certificate against
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] not_after: Set the Not After field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ. Supports the Y10K end date for IEEE 802.1AR-2018 standard devices, 9999-12-31T23:59:59Z.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] other_sans: List of other SANs
        :param pulumi.Input[_builtins.bool] renew_pending: `true` if the current time (during refresh) is after the start of the early renewal window declared by `min_seconds_remaining`, and `false` otherwise; if `auto_renew` is set to `true` then the provider will plan to replace the certificate once renewal is pending.
        :param pulumi.Input[_builtins.str] serial_number: The certificate's serial number, hex formatted.
        :param pulumi.Input[_builtins.str] ttl: Time to live
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] uri_sans: List of alternative URIs
        """
        if alt_names is not None:
            pulumi.set(__self__, "alt_names", alt_names)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if ca_chains is not None:
            pulumi.set(__self__, "ca_chains", ca_chains)
        if cert_metadata is not None:
            pulumi.set(__self__, "cert_metadata", cert_metadata)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if csr is not None:
            pulumi.set(__self__, "csr", csr)
        if exclude_cn_from_sans is not None:
            pulumi.set(__self__, "exclude_cn_from_sans", exclude_cn_from_sans)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if ip_sans is not None:
            pulumi.set(__self__, "ip_sans", ip_sans)
        if issuer_ref is not None:
            pulumi.set(__self__, "issuer_ref", issuer_ref)
        if issuing_ca is not None:
            pulumi.set(__self__, "issuing_ca", issuing_ca)
        if min_seconds_remaining is not None:
            pulumi.set(__self__, "min_seconds_remaining", min_seconds_remaining)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if not_after is not None:
            pulumi.set(__self__, "not_after", not_after)
        if other_sans is not None:
            pulumi.set(__self__, "other_sans", other_sans)
        if renew_pending is not None:
            pulumi.set(__self__, "renew_pending", renew_pending)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if uri_sans is not None:
            pulumi.set(__self__, "uri_sans", uri_sans)

    @_builtins.property
    @pulumi.getter(name="altNames")
    def alt_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of alternative names
        """
        return pulumi.get(self, "alt_names")

    @alt_names.setter
    def alt_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "alt_names", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, certs will be renewed if the expiration is within `min_seconds_remaining`. Default `false`
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The PKI secret backend the resource belongs to.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="caChains")
    def ca_chains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The CA chain
        """
        return pulumi.get(self, "ca_chains")

    @ca_chains.setter
    def ca_chains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ca_chains", value)

    @_builtins.property
    @pulumi.getter(name="certMetadata")
    def cert_metadata(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A base 64 encoded value or an empty string to associate with the certificate's serial number. The role's no_store_metadata must be set to false, otherwise an error is returned when specified.
        """
        return pulumi.get(self, "cert_metadata")

    @cert_metadata.setter
    def cert_metadata(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert_metadata", value)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CN of certificate to create
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "common_name", value)

    @_builtins.property
    @pulumi.getter
    def csr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CSR
        """
        return pulumi.get(self, "csr")

    @csr.setter
    def csr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "csr", value)

    @_builtins.property
    @pulumi.getter(name="excludeCnFromSans")
    def exclude_cn_from_sans(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to exclude CN from SANs
        """
        return pulumi.get(self, "exclude_cn_from_sans")

    @exclude_cn_from_sans.setter
    def exclude_cn_from_sans(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "exclude_cn_from_sans", value)

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The expiration date of the certificate in unix epoch format
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expiration", value)

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The format of data
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "format", value)

    @_builtins.property
    @pulumi.getter(name="ipSans")
    def ip_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of alternative IPs
        """
        return pulumi.get(self, "ip_sans")

    @ip_sans.setter
    def ip_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_sans", value)

    @_builtins.property
    @pulumi.getter(name="issuerRef")
    def issuer_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the default issuer of this request. Can
        be the value `default`, a name, or an issuer ID. Use ACLs to prevent access to
        the `/pki/issuer/:issuer_ref/{issue,sign}/:name` paths to prevent users
        overriding the role's `issuer_ref` value.
        """
        return pulumi.get(self, "issuer_ref")

    @issuer_ref.setter
    def issuer_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer_ref", value)

    @_builtins.property
    @pulumi.getter(name="issuingCa")
    def issuing_ca(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The issuing CA
        """
        return pulumi.get(self, "issuing_ca")

    @issuing_ca.setter
    def issuing_ca(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuing_ca", value)

    @_builtins.property
    @pulumi.getter(name="minSecondsRemaining")
    def min_seconds_remaining(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Generate a new certificate when the expiration is within this number of seconds, default is 604800 (7 days)
        """
        return pulumi.get(self, "min_seconds_remaining")

    @min_seconds_remaining.setter
    def min_seconds_remaining(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_seconds_remaining", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the role to create the certificate against
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="notAfter")
    def not_after(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the Not After field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ. Supports the Y10K end date for IEEE 802.1AR-2018 standard devices, 9999-12-31T23:59:59Z.
        """
        return pulumi.get(self, "not_after")

    @not_after.setter
    def not_after(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "not_after", value)

    @_builtins.property
    @pulumi.getter(name="otherSans")
    def other_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of other SANs
        """
        return pulumi.get(self, "other_sans")

    @other_sans.setter
    def other_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "other_sans", value)

    @_builtins.property
    @pulumi.getter(name="renewPending")
    def renew_pending(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        `true` if the current time (during refresh) is after the start of the early renewal window declared by `min_seconds_remaining`, and `false` otherwise; if `auto_renew` is set to `true` then the provider will plan to replace the certificate once renewal is pending.
        """
        return pulumi.get(self, "renew_pending")

    @renew_pending.setter
    def renew_pending(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "renew_pending", value)

    @_builtins.property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate's serial number, hex formatted.
        """
        return pulumi.get(self, "serial_number")

    @serial_number.setter
    def serial_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "serial_number", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time to live
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter(name="uriSans")
    def uri_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of alternative URIs
        """
        return pulumi.get(self, "uri_sans")

    @uri_sans.setter
    def uri_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "uri_sans", value)


@pulumi.type_token("vault:pkiSecret/secretBackendSign:SecretBackendSign")
class SecretBackendSign(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 common_name: Optional[pulumi.Input[_builtins.str]] = None,
                 csr: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_cn_from_sans: Optional[pulumi.Input[_builtins.bool]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 issuer_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 min_seconds_remaining: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 not_after: Optional[pulumi.Input[_builtins.str]] = None,
                 other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        test = vault.pkisecret.SecretBackendSign("test",
            backend=pki["path"],
            name=admin["name"],
            csr=\"\"\"-----BEGIN CERTIFICATE REQUEST-----
        MIIEqDCCApACAQAwYzELMAkGA1UEBhMCQVUxEzARBgNVBAgMClNvbWUtU3RhdGUx
        ITAfBgNVBAoMGEludGVybmV0IFdpZGdpdHMgUHR5IEx0ZDEcMBoGA1UEAwwTY2Vy
        dC50ZXN0Lm15LmRvbWFpbjCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIB
        AJupYCQ8UVCWII1Zof1c6YcSSaM9hEaDU78cfKP5RoSeH10BvrWRfT+mzCONVpNP
        CW9Iabtvk6hm0ot6ilnndEyVJbc0g7hdDLBX5BM25D+DGZGJRKUz1V+uBrWmXtIt
        Vonj7JTDTe7ViH0GDsB7CvqXFGXO2a2cDYBchLkL6vQiFPshxvUsLtwxuy/qdYgy
        X6ya+AUoZcoQGy1XxNjfH6cPtWSWQGEp1oPR6vL9hU3laTZb3C+VV4jZem+he8/0
        V+qV6fLG92WTXm2hmf8nrtUqqJ+C7mW/RJod+TviviBadIX0OHXW7k5HVsZood01
        te8vMRUNJNiZfa9EMIK5oncbQn0LcM3Wo9VrjpL7jREb/4HCS2gswYGv7hzk9cCS
        kVY4rDucchKbApuI3kfzmO7GFOF5eiSkYZpY/czNn7VVM3WCu6dpOX4+3rhgrZQw
        kY14L930DaLVRUgve/zKVP2D2GHdEOs+MbV7s96UgigT9pXly/yHPj+1sSYqmnaD
        5b7jSeJusmzO/nrwXVGLsnezR87VzHl9Ux9g5s6zh+R+PrZuVxYsLvoUpaasH47O
        gIcBzSb/6pSGZKAUizmYsHsR1k88dAvsQ+FsUDaNokdi9VndEB4QPmiFmjyLV+0I
        1TFoXop4sW11NPz1YCq+IxnYrEaIN3PyhY0GvBJDFY1/AgMBAAGgADANBgkqhkiG
        9w0BAQsFAAOCAgEActuqnqS8Y9UF7e08w7tR3FPzGecWreuvxILrlFEZJxiLPFqL
        It7uJvtypCVQvz6UQzKdBYO7tMpRaWViB8DrWzXNZjLMrg+QHcpveg8C0Ett4scG
        fnvLk6fTDFYrnGvwHTqiHos5i0y3bFLyS1BGwSpdLAykGtvC+VM8mRyw/Y7CPcKN
        77kebY/9xduW1g2uxWLr0x90RuQDv9psPojT+59tRLGSp5Kt0IeD3QtnAZEFE4aN
        vt+Pd69eg3BgZ8ZeDgoqAw3yppvOkpAFiE5pw2qPZaM4SRphl4d2Lek2zNIMyZqv
        do5zh356HOgXtDaSg0POnRGrN/Ua+LMCRTg6GEPUnx9uQb/zt8Zu0hIexDGyykp1
        OGqtWlv/Nc8UYuS38v0BeB6bMPeoqQUjkqs8nHlAEFn0KlgYdtDC+7SdQx6wS4te
        dBKRNDfC4lS3jYJgs55jHqonZgkpSi3bamlxpfpW0ukGBcmq91wRe4bOw/4uD/vf
        UwqMWOdCYcU3mdYNjTWy22ORW3SGFQxMBwpUEURCSoeqWr6aJeQ7KAYkx1PrB5T8
        OTEc13lWf+B0PU9UJuGTsmpIuImPDVd0EVDayr3mT5dDbqTVDbe8ppf2IswABmf0
        o3DybUeUmknYjl109rdSf+76nuREICHatxXgN3xCMFuBaN4WLO+ksd6Y1Ys=
        -----END CERTIFICATE REQUEST-----
        \"\"\",
            common_name="test.my.domain",
            opts = pulumi.ResourceOptions(depends_on=[admin]))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alt_names: List of alternative names
        :param pulumi.Input[_builtins.bool] auto_renew: If set to `true`, certs will be renewed if the expiration is within `min_seconds_remaining`. Default `false`
        :param pulumi.Input[_builtins.str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[_builtins.str] cert_metadata: A base 64 encoded value or an empty string to associate with the certificate's serial number. The role's no_store_metadata must be set to false, otherwise an error is returned when specified.
        :param pulumi.Input[_builtins.str] common_name: CN of certificate to create
        :param pulumi.Input[_builtins.str] csr: The CSR
        :param pulumi.Input[_builtins.bool] exclude_cn_from_sans: Flag to exclude CN from SANs
        :param pulumi.Input[_builtins.str] format: The format of data
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_sans: List of alternative IPs
        :param pulumi.Input[_builtins.str] issuer_ref: Specifies the default issuer of this request. Can
               be the value `default`, a name, or an issuer ID. Use ACLs to prevent access to
               the `/pki/issuer/:issuer_ref/{issue,sign}/:name` paths to prevent users
               overriding the role's `issuer_ref` value.
        :param pulumi.Input[_builtins.int] min_seconds_remaining: Generate a new certificate when the expiration is within this number of seconds, default is 604800 (7 days)
        :param pulumi.Input[_builtins.str] name: Name of the role to create the certificate against
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] not_after: Set the Not After field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ. Supports the Y10K end date for IEEE 802.1AR-2018 standard devices, 9999-12-31T23:59:59Z.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] other_sans: List of other SANs
        :param pulumi.Input[_builtins.str] ttl: Time to live
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] uri_sans: List of alternative URIs
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretBackendSignArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        test = vault.pkisecret.SecretBackendSign("test",
            backend=pki["path"],
            name=admin["name"],
            csr=\"\"\"-----BEGIN CERTIFICATE REQUEST-----
        MIIEqDCCApACAQAwYzELMAkGA1UEBhMCQVUxEzARBgNVBAgMClNvbWUtU3RhdGUx
        ITAfBgNVBAoMGEludGVybmV0IFdpZGdpdHMgUHR5IEx0ZDEcMBoGA1UEAwwTY2Vy
        dC50ZXN0Lm15LmRvbWFpbjCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIB
        AJupYCQ8UVCWII1Zof1c6YcSSaM9hEaDU78cfKP5RoSeH10BvrWRfT+mzCONVpNP
        CW9Iabtvk6hm0ot6ilnndEyVJbc0g7hdDLBX5BM25D+DGZGJRKUz1V+uBrWmXtIt
        Vonj7JTDTe7ViH0GDsB7CvqXFGXO2a2cDYBchLkL6vQiFPshxvUsLtwxuy/qdYgy
        X6ya+AUoZcoQGy1XxNjfH6cPtWSWQGEp1oPR6vL9hU3laTZb3C+VV4jZem+he8/0
        V+qV6fLG92WTXm2hmf8nrtUqqJ+C7mW/RJod+TviviBadIX0OHXW7k5HVsZood01
        te8vMRUNJNiZfa9EMIK5oncbQn0LcM3Wo9VrjpL7jREb/4HCS2gswYGv7hzk9cCS
        kVY4rDucchKbApuI3kfzmO7GFOF5eiSkYZpY/czNn7VVM3WCu6dpOX4+3rhgrZQw
        kY14L930DaLVRUgve/zKVP2D2GHdEOs+MbV7s96UgigT9pXly/yHPj+1sSYqmnaD
        5b7jSeJusmzO/nrwXVGLsnezR87VzHl9Ux9g5s6zh+R+PrZuVxYsLvoUpaasH47O
        gIcBzSb/6pSGZKAUizmYsHsR1k88dAvsQ+FsUDaNokdi9VndEB4QPmiFmjyLV+0I
        1TFoXop4sW11NPz1YCq+IxnYrEaIN3PyhY0GvBJDFY1/AgMBAAGgADANBgkqhkiG
        9w0BAQsFAAOCAgEActuqnqS8Y9UF7e08w7tR3FPzGecWreuvxILrlFEZJxiLPFqL
        It7uJvtypCVQvz6UQzKdBYO7tMpRaWViB8DrWzXNZjLMrg+QHcpveg8C0Ett4scG
        fnvLk6fTDFYrnGvwHTqiHos5i0y3bFLyS1BGwSpdLAykGtvC+VM8mRyw/Y7CPcKN
        77kebY/9xduW1g2uxWLr0x90RuQDv9psPojT+59tRLGSp5Kt0IeD3QtnAZEFE4aN
        vt+Pd69eg3BgZ8ZeDgoqAw3yppvOkpAFiE5pw2qPZaM4SRphl4d2Lek2zNIMyZqv
        do5zh356HOgXtDaSg0POnRGrN/Ua+LMCRTg6GEPUnx9uQb/zt8Zu0hIexDGyykp1
        OGqtWlv/Nc8UYuS38v0BeB6bMPeoqQUjkqs8nHlAEFn0KlgYdtDC+7SdQx6wS4te
        dBKRNDfC4lS3jYJgs55jHqonZgkpSi3bamlxpfpW0ukGBcmq91wRe4bOw/4uD/vf
        UwqMWOdCYcU3mdYNjTWy22ORW3SGFQxMBwpUEURCSoeqWr6aJeQ7KAYkx1PrB5T8
        OTEc13lWf+B0PU9UJuGTsmpIuImPDVd0EVDayr3mT5dDbqTVDbe8ppf2IswABmf0
        o3DybUeUmknYjl109rdSf+76nuREICHatxXgN3xCMFuBaN4WLO+ksd6Y1Ys=
        -----END CERTIFICATE REQUEST-----
        \"\"\",
            common_name="test.my.domain",
            opts = pulumi.ResourceOptions(depends_on=[admin]))
        ```

        :param str resource_name: The name of the resource.
        :param SecretBackendSignArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendSignArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 common_name: Optional[pulumi.Input[_builtins.str]] = None,
                 csr: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_cn_from_sans: Optional[pulumi.Input[_builtins.bool]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 issuer_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 min_seconds_remaining: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 not_after: Optional[pulumi.Input[_builtins.str]] = None,
                 other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretBackendSignArgs.__new__(SecretBackendSignArgs)

            __props__.__dict__["alt_names"] = alt_names
            __props__.__dict__["auto_renew"] = auto_renew
            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            __props__.__dict__["cert_metadata"] = cert_metadata
            if common_name is None and not opts.urn:
                raise TypeError("Missing required property 'common_name'")
            __props__.__dict__["common_name"] = common_name
            if csr is None and not opts.urn:
                raise TypeError("Missing required property 'csr'")
            __props__.__dict__["csr"] = csr
            __props__.__dict__["exclude_cn_from_sans"] = exclude_cn_from_sans
            __props__.__dict__["format"] = format
            __props__.__dict__["ip_sans"] = ip_sans
            __props__.__dict__["issuer_ref"] = issuer_ref
            __props__.__dict__["min_seconds_remaining"] = min_seconds_remaining
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["not_after"] = not_after
            __props__.__dict__["other_sans"] = other_sans
            __props__.__dict__["ttl"] = ttl
            __props__.__dict__["uri_sans"] = uri_sans
            __props__.__dict__["ca_chains"] = None
            __props__.__dict__["certificate"] = None
            __props__.__dict__["expiration"] = None
            __props__.__dict__["issuing_ca"] = None
            __props__.__dict__["renew_pending"] = None
            __props__.__dict__["serial_number"] = None
        super(SecretBackendSign, __self__).__init__(
            'vault:pkiSecret/secretBackendSign:SecretBackendSign',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            ca_chains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            cert_metadata: Optional[pulumi.Input[_builtins.str]] = None,
            certificate: Optional[pulumi.Input[_builtins.str]] = None,
            common_name: Optional[pulumi.Input[_builtins.str]] = None,
            csr: Optional[pulumi.Input[_builtins.str]] = None,
            exclude_cn_from_sans: Optional[pulumi.Input[_builtins.bool]] = None,
            expiration: Optional[pulumi.Input[_builtins.int]] = None,
            format: Optional[pulumi.Input[_builtins.str]] = None,
            ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            issuer_ref: Optional[pulumi.Input[_builtins.str]] = None,
            issuing_ca: Optional[pulumi.Input[_builtins.str]] = None,
            min_seconds_remaining: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            not_after: Optional[pulumi.Input[_builtins.str]] = None,
            other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            renew_pending: Optional[pulumi.Input[_builtins.bool]] = None,
            serial_number: Optional[pulumi.Input[_builtins.str]] = None,
            ttl: Optional[pulumi.Input[_builtins.str]] = None,
            uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'SecretBackendSign':
        """
        Get an existing SecretBackendSign resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alt_names: List of alternative names
        :param pulumi.Input[_builtins.bool] auto_renew: If set to `true`, certs will be renewed if the expiration is within `min_seconds_remaining`. Default `false`
        :param pulumi.Input[_builtins.str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ca_chains: The CA chain
        :param pulumi.Input[_builtins.str] cert_metadata: A base 64 encoded value or an empty string to associate with the certificate's serial number. The role's no_store_metadata must be set to false, otherwise an error is returned when specified.
        :param pulumi.Input[_builtins.str] certificate: The certificate
        :param pulumi.Input[_builtins.str] common_name: CN of certificate to create
        :param pulumi.Input[_builtins.str] csr: The CSR
        :param pulumi.Input[_builtins.bool] exclude_cn_from_sans: Flag to exclude CN from SANs
        :param pulumi.Input[_builtins.int] expiration: The expiration date of the certificate in unix epoch format
        :param pulumi.Input[_builtins.str] format: The format of data
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_sans: List of alternative IPs
        :param pulumi.Input[_builtins.str] issuer_ref: Specifies the default issuer of this request. Can
               be the value `default`, a name, or an issuer ID. Use ACLs to prevent access to
               the `/pki/issuer/:issuer_ref/{issue,sign}/:name` paths to prevent users
               overriding the role's `issuer_ref` value.
        :param pulumi.Input[_builtins.str] issuing_ca: The issuing CA
        :param pulumi.Input[_builtins.int] min_seconds_remaining: Generate a new certificate when the expiration is within this number of seconds, default is 604800 (7 days)
        :param pulumi.Input[_builtins.str] name: Name of the role to create the certificate against
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] not_after: Set the Not After field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ. Supports the Y10K end date for IEEE 802.1AR-2018 standard devices, 9999-12-31T23:59:59Z.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] other_sans: List of other SANs
        :param pulumi.Input[_builtins.bool] renew_pending: `true` if the current time (during refresh) is after the start of the early renewal window declared by `min_seconds_remaining`, and `false` otherwise; if `auto_renew` is set to `true` then the provider will plan to replace the certificate once renewal is pending.
        :param pulumi.Input[_builtins.str] serial_number: The certificate's serial number, hex formatted.
        :param pulumi.Input[_builtins.str] ttl: Time to live
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] uri_sans: List of alternative URIs
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretBackendSignState.__new__(_SecretBackendSignState)

        __props__.__dict__["alt_names"] = alt_names
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["backend"] = backend
        __props__.__dict__["ca_chains"] = ca_chains
        __props__.__dict__["cert_metadata"] = cert_metadata
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["common_name"] = common_name
        __props__.__dict__["csr"] = csr
        __props__.__dict__["exclude_cn_from_sans"] = exclude_cn_from_sans
        __props__.__dict__["expiration"] = expiration
        __props__.__dict__["format"] = format
        __props__.__dict__["ip_sans"] = ip_sans
        __props__.__dict__["issuer_ref"] = issuer_ref
        __props__.__dict__["issuing_ca"] = issuing_ca
        __props__.__dict__["min_seconds_remaining"] = min_seconds_remaining
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["not_after"] = not_after
        __props__.__dict__["other_sans"] = other_sans
        __props__.__dict__["renew_pending"] = renew_pending
        __props__.__dict__["serial_number"] = serial_number
        __props__.__dict__["ttl"] = ttl
        __props__.__dict__["uri_sans"] = uri_sans
        return SecretBackendSign(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="altNames")
    def alt_names(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of alternative names
        """
        return pulumi.get(self, "alt_names")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set to `true`, certs will be renewed if the expiration is within `min_seconds_remaining`. Default `false`
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[_builtins.str]:
        """
        The PKI secret backend the resource belongs to.
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="caChains")
    def ca_chains(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The CA chain
        """
        return pulumi.get(self, "ca_chains")

    @_builtins.property
    @pulumi.getter(name="certMetadata")
    def cert_metadata(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A base 64 encoded value or an empty string to associate with the certificate's serial number. The role's no_store_metadata must be set to false, otherwise an error is returned when specified.
        """
        return pulumi.get(self, "cert_metadata")

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[_builtins.str]:
        """
        The certificate
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Output[_builtins.str]:
        """
        CN of certificate to create
        """
        return pulumi.get(self, "common_name")

    @_builtins.property
    @pulumi.getter
    def csr(self) -> pulumi.Output[_builtins.str]:
        """
        The CSR
        """
        return pulumi.get(self, "csr")

    @_builtins.property
    @pulumi.getter(name="excludeCnFromSans")
    def exclude_cn_from_sans(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag to exclude CN from SANs
        """
        return pulumi.get(self, "exclude_cn_from_sans")

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> pulumi.Output[_builtins.int]:
        """
        The expiration date of the certificate in unix epoch format
        """
        return pulumi.get(self, "expiration")

    @_builtins.property
    @pulumi.getter
    def format(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The format of data
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="ipSans")
    def ip_sans(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of alternative IPs
        """
        return pulumi.get(self, "ip_sans")

    @_builtins.property
    @pulumi.getter(name="issuerRef")
    def issuer_ref(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the default issuer of this request. Can
        be the value `default`, a name, or an issuer ID. Use ACLs to prevent access to
        the `/pki/issuer/:issuer_ref/{issue,sign}/:name` paths to prevent users
        overriding the role's `issuer_ref` value.
        """
        return pulumi.get(self, "issuer_ref")

    @_builtins.property
    @pulumi.getter(name="issuingCa")
    def issuing_ca(self) -> pulumi.Output[_builtins.str]:
        """
        The issuing CA
        """
        return pulumi.get(self, "issuing_ca")

    @_builtins.property
    @pulumi.getter(name="minSecondsRemaining")
    def min_seconds_remaining(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Generate a new certificate when the expiration is within this number of seconds, default is 604800 (7 days)
        """
        return pulumi.get(self, "min_seconds_remaining")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the role to create the certificate against
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="notAfter")
    def not_after(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Set the Not After field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ. Supports the Y10K end date for IEEE 802.1AR-2018 standard devices, 9999-12-31T23:59:59Z.
        """
        return pulumi.get(self, "not_after")

    @_builtins.property
    @pulumi.getter(name="otherSans")
    def other_sans(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of other SANs
        """
        return pulumi.get(self, "other_sans")

    @_builtins.property
    @pulumi.getter(name="renewPending")
    def renew_pending(self) -> pulumi.Output[_builtins.bool]:
        """
        `true` if the current time (during refresh) is after the start of the early renewal window declared by `min_seconds_remaining`, and `false` otherwise; if `auto_renew` is set to `true` then the provider will plan to replace the certificate once renewal is pending.
        """
        return pulumi.get(self, "renew_pending")

    @_builtins.property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> pulumi.Output[_builtins.str]:
        """
        The certificate's serial number, hex formatted.
        """
        return pulumi.get(self, "serial_number")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Time to live
        """
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter(name="uriSans")
    def uri_sans(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of alternative URIs
        """
        return pulumi.get(self, "uri_sans")

