# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AuthBackendRoleArgs', 'AuthBackendRole']

@pulumi.input_type
class AuthBackendRoleArgs:
    def __init__(__self__, *,
                 role_name: pulumi.Input[_builtins.str],
                 allowed_entity_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_policies_globs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 disallowed_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 disallowed_policies_globs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 orphan: Optional[pulumi.Input[_builtins.bool]] = None,
                 path_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 renewable: Optional[pulumi.Input[_builtins.bool]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 token_num_uses: Optional[pulumi.Input[_builtins.int]] = None,
                 token_period: Optional[pulumi.Input[_builtins.int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AuthBackendRole resource.
        :param pulumi.Input[_builtins.str] role_name: The name of the role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_entity_aliases: List of allowed entity aliases.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_policies: List of allowed policies for given role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_policies_globs: Set of allowed policies with glob match for given role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] disallowed_policies: List of disallowed policies for given role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] disallowed_policies_globs: Set of disallowed policies with glob match for given role.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.bool] orphan: If true, tokens created against this policy will be orphan tokens.
        :param pulumi.Input[_builtins.str] path_suffix: Tokens created against this role will have the given suffix as part of their path in addition to the role name.
        :param pulumi.Input[_builtins.bool] renewable: Whether to disable the ability of the token to be renewed past its initial TTL.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_bound_cidrs: Specifies the blocks of IP addresses which are allowed to use the generated token
        :param pulumi.Input[_builtins.int] token_explicit_max_ttl: Generated Token's Explicit Maximum TTL in seconds
        :param pulumi.Input[_builtins.int] token_max_ttl: The maximum lifetime of the generated token
        :param pulumi.Input[_builtins.bool] token_no_default_policy: If true, the 'default' policy will not automatically be added to generated tokens
        :param pulumi.Input[_builtins.int] token_num_uses: The maximum number of times a token may be used, a value of zero means unlimited
        :param pulumi.Input[_builtins.int] token_period: Generated Token's Period
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_policies: Generated Token's Policies
        :param pulumi.Input[_builtins.int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[_builtins.str] token_type: The type of token to generate, service or batch
        """
        pulumi.set(__self__, "role_name", role_name)
        if allowed_entity_aliases is not None:
            pulumi.set(__self__, "allowed_entity_aliases", allowed_entity_aliases)
        if allowed_policies is not None:
            pulumi.set(__self__, "allowed_policies", allowed_policies)
        if allowed_policies_globs is not None:
            pulumi.set(__self__, "allowed_policies_globs", allowed_policies_globs)
        if disallowed_policies is not None:
            pulumi.set(__self__, "disallowed_policies", disallowed_policies)
        if disallowed_policies_globs is not None:
            pulumi.set(__self__, "disallowed_policies_globs", disallowed_policies_globs)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if orphan is not None:
            pulumi.set(__self__, "orphan", orphan)
        if path_suffix is not None:
            pulumi.set(__self__, "path_suffix", path_suffix)
        if renewable is not None:
            pulumi.set(__self__, "renewable", renewable)
        if token_bound_cidrs is not None:
            pulumi.set(__self__, "token_bound_cidrs", token_bound_cidrs)
        if token_explicit_max_ttl is not None:
            pulumi.set(__self__, "token_explicit_max_ttl", token_explicit_max_ttl)
        if token_max_ttl is not None:
            pulumi.set(__self__, "token_max_ttl", token_max_ttl)
        if token_no_default_policy is not None:
            pulumi.set(__self__, "token_no_default_policy", token_no_default_policy)
        if token_num_uses is not None:
            pulumi.set(__self__, "token_num_uses", token_num_uses)
        if token_period is not None:
            pulumi.set(__self__, "token_period", token_period)
        if token_policies is not None:
            pulumi.set(__self__, "token_policies", token_policies)
        if token_ttl is not None:
            pulumi.set(__self__, "token_ttl", token_ttl)
        if token_type is not None:
            pulumi.set(__self__, "token_type", token_type)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the role.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role_name", value)

    @_builtins.property
    @pulumi.getter(name="allowedEntityAliases")
    def allowed_entity_aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of allowed entity aliases.
        """
        return pulumi.get(self, "allowed_entity_aliases")

    @allowed_entity_aliases.setter
    def allowed_entity_aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_entity_aliases", value)

    @_builtins.property
    @pulumi.getter(name="allowedPolicies")
    def allowed_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of allowed policies for given role.
        """
        return pulumi.get(self, "allowed_policies")

    @allowed_policies.setter
    def allowed_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_policies", value)

    @_builtins.property
    @pulumi.getter(name="allowedPoliciesGlobs")
    def allowed_policies_globs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of allowed policies with glob match for given role.
        """
        return pulumi.get(self, "allowed_policies_globs")

    @allowed_policies_globs.setter
    def allowed_policies_globs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_policies_globs", value)

    @_builtins.property
    @pulumi.getter(name="disallowedPolicies")
    def disallowed_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of disallowed policies for given role.
        """
        return pulumi.get(self, "disallowed_policies")

    @disallowed_policies.setter
    def disallowed_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "disallowed_policies", value)

    @_builtins.property
    @pulumi.getter(name="disallowedPoliciesGlobs")
    def disallowed_policies_globs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of disallowed policies with glob match for given role.
        """
        return pulumi.get(self, "disallowed_policies_globs")

    @disallowed_policies_globs.setter
    def disallowed_policies_globs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "disallowed_policies_globs", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def orphan(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, tokens created against this policy will be orphan tokens.
        """
        return pulumi.get(self, "orphan")

    @orphan.setter
    def orphan(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "orphan", value)

    @_builtins.property
    @pulumi.getter(name="pathSuffix")
    def path_suffix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Tokens created against this role will have the given suffix as part of their path in addition to the role name.
        """
        return pulumi.get(self, "path_suffix")

    @path_suffix.setter
    def path_suffix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path_suffix", value)

    @_builtins.property
    @pulumi.getter
    def renewable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to disable the ability of the token to be renewed past its initial TTL.
        """
        return pulumi.get(self, "renewable")

    @renewable.setter
    def renewable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "renewable", value)

    @_builtins.property
    @pulumi.getter(name="tokenBoundCidrs")
    def token_bound_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the blocks of IP addresses which are allowed to use the generated token
        """
        return pulumi.get(self, "token_bound_cidrs")

    @token_bound_cidrs.setter
    def token_bound_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "token_bound_cidrs", value)

    @_builtins.property
    @pulumi.getter(name="tokenExplicitMaxTtl")
    def token_explicit_max_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Generated Token's Explicit Maximum TTL in seconds
        """
        return pulumi.get(self, "token_explicit_max_ttl")

    @token_explicit_max_ttl.setter
    def token_explicit_max_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_explicit_max_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenMaxTtl")
    def token_max_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum lifetime of the generated token
        """
        return pulumi.get(self, "token_max_ttl")

    @token_max_ttl.setter
    def token_max_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_max_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenNoDefaultPolicy")
    def token_no_default_policy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the 'default' policy will not automatically be added to generated tokens
        """
        return pulumi.get(self, "token_no_default_policy")

    @token_no_default_policy.setter
    def token_no_default_policy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "token_no_default_policy", value)

    @_builtins.property
    @pulumi.getter(name="tokenNumUses")
    def token_num_uses(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of times a token may be used, a value of zero means unlimited
        """
        return pulumi.get(self, "token_num_uses")

    @token_num_uses.setter
    def token_num_uses(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_num_uses", value)

    @_builtins.property
    @pulumi.getter(name="tokenPeriod")
    def token_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Generated Token's Period
        """
        return pulumi.get(self, "token_period")

    @token_period.setter
    def token_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_period", value)

    @_builtins.property
    @pulumi.getter(name="tokenPolicies")
    def token_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Generated Token's Policies
        """
        return pulumi.get(self, "token_policies")

    @token_policies.setter
    def token_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "token_policies", value)

    @_builtins.property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The initial ttl of the token to generate in seconds
        """
        return pulumi.get(self, "token_ttl")

    @token_ttl.setter
    def token_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of token to generate, service or batch
        """
        return pulumi.get(self, "token_type")

    @token_type.setter
    def token_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_type", value)


@pulumi.input_type
class _AuthBackendRoleState:
    def __init__(__self__, *,
                 allowed_entity_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_policies_globs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 disallowed_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 disallowed_policies_globs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 orphan: Optional[pulumi.Input[_builtins.bool]] = None,
                 path_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 renewable: Optional[pulumi.Input[_builtins.bool]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 token_num_uses: Optional[pulumi.Input[_builtins.int]] = None,
                 token_period: Optional[pulumi.Input[_builtins.int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AuthBackendRole resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_entity_aliases: List of allowed entity aliases.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_policies: List of allowed policies for given role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_policies_globs: Set of allowed policies with glob match for given role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] disallowed_policies: List of disallowed policies for given role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] disallowed_policies_globs: Set of disallowed policies with glob match for given role.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.bool] orphan: If true, tokens created against this policy will be orphan tokens.
        :param pulumi.Input[_builtins.str] path_suffix: Tokens created against this role will have the given suffix as part of their path in addition to the role name.
        :param pulumi.Input[_builtins.bool] renewable: Whether to disable the ability of the token to be renewed past its initial TTL.
        :param pulumi.Input[_builtins.str] role_name: The name of the role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_bound_cidrs: Specifies the blocks of IP addresses which are allowed to use the generated token
        :param pulumi.Input[_builtins.int] token_explicit_max_ttl: Generated Token's Explicit Maximum TTL in seconds
        :param pulumi.Input[_builtins.int] token_max_ttl: The maximum lifetime of the generated token
        :param pulumi.Input[_builtins.bool] token_no_default_policy: If true, the 'default' policy will not automatically be added to generated tokens
        :param pulumi.Input[_builtins.int] token_num_uses: The maximum number of times a token may be used, a value of zero means unlimited
        :param pulumi.Input[_builtins.int] token_period: Generated Token's Period
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_policies: Generated Token's Policies
        :param pulumi.Input[_builtins.int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[_builtins.str] token_type: The type of token to generate, service or batch
        """
        if allowed_entity_aliases is not None:
            pulumi.set(__self__, "allowed_entity_aliases", allowed_entity_aliases)
        if allowed_policies is not None:
            pulumi.set(__self__, "allowed_policies", allowed_policies)
        if allowed_policies_globs is not None:
            pulumi.set(__self__, "allowed_policies_globs", allowed_policies_globs)
        if disallowed_policies is not None:
            pulumi.set(__self__, "disallowed_policies", disallowed_policies)
        if disallowed_policies_globs is not None:
            pulumi.set(__self__, "disallowed_policies_globs", disallowed_policies_globs)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if orphan is not None:
            pulumi.set(__self__, "orphan", orphan)
        if path_suffix is not None:
            pulumi.set(__self__, "path_suffix", path_suffix)
        if renewable is not None:
            pulumi.set(__self__, "renewable", renewable)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if token_bound_cidrs is not None:
            pulumi.set(__self__, "token_bound_cidrs", token_bound_cidrs)
        if token_explicit_max_ttl is not None:
            pulumi.set(__self__, "token_explicit_max_ttl", token_explicit_max_ttl)
        if token_max_ttl is not None:
            pulumi.set(__self__, "token_max_ttl", token_max_ttl)
        if token_no_default_policy is not None:
            pulumi.set(__self__, "token_no_default_policy", token_no_default_policy)
        if token_num_uses is not None:
            pulumi.set(__self__, "token_num_uses", token_num_uses)
        if token_period is not None:
            pulumi.set(__self__, "token_period", token_period)
        if token_policies is not None:
            pulumi.set(__self__, "token_policies", token_policies)
        if token_ttl is not None:
            pulumi.set(__self__, "token_ttl", token_ttl)
        if token_type is not None:
            pulumi.set(__self__, "token_type", token_type)

    @_builtins.property
    @pulumi.getter(name="allowedEntityAliases")
    def allowed_entity_aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of allowed entity aliases.
        """
        return pulumi.get(self, "allowed_entity_aliases")

    @allowed_entity_aliases.setter
    def allowed_entity_aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_entity_aliases", value)

    @_builtins.property
    @pulumi.getter(name="allowedPolicies")
    def allowed_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of allowed policies for given role.
        """
        return pulumi.get(self, "allowed_policies")

    @allowed_policies.setter
    def allowed_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_policies", value)

    @_builtins.property
    @pulumi.getter(name="allowedPoliciesGlobs")
    def allowed_policies_globs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of allowed policies with glob match for given role.
        """
        return pulumi.get(self, "allowed_policies_globs")

    @allowed_policies_globs.setter
    def allowed_policies_globs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_policies_globs", value)

    @_builtins.property
    @pulumi.getter(name="disallowedPolicies")
    def disallowed_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of disallowed policies for given role.
        """
        return pulumi.get(self, "disallowed_policies")

    @disallowed_policies.setter
    def disallowed_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "disallowed_policies", value)

    @_builtins.property
    @pulumi.getter(name="disallowedPoliciesGlobs")
    def disallowed_policies_globs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of disallowed policies with glob match for given role.
        """
        return pulumi.get(self, "disallowed_policies_globs")

    @disallowed_policies_globs.setter
    def disallowed_policies_globs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "disallowed_policies_globs", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def orphan(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, tokens created against this policy will be orphan tokens.
        """
        return pulumi.get(self, "orphan")

    @orphan.setter
    def orphan(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "orphan", value)

    @_builtins.property
    @pulumi.getter(name="pathSuffix")
    def path_suffix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Tokens created against this role will have the given suffix as part of their path in addition to the role name.
        """
        return pulumi.get(self, "path_suffix")

    @path_suffix.setter
    def path_suffix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path_suffix", value)

    @_builtins.property
    @pulumi.getter
    def renewable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to disable the ability of the token to be renewed past its initial TTL.
        """
        return pulumi.get(self, "renewable")

    @renewable.setter
    def renewable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "renewable", value)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the role.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_name", value)

    @_builtins.property
    @pulumi.getter(name="tokenBoundCidrs")
    def token_bound_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the blocks of IP addresses which are allowed to use the generated token
        """
        return pulumi.get(self, "token_bound_cidrs")

    @token_bound_cidrs.setter
    def token_bound_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "token_bound_cidrs", value)

    @_builtins.property
    @pulumi.getter(name="tokenExplicitMaxTtl")
    def token_explicit_max_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Generated Token's Explicit Maximum TTL in seconds
        """
        return pulumi.get(self, "token_explicit_max_ttl")

    @token_explicit_max_ttl.setter
    def token_explicit_max_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_explicit_max_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenMaxTtl")
    def token_max_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum lifetime of the generated token
        """
        return pulumi.get(self, "token_max_ttl")

    @token_max_ttl.setter
    def token_max_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_max_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenNoDefaultPolicy")
    def token_no_default_policy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the 'default' policy will not automatically be added to generated tokens
        """
        return pulumi.get(self, "token_no_default_policy")

    @token_no_default_policy.setter
    def token_no_default_policy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "token_no_default_policy", value)

    @_builtins.property
    @pulumi.getter(name="tokenNumUses")
    def token_num_uses(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of times a token may be used, a value of zero means unlimited
        """
        return pulumi.get(self, "token_num_uses")

    @token_num_uses.setter
    def token_num_uses(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_num_uses", value)

    @_builtins.property
    @pulumi.getter(name="tokenPeriod")
    def token_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Generated Token's Period
        """
        return pulumi.get(self, "token_period")

    @token_period.setter
    def token_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_period", value)

    @_builtins.property
    @pulumi.getter(name="tokenPolicies")
    def token_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Generated Token's Policies
        """
        return pulumi.get(self, "token_policies")

    @token_policies.setter
    def token_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "token_policies", value)

    @_builtins.property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The initial ttl of the token to generate in seconds
        """
        return pulumi.get(self, "token_ttl")

    @token_ttl.setter
    def token_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_ttl", value)

    @_builtins.property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of token to generate, service or batch
        """
        return pulumi.get(self, "token_type")

    @token_type.setter
    def token_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_type", value)


@pulumi.type_token("vault:tokenauth/authBackendRole:AuthBackendRole")
class AuthBackendRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_entity_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_policies_globs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 disallowed_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 disallowed_policies_globs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 orphan: Optional[pulumi.Input[_builtins.bool]] = None,
                 path_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 renewable: Optional[pulumi.Input[_builtins.bool]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 token_num_uses: Optional[pulumi.Input[_builtins.int]] = None,
                 token_period: Optional[pulumi.Input[_builtins.int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages Token auth backend role in a Vault server. See the [Vault
        documentation](https://www.vaultproject.io/docs/auth/token.html) for more
        information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        example = vault.tokenauth.AuthBackendRole("example",
            role_name="my-role",
            allowed_policies=[
                "dev",
                "test",
            ],
            disallowed_policies=["default"],
            allowed_entity_aliases=["test_entity"],
            orphan=True,
            token_period=86400,
            renewable=True,
            token_explicit_max_ttl=115200,
            path_suffix="path-suffix")
        ```

        ## Import

        Token auth backend roles can be imported with `auth/token/roles/` followed by the `role_name`, e.g.

        ```sh
        $ pulumi import vault:tokenauth/authBackendRole:AuthBackendRole example auth/token/roles/my-role
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_entity_aliases: List of allowed entity aliases.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_policies: List of allowed policies for given role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_policies_globs: Set of allowed policies with glob match for given role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] disallowed_policies: List of disallowed policies for given role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] disallowed_policies_globs: Set of disallowed policies with glob match for given role.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.bool] orphan: If true, tokens created against this policy will be orphan tokens.
        :param pulumi.Input[_builtins.str] path_suffix: Tokens created against this role will have the given suffix as part of their path in addition to the role name.
        :param pulumi.Input[_builtins.bool] renewable: Whether to disable the ability of the token to be renewed past its initial TTL.
        :param pulumi.Input[_builtins.str] role_name: The name of the role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_bound_cidrs: Specifies the blocks of IP addresses which are allowed to use the generated token
        :param pulumi.Input[_builtins.int] token_explicit_max_ttl: Generated Token's Explicit Maximum TTL in seconds
        :param pulumi.Input[_builtins.int] token_max_ttl: The maximum lifetime of the generated token
        :param pulumi.Input[_builtins.bool] token_no_default_policy: If true, the 'default' policy will not automatically be added to generated tokens
        :param pulumi.Input[_builtins.int] token_num_uses: The maximum number of times a token may be used, a value of zero means unlimited
        :param pulumi.Input[_builtins.int] token_period: Generated Token's Period
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_policies: Generated Token's Policies
        :param pulumi.Input[_builtins.int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[_builtins.str] token_type: The type of token to generate, service or batch
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthBackendRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages Token auth backend role in a Vault server. See the [Vault
        documentation](https://www.vaultproject.io/docs/auth/token.html) for more
        information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        example = vault.tokenauth.AuthBackendRole("example",
            role_name="my-role",
            allowed_policies=[
                "dev",
                "test",
            ],
            disallowed_policies=["default"],
            allowed_entity_aliases=["test_entity"],
            orphan=True,
            token_period=86400,
            renewable=True,
            token_explicit_max_ttl=115200,
            path_suffix="path-suffix")
        ```

        ## Import

        Token auth backend roles can be imported with `auth/token/roles/` followed by the `role_name`, e.g.

        ```sh
        $ pulumi import vault:tokenauth/authBackendRole:AuthBackendRole example auth/token/roles/my-role
        ```

        :param str resource_name: The name of the resource.
        :param AuthBackendRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthBackendRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_entity_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_policies_globs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 disallowed_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 disallowed_policies_globs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 orphan: Optional[pulumi.Input[_builtins.bool]] = None,
                 path_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 renewable: Optional[pulumi.Input[_builtins.bool]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 token_num_uses: Optional[pulumi.Input[_builtins.int]] = None,
                 token_period: Optional[pulumi.Input[_builtins.int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 token_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthBackendRoleArgs.__new__(AuthBackendRoleArgs)

            __props__.__dict__["allowed_entity_aliases"] = allowed_entity_aliases
            __props__.__dict__["allowed_policies"] = allowed_policies
            __props__.__dict__["allowed_policies_globs"] = allowed_policies_globs
            __props__.__dict__["disallowed_policies"] = disallowed_policies
            __props__.__dict__["disallowed_policies_globs"] = disallowed_policies_globs
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["orphan"] = orphan
            __props__.__dict__["path_suffix"] = path_suffix
            __props__.__dict__["renewable"] = renewable
            if role_name is None and not opts.urn:
                raise TypeError("Missing required property 'role_name'")
            __props__.__dict__["role_name"] = role_name
            __props__.__dict__["token_bound_cidrs"] = token_bound_cidrs
            __props__.__dict__["token_explicit_max_ttl"] = token_explicit_max_ttl
            __props__.__dict__["token_max_ttl"] = token_max_ttl
            __props__.__dict__["token_no_default_policy"] = token_no_default_policy
            __props__.__dict__["token_num_uses"] = token_num_uses
            __props__.__dict__["token_period"] = token_period
            __props__.__dict__["token_policies"] = token_policies
            __props__.__dict__["token_ttl"] = token_ttl
            __props__.__dict__["token_type"] = token_type
        super(AuthBackendRole, __self__).__init__(
            'vault:tokenauth/authBackendRole:AuthBackendRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_entity_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            allowed_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            allowed_policies_globs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            disallowed_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            disallowed_policies_globs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            orphan: Optional[pulumi.Input[_builtins.bool]] = None,
            path_suffix: Optional[pulumi.Input[_builtins.str]] = None,
            renewable: Optional[pulumi.Input[_builtins.bool]] = None,
            role_name: Optional[pulumi.Input[_builtins.str]] = None,
            token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            token_explicit_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            token_max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            token_no_default_policy: Optional[pulumi.Input[_builtins.bool]] = None,
            token_num_uses: Optional[pulumi.Input[_builtins.int]] = None,
            token_period: Optional[pulumi.Input[_builtins.int]] = None,
            token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            token_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'AuthBackendRole':
        """
        Get an existing AuthBackendRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_entity_aliases: List of allowed entity aliases.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_policies: List of allowed policies for given role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_policies_globs: Set of allowed policies with glob match for given role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] disallowed_policies: List of disallowed policies for given role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] disallowed_policies_globs: Set of disallowed policies with glob match for given role.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.bool] orphan: If true, tokens created against this policy will be orphan tokens.
        :param pulumi.Input[_builtins.str] path_suffix: Tokens created against this role will have the given suffix as part of their path in addition to the role name.
        :param pulumi.Input[_builtins.bool] renewable: Whether to disable the ability of the token to be renewed past its initial TTL.
        :param pulumi.Input[_builtins.str] role_name: The name of the role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_bound_cidrs: Specifies the blocks of IP addresses which are allowed to use the generated token
        :param pulumi.Input[_builtins.int] token_explicit_max_ttl: Generated Token's Explicit Maximum TTL in seconds
        :param pulumi.Input[_builtins.int] token_max_ttl: The maximum lifetime of the generated token
        :param pulumi.Input[_builtins.bool] token_no_default_policy: If true, the 'default' policy will not automatically be added to generated tokens
        :param pulumi.Input[_builtins.int] token_num_uses: The maximum number of times a token may be used, a value of zero means unlimited
        :param pulumi.Input[_builtins.int] token_period: Generated Token's Period
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_policies: Generated Token's Policies
        :param pulumi.Input[_builtins.int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[_builtins.str] token_type: The type of token to generate, service or batch
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthBackendRoleState.__new__(_AuthBackendRoleState)

        __props__.__dict__["allowed_entity_aliases"] = allowed_entity_aliases
        __props__.__dict__["allowed_policies"] = allowed_policies
        __props__.__dict__["allowed_policies_globs"] = allowed_policies_globs
        __props__.__dict__["disallowed_policies"] = disallowed_policies
        __props__.__dict__["disallowed_policies_globs"] = disallowed_policies_globs
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["orphan"] = orphan
        __props__.__dict__["path_suffix"] = path_suffix
        __props__.__dict__["renewable"] = renewable
        __props__.__dict__["role_name"] = role_name
        __props__.__dict__["token_bound_cidrs"] = token_bound_cidrs
        __props__.__dict__["token_explicit_max_ttl"] = token_explicit_max_ttl
        __props__.__dict__["token_max_ttl"] = token_max_ttl
        __props__.__dict__["token_no_default_policy"] = token_no_default_policy
        __props__.__dict__["token_num_uses"] = token_num_uses
        __props__.__dict__["token_period"] = token_period
        __props__.__dict__["token_policies"] = token_policies
        __props__.__dict__["token_ttl"] = token_ttl
        __props__.__dict__["token_type"] = token_type
        return AuthBackendRole(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowedEntityAliases")
    def allowed_entity_aliases(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of allowed entity aliases.
        """
        return pulumi.get(self, "allowed_entity_aliases")

    @_builtins.property
    @pulumi.getter(name="allowedPolicies")
    def allowed_policies(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of allowed policies for given role.
        """
        return pulumi.get(self, "allowed_policies")

    @_builtins.property
    @pulumi.getter(name="allowedPoliciesGlobs")
    def allowed_policies_globs(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Set of allowed policies with glob match for given role.
        """
        return pulumi.get(self, "allowed_policies_globs")

    @_builtins.property
    @pulumi.getter(name="disallowedPolicies")
    def disallowed_policies(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of disallowed policies for given role.
        """
        return pulumi.get(self, "disallowed_policies")

    @_builtins.property
    @pulumi.getter(name="disallowedPoliciesGlobs")
    def disallowed_policies_globs(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Set of disallowed policies with glob match for given role.
        """
        return pulumi.get(self, "disallowed_policies_globs")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def orphan(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, tokens created against this policy will be orphan tokens.
        """
        return pulumi.get(self, "orphan")

    @_builtins.property
    @pulumi.getter(name="pathSuffix")
    def path_suffix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Tokens created against this role will have the given suffix as part of their path in addition to the role name.
        """
        return pulumi.get(self, "path_suffix")

    @_builtins.property
    @pulumi.getter
    def renewable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to disable the ability of the token to be renewed past its initial TTL.
        """
        return pulumi.get(self, "renewable")

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the role.
        """
        return pulumi.get(self, "role_name")

    @_builtins.property
    @pulumi.getter(name="tokenBoundCidrs")
    def token_bound_cidrs(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the blocks of IP addresses which are allowed to use the generated token
        """
        return pulumi.get(self, "token_bound_cidrs")

    @_builtins.property
    @pulumi.getter(name="tokenExplicitMaxTtl")
    def token_explicit_max_ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Generated Token's Explicit Maximum TTL in seconds
        """
        return pulumi.get(self, "token_explicit_max_ttl")

    @_builtins.property
    @pulumi.getter(name="tokenMaxTtl")
    def token_max_ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum lifetime of the generated token
        """
        return pulumi.get(self, "token_max_ttl")

    @_builtins.property
    @pulumi.getter(name="tokenNoDefaultPolicy")
    def token_no_default_policy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, the 'default' policy will not automatically be added to generated tokens
        """
        return pulumi.get(self, "token_no_default_policy")

    @_builtins.property
    @pulumi.getter(name="tokenNumUses")
    def token_num_uses(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum number of times a token may be used, a value of zero means unlimited
        """
        return pulumi.get(self, "token_num_uses")

    @_builtins.property
    @pulumi.getter(name="tokenPeriod")
    def token_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Generated Token's Period
        """
        return pulumi.get(self, "token_period")

    @_builtins.property
    @pulumi.getter(name="tokenPolicies")
    def token_policies(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Generated Token's Policies
        """
        return pulumi.get(self, "token_policies")

    @_builtins.property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The initial ttl of the token to generate in seconds
        """
        return pulumi.get(self, "token_ttl")

    @_builtins.property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of token to generate, service or batch
        """
        return pulumi.get(self, "token_type")

