# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.custom_agent_response import CustomAgentResponse
from .raw_client import AsyncRawAgentsClient, RawAgentsClient

if typing.TYPE_CHECKING:
    from .drive.client import AsyncDriveClient, DriveClient
    from .general.client import AsyncGeneralClient, GeneralClient
    from .research.client import AsyncResearchClient, ResearchClient
    from .sql.client import AsyncSqlClient, SqlClient
# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AgentsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAgentsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._drive: typing.Optional[DriveClient] = None
        self._general: typing.Optional[GeneralClient] = None
        self._research: typing.Optional[ResearchClient] = None
        self._sql: typing.Optional[SqlClient] = None

    @property
    def with_raw_response(self) -> RawAgentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAgentsClient
        """
        return self._raw_client

    def invoke_by_id(
        self,
        agent_id: str,
        *,
        config: typing.Dict[str, typing.Optional[typing.Any]],
        messages: typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CustomAgentResponse:
        """
        Coming soon!

        Invoke a custom agent created in [spaces](https://resources.athenaintel.com/docs/agents/create-your-agent).

        Custom agents can be created and configured in spaces to perform specialized tasks.
        Refer to the specific agent's documentation for details on configuration options
        and expected responses.

        Parameters
        ----------
        agent_id : str
            The ID of the custom agent to invoke. Create custom agents in [spaces](https://resources.athenaintel.com/docs/agents/create-your-agent).

        config : typing.Dict[str, typing.Optional[typing.Any]]
            Configuration for the custom agent. See the agent's documentation for specific configuration options.

        messages : typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]]
            The messages to send to the custom agent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CustomAgentResponse
            Successful Response

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.agents.invoke_by_id(
            agent_id="agent_id",
            config={"key": "value"},
            messages=[{"key": "value"}],
        )
        """
        _response = self._raw_client.invoke_by_id(
            agent_id, config=config, messages=messages, request_options=request_options
        )
        return _response.data

    @property
    def drive(self):
        if self._drive is None:
            from .drive.client import DriveClient  # noqa: E402

            self._drive = DriveClient(client_wrapper=self._client_wrapper)
        return self._drive

    @property
    def general(self):
        if self._general is None:
            from .general.client import GeneralClient  # noqa: E402

            self._general = GeneralClient(client_wrapper=self._client_wrapper)
        return self._general

    @property
    def research(self):
        if self._research is None:
            from .research.client import ResearchClient  # noqa: E402

            self._research = ResearchClient(client_wrapper=self._client_wrapper)
        return self._research

    @property
    def sql(self):
        if self._sql is None:
            from .sql.client import SqlClient  # noqa: E402

            self._sql = SqlClient(client_wrapper=self._client_wrapper)
        return self._sql


class AsyncAgentsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAgentsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._drive: typing.Optional[AsyncDriveClient] = None
        self._general: typing.Optional[AsyncGeneralClient] = None
        self._research: typing.Optional[AsyncResearchClient] = None
        self._sql: typing.Optional[AsyncSqlClient] = None

    @property
    def with_raw_response(self) -> AsyncRawAgentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAgentsClient
        """
        return self._raw_client

    async def invoke_by_id(
        self,
        agent_id: str,
        *,
        config: typing.Dict[str, typing.Optional[typing.Any]],
        messages: typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CustomAgentResponse:
        """
        Coming soon!

        Invoke a custom agent created in [spaces](https://resources.athenaintel.com/docs/agents/create-your-agent).

        Custom agents can be created and configured in spaces to perform specialized tasks.
        Refer to the specific agent's documentation for details on configuration options
        and expected responses.

        Parameters
        ----------
        agent_id : str
            The ID of the custom agent to invoke. Create custom agents in [spaces](https://resources.athenaintel.com/docs/agents/create-your-agent).

        config : typing.Dict[str, typing.Optional[typing.Any]]
            Configuration for the custom agent. See the agent's documentation for specific configuration options.

        messages : typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]]
            The messages to send to the custom agent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CustomAgentResponse
            Successful Response

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.agents.invoke_by_id(
                agent_id="agent_id",
                config={"key": "value"},
                messages=[{"key": "value"}],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.invoke_by_id(
            agent_id, config=config, messages=messages, request_options=request_options
        )
        return _response.data

    @property
    def drive(self):
        if self._drive is None:
            from .drive.client import AsyncDriveClient  # noqa: E402

            self._drive = AsyncDriveClient(client_wrapper=self._client_wrapper)
        return self._drive

    @property
    def general(self):
        if self._general is None:
            from .general.client import AsyncGeneralClient  # noqa: E402

            self._general = AsyncGeneralClient(client_wrapper=self._client_wrapper)
        return self._general

    @property
    def research(self):
        if self._research is None:
            from .research.client import AsyncResearchClient  # noqa: E402

            self._research = AsyncResearchClient(client_wrapper=self._client_wrapper)
        return self._research

    @property
    def sql(self):
        if self._sql is None:
            from .sql.client import AsyncSqlClient  # noqa: E402

            self._sql = AsyncSqlClient(client_wrapper=self._client_wrapper)
        return self._sql
