# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.custom_agent_response import CustomAgentResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawAgentsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def invoke_by_id(
        self,
        agent_id: str,
        *,
        config: typing.Dict[str, typing.Optional[typing.Any]],
        messages: typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CustomAgentResponse]:
        """
        Coming soon!

        Invoke a custom agent created in [spaces](https://resources.athenaintel.com/docs/agents/create-your-agent).

        Custom agents can be created and configured in spaces to perform specialized tasks.
        Refer to the specific agent's documentation for details on configuration options
        and expected responses.

        Parameters
        ----------
        agent_id : str
            The ID of the custom agent to invoke. Create custom agents in [spaces](https://resources.athenaintel.com/docs/agents/create-your-agent).

        config : typing.Dict[str, typing.Optional[typing.Any]]
            Configuration for the custom agent. See the agent's documentation for specific configuration options.

        messages : typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]]
            The messages to send to the custom agent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CustomAgentResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/v0/agents/{jsonable_encoder(agent_id)}/invoke",
            method="POST",
            json={
                "config": config,
                "messages": messages,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CustomAgentResponse,
                    parse_obj_as(
                        type_=CustomAgentResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawAgentsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def invoke_by_id(
        self,
        agent_id: str,
        *,
        config: typing.Dict[str, typing.Optional[typing.Any]],
        messages: typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CustomAgentResponse]:
        """
        Coming soon!

        Invoke a custom agent created in [spaces](https://resources.athenaintel.com/docs/agents/create-your-agent).

        Custom agents can be created and configured in spaces to perform specialized tasks.
        Refer to the specific agent's documentation for details on configuration options
        and expected responses.

        Parameters
        ----------
        agent_id : str
            The ID of the custom agent to invoke. Create custom agents in [spaces](https://resources.athenaintel.com/docs/agents/create-your-agent).

        config : typing.Dict[str, typing.Optional[typing.Any]]
            Configuration for the custom agent. See the agent's documentation for specific configuration options.

        messages : typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]]
            The messages to send to the custom agent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CustomAgentResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/v0/agents/{jsonable_encoder(agent_id)}/invoke",
            method="POST",
            json={
                "config": config,
                "messages": messages,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CustomAgentResponse,
                    parse_obj_as(
                        type_=CustomAgentResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
