# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.create_project_response_out import CreateProjectResponseOut
from ..types.paginated_assets_out import PaginatedAssetsOut
from ..types.public_asset_out import PublicAssetOut
from .raw_client import AsyncRawAssetsClient, RawAssetsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AssetsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAssetsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAssetsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAssetsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        filters: typing.Optional[str] = None,
        sort: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedAssetsOut:
        """
        Retrieve a paginated list of assets with optional filtering and sorting. Assets include documents, presentations, spreadsheets, images, videos, and other file types managed by Athena Intelligence.

        Parameters
        ----------
        limit : typing.Optional[int]
            Maximum number of assets to return per page (1-500)

        offset : typing.Optional[int]
            Number of assets to skip for pagination

        filters : typing.Optional[str]
            JSON string of filter criteria. Supports: created_by_id, created_by_email, tags, created_after/before, updated_after/before, title_substring, is_archived, is_hidden, athena_metadata, media_type, athena_converted_type, athena_original_type, summary_ready, summary_status

        sort : typing.Optional[str]
            JSON string of sort criteria: [{"field": "updated_at", "direction": "desc"}]. Supported fields: created_by_id, created_by_email, created_at, updated_at, is_archived, is_hidden, summary_ready, summary_status

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedAssetsOut
            Successfully retrieved paginated list of assets

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.assets.list(
            limit=1,
            offset=1,
            filters="filters",
            sort="sort",
        )
        """
        _response = self._raw_client.list(
            limit=limit, offset=offset, filters=filters, sort=sort, request_options=request_options
        )
        return _response.data

    def create_project(
        self,
        *,
        title: str,
        custom_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        description: typing.Optional[str] = OMIT,
        parent_folder_id: typing.Optional[str] = OMIT,
        project_type: typing.Optional[str] = OMIT,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateProjectResponseOut:
        """
        Create a new project with custom metadata. Projects can be typed (e.g., 'candidate', 'user', 'company') and include flexible custom metadata for storing additional information.

        Parameters
        ----------
        title : str
            The project title

        custom_metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            A flexible dictionary for storing custom metadata

        description : typing.Optional[str]
            Optional project description

        parent_folder_id : typing.Optional[str]
            Optional parent folder ID

        project_type : typing.Optional[str]
            User-defined project type (e.g., 'candidate', 'user', 'company')

        tags : typing.Optional[typing.Sequence[str]]
            Optional list of tags for categorizing the project

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateProjectResponseOut
            Project created successfully

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.assets.create_project(
            custom_metadata={
                "email": "john.doe@example.com",
                "phone": "+1-555-0123",
                "source": "linkedin",
                "status": "active",
            },
            description="Candidate profile for senior software engineer position",
            parent_folder_id="asset_folder_123",
            project_type="candidate",
            tags=["engineering", "senior", "active"],
            title="John Doe - Software Engineer",
        )
        """
        _response = self._raw_client.create_project(
            title=title,
            custom_metadata=custom_metadata,
            description=description,
            parent_folder_id=parent_folder_id,
            project_type=project_type,
            tags=tags,
            request_options=request_options,
        )
        return _response.data

    def get(self, asset_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> PublicAssetOut:
        """
        Retrieve a single asset by its ID. Returns comprehensive metadata including creation info, tags, timestamps, media type, and AI-generated summary.

        Parameters
        ----------
        asset_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PublicAssetOut
            Successfully retrieved asset

        Examples
        --------
        from athena import Athena

        client = Athena(
            api_key="YOUR_API_KEY",
        )
        client.assets.get(
            asset_id="asset_id",
        )
        """
        _response = self._raw_client.get(asset_id, request_options=request_options)
        return _response.data


class AsyncAssetsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAssetsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAssetsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAssetsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        filters: typing.Optional[str] = None,
        sort: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedAssetsOut:
        """
        Retrieve a paginated list of assets with optional filtering and sorting. Assets include documents, presentations, spreadsheets, images, videos, and other file types managed by Athena Intelligence.

        Parameters
        ----------
        limit : typing.Optional[int]
            Maximum number of assets to return per page (1-500)

        offset : typing.Optional[int]
            Number of assets to skip for pagination

        filters : typing.Optional[str]
            JSON string of filter criteria. Supports: created_by_id, created_by_email, tags, created_after/before, updated_after/before, title_substring, is_archived, is_hidden, athena_metadata, media_type, athena_converted_type, athena_original_type, summary_ready, summary_status

        sort : typing.Optional[str]
            JSON string of sort criteria: [{"field": "updated_at", "direction": "desc"}]. Supported fields: created_by_id, created_by_email, created_at, updated_at, is_archived, is_hidden, summary_ready, summary_status

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedAssetsOut
            Successfully retrieved paginated list of assets

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.assets.list(
                limit=1,
                offset=1,
                filters="filters",
                sort="sort",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            limit=limit, offset=offset, filters=filters, sort=sort, request_options=request_options
        )
        return _response.data

    async def create_project(
        self,
        *,
        title: str,
        custom_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        description: typing.Optional[str] = OMIT,
        parent_folder_id: typing.Optional[str] = OMIT,
        project_type: typing.Optional[str] = OMIT,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateProjectResponseOut:
        """
        Create a new project with custom metadata. Projects can be typed (e.g., 'candidate', 'user', 'company') and include flexible custom metadata for storing additional information.

        Parameters
        ----------
        title : str
            The project title

        custom_metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            A flexible dictionary for storing custom metadata

        description : typing.Optional[str]
            Optional project description

        parent_folder_id : typing.Optional[str]
            Optional parent folder ID

        project_type : typing.Optional[str]
            User-defined project type (e.g., 'candidate', 'user', 'company')

        tags : typing.Optional[typing.Sequence[str]]
            Optional list of tags for categorizing the project

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateProjectResponseOut
            Project created successfully

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.assets.create_project(
                custom_metadata={
                    "email": "john.doe@example.com",
                    "phone": "+1-555-0123",
                    "source": "linkedin",
                    "status": "active",
                },
                description="Candidate profile for senior software engineer position",
                parent_folder_id="asset_folder_123",
                project_type="candidate",
                tags=["engineering", "senior", "active"],
                title="John Doe - Software Engineer",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_project(
            title=title,
            custom_metadata=custom_metadata,
            description=description,
            parent_folder_id=parent_folder_id,
            project_type=project_type,
            tags=tags,
            request_options=request_options,
        )
        return _response.data

    async def get(self, asset_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> PublicAssetOut:
        """
        Retrieve a single asset by its ID. Returns comprehensive metadata including creation info, tags, timestamps, media type, and AI-generated summary.

        Parameters
        ----------
        asset_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PublicAssetOut
            Successfully retrieved asset

        Examples
        --------
        import asyncio

        from athena import AsyncAthena

        client = AsyncAthena(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.assets.get(
                asset_id="asset_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(asset_id, request_options=request_options)
        return _response.data
