# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .content import Content


class ConversationMessage(UniversalBaseModel):
    """
    Model representing a single conversation message.
    """

    additional_kwargs: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Additional message metadata
    """

    content: Content = pydantic.Field()
    """
    Message content as text or structured content blocks
    """

    id: str = pydantic.Field()
    """
    Unique identifier for the message
    """

    role: str = pydantic.Field()
    """
    Role of the message sender (user, assistant, system)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
